// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief meson spectra at 10.58 GeV
  class BELLE_2025_I2849895 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BELLE_2025_I2849895);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      declare(UnstableParticles(),"UFS");
      for(unsigned int ix=0;ix<6;++ix)
        book(_h[ix],1,1,1+ix);
      for(unsigned int ix=0;ix<9;++ix)
        book(_h[6+ix],2,1,1+ix);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      // apply projection
      const UnstableParticles & ufs = apply<UnstableParticles>(event, "UFS");
      // fill single particle histos
      for (const Particle& p : ufs.particles()) {
        // remove particles from radiation/mixing
        bool self=false;
        for(const Particle & child : p.children())
          self |= p.abspid()==child.pid();
        if(self) continue;
        const double xp = 2.*p.momentum().p3().mod()/sqrtS();
        switch (p.abspid()) {
        case 411:
          _h[0]->fill(xp);
          break;
        case 421:
          _h[1]->fill(xp);
          break;
        case 431:
          _h[2]->fill(xp);
          break;
        case 413:
          _h[3]->fill(xp);
          break;
        case 423:
          _h[4]->fill(xp);
          break;
        case 433:
          _h[5]->fill(xp);
          break;
        case 213:
          if(p.pid()>0) _h[6]->fill(xp);
          break;
        case 113:
          _h[7]->fill(xp);
          break;
        case 223:
          _h[8]->fill(xp);
          break;
        case 323:
          _h[9]->fill(xp);
          break;
        case 313:
          _h[10]->fill(xp);
          break;
        case 333:
          _h[11]->fill(xp);
          break;
        case 221:
          _h[12]->fill(xp);
          break;
        case PID::K0S:
          _h[13]->fill(xp);
          break;
        case 9010221:
          _h[14]->fill(xp);
          break;
        default:
          break;
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_h,crossSection()/picobarn/sumOfWeights());
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[15];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BELLE_2025_I2849895);

}
