#ifndef STARTFBG_H
#define STARTFBG_H
/*
    Falling Block Game
    Copyright (C) 1999-2002 Jared Krinke <http://derajdezine.vze.com/>


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    This application is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this distribution; if not, write to:
    Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA02111-1307  USA

    Jared Krinke

    Deraj DeZine
    http://derajdezine.vze.com/
*/

#include <wx/wx.h>

#ifdef WIN32
#define FBG_EXTENSION ".exe"
#else
#define FBG_EXTENSION
#endif

class fbglaunch;
class fbglaunchFrame;

class fbglaunchFrame : public wxFrame {
public:
	fbglaunchFrame(const char* argv0, const fbglaunch* newParent, const wxString& title, int w, int h);
	virtual void OnQuit(wxCommandEvent WXUNUSED(event));
	void clickPlay(wxCommandEvent& evt);
	void checkBType(wxCommandEvent& evt);
#ifdef ENABLE_SOUND
	void checkMusic(wxCommandEvent& evt);
#endif
	enum {ID_PLAY=1,ID_RES,ID_BPP,ID_FS,ID_LEVEL,ID_BTYPE_CHECK,ID_BTYPE,ID_LIGHT,ID_THEME,
#ifdef ENABLE_SOUND
		ID_MUSIC,ID_MUSIC_CHECK
#endif
	};
	DECLARE_EVENT_TABLE()
protected:
	const fbglaunch* parent;
	wxChoice* resMenu;
	wxChoice* bppMenu;
	wxCheckBox* fsCheck;
	wxChoice* levelMenu;
	wxButton* playButton;
	wxCheckBox* btypeCheck;
	wxChoice* btypeMenu;
	wxCheckBox* lightCheck;
	wxChoice* themeMenu;
#ifdef ENABLE_SOUND
	wxCheckBox* musicCheck;
	wxChoice* musicMenu;
#endif
};

class fbglaunch : public wxApp {
public:
	virtual bool OnInit();
	virtual int OnExit();
	void launchFBG(const wxString& fbgBin, bool fs, bool light, const wxString& theme,
#ifdef ENABLE_SOUND
		const wxString& music,
#endif
		const wxString& bpp, const wxString& res, const wxString& level, const wxString& btype) const;
protected:
	fbglaunchFrame* frame;
};

#endif
