/*
 * bindings.c
 *
 * Functions for dealing with key bindings.
 *
 * This file is part of the ckpass project.
 *
 * Copyright (C) 2009  Heath N. Caldwell <hncaldwell@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>

#include "bindings.h"

struct binding *new_binding_set()
{
	struct binding *set;

	set = malloc(sizeof(struct binding));
	set->key = 0;

	return set;
}

void add_binding(struct binding **set, int key, const char *command)
{
	struct binding *b;
	int i;
	
	/* If a binding for this key already exists, replace it. */
	for(b = *set; b->key; b++) {
		if(b->key == key) {
			b->command = (char *)command;
			return;
		}
	}
	
	/* Keep size of set in i.  Include one for the terminating binding. */
	for(b = *set, i = 1; b->key; b++, i++);

	*set = realloc(*set, (i + 1) * sizeof(struct binding));
	(b+1)->key = 0; /* Make last one be the terminating binding. */

	/* Keep bindings sorted by command. */
	for(b--; b >= *set && strcmp(command, b->command) < 0; b--) {
		(b+1)->key = b->key;
		(b+1)->command = b->command;
	}

	(b+1)->key = key;
	(b+1)->command = (char *)command;
}

