/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.IoActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.JavaBeanDumper;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

class SwiftDepsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwiftDepsHandler.class);
    static final List RESET_TIMESTAMP = Arrays.asList(0L, 0L);

    SwiftDepsHandler() {
    }

    SwiftDeps parse(File moduleSwiftDeps) throws FileNotFoundException {
        return (SwiftDeps)IoActions.withResource((Closeable)new FileInputStream(moduleSwiftDeps), (Transformer)new Transformer<SwiftDeps, FileInputStream>(){

            public SwiftDeps transform(FileInputStream fileInputStream) {
                Yaml yaml = new Yaml(new Loader((BaseConstructor)new Constructor(SwiftDeps.class)));
                return (SwiftDeps)yaml.load((InputStream)fileInputStream);
            }
        });
    }

    private void adjustTimestamps(SwiftDeps swiftDeps, Collection<File> changedSources) {
        for (File changedSource : changedSources) {
            if (!swiftDeps.inputs.containsKey(changedSource.getAbsolutePath())) continue;
            swiftDeps.inputs.put(changedSource.getAbsolutePath(), RESET_TIMESTAMP);
        }
    }

    private void write(File moduleSwiftDeps, final SwiftDeps swiftDeps) {
        IoActions.writeTextFile((File)moduleSwiftDeps, (Action)new Action<BufferedWriter>(){

            public void execute(BufferedWriter bufferedWriter) {
                JavaBeanDumper yaml = new JavaBeanDumper(false);
                yaml.dump((Object)swiftDeps, (Writer)bufferedWriter);
            }
        });
    }

    boolean adjustTimestampsFor(File moduleSwiftDeps, Collection<File> changedSources) {
        if (moduleSwiftDeps.exists() && !changedSources.isEmpty()) {
            try {
                SwiftDeps swiftDeps = this.parse(moduleSwiftDeps);
                this.adjustTimestamps(swiftDeps, changedSources);
                this.write(moduleSwiftDeps, swiftDeps);
            }
            catch (Exception e) {
                LOGGER.debug("could not update module.swiftdeps", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static class SwiftDeps {
        private String version;
        private String options;
        private List<Long> build_time;
        private Map<String, List> inputs;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getOptions() {
            return this.options;
        }

        public void setOptions(String options) {
            this.options = options;
        }

        public List<Long> getBuild_time() {
            return this.build_time;
        }

        public void setBuild_time(List<Long> build_time) {
            this.build_time = build_time;
        }

        public Map<String, List> getInputs() {
            return this.inputs;
        }

        public void setInputs(Map<String, List> inputs) {
            this.inputs = inputs;
        }
    }
}

