/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.api.internal.changedetection.state.mirror.RelativePathStringTracker;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathFingerprint;

public class RelativePathFingerprintingStrategy
implements FingerprintingStrategy {
    private final StringInterner stringInterner;

    public RelativePathFingerprintingStrategy(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    @Override
    public Map<String, NormalizedFileSnapshot> collectSnapshots(Iterable<FileSystemSnapshot> roots) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashSet processedEntries = new HashSet();
        for (FileSystemSnapshot root : roots) {
            root.accept(new PhysicalSnapshotVisitor(){
                private final RelativePathStringTracker relativePathStringTracker = new RelativePathStringTracker();

                @Override
                public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                    boolean isRoot = this.relativePathStringTracker.isRoot();
                    this.relativePathStringTracker.enter(directorySnapshot);
                    String absolutePath = directorySnapshot.getAbsolutePath();
                    if (processedEntries.add(absolutePath)) {
                        NormalizedFileSnapshot snapshot = isRoot ? IgnoredPathFingerprint.DIRECTORY : new DefaultNormalizedFileSnapshot(RelativePathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), directorySnapshot);
                        builder.put((Object)absolutePath, (Object)snapshot);
                    }
                    return true;
                }

                @Override
                public void visit(PhysicalSnapshot fileSnapshot) {
                    String absolutePath = fileSnapshot.getAbsolutePath();
                    if (processedEntries.add(absolutePath)) {
                        NormalizedFileSnapshot normalizedFileSnapshot = this.relativePathStringTracker.isRoot() ? new DefaultNormalizedFileSnapshot(fileSnapshot.getName(), fileSnapshot) : this.createNormalizedFileSnapshot(fileSnapshot);
                        builder.put((Object)absolutePath, (Object)normalizedFileSnapshot);
                    }
                }

                private NormalizedFileSnapshot createNormalizedFileSnapshot(PhysicalSnapshot fileSnapshot) {
                    this.relativePathStringTracker.enter(fileSnapshot);
                    DefaultNormalizedFileSnapshot normalizedFileSnapshot = new DefaultNormalizedFileSnapshot(RelativePathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), fileSnapshot);
                    this.relativePathStringTracker.leave();
                    return normalizedFileSnapshot;
                }

                @Override
                public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                    this.relativePathStringTracker.leave();
                }
            });
        }
        return builder.build();
    }

    @Override
    public FingerprintCompareStrategy getCompareStrategy() {
        return FingerprintCompareStrategy.NORMALIZED;
    }

    @Override
    public FingerprintingStrategy.Identifier getIdentifier() {
        return FingerprintingStrategy.Identifier.RELATIVE_PATH;
    }
}

