/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.util.DeprecationLogger;

@NonNullApi
public class DefaultTaskDestroyables
implements TaskDestroyablesInternal {
    private final TaskMutator taskMutator;
    private final List<Object> registeredPaths = Lists.newArrayList();

    public DefaultTaskDestroyables(TaskMutator taskMutator) {
        this.taskMutator = taskMutator;
    }

    public void files(final Object ... paths) {
        DeprecationLogger.nagUserOfReplacedMethod((String)"TaskDestroys.files", (String)"TaskDestroys.register");
        this.taskMutator.mutate("TaskDestroys.files(Object...)", new Runnable(){

            @Override
            public void run() {
                Collections.addAll(DefaultTaskDestroyables.this.registeredPaths, paths);
            }
        });
    }

    public void file(final Object path) {
        DeprecationLogger.nagUserOfReplacedMethod((String)"TaskDestroys.file", (String)"TaskDestroys.register");
        this.taskMutator.mutate("TaskDestroys.file(Object...)", new Runnable(){

            @Override
            public void run() {
                DefaultTaskDestroyables.this.registeredPaths.add(path);
            }
        });
    }

    public void register(final Object ... paths) {
        this.taskMutator.mutate("TaskDestroys.register(Object...)", new Runnable(){

            @Override
            public void run() {
                Collections.addAll(DefaultTaskDestroyables.this.registeredPaths, paths);
            }
        });
    }

    @Override
    public Collection<Object> getRegisteredPaths() {
        return this.registeredPaths;
    }
}

