/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.diff;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTreeChangeBuilder;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public class DiffTree<OT, NT> {
    private final FlyweightCapableTreeStructure<OT> myOldTree;
    private final FlyweightCapableTreeStructure<NT> myNewTree;
    private final ShallowNodeComparator<OT, NT> myComparator;
    private final List<Ref<OT[]>> myOldChildrenLists;
    private final List<Ref<NT[]>> myNewChildrenLists;
    private final CharSequence myOldText;
    private final CharSequence myNewText;
    private final int myOldTreeStart;
    private final int myNewTreeStart;
    private static final DiffTreeChangeBuilder EMPTY_CONSUMER = new DiffTreeChangeBuilder(){

        public void nodeReplaced(@NotNull Object oldChild, @NotNull Object newChild) {
            if (oldChild == null) {
                1.$$$reportNull$$$0(0);
            }
            if (newChild == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        public void nodeDeleted(@NotNull Object oldParent, @NotNull Object oldNode) {
            if (oldParent == null) {
                1.$$$reportNull$$$0(2);
            }
            if (oldNode == null) {
                1.$$$reportNull$$$0(3);
            }
        }

        public void nodeInserted(@NotNull Object oldParent, @NotNull Object newNode, int pos) {
            if (oldParent == null) {
                1.$$$reportNull$$$0(4);
            }
            if (newNode == null) {
                1.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldChild";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChild";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/diff/DiffTree$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeReplaced";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeDeleted";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeInserted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private DiffTree(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull CharSequence oldText) {
        if (oldTree == null) {
            DiffTree.$$$reportNull$$$0(0);
        }
        if (newTree == null) {
            DiffTree.$$$reportNull$$$0(1);
        }
        if (comparator == null) {
            DiffTree.$$$reportNull$$$0(2);
        }
        if (oldText == null) {
            DiffTree.$$$reportNull$$$0(3);
        }
        this.myOldChildrenLists = new ArrayList<Ref<OT[]>>();
        this.myNewChildrenLists = new ArrayList<Ref<NT[]>>();
        this.myOldTree = oldTree;
        this.myNewTree = newTree;
        this.myComparator = comparator;
        this.myOldText = oldText;
        this.myOldTreeStart = oldTree.getStartOffset(oldTree.getRoot());
        this.myNewText = newTree.toString(newTree.getRoot());
        this.myNewTreeStart = newTree.getStartOffset(newTree.getRoot());
    }

    public static <OT, NT> void diff(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull DiffTreeChangeBuilder<OT, NT> consumer, @NotNull CharSequence oldText) {
        if (oldTree == null) {
            DiffTree.$$$reportNull$$$0(4);
        }
        if (newTree == null) {
            DiffTree.$$$reportNull$$$0(5);
        }
        if (comparator == null) {
            DiffTree.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            DiffTree.$$$reportNull$$$0(7);
        }
        if (oldText == null) {
            DiffTree.$$$reportNull$$$0(8);
        }
        DiffTree<OT, NT> tree = new DiffTree<OT, NT>(oldTree, newTree, comparator, oldText);
        super.build(oldTree.getRoot(), newTree.getRoot(), 0, consumer);
    }

    @NotNull
    private static <OT, NT> DiffTreeChangeBuilder<OT, NT> emptyConsumer() {
        DiffTreeChangeBuilder diffTreeChangeBuilder = EMPTY_CONSUMER;
        if (diffTreeChangeBuilder == null) {
            DiffTree.$$$reportNull$$$0(9);
        }
        return diffTreeChangeBuilder;
    }

    @NotNull
    private CompareResult build(@NotNull OT oldNode, @NotNull NT newNode, int level, @NotNull DiffTreeChangeBuilder<OT, NT> consumer) {
        CompareResult result2;
        if (oldNode == null) {
            DiffTree.$$$reportNull$$$0(10);
        }
        if (newNode == null) {
            DiffTree.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            DiffTree.$$$reportNull$$$0(12);
        }
        if (level == this.myNewChildrenLists.size()) {
            this.myNewChildrenLists.add(new Ref());
            this.myOldChildrenLists.add(new Ref());
        }
        Ref<T[]> oldChildrenR = this.myOldChildrenLists.get(level);
        int oldChildrenSize = this.myOldTree.getChildren(oldNode, oldChildrenR);
        T[] oldChildren = oldChildrenR.get();
        Ref<T[]> newChildrenR = this.myNewChildrenLists.get(level);
        int newChildrenSize = this.myNewTree.getChildren(newNode, newChildrenR);
        T[] newChildren = newChildrenR.get();
        if (Math.abs(oldChildrenSize - newChildrenSize) > 20) {
            consumer.nodeReplaced(oldNode, newNode);
            result2 = CompareResult.NOT_EQUAL;
        } else if (oldChildrenSize == 0 && newChildrenSize == 0) {
            if (!this.myComparator.hashCodesEqual(oldNode, newNode) || !this.myComparator.typesEqual(oldNode, newNode)) {
                consumer.nodeReplaced(oldNode, newNode);
                result2 = CompareResult.NOT_EQUAL;
            } else {
                result2 = CompareResult.EQUAL;
            }
        } else {
            ShallowNodeComparator<OT, NT> comparator = this.myComparator;
            int minSize = Math.min(oldChildrenSize, newChildrenSize);
            int suffixLength = this.match(oldChildren, oldChildrenSize - 1, newChildren, newChildrenSize - 1, level, -1, minSize);
            int maxPrefixLength = minSize - suffixLength - (oldChildrenSize == newChildrenSize && suffixLength < minSize ? 1 : 0);
            int prefixLength = this.match(oldChildren, 0, newChildren, 0, level, 1, maxPrefixLength);
            if (oldChildrenSize == newChildrenSize && suffixLength + prefixLength == oldChildrenSize) {
                result2 = CompareResult.EQUAL;
            } else if (consumer == DiffTree.emptyConsumer()) {
                result2 = CompareResult.NOT_EQUAL;
            } else {
                int oldIndex = prefixLength;
                int newIndex = prefixLength;
                while (oldIndex < oldChildrenSize - suffixLength || newIndex < newChildrenSize - suffixLength) {
                    CompareResult c;
                    Object oldChild1 = oldIndex < oldChildrenSize - suffixLength ? (Object)oldChildren[oldIndex] : null;
                    Object oldChild2 = oldIndex < oldChildrenSize - suffixLength - 1 ? (Object)oldChildren[oldIndex + 1] : null;
                    OT oldChild3 = oldIndex < oldChildrenSize - suffixLength - 2 ? (OT)oldChildren[oldIndex + 2] : null;
                    Object newChild1 = newIndex < newChildrenSize - suffixLength ? (Object)newChildren[newIndex] : null;
                    Object newChild2 = newIndex < newChildrenSize - suffixLength - 1 ? (Object)newChildren[newIndex + 1] : null;
                    NT newChild3 = newIndex < newChildrenSize - suffixLength - 2 ? (NT)newChildren[newIndex + 2] : null;
                    CompareResult c11 = this.looksEqual(comparator, oldChild1, newChild1);
                    if (c11 == CompareResult.EQUAL || c11 == CompareResult.DRILL_DOWN_NEEDED) {
                        if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
                            this.build(oldChild1, newChild1, level + 1, consumer);
                        }
                        ++oldIndex;
                        ++newIndex;
                        continue;
                    }
                    if (c11 == CompareResult.TYPE_ONLY) {
                        CompareResult c21 = this.looksEqual(comparator, oldChild2, newChild1);
                        if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED) {
                            consumer.nodeDeleted(oldNode, oldChild1);
                            ++oldIndex;
                            continue;
                        }
                        CompareResult c12 = this.looksEqual(comparator, oldChild1, newChild2);
                        if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
                            consumer.nodeInserted(oldNode, newChild1, newIndex);
                            ++newIndex;
                            continue;
                        }
                        consumer.nodeReplaced(oldChild1, newChild1);
                        ++oldIndex;
                        ++newIndex;
                        continue;
                    }
                    CompareResult c12 = this.looksEqual(comparator, oldChild1, newChild2);
                    if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
                        consumer.nodeInserted(oldNode, newChild1, newIndex);
                        ++newIndex;
                        continue;
                    }
                    CompareResult c21 = this.looksEqual(comparator, oldChild2, newChild1);
                    if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED || c21 == CompareResult.TYPE_ONLY) {
                        consumer.nodeDeleted(oldNode, oldChild1);
                        ++oldIndex;
                        continue;
                    }
                    if (c12 == CompareResult.TYPE_ONLY) {
                        consumer.nodeInserted(oldNode, newChild1, newIndex);
                        ++newIndex;
                        continue;
                    }
                    if (oldChild1 == null) {
                        consumer.nodeInserted(oldNode, newChild1, newIndex);
                        ++newIndex;
                        continue;
                    }
                    if (newChild1 == null) {
                        consumer.nodeDeleted(oldNode, oldChild1);
                        ++oldIndex;
                        continue;
                    }
                    if (oldChild3 != null || newChild3 != null) {
                        CompareResult c13 = this.looksEqual(comparator, oldChild1, newChild3);
                        if (c13 == CompareResult.EQUAL || c13 == CompareResult.DRILL_DOWN_NEEDED || c13 == CompareResult.TYPE_ONLY) {
                            consumer.nodeInserted(oldNode, newChild1, newIndex);
                            consumer.nodeInserted(oldNode, newChild2, ++newIndex);
                            ++newIndex;
                            continue;
                        }
                        CompareResult c31 = this.looksEqual(comparator, oldChild3, newChild1);
                        if (c31 == CompareResult.EQUAL || c31 == CompareResult.DRILL_DOWN_NEEDED || c31 == CompareResult.TYPE_ONLY) {
                            consumer.nodeDeleted(oldNode, oldChild1);
                            consumer.nodeDeleted(oldNode, oldChild2);
                            ++oldIndex;
                            ++oldIndex;
                            continue;
                        }
                    }
                    OT oldLastChild = oldIndex < oldChildrenSize - suffixLength ? (OT)oldChildren[oldChildrenSize - suffixLength - 1] : null;
                    NT newLastChild = newIndex < newChildrenSize - suffixLength ? (NT)newChildren[newChildrenSize - suffixLength - 1] : null;
                    CompareResult compareResult = c = oldLastChild == null || newLastChild == null ? CompareResult.NOT_EQUAL : this.looksEqual(comparator, oldLastChild, newLastChild);
                    if (c == CompareResult.EQUAL || c == CompareResult.TYPE_ONLY || c == CompareResult.DRILL_DOWN_NEEDED) {
                        if (c == CompareResult.DRILL_DOWN_NEEDED) {
                            this.build(oldLastChild, newLastChild, level + 1, consumer);
                        } else {
                            consumer.nodeReplaced(oldLastChild, newLastChild);
                        }
                        ++suffixLength;
                        continue;
                    }
                    consumer.nodeReplaced(oldChild1, newChild1);
                    ++oldIndex;
                    ++newIndex;
                }
                result2 = CompareResult.NOT_EQUAL;
            }
        }
        this.myOldTree.disposeChildren(oldChildren, oldChildrenSize);
        this.myNewTree.disposeChildren(newChildren, newChildrenSize);
        CompareResult compareResult = result2;
        if (compareResult == null) {
            DiffTree.$$$reportNull$$$0(13);
        }
        return compareResult;
    }

    private int match(OT[] oldChildren, int oldIndex, NT[] newChildren, int newIndex, int level, int step, int maxLength) {
        int delta;
        for (delta = 0; delta != maxLength * step; delta += step) {
            OT oldChild = oldChildren[oldIndex + delta];
            NT newChild = newChildren[newIndex + delta];
            CompareResult c11 = this.looksEqual(this.myComparator, oldChild, newChild);
            if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
                CompareResult compareResult = c11 = this.textMatch(oldChild, newChild) ? this.build(oldChild, newChild, level + 1, DiffTree.<OT, NT>emptyConsumer()) : CompareResult.NOT_EQUAL;
                assert (c11 != CompareResult.DRILL_DOWN_NEEDED);
            }
            if (c11 != CompareResult.EQUAL) break;
        }
        return delta * step;
    }

    private boolean textMatch(OT oldChild, NT newChild) {
        int oldStart = this.myOldTree.getStartOffset(oldChild) - this.myOldTreeStart;
        int oldEnd = this.myOldTree.getEndOffset(oldChild) - this.myOldTreeStart;
        int newStart = this.myNewTree.getStartOffset(newChild) - this.myNewTreeStart;
        int newEnd = this.myNewTree.getEndOffset(newChild) - this.myNewTreeStart;
        return CharArrayUtil.regionMatches(this.myOldText, oldStart, oldEnd, this.myNewText, newStart, newEnd);
    }

    @NotNull
    private CompareResult looksEqual(@NotNull ShallowNodeComparator<OT, NT> comparator, OT oldChild1, NT newChild1) {
        if (comparator == null) {
            DiffTree.$$$reportNull$$$0(14);
        }
        if (oldChild1 == null || newChild1 == null) {
            CompareResult compareResult = oldChild1 == newChild1 ? CompareResult.EQUAL : CompareResult.NOT_EQUAL;
            if (compareResult == null) {
                DiffTree.$$$reportNull$$$0(15);
            }
            return compareResult;
        }
        if (!comparator.typesEqual(oldChild1, newChild1)) {
            CompareResult compareResult = CompareResult.NOT_EQUAL;
            if (compareResult == null) {
                DiffTree.$$$reportNull$$$0(16);
            }
            return compareResult;
        }
        ThreeState ret = comparator.deepEqual(oldChild1, newChild1);
        if (ret == ThreeState.YES) {
            CompareResult compareResult = CompareResult.EQUAL;
            if (compareResult == null) {
                DiffTree.$$$reportNull$$$0(17);
            }
            return compareResult;
        }
        if (ret == ThreeState.UNSURE) {
            CompareResult compareResult = CompareResult.DRILL_DOWN_NEEDED;
            if (compareResult == null) {
                DiffTree.$$$reportNull$$$0(18);
            }
            return compareResult;
        }
        CompareResult compareResult = CompareResult.TYPE_ONLY;
        if (compareResult == null) {
            DiffTree.$$$reportNull$$$0(19);
        }
        return compareResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTree";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTree";
                break;
            }
            case 2: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/diff/DiffTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/diff/DiffTree";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyConsumer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "looksEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "looksEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum CompareResult {
        EQUAL,
        DRILL_DOWN_NEEDED,
        TYPE_ONLY,
        NOT_EQUAL;

    }
}

