/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class AnnotationParamListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.AnnotationParamListElement");
    private static final TokenSet NAME_VALUE_PAIR_BIT_SET = TokenSet.create(JavaElementType.NAME_VALUE_PAIR);

    public AnnotationParamListElement() {
        super(JavaElementType.ANNOTATION_PARAMETER_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(i) || i == JavaElementType.NAME_VALUE_PAIR && child.getFirstChildNode() != null && child.getFirstChildNode().getElementType() == JavaElementType.ANNOTATION_ARRAY_INITIALIZER) {
            return 249;
        }
        return 0;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                LOG.assertTrue(false);
                return null;
            }
            case 24: {
                return this.findChildByType(JavaTokenType.LPARENTH);
            }
            case 25: 
        }
        return this.findChildByType(JavaTokenType.RPARENTH);
    }

    @Override
    public TreeElement addInternal(TreeElement first2, ASTNode last2, ASTNode anchor2, Boolean before) {
        if (first2.getElementType() == JavaElementType.NAME_VALUE_PAIR && last2.getElementType() == JavaElementType.NAME_VALUE_PAIR) {
            PsiAnnotationMemberValue value;
            PsiNameValuePair pair;
            ASTNode node;
            ASTNode[] nodes;
            ASTNode rparenth;
            ASTNode lparenth = this.findChildByType(JavaTokenType.LPARENTH);
            if (lparenth == null) {
                CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
                LeafElement created = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getFirstChildNode(), true);
            }
            if ((rparenth = this.findChildByType(JavaTokenType.RPARENTH)) == null) {
                CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
                LeafElement created = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getLastChildNode(), false);
            }
            if ((nodes = this.getChildren(NAME_VALUE_PAIR_BIT_SET)).length == 1 && (node = nodes[0]) instanceof PsiNameValuePair && (pair = (PsiNameValuePair)((Object)node)).getName() == null && (value = pair.getValue()) != null) {
                try {
                    PsiElementFactory factory2 = JavaPsiFacade.getInstance(this.getPsi().getProject()).getElementFactory();
                    PsiAnnotation annotation2 = factory2.createAnnotationFromText("@AAA(value = " + value.getText() + ")", null);
                    this.replaceChild(node, annotation2.getParameterList().getAttributes()[0].getNode());
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            if (anchor2 == null && before != null) {
                anchor2 = this.findChildByType(before != false ? JavaTokenType.RPARENTH : JavaTokenType.LPARENTH);
            }
            TreeElement firstAdded = super.addInternal(first2, last2, anchor2, before);
            JavaSourceUtil.addSeparatingComma(this, first2, NAME_VALUE_PAIR_BIT_SET);
            return firstAdded;
        }
        return super.addInternal(first2, last2, anchor2, before);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            AnnotationParamListElement.$$$reportNull$$$0(0);
        }
        if (child.getElementType() == JavaElementType.NAME_VALUE_PAIR) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/AnnotationParamListElement", "deleteChildInternal"));
    }
}

