/* Zutils - Utilities dealing with compressed files
   Copyright (C) 2009-2026 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// format_index; < 0 means undefined, >= num_formats means uncompressed
enum { fmt_bz2, fmt_gz, fmt_lz, fmt_xz, fmt_zst, num_formats };

const char * const format_names[num_formats] =
  { "bz2", "gz", "lz", "xz", "zst" };
const char * const simple_extensions[num_formats] =
  { ".bz2", ".gz", ".lz", ".xz", ".zst" };
const int format_order[num_formats] =
  { fmt_lz, fmt_gz, fmt_bz2, fmt_zst, fmt_xz };		// search order

bool enabled_format( const int format_index );		// -1 == uncompressed
void parse_format_list( const std::string & arg, const char * const pn );
// Return num_formats if arg == "un" (uncompressed).
int parse_format_type( const std::string & arg, const char * const pn,
                       const bool allow_uncompressed = true );

int extension_index( const std::string & name );	// -1 if unknown
int extension_format( const int eindex );		// -1 if uncompressed
const char * extension_from( const int eindex );	// -1 if uncompressed
const char * extension_to( const int eindex );

// Return format_index, or -1 if uncompressed.
//
inline int test_extension( const std::string & name )
  { return extension_format( extension_index( name ) ); }

extern const char * invocation_name;
extern const char * program_name;
extern int verbosity;

class Arg_parser;

void maybe_process_config_file( const Arg_parser & parser );

void parse_compressor( const std::string & arg, const char * const pn,
                       const int format_index, const int eretval = 2 );

const char * get_compressor_name( const int format_index );
const std::vector< std::string > & get_compressor_args( const int format_index );

void show_help_addr();
void show_version( const char * const command = 0 );
void show_error( const char * const msg, const int errcode = 0,
                 const bool help = false );
void show_file_error( const char * const filename, const char * const msg,
                      const int errcode = 0 );
inline void show_stdout_error( const int errcode = 0 )
  { show_file_error( "(stdout)", "Write error", errcode ); }
void internal_error( const char * const msg );
void show_option_error( const char * const arg, const char * const msg,
                        const char * const option_name );
void show_close_error( const char * const prog_name = "data feeder" );
void show_exec_error( const char * const prog_name );
void show_fork_error( const char * const prog_name );

// Return exit status of child process 'pid', or 'eretval' in case of error.
//
int wait_for_child( const pid_t pid, const char * const name,
                    const int eretval = 2, const bool isgzxz = false );
