/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_24 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4700, "epsg", 4700,
        "IGN Astro 1960", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "IGN_Astro_1960", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN Astro 1960\",DATUM[\"IGN_Astro_1960\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[");
    add_srs_wkt (p, 2,
        "\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM");
    add_srs_wkt (p, 3,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 4,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 5,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4700\"]]");
    p = add_epsg_def_ex (filter, first, last, 4701, "epsg", 4701,
        "IGCB 1955", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Institut_Geographique_du_Congo_Belge_1955", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGCB 1955\",DATUM[\"Institut_Geographique_du_Co");
    add_srs_wkt (p, 1,
        "ngo_Belge_1955\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.");
    add_srs_wkt (p, 2,
        "145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6701\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4701\"]]");
    p = add_epsg_def_ex (filter, first, last, 4702, "epsg", 4702,
        "Mauritania 1999", 1, 1,
        "GRS 1980", "Greenwich",
        "Mauritania_1999", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mauritania 1999\",DATUM[\"Mauritania_1999\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6702\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4702\"]]");
    p = add_epsg_def_ex (filter, first, last, 4703, "epsg", 4703,
        "Mhast 1951", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Missao_Hidrografico_Angola_y_Sao_Tome_1951", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast 1951\",DATUM[\"Missao_Hidrografico_Angola");
    add_srs_wkt (p, 1,
        "_y_Sao_Tome_1951\",SPHEROID[\"Clarke 1880 (RGS)\",637824");
    add_srs_wkt (p, 2,
        "9.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6703\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4703\"]]");
    p = add_epsg_def_ex (filter, first, last, 4704, "epsg", 4704,
        "Mhast (onshore)", 1, 1,
        "International 1924", "Greenwich",
        "Mhast_onshore", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast (onshore)\",DATUM[\"Mhast_onshore\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6704\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4704\"]]");
    p = add_epsg_def_ex (filter, first, last, 4705, "epsg", 4705,
        "Mhast (offshore)", 1, 1,
        "International 1924", "Greenwich",
        "Mhast_offshore", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast (offshore)\",DATUM[\"Mhast_offshore\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6705\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4705\"]]");
    p = add_epsg_def_ex (filter, first, last, 4706, "epsg", 4706,
        "Egypt Gulf of Suez S-650 TL", 1, 1,
        "Helmert 1906", "Greenwich",
        "Egypt_Gulf_of_Suez_S-650_TL", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +towgs84=-146.21,112.63,4.0");
    add_proj4text (p, 1,
        "5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Egypt Gulf of Suez S-650 TL\",DATUM[\"Egypt_Gul");
    add_srs_wkt (p, 1,
        "f_of_Suez_S-650_TL\",SPHEROID[\"Helmert 1906\",6378200,2");
    add_srs_wkt (p, 2,
        "98.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6706\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4706\"]]");
    p = add_epsg_def_ex (filter, first, last, 4707, "epsg", 4707,
        "Tern Island 1961", 1, 1,
        "International 1924", "Greenwich",
        "Tern_Island_1961", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=114,-116,-333,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tern Island 1961\",DATUM[\"Tern_Island_1961\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6707\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4707\"]]");
    p = add_epsg_def_ex (filter, first, last, 4708, "epsg", 4708,
        "Cocos Islands 1965", 1, 1,
        "Australian National Spheroid", "Greenwich",
        "Cocos_Islands_1965", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-491,-22,435,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cocos Islands 1965\",DATUM[\"Cocos_Islands_1965");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Australian National Spheroid\",6378160,298");
    add_srs_wkt (p, 2,
        ".25,AUTHORITY[\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "708\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"4708\"]]");
    p = add_epsg_def_ex (filter, first, last, 4709, "epsg", 4709,
        "Iwo Jima 1945", 1, 1,
        "International 1924", "Greenwich",
        "Iwo_Jima_1945", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=145,75,-272,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Iwo Jima 1945\",DATUM[\"Iwo_Jima_1945\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"6709\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4709\"]]");
    p = add_epsg_def_ex (filter, first, last, 4710, "epsg", 4710,
        "Astro DOS 71", 1, 1,
        "International 1924", "Greenwich",
        "Astro_DOS_71", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-320,550,-494,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Astro DOS 71\",DATUM[\"Astro_DOS_71\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6710\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4710\"]]");
    p = add_epsg_def_ex (filter, first, last, 4711, "epsg", 4711,
        "Marcus Island 1952", 1, 1,
        "International 1924", "Greenwich",
        "Marcus_Island_1952", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=124,-234,-25,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Marcus Island 1952\",DATUM[\"Marcus_Island_1952");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6711\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4711\"]]");
    p = add_epsg_def_ex (filter, first, last, 4712, "epsg", 4712,
        "Ascension Island 1958", 1, 1,
        "International 1924", "Greenwich",
        "Ascension_Island_1958", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-205,107,53,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ascension Island 1958\",DATUM[\"Ascension_Islan");
    add_srs_wkt (p, 1,
        "d_1958\",SPHEROID[\"International 1924\",6378388,297,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6712\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4712\"]]");
    p = add_epsg_def_ex (filter, first, last, 4713, "epsg", 4713,
        "Ayabelle Lighthouse", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Ayabelle_Lighthouse", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-77,-128,142,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ayabelle Lighthouse\",DATUM[\"Ayabelle_Lighthou");
    add_srs_wkt (p, 1,
        "se\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6713\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4713\"]]");
    p = add_epsg_def_ex (filter, first, last, 4714, "epsg", 4714,
        "Bellevue", 1, 1,
        "International 1924", "Greenwich",
        "Bellevue", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-127,-769,472,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bellevue\",DATUM[\"Bellevue\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6714\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4714");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4715, "epsg", 4715,
        "Camp Area Astro", 1, 1,
        "International 1924", "Greenwich",
        "Camp_Area_Astro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104,-129,239,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Camp Area Astro\",DATUM[\"Camp_Area_Astro\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6715\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4715\"]]");
    p = add_epsg_def_ex (filter, first, last, 4716, "epsg", 4716,
        "Phoenix Islands 1966", 1, 1,
        "International 1924", "Greenwich",
        "Phoenix_Islands_1966", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=298,-304,-375,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Phoenix Islands 1966\",DATUM[\"Phoenix_Islands_");
    add_srs_wkt (p, 1,
        "1966\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6716\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4716\"]]");
    p = add_epsg_def_ex (filter, first, last, 4717, "epsg", 4717,
        "Cape Canaveral", 1, 1,
        "Clarke 1866", "Greenwich",
        "Cape_Canaveral", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-2,151,181,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cape Canaveral\",DATUM[\"Cape_Canaveral\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6717\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4717\"]]");
    p = add_epsg_def_ex (filter, first, last, 4718, "epsg", 4718,
        "Solomon 1968", 1, 1,
        "International 1924", "Greenwich",
        "Solomon_1968", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=230,-199,-752,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Solomon 1968\",DATUM[\"Solomon_1968\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6718\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4718\"]]");
    p = add_epsg_def_ex (filter, first, last, 4719, "epsg", 4719,
        "Easter Island 1967", 1, 1,
        "International 1924", "Greenwich",
        "Easter_Island_1967", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=211,147,111,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Easter Island 1967\",DATUM[\"Easter_Island_1967");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6719\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4719\"]]");
    p = add_epsg_def_ex (filter, first, last, 4720, "epsg", 4720,
        "Fiji 1986", 1, 1,
        "WGS 72", "Greenwich",
        "Fiji_Geodetic_Datum_1986", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.");
    add_proj4text (p, 1,
        "2263 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fiji 1986\",DATUM[\"Fiji_Geodetic_Datum_1986\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7043\"]],AUTHORITY[\"EPSG\",\"6720\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4720\"]]");
    p = add_epsg_def_ex (filter, first, last, 4721, "epsg", 4721,
        "Fiji 1956", 1, 1,
        "International 1924", "Greenwich",
        "Fiji_1956", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=265.025,384.929,-194.");
    add_proj4text (p, 1,
        "046,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fiji 1956\",DATUM[\"Fiji_1956\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6721\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 6,
        "21\"]]");
    p = add_epsg_def_ex (filter, first, last, 4722, "epsg", 4722,
        "South Georgia 1968", 1, 1,
        "International 1924", "Greenwich",
        "South_Georgia_1968", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-794,119,-298,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"South Georgia 1968\",DATUM[\"South_Georgia_1968");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6722\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4722\"]]");
    p = add_epsg_def_ex (filter, first, last, 4723, "epsg", 4723,
        "GCGD59", 1, 1,
        "Clarke 1866", "Greenwich",
        "Grand_Cayman_Geodetic_Datum_1959", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-179.483,-69.379,-2");
    add_proj4text (p, 1,
        "7.584,-7.862,8.163,6.042,-13.925 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GCGD59\",DATUM[\"Grand_Cayman_Geodetic_Datum_19");
    add_srs_wkt (p, 1,
        "59\",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213898");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6723");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4723\"]]");
    p = add_epsg_def_ex (filter, first, last, 4724, "epsg", 4724,
        "Diego Garcia 1969", 1, 1,
        "International 1924", "Greenwich",
        "Diego_Garcia_1969", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=208,-435,-229,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Diego Garcia 1969\",DATUM[\"Diego_Garcia_1969\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6724\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4724\"]]");
    p = add_epsg_def_ex (filter, first, last, 4725, "epsg", 4725,
        "Johnston Island 1961", 1, 1,
        "International 1924", "Greenwich",
        "Johnston_Island_1961", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=189,-79,-202,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Johnston Island 1961\",DATUM[\"Johnston_Island_");
    add_srs_wkt (p, 1,
        "1961\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6725\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4725\"]]");
    p = add_epsg_def_ex (filter, first, last, 4726, "epsg", 4726,
        "SIGD61", 1, 1,
        "Clarke 1866", "Greenwich",
        "Sister_Islands_Geodetic_Datum_1961", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=8.853,-52.644,180.3");
    add_proj4text (p, 1,
        "04,-0.393,-2.323,2.96,-24.081 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIGD61\",DATUM[\"Sister_Islands_Geodetic_Datum_");
    add_srs_wkt (p, 1,
        "1961\",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982138");
    add_srs_wkt (p, 2,
        "98,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 3,
        "26\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4726\"]]");
    p = add_epsg_def_ex (filter, first, last, 4727, "epsg", 4727,
        "Midway 1961", 1, 1,
        "International 1924", "Greenwich",
        "Midway_1961", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=403,-81,277,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Midway 1961\",DATUM[\"Midway_1961\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6727\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4727\"]]");
    p = add_epsg_def_ex (filter, first, last, 4728, "epsg", 4728,
        "PN84", 1, 1,
        "International 1924", "Greenwich",
        "Pico_de_las_Nieves_1984", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-307,-92,127,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PN84\",DATUM[\"Pico_de_las_Nieves_1984\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6728\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4728\"]]");
    p = add_epsg_def_ex (filter, first, last, 4729, "epsg", 4729,
        "Pitcairn 1967", 1, 1,
        "International 1924", "Greenwich",
        "Pitcairn_1967", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=185,165,42,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pitcairn 1967\",DATUM[\"Pitcairn_1967\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"6729\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4729\"]]");
    p = add_epsg_def_ex (filter, first, last, 4730, "epsg", 4730,
        "Santo 1965", 1, 1,
        "International 1924", "Greenwich",
        "Santo_1965", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=170,42,84,0,0,0,0 +no");
    add_proj4text (p, 1,
        "_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Santo 1965\",DATUM[\"Santo_1965\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6730\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4730\"]]");
    p = add_epsg_def_ex (filter, first, last, 4731, "epsg", 4731,
        "Viti Levu 1916 (deprecated)", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Viti_Levu_1916", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=51,391,-36,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Viti Levu 1916 (deprecated)\",DATUM[\"Viti_Levu");
    add_srs_wkt (p, 1,
        "_1916\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 3,
        "31\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4731\"]]");
    p = add_epsg_def_ex (filter, first, last, 4732, "epsg", 4732,
        "Marshall Islands 1960", 1, 1,
        "Hough 1960", "Greenwich",
        "Marshall_Islands_1960", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378270 +b=6356794.343434343 +towgs84=1");
    add_proj4text (p, 1,
        "02,52,-38,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Marshall Islands 1960\",DATUM[\"Marshall_Island");
    add_srs_wkt (p, 1,
        "s_1960\",SPHEROID[\"Hough 1960\",6378270,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7053\"]],AUTHORITY[\"EPSG\",\"6732\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4732\"]]");
    p = add_epsg_def_ex (filter, first, last, 4733, "epsg", 4733,
        "Wake Island 1952", 1, 1,
        "International 1924", "Greenwich",
        "Wake_Island_1952", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=276,-57,149,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Wake Island 1952\",DATUM[\"Wake_Island_1952\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6733\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4733\"]]");
    p = add_epsg_def_ex (filter, first, last, 4734, "epsg", 4734,
        "Tristan 1968", 1, 1,
        "International 1924", "Greenwich",
        "Tristan_1968", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-632,438,-609,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tristan 1968\",DATUM[\"Tristan_1968\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6734\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4734\"]]");
    p = add_epsg_def_ex (filter, first, last, 4735, "epsg", 4735,
        "Kusaie 1951", 1, 1,
        "International 1924", "Greenwich",
        "Kusaie_1951", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=647,1777,-1124,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kusaie 1951\",DATUM[\"Kusaie_1951\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6735\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4735\"]]");
    p = add_epsg_def_ex (filter, first, last, 4736, "epsg", 4736,
        "Deception Island", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Deception_Island", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=260,12,-147,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Deception Island\",DATUM[\"Deception_Island\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6736\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4736\"]]");
    p = add_epsg_def_ex (filter, first, last, 4737, "epsg", 4737,
        "Korea 2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Korea 2000\",DATUM[\"Geocentric_datum_of_Korea\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4737\"]]");
    p = add_epsg_def_ex (filter, first, last, 4738, "epsg", 4738,
        "Hong Kong 1963", 1, 1,
        "Clarke 1858", "Greenwich",
        "Hong_Kong_1963", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong 1963\",DATUM[\"Hong_Kong_1963\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1858\",6378293.64520876,294.260676369261,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"6738\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4738\"]]");
    p = add_epsg_def_ex (filter, first, last, 4739, "epsg", 4739,
        "Hong Kong 1963(67)", 1, 1,
        "International 1924", "Greenwich",
        "Hong_Kong_1963_67", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-156,-271,-189,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong 1963(67)\",DATUM[\"Hong_Kong_1963_67\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6739\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4739\"]]");
    p = add_epsg_def_ex (filter, first, last, 4740, "epsg", 4740,
        "PZ-90", 1, 1,
        "PZ-90", "Greenwich",
        "Parametry_Zemli_1990", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +b=6356751.361745712 +towgs84=0");
    add_proj4text (p, 1,
        ",0,1.5,0,0,0.076,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PZ-90\",DATUM[\"Parametry_Zemli_1990\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"PZ-90\",6378136,298.257839303,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "54\"]],AUTHORITY[\"EPSG\",\"6740\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4740\"]]");
    p = add_epsg_def_ex (filter, first, last, 4741, "epsg", 4741,
        "FD54", 1, 1,
        "International 1924", "Greenwich",
        "Faroe_Datum_1954", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"FD54\",DATUM[\"Faroe_Datum_1954\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6741\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4741\"]]");
    p = add_epsg_def_ex (filter, first, last, 4742, "epsg", 4742,
        "GDM2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GDM2000\",DATUM[\"Geodetic_Datum_of_Malaysia_20");
    add_srs_wkt (p, 1,
        "00\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4742\"]]");
    p = add_epsg_def_ex (filter, first, last, 4743, "epsg", 4743,
        "Karbala 1979", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Karbala_1979", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=70.995,-335.916,262");
    add_proj4text (p, 1,
        ".898,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Karbala 1979\",DATUM[\"Karbala_1979\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6743\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4743\"]]");
    p = add_epsg_def_ex (filter, first, last, 4744, "epsg", 4744,
        "Nahrwan 1934", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-242.2,-144.9,370.3");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nahrwan 1934\",DATUM[\"Nahrwan_1934\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6744\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4744\"]]");
    p = add_epsg_def_ex (filter, first, last, 4745, "epsg", 4745,
        "RD/83", 1, 1,
        "Bessel 1841", "Greenwich",
        "Rauenberg_Datum_83", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4745\"]]");
    p = add_epsg_def_ex (filter, first, last, 4746, "epsg", 4746,
        "PD/83", 1, 1,
        "Bessel 1841", "Greenwich",
        "Potsdam_Datum_83", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 1,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4746\"]]");
    p = add_epsg_def_ex (filter, first, last, 4747, "epsg", 4747,
        "GR96", 1, 1,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GR96\",DATUM[\"Greenland_1996\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 6,
        "47\"]]");
    p = add_epsg_def_ex (filter, first, last, 4748, "epsg", 4748,
        "Vanua Levu 1915", 1, 1,
        "Clarke 1880 (international foot)", "Greenwich",
        "Vanua_Levu_1915", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51");
    add_proj4text (p, 1,
        ",391,-36,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Vanua Levu 1915\",DATUM[\"Vanua_Levu_1915\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (international foot)\",6378306.3696,");
    add_srs_wkt (p, 2,
        "293.466307655635,AUTHORITY[\"EPSG\",\"7055\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6748\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4748\"]]");
    p = add_epsg_def_ex (filter, first, last, 4749, "epsg", 4749,
        "RGNC91-93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91-93", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGNC91-93\",DATUM[\"Reseau_Geodesique_de_Nouvel");
    add_srs_wkt (p, 1,
        "le_Caledonie_91-93\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4749\"]]");
    p = add_epsg_def_ex (filter, first, last, 4750, "epsg", 4750,
        "ST87 Ouvea", 1, 1,
        "WGS 84", "Greenwich",
        "ST87_Ouvea", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-56.263,16.136,-22.8");
    add_proj4text (p, 1,
        "56,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST87 Ouvea\",DATUM[\"ST87_Ouvea\",SPHEROID[\"WG");
    add_srs_wkt (p, 1,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6750\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 6,
        "50\"]]");
    p = add_epsg_def_ex (filter, first, last, 4751, "epsg", 4751,
        "Kertau (RSO)", 1, 1,
        "Everest 1830 (RSO 1969)", "Greenwich",
        "Kertau_RSO", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377295.664 +b=6356094.667915204 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kertau (RSO)\",DATUM[\"Kertau_RSO\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (RSO 1969)\",6377295.664,300.8017,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7056\"]],AUTHORITY[\"EPSG\",\"6751\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4751\"]]");
    p = add_epsg_def_ex (filter, first, last, 4752, "epsg", 4752,
        "Viti Levu 1912", 1, 1,
        "Clarke 1880 (international foot)", "Greenwich",
        "Viti_Levu_1912", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=98");
    add_proj4text (p, 1,
        ",390,-22,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Viti Levu 1912\",DATUM[\"Viti_Levu_1912\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1880 (international foot)\",6378306.3696,29");
    add_srs_wkt (p, 2,
        "3.466307655635,AUTHORITY[\"EPSG\",\"7055\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6752\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4752\"]]");
    p = add_epsg_def_ex (filter, first, last, 4753, "epsg", 4753,
        "fk89", 1, 1,
        "International 1924", "Greenwich",
        "fk89", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"fk89\",DATUM[\"fk89\",SPHEROID[\"International ");
    add_srs_wkt (p, 1,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"6753\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 5,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4753\"]]");
    p = add_epsg_def_ex (filter, first, last, 4754, "epsg", 4754,
        "LGD2006", 1, 1,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-208.4058,-109.8777,-");
    add_proj4text (p, 1,
        "2.5764,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LGD2006\",DATUM[\"Libyan_Geodetic_Datum_2006\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6754\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4754\"]]");
    p = add_epsg_def_ex (filter, first, last, 4755, "epsg", 4755,
        "DGN95", 1, 1,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DGN95\",DATUM[\"Datum_Geodesi_Nasional_1995\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7030\"]],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4755\"]]");
    p = add_epsg_def_ex (filter, first, last, 4756, "epsg", 4756,
        "VN-2000", 1, 1,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-191.90441429,-39.30");
    add_proj4text (p, 1,
        "318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0");
    add_proj4text (p, 2,
        ".252906278 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"VN-2000\",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],AUTHORITY[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 4,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 5,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 6,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 4757, "epsg", 4757,
        "SVY21", 1, 1,
        "WGS 84", "Greenwich",
        "SVY21", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SVY21\",DATUM[\"SVY21\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 1,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"6757\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 5,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4757\"]]");
    p = add_epsg_def_ex (filter, first, last, 4758, "epsg", 4758,
        "JAD2001", 1, 1,
        "WGS 84", "Greenwich",
        "Jamaica_2001", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JAD2001\",DATUM[\"Jamaica_2001\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],AUTHORITY[\"EPSG\",\"6758\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 4,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 5,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 6,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 4759, "epsg", 4759,
        "NAD83(NSRS2007)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 1,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    p = add_epsg_def_ex (filter, first, last, 4760, "epsg", 4760,
        "WGS 66", 1, 1,
        "NWL 9D", "Greenwich",
        "World_Geodetic_System_1966", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 66\",DATUM[\"World_Geodetic_System_1966\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"NWL 9D\",6378145,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "025\"]],AUTHORITY[\"EPSG\",\"6760\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4760\"]]");
    p = add_epsg_def_ex (filter, first, last, 4761, "epsg", 4761,
        "HTRS96", 1, 1,
        "GRS 1980", "Greenwich",
        "Croatian_Terrestrial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"HTRS96\",DATUM[\"Croatian_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6761\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4761\"]]");
    p = add_epsg_def_ex (filter, first, last, 4762, "epsg", 4762,
        "BDA2000", 1, 1,
        "WGS 84", "Greenwich",
        "Bermuda_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"BDA2000\",DATUM[\"Bermuda_2000\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],AUTHORITY[\"EPSG\",\"6762\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 4,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 5,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"476");
    add_srs_wkt (p, 6,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 4763, "epsg", 4763,
        "Pitcairn 2006", 1, 1,
        "WGS 84", "Greenwich",
        "Pitcairn_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pitcairn 2006\",DATUM[\"Pitcairn_2006\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7030\"]],AUTHORITY[\"EPSG\",\"6763\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4763\"]]");
    p = add_epsg_def_ex (filter, first, last, 4764, "epsg", 4764,
        "RSRGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RSRGD2000\",DATUM[\"Ross_Sea_Region_Geodetic_Da");
    add_srs_wkt (p, 1,
        "tum_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6764\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4764\"]]");
    p = add_epsg_def_ex (filter, first, last, 4765, "epsg", 4765,
        "Slovenia 1996", 1, 1,
        "GRS 1980", "Greenwich",
        "Slovenia_Geodetic_Datum_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Slovenia 1996\",DATUM[\"Slovenia_Geodetic_Datum");
    add_srs_wkt (p, 1,
        "_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6765\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4765\"]]");
    p = add_epsg_def_ex (filter, first, last, 4766, "epsg", 4766,
        "New Beijing / 3-degree Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 30\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",90],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",30500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4766\"]]");
    p = add_epsg_def_ex (filter, first, last, 4767, "epsg", 4767,
        "New Beijing / 3-degree Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 31\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",93],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",31500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4767\"]]");
    p = add_epsg_def_ex (filter, first, last, 4768, "epsg", 4768,
        "New Beijing / 3-degree Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 32\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",96],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",32500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4768\"]]");
    p = add_epsg_def_ex (filter, first, last, 4769, "epsg", 4769,
        "New Beijing / 3-degree Gauss-Kruger zone 33", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 33\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",99],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",33500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4769\"]]");
    p = add_epsg_def_ex (filter, first, last, 4770, "epsg", 4770,
        "New Beijing / 3-degree Gauss-Kruger zone 34", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 34\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",102],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",34500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4770\"]]");
    p = add_epsg_def_ex (filter, first, last, 4771, "epsg", 4771,
        "New Beijing / 3-degree Gauss-Kruger zone 35", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 35\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",105],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",35500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4771\"]]");
    p = add_epsg_def_ex (filter, first, last, 4772, "epsg", 4772,
        "New Beijing / 3-degree Gauss-Kruger zone 36", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 36\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",108],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",36500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4772\"]]");
    p = add_epsg_def_ex (filter, first, last, 4773, "epsg", 4773,
        "New Beijing / 3-degree Gauss-Kruger zone 37", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 37\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",111],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",37500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4773\"]]");
    p = add_epsg_def_ex (filter, first, last, 4774, "epsg", 4774,
        "New Beijing / 3-degree Gauss-Kruger zone 38", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 38\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",114],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",38500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4774\"]]");
    p = add_epsg_def_ex (filter, first, last, 4775, "epsg", 4775,
        "New Beijing / 3-degree Gauss-Kruger zone 39", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 39\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",117],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",39500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4775\"]]");
    p = add_epsg_def_ex (filter, first, last, 4776, "epsg", 4776,
        "New Beijing / 3-degree Gauss-Kruger zone 40", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 40\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",120],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",40500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4776\"]]");
    p = add_epsg_def_ex (filter, first, last, 4777, "epsg", 4777,
        "New Beijing / 3-degree Gauss-Kruger zone 41", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 41\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",123],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",41500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4777\"]]");
    p = add_epsg_def_ex (filter, first, last, 4778, "epsg", 4778,
        "New Beijing / 3-degree Gauss-Kruger zone 42", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 42\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",126],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",42500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4778\"]]");
    p = add_epsg_def_ex (filter, first, last, 4779, "epsg", 4779,
        "New Beijing / 3-degree Gauss-Kruger zone 43", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 43\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",43500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4779\"]]");
    p = add_epsg_def_ex (filter, first, last, 4780, "epsg", 4780,
        "New Beijing / 3-degree Gauss-Kruger zone 44", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 44\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",132],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",44500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4780\"]]");
    p = add_epsg_def_ex (filter, first, last, 4781, "epsg", 4781,
        "New Beijing / 3-degree Gauss-Kruger zone 45", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 45\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",45500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4781\"]]");
    p = add_epsg_def_ex (filter, first, last, 4782, "epsg", 4782,
        "New Beijing / 3-degree Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 75E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",75],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4782");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4783, "epsg", 4783,
        "New Beijing / 3-degree Gauss-Kruger CM 78E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 78E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",78],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4783");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4784, "epsg", 4784,
        "New Beijing / 3-degree Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 81E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",81],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4784");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4785, "epsg", 4785,
        "New Beijing / 3-degree Gauss-Kruger CM 84E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 84E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",84],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4785");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4786, "epsg", 4786,
        "New Beijing / 3-degree Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 87E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",87],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4786");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4787, "epsg", 4787,
        "New Beijing / 3-degree Gauss-Kruger CM 90E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 90E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",90],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4787");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4788, "epsg", 4788,
        "New Beijing / 3-degree Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 93E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",93],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4788");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4789, "epsg", 4789,
        "New Beijing / 3-degree Gauss-Kruger CM 96E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 96E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",96],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4789");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4790, "epsg", 4790,
        "New Beijing / 3-degree Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 99E\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",99],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4790");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4791, "epsg", 4791,
        "New Beijing / 3-degree Gauss-Kruger CM 102E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 102E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",102],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4791\"]]");
    p = add_epsg_def_ex (filter, first, last, 4792, "epsg", 4792,
        "New Beijing / 3-degree Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 105E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",105],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4792\"]]");
    p = add_epsg_def_ex (filter, first, last, 4793, "epsg", 4793,
        "New Beijing / 3-degree Gauss-Kruger CM 108E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 108E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",108],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4793\"]]");
    p = add_epsg_def_ex (filter, first, last, 4794, "epsg", 4794,
        "New Beijing / 3-degree Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 111E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",111],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4794\"]]");
    p = add_epsg_def_ex (filter, first, last, 4795, "epsg", 4795,
        "New Beijing / 3-degree Gauss-Kruger CM 114E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 114E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",114],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4795\"]]");
    p = add_epsg_def_ex (filter, first, last, 4796, "epsg", 4796,
        "New Beijing / 3-degree Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 117E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",117],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4796\"]]");
    p = add_epsg_def_ex (filter, first, last, 4797, "epsg", 4797,
        "New Beijing / 3-degree Gauss-Kruger CM 120E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 120E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",120],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4797\"]]");
    p = add_epsg_def_ex (filter, first, last, 4798, "epsg", 4798,
        "New Beijing / 3-degree Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 123E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",123],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4798\"]]");
    p = add_epsg_def_ex (filter, first, last, 4799, "epsg", 4799,
        "New Beijing / 3-degree Gauss-Kruger CM 126E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 126E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",126],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4799\"]]");
    p = add_epsg_def_ex (filter, first, last, 4800, "epsg", 4800,
        "New Beijing / 3-degree Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 129E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4800\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

