% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isRequiresOk.R
\name{isRequiresOk}
\alias{isRequiresOk}
\title{Check if parameter requirements are met.}
\usage{
isRequiresOk(par.set, par.vals, ids = names(par.vals), use.defaults = TRUE)
}
\arguments{
\item{par.set}{\link{ParamSet}\cr
Parameter set.}

\item{par.vals}{(\code{list()}) \cr
List of parameter settings.}

\item{ids}{(\code{character()}) \cr
\code{id}s of the param.vals to check. Default is \code{names(par.vals)}.}

\item{use.defaults}{(\code{logical()}) \cr
Some requirements relay on default values of the \code{par.set}. Default is
\code{TRUE}, which means that if the value is not present in \code{par.vals} the
default value will be considered.}
}
\value{
\code{logical(1)} \cr
}
\description{
Check if a parameter value satisfies the requirements of the
parameter description. This only checks the \code{requires} expressions.
}
