# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from azure.security.attestation import AttestationClient
from devtools_testutils import AzureRecordedTestCase, PowerShellPreparer
import functools


class AttestationClientTestBase(AzureRecordedTestCase):

    def create_client(self, endpoint):
        credential = self.get_credential(AttestationClient)
        return self.create_client_from_credential(
            AttestationClient,
            credential=credential,
            endpoint=endpoint,
        )


AttestationPreparer = functools.partial(
    PowerShellPreparer, "attestation", attestation_endpoint="https://fake_attestation_endpoint.com"
)
