# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hybridconnectivity.aio import HybridConnectivityMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHybridConnectivityMgmtSolutionConfigurationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HybridConnectivityMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_configurations_get(self, resource_group):
        response = await self.client.solution_configurations.get(
            resource_uri="str",
            solution_configuration="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_configurations_create_or_update(self, resource_group):
        response = await self.client.solution_configurations.create_or_update(
            resource_uri="str",
            solution_configuration="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "solutionType": "str",
                    "lastSyncTime": "2020-02-20 00:00:00",
                    "provisioningState": "str",
                    "solutionSettings": {},
                    "status": "str",
                    "statusDetails": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_configurations_update(self, resource_group):
        response = await self.client.solution_configurations.update(
            resource_uri="str",
            solution_configuration="str",
            properties={
                "id": "str",
                "name": "str",
                "properties": {"solutionSettings": {}, "solutionType": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_configurations_delete(self, resource_group):
        response = await self.client.solution_configurations.delete(
            resource_uri="str",
            solution_configuration="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_configurations_list(self, resource_group):
        response = self.client.solution_configurations.list(
            resource_uri="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_configurations_begin_sync_now(self, resource_group):
        response = await (
            await self.client.solution_configurations.begin_sync_now(
                resource_uri="str",
                solution_configuration="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
