# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`ssh`](#ssh): This class manages ssh client and server
* [`ssh::client`](#ssh--client): This class add ssh client management
* [`ssh::hostkeys`](#ssh--hostkeys): This class manages hostkeys
* [`ssh::knownhosts`](#ssh--knownhosts): This class manages knownhosts if collection is enabled.
* [`ssh::server`](#ssh--server): This class managed ssh server

#### Private Classes

* `ssh::client::config`: Manages ssh configuration
* `ssh::client::install`: Install ssh client package
* `ssh::server::config`: Managed ssh server configuration
* `ssh::server::install`: Install ssh server package
* `ssh::server::service`: This class managed ssh server service

### Defined types

* [`ssh::client::config::user`](#ssh--client--config--user): This defined type manages a users ssh config
* [`ssh::client::match_block`](#ssh--client--match_block): Add match_block to ssh client config (concat needed)
* [`ssh::server::config::setting`](#ssh--server--config--setting): Internal define to managed ssh server param
* [`ssh::server::config_file`](#ssh--server--config_file): Resource type for managing a config file in the include dir.
* [`ssh::server::host_key`](#ssh--server--host_key): Manage a ssh host key

This module install a ssh host key in the server (basically, it is
a file resource but it also notifies to the ssh service)

Important! This define does not modify any option in sshd_config, so
you have to manually define the HostKey option in the server options
if you haven't done yet.
* [`ssh::server::instances`](#ssh--server--instances): Configure separate ssh server instances
* [`ssh::server::match_block`](#ssh--server--match_block): Add match_block to ssh server config
* [`ssh::server::options`](#ssh--server--options): This defined type manages ssh server options

### Functions

#### Public Functions

* [`sshclient_options_to_augeas_ssh_config`](#sshclient_options_to_augeas_ssh_config): This function will convert a key-value hash to a format understandable by the augeas sshd_config provider It will also optionally deal with k
* [`sshserver_options_to_augeas_sshd_config`](#sshserver_options_to_augeas_sshd_config): This function will convert a key-value hash to a format understandable by the augeas sshd_config provider It will also optionally deal with k

#### Private Functions

* `ssh::ipaddresses`: Returns ip addresses of network interfaces (except lo) found by facter.

### Data types

* [`Ssh::ClientMatch`](#Ssh--ClientMatch): OpenSSH client `Match` criteria. See `ssh_config(5)`

## Classes

### <a name="ssh"></a>`ssh`

}

#### Examples

##### Puppet usage

```puppet
class { 'ssh':
  storeconfigs_enabled         => false,
  server_options               => {
    'Match User www-data'      => {
      'ChrootDirectory'        => '%h',
      'ForceCommand'           => 'internal-sftp',
      'PasswordAuthentication' => 'yes',
      'AllowTcpForwarding'     => 'no',
      'X11Forwarding'          => 'no',
    },
    'Port'                     => [22, 2222, 2288],
  },
  client_options               => {
    'Host *.amazonaws.com'     => {
      'User'                   => 'ec2-user',
    },
  },
  users_client_options         => {
    'bob'                      => {
      options                  => {
        'Host *.alice.fr'      => {
          'User'               => 'alice',
        },
      },
    },
  },
 'server_instances' => {
   'sftp_server_init' => {
     'ensure' => 'present',
     'options' => {
       'sshd_config' => {
         'Port' => 8022,
         'Protocol' => 2,
         'AddressFamily' => 'any',
         'HostKey' => '/etc/ssh/ssh_host_rsa_key',
         'SyslogFacility' => 'AUTH',
         'LogLevel' => 'INFO',
         'PermitRootLogin' => 'no',
       },
       'sshd_service_options' => '',
       'match_blocks' => {
         '*,!ssh_exempt_ldap_authkey,!sshlokey' => {
           'type' => 'group',
           'options' => {
             'AuthorizedKeysCommand' => '/usr/local/bin/getauthkey',
             'AuthorizedKeysCommandUser' => 'nobody',
             'AuthorizedKeysFile' => '/dev/null',
           },
         },
       },
     },
   },
 },
```

##### hiera usage

```puppet
ssh::storeconfigs_enabled: true

ssh::server_options:
    Protocol: '2'
    ListenAddress:
        - '127.0.0.0'
        - '%{::hostname}'
    PasswordAuthentication: 'yes'
    SyslogFacility: 'AUTHPRIV'
    UsePAM: 'yes'
    X11Forwarding: 'yes'

ssh::server::match_block:
  filetransfer:
    type: group
    options:
      ChrootDirectory: /home/sftp
      ForceCommand: internal-sftp

ssh::client_options:
    'Host *':
        SendEnv: 'LANG LC_*'
        ForwardX11Trusted: 'yes'
        ServerAliveInterval: '10'

ssh::users_client_options:
    'bob':
        'options':
            'Host *.alice.fr':
                'User': 'alice'
                'PasswordAuthentication': 'no'
 ssh::server::server_instances:
    sftp_server_init:
      ensure: present
      options:
        sshd_config:
         Port: 8022
         Protocol: 2
         AddressFamily: 'any'
         HostKey: '/etc/ssh/ssh_host_rsa_key'
         SyslogFacility: 'AUTH'
         LogLevel: INFO
         PermitRootLogin: 'no'
      sshd_service_options: ''
      match_blocks:
        '*,!ssh_exempt_ldap_authkey,!sshlokey':
           type: group
           options:
             AuthorizedKeysCommand: '/usr/local/bin/getauthkey'
             AuthorizedKeysCommandUser: 'nobody'
             AuthorizedKeysFile: '/dev/null'
```

#### Parameters

The following parameters are available in the `ssh` class:

* [`server_options`](#-ssh--server_options)
* [`server_match_block`](#-ssh--server_match_block)
* [`client_options`](#-ssh--client_options)
* [`client_match_block`](#-ssh--client_match_block)
* [`users_client_options`](#-ssh--users_client_options)
* [`version`](#-ssh--version)
* [`storeconfigs_enabled`](#-ssh--storeconfigs_enabled)
* [`validate_sshd_file`](#-ssh--validate_sshd_file)
* [`use_augeas`](#-ssh--use_augeas)
* [`server_options_absent`](#-ssh--server_options_absent)
* [`client_options_absent`](#-ssh--client_options_absent)
* [`use_issue_net`](#-ssh--use_issue_net)
* [`purge_unmanaged_sshkeys`](#-ssh--purge_unmanaged_sshkeys)
* [`server_instances`](#-ssh--server_instances)

##### <a name="-ssh--server_options"></a>`server_options`

Data type: `Optional[Hash]`

Add dynamic options for ssh server config

Default value: `undef`

##### <a name="-ssh--server_match_block"></a>`server_match_block`

Data type: `Hash`

Add match block for ssh server config

Default value: `{}`

##### <a name="-ssh--client_options"></a>`client_options`

Data type: `Optional[Hash]`

Add dynamic options for ssh client config

Default value: `undef`

##### <a name="-ssh--client_match_block"></a>`client_match_block`

Data type: `Hash`

Add match block for ssh client config

Default value: `{}`

##### <a name="-ssh--users_client_options"></a>`users_client_options`

Data type: `Hash`

Add users options for ssh client config

Default value: `{}`

##### <a name="-ssh--version"></a>`version`

Data type: `String`

Define package version (package ressource)

Default value: `'present'`

##### <a name="-ssh--storeconfigs_enabled"></a>`storeconfigs_enabled`

Data type: `Boolean`

Default value for storeconfigs_enabled (client and server)

Default value: `true`

##### <a name="-ssh--validate_sshd_file"></a>`validate_sshd_file`

Data type: `Boolean`

Default value for validate_sshd_file (server)

Default value: `false`

##### <a name="-ssh--use_augeas"></a>`use_augeas`

Data type: `Boolean`

Default value to use augeas (client and server)

Default value: `false`

##### <a name="-ssh--server_options_absent"></a>`server_options_absent`

Data type: `Array`

List of options to remove for server config (augeas only)

Default value: `[]`

##### <a name="-ssh--client_options_absent"></a>`client_options_absent`

Data type: `Array`

List of options to remove for client config (augeas only)

Default value: `[]`

##### <a name="-ssh--use_issue_net"></a>`use_issue_net`

Data type: `Boolean`

Use issue_net header

Default value: `false`

##### <a name="-ssh--purge_unmanaged_sshkeys"></a>`purge_unmanaged_sshkeys`

Data type: `Boolean`

Purge unmanaged sshkeys

Default value: `true`

##### <a name="-ssh--server_instances"></a>`server_instances`

Data type: `Hash[String[1],Hash[String[1],NotUndef]]`

Configure SSH instances

Default value: `{}`

### <a name="ssh--client"></a>`ssh::client`

This class add ssh client management

#### Examples

##### Puppet usage

```puppet
class { 'ssh::client':
  ensure               => present,
  storeconfigs_enabled => true,
  use_augeas           => false,
}
```

#### Parameters

The following parameters are available in the `ssh::client` class:

* [`ssh_config`](#-ssh--client--ssh_config)
* [`client_package_name`](#-ssh--client--client_package_name)
* [`ensure`](#-ssh--client--ensure)
* [`storeconfigs_enabled`](#-ssh--client--storeconfigs_enabled)
* [`options`](#-ssh--client--options)
* [`use_augeas`](#-ssh--client--use_augeas)
* [`options_absent`](#-ssh--client--options_absent)
* [`default_options`](#-ssh--client--default_options)
* [`match_block`](#-ssh--client--match_block)

##### <a name="-ssh--client--ssh_config"></a>`ssh_config`

Data type: `Stdlib::Absolutepath`

Path to ssh client config file

##### <a name="-ssh--client--client_package_name"></a>`client_package_name`

Data type: `Optional[String[1]]`

Name of the client package

Default value: `undef`

##### <a name="-ssh--client--ensure"></a>`ensure`

Data type: `String`

Ensurable param to ssh client

Default value: `present`

##### <a name="-ssh--client--storeconfigs_enabled"></a>`storeconfigs_enabled`

Data type: `Boolean`

Collected host keys from servers will be written to known_hosts unless storeconfigs_enabled is false

Default value: `true`

##### <a name="-ssh--client--options"></a>`options`

Data type: `Hash`

SSH client options, will be deep_merged with default_options. This parameter takes precedence over default_options

Default value: `{}`

##### <a name="-ssh--client--use_augeas"></a>`use_augeas`

Data type: `Boolean`

Use augeas to configure ssh client

Default value: `false`

##### <a name="-ssh--client--options_absent"></a>`options_absent`

Data type: `Array`

Remove options (with augeas style)

Default value: `[]`

##### <a name="-ssh--client--default_options"></a>`default_options`

Data type: `Hash`

Default options to set, will be merged with options parameter

##### <a name="-ssh--client--match_block"></a>`match_block`

Data type: `Hash`

Add ssh match_block (with concat)

Default value: `{}`

### <a name="ssh--hostkeys"></a>`ssh::hostkeys`

This class manages hostkeys

#### Parameters

The following parameters are available in the `ssh::hostkeys` class:

* [`export_ipaddresses`](#-ssh--hostkeys--export_ipaddresses)
* [`storeconfigs_group`](#-ssh--hostkeys--storeconfigs_group)
* [`extra_aliases`](#-ssh--hostkeys--extra_aliases)
* [`exclude_interfaces`](#-ssh--hostkeys--exclude_interfaces)
* [`exclude_interfaces_re`](#-ssh--hostkeys--exclude_interfaces_re)
* [`exclude_ipaddresses`](#-ssh--hostkeys--exclude_ipaddresses)
* [`use_trusted_facts`](#-ssh--hostkeys--use_trusted_facts)
* [`tags`](#-ssh--hostkeys--tags)

##### <a name="-ssh--hostkeys--export_ipaddresses"></a>`export_ipaddresses`

Data type: `Boolean`

Whether ip addresses should be added as aliases

Default value: `true`

##### <a name="-ssh--hostkeys--storeconfigs_group"></a>`storeconfigs_group`

Data type: `Optional[String[1]]`

Tag hostkeys with this group to allow segregation

Default value: `undef`

##### <a name="-ssh--hostkeys--extra_aliases"></a>`extra_aliases`

Data type: `Array`

Additional aliases to set for host keys

Default value: `[]`

##### <a name="-ssh--hostkeys--exclude_interfaces"></a>`exclude_interfaces`

Data type: `Array`

List of interfaces to exclude

Default value: `[]`

##### <a name="-ssh--hostkeys--exclude_interfaces_re"></a>`exclude_interfaces_re`

Data type: `Array`

List of regular expressions to exclude interfaces

Default value: `[]`

##### <a name="-ssh--hostkeys--exclude_ipaddresses"></a>`exclude_ipaddresses`

Data type: `Array`

List of ip addresses to exclude

Default value: `[]`

##### <a name="-ssh--hostkeys--use_trusted_facts"></a>`use_trusted_facts`

Data type: `Boolean`

Whether to use trusted or normal facts

Default value: `false`

##### <a name="-ssh--hostkeys--tags"></a>`tags`

Data type: `Optional[Array[String[1]]]`

Array of custom tags

Default value: `undef`

### <a name="ssh--knownhosts"></a>`ssh::knownhosts`

This class manages knownhosts if collection is enabled.

#### Parameters

The following parameters are available in the `ssh::knownhosts` class:

* [`collect_enabled`](#-ssh--knownhosts--collect_enabled)
* [`storeconfigs_group`](#-ssh--knownhosts--storeconfigs_group)

##### <a name="-ssh--knownhosts--collect_enabled"></a>`collect_enabled`

Data type: `Boolean`

Enable collection

Default value: `$ssh::knownhosts::collect_enabled`

##### <a name="-ssh--knownhosts--storeconfigs_group"></a>`storeconfigs_group`

Data type: `Optional[String[1]]`

Define the hostkeys group storage

Default value: `undef`

### <a name="ssh--server"></a>`ssh::server`

This class managed ssh server

#### Examples

##### Puppet usage

```puppet
class { 'ssh::server':
  ensure               => present,
  storeconfigs_enabled => true,
  use_issue_net        => false,
}
```

#### Parameters

The following parameters are available in the `ssh::server` class:

* [`service_name`](#-ssh--server--service_name)
* [`sshd_config`](#-ssh--server--sshd_config)
* [`sshd_dir`](#-ssh--server--sshd_dir)
* [`sshd_binary`](#-ssh--server--sshd_binary)
* [`sshd_config_mode`](#-ssh--server--sshd_config_mode)
* [`host_priv_key_group`](#-ssh--server--host_priv_key_group)
* [`default_options`](#-ssh--server--default_options)
* [`ensure`](#-ssh--server--ensure)
* [`include_dir`](#-ssh--server--include_dir)
* [`include_dir_mode`](#-ssh--server--include_dir_mode)
* [`include_dir_purge`](#-ssh--server--include_dir_purge)
* [`config_files`](#-ssh--server--config_files)
* [`storeconfigs_enabled`](#-ssh--server--storeconfigs_enabled)
* [`options`](#-ssh--server--options)
* [`validate_sshd_file`](#-ssh--server--validate_sshd_file)
* [`use_augeas`](#-ssh--server--use_augeas)
* [`options_absent`](#-ssh--server--options_absent)
* [`match_block`](#-ssh--server--match_block)
* [`use_issue_net`](#-ssh--server--use_issue_net)
* [`sshd_environments_file`](#-ssh--server--sshd_environments_file)
* [`server_package_name`](#-ssh--server--server_package_name)

##### <a name="-ssh--server--service_name"></a>`service_name`

Data type: `String[1]`

Name of the sshd service

##### <a name="-ssh--server--sshd_config"></a>`sshd_config`

Data type: `Stdlib::Absolutepath`

Path to the sshd_config file

##### <a name="-ssh--server--sshd_dir"></a>`sshd_dir`

Data type: `Stdlib::Absolutepath`

Path to the sshd dir (e.g. /etc/ssh)

##### <a name="-ssh--server--sshd_binary"></a>`sshd_binary`

Data type: `Stdlib::Absolutepath`

Path to the sshd binary

##### <a name="-ssh--server--sshd_config_mode"></a>`sshd_config_mode`

Data type: `Stdlib::Filemode`

Mode to set on the sshd config file

##### <a name="-ssh--server--host_priv_key_group"></a>`host_priv_key_group`

Data type: `Integer`

Name of the group for the private host key

##### <a name="-ssh--server--default_options"></a>`default_options`

Data type: `Hash`

Default options to set, will be merged with options parameter

##### <a name="-ssh--server--ensure"></a>`ensure`

Data type: `Enum[present,absent,latest]`

Ensurable param to ssh server

Default value: `present`

##### <a name="-ssh--server--include_dir"></a>`include_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Path to sshd include directory.

Default value: `undef`

##### <a name="-ssh--server--include_dir_mode"></a>`include_dir_mode`

Data type: `Stdlib::Filemode`

Mode to set on the sshd include directory.

Default value: `'0700'`

##### <a name="-ssh--server--include_dir_purge"></a>`include_dir_purge`

Data type: `Boolean`

Purge the include directory if true.

Default value: `true`

##### <a name="-ssh--server--config_files"></a>`config_files`

Data type: `Hash[String, Hash]`

Hash of config files to add to the ssh include directory.

Default value: `{}`

##### <a name="-ssh--server--storeconfigs_enabled"></a>`storeconfigs_enabled`

Data type: `Boolean`

Host keys will be collected and distributed unless storeconfigs_enabled is false.

Default value: `true`

##### <a name="-ssh--server--options"></a>`options`

Data type: `Hash`

Dynamic hash for openssh server option

Default value: `{}`

##### <a name="-ssh--server--validate_sshd_file"></a>`validate_sshd_file`

Data type: `Boolean`

Add sshd file validate cmd

Default value: `false`

##### <a name="-ssh--server--use_augeas"></a>`use_augeas`

Data type: `Boolean`

Use augeas for configuration (default concat)

Default value: `false`

##### <a name="-ssh--server--options_absent"></a>`options_absent`

Data type: `Array`

Remove options (with augeas style)

Default value: `[]`

##### <a name="-ssh--server--match_block"></a>`match_block`

Data type: `Hash`

Add sshd match_block (with concat)

Default value: `{}`

##### <a name="-ssh--server--use_issue_net"></a>`use_issue_net`

Data type: `Boolean`

Add issue_net banner

Default value: `false`

##### <a name="-ssh--server--sshd_environments_file"></a>`sshd_environments_file`

Data type: `Optional[Stdlib::Absolutepath]`

Path to a sshd environments file (e.g. /etc/defaults/ssh on Debian)

Default value: `undef`

##### <a name="-ssh--server--server_package_name"></a>`server_package_name`

Data type: `Optional[String[1]]`

Name of the server package to install

Default value: `undef`

## Defined types

### <a name="ssh--client--config--user"></a>`ssh::client::config::user`

Copyright (c) IN2P3 Computing Centre, IN2P3, CNRS
Contributor: Remi Ferrand <remi{dot}ferrand_at_cc(dot)in2p3.fr> (2015)
Contributor: Tim Meusel <tim@bastelfreak.de> (2017)

#### Parameters

The following parameters are available in the `ssh::client::config::user` defined type:

* [`ensure`](#-ssh--client--config--user--ensure)
* [`target`](#-ssh--client--config--user--target)
* [`user_home_dir`](#-ssh--client--config--user--user_home_dir)
* [`manage_user_ssh_dir`](#-ssh--client--config--user--manage_user_ssh_dir)
* [`options`](#-ssh--client--config--user--options)
* [`user`](#-ssh--client--config--user--user)
* [`ssh_directory_default_mode`](#-ssh--client--config--user--ssh_directory_default_mode)
* [`ssh_config_default_mode`](#-ssh--client--config--user--ssh_config_default_mode)

##### <a name="-ssh--client--config--user--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Specifies whether the config file should be present or absent

Default value: `present`

##### <a name="-ssh--client--config--user--target"></a>`target`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the config file location, defaults to `~/.ssh/config` if $target and $user_home_dir are not set

Default value: `undef`

##### <a name="-ssh--client--config--user--user_home_dir"></a>`user_home_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the location of users home dir, defaults to `/home/$user`

Default value: `undef`

##### <a name="-ssh--client--config--user--manage_user_ssh_dir"></a>`manage_user_ssh_dir`

Data type: `Boolean`

Whether the users ssh dir should be managed or not

Default value: `true`

##### <a name="-ssh--client--config--user--options"></a>`options`

Data type: `Hash`

Options which should be set

Default value: `{}`

##### <a name="-ssh--client--config--user--user"></a>`user`

Data type: `String[1]`

The name of the user the config should be managed for

Default value: `$name`

##### <a name="-ssh--client--config--user--ssh_directory_default_mode"></a>`ssh_directory_default_mode`

Data type: `String[1]`

Default mode for the users ssh dir

Default value: `'0700'`

##### <a name="-ssh--client--config--user--ssh_config_default_mode"></a>`ssh_config_default_mode`

Data type: `String[1]`

Default mode for the ssh config file

Default value: `'0600'`

### <a name="ssh--client--match_block"></a>`ssh::client::match_block`

Add match_block to ssh client config (concat needed)

#### Parameters

The following parameters are available in the `ssh::client::match_block` defined type:

* [`options`](#-ssh--client--match_block--options)
* [`type`](#-ssh--client--match_block--type)
* [`order`](#-ssh--client--match_block--order)
* [`target`](#-ssh--client--match_block--target)

##### <a name="-ssh--client--match_block--options"></a>`options`

Data type: `Hash`

Options which should be set

Default value: `{}`

##### <a name="-ssh--client--match_block--type"></a>`type`

Data type: `Ssh::ClientMatch`

Type of match_block, e.g. user, group, host, ...

Default value: `'user'`

##### <a name="-ssh--client--match_block--order"></a>`order`

Data type: `Integer`

Orders your settings within the config file

Default value: `50`

##### <a name="-ssh--client--match_block--target"></a>`target`

Data type: `Stdlib::Absolutepath`

Sets the target file of the concat fragment

Default value: `$ssh::client::ssh_config`

### <a name="ssh--server--config--setting"></a>`ssh::server::config::setting`

Internal define to managed ssh server param

#### Parameters

The following parameters are available in the `ssh::server::config::setting` defined type:

* [`key`](#-ssh--server--config--setting--key)
* [`value`](#-ssh--server--config--setting--value)
* [`order`](#-ssh--server--config--setting--order)

##### <a name="-ssh--server--config--setting--key"></a>`key`

Data type: `String[1]`

Key of the value which should be set

##### <a name="-ssh--server--config--setting--value"></a>`value`

Data type: `Variant[Boolean, Array, Hash, String]`

Value which should be set

##### <a name="-ssh--server--config--setting--order"></a>`order`

Data type: `Variant[String[1], Integer]`

Orders your setting within the config file

Default value: `'10'`

### <a name="ssh--server--config_file"></a>`ssh::server::config_file`

Resource type for managing a config file in the include dir.

#### Parameters

The following parameters are available in the `ssh::server::config_file` defined type:

* [`mode`](#-ssh--server--config_file--mode)
* [`include`](#-ssh--server--config_file--include)
* [`options`](#-ssh--server--config_file--options)
* [`path`](#-ssh--server--config_file--path)

##### <a name="-ssh--server--config_file--mode"></a>`mode`

Data type: `Stdlib::Filemode`

File mode for the config file.

Default value: `$ssh::server::sshd_config_mode`

##### <a name="-ssh--server--config_file--include"></a>`include`

Data type: `Optional[Stdlib::Absolutepath]`

Absolute path to config file to include at the top of the config file. This
is intended for including files not managed by this module (crypto policies).

Default value: `undef`

##### <a name="-ssh--server--config_file--options"></a>`options`

Data type: `Hash`

Dynamic hash for openssh server option

Default value: `{}`

##### <a name="-ssh--server--config_file--path"></a>`path`

Data type: `Stdlib::Absolutepath`



Default value: `"${ssh::server::include_dir}/${name}.conf"`

### <a name="ssh--server--host_key"></a>`ssh::server::host_key`

Manage a ssh host key

This module install a ssh host key in the server (basically, it is
a file resource but it also notifies to the ssh service)

Important! This define does not modify any option in sshd_config, so
you have to manually define the HostKey option in the server options
if you haven't done yet.

#### Parameters

The following parameters are available in the `ssh::server::host_key` defined type:

* [`ensure`](#-ssh--server--host_key--ensure)
* [`public_key_source`](#-ssh--server--host_key--public_key_source)
* [`public_key_content`](#-ssh--server--host_key--public_key_content)
* [`private_key_source`](#-ssh--server--host_key--private_key_source)
* [`private_key_content`](#-ssh--server--host_key--private_key_content)
* [`certificate_source`](#-ssh--server--host_key--certificate_source)
* [`certificate_content`](#-ssh--server--host_key--certificate_content)

##### <a name="-ssh--server--host_key--ensure"></a>`ensure`

Data type: `Enum[present, absent]`

Set to 'absent' to remove host_key files

Default value: `'present'`

##### <a name="-ssh--server--host_key--public_key_source"></a>`public_key_source`

Data type: `Optional[String[1]]`

Sets the content of the source parameter for the public key file
Note public_key_source and public_key_content are mutually exclusive.

Default value: `undef`

##### <a name="-ssh--server--host_key--public_key_content"></a>`public_key_content`

Data type: `Optional[String[1]]`

Sets the content for the public key file.
Note public_key_source and public_key_content are mutually exclusive.

Default value: `undef`

##### <a name="-ssh--server--host_key--private_key_source"></a>`private_key_source`

Data type: `Optional[String[1]]`

Sets the content of the source parameter for the private key file
Note private_key_source and private_key_content are mutually exclusive.

Default value: `undef`

##### <a name="-ssh--server--host_key--private_key_content"></a>`private_key_content`

Data type: `Optional[String[1]]`

Sets the content for the private key file.
Note private_key_source and private_key_content are mutually exclusive.

Default value: `undef`

##### <a name="-ssh--server--host_key--certificate_source"></a>`certificate_source`

Data type: `Optional[String[1]]`

Sets the content of the source parameter for the host key certificate.
Note certificate_source and certificate_content are mutually exclusive.

Default value: `undef`

##### <a name="-ssh--server--host_key--certificate_content"></a>`certificate_content`

Data type: `Optional[String[1]]`

Sets the content for the host key certificate.
Note certificate_source and certificate_content are mutually exclusive.

Default value: `undef`

### <a name="ssh--server--instances"></a>`ssh::server::instances`

Configure separate ssh server instances

#### Parameters

The following parameters are available in the `ssh::server::instances` defined type:

* [`ensure`](#-ssh--server--instances--ensure)
* [`options`](#-ssh--server--instances--options)
* [`service_ensure`](#-ssh--server--instances--service_ensure)
* [`service_enable`](#-ssh--server--instances--service_enable)
* [`validate_config_file`](#-ssh--server--instances--validate_config_file)
* [`sshd_instance_config_file`](#-ssh--server--instances--sshd_instance_config_file)
* [`sshd_binary`](#-ssh--server--instances--sshd_binary)
* [`sshd_environments_file`](#-ssh--server--instances--sshd_environments_file)

##### <a name="-ssh--server--instances--ensure"></a>`ensure`

Data type: `Enum[present, absent]`

Specifies whether the instance should be added or removed

Default value: `present`

##### <a name="-ssh--server--instances--options"></a>`options`

Data type: `Hash`

Set options for the instance

Default value: `{}`

##### <a name="-ssh--server--instances--service_ensure"></a>`service_ensure`

Data type: `Stdlib::Ensure::Service`

Whether this instance service should be running or stopped, defaults to true when ensure is set to present, otherwise false

Default value: `$ensure ? { 'present' => 'running', 'absent' => 'stopped'`

##### <a name="-ssh--server--instances--service_enable"></a>`service_enable`

Data type: `Boolean`

Whether this instance service should be started at boot. Will be added automatically if ensure is running/removed if ensure is stopped

Default value: `($service_ensure == 'running'`

##### <a name="-ssh--server--instances--validate_config_file"></a>`validate_config_file`

Data type: `Boolean`

Validate config file before applying

Default value: `false`

##### <a name="-ssh--server--instances--sshd_instance_config_file"></a>`sshd_instance_config_file`

Data type: `Stdlib::Absolutepath`

Path of the instance sshd config

Default value: `"${ssh::server::sshd_dir}/sshd_config.${title}"`

##### <a name="-ssh--server--instances--sshd_binary"></a>`sshd_binary`

Data type: `Stdlib::Absolutepath`

Path to sshd binary

Default value: `$ssh::server::sshd_binary`

##### <a name="-ssh--server--instances--sshd_environments_file"></a>`sshd_environments_file`

Data type: `Optional[Stdlib::Absolutepath]`

Path to environments file, if any

Default value: `$ssh::server::sshd_environments_file`

### <a name="ssh--server--match_block"></a>`ssh::server::match_block`

Add match_block to ssh server config

#### Parameters

The following parameters are available in the `ssh::server::match_block` defined type:

* [`options`](#-ssh--server--match_block--options)
* [`type`](#-ssh--server--match_block--type)
* [`order`](#-ssh--server--match_block--order)
* [`target`](#-ssh--server--match_block--target)

##### <a name="-ssh--server--match_block--options"></a>`options`

Data type: `Hash`

Options which should be set

Default value: `{}`

##### <a name="-ssh--server--match_block--type"></a>`type`

Data type: `String[1]`

Type of match_block, e.g. user, group, host, ...

Default value: `'user'`

##### <a name="-ssh--server--match_block--order"></a>`order`

Data type: `Integer`

Orders your settings within the config file

Default value: `50`

##### <a name="-ssh--server--match_block--target"></a>`target`

Data type: `Stdlib::Absolutepath`

Sets the target file of the concat fragment

Default value: `$ssh::server::sshd_config`

### <a name="ssh--server--options"></a>`ssh::server::options`

This defined type manages ssh server options

#### Parameters

The following parameters are available in the `ssh::server::options` defined type:

* [`options`](#-ssh--server--options--options)
* [`order`](#-ssh--server--options--order)

##### <a name="-ssh--server--options--options"></a>`options`

Data type: `Hash`

Options which should be set

Default value: `{}`

##### <a name="-ssh--server--options--order"></a>`order`

Data type: `Integer`

Orders your settings within the config file

Default value: `50`

## Functions

### <a name="sshclient_options_to_augeas_ssh_config"></a>`sshclient_options_to_augeas_ssh_config`

Type: Ruby 3.x API

This function will convert a key-value hash to a format understandable by the augeas sshd_config provider
It will also optionally deal with keys that should be absent, and inject static parameters if supplied.

Usage: sshclient_options_to_augeas_ssh_config($options_present, $options_absent, $other_parameters)
-  $options_hash is mandatory and must be a hash.
-  $options_absent is optional and can be either a single value or an array.
-  $other_parameters is optional and must be a hash.

Example:
$options = {
              'Host *.example.com' => {
                 'ForwardAgent' => 'yes',
                 'BatchMode'    => 'yes',
              },
              'ForwardAgent'           => 'no',
              'BatchMode'              => 'no',
              'StrictHostKeyChecking'  => 'no',
           }
$options_absent = ['StrictHostKeyChecking','NoneField']
$other_parameters = { 'target' => '/etc/ssh/ssh_config' }

$options_final_augeas = sshclient_options_to_augeas_ssh_config($options, $options_absent, $other_parameters)

In this case, the value of $options_final_augeas would be:

'ForwardAgent *.example.com' => {
    'ensure'    => 'present',
    'host'      => '*.example.com',
    'key'       => 'ForwardAgent',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'BatchMode *.example.com' => {
    'ensure'    => 'present',
    'host'      => '*.example.com',
    'key'       => 'BatchMode',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'ForwardAgent' => {
    'ensure'    => 'present',
    'key'       => 'ForwardAgent',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'BatchMode' => {
    'ensure'    => 'present',
    'key'       => 'BatchMode',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'StrictHostKeyChecking' => {
    'ensure'    => 'absent',
    'key'       => 'StrictHostKeyChecking',
    'target'    => '/etc/ssh/ssh_config',
 }
 'NoneField' => {
    'ensure'    => 'absent',
    'key'       => 'NoneField',
    'target'    => '/etc/ssh/ssh_config',
 }

Note how the word "Host" is stripped a

#### `sshclient_options_to_augeas_ssh_config()`

This function will convert a key-value hash to a format understandable by the augeas sshd_config provider
It will also optionally deal with keys that should be absent, and inject static parameters if supplied.

Usage: sshclient_options_to_augeas_ssh_config($options_present, $options_absent, $other_parameters)
-  $options_hash is mandatory and must be a hash.
-  $options_absent is optional and can be either a single value or an array.
-  $other_parameters is optional and must be a hash.

Example:
$options = {
              'Host *.example.com' => {
                 'ForwardAgent' => 'yes',
                 'BatchMode'    => 'yes',
              },
              'ForwardAgent'           => 'no',
              'BatchMode'              => 'no',
              'StrictHostKeyChecking'  => 'no',
           }
$options_absent = ['StrictHostKeyChecking','NoneField']
$other_parameters = { 'target' => '/etc/ssh/ssh_config' }

$options_final_augeas = sshclient_options_to_augeas_ssh_config($options, $options_absent, $other_parameters)

In this case, the value of $options_final_augeas would be:

'ForwardAgent *.example.com' => {
    'ensure'    => 'present',
    'host'      => '*.example.com',
    'key'       => 'ForwardAgent',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'BatchMode *.example.com' => {
    'ensure'    => 'present',
    'host'      => '*.example.com',
    'key'       => 'BatchMode',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'ForwardAgent' => {
    'ensure'    => 'present',
    'key'       => 'ForwardAgent',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'BatchMode' => {
    'ensure'    => 'present',
    'key'       => 'BatchMode',
    'value'     => 'yes',
    'target'    => '/etc/ssh/ssh_config',
 }
'StrictHostKeyChecking' => {
    'ensure'    => 'absent',
    'key'       => 'StrictHostKeyChecking',
    'target'    => '/etc/ssh/ssh_config',
 }
 'NoneField' => {
    'ensure'    => 'absent',
    'key'       => 'NoneField',
    'target'    => '/etc/ssh/ssh_config',
 }

Note how the word "Host" is stripped a

Returns: `Any`

### <a name="sshserver_options_to_augeas_sshd_config"></a>`sshserver_options_to_augeas_sshd_config`

Type: Ruby 3.x API

This function will convert a key-value hash to a format understandable by the augeas sshd_config provider
It will also optionally deal with keys that should be absent, and inject static parameters if supplied.

Usage: sshserver_options_to_augeas_sshd_config($options_present, $options_absent, $other_parameters)
-  $options_hash is mandatory and must be a hash.
-  $options_absent is optional and can be either a single value or an array.
-  $other_parameters is optional and must be a hash.

Example:
$options = {
              'Match User www-data' => {
                 'PasswordAuthentication' => 'yes',
                 'X11Forwarding' => 'no',
              },
              'Match Group bamboo' => {
                 'ForcedCommand'  => '/bin/echo hello world',
              },
              'X11Forwarding'          => 'yes',
              'DebianBanner'           => '/etc/banner.net',
              'AllowGroups'            => ["sshgroups", "admins"],
           }
$options_absent = ['DebianBanner','NoneField']
$other_parameters = { 'target' => '/etc/ssh/sshd_config' }

$options_final_augeas = sshserver_options_to_augeas_sshd_config($options, $options_absent, $other_parameters)

In this case, the value of $options_final_augeas would be:

'PasswordAuthentication User www-data' => {
    'ensure'    => 'present',
    'condition' => 'User www-data',
    'key'       => 'PasswordAuthentication',
    'value'     => 'yes',
    'target'    => '/etc/ssh/sshd_config',
 }
 'X11Forwarding User www-data' => {
    'ensure'    => 'present',
    'condition' => 'User www-data',
    'key'       => 'X11Forwarding',
    'value'     => 'no',
    'target'    => '/etc/ssh/sshd_config',
 }
 'ForcedCommand Group bamboo' => {
    'ensure'    => 'present',
    'condition' => 'Group bamboo',
    'key'       => 'ForcedCommand',
    'value'     => '/bin/echo hello world',
    'target'    => '/etc/ssh/sshd_config',
 }
 'X11Forwarding' => {
    'ensure'    => 'present',
    'key'       => 'X11Forwarding',
    'value'     => 'yes',
    'target'    => '/etc/ssh/sshd_config',
 }
 'DebianBanner' => {
    'ensure'    => 'absent',
    'key'       => 'DebianBanner',
    'target'    => '/etc/ssh/sshd_config',
 }
 'AllowGroups' => {
    'ensure'    => 'present',
    'key'       => 'AllowGroups',
    'value'     => ['sshgroups','admins'],
    'target'    => '/etc/ssh/sshd_config',
 }
 'NoneField' => {
    'ensure'    => 'absent',
    'key'       => 'NoneField',
    'target'    => '/etc/ssh/sshd_config',
 }

Note how the word "Match" is stripped a

#### `sshserver_options_to_augeas_sshd_config()`

This function will convert a key-value hash to a format understandable by the augeas sshd_config provider
It will also optionally deal with keys that should be absent, and inject static parameters if supplied.

Usage: sshserver_options_to_augeas_sshd_config($options_present, $options_absent, $other_parameters)
-  $options_hash is mandatory and must be a hash.
-  $options_absent is optional and can be either a single value or an array.
-  $other_parameters is optional and must be a hash.

Example:
$options = {
              'Match User www-data' => {
                 'PasswordAuthentication' => 'yes',
                 'X11Forwarding' => 'no',
              },
              'Match Group bamboo' => {
                 'ForcedCommand'  => '/bin/echo hello world',
              },
              'X11Forwarding'          => 'yes',
              'DebianBanner'           => '/etc/banner.net',
              'AllowGroups'            => ["sshgroups", "admins"],
           }
$options_absent = ['DebianBanner','NoneField']
$other_parameters = { 'target' => '/etc/ssh/sshd_config' }

$options_final_augeas = sshserver_options_to_augeas_sshd_config($options, $options_absent, $other_parameters)

In this case, the value of $options_final_augeas would be:

'PasswordAuthentication User www-data' => {
    'ensure'    => 'present',
    'condition' => 'User www-data',
    'key'       => 'PasswordAuthentication',
    'value'     => 'yes',
    'target'    => '/etc/ssh/sshd_config',
 }
 'X11Forwarding User www-data' => {
    'ensure'    => 'present',
    'condition' => 'User www-data',
    'key'       => 'X11Forwarding',
    'value'     => 'no',
    'target'    => '/etc/ssh/sshd_config',
 }
 'ForcedCommand Group bamboo' => {
    'ensure'    => 'present',
    'condition' => 'Group bamboo',
    'key'       => 'ForcedCommand',
    'value'     => '/bin/echo hello world',
    'target'    => '/etc/ssh/sshd_config',
 }
 'X11Forwarding' => {
    'ensure'    => 'present',
    'key'       => 'X11Forwarding',
    'value'     => 'yes',
    'target'    => '/etc/ssh/sshd_config',
 }
 'DebianBanner' => {
    'ensure'    => 'absent',
    'key'       => 'DebianBanner',
    'target'    => '/etc/ssh/sshd_config',
 }
 'AllowGroups' => {
    'ensure'    => 'present',
    'key'       => 'AllowGroups',
    'value'     => ['sshgroups','admins'],
    'target'    => '/etc/ssh/sshd_config',
 }
 'NoneField' => {
    'ensure'    => 'absent',
    'key'       => 'NoneField',
    'target'    => '/etc/ssh/sshd_config',
 }

Note how the word "Match" is stripped a

Returns: `Any`

## Data types

### <a name="Ssh--ClientMatch"></a>`Ssh::ClientMatch`

OpenSSH client `Match` criteria. See `ssh_config(5)`

Alias of `Enum['!all', 'all', '!canonical', 'canonical', '!exec', 'exec', '!final', 'final', '!host', 'host', '!localuser', 'localuser', '!originalhost', 'originalhost', '!user', 'user']`

