let all = [
  "CURLE_OK";
  "CURLE_UNSUPPORTED_PROTOCOL";
  "CURLE_FAILED_INIT";
  "CURLE_URL_MALFORMAT";
  "CURLE_URL_MALFORMAT_USER";
  "CURLE_COULDNT_RESOLVE_PROXY";
  "CURLE_COULDNT_RESOLVE_HOST";
  "CURLE_COULDNT_CONNECT";
  "CURLE_FTP_WEIRD_SERVER_REPLY";
  "CURLE_FTP_ACCESS_DENIED";
  "CURLE_FTP_USER_PASSWORD_INCORRECT";
  "CURLE_FTP_WEIRD_PASS_REPLY";
  "CURLE_FTP_WEIRD_USER_REPLY";
  "CURLE_FTP_WEIRD_PASV_REPLY";
  "CURLE_FTP_WEIRD_227_FORMAT";
  "CURLE_FTP_CANT_GET_HOST";
  "CURLE_FTP_CANT_RECONNECT";
  "CURLE_FTP_COULDNT_SET_BINARY";
  "CURLE_PARTIAL_FILE";
  "CURLE_FTP_COULDNT_RETR_FILE";
  "CURLE_FTP_WRITE_ERROR";
  "CURLE_FTP_QUOTE_ERROR";
  "CURLE_HTTP_RETURNED_ERROR";
  "CURLE_WRITE_ERROR";
  "CURLE_MALFORMAT_USER";
  "CURLE_FTP_COULDNT_STOR_FILE";
  "CURLE_READ_ERROR";
  "CURLE_OUT_OF_MEMORY";
  "CURLE_OPERATION_TIMEOUTED";
  "CURLE_FTP_COULDNT_SET_ASCII";
  "CURLE_FTP_PORT_FAILED";
  "CURLE_FTP_COULDNT_USE_REST";
  "CURLE_FTP_COULDNT_GET_SIZE";
  "CURLE_HTTP_RANGE_ERROR";
  "CURLE_HTTP_POST_ERROR";
  "CURLE_SSL_CONNECT_ERROR";
  "CURLE_BAD_DOWNLOAD_RESUME";
  "CURLE_FILE_COULDNT_READ_FILE";
  "CURLE_LDAP_CANNOT_BIND";
  "CURLE_LDAP_SEARCH_FAILED";
  "CURLE_LIBRARY_NOT_FOUND";
  "CURLE_FUNCTION_NOT_FOUND";
  "CURLE_ABORTED_BY_CALLBACK";
  "CURLE_BAD_FUNCTION_ARGUMENT";
  "CURLE_BAD_CALLING_ORDER";
  "CURLE_INTERFACE_FAILED";
  "CURLE_BAD_PASSWORD_ENTERED";
  "CURLE_TOO_MANY_REDIRECTS";
  "CURLE_UNKNOWN_TELNET_OPTION";
  "CURLE_TELNET_OPTION_SYNTAX";
  "CURLE_SSL_PEER_CERTIFICATE";
  "CURLE_GOT_NOTHING";
  "CURLE_SSL_ENGINE_NOTFOUND";
  "CURLE_SSL_ENGINE_SETFAILED";
  "CURLE_SEND_ERROR";
  "CURLE_RECV_ERROR";
  "CURLE_SHARE_IN_USE";
  "CURLE_SSL_CERTPROBLEM";
  "CURLE_SSL_CIPHER";
  "CURLE_SSL_CACERT";
  "CURLE_BAD_CONTENT_ENCODING";
  "CURLE_LDAP_INVALID_URL";
  "CURLE_FILESIZE_EXCEEDED";
  "CURLE_FTP_SSL_FAILED";
  "CURLE_SEND_FAIL_REWIND";
  "CURLE_SSL_ENGINE_INITFAILED";
  "CURLE_LOGIN_DENIED";
  "CURLE_TFTP_NOTFOUND";
  "CURLE_TFTP_PERM";
  "CURLE_REMOTE_DISK_FULL";
  "CURLE_TFTP_ILLEGAL";
  "CURLE_TFTP_UNKNOWNID";
  "CURLE_REMOTE_FILE_EXISTS";
  "CURLE_TFTP_NOSUCHUSER";
  "CURLE_CONV_FAILED";
  "CURLE_CONV_REQD";
  "CURLE_SSL_CACERT_BADFILE";
  "CURLE_REMOTE_FILE_NOT_FOUND";
  "CURLE_SSH";
  "CURLE_SSL_SHUTDOWN_FAILED";
  "CURLE_AGAIN";
]

let pr fmt = Printf.ksprintf print_endline fmt

let () =
  match List.tl @@ Array.to_list @@ Sys.argv with
  | [] | "c"::[] ->
    all |> List.iteri begin fun i s ->
      match s with
      | "CURLE_OK" ->
        pr "    {\"%s\", %s}," s s
      | _ ->
        pr "#if HAVE_DECL_%s" s;
        pr "#if %s != %d" s i;
        pr "#warning error code mismatch: %s != %d" s i;
        pr "#endif";
        pr "    {\"%s\", %s}," s s;
        pr "#else";
        pr "    {\"%s\", -1}," s;
        pr"#endif";
    end
  | "ml"::[] -> all |> List.iter (pr "  | %s")
  | "configure"::[] ->
    Format.set_margin 80;
    Format.open_box 0;
    all |> List.iter (function "CURLE_OK" -> () | s -> Format.printf "%s,@ " s);
    Format.close_box ();
  | _ -> failwith "bad usage"
