/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var Complex128 = require( '@stdlib/complex/float64' );
var randu = require( '@stdlib/random/base/randu' );
var round = require( './../../../../base/special/round' );
var real = require( '@stdlib/complex/real' );
var imag = require( '@stdlib/complex/imag' );
var csub = require( './../lib' );

var re;
var im;
var z1;
var z2;
var z3;
var o;
var i;

for ( i = 0; i < 100; i++ ) {
	re = round( randu()*100.0 ) - 50.0;
	im = round( randu()*100.0 ) - 50.0;
	z1 = new Complex128( re, im );

	re = round( randu()*100.0 ) - 50.0;
	im = round( randu()*100.0 ) - 50.0;
	z2 = new Complex128( re, im );

	o = csub( real(z1), imag(z1), real(z2), imag(z2) );
	z3 = new Complex128( o[ 0 ], o[ 1 ] );

	console.log( '(%s) - (%s) = %s', z1.toString(), z2.toString(), z3.toString() );
}
