/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller;

import jarinstaller.ErrorHandler;
import jarinstaller.gui.DebugInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLParser
implements ContentHandler {
    public static final int RESULT_INITIAL_SIZE = 10;
    private boolean debugOn = false;
    private XMLReader xml_r;
    private Vector objectpath = new Vector();
    private Object acttable;
    private Object newtable;
    private boolean root;
    private boolean stepUp;
    private ErrorHandler errorlist = null;
    private StringBuffer datastore = new StringBuffer();

    public XMLParser(ErrorHandler errorlist) {
        this.setErrorlist(errorlist);
        try {
            try {
                this.xml_r = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException e) {
                this.xml_r = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            }
            this.xml_r.setContentHandler(this);
        }
        catch (SAXException e) {
            this.errAdmin("9000", "XML olvas\u00f3 l\u00e9trehoz\u00e1si hiba", e, null);
        }
    }

    public XMLParser(String parser_class, ErrorHandler errorlist) {
        try {
            this.setErrorlist(errorlist);
            this.xml_r = XMLReaderFactory.createXMLReader(parser_class);
            this.xml_r.setContentHandler(this);
        }
        catch (SAXException e) {
            this.errAdmin("9000", "XML olvas\u00f3 l\u00e9trehoz\u00e1si hiba", e, parser_class);
        }
    }

    public Object parse(InputSource input) throws SAXException, IOException {
        this.xml_r.parse(input);
        return this.objectpath.firstElement();
    }

    public Object parse(String uri) {
        InputSource input = new InputSource();
        input.setSystemId(uri);
        try {
            return this.parse(input);
        }
        catch (IOException e) {
            this.errAdmin("9001", "Sikertelen az \u00e1llom\u00e1ny beolvas\u00e1sa", e, uri);
        }
        catch (SAXException e) {
            this.errAdmin("9003", "Sikertelen az \u00e1llom\u00e1ny beolvas\u00e1sa", e, uri);
        }
        return null;
    }

    public Object parse(byte[] source) {
        InputSource input = new InputSource();
        input.setByteStream(new ByteArrayInputStream(source));
        try {
            return this.parse(input);
        }
        catch (IOException e) {
            this.errAdmin("9008", "XML olvas\u00f3 ind\u00edt\u00e1si hiba", e, source);
        }
        catch (SAXException e) {
            this.errAdmin("9009", "Sikertelen az \u00e1llom\u00e1ny beolvas\u00e1sa", e, source);
        }
        return null;
    }

    public Object parse(File file) {
        try {
            InputSource input = new InputSource();
            input.setByteStream(new BufferedInputStream(new FileInputStream(file)));
            return this.parse(input);
        }
        catch (IOException e) {
            this.errAdmin("9010", "XML olvas\u00f3 ind\u00edt\u00e1si hiba", e, file.getPath());
        }
        catch (SAXException e) {
            this.errAdmin("9011", "Sikertelen az \u00e1llom\u00e1ny beolvas\u00e1sa", e, file.getPath());
        }
        return null;
    }

    public void setErrorlist(ErrorHandler errorlist) {
        this.errorlist = errorlist;
    }

    public void endDocument() throws SAXException {
        this.log("ed");
    }

    public void startDocument() throws SAXException {
        this.log("sd");
        this.objectpath.removeAllElements();
        this.acttable = new Hashtable(10);
        this.root = true;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = String.valueOf(ch, start, length);
        if (value.trim().length() == 0) {
            return;
        }
        this.datastore.append(value.trim());
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.log("whitesp");
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.log("endPrefixMapping");
    }

    public void skippedEntity(String name) throws SAXException {
        this.log("skippedEntity");
    }

    public void setDocumentLocator(Locator locator) {
        this.log("skippedEntity");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.log("processingInstruction");
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.log("startPrefixMapping");
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.log("endElement-qName:" + qName);
        if (this.datastore.length() > 0) {
            ((Vector)this.acttable).add(this.datastore.toString());
            this.datastore.delete(0, this.datastore.length());
        }
        if (!this.stepUp) {
            this.stepUp = true;
            return;
        }
        if (this.objectpath.size() > 1) {
            this.objectpath.remove(this.objectpath.size() - 1);
            this.acttable = this.objectpath.lastElement();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.datastore.delete(0, this.datastore.length());
        try {
            this.log("startElement-qName:" + qName);
            this.stepUp = true;
            if (atts.getLength() == 0 && this.acttable instanceof Vector) {
                this.stepUp = false;
                return;
            }
            if (!this.root) {
                this.newtable = atts.getLength() == 0 ? new Vector() : new Hashtable(10);
                if (this.acttable instanceof Vector) {
                    ((Vector)this.acttable).add(this.newtable);
                } else {
                    ((Hashtable)this.acttable).put(qName, this.newtable);
                }
                this.acttable = this.newtable;
            }
            this.objectpath.add(this.acttable);
            for (int i = 0; i < atts.getLength(); ++i) {
                Object[] parameters = new Object[]{atts.getValue(i)};
                this.log(atts.getQName(i) + "-" + parameters[0]);
                ((Hashtable)this.acttable).put(atts.getQName(i), parameters[0]);
            }
            this.root = false;
        }
        catch (Exception e) {
            this.errAdmin("9010", "XML Olvas\u00e1si hiba", e, localName);
            throw new SAXException(e);
        }
    }

    public void log(Object msg) {
        if (this.debugOn) {
            DebugInfo.showMessage(msg.toString());
        }
    }

    private String errAdmin(String id, String msg, Exception e, Object o) {
        if (this.debugOn && e != null) {
            e.printStackTrace();
        }
        String errmsg = msg + ":" + (o == null ? "" : o.toString());
        if (this.errorlist != null) {
            try {
                this.errorlist.errAdmin(id, errmsg, null, o);
            }
            catch (Exception err) {}
        } else {
            DebugInfo.showMessage(id + " " + errmsg);
        }
        return id + " " + errmsg;
    }
}

