/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.Binding;
import android.databinding.tool.MergedBinding;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class BindingTarget {
    List<Binding> mBindings = new ArrayList<Binding>();
    ExprModel mModel;
    ModelClass mResolvedClass;
    private ResourceBundle.BindingTargetBundle mBundle;

    public BindingTarget(ResourceBundle.BindingTargetBundle bundle) {
        this.mBundle = bundle;
    }

    public boolean isUsed() {
        return this.mBundle.isUsed();
    }

    public void addBinding(String name, Expr expr) {
        this.mBindings.add(new Binding(this, name, expr));
    }

    public String getInterfaceType() {
        return this.mBundle.getInterfaceType() == null ? this.mBundle.getFullClassName() : this.mBundle.getInterfaceType();
    }

    public String getId() {
        return this.mBundle.getId();
    }

    public String getTag() {
        return this.mBundle.getTag();
    }

    public String getOriginalTag() {
        return this.mBundle.getOriginalTag();
    }

    public String getViewClass() {
        return this.mBundle.getFullClassName();
    }

    public ModelClass getResolvedType() {
        if (this.mResolvedClass == null) {
            this.mResolvedClass = ModelAnalyzer.getInstance().findClass(this.mBundle.getFullClassName(), this.mModel.getImports());
        }
        return this.mResolvedClass;
    }

    public String getIncludedLayout() {
        return this.mBundle.getIncludedLayout();
    }

    public boolean isBinder() {
        return this.getIncludedLayout() != null;
    }

    public boolean supportsTag() {
        return !SetterStore.get(ModelAnalyzer.getInstance()).isUntaggable(this.mBundle.getFullClassName());
    }

    public List<Binding> getBindings() {
        return this.mBindings;
    }

    public ExprModel getModel() {
        return this.mModel;
    }

    public void setModel(ExprModel model) {
        this.mModel = model;
    }

    public void resolveMultiSetters() {
        L.d("resolving multi setters for %s", this.getId());
        SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
        String[] attributes = new String[this.mBindings.size()];
        ModelClass[] types = new ModelClass[this.mBindings.size()];
        for (int i = 0; i < this.mBindings.size(); ++i) {
            Binding binding = this.mBindings.get(i);
            attributes[i] = binding.getName();
            types[i] = binding.getExpr().getResolvedType();
        }
        List<SetterStore.MultiAttributeSetter> multiAttributeSetterCalls = setterStore.getMultiAttributeSetterCalls(attributes, this.getResolvedType(), types);
        if (multiAttributeSetterCalls.isEmpty()) {
            return;
        }
        final HashMap<String, Binding> lookup = new HashMap<String, Binding>();
        for (Binding binding : this.mBindings) {
            String name = binding.getName();
            if (name.startsWith("android:")) {
                lookup.put(name, binding);
                continue;
            }
            int ind = name.indexOf(":");
            if (ind == -1) {
                lookup.put(name, binding);
                continue;
            }
            lookup.put(name.substring(ind + 1), binding);
        }
        ArrayList<MergedBinding> mergeBindings = new ArrayList<MergedBinding>();
        for (SetterStore.MultiAttributeSetter setter : multiAttributeSetterCalls) {
            L.d("resolved %s", setter);
            Binding[] mergedBindings = Iterables.toArray(Iterables.transform(Arrays.asList(setter.attributes), new Function<String, Binding>(){

                @Override
                public Binding apply(String attribute) {
                    L.d("looking for binding for attribute %s", attribute);
                    return (Binding)lookup.get(attribute);
                }
            }), Binding.class);
            Preconditions.checkArgument(mergedBindings.length == setter.attributes.length);
            for (Binding binding : mergedBindings) {
                binding.getExpr().setBindingExpression(false);
                this.mBindings.remove(binding);
            }
            MergedBinding mergedBinding = new MergedBinding(this.getModel(), setter, this, Arrays.asList(mergedBindings));
            mergeBindings.add(mergedBinding);
        }
        for (MergedBinding binding : mergeBindings) {
            this.mBindings.add(binding);
        }
    }
}

