#!/usr/bin/env python3

#-----------------------------------------------------------------------------
# Borrowed initially from https://github.com/mrowa44/emojify
# Copyright (c) 2015 Justyna Rachowicz
# Copyright (C) Proxmark3 contributors. See AUTHORS.md for details.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# See LICENSE.txt for the text of the license.
#-----------------------------------------------------------------------------

from urllib.request import urlopen
import json


EMOJI_JSON_URL = 'https://raw.githubusercontent.com/github/gemoji/master/db/emoji.json'

def string_emoji(emoji_json):
    for alias in emoji_json['aliases']:
        return('    {{":{0}:", "{1}"}}, // {2}\n'.format(alias,
              ''.join('\\x{:02x}'.format(b) for b in emoji_json['emoji'].encode('utf8')),
              emoji_json['emoji']))

C_HEADER="""//-----------------------------------------------------------------------------
// Borrowed initially from https://github.com/github/gemoji
// Copyright (C) Proxmark3 contributors. See AUTHORS.md for details.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// See LICENSE.txt for the text of the license.
//-----------------------------------------------------------------------------
// *DO NOT EDIT MANUALLY*
// Autogenerated with emojis_scrap_github.py
//-----------------------------------------------------------------------------
#ifndef EMOJIS_H__
#define EMOJIS_H__

typedef struct emoji_s {
    const char *alias;
    const char *emoji;
} emoji_t;
// emoji_t array are expected to be NULL terminated

static emoji_t EmojiTable[] = {
"""

C_FOOTER="""    {NULL, NULL}
};
#endif
"""

with open('src/emojis.h','w') as femoji:
    with urlopen(EMOJI_JSON_URL) as conn:
        emojis_json = json.loads(conn.read().decode('utf-8'))
        femoji.write(C_HEADER)
        for emoji_json in emojis_json:
            femoji.write(string_emoji(emoji_json))
        femoji.write(C_FOOTER)
