/*
 * JWT Authentication Module
 *
 * Copyright (C) 2020 OpenSIPS Project
 *
 * opensips is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * opensips is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * History:
 * --------
 * 2020-03-12 initial release (vlad)
 */

#ifndef JWTAUTHORIZE_H
#define JWTAUTHORIZE_H

int auth_db_init(const str* db_url);
void auth_db_close();

int jwt_db_authorize(struct sip_msg* _msg, str* jwt_token, pv_spec_t* auth_user);
int jwt_script_authorize(struct sip_msg* _msg, str* jwt_token, str* key, 
		pv_spec_t* decoded_jwt);

#endif /* JWTAUTHORIZE_H */
