/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.function.settings.WaypointTypeList;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.IconManager;
import tim.prune.gui.colour.WaypointColours;
import tim.prune.gui.map.WpIconLibrary;
import tim.prune.load.GenericFileFilter;

public class SetWaypointSettings
extends GenericFunction {
    private JDialog _dialog = null;
    private JComboBox<Integer> _wpIconCombobox = null;
    private JRadioButton[] _sizeRadioButtons = null;
    private JCheckBox _coloursCheckbox = null;
    private JCheckBox _customIconCheckbox = null;
    private JButton _browseButton = null;
    private File _selectedIconFile = null;
    private JSlider _saltSlider = null;
    private JLabel _saltLabel = null;
    private JLabel _noTypesLabel = null;
    private final WaypointTypeList _typeList = new WaypointTypeList();
    private JList<String> _typeListBox = null;
    private JScrollPane _listScroller = null;

    public SetWaypointSettings(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.setwaypointdisplay";
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel4);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.displaysettings.waypointicons"));
        jLabel.setAlignmentX(0.0f);
        guiGridLayout.add(jLabel);
        this._wpIconCombobox = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5});
        this._wpIconCombobox.setRenderer(new IconComboRenderer(this.getIconManager()));
        guiGridLayout.add(this._wpIconCombobox);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this._sizeRadioButtons = new JRadioButton[3];
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = new String[]{"small", "medium", "large"};
        int n = 0;
        while (n < 3) {
            this._sizeRadioButtons[n] = new JRadioButton(I18nManager.getText("dialog.displaysettings.size." + stringArray[n]));
            buttonGroup.add(this._sizeRadioButtons[n]);
            jPanel5.add(this._sizeRadioButtons[n]);
            ++n;
        }
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        this._customIconCheckbox = new JCheckBox(I18nManager.getText("dialog.waypointsettings.usecustomicon"));
        this._customIconCheckbox.addActionListener(actionEvent -> this.updateCustomIconCheckbox());
        jPanel6.add(this._customIconCheckbox);
        this._browseButton = new JButton(I18nManager.getText("button.browse"));
        this._browseButton.addActionListener(actionEvent -> this.chooseCustomIconFile());
        this._browseButton.setEnabled(false);
        jPanel6.add(this._browseButton);
        jPanel3.add(jPanel6);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(15));
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel7.setAlignmentX(0.0f);
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        this._coloursCheckbox = new JCheckBox(I18nManager.getText("dialog.waypointsettings.usecolours"));
        jPanel7.add(this._coloursCheckbox);
        jPanel7.add(Box.createVerticalStrut(10));
        this._saltSlider = new JSlider(0, WaypointColours.getMaxSalt());
        jPanel7.add(this._saltSlider);
        this._saltLabel = new JLabel("some label");
        jPanel7.add(this._saltLabel);
        this._noTypesLabel = new JLabel(I18nManager.getText("dialog.waypointsettings.notypesintrack"));
        jPanel7.add(this._noTypesLabel);
        this._typeListBox = new JList<String>(this._typeList);
        this._typeListBox.setVisibleRowCount(4);
        this._typeListBox.setLayoutOrientation(2);
        this._typeListBox.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                this.setText(object.toString());
                this.setHorizontalTextPosition(2);
                this.setIconTextGap(7);
                this.setIcon(SetWaypointSettings.this.makeImageIcon(object.toString(), SetWaypointSettings.this._saltSlider.getValue()));
                return this;
            }
        });
        this._listScroller = new JScrollPane(this._typeListBox);
        jPanel7.add(this._listScroller);
        jPanel2.add(jPanel7);
        this._saltSlider.addChangeListener(changeEvent -> this.showPreview(this._saltSlider.getValue()));
        this._coloursCheckbox.addChangeListener(changeEvent -> this.coloursSwitched());
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> this.finish());
        jPanel8.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel8.add(jButton2);
        jPanel.add((Component)jPanel8, "South");
        return jPanel;
    }

    private void updateCustomIconCheckbox() {
        boolean bl = this._customIconCheckbox.isSelected() && this._selectedIconFile != null && this._selectedIconFile.exists() && this._selectedIconFile.isFile() && this._selectedIconFile.canRead();
        String string = I18nManager.getText("dialog.waypointsettings.usecustomicon");
        if (bl) {
            string = String.valueOf(string) + " (" + this._selectedIconFile.getName() + ")";
        }
        this._customIconCheckbox.setText(string);
        this.enableIconControls(this._customIconCheckbox.isSelected());
    }

    private void enableIconControls(boolean bl) {
        this._wpIconCombobox.setEnabled(!bl);
        JRadioButton[] jRadioButtonArray = this._sizeRadioButtons;
        int n = this._sizeRadioButtons.length;
        int n2 = 0;
        while (n2 < n) {
            JRadioButton jRadioButton = jRadioButtonArray[n2];
            jRadioButton.setEnabled(!bl);
            ++n2;
        }
        this._browseButton.setEnabled(bl);
    }

    private void chooseCustomIconFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new GenericFileFilter("filetypefilter.png", new String[]{"png"}));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (this._selectedIconFile != null) {
            jFileChooser.setSelectedFile(this._selectedIconFile);
        }
        if (jFileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._selectedIconFile = jFileChooser.getSelectedFile();
            this.updateCustomIconCheckbox();
        }
    }

    private void coloursSwitched() {
        boolean bl = this._coloursCheckbox.isSelected();
        this.showPreview(bl ? Math.max(this._saltSlider.getValue(), 0) : -1);
        this._saltSlider.setEnabled(bl);
        this._typeListBox.setEnabled(bl);
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, this.getName());
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        Config config = this.getConfig();
        try {
            this._wpIconCombobox.setSelectedIndex(config.getConfigInt("prune.waypointicons"));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.selectIconSizeRadio(config.getConfigInt("prune.waypointiconsize"));
        this._selectedIconFile = this.makeFile(config.getConfigString("prune.waypointiconpath"));
        this._customIconCheckbox.setSelected(config.getConfigBoolean("prune.waypointiconusecustom") && this._selectedIconFile != null);
        this.updateCustomIconCheckbox();
        int n = config.getConfigInt("prune.waypointsalt");
        this._coloursCheckbox.setSelected(n >= 0);
        this._saltSlider.setValue(Math.max(n, 0));
        this._saltSlider.setEnabled(n >= 0);
        this._typeList.compile(this._app.getTrackInfo().getTrack());
        this.showPreview(n);
        this._dialog.setVisible(true);
    }

    private File makeFile(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        File file = new File(string);
        if (file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(".png")) {
            return file;
        }
        return null;
    }

    private void showPreview(int n) {
        String string = n < 0 ? "" : String.valueOf(I18nManager.getText("dialog.waypointsettings.saltvalue")) + " : " + n;
        this._saltLabel.setText(string);
        this._noTypesLabel.setVisible(this._typeList.getSize() == 0);
        this._typeListBox.repaint();
        this._listScroller.setVisible(this._typeList.getSize() > 0);
    }

    private void selectIconSizeRadio(int n) {
        if (n < 0 || n >= this._sizeRadioButtons.length) {
            n = 1;
        }
        if (this._sizeRadioButtons[n] != null) {
            this._sizeRadioButtons[n].setSelected(true);
        }
    }

    private int getSelectedIconSize() {
        int n = 0;
        while (n < this._sizeRadioButtons.length) {
            if (this._sizeRadioButtons[n] != null && this._sizeRadioButtons[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return 1;
    }

    private Icon makeImageIcon(String string, int n) {
        Color color = WaypointColours.getColourForType(string, n);
        if (color == null) {
            return null;
        }
        int n2 = color.getRGB();
        BufferedImage bufferedImage = new BufferedImage(20, 20, 1);
        int n3 = 1;
        while (n3 < 19) {
            bufferedImage.setRGB(n3, 0, 0);
            bufferedImage.setRGB(0, n3, 0);
            int n4 = 1;
            while (n4 < 19) {
                bufferedImage.setRGB(n3, n4, n2);
                ++n4;
            }
            bufferedImage.setRGB(n3, 19, 0);
            bufferedImage.setRGB(19, n3, 0);
            ++n3;
        }
        return new ImageIcon(bufferedImage);
    }

    public void finish() {
        Config config = this.getConfig();
        config.setConfigInt("prune.waypointicons", this._wpIconCombobox.getSelectedIndex());
        config.setConfigInt("prune.waypointiconsize", this.getSelectedIconSize());
        config.setConfigBoolean("prune.waypointiconusecustom", this._customIconCheckbox.isSelected());
        config.setConfigString("prune.waypointiconpath", this._selectedIconFile == null ? "" : this._selectedIconFile.getAbsolutePath());
        int n = this._coloursCheckbox.isSelected() ? this._saltSlider.getValue() : -1;
        config.setConfigInt("prune.waypointsalt", n);
        UpdateMessageBroker.informSubscribers(128);
        this._dialog.dispose();
    }

    static class IconComboRenderer
    extends JLabel
    implements ListCellRenderer<Integer> {
        private final ImageIcon[] _icons = new ImageIcon[6];
        private final IconManager _iconManager;

        IconComboRenderer(IconManager iconManager) {
            this.setOpaque(true);
            this._iconManager = iconManager;
        }

        private String getLabel(int n) {
            return I18nManager.getText("dialog.displaysettings.wpicon." + WpIconLibrary.getIconName(n));
        }

        private ImageIcon getIcon(int n) {
            if (this._icons[n] == null) {
                this._icons[n] = WpIconLibrary.getFixedIconDefinition(n, this._iconManager).getImageIcon();
            }
            return this._icons[n];
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Integer> jList, Integer n, int n2, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setIcon(this.getIcon(n));
            this.setText(this.getLabel(n));
            return this;
        }
    }
}

