# This file has been autogenerated by the pywayland scanner

# Copyright © 2012, 2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .zwp_input_method_context_v1 import ZwpInputMethodContextV1


class ZwpInputMethodV1(Interface):
    """Input method

    An input method object is responsible for composing text in response to
    input from hardware or virtual keyboards. There is one input method object
    per seat. On activate there is a new input method context object created
    which allows the input method to communicate with the text input.
    """

    name = "zwp_input_method_v1"
    version = 1


class ZwpInputMethodV1Proxy(Proxy[ZwpInputMethodV1]):
    interface = ZwpInputMethodV1


class ZwpInputMethodV1Resource(Resource):
    interface = ZwpInputMethodV1

    @ZwpInputMethodV1.event(
        Argument(ArgumentType.NewId, interface=ZwpInputMethodContextV1),
    )
    def activate(self, id: ZwpInputMethodContextV1) -> None:
        """Activate event

        A text input was activated. Creates an input method context object
        which allows communication with the text input.

        :param id:
        :type id:
            :class:`~pywayland.protocol.input_method_unstable_v1.ZwpInputMethodContextV1`
        """
        self._post_event(0, id)

    @ZwpInputMethodV1.event(
        Argument(ArgumentType.Object, interface=ZwpInputMethodContextV1),
    )
    def deactivate(self, context: ZwpInputMethodContextV1) -> None:
        """Deactivate event

        The text input corresponding to the context argument was deactivated.
        The input method context should be destroyed after deactivation is
        handled.

        :param context:
        :type context:
            :class:`~pywayland.protocol.input_method_unstable_v1.ZwpInputMethodContextV1`
        """
        self._post_event(1, context)


class ZwpInputMethodV1Global(Global):
    interface = ZwpInputMethodV1


ZwpInputMethodV1._gen_c()
ZwpInputMethodV1.proxy_class = ZwpInputMethodV1Proxy
ZwpInputMethodV1.resource_class = ZwpInputMethodV1Resource
ZwpInputMethodV1.global_class = ZwpInputMethodV1Global
