//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICESTORM_API_EXPORTS
#   define ICESTORM_API_EXPORTS
#endif
#include <IceStorm/IceStorm.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::LinkExists> iceC_IceStorm_LinkExists_init("::IceStorm::LinkExists");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::NoSuchLink> iceC_IceStorm_NoSuchLink_init("::IceStorm::NoSuchLink");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::AlreadySubscribed> iceC_IceStorm_AlreadySubscribed_init("::IceStorm::AlreadySubscribed");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::InvalidSubscriber> iceC_IceStorm_InvalidSubscriber_init("::IceStorm::InvalidSubscriber");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::BadQoS> iceC_IceStorm_BadQoS_init("::IceStorm::BadQoS");

const ::std::string iceC_IceStorm_Topic_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::Topic"
};
const ::std::string iceC_IceStorm_Topic_ops[] =
{
    "destroy",
    "getLinkInfoSeq",
    "getName",
    "getNonReplicatedPublisher",
    "getPublisher",
    "getSubscribers",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "link",
    "subscribeAndGetPublisher",
    "unlink",
    "unsubscribe"
};
const ::std::string iceC_IceStorm_Topic_getName_name = "getName";
const ::std::string iceC_IceStorm_Topic_getPublisher_name = "getPublisher";
const ::std::string iceC_IceStorm_Topic_getNonReplicatedPublisher_name = "getNonReplicatedPublisher";
const ::std::string iceC_IceStorm_Topic_subscribeAndGetPublisher_name = "subscribeAndGetPublisher";
const ::std::string iceC_IceStorm_Topic_unsubscribe_name = "unsubscribe";
const ::std::string iceC_IceStorm_Topic_link_name = "link";
const ::std::string iceC_IceStorm_Topic_unlink_name = "unlink";
const ::std::string iceC_IceStorm_Topic_getLinkInfoSeq_name = "getLinkInfoSeq";
const ::std::string iceC_IceStorm_Topic_getSubscribers_name = "getSubscribers";
const ::std::string iceC_IceStorm_Topic_destroy_name = "destroy";

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::TopicExists> iceC_IceStorm_TopicExists_init("::IceStorm::TopicExists");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::NoSuchTopic> iceC_IceStorm_NoSuchTopic_init("::IceStorm::NoSuchTopic");

const ::std::string iceC_IceStorm_TopicManager_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::TopicManager"
};
const ::std::string iceC_IceStorm_TopicManager_ops[] =
{
    "create",
    "getSliceChecksums",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "retrieve",
    "retrieveAll"
};
const ::std::string iceC_IceStorm_TopicManager_create_name = "create";
const ::std::string iceC_IceStorm_TopicManager_retrieve_name = "retrieve";
const ::std::string iceC_IceStorm_TopicManager_retrieveAll_name = "retrieveAll";
const ::std::string iceC_IceStorm_TopicManager_getSliceChecksums_name = "getSliceChecksums";

const ::std::string iceC_IceStorm_Finder_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::Finder"
};
const ::std::string iceC_IceStorm_Finder_ops[] =
{
    "getTopicManager",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceStorm_Finder_getTopicManager_name = "getTopicManager";

}

IceStorm::LinkExists::~LinkExists()
{
}

const ::std::string&
IceStorm::LinkExists::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::LinkExists";
    return typeId;
}

IceStorm::NoSuchLink::~NoSuchLink()
{
}

const ::std::string&
IceStorm::NoSuchLink::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::NoSuchLink";
    return typeId;
}

IceStorm::AlreadySubscribed::~AlreadySubscribed()
{
}

const ::std::string&
IceStorm::AlreadySubscribed::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::AlreadySubscribed";
    return typeId;
}

IceStorm::InvalidSubscriber::~InvalidSubscriber()
{
}

const ::std::string&
IceStorm::InvalidSubscriber::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::InvalidSubscriber";
    return typeId;
}

IceStorm::BadQoS::~BadQoS()
{
}

const ::std::string&
IceStorm::BadQoS::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::BadQoS";
    return typeId;
}

IceStorm::TopicExists::~TopicExists()
{
}

const ::std::string&
IceStorm::TopicExists::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::TopicExists";
    return typeId;
}

IceStorm::NoSuchTopic::~NoSuchTopic()
{
}

const ::std::string&
IceStorm::NoSuchTopic::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::NoSuchTopic";
    return typeId;
}

bool
IceStorm::Topic::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_Topic_ids, iceC_IceStorm_Topic_ids + 2, s);
}

::std::vector<::std::string>
IceStorm::Topic::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceStorm_Topic_ids[0], &iceC_IceStorm_Topic_ids[2]);
}

::std::string
IceStorm::Topic::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::Topic::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::Topic";
    return typeId;
}

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getName(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getName(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getPublisher(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->getPublisher(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getNonReplicatedPublisher(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->getNonReplicatedPublisher(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_subscribeAndGetPublisher(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    QoS iceP_theQoS;
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_subscriber;
    istr->readAll(iceP_theQoS, iceP_subscriber);
    inS.endReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->subscribeAndGetPublisher(::std::move(iceP_theQoS), ::std::move(iceP_subscriber), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_unsubscribe(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_subscriber;
    istr->readAll(iceP_subscriber);
    inS.endReadParams();
    this->unsubscribe(::std::move(iceP_subscriber), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_link(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<TopicPrx> iceP_linkTo;
    int iceP_cost;
    istr->readAll(iceP_linkTo, iceP_cost);
    inS.endReadParams();
    this->link(::std::move(iceP_linkTo), iceP_cost, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_unlink(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<TopicPrx> iceP_linkTo;
    istr->readAll(iceP_linkTo);
    inS.endReadParams();
    this->unlink(::std::move(iceP_linkTo), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getLinkInfoSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    LinkInfoSeq ret = this->getLinkInfoSeq(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getSubscribers(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::Ice::IdentitySeq ret = this->getSubscribers(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_Topic_ops, iceC_IceStorm_Topic_ops + 14, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_Topic_ops)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getLinkInfoSeq(in, current);
        }
        case 2:
        {
            return _iceD_getName(in, current);
        }
        case 3:
        {
            return _iceD_getNonReplicatedPublisher(in, current);
        }
        case 4:
        {
            return _iceD_getPublisher(in, current);
        }
        case 5:
        {
            return _iceD_getSubscribers(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        case 10:
        {
            return _iceD_link(in, current);
        }
        case 11:
        {
            return _iceD_subscribeAndGetPublisher(in, current);
        }
        case 12:
        {
            return _iceD_unlink(in, current);
        }
        case 13:
        {
            return _iceD_unsubscribe(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceStorm::TopicManager::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicManager_ids, iceC_IceStorm_TopicManager_ids + 2, s);
}

::std::vector<::std::string>
IceStorm::TopicManager::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceStorm_TopicManager_ids[0], &iceC_IceStorm_TopicManager_ids[2]);
}

::std::string
IceStorm::TopicManager::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicManager::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::TopicManager";
    return typeId;
}

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_create(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    ::std::shared_ptr<TopicPrx> ret = this->create(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_retrieve(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    ::std::shared_ptr<TopicPrx> ret = this->retrieve(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_retrieveAll(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    TopicDict ret = this->retrieveAll(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_getSliceChecksums(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::SliceChecksumDict ret = this->getSliceChecksums(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicManager_ops, iceC_IceStorm_TopicManager_ops + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicManager_ops)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_getSliceChecksums(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_retrieve(in, current);
        }
        case 7:
        {
            return _iceD_retrieveAll(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceStorm::Finder::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_Finder_ids, iceC_IceStorm_Finder_ids + 2, s);
}

::std::vector<::std::string>
IceStorm::Finder::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceStorm_Finder_ids[0], &iceC_IceStorm_Finder_ids[2]);
}

::std::string
IceStorm::Finder::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::Finder::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::Finder";
    return typeId;
}

/// \cond INTERNAL
bool
IceStorm::Finder::_iceD_getTopicManager(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<TopicManagerPrx> ret = this->getTopicManager(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Finder::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_Finder_ops, iceC_IceStorm_Finder_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_Finder_ops)
    {
        case 0:
        {
            return _iceD_getTopicManager(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_getName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getName_name);
    outAsync->invoke(iceC_IceStorm_Topic_getName_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_getPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getPublisher_name);
    outAsync->invoke(iceC_IceStorm_Topic_getPublisher_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_getNonReplicatedPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getNonReplicatedPublisher_name);
    outAsync->invoke(iceC_IceStorm_Topic_getNonReplicatedPublisher_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_subscribeAndGetPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const QoS& iceP_theQoS, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_subscribeAndGetPublisher_name);
    outAsync->invoke(iceC_IceStorm_Topic_subscribeAndGetPublisher_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_theQoS, iceP_subscriber);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AlreadySubscribed&)
            {
                throw;
            }
            catch(const BadQoS&)
            {
                throw;
            }
            catch(const InvalidSubscriber&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_unsubscribe(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceStorm_Topic_unsubscribe_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_subscriber);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_link(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<TopicPrx>& iceP_linkTo, int iceP_cost, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_link_name);
    outAsync->invoke(iceC_IceStorm_Topic_link_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_linkTo, iceP_cost);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const LinkExists&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_unlink(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<TopicPrx>& iceP_linkTo, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_unlink_name);
    outAsync->invoke(iceC_IceStorm_Topic_unlink_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_linkTo);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NoSuchLink&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_getLinkInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStorm::LinkInfoSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getLinkInfoSeq_name);
    outAsync->invoke(iceC_IceStorm_Topic_getLinkInfoSeq_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_getSubscribers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::IdentitySeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getSubscribers_name);
    outAsync->invoke(iceC_IceStorm_Topic_getSubscribers_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicPrx::_iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceStorm_Topic_destroy_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceStorm::TopicPrx::_newInstance() const
{
    return ::IceInternal::createProxy<TopicPrx>();
}
/// \endcond

const ::std::string&
IceStorm::TopicPrx::ice_staticId()
{
    return Topic::ice_staticId();
}

/// \cond INTERNAL
void
IceStorm::TopicManagerPrx::_iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicPrx>>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_create_name);
    outAsync->invoke(iceC_IceStorm_TopicManager_create_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const TopicExists&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicManagerPrx::_iceI_retrieve(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicPrx>>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_retrieve_name);
    outAsync->invoke(iceC_IceStorm_TopicManager_retrieve_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NoSuchTopic&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicManagerPrx::_iceI_retrieveAll(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStorm::TopicDict>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_retrieveAll_name);
    outAsync->invoke(iceC_IceStorm_TopicManager_retrieveAll_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicManagerPrx::_iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_getSliceChecksums_name);
    outAsync->invoke(iceC_IceStorm_TopicManager_getSliceChecksums_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceStorm::TopicManagerPrx::_newInstance() const
{
    return ::IceInternal::createProxy<TopicManagerPrx>();
}
/// \endcond

const ::std::string&
IceStorm::TopicManagerPrx::ice_staticId()
{
    return TopicManager::ice_staticId();
}

/// \cond INTERNAL
void
IceStorm::FinderPrx::_iceI_getTopicManager(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicManagerPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_Finder_getTopicManager_name);
    outAsync->invoke(iceC_IceStorm_Finder_getTopicManager_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceStorm::FinderPrx::_newInstance() const
{
    return ::IceInternal::createProxy<FinderPrx>();
}
/// \endcond

const ::std::string&
IceStorm::FinderPrx::ice_staticId()
{
    return Finder::ice_staticId();
}

namespace Ice
{
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_IceStorm_Topic_getName_name = "getName";

const ::std::string iceC_IceStorm_Topic_getPublisher_name = "getPublisher";

const ::std::string iceC_IceStorm_Topic_getNonReplicatedPublisher_name = "getNonReplicatedPublisher";

const ::std::string iceC_IceStorm_Topic_subscribeAndGetPublisher_name = "subscribeAndGetPublisher";

const ::std::string iceC_IceStorm_Topic_unsubscribe_name = "unsubscribe";

const ::std::string iceC_IceStorm_Topic_link_name = "link";

const ::std::string iceC_IceStorm_Topic_unlink_name = "unlink";

const ::std::string iceC_IceStorm_Topic_getLinkInfoSeq_name = "getLinkInfoSeq";

const ::std::string iceC_IceStorm_Topic_getSubscribers_name = "getSubscribers";

const ::std::string iceC_IceStorm_Topic_destroy_name = "destroy";

const ::std::string iceC_IceStorm_TopicManager_create_name = "create";

const ::std::string iceC_IceStorm_TopicManager_retrieve_name = "retrieve";

const ::std::string iceC_IceStorm_TopicManager_retrieveAll_name = "retrieveAll";

const ::std::string iceC_IceStorm_TopicManager_getSliceChecksums_name = "getSliceChecksums";

const ::std::string iceC_IceStorm_Finder_getTopicManager_name = "getTopicManager";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::LinkExists> iceC_IceStorm_LinkExists_init("::IceStorm::LinkExists");

}

IceStorm::LinkExists::LinkExists(const ::std::string& name) :
    ::Ice::UserException(),
    name(name)
{
}

#ifdef ICE_CPP11_COMPILER
IceStorm::LinkExists::~LinkExists()
{
}
#else
IceStorm::LinkExists::~LinkExists() throw()
{
}
#endif

::std::string
IceStorm::LinkExists::ice_id() const
{
    return "::IceStorm::LinkExists";
}

IceStorm::LinkExists*
IceStorm::LinkExists::ice_clone() const
{
    return new LinkExists(*this);
}

void
IceStorm::LinkExists::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::LinkExists::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::LinkExists", -1, true);
    ::Ice::StreamWriter< LinkExists, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::LinkExists::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< LinkExists, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::NoSuchLink> iceC_IceStorm_NoSuchLink_init("::IceStorm::NoSuchLink");

}

IceStorm::NoSuchLink::NoSuchLink(const ::std::string& name) :
    ::Ice::UserException(),
    name(name)
{
}

#ifdef ICE_CPP11_COMPILER
IceStorm::NoSuchLink::~NoSuchLink()
{
}
#else
IceStorm::NoSuchLink::~NoSuchLink() throw()
{
}
#endif

::std::string
IceStorm::NoSuchLink::ice_id() const
{
    return "::IceStorm::NoSuchLink";
}

IceStorm::NoSuchLink*
IceStorm::NoSuchLink::ice_clone() const
{
    return new NoSuchLink(*this);
}

void
IceStorm::NoSuchLink::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::NoSuchLink::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::NoSuchLink", -1, true);
    ::Ice::StreamWriter< NoSuchLink, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::NoSuchLink::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< NoSuchLink, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::AlreadySubscribed> iceC_IceStorm_AlreadySubscribed_init("::IceStorm::AlreadySubscribed");

}

#ifdef ICE_CPP11_COMPILER
IceStorm::AlreadySubscribed::~AlreadySubscribed()
{
}
#else
IceStorm::AlreadySubscribed::~AlreadySubscribed() throw()
{
}
#endif

::std::string
IceStorm::AlreadySubscribed::ice_id() const
{
    return "::IceStorm::AlreadySubscribed";
}

IceStorm::AlreadySubscribed*
IceStorm::AlreadySubscribed::ice_clone() const
{
    return new AlreadySubscribed(*this);
}

void
IceStorm::AlreadySubscribed::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::AlreadySubscribed::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::AlreadySubscribed", -1, true);
    ::Ice::StreamWriter< AlreadySubscribed, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::AlreadySubscribed::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< AlreadySubscribed, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::InvalidSubscriber> iceC_IceStorm_InvalidSubscriber_init("::IceStorm::InvalidSubscriber");

}

IceStorm::InvalidSubscriber::InvalidSubscriber(const ::std::string& reason) :
    ::Ice::UserException(),
    reason(reason)
{
}

#ifdef ICE_CPP11_COMPILER
IceStorm::InvalidSubscriber::~InvalidSubscriber()
{
}
#else
IceStorm::InvalidSubscriber::~InvalidSubscriber() throw()
{
}
#endif

::std::string
IceStorm::InvalidSubscriber::ice_id() const
{
    return "::IceStorm::InvalidSubscriber";
}

IceStorm::InvalidSubscriber*
IceStorm::InvalidSubscriber::ice_clone() const
{
    return new InvalidSubscriber(*this);
}

void
IceStorm::InvalidSubscriber::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::InvalidSubscriber::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::InvalidSubscriber", -1, true);
    ::Ice::StreamWriter< InvalidSubscriber, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::InvalidSubscriber::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InvalidSubscriber, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::BadQoS> iceC_IceStorm_BadQoS_init("::IceStorm::BadQoS");

}

IceStorm::BadQoS::BadQoS(const ::std::string& reason) :
    ::Ice::UserException(),
    reason(reason)
{
}

#ifdef ICE_CPP11_COMPILER
IceStorm::BadQoS::~BadQoS()
{
}
#else
IceStorm::BadQoS::~BadQoS() throw()
{
}
#endif

::std::string
IceStorm::BadQoS::ice_id() const
{
    return "::IceStorm::BadQoS";
}

IceStorm::BadQoS*
IceStorm::BadQoS::ice_clone() const
{
    return new BadQoS(*this);
}

void
IceStorm::BadQoS::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::BadQoS::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::BadQoS", -1, true);
    ::Ice::StreamWriter< BadQoS, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::BadQoS::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< BadQoS, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::TopicExists> iceC_IceStorm_TopicExists_init("::IceStorm::TopicExists");

}

IceStorm::TopicExists::TopicExists(const ::std::string& name) :
    ::Ice::UserException(),
    name(name)
{
}

#ifdef ICE_CPP11_COMPILER
IceStorm::TopicExists::~TopicExists()
{
}
#else
IceStorm::TopicExists::~TopicExists() throw()
{
}
#endif

::std::string
IceStorm::TopicExists::ice_id() const
{
    return "::IceStorm::TopicExists";
}

IceStorm::TopicExists*
IceStorm::TopicExists::ice_clone() const
{
    return new TopicExists(*this);
}

void
IceStorm::TopicExists::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::TopicExists::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::TopicExists", -1, true);
    ::Ice::StreamWriter< TopicExists, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::TopicExists::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< TopicExists, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::NoSuchTopic> iceC_IceStorm_NoSuchTopic_init("::IceStorm::NoSuchTopic");

}

IceStorm::NoSuchTopic::NoSuchTopic(const ::std::string& name) :
    ::Ice::UserException(),
    name(name)
{
}

#ifdef ICE_CPP11_COMPILER
IceStorm::NoSuchTopic::~NoSuchTopic()
{
}
#else
IceStorm::NoSuchTopic::~NoSuchTopic() throw()
{
}
#endif

::std::string
IceStorm::NoSuchTopic::ice_id() const
{
    return "::IceStorm::NoSuchTopic";
}

IceStorm::NoSuchTopic*
IceStorm::NoSuchTopic::ice_clone() const
{
    return new NoSuchTopic(*this);
}

void
IceStorm::NoSuchTopic::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::NoSuchTopic::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::NoSuchTopic", -1, true);
    ::Ice::StreamWriter< NoSuchTopic, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::NoSuchTopic::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< NoSuchTopic, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
ICESTORM_API ::IceProxy::Ice::Object* ::IceProxy::IceStorm::upCast(Topic* p) { return p; }

void
::IceProxy::IceStorm::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Topic>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Topic;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_getName(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getName_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_getName_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_getName_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_Topic_getName_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::std::string
IceProxy::IceStorm::Topic::end_getName(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_getName_name);
    ::std::string ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_getPublisher(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getPublisher_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_getPublisher_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_getPublisher_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_Topic_getPublisher_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceStorm::Topic::end_getPublisher(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_getPublisher_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_getNonReplicatedPublisher(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getNonReplicatedPublisher_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_getNonReplicatedPublisher_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_getNonReplicatedPublisher_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_Topic_getNonReplicatedPublisher_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceStorm::Topic::end_getNonReplicatedPublisher(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_getNonReplicatedPublisher_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_subscribeAndGetPublisher_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_subscribeAndGetPublisher_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_subscribeAndGetPublisher_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_theQoS);
        ostr->write(iceP_subscriber);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_Topic_subscribeAndGetPublisher_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceStorm::Topic::end_subscribeAndGetPublisher(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_subscribeAndGetPublisher_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceStorm::AlreadySubscribed&)
        {
            throw;
        }
        catch(const ::IceStorm::BadQoS&)
        {
            throw;
        }
        catch(const ::IceStorm::InvalidSubscriber&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_unsubscribe(const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_unsubscribe_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_unsubscribe_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_subscriber);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_Topic_unsubscribe_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceStorm::Topic::end_unsubscribe(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceStorm_Topic_unsubscribe_name);
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_link(const ::IceStorm::TopicPrx& iceP_linkTo, ::Ice::Int iceP_cost, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_link_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_link_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_link_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_linkTo);
        ostr->write(iceP_cost);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_Topic_link_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceStorm::Topic::end_link(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_link_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceStorm::LinkExists&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_unlink(const ::IceStorm::TopicPrx& iceP_linkTo, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_unlink_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_unlink_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_unlink_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_linkTo);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_Topic_unlink_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceStorm::Topic::end_unlink(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_unlink_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceStorm::NoSuchLink&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_getLinkInfoSeq(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getLinkInfoSeq_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_getLinkInfoSeq_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_getLinkInfoSeq_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_Topic_getLinkInfoSeq_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceStorm::LinkInfoSeq
IceProxy::IceStorm::Topic::end_getLinkInfoSeq(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_getLinkInfoSeq_name);
    ::IceStorm::LinkInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_getSubscribers(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Topic_getSubscribers_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_getSubscribers_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_getSubscribers_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_Topic_getSubscribers_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::IdentitySeq
IceProxy::IceStorm::Topic::end_getSubscribers(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Topic_getSubscribers_name);
    ::Ice::IdentitySeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::Topic::_iceI_begin_destroy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Topic_destroy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Topic_destroy_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_Topic_destroy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceStorm::Topic::end_destroy(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceStorm_Topic_destroy_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceStorm::Topic::_newInstance() const
{
    return new Topic;
}
/// \endcond

const ::std::string&
IceProxy::IceStorm::Topic::ice_staticId()
{
    return ::IceStorm::Topic::ice_staticId();
}

/// \cond INTERNAL
ICESTORM_API ::IceProxy::Ice::Object* ::IceProxy::IceStorm::upCast(TopicManager* p) { return p; }

void
::IceProxy::IceStorm::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< TopicManager>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new TopicManager;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicManager::_iceI_begin_create(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_create_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicManager_create_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicManager_create_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_TopicManager_create_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceStorm::TopicPrx
IceProxy::IceStorm::TopicManager::end_create(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_TopicManager_create_name);
    ::IceStorm::TopicPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceStorm::TopicExists&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicManager::_iceI_begin_retrieve(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_retrieve_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicManager_retrieve_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicManager_retrieve_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_TopicManager_retrieve_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceStorm::TopicPrx
IceProxy::IceStorm::TopicManager::end_retrieve(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_TopicManager_retrieve_name);
    ::IceStorm::TopicPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceStorm::NoSuchTopic&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicManager::_iceI_begin_retrieveAll(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_retrieveAll_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicManager_retrieveAll_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicManager_retrieveAll_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_TopicManager_retrieveAll_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceStorm::TopicDict
IceProxy::IceStorm::TopicManager::end_retrieveAll(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_TopicManager_retrieveAll_name);
    ::IceStorm::TopicDict ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicManager::_iceI_begin_getSliceChecksums(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManager_getSliceChecksums_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicManager_getSliceChecksums_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicManager_getSliceChecksums_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_TopicManager_getSliceChecksums_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::SliceChecksumDict
IceProxy::IceStorm::TopicManager::end_getSliceChecksums(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_TopicManager_getSliceChecksums_name);
    ::Ice::SliceChecksumDict ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceStorm::TopicManager::_newInstance() const
{
    return new TopicManager;
}
/// \endcond

const ::std::string&
IceProxy::IceStorm::TopicManager::ice_staticId()
{
    return ::IceStorm::TopicManager::ice_staticId();
}

/// \cond INTERNAL
ICESTORM_API ::IceProxy::Ice::Object* ::IceProxy::IceStorm::upCast(Finder* p) { return p; }

void
::IceProxy::IceStorm::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Finder>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Finder;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceStorm::Finder::_iceI_begin_getTopicManager(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_Finder_getTopicManager_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_Finder_getTopicManager_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_Finder_getTopicManager_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_Finder_getTopicManager_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceStorm::TopicManagerPrx
IceProxy::IceStorm::Finder::end_getTopicManager(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_Finder_getTopicManager_name);
    ::IceStorm::TopicManagerPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceStorm::Finder::_newInstance() const
{
    return new Finder;
}
/// \endcond

const ::std::string&
IceProxy::IceStorm::Finder::ice_staticId()
{
    return ::IceStorm::Finder::ice_staticId();
}

IceStorm::Topic::~Topic()
{
}

/// \cond INTERNAL
ICESTORM_API ::Ice::Object* IceStorm::upCast(Topic* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceStorm_Topic_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::Topic"
};

}

bool
IceStorm::Topic::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_Topic_ids, iceC_IceStorm_Topic_ids + 2, s);
}

::std::vector< ::std::string>
IceStorm::Topic::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceStorm_Topic_ids[0], &iceC_IceStorm_Topic_ids[2]);
}

const ::std::string&
IceStorm::Topic::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::Topic::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceStorm::Topic";
    return typeId;
#else
    return iceC_IceStorm_Topic_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getName(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getName(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getPublisher(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::ObjectPrx ret = this->getPublisher(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getNonReplicatedPublisher(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::ObjectPrx ret = this->getNonReplicatedPublisher(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_subscribeAndGetPublisher(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    QoS iceP_theQoS;
    ::Ice::ObjectPrx iceP_subscriber;
    istr->read(iceP_theQoS);
    istr->read(iceP_subscriber);
    inS.endReadParams();
    ::Ice::ObjectPrx ret = this->subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_unsubscribe(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::ObjectPrx iceP_subscriber;
    istr->read(iceP_subscriber);
    inS.endReadParams();
    this->unsubscribe(iceP_subscriber, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_link(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    TopicPrx iceP_linkTo;
    ::Ice::Int iceP_cost;
    istr->read(iceP_linkTo);
    istr->read(iceP_cost);
    inS.endReadParams();
    this->link(iceP_linkTo, iceP_cost, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_unlink(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    TopicPrx iceP_linkTo;
    istr->read(iceP_linkTo);
    inS.endReadParams();
    this->unlink(iceP_linkTo, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getLinkInfoSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    LinkInfoSeq ret = this->getLinkInfoSeq(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_getSubscribers(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    ::Ice::IdentitySeq ret = this->getSubscribers(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::Topic::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceStorm_Topic_all[] =
{
    "destroy",
    "getLinkInfoSeq",
    "getName",
    "getNonReplicatedPublisher",
    "getPublisher",
    "getSubscribers",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "link",
    "subscribeAndGetPublisher",
    "unlink",
    "unsubscribe"
};

}

/// \cond INTERNAL
bool
IceStorm::Topic::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_Topic_all, iceC_IceStorm_Topic_all + 14, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_Topic_all)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getLinkInfoSeq(in, current);
        }
        case 2:
        {
            return _iceD_getName(in, current);
        }
        case 3:
        {
            return _iceD_getNonReplicatedPublisher(in, current);
        }
        case 4:
        {
            return _iceD_getPublisher(in, current);
        }
        case 5:
        {
            return _iceD_getSubscribers(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        case 10:
        {
            return _iceD_link(in, current);
        }
        case 11:
        {
            return _iceD_subscribeAndGetPublisher(in, current);
        }
        case 12:
        {
            return _iceD_unlink(in, current);
        }
        case 13:
        {
            return _iceD_unsubscribe(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceStorm::Topic::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Topic, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::Topic::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Topic, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::_icePatchObjectPtr(TopicPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = TopicPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Topic::ice_staticId(), v);
    }
}
/// \endcond

IceStorm::TopicManager::~TopicManager()
{
}

/// \cond INTERNAL
ICESTORM_API ::Ice::Object* IceStorm::upCast(TopicManager* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicManager_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::TopicManager"
};

}

bool
IceStorm::TopicManager::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicManager_ids, iceC_IceStorm_TopicManager_ids + 2, s);
}

::std::vector< ::std::string>
IceStorm::TopicManager::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceStorm_TopicManager_ids[0], &iceC_IceStorm_TopicManager_ids[2]);
}

const ::std::string&
IceStorm::TopicManager::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicManager::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceStorm::TopicManager";
    return typeId;
#else
    return iceC_IceStorm_TopicManager_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_create(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    TopicPrx ret = this->create(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_retrieve(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    TopicPrx ret = this->retrieve(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_retrieveAll(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    TopicDict ret = this->retrieveAll(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceD_getSliceChecksums(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::SliceChecksumDict ret = this->getSliceChecksums(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicManager_all[] =
{
    "create",
    "getSliceChecksums",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "retrieve",
    "retrieveAll"
};

}

/// \cond INTERNAL
bool
IceStorm::TopicManager::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicManager_all, iceC_IceStorm_TopicManager_all + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicManager_all)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_getSliceChecksums(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_retrieve(in, current);
        }
        case 7:
        {
            return _iceD_retrieveAll(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceStorm::TopicManager::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< TopicManager, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::TopicManager::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< TopicManager, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::_icePatchObjectPtr(TopicManagerPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = TopicManagerPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(TopicManager::ice_staticId(), v);
    }
}
/// \endcond

IceStorm::Finder::~Finder()
{
}

/// \cond INTERNAL
ICESTORM_API ::Ice::Object* IceStorm::upCast(Finder* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceStorm_Finder_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::Finder"
};

}

bool
IceStorm::Finder::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_Finder_ids, iceC_IceStorm_Finder_ids + 2, s);
}

::std::vector< ::std::string>
IceStorm::Finder::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceStorm_Finder_ids[0], &iceC_IceStorm_Finder_ids[2]);
}

const ::std::string&
IceStorm::Finder::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::Finder::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceStorm::Finder";
    return typeId;
#else
    return iceC_IceStorm_Finder_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceStorm::Finder::_iceD_getTopicManager(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    TopicManagerPrx ret = this->getTopicManager(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceStorm_Finder_all[] =
{
    "getTopicManager",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceStorm::Finder::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_Finder_all, iceC_IceStorm_Finder_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_Finder_all)
    {
        case 0:
        {
            return _iceD_getTopicManager(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceStorm::Finder::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Finder, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::Finder::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Finder, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::_icePatchObjectPtr(FinderPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = FinderPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Finder::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
