/* interface.c generated by valac 0.56.18, the Vala compiler
 * generated from interface.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "xfmpc.h"
#include <src/libc/mpdclient.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <xfce-revision.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	XFMPC_INTERFACE_0_PROPERTY,
	XFMPC_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* xfmpc_interface_properties[XFMPC_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _XfmpcInterfacePrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkButton* button_prev;
	GtkButton* button_pp;
	GtkButton* button_next;
	GtkVolumeButton* button_volume;
	XfmpcProgressBar* progress_bar;
	GtkLabel* title;
	GtkLabel* subtitle;
	gboolean progress_bar_sync;
};

static gint XfmpcInterface_private_offset;
static gpointer xfmpc_interface_parent_class = NULL;

static gboolean xfmpc_interface_cb_progress_box_motion_event (XfmpcInterface* self,
                                                       GdkEventMotion* event);
static gboolean xfmpc_interface_cb_progress_box_press_event (XfmpcInterface* self,
                                                      GdkEventButton* event);
static gboolean xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self,
                                                        GdkEventButton* event);
static void xfmpc_interface_cb_song_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_pp_changed (XfmpcInterface* self,
                                    gboolean is_playing);
static void xfmpc_interface_cb_time_changed (XfmpcInterface* self,
                                      gint song_time);
static void xfmpc_interface_cb_total_time_changed (XfmpcInterface* self,
                                            gint total_time);
static void xfmpc_interface_cb_volume_changed (XfmpcInterface* self,
                                        gint volume);
static void xfmpc_interface_cb_playlist_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_stopped (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self);
static GObject * xfmpc_interface_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void _xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender,
                                                                     gdouble value,
                                                                     gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                       GdkEventMotion* event,
                                                                                       gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                     GdkEventButton* event,
                                                                                     gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                         GdkEventButton* event,
                                                                                         gpointer self);
static void _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender,
                                                                    gpointer self);
static void _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender,
                                                                gboolean is_playing,
                                                                gpointer self);
static void _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender,
                                                                    gint song_time,
                                                                    gpointer self);
static void _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender,
                                                                                gint total_time,
                                                                                gpointer self);
static void _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender,
                                                                        gint volume,
                                                                        gpointer self);
static void _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                            gpointer self);
static void _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender,
                                                          gpointer self);
static void xfmpc_interface_finalize (GObject * obj);
static GType xfmpc_interface_get_type_once (void);

static inline gpointer
xfmpc_interface_get_instance_private (XfmpcInterface* self)
{
	return G_STRUCT_MEMBER_P (self, XfmpcInterface_private_offset);
}

void
xfmpc_interface_set_title (XfmpcInterface* self,
                           const gchar* title)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->title;
	gtk_label_set_text (_tmp0_, title);
}

void
xfmpc_interface_set_subtitle (XfmpcInterface* self,
                              const gchar* subtitle)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subtitle != NULL);
	_tmp0_ = self->priv->subtitle;
	gtk_label_set_text (_tmp0_, subtitle);
}

void
xfmpc_interface_pp_clicked (XfmpcInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	XfmpcMpdclient* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	if (!xfmpc_mpdclient_pp (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->mpdclient;
	xfmpc_interface_set_pp (self, xfmpc_mpdclient_is_playing (_tmp1_));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
xfmpc_interface_set_pp (XfmpcInterface* self,
                        gboolean play)
{
	GtkImage* image = NULL;
	GtkButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkImage* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_pp;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_image_get_type (), GtkImage));
	image = _tmp2_;
	if (play == TRUE) {
		GtkImage* _tmp3_;
		_tmp3_ = image;
		gtk_image_set_from_icon_name (_tmp3_, "media-playback-pause", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	} else {
		GtkImage* _tmp4_;
		_tmp4_ = image;
		gtk_image_set_from_icon_name (_tmp4_, "media-playback-start", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	}
	_g_object_unref0 (image);
}

static gboolean
xfmpc_interface_cb_progress_box_motion_event (XfmpcInterface* self,
                                              GdkEventMotion* event)
{
	gint time_total = 0;
	XfmpcMpdclient* _tmp0_;
	GtkAllocation allocation = {0};
	XfmpcProgressBar* _tmp1_;
	GtkAllocation _tmp2_ = {0};
	gdouble song_time = 0.0;
	GtkAllocation _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->mpdclient;
	time_total = xfmpc_mpdclient_get_total_time (_tmp0_);
	if (time_total < 0) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->progress_bar;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = allocation;
	song_time = event->x / _tmp3_.width;
	song_time *= (gdouble) time_total;
	if (song_time < ((gdouble) 0)) {
		song_time = (gdouble) 0;
	} else {
		if (song_time > ((gdouble) time_total)) {
			song_time = (gdouble) time_total;
		}
	}
	xfmpc_interface_set_time (self, (gint) song_time, time_total);
	result = FALSE;
	return result;
}

static gboolean
xfmpc_interface_cb_progress_box_press_event (XfmpcInterface* self,
                                             GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->progress_bar_sync = FALSE;
	result = FALSE;
	return result;
}

static gboolean
xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self,
                                               GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gint time_total = 0;
	XfmpcMpdclient* _tmp1_;
	GtkAllocation allocation = {0};
	XfmpcProgressBar* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	gdouble song_time = 0.0;
	GtkAllocation _tmp4_;
	XfmpcMpdclient* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type != GDK_BUTTON_RELEASE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->button != ((guint) 1);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->progress_bar_sync = TRUE;
	_tmp1_ = self->priv->mpdclient;
	time_total = xfmpc_mpdclient_get_total_time (_tmp1_);
	if (time_total < 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->progress_bar;
	gtk_widget_get_allocation ((GtkWidget*) _tmp2_, &_tmp3_);
	allocation = _tmp3_;
	_tmp4_ = allocation;
	song_time = event->x / _tmp4_.width;
	song_time *= (gdouble) time_total;
	_tmp5_ = self->priv->mpdclient;
	xfmpc_mpdclient_set_song_time (_tmp5_, (guint) ((gint) song_time));
	result = TRUE;
	return result;
}

void
xfmpc_interface_volume_changed (XfmpcInterface* self,
                                gdouble value)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_set_volume (_tmp0_, (guchar) ((gchar) value));
}

void
xfmpc_interface_set_volume (XfmpcInterface* self,
                            gint volume)
{
	GtkVolumeButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_volume;
	gtk_scale_button_set_value ((GtkScaleButton*) _tmp0_, (gdouble) volume);
}

void
xfmpc_interface_popup_volume (XfmpcInterface* self)
{
	GtkVolumeButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_volume;
	g_signal_emit_by_name (_tmp0_, "popup", NULL, NULL);
}

void
xfmpc_interface_set_time (XfmpcInterface* self,
                          gint song_time,
                          gint time_total)
{
	gint min = 0;
	gint sec = 0;
	gint min_total = 0;
	gint sec_total = 0;
	gdouble fraction = 0.0;
	GString* text = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	XfmpcProgressBar* _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_ = 0.0;
	XfmpcProgressBar* _tmp6_;
	g_return_if_fail (self != NULL);
	fraction = 1.0;
	min = song_time / 60;
	sec = song_time % 60;
	min_total = time_total / 60;
	sec_total = time_total % 60;
	_tmp0_ = g_string_new ("");
	text = _tmp0_;
	_tmp1_ = text;
	g_string_append_printf (_tmp1_, "%d:%02d / %d:%02d", min, sec, min_total, sec_total);
	_tmp2_ = self->priv->progress_bar;
	_tmp3_ = text;
	_tmp4_ = _tmp3_->str;
	xfmpc_progress_bar_set_text (_tmp2_, _tmp4_);
	if (time_total > 0) {
		fraction = (gdouble) (((gfloat) song_time) / ((gfloat) time_total));
	}
	if (fraction <= 1.0) {
		_tmp5_ = fraction;
	} else {
		_tmp5_ = 1.0;
	}
	_tmp6_ = self->priv->progress_bar;
	xfmpc_progress_bar_set_fraction (_tmp6_, _tmp5_);
	_g_string_free0 (text);
}

void
xfmpc_interface_reset (XfmpcInterface* self)
{
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_set_time (self, 0, 0);
	xfmpc_interface_set_volume (self, 0);
	xfmpc_interface_update_title (self);
}

void
xfmpc_interface_update_title (XfmpcInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	if (xfmpc_mpdclient_is_playing (_tmp0_)) {
		XfmpcMpdclient* _tmp1_;
		const gchar* _tmp2_;
		gchar* text = NULL;
		XfmpcMpdclient* _tmp3_;
		const gchar* _tmp4_;
		XfmpcMpdclient* _tmp5_;
		const gchar* _tmp6_;
		XfmpcMpdclient* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp1_ = self->priv->mpdclient;
		_tmp2_ = xfmpc_mpdclient_get_title (_tmp1_);
		xfmpc_interface_set_title (self, _tmp2_);
		_tmp3_ = self->priv->mpdclient;
		_tmp4_ = xfmpc_mpdclient_get_artist (_tmp3_);
		_tmp5_ = self->priv->mpdclient;
		_tmp6_ = xfmpc_mpdclient_get_album (_tmp5_);
		_tmp7_ = self->priv->mpdclient;
		_tmp8_ = xfmpc_mpdclient_get_date (_tmp7_);
		_tmp9_ = g_strdup_printf (_ ("by \"%s\" from \"%s\" (%s)"), _tmp4_, _tmp6_, _tmp8_);
		text = _tmp9_;
		_tmp10_ = text;
		xfmpc_interface_set_subtitle (self, _tmp10_);
		_g_free0 (text);
	} else {
		XfmpcMpdclient* _tmp11_;
		_tmp11_ = self->priv->mpdclient;
		if (xfmpc_mpdclient_is_stopped (_tmp11_)) {
			xfmpc_interface_set_title (self, _ ("Stopped"));
			xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
		} else {
			XfmpcMpdclient* _tmp12_;
			_tmp12_ = self->priv->mpdclient;
			if (!xfmpc_mpdclient_is_connected (_tmp12_)) {
				xfmpc_interface_set_title (self, _ ("Not connected"));
				xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
			}
		}
	}
}

static void
xfmpc_interface_cb_song_changed (XfmpcInterface* self)
{
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}

static void
xfmpc_interface_cb_pp_changed (XfmpcInterface* self,
                               gboolean is_playing)
{
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, is_playing);
	xfmpc_interface_cb_song_changed (self);
}

static void
xfmpc_interface_cb_time_changed (XfmpcInterface* self,
                                 gint song_time)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->progress_bar_sync == FALSE) {
		return;
	}
	_tmp0_ = self->priv->mpdclient;
	xfmpc_interface_set_time (self, song_time, xfmpc_mpdclient_get_total_time (_tmp0_));
}

static void
xfmpc_interface_cb_total_time_changed (XfmpcInterface* self,
                                       gint total_time)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->progress_bar_sync == FALSE) {
		return;
	}
	_tmp0_ = self->priv->mpdclient;
	xfmpc_interface_set_time (self, xfmpc_mpdclient_get_time (_tmp0_), total_time);
}

static void
xfmpc_interface_cb_volume_changed (XfmpcInterface* self,
                                   gint volume)
{
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_volume (self, volume);
}

static void
xfmpc_interface_cb_playlist_changed (XfmpcInterface* self)
{
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}

static void
xfmpc_interface_cb_stopped (XfmpcInterface* self)
{
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_update_title (self);
}

static void
xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_previous (_tmp0_);
}

static void
xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_next (_tmp0_);
}

XfmpcInterface*
xfmpc_interface_construct (GType object_type)
{
	XfmpcInterface * self = NULL;
	self = (XfmpcInterface*) g_object_new (object_type, NULL);
	return self;
}

XfmpcInterface*
xfmpc_interface_new (void)
{
	return xfmpc_interface_construct (XFMPC_TYPE_INTERFACE);
}

static void
_xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	xfmpc_interface_cb_mpdclient_previous ((XfmpcInterface*) self);
}

static void
_xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	xfmpc_interface_pp_clicked ((XfmpcInterface*) self);
}

static void
_xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	xfmpc_interface_cb_mpdclient_next ((XfmpcInterface*) self);
}

static void
_xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender,
                                                                gdouble value,
                                                                gpointer self)
{
	xfmpc_interface_volume_changed ((XfmpcInterface*) self, value);
}

static gboolean
_xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                              GdkEventMotion* event,
                                                                              gpointer self)
{
	gboolean result;
	result = xfmpc_interface_cb_progress_box_motion_event ((XfmpcInterface*) self, event);
	return result;
}

static gboolean
_xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                            GdkEventButton* event,
                                                                            gpointer self)
{
	gboolean result;
	result = xfmpc_interface_cb_progress_box_press_event ((XfmpcInterface*) self, event);
	return result;
}

static gboolean
_xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                GdkEventButton* event,
                                                                                gpointer self)
{
	gboolean result;
	result = xfmpc_interface_cb_progress_box_release_event ((XfmpcInterface*) self, event);
	return result;
}

static void
_xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender,
                                                               gpointer self)
{
	xfmpc_interface_cb_song_changed ((XfmpcInterface*) self);
}

static void
_xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender,
                                                           gboolean is_playing,
                                                           gpointer self)
{
	xfmpc_interface_cb_pp_changed ((XfmpcInterface*) self, is_playing);
}

static void
_xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender,
                                                               gint song_time,
                                                               gpointer self)
{
	xfmpc_interface_cb_time_changed ((XfmpcInterface*) self, song_time);
}

static void
_xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender,
                                                                           gint total_time,
                                                                           gpointer self)
{
	xfmpc_interface_cb_total_time_changed ((XfmpcInterface*) self, total_time);
}

static void
_xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender,
                                                                   gint volume,
                                                                   gpointer self)
{
	xfmpc_interface_cb_volume_changed ((XfmpcInterface*) self, volume);
}

static void
_xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                       gpointer self)
{
	xfmpc_interface_cb_playlist_changed ((XfmpcInterface*) self);
}

static void
_xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender,
                                                     gpointer self)
{
	xfmpc_interface_cb_stopped ((XfmpcInterface*) self);
}

static GObject *
xfmpc_interface_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcInterface * self;
	XfmpcMpdclient* _tmp0_;
	XfmpcPreferences* _tmp1_;
	GtkImage* image = NULL;
	GtkImage* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkImage* _tmp6_;
	GtkButton* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkImage* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkImage* _tmp13_;
	GtkButton* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkImage* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkImage* _tmp20_;
	GtkButton* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkVolumeButton* _tmp23_;
	GtkVolumeButton* _tmp24_;
	GtkVolumeButton* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkAdjustment* adjustment = NULL;
	GtkVolumeButton* _tmp27_;
	GtkAdjustment* _tmp28_;
	GtkAdjustment* _tmp29_;
	GtkAdjustment* _tmp30_;
	GtkAdjustment* _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	GtkAdjustment* _tmp34_;
	GtkAdjustment* _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	GtkAdjustment* _tmp38_;
	GtkAdjustment* _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	GtkEventBox* progress_box = NULL;
	GtkEventBox* _tmp42_;
	XfmpcProgressBar* _tmp43_;
	XfmpcProgressBar* _tmp44_;
	XfmpcProgressBar* _tmp45_;
	GtkEventBox* _tmp46_;
	XfmpcProgressBar* _tmp47_;
	GtkEventBox* _tmp48_;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp49_;
	PangoAttribute* attr = NULL;
	PangoAttribute* _tmp50_;
	PangoAttribute* _tmp51_;
	PangoAttribute* _tmp52_;
	PangoAttrList* _tmp53_;
	PangoAttribute* _tmp54_;
	PangoAttribute* _tmp55_;
	PangoAttribute* _tmp56_;
	PangoAttribute* _tmp57_;
	PangoAttribute* _tmp58_;
	PangoAttrList* _tmp59_;
	PangoAttribute* _tmp60_;
	PangoAttribute* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	PangoAttrList* _tmp64_;
	GtkLabel* _tmp65_;
	GtkLabel* _tmp66_;
	GtkLabel* _tmp67_;
	GtkLabel* _tmp68_;
	PangoAttrList* _tmp69_;
	PangoAttribute* _tmp70_;
	PangoAttribute* _tmp71_;
	PangoAttribute* _tmp72_;
	PangoAttrList* _tmp73_;
	PangoAttribute* _tmp74_;
	PangoAttribute* _tmp75_;
	GtkLabel* _tmp76_;
	GtkLabel* _tmp77_;
	PangoAttrList* _tmp78_;
	GtkLabel* _tmp79_;
	GtkLabel* _tmp80_;
	GtkLabel* _tmp81_;
	GtkLabel* _tmp82_;
	GtkBox* box = NULL;
	GtkBox* _tmp83_;
	GtkBox* _tmp84_;
	GtkBox* _tmp85_;
	GtkButton* _tmp86_;
	GtkBox* _tmp87_;
	GtkButton* _tmp88_;
	GtkBox* _tmp89_;
	GtkButton* _tmp90_;
	GtkBox* _tmp91_;
	GtkEventBox* _tmp92_;
	GtkBox* _tmp93_;
	GtkVolumeButton* _tmp94_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp95_;
	GtkBox* _tmp96_;
	GtkBox* _tmp97_;
	GtkLabel* _tmp98_;
	GtkBox* _tmp99_;
	GtkLabel* _tmp100_;
	GtkButton* _tmp101_;
	GtkButton* _tmp102_;
	GtkButton* _tmp103_;
	GtkVolumeButton* _tmp104_;
	GtkEventBox* _tmp105_;
	GtkEventBox* _tmp106_;
	GtkEventBox* _tmp107_;
	XfmpcMpdclient* _tmp108_;
	XfmpcMpdclient* _tmp109_;
	XfmpcMpdclient* _tmp110_;
	XfmpcMpdclient* _tmp111_;
	XfmpcMpdclient* _tmp112_;
	XfmpcMpdclient* _tmp113_;
	XfmpcMpdclient* _tmp114_;
	parent_class = G_OBJECT_CLASS (xfmpc_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_INTERFACE, XfmpcInterface);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 4);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("media-skip-backward", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp2_);
	image = _tmp2_;
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->button_prev);
	self->priv->button_prev = _tmp3_;
	_tmp4_ = self->priv->button_prev;
	gtk_button_set_relief (_tmp4_, GTK_RELIEF_NONE);
	_tmp5_ = self->priv->button_prev;
	_tmp6_ = image;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->button_prev;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, "primary-button");
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (image);
	image = _tmp9_;
	_tmp10_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->button_pp);
	self->priv->button_pp = _tmp10_;
	_tmp11_ = self->priv->button_pp;
	gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
	_tmp12_ = self->priv->button_pp;
	_tmp13_ = image;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->button_pp;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_add_class (_tmp15_, "primary-button");
	_tmp16_ = (GtkImage*) gtk_image_new_from_icon_name ("media-skip-forward", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (image);
	image = _tmp16_;
	_tmp17_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->button_next);
	self->priv->button_next = _tmp17_;
	_tmp18_ = self->priv->button_next;
	gtk_button_set_relief (_tmp18_, GTK_RELIEF_NONE);
	_tmp19_ = self->priv->button_next;
	_tmp20_ = image;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->button_next;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	gtk_style_context_add_class (_tmp22_, "primary-button");
	_tmp23_ = (GtkVolumeButton*) gtk_volume_button_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->button_volume);
	self->priv->button_volume = _tmp23_;
	_tmp24_ = self->priv->button_volume;
	gtk_button_set_relief ((GtkButton*) _tmp24_, GTK_RELIEF_NONE);
	_tmp25_ = self->priv->button_volume;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "primary-button");
	_tmp27_ = self->priv->button_volume;
	_tmp28_ = gtk_scale_button_get_adjustment ((GtkScaleButton*) _tmp27_);
	_tmp29_ = _g_object_ref0 (_tmp28_);
	adjustment = _tmp29_;
	_tmp30_ = adjustment;
	_tmp31_ = adjustment;
	_tmp32_ = gtk_adjustment_get_upper (_tmp31_);
	_tmp33_ = _tmp32_;
	gtk_adjustment_set_upper (_tmp31_, _tmp33_ * 100);
	_tmp34_ = adjustment;
	_tmp35_ = adjustment;
	_tmp36_ = gtk_adjustment_get_step_increment (_tmp35_);
	_tmp37_ = _tmp36_;
	gtk_adjustment_set_step_increment (_tmp35_, _tmp37_ * 100);
	_tmp38_ = adjustment;
	_tmp39_ = adjustment;
	_tmp40_ = gtk_adjustment_get_page_increment (_tmp39_);
	_tmp41_ = _tmp40_;
	gtk_adjustment_set_page_increment (_tmp39_, _tmp41_ * 100);
	_tmp42_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp42_);
	progress_box = _tmp42_;
	_tmp43_ = xfmpc_progress_bar_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp43_;
	_tmp44_ = self->priv->progress_bar;
	xfmpc_progress_bar_set_text (_tmp44_, "0:00 / 0:00");
	_tmp45_ = self->priv->progress_bar;
	xfmpc_progress_bar_set_fraction (_tmp45_, 1.0);
	_tmp46_ = progress_box;
	_tmp47_ = self->priv->progress_bar;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = progress_box;
	gtk_event_box_set_above_child (_tmp48_, TRUE);
	_tmp49_ = pango_attr_list_new ();
	attrs = _tmp49_;
	_tmp50_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	attr = _tmp50_;
	_tmp51_ = attr;
	_tmp51_->start_index = (guint) 0;
	_tmp52_ = attr;
	_tmp52_->end_index = (guint) -1;
	_tmp53_ = attrs;
	_tmp54_ = attr;
	_tmp55_ = pango_attribute_copy (_tmp54_);
	pango_attr_list_insert (_tmp53_, _tmp55_);
	_tmp56_ = pango_attr_scale_new ((gdouble) PANGO_SCALE_X_LARGE);
	_pango_attribute_destroy0 (attr);
	attr = _tmp56_;
	_tmp57_ = attr;
	_tmp57_->start_index = (guint) 0;
	_tmp58_ = attr;
	_tmp58_->end_index = (guint) -1;
	_tmp59_ = attrs;
	_tmp60_ = attr;
	_tmp61_ = pango_attribute_copy (_tmp60_);
	pango_attr_list_insert (_tmp59_, _tmp61_);
	_tmp62_ = (GtkLabel*) gtk_label_new (_ ("Not connected"));
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (self->priv->title);
	self->priv->title = _tmp62_;
	_tmp63_ = self->priv->title;
	_tmp64_ = attrs;
	gtk_label_set_attributes (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->title;
	gtk_label_set_selectable (_tmp65_, TRUE);
	_tmp66_ = self->priv->title;
	gtk_label_set_ellipsize (_tmp66_, PANGO_ELLIPSIZE_END);
	_tmp67_ = self->priv->title;
	gtk_label_set_xalign (_tmp67_, 0.0f);
	_tmp68_ = self->priv->title;
	gtk_label_set_yalign (_tmp68_, 0.5f);
	_tmp69_ = pango_attr_list_new ();
	_pango_attr_list_unref0 (attrs);
	attrs = _tmp69_;
	_tmp70_ = pango_attr_scale_new ((gdouble) PANGO_SCALE_SMALL);
	_pango_attribute_destroy0 (attr);
	attr = _tmp70_;
	_tmp71_ = attr;
	_tmp71_->start_index = (guint) 0;
	_tmp72_ = attr;
	_tmp72_->end_index = (guint) -1;
	_tmp73_ = attrs;
	_tmp74_ = attr;
	_tmp75_ = pango_attribute_copy (_tmp74_);
	pango_attr_list_insert (_tmp73_, _tmp75_);
	_tmp76_ = (GtkLabel*) gtk_label_new (PACKAGE_STRING);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->subtitle);
	self->priv->subtitle = _tmp76_;
	_tmp77_ = self->priv->subtitle;
	_tmp78_ = attrs;
	gtk_label_set_attributes (_tmp77_, _tmp78_);
	_tmp79_ = self->priv->subtitle;
	gtk_label_set_selectable (_tmp79_, TRUE);
	_tmp80_ = self->priv->subtitle;
	gtk_label_set_ellipsize (_tmp80_, PANGO_ELLIPSIZE_END);
	_tmp81_ = self->priv->subtitle;
	gtk_label_set_xalign (_tmp81_, 0.0f);
	_tmp82_ = self->priv->subtitle;
	gtk_label_set_yalign (_tmp82_, 0.5f);
	_tmp83_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp83_);
	box = _tmp83_;
	_tmp84_ = box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 0);
	_tmp85_ = box;
	_tmp86_ = self->priv->button_prev;
	gtk_box_pack_start (_tmp85_, (GtkWidget*) _tmp86_, FALSE, FALSE, (guint) 0);
	_tmp87_ = box;
	_tmp88_ = self->priv->button_pp;
	gtk_box_pack_start (_tmp87_, (GtkWidget*) _tmp88_, FALSE, FALSE, (guint) 0);
	_tmp89_ = box;
	_tmp90_ = self->priv->button_next;
	gtk_box_pack_start (_tmp89_, (GtkWidget*) _tmp90_, FALSE, FALSE, (guint) 0);
	_tmp91_ = box;
	_tmp92_ = progress_box;
	gtk_box_pack_start (_tmp91_, (GtkWidget*) _tmp92_, TRUE, TRUE, (guint) 4);
	_tmp93_ = box;
	_tmp94_ = self->priv->button_volume;
	gtk_box_pack_start (_tmp93_, (GtkWidget*) _tmp94_, FALSE, FALSE, (guint) 0);
	_tmp95_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp95_);
	vbox = _tmp95_;
	_tmp96_ = vbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp96_, FALSE, TRUE, (guint) 0);
	_tmp97_ = vbox;
	_tmp98_ = self->priv->title;
	gtk_container_add ((GtkContainer*) _tmp97_, (GtkWidget*) _tmp98_);
	_tmp99_ = vbox;
	_tmp100_ = self->priv->subtitle;
	gtk_container_add ((GtkContainer*) _tmp99_, (GtkWidget*) _tmp100_);
	_tmp101_ = self->priv->button_prev;
	g_signal_connect_object (_tmp101_, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked, self, 0);
	_tmp102_ = self->priv->button_pp;
	g_signal_connect_object (_tmp102_, "clicked", (GCallback) _xfmpc_interface_pp_clicked_gtk_button_clicked, self, 0);
	_tmp103_ = self->priv->button_next;
	g_signal_connect_object (_tmp103_, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked, self, 0);
	_tmp104_ = self->priv->button_volume;
	g_signal_connect_object ((GtkScaleButton*) _tmp104_, "value-changed", (GCallback) _xfmpc_interface_volume_changed_gtk_scale_button_value_changed, self, 0);
	_tmp105_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp105_, "motion-notify-event", (GCallback) _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event, self, 0);
	_tmp106_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp106_, "button-press-event", (GCallback) _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event, self, 0);
	_tmp107_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp107_, "button-release-event", (GCallback) _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event, self, 0);
	_tmp108_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp108_, "song-changed", (GCallback) _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed, self, 0);
	_tmp109_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp109_, "pp-changed", (GCallback) _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp110_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp110_, "time-changed", (GCallback) _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed, self, 0);
	_tmp111_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp111_, "total-time-changed", (GCallback) _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed, self, 0);
	_tmp112_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp112_, "volume-changed", (GCallback) _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed, self, 0);
	_tmp113_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp113_, "playlist-changed", (GCallback) _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp114_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp114_, "stopped", (GCallback) _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped, self, 0);
	_g_object_unref0 (vbox);
	_g_object_unref0 (box);
	_pango_attribute_destroy0 (attr);
	_pango_attr_list_unref0 (attrs);
	_g_object_unref0 (progress_box);
	_g_object_unref0 (adjustment);
	_g_object_unref0 (image);
	return obj;
}

static void
xfmpc_interface_class_init (XfmpcInterfaceClass * klass,
                            gpointer klass_data)
{
	xfmpc_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XfmpcInterface_private_offset);
	G_OBJECT_CLASS (klass)->constructor = xfmpc_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_interface_finalize;
}

static void
xfmpc_interface_instance_init (XfmpcInterface * self,
                               gpointer klass)
{
	self->priv = xfmpc_interface_get_instance_private (self);
	self->priv->progress_bar_sync = TRUE;
}

static void
xfmpc_interface_finalize (GObject * obj)
{
	XfmpcInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_INTERFACE, XfmpcInterface);
	_g_object_unref0 (self->priv->button_prev);
	_g_object_unref0 (self->priv->button_pp);
	_g_object_unref0 (self->priv->button_next);
	_g_object_unref0 (self->priv->button_volume);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->title);
	_g_object_unref0 (self->priv->subtitle);
	G_OBJECT_CLASS (xfmpc_interface_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
xfmpc_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XfmpcInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcInterface), 0, (GInstanceInitFunc) xfmpc_interface_instance_init, NULL };
	GType xfmpc_interface_type_id;
	xfmpc_interface_type_id = g_type_register_static (gtk_box_get_type (), "XfmpcInterface", &g_define_type_info, 0);
	XfmpcInterface_private_offset = g_type_add_instance_private (xfmpc_interface_type_id, sizeof (XfmpcInterfacePrivate));
	return xfmpc_interface_type_id;
}

GType
xfmpc_interface_get_type (void)
{
	static volatile gsize xfmpc_interface_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_interface_type_id__once)) {
		GType xfmpc_interface_type_id;
		xfmpc_interface_type_id = xfmpc_interface_get_type_once ();
		g_once_init_leave (&xfmpc_interface_type_id__once, xfmpc_interface_type_id);
	}
	return xfmpc_interface_type_id__once;
}

