// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Dialog, DialogPresentationMode, NavigationPage, PreferencesPage, Toast};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwPreferencesDialog")]
    pub struct PreferencesDialog(Object<ffi::AdwPreferencesDialog, ffi::AdwPreferencesDialogClass>) @extends Dialog, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::ShortcutManager;

    match fn {
        type_ => || ffi::adw_preferences_dialog_get_type(),
    }
}

impl PreferencesDialog {
    pub const NONE: Option<&'static PreferencesDialog> = None;

    #[doc(alias = "adw_preferences_dialog_new")]
    pub fn new() -> PreferencesDialog {
        assert_initialized_main_thread!();
        unsafe { Dialog::from_glib_none(ffi::adw_preferences_dialog_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PreferencesDialog`] objects.
    ///
    /// This method returns an instance of [`PreferencesDialogBuilder`](crate::builders::PreferencesDialogBuilder) which can be used to create [`PreferencesDialog`] objects.
    pub fn builder() -> PreferencesDialogBuilder {
        PreferencesDialogBuilder::new()
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl Default for PreferencesDialog {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PreferencesDialog`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PreferencesDialogBuilder {
    builder: glib::object::ObjectBuilder<'static, PreferencesDialog>,
}

impl PreferencesDialogBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn search_enabled(self, search_enabled: bool) -> Self {
        Self {
            builder: self.builder.property("search-enabled", search_enabled),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn visible_page(self, visible_page: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("visible-page", visible_page.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn visible_page_name(self, visible_page_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("visible-page-name", visible_page_name.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn can_close(self, can_close: bool) -> Self {
        Self {
            builder: self.builder.property("can-close", can_close),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn child(self, child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn content_height(self, content_height: i32) -> Self {
        Self {
            builder: self.builder.property("content-height", content_height),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn content_width(self, content_width: i32) -> Self {
        Self {
            builder: self.builder.property("content-width", content_width),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn default_widget(self, default_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-widget", default_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn focus_widget(self, focus_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("focus-widget", focus_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn follows_content_size(self, follows_content_size: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("follows-content-size", follows_content_size),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn presentation_mode(self, presentation_mode: DialogPresentationMode) -> Self {
        Self {
            builder: self
                .builder
                .property("presentation-mode", presentation_mode),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PreferencesDialog`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PreferencesDialog {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

pub trait PreferencesDialogExt: IsA<PreferencesDialog> + 'static {
    #[doc(alias = "adw_preferences_dialog_add")]
    fn add(&self, page: &impl IsA<PreferencesPage>) {
        unsafe {
            ffi::adw_preferences_dialog_add(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_preferences_dialog_add_toast")]
    fn add_toast(&self, toast: Toast) {
        unsafe {
            ffi::adw_preferences_dialog_add_toast(
                self.as_ref().to_glib_none().0,
                toast.into_glib_ptr(),
            );
        }
    }

    #[doc(alias = "adw_preferences_dialog_get_search_enabled")]
    #[doc(alias = "get_search_enabled")]
    #[doc(alias = "search-enabled")]
    fn is_search_enabled(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_preferences_dialog_get_search_enabled(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_preferences_dialog_get_visible_page")]
    #[doc(alias = "get_visible_page")]
    #[doc(alias = "visible-page")]
    fn visible_page(&self) -> Option<PreferencesPage> {
        unsafe {
            from_glib_none(ffi::adw_preferences_dialog_get_visible_page(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_preferences_dialog_get_visible_page_name")]
    #[doc(alias = "get_visible_page_name")]
    #[doc(alias = "visible-page-name")]
    fn visible_page_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_preferences_dialog_get_visible_page_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_preferences_dialog_pop_subpage")]
    fn pop_subpage(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_preferences_dialog_pop_subpage(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_preferences_dialog_push_subpage")]
    fn push_subpage(&self, page: &impl IsA<NavigationPage>) {
        unsafe {
            ffi::adw_preferences_dialog_push_subpage(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_preferences_dialog_remove")]
    fn remove(&self, page: &impl IsA<PreferencesPage>) {
        unsafe {
            ffi::adw_preferences_dialog_remove(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_preferences_dialog_set_search_enabled")]
    #[doc(alias = "search-enabled")]
    fn set_search_enabled(&self, search_enabled: bool) {
        unsafe {
            ffi::adw_preferences_dialog_set_search_enabled(
                self.as_ref().to_glib_none().0,
                search_enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_preferences_dialog_set_visible_page")]
    #[doc(alias = "visible-page")]
    fn set_visible_page(&self, page: &impl IsA<PreferencesPage>) {
        unsafe {
            ffi::adw_preferences_dialog_set_visible_page(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_preferences_dialog_set_visible_page_name")]
    #[doc(alias = "visible-page-name")]
    fn set_visible_page_name(&self, name: &str) {
        unsafe {
            ffi::adw_preferences_dialog_set_visible_page_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "search-enabled")]
    fn connect_search_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_search_enabled_trampoline<
            P: IsA<PreferencesDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwPreferencesDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PreferencesDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::search-enabled".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_search_enabled_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "visible-page")]
    fn connect_visible_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_page_trampoline<
            P: IsA<PreferencesDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwPreferencesDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PreferencesDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visible-page".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visible_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "visible-page-name")]
    fn connect_visible_page_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_page_name_trampoline<
            P: IsA<PreferencesDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwPreferencesDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PreferencesDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visible-page-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visible_page_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<PreferencesDialog>> PreferencesDialogExt for O {}
