const char sysprof_collapse_lua[] =
"local parse = require \"sysprof.parse\"\n"
"local vmdef = require \"jit.vmdef\"\n"
"local symtab = require \"utils.symtab\"\n"
"\n"
"local VMST_NAMES = {\n"
"  [parse.VMST.INTERP] = \"VMST_INTERP\",\n"
"  [parse.VMST.LFUNC]  = \"VMST_LFUNC\",\n"
"  [parse.VMST.FFUNC]  = \"VMST_FFUNC\",\n"
"  [parse.VMST.CFUNC]  = \"VMST_CFUNC\",\n"
"  [parse.VMST.GC]     = \"VMST_GC\",\n"
"  [parse.VMST.EXIT]   = \"VMST_EXIT\",\n"
"  [parse.VMST.RECORD] = \"VMST_RECORD\",\n"
"  [parse.VMST.OPT]    = \"VMST_OPT\",\n"
"  [parse.VMST.ASM]    = \"VMST_ASM\",\n"
"  [parse.VMST.TRACE]  = \"VMST_TRACE\",\n"
"}\n"
"\n"
"local M = {}\n"
"\n"
"local function new_node(name, is_leaf)\n"
"  return {\n"
"    name = name,\n"
"    count = 0,\n"
"    is_leaf = is_leaf,\n"
"    children = {}\n"
"  }\n"
"end\n"
"\n"
"-- insert new child into a node (or increase counter in existing one)\n"
"local function insert(name, node, is_leaf)\n"
"  if node.children[name] == nil then\n"
"    node.children[name] = new_node(name, is_leaf)\n"
"  end\n"
"\n"
"  local child = node.children[name]\n"
"  child.count = child.count + 1\n"
"\n"
"  return child\n"
"end\n"
"\n"
"local function insert_lua_callchain(chain, lua, symbols)\n"
"  local ins_cnt = 0\n"
"  for _,fr in pairs(lua.callchain) do\n"
"    local name_lua\n"
"\n"
"    ins_cnt = ins_cnt + 1\n"
"    if fr.type == parse.FRAME.FFUNC then\n"
"      name_lua = vmdef.ffnames[fr.ffid]\n"
"    else\n"
"      name_lua = symtab.demangle(symbols, {\n"
"        addr = fr.addr,\n"
"        line = fr.line,\n"
"        gen = fr.gen\n"
"      })\n"
"      if lua.trace.traceno ~= nil and lua.trace.addr == fr.addr and\n"
"          lua.trace.line == fr.line then\n"
"        name_lua = symtab.demangle(symbols, {\n"
"          addr = fr.addr,\n"
"          traceno = lua.trace.traceno,\n"
"          gen = fr.gen\n"
"        })\n"
"      end\n"
"\n"
"      if fr.type == parse.FRAME.CFUNC then\n"
"        -- C function encountered, the next chunk\n"
"        -- of frames is located on the C stack.\n"
"        break\n"
"      end\n"
"    end\n"
"\n"
"    table.insert(chain, 1, { name = name_lua })\n"
"  end\n"
"  table.remove(lua.callchain, ins_cnt)\n"
"end\n"
"\n"
"-- merge lua and host callchains into one callchain representing\n"
"-- transfer of control\n"
"local function merge(event, symbols, sep_vmst)\n"
"  local cc = {}\n"
"\n"
"  for _,h_fr in pairs(event.host.callchain) do\n"
"    local name_host = symtab.demangle(symbols, {\n"
"      addr = h_fr.addr,\n"
"      gen = h_fr.gen\n"
"    })\n"
"    table.insert(cc, 1, { name = name_host })\n"
"\n"
"    if string.match(name_host, '^lua_cpcall') ~= nil then\n"
"      -- Any C function is present on both the C and the Lua\n"
"      -- stacks. It is more convenient to get its info from the\n"
"      -- host stack, since it has information about child frames.\n"
"      table.remove(event.lua.callchain, 1)\n"
"    end\n"
"\n"
"    if string.match(name_host, '^lua_p\?call') ~= nil then\n"
"      insert_lua_callchain(cc, event.lua, symbols)\n"
"    end\n"
"\n"
"  end\n"
"\n"
"  if sep_vmst == true then\n"
"    table.insert(cc, { name = VMST_NAMES[event.lua.vmstate] })\n"
"  end\n"
"\n"
"  return cc\n"
"end\n"
"\n"
"-- Collapse all the events into call tree\n"
"function M.collapse(events, symbols, sep_vmst)\n"
"  local root = new_node('root', false)\n"
"\n"
"  for _,ev in pairs(events) do\n"
"    local callchain = merge(ev, symbols, sep_vmst)\n"
"    local curr_node = root\n"
"    for i=#callchain,1,-1 do\n"
"      curr_node = insert(callchain[i].name, curr_node, false)\n"
"    end\n"
"    insert('', curr_node, true)\n"
"  end\n"
"\n"
"  return root\n"
"end\n"
"\n"
"return M\n"
""
;
