/* CustomShortcutRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CustomShortcutRow.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2025 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "keyboard.h"
#include <glib.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW (keyboard_shortcuts_custom_shortcut_row_get_type ())
#define KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, KeyboardShortcutsCustomShortcutRow))
#define KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, KeyboardShortcutsCustomShortcutRowClass))
#define KEYBOARD_SHORTCUTS_IS_CUSTOM_SHORTCUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW))
#define KEYBOARD_SHORTCUTS_IS_CUSTOM_SHORTCUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW))
#define KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, KeyboardShortcutsCustomShortcutRowClass))

typedef struct _KeyboardShortcutsCustomShortcutRow KeyboardShortcutsCustomShortcutRow;
typedef struct _KeyboardShortcutsCustomShortcutRowClass KeyboardShortcutsCustomShortcutRowClass;
typedef struct _KeyboardShortcutsCustomShortcutRowPrivate KeyboardShortcutsCustomShortcutRowPrivate;
enum  {
	KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_0_PROPERTY,
	KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_PROPERTY,
	KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_NUM_PROPERTIES
};
static GParamSpec* keyboard_shortcuts_custom_shortcut_row_properties[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_NUM_PROPERTIES];
#define _keyboard_shortcuts_custom_shortcuts_parsed_shortcut_free0(var) ((var == NULL) ? NULL : (var = (keyboard_shortcuts_custom_shortcuts_parsed_shortcut_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
enum  {
	KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_CHANGED_SIGNAL,
	KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_NUM_SIGNALS
};
static guint keyboard_shortcuts_custom_shortcut_row_signals[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_NUM_SIGNALS] = {0};

struct _KeyboardShortcutsCustomShortcutRow {
	GtkListBoxRow parent_instance;
	KeyboardShortcutsCustomShortcutRowPrivate * priv;
};

struct _KeyboardShortcutsCustomShortcutRowClass {
	GtkListBoxRowClass parent_class;
};

struct _KeyboardShortcutsCustomShortcutRowPrivate {
	KeyboardShortcutsCustomShortcutsParsedShortcut* _shortcut;
	GtkButton* clear_button;
	GtkBox* keycap_box;
	GtkLabel* status_label;
	GtkStack* keycap_stack;
	gboolean is_editing_shortcut;
};

struct _Block19Data {
	int _ref_count_;
	KeyboardShortcutsCustomShortcutRow* self;
	GraniteMessageDialog* message_dialog;
};

struct _Block20Data {
	int _ref_count_;
	KeyboardShortcutsCustomShortcutRow* self;
	GtkPopover* popover;
};

static gint KeyboardShortcutsCustomShortcutRow_private_offset;
static gpointer keyboard_shortcuts_custom_shortcut_row_parent_class = NULL;

VALA_EXTERN GType keyboard_shortcuts_custom_shortcut_row_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyboardShortcutsCustomShortcutRow* keyboard_shortcuts_custom_shortcut_row_new (KeyboardShortcutsCustomShortcutsParsedShortcut* shortcut);
VALA_EXTERN KeyboardShortcutsCustomShortcutRow* keyboard_shortcuts_custom_shortcut_row_construct (GType object_type,
                                                                                      KeyboardShortcutsCustomShortcutsParsedShortcut* shortcut);
static void keyboard_shortcuts_custom_shortcut_row_edit_shortcut (KeyboardShortcutsCustomShortcutRow* self,
                                                           gboolean start_editing);
static void keyboard_shortcuts_custom_shortcut_row_render_keycaps (KeyboardShortcutsCustomShortcutRow* self);
static void keyboard_shortcuts_custom_shortcut_row_on_key_released (KeyboardShortcutsCustomShortcutRow* self,
                                                             GtkEventControllerKey* controller,
                                                             guint keyval,
                                                             guint keycode,
                                                             GdkModifierType state);
static void keyboard_shortcuts_custom_shortcut_row_update_binding (KeyboardShortcutsCustomShortcutRow* self,
                                                            KeyboardShortcutsShortcut* new_shortcut);
VALA_EXTERN gboolean keyboard_shortcuts_conflicts_manager_shortcut_conflicts (KeyboardShortcutsShortcut* shortcut,
                                                                  gchar** name,
                                                                  gchar** group);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void ___lambda66_ (Block19Data* _data19_);
static void ____lambda66__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN KeyboardShortcutsCustomShortcutsParsedShortcut* keyboard_shortcuts_custom_shortcut_row_get_shortcut (KeyboardShortcutsCustomShortcutRow* self);
static void keyboard_shortcuts_custom_shortcut_row_build_keycap_box (KeyboardShortcutsCustomShortcutRow* self,
                                                              const gchar* value_string,
                                                              GtkBox** box);
VALA_EXTERN void keyboard_shortcuts_custom_shortcut_row_set_shortcut (KeyboardShortcutsCustomShortcutRow* self,
                                                          KeyboardShortcutsCustomShortcutsParsedShortcut* value);
static gboolean _keyboard_shortcuts_custom_shortcuts_parsed_shortcut_equal (const KeyboardShortcutsCustomShortcutsParsedShortcut * s1,
                                                                     const KeyboardShortcutsCustomShortcutsParsedShortcut * s2);
static GObject * keyboard_shortcuts_custom_shortcut_row_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void _keyboard_shortcuts_custom_shortcut_row___lambda67_ (Block20Data* _data20_);
static void __keyboard_shortcuts_custom_shortcut_row___lambda67__gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void _keyboard_shortcuts_custom_shortcut_row___lambda68_ (Block20Data* _data20_);
static void __keyboard_shortcuts_custom_shortcut_row___lambda68__gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void _keyboard_shortcuts_custom_shortcut_row___lambda69_ (Block20Data* _data20_);
static void __keyboard_shortcuts_custom_shortcut_row___lambda69__gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void _keyboard_shortcuts_custom_shortcut_row___lambda70_ (KeyboardShortcutsCustomShortcutRow* self);
static void __keyboard_shortcuts_custom_shortcut_row___lambda70__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                      gint n_press,
                                                                                      gdouble x,
                                                                                      gdouble y,
                                                                                      gpointer self);
static void _keyboard_shortcuts_custom_shortcut_row___lambda71_ (KeyboardShortcutsCustomShortcutRow* self);
static void __keyboard_shortcuts_custom_shortcut_row___lambda71__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                      gint n_press,
                                                                                      gdouble x,
                                                                                      gdouble y,
                                                                                      gpointer self);
static void _keyboard_shortcuts_custom_shortcut_row_on_key_released_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                                    guint keyval,
                                                                                                    guint keycode,
                                                                                                    GdkModifierType state,
                                                                                                    gpointer self);
static void _keyboard_shortcuts_custom_shortcut_row___lambda72_ (KeyboardShortcutsCustomShortcutRow* self);
static void __keyboard_shortcuts_custom_shortcut_row___lambda72__gtk_event_controller_focus_leave (GtkEventControllerFocus* _sender,
                                                                                            gpointer self);
static void keyboard_shortcuts_custom_shortcut_row_finalize (GObject * obj);
static GType keyboard_shortcuts_custom_shortcut_row_get_type_once (void);
static void _vala_keyboard_shortcuts_custom_shortcut_row_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_keyboard_shortcuts_custom_shortcut_row_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
keyboard_shortcuts_custom_shortcut_row_get_instance_private (KeyboardShortcutsCustomShortcutRow* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardShortcutsCustomShortcutRow_private_offset);
}

KeyboardShortcutsCustomShortcutRow*
keyboard_shortcuts_custom_shortcut_row_construct (GType object_type,
                                                  KeyboardShortcutsCustomShortcutsParsedShortcut* shortcut)
{
	KeyboardShortcutsCustomShortcutRow * self = NULL;
	KeyboardShortcutsCustomShortcutsParsedShortcut _tmp0_;
	g_return_val_if_fail (shortcut != NULL, NULL);
	_tmp0_ = *shortcut;
	self = (KeyboardShortcutsCustomShortcutRow*) g_object_new (object_type, "shortcut", &_tmp0_, NULL);
	return self;
}

KeyboardShortcutsCustomShortcutRow*
keyboard_shortcuts_custom_shortcut_row_new (KeyboardShortcutsCustomShortcutsParsedShortcut* shortcut)
{
	return keyboard_shortcuts_custom_shortcut_row_construct (KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, shortcut);
}

static void
keyboard_shortcuts_custom_shortcut_row_edit_shortcut (KeyboardShortcutsCustomShortcutRow* self,
                                                      gboolean start_editing)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (start_editing) {
		_tmp0_ = !self->priv->is_editing_shortcut;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkRoot* _tmp1_;
		GdkSurface* _tmp2_;
		GtkStack* _tmp3_;
		GtkLabel* _tmp4_;
		GtkLabel* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp2_ = gtk_native_get_surface ((GtkNative*) _tmp1_);
		gdk_toplevel_inhibit_system_shortcuts (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gdk_toplevel_get_type (), GdkToplevel), NULL);
		_tmp3_ = self->priv->keycap_stack;
		_tmp4_ = self->priv->status_label;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->status_label;
		gtk_label_set_label (_tmp5_, _ ("Enter new shortcut…"));
		_tmp6_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp7_ = _tmp6_;
		gtk_list_box_select_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_get_type (), GtkListBox), (GtkListBoxRow*) self);
		gtk_widget_grab_focus ((GtkWidget*) self);
	} else {
		gboolean _tmp8_ = FALSE;
		if (!start_editing) {
			_tmp8_ = self->priv->is_editing_shortcut;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkRoot* _tmp9_;
			GdkSurface* _tmp10_;
			_tmp9_ = gtk_widget_get_root ((GtkWidget*) self);
			_tmp10_ = gtk_native_get_surface ((GtkNative*) _tmp9_);
			gdk_toplevel_restore_system_shortcuts (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gdk_toplevel_get_type (), GdkToplevel));
			keyboard_shortcuts_custom_shortcut_row_render_keycaps (self);
		}
	}
	self->priv->is_editing_shortcut = start_editing;
}

static void
keyboard_shortcuts_custom_shortcut_row_on_key_released (KeyboardShortcutsCustomShortcutRow* self,
                                                        GtkEventControllerKey* controller,
                                                        guint keyval,
                                                        guint keycode,
                                                        GdkModifierType state)
{
	GdkModifierType mods = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	if (!self->priv->is_editing_shortcut) {
		return;
	}
	mods = state & gtk_accelerator_get_default_mod_mask ();
	if (mods > 0) {
		KeyboardShortcutsShortcut* shortcut = NULL;
		KeyboardShortcutsShortcut* _tmp0_;
		KeyboardShortcutsShortcut* _tmp1_;
		_tmp0_ = keyboard_shortcuts_shortcut_new (keyval, mods);
		shortcut = _tmp0_;
		_tmp1_ = shortcut;
		keyboard_shortcuts_custom_shortcut_row_update_binding (self, _tmp1_);
		_g_object_unref0 (shortcut);
	} else {
		switch (keyval) {
			case GDK_KEY_Escape:
			{
				break;
			}
			case GDK_KEY_F2:
			case GDK_KEY_F3:
			case GDK_KEY_F4:
			case GDK_KEY_F5:
			case GDK_KEY_F6:
			case GDK_KEY_F7:
			case GDK_KEY_F8:
			case GDK_KEY_F9:
			case GDK_KEY_F10:
			case GDK_KEY_F12:
			case GDK_KEY_Menu:
			case GDK_KEY_Print:
			case GDK_KEY_Mail:
			case GDK_KEY_Explorer:
			case GDK_KEY_AudioMedia:
			case GDK_KEY_WWW:
			case GDK_KEY_AudioRaiseVolume:
			case GDK_KEY_AudioLowerVolume:
			case GDK_KEY_AudioMute:
			case GDK_KEY_AudioPlay:
			case GDK_KEY_AudioPause:
			case GDK_KEY_AudioStop:
			case GDK_KEY_AudioPrev:
			case GDK_KEY_AudioNext:
			case GDK_KEY_Eject:
			{
				KeyboardShortcutsShortcut* shortcut = NULL;
				KeyboardShortcutsShortcut* _tmp2_;
				KeyboardShortcutsShortcut* _tmp3_;
				_tmp2_ = keyboard_shortcuts_shortcut_new (keyval, mods);
				shortcut = _tmp2_;
				_tmp3_ = shortcut;
				keyboard_shortcuts_custom_shortcut_row_update_binding (self, _tmp3_);
				_g_object_unref0 (shortcut);
				break;
			}
			default:
			{
				return;
			}
		}
	}
	keyboard_shortcuts_custom_shortcut_row_edit_shortcut (self, FALSE);
	return;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		KeyboardShortcutsCustomShortcutRow* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->message_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda66_ (Block19Data* _data19_)
{
	KeyboardShortcutsCustomShortcutRow* self;
	GraniteMessageDialog* _tmp0_;
	self = _data19_->self;
	_tmp0_ = _data19_->message_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
____lambda66__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda66_ (self);
}

static void
keyboard_shortcuts_custom_shortcut_row_update_binding (KeyboardShortcutsCustomShortcutRow* self,
                                                       KeyboardShortcutsShortcut* new_shortcut)
{
	gchar* conflict_name = NULL;
	gchar* _tmp0_;
	gchar* group = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_shortcut != NULL);
	_tmp0_ = g_strdup ("");
	conflict_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	group = _tmp1_;
	_tmp4_ = keyboard_shortcuts_conflicts_manager_shortcut_conflicts (new_shortcut, &_tmp2_, &_tmp3_);
	_g_free0 (conflict_name);
	conflict_name = _tmp2_;
	_g_free0 (group);
	group = _tmp3_;
	if (_tmp4_) {
		Block19Data* _data19_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GThemedIcon* _tmp11_;
		GThemedIcon* _tmp12_;
		GThemedIcon* _tmp13_;
		GtkRoot* _tmp14_;
		GtkWindow* _tmp15_;
		GraniteMessageDialog* _tmp16_ = NULL;
		GraniteMessageDialog* _tmp17_;
		GraniteMessageDialog* _tmp18_;
		GraniteMessageDialog* _tmp19_;
		_data19_ = g_slice_new0 (Block19Data);
		_data19_->_ref_count_ = 1;
		_data19_->self = g_object_ref (self);
		_tmp5_ = keyboard_shortcuts_shortcut_to_readable (new_shortcut);
		_tmp6_ = _tmp5_;
		_tmp7_ = group;
		_tmp8_ = conflict_name;
		_tmp9_ = g_strdup_printf (_ ("“%s” is already used for “%s → %s”."), _tmp6_, _tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-keyboard");
		_tmp12_ = _tmp11_;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp14_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_window_get_type (), GtkWindow));
		_tmp16_ = granite_message_dialog_new (_ ("Unable to set new shortcut due to conflicts"), _tmp10_, (GIcon*) _tmp12_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp16_, (GIcon*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		gtk_window_set_modal ((GtkWindow*) _tmp16_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp16_, _tmp15_);
		_g_object_unref0 (_tmp15_);
		g_object_ref_sink (_tmp16_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp6_);
		_data19_->message_dialog = _tmp17_;
		_tmp18_ = _data19_->message_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ____lambda66__gtk_dialog_response, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
		_tmp19_ = _data19_->message_dialog;
		gtk_window_present ((GtkWindow*) _tmp19_);
		block19_data_unref (_data19_);
		_data19_ = NULL;
		_g_free0 (group);
		_g_free0 (conflict_name);
		return;
	} else {
		KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp20_;
		gchar* _tmp21_;
		gchar** _tmp22_;
		_tmp20_ = self->priv->_shortcut;
		_tmp21_ = keyboard_shortcuts_shortcut_to_gsettings (new_shortcut);
		_tmp22_ = g_new0 (gchar*, 1 + 1);
		_tmp22_[0] = _tmp21_;
		(*_tmp20_).keybindings = (_vala_array_free ((*_tmp20_).keybindings, (*_tmp20_).keybindings_length1, (GDestroyNotify) g_free), NULL);
		(*_tmp20_).keybindings = _tmp22_;
		(*_tmp20_).keybindings_length1 = 1;
		g_signal_emit (self, keyboard_shortcuts_custom_shortcut_row_signals[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_CHANGED_SIGNAL], 0);
	}
	_g_free0 (group);
	_g_free0 (conflict_name);
}

static void
keyboard_shortcuts_custom_shortcut_row_render_keycaps (KeyboardShortcutsCustomShortcutRow* self)
{
	const gchar* _tmp0_ = NULL;
	KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* value_string = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_shortcut;
	_tmp2_ = (*_tmp1_).keybindings;
	_tmp2__length1 = (*_tmp1_).keybindings_length1;
	if (_tmp2__length1 > 0) {
		KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->_shortcut;
		_tmp4_ = (*_tmp3_).keybindings;
		_tmp4__length1 = (*_tmp3_).keybindings_length1;
		_tmp5_ = _tmp4_[0];
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = "";
	}
	_tmp6_ = g_strdup (_tmp0_);
	value_string = _tmp6_;
	_tmp7_ = value_string;
	if (g_strcmp0 (_tmp7_, "") != 0) {
		const gchar* _tmp8_;
		GtkStack* _tmp9_;
		GtkBox* _tmp10_;
		GtkButton* _tmp11_;
		_tmp8_ = value_string;
		keyboard_shortcuts_custom_shortcut_row_build_keycap_box (self, _tmp8_, &self->priv->keycap_box);
		_tmp9_ = self->priv->keycap_stack;
		_tmp10_ = self->priv->keycap_box;
		gtk_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
		_tmp11_ = self->priv->clear_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
	} else {
		GtkButton* _tmp12_;
		GtkStack* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		_tmp12_ = self->priv->clear_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
		_tmp13_ = self->priv->keycap_stack;
		_tmp14_ = self->priv->status_label;
		gtk_stack_set_visible_child (_tmp13_, (GtkWidget*) _tmp14_);
		_tmp15_ = self->priv->status_label;
		gtk_label_set_label (_tmp15_, _ ("Disabled"));
	}
	_g_free0 (value_string);
}

static void
keyboard_shortcuts_custom_shortcut_row_build_keycap_box (KeyboardShortcutsCustomShortcutRow* self,
                                                         const gchar* value_string,
                                                         GtkBox** box)
{
	gchar* accels_string = NULL;
	gchar* _tmp0_;
	gchar** accels = NULL;
	gchar** _tmp1_;
	gint accels_length1;
	gint _accels_size_;
	const gchar* _tmp2_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value_string != NULL);
	g_return_if_fail (*box != NULL);
	_tmp0_ = granite_accel_to_string (value_string);
	accels_string = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	accels = _tmp1_;
	accels_length1 = 0;
	_accels_size_ = accels_length1;
	_tmp2_ = accels_string;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		_tmp3_ = accels_string;
		_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, " + ", 0);
		accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
		accels = _tmp5_;
		accels_length1 = _vala_array_length (_tmp4_);
		_accels_size_ = accels_length1;
	}
	while (TRUE) {
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp6_ = gtk_widget_get_first_child ((GtkWidget*) (*box));
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = gtk_widget_get_first_child ((GtkWidget*) (*box));
		gtk_box_remove (*box, _tmp7_);
	}
	_tmp8_ = accels;
	_tmp8__length1 = accels_length1;
	{
		gchar** accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
		accel_collection = _tmp8_;
		accel_collection_length1 = _tmp8__length1;
		for (accel_it = 0; accel_it < accel_collection_length1; accel_it = accel_it + 1) {
			const gchar* accel = NULL;
			accel = accel_collection[accel_it];
			{
				const gchar* _tmp9_;
				GtkLabel* keycap_label = NULL;
				const gchar* _tmp10_;
				GtkLabel* _tmp11_;
				GtkLabel* _tmp12_;
				GtkLabel* _tmp13_;
				_tmp9_ = accel;
				if (g_strcmp0 (_tmp9_, "") == 0) {
					continue;
				}
				_tmp10_ = accel;
				_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
				g_object_ref_sink (_tmp11_);
				keycap_label = _tmp11_;
				_tmp12_ = keycap_label;
				gtk_widget_add_css_class ((GtkWidget*) _tmp12_, "keycap");
				_tmp13_ = keycap_label;
				gtk_box_append (*box, (GtkWidget*) _tmp13_);
				_g_object_unref0 (keycap_label);
			}
		}
	}
	accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (accels_string);
}

KeyboardShortcutsCustomShortcutsParsedShortcut*
keyboard_shortcuts_custom_shortcut_row_get_shortcut (KeyboardShortcutsCustomShortcutRow* self)
{
	KeyboardShortcutsCustomShortcutsParsedShortcut* result;
	KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_shortcut;
	result = _tmp0_;
	return result;
}

static gboolean
_keyboard_shortcuts_custom_shortcuts_parsed_shortcut_equal (const KeyboardShortcutsCustomShortcutsParsedShortcut * s1,
                                                            const KeyboardShortcutsCustomShortcutsParsedShortcut * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (g_strcmp0 (s1->target, s2->target)) {
		return FALSE;
	}
	if (s1->parameters != s2->parameters) {
		return FALSE;
	}
	if (s1->keybindings != s2->keybindings) {
		return FALSE;
	}
	return TRUE;
}

static gpointer
_keyboard_shortcuts_custom_shortcuts_parsed_shortcut_dup0 (gpointer self)
{
	return self ? keyboard_shortcuts_custom_shortcuts_parsed_shortcut_dup (self) : NULL;
}

void
keyboard_shortcuts_custom_shortcut_row_set_shortcut (KeyboardShortcutsCustomShortcutRow* self,
                                                     KeyboardShortcutsCustomShortcutsParsedShortcut* value)
{
	KeyboardShortcutsCustomShortcutsParsedShortcut* old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_shortcuts_custom_shortcut_row_get_shortcut (self);
	if (_keyboard_shortcuts_custom_shortcuts_parsed_shortcut_equal (value, old_value) != TRUE) {
		KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp0_;
		_tmp0_ = _keyboard_shortcuts_custom_shortcuts_parsed_shortcut_dup0 (value);
		_keyboard_shortcuts_custom_shortcuts_parsed_shortcut_free0 (self->priv->_shortcut);
		self->priv->_shortcut = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, keyboard_shortcuts_custom_shortcut_row_properties[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_PROPERTY]);
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		KeyboardShortcutsCustomShortcutRow* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->popover);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
_keyboard_shortcuts_custom_shortcut_row___lambda67_ (Block20Data* _data20_)
{
	KeyboardShortcutsCustomShortcutRow* self;
	GtkPopover* _tmp0_;
	self = _data20_->self;
	_tmp0_ = _data20_->popover;
	gtk_popover_popdown (_tmp0_);
	if (!self->priv->is_editing_shortcut) {
		KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp1_;
		gchar** _tmp2_;
		_tmp1_ = self->priv->_shortcut;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		(*_tmp1_).keybindings = (_vala_array_free ((*_tmp1_).keybindings, (*_tmp1_).keybindings_length1, (GDestroyNotify) g_free), NULL);
		(*_tmp1_).keybindings = _tmp2_;
		(*_tmp1_).keybindings_length1 = 0;
		keyboard_shortcuts_custom_shortcut_row_render_keycaps (self);
		g_signal_emit (self, keyboard_shortcuts_custom_shortcut_row_signals[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_CHANGED_SIGNAL], 0);
	}
}

static void
__keyboard_shortcuts_custom_shortcut_row___lambda67__gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	_keyboard_shortcuts_custom_shortcut_row___lambda67_ (self);
}

static void
_keyboard_shortcuts_custom_shortcut_row___lambda68_ (Block20Data* _data20_)
{
	KeyboardShortcutsCustomShortcutRow* self;
	GtkPopover* _tmp0_;
	self = _data20_->self;
	_tmp0_ = _data20_->popover;
	gtk_popover_popdown (_tmp0_);
	keyboard_shortcuts_custom_shortcut_row_set_shortcut (self, NULL);
	g_signal_emit (self, keyboard_shortcuts_custom_shortcut_row_signals[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_CHANGED_SIGNAL], 0);
	gtk_widget_unparent ((GtkWidget*) self);
}

static void
__keyboard_shortcuts_custom_shortcut_row___lambda68__gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	_keyboard_shortcuts_custom_shortcut_row___lambda68_ (self);
}

static void
_keyboard_shortcuts_custom_shortcut_row___lambda69_ (Block20Data* _data20_)
{
	KeyboardShortcutsCustomShortcutRow* self;
	GtkPopover* _tmp0_;
	self = _data20_->self;
	_tmp0_ = _data20_->popover;
	gtk_popover_popdown (_tmp0_);
	keyboard_shortcuts_custom_shortcut_row_edit_shortcut (self, TRUE);
}

static void
__keyboard_shortcuts_custom_shortcut_row___lambda69__gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	_keyboard_shortcuts_custom_shortcut_row___lambda69_ (self);
}

static void
_keyboard_shortcuts_custom_shortcut_row___lambda70_ (KeyboardShortcutsCustomShortcutRow* self)
{
	keyboard_shortcuts_custom_shortcut_row_edit_shortcut (self, TRUE);
}

static void
__keyboard_shortcuts_custom_shortcut_row___lambda70__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                 gint n_press,
                                                                                 gdouble x,
                                                                                 gdouble y,
                                                                                 gpointer self)
{
	_keyboard_shortcuts_custom_shortcut_row___lambda70_ ((KeyboardShortcutsCustomShortcutRow*) self);
}

static void
_keyboard_shortcuts_custom_shortcut_row___lambda71_ (KeyboardShortcutsCustomShortcutRow* self)
{
	keyboard_shortcuts_custom_shortcut_row_edit_shortcut (self, TRUE);
}

static void
__keyboard_shortcuts_custom_shortcut_row___lambda71__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                 gint n_press,
                                                                                 gdouble x,
                                                                                 gdouble y,
                                                                                 gpointer self)
{
	_keyboard_shortcuts_custom_shortcut_row___lambda71_ ((KeyboardShortcutsCustomShortcutRow*) self);
}

static void
_keyboard_shortcuts_custom_shortcut_row_on_key_released_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                               guint keyval,
                                                                                               guint keycode,
                                                                                               GdkModifierType state,
                                                                                               gpointer self)
{
	keyboard_shortcuts_custom_shortcut_row_on_key_released ((KeyboardShortcutsCustomShortcutRow*) self, _sender, keyval, keycode, state);
}

static void
_keyboard_shortcuts_custom_shortcut_row___lambda72_ (KeyboardShortcutsCustomShortcutRow* self)
{
	keyboard_shortcuts_custom_shortcut_row_edit_shortcut (self, FALSE);
}

static void
__keyboard_shortcuts_custom_shortcut_row___lambda72__gtk_event_controller_focus_leave (GtkEventControllerFocus* _sender,
                                                                                       gpointer self)
{
	_keyboard_shortcuts_custom_shortcut_row___lambda72_ ((KeyboardShortcutsCustomShortcutRow*) self);
}

static GObject *
keyboard_shortcuts_custom_shortcut_row_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardShortcutsCustomShortcutRow * self;
	Block20Data* _data20_;
	gchar* name = NULL;
	gchar* description = NULL;
	GtkWidget* icon_widget = NULL;
	KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp0_;
	GtkLabel* app_name = NULL;
	const gchar* _tmp54_;
	GtkLabel* _tmp55_ = NULL;
	GtkLabel* app_comment = NULL;
	const gchar* _tmp56_;
	GtkLabel* _tmp57_ = NULL;
	GtkLabel* _tmp58_;
	GtkGrid* app_grid = NULL;
	GtkGrid* _tmp59_ = NULL;
	GtkGrid* _tmp60_;
	GtkWidget* _tmp61_;
	GtkGrid* _tmp62_;
	GtkLabel* _tmp63_;
	GtkGrid* _tmp64_;
	GtkLabel* _tmp65_;
	GtkLabel* _tmp66_ = NULL;
	GtkLabel* _tmp67_;
	GtkBox* _tmp68_ = NULL;
	GtkBox* four_key_box = NULL;
	GtkBox* _tmp69_ = NULL;
	GtkStack* _tmp70_ = NULL;
	GtkStack* _tmp71_;
	GtkBox* _tmp72_;
	GtkStack* _tmp73_;
	GtkBox* _tmp74_;
	GtkStack* _tmp75_;
	GtkLabel* _tmp76_;
	GtkButton* set_accel_button = NULL;
	GtkLabel* _tmp77_ = NULL;
	GtkButton* _tmp78_ = NULL;
	GtkButton* _tmp79_;
	GtkLabel* _tmp80_ = NULL;
	GtkButton* _tmp81_ = NULL;
	GtkButton* _tmp82_;
	GtkButton* _tmp83_;
	GtkButton* remove_button = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkButton* _tmp85_ = NULL;
	GtkButton* _tmp86_;
	GtkButton* _tmp87_;
	GtkBox* action_box = NULL;
	GtkBox* _tmp88_;
	GtkBox* _tmp89_;
	GtkButton* _tmp90_;
	GtkBox* _tmp91_;
	GtkButton* _tmp92_;
	GtkBox* _tmp93_;
	GtkButton* _tmp94_;
	GtkBox* _tmp95_;
	GtkWidget* _tmp96_;
	GtkPopover* _tmp97_ = NULL;
	GtkPopover* _tmp98_;
	GtkMenuButton* menubutton = NULL;
	gchar* _tmp99_;
	GtkPopover* _tmp100_;
	GtkPopover* _tmp101_;
	GtkMenuButton* _tmp102_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp103_ = NULL;
	GtkBox* _tmp104_;
	GtkGrid* _tmp105_;
	GtkBox* _tmp106_;
	GtkStack* _tmp107_;
	GtkBox* _tmp108_;
	GtkMenuButton* _tmp109_;
	GtkBox* _tmp110_;
	GtkButton* _tmp111_;
	GtkButton* _tmp112_;
	GtkButton* _tmp113_;
	GtkGestureClick* keycap_controller = NULL;
	GtkGestureClick* _tmp114_;
	GtkStack* _tmp115_;
	GtkGestureClick* _tmp116_;
	GtkEventController* _tmp117_;
	GtkGestureClick* _tmp118_;
	GtkGestureClick* status_controller = NULL;
	GtkGestureClick* _tmp119_;
	GtkLabel* _tmp120_;
	GtkGestureClick* _tmp121_;
	GtkEventController* _tmp122_;
	GtkGestureClick* _tmp123_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp124_;
	GtkEventControllerKey* _tmp125_;
	GtkEventControllerKey* _tmp126_;
	GtkEventController* _tmp127_;
	GtkEventControllerFocus* focus_controller = NULL;
	GtkEventControllerFocus* _tmp128_;
	GtkEventControllerFocus* _tmp129_;
	GtkEventControllerFocus* _tmp130_;
	GtkEventController* _tmp131_;
	parent_class = G_OBJECT_CLASS (keyboard_shortcuts_custom_shortcut_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, KeyboardShortcutsCustomShortcutRow);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = self->priv->_shortcut;
	if ((*_tmp0_).type == KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUTS_ACTION_TYPE_DESKTOP_FILE) {
		GDesktopAppInfo* desktop_file = NULL;
		KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp1_;
		const gchar* _tmp2_;
		GDesktopAppInfo* _tmp3_;
		gchar* action = NULL;
		KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp4_;
		GHashTable* _tmp5_;
		const gchar* _tmp11_;
		GDesktopAppInfo* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		GIcon* _tmp25_ = NULL;
		GDesktopAppInfo* _tmp26_;
		GIcon* _tmp27_;
		GIcon* _tmp28_;
		GtkImage* image = NULL;
		GIcon* _tmp30_;
		GtkImage* _tmp31_ = NULL;
		const gchar* _tmp32_;
		_tmp1_ = self->priv->_shortcut;
		_tmp2_ = (*_tmp1_).target;
		_tmp3_ = g_desktop_app_info_new (_tmp2_);
		desktop_file = _tmp3_;
		action = NULL;
		_tmp4_ = self->priv->_shortcut;
		_tmp5_ = (*_tmp4_).parameters;
		if (g_hash_table_contains (_tmp5_, "action")) {
			KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp6_;
			GHashTable* _tmp7_;
			gconstpointer _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = self->priv->_shortcut;
			_tmp7_ = (*_tmp6_).parameters;
			_tmp8_ = g_hash_table_lookup (_tmp7_, "action");
			_tmp9_ = g_variant_get_string ((GVariant*) _tmp8_, NULL);
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (action);
			action = _tmp10_;
		}
		_tmp11_ = action;
		if (_tmp11_ != NULL) {
			GDesktopAppInfo* _tmp12_;
			const gchar* _tmp13_;
			GDesktopAppInfo* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp12_ = desktop_file;
			_tmp13_ = g_app_info_get_name ((GAppInfo*) _tmp12_);
			_tmp14_ = desktop_file;
			_tmp15_ = action;
			_tmp16_ = g_desktop_app_info_get_action_name (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("%s -> %s", _tmp13_, _tmp17_);
			_g_free0 (name);
			name = _tmp18_;
			_g_free0 (_tmp17_);
		} else {
			GDesktopAppInfo* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = desktop_file;
			_tmp20_ = g_app_info_get_name ((GAppInfo*) _tmp19_);
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (name);
			name = _tmp21_;
		}
		_tmp22_ = desktop_file;
		_tmp23_ = g_app_info_get_description ((GAppInfo*) _tmp22_);
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (description);
		description = _tmp24_;
		_tmp26_ = desktop_file;
		_tmp27_ = g_app_info_get_icon ((GAppInfo*) _tmp26_);
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_tmp25_ = _tmp28_;
		if (_tmp25_ == NULL) {
			GThemedIcon* _tmp29_;
			_tmp29_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
			_g_object_unref0 (_tmp25_);
			_tmp25_ = (GIcon*) _tmp29_;
		}
		_tmp30_ = _tmp25_;
		_tmp25_ = NULL;
		_tmp31_ = (GtkImage*) gtk_image_new ();
		gtk_image_set_pixel_size (_tmp31_, 32);
		g_object_set (_tmp31_, "gicon", _tmp30_, NULL);
		_g_object_unref0 (_tmp30_);
		g_object_ref_sink (_tmp31_);
		image = _tmp31_;
		_tmp32_ = action;
		if (_tmp32_ != NULL) {
			GIcon* action_icon = NULL;
			GDesktopAppInfo* _tmp33_;
			const gchar* _tmp34_;
			GIcon* _tmp35_;
			GtkImage* overlay_image = NULL;
			GIcon* _tmp36_;
			GIcon* _tmp37_;
			GtkImage* _tmp38_ = NULL;
			GtkOverlay* overlay = NULL;
			GtkImage* _tmp39_;
			GtkWidget* _tmp40_;
			GtkOverlay* _tmp41_ = NULL;
			GtkOverlay* _tmp42_;
			GtkImage* _tmp43_;
			GtkOverlay* _tmp44_;
			GtkWidget* _tmp45_;
			_tmp33_ = desktop_file;
			_tmp34_ = action;
			_tmp35_ = keyboard_shortcuts_utils_get_action_icon (_tmp33_, _tmp34_);
			action_icon = _tmp35_;
			_tmp36_ = action_icon;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_tmp38_ = (GtkImage*) gtk_image_new ();
			gtk_image_set_pixel_size (_tmp38_, 16);
			g_object_set (_tmp38_, "gicon", _tmp37_, NULL);
			_g_object_unref0 (_tmp37_);
			gtk_widget_set_halign ((GtkWidget*) _tmp38_, GTK_ALIGN_END);
			gtk_widget_set_valign ((GtkWidget*) _tmp38_, GTK_ALIGN_END);
			g_object_ref_sink (_tmp38_);
			overlay_image = _tmp38_;
			_tmp39_ = image;
			_tmp40_ = _g_object_ref0 ((GtkWidget*) _tmp39_);
			_tmp41_ = (GtkOverlay*) gtk_overlay_new ();
			gtk_overlay_set_child (_tmp41_, _tmp40_);
			_g_object_unref0 (_tmp40_);
			g_object_ref_sink (_tmp41_);
			overlay = _tmp41_;
			_tmp42_ = overlay;
			_tmp43_ = overlay_image;
			gtk_overlay_add_overlay (_tmp42_, (GtkWidget*) _tmp43_);
			_tmp44_ = overlay;
			_tmp45_ = _g_object_ref0 ((GtkWidget*) _tmp44_);
			_g_object_unref0 (icon_widget);
			icon_widget = _tmp45_;
			_g_object_unref0 (overlay);
			_g_object_unref0 (overlay_image);
			_g_object_unref0 (action_icon);
		} else {
			GtkImage* _tmp46_;
			GtkWidget* _tmp47_;
			_tmp46_ = image;
			_tmp47_ = _g_object_ref0 ((GtkWidget*) _tmp46_);
			_g_object_unref0 (icon_widget);
			icon_widget = _tmp47_;
		}
		_g_object_unref0 (image);
		_g_object_unref0 (_tmp25_);
		_g_free0 (action);
		_g_object_unref0 (desktop_file);
	} else {
		gchar* _tmp48_;
		KeyboardShortcutsCustomShortcutsParsedShortcut* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		GThemedIcon* _tmp52_;
		GtkImage* _tmp53_ = NULL;
		_tmp48_ = g_strdup (_ ("Custom Command"));
		_g_free0 (name);
		name = _tmp48_;
		_tmp49_ = self->priv->_shortcut;
		_tmp50_ = (*_tmp49_).target;
		_tmp51_ = g_strdup (_tmp50_);
		_g_free0 (description);
		description = _tmp51_;
		_tmp52_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_tmp53_ = (GtkImage*) gtk_image_new ();
		gtk_image_set_pixel_size (_tmp53_, 32);
		g_object_set (_tmp53_, "gicon", (GIcon*) _tmp52_, NULL);
		_g_object_unref0 (_tmp52_);
		g_object_ref_sink (_tmp53_);
		_g_object_unref0 (icon_widget);
		icon_widget = (GtkWidget*) _tmp53_;
	}
	_tmp54_ = name;
	_tmp55_ = (GtkLabel*) gtk_label_new (_tmp54_);
	gtk_label_set_xalign (_tmp55_, (gfloat) 0);
	g_object_ref_sink (_tmp55_);
	app_name = _tmp55_;
	_tmp56_ = description;
	_tmp57_ = (GtkLabel*) gtk_label_new (_tmp56_);
	gtk_label_set_ellipsize (_tmp57_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp57_, TRUE);
	gtk_label_set_xalign (_tmp57_, (gfloat) 0);
	g_object_ref_sink (_tmp57_);
	app_comment = _tmp57_;
	_tmp58_ = app_comment;
	gtk_widget_add_css_class ((GtkWidget*) _tmp58_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp59_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp59_, 6);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp59_, TRUE);
	g_object_ref_sink (_tmp59_);
	app_grid = _tmp59_;
	_tmp60_ = app_grid;
	_tmp61_ = icon_widget;
	gtk_grid_attach (_tmp60_, _tmp61_, 0, 0, 1, 2);
	_tmp62_ = app_grid;
	_tmp63_ = app_name;
	gtk_grid_attach (_tmp62_, (GtkWidget*) _tmp63_, 1, 0, 1, 1);
	_tmp64_ = app_grid;
	_tmp65_ = app_comment;
	gtk_grid_attach (_tmp64_, (GtkWidget*) _tmp65_, 1, 1, 1, 1);
	_tmp66_ = (GtkLabel*) gtk_label_new (_ ("Disabled"));
	gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->status_label);
	self->priv->status_label = _tmp66_;
	_tmp67_ = self->priv->status_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp67_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp68_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp68_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp68_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->keycap_box);
	self->priv->keycap_box = _tmp68_;
	_tmp69_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp69_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp69_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp69_);
	four_key_box = _tmp69_;
	keyboard_shortcuts_custom_shortcut_row_build_keycap_box (self, "<Shift><Alt><Control>F10", &four_key_box);
	_tmp70_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp70_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	gtk_stack_set_vhomogeneous (_tmp70_, TRUE);
	g_object_ref_sink (_tmp70_);
	_g_object_unref0 (self->priv->keycap_stack);
	self->priv->keycap_stack = _tmp70_;
	_tmp71_ = self->priv->keycap_stack;
	_tmp72_ = four_key_box;
	gtk_stack_add_child (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = self->priv->keycap_stack;
	_tmp74_ = self->priv->keycap_box;
	gtk_stack_add_child (_tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = self->priv->keycap_stack;
	_tmp76_ = self->priv->status_label;
	gtk_stack_add_child (_tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = (GtkLabel*) gtk_label_new (_ ("Set New Shortcut"));
	gtk_widget_set_halign ((GtkWidget*) _tmp77_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp77_);
	_tmp78_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp78_, (GtkWidget*) _tmp77_);
	_g_object_unref0 (_tmp77_);
	g_object_ref_sink (_tmp78_);
	set_accel_button = _tmp78_;
	_tmp79_ = set_accel_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp79_, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp80_ = (GtkLabel*) gtk_label_new (_ ("Disable"));
	gtk_widget_set_halign ((GtkWidget*) _tmp80_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp80_);
	_tmp81_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp81_, (GtkWidget*) _tmp80_);
	_g_object_unref0 (_tmp80_);
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->clear_button);
	self->priv->clear_button = _tmp81_;
	_tmp82_ = self->priv->clear_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp82_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp83_ = self->priv->clear_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp83_, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp84_ = (GtkLabel*) gtk_label_new (_ ("Remove"));
	gtk_widget_set_halign ((GtkWidget*) _tmp84_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp84_);
	_tmp85_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp85_, (GtkWidget*) _tmp84_);
	_g_object_unref0 (_tmp84_);
	g_object_ref_sink (_tmp85_);
	remove_button = _tmp85_;
	_tmp86_ = remove_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp86_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp87_ = remove_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp87_, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp88_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp88_);
	action_box = _tmp88_;
	_tmp89_ = action_box;
	_tmp90_ = set_accel_button;
	gtk_box_append (_tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = action_box;
	_tmp92_ = self->priv->clear_button;
	gtk_box_append (_tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = action_box;
	_tmp94_ = remove_button;
	gtk_box_append (_tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = action_box;
	_tmp96_ = _g_object_ref0 ((GtkWidget*) _tmp95_);
	_tmp97_ = (GtkPopover*) gtk_popover_new ();
	gtk_popover_set_child (_tmp97_, _tmp96_);
	_g_object_unref0 (_tmp96_);
	g_object_ref_sink (_tmp97_);
	_data20_->popover = _tmp97_;
	_tmp98_ = _data20_->popover;
	gtk_widget_add_css_class ((GtkWidget*) _tmp98_, GRANITE_STYLE_CLASS_MENU);
	_tmp99_ = g_strdup ("open-menu-symbolic");
	_tmp100_ = _data20_->popover;
	_tmp101_ = _g_object_ref0 (_tmp100_);
	_tmp102_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_has_frame (_tmp102_, FALSE);
	gtk_widget_set_valign ((GtkWidget*) _tmp102_, GTK_ALIGN_CENTER);
	gtk_menu_button_set_icon_name (_tmp102_, _tmp99_);
	_g_free0 (_tmp99_);
	gtk_menu_button_set_popover (_tmp102_, _tmp101_);
	_g_object_unref0 (_tmp101_);
	g_object_ref_sink (_tmp102_);
	menubutton = _tmp102_;
	_tmp103_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp103_, 3);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp103_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp103_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp103_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp103_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp103_);
	box = _tmp103_;
	_tmp104_ = box;
	_tmp105_ = app_grid;
	gtk_box_append (_tmp104_, (GtkWidget*) _tmp105_);
	_tmp106_ = box;
	_tmp107_ = self->priv->keycap_stack;
	gtk_box_append (_tmp106_, (GtkWidget*) _tmp107_);
	_tmp108_ = box;
	_tmp109_ = menubutton;
	gtk_box_append (_tmp108_, (GtkWidget*) _tmp109_);
	_tmp110_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp110_);
	keyboard_shortcuts_custom_shortcut_row_render_keycaps (self);
	_tmp111_ = self->priv->clear_button;
	g_signal_connect_data (_tmp111_, "clicked", (GCallback) __keyboard_shortcuts_custom_shortcut_row___lambda67__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp112_ = remove_button;
	g_signal_connect_data (_tmp112_, "clicked", (GCallback) __keyboard_shortcuts_custom_shortcut_row___lambda68__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp113_ = set_accel_button;
	g_signal_connect_data (_tmp113_, "clicked", (GCallback) __keyboard_shortcuts_custom_shortcut_row___lambda69__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp114_ = (GtkGestureClick*) gtk_gesture_click_new ();
	keycap_controller = _tmp114_;
	_tmp115_ = self->priv->keycap_stack;
	_tmp116_ = keycap_controller;
	_tmp117_ = _g_object_ref0 ((GtkEventController*) _tmp116_);
	gtk_widget_add_controller ((GtkWidget*) _tmp115_, _tmp117_);
	_tmp118_ = keycap_controller;
	g_signal_connect_object (_tmp118_, "released", (GCallback) __keyboard_shortcuts_custom_shortcut_row___lambda70__gtk_gesture_click_released, self, 0);
	_tmp119_ = (GtkGestureClick*) gtk_gesture_click_new ();
	status_controller = _tmp119_;
	_tmp120_ = self->priv->status_label;
	_tmp121_ = status_controller;
	_tmp122_ = _g_object_ref0 ((GtkEventController*) _tmp121_);
	gtk_widget_add_controller ((GtkWidget*) _tmp120_, _tmp122_);
	_tmp123_ = status_controller;
	g_signal_connect_object (_tmp123_, "released", (GCallback) __keyboard_shortcuts_custom_shortcut_row___lambda71__gtk_gesture_click_released, self, 0);
	_tmp124_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp124_;
	_tmp125_ = key_controller;
	g_signal_connect_object (_tmp125_, "key-released", (GCallback) _keyboard_shortcuts_custom_shortcut_row_on_key_released_gtk_event_controller_key_key_released, self, 0);
	_tmp126_ = key_controller;
	_tmp127_ = _g_object_ref0 ((GtkEventController*) _tmp126_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp127_);
	_tmp128_ = (GtkEventControllerFocus*) gtk_event_controller_focus_new ();
	focus_controller = _tmp128_;
	_tmp129_ = focus_controller;
	g_signal_connect_object (_tmp129_, "leave", (GCallback) __keyboard_shortcuts_custom_shortcut_row___lambda72__gtk_event_controller_focus_leave, self, 0);
	_tmp130_ = focus_controller;
	_tmp131_ = _g_object_ref0 ((GtkEventController*) _tmp130_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp131_);
	_g_object_unref0 (focus_controller);
	_g_object_unref0 (key_controller);
	_g_object_unref0 (status_controller);
	_g_object_unref0 (keycap_controller);
	_g_object_unref0 (box);
	_g_object_unref0 (menubutton);
	_g_object_unref0 (action_box);
	_g_object_unref0 (remove_button);
	_g_object_unref0 (set_accel_button);
	_g_object_unref0 (four_key_box);
	_g_object_unref0 (app_grid);
	_g_object_unref0 (app_comment);
	_g_object_unref0 (app_name);
	_g_object_unref0 (icon_widget);
	_g_free0 (description);
	_g_free0 (name);
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return obj;
}

static void
keyboard_shortcuts_custom_shortcut_row_class_init (KeyboardShortcutsCustomShortcutRowClass * klass,
                                                   gpointer klass_data)
{
	keyboard_shortcuts_custom_shortcut_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardShortcutsCustomShortcutRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_shortcuts_custom_shortcut_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_shortcuts_custom_shortcut_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = keyboard_shortcuts_custom_shortcut_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_shortcuts_custom_shortcut_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_PROPERTY, keyboard_shortcuts_custom_shortcut_row_properties[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_PROPERTY] = g_param_spec_boxed ("shortcut", "shortcut", "shortcut", KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUTS_TYPE_PARSED_SHORTCUT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	keyboard_shortcuts_custom_shortcut_row_signals[KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_CHANGED_SIGNAL] = g_signal_new ("shortcut-changed", KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
keyboard_shortcuts_custom_shortcut_row_instance_init (KeyboardShortcutsCustomShortcutRow * self,
                                                      gpointer klass)
{
	self->priv = keyboard_shortcuts_custom_shortcut_row_get_instance_private (self);
	self->priv->is_editing_shortcut = FALSE;
}

static void
keyboard_shortcuts_custom_shortcut_row_finalize (GObject * obj)
{
	KeyboardShortcutsCustomShortcutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, KeyboardShortcutsCustomShortcutRow);
	_keyboard_shortcuts_custom_shortcuts_parsed_shortcut_free0 (self->priv->_shortcut);
	_g_object_unref0 (self->priv->clear_button);
	_g_object_unref0 (self->priv->keycap_box);
	_g_object_unref0 (self->priv->status_label);
	_g_object_unref0 (self->priv->keycap_stack);
	G_OBJECT_CLASS (keyboard_shortcuts_custom_shortcut_row_parent_class)->finalize (obj);
}

static GType
keyboard_shortcuts_custom_shortcut_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardShortcutsCustomShortcutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_shortcuts_custom_shortcut_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardShortcutsCustomShortcutRow), 0, (GInstanceInitFunc) keyboard_shortcuts_custom_shortcut_row_instance_init, NULL };
	GType keyboard_shortcuts_custom_shortcut_row_type_id;
	keyboard_shortcuts_custom_shortcut_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "KeyboardShortcutsCustomShortcutRow", &g_define_type_info, 0);
	KeyboardShortcutsCustomShortcutRow_private_offset = g_type_add_instance_private (keyboard_shortcuts_custom_shortcut_row_type_id, sizeof (KeyboardShortcutsCustomShortcutRowPrivate));
	return keyboard_shortcuts_custom_shortcut_row_type_id;
}

GType
keyboard_shortcuts_custom_shortcut_row_get_type (void)
{
	static volatile gsize keyboard_shortcuts_custom_shortcut_row_type_id__once = 0;
	if (g_once_init_enter (&keyboard_shortcuts_custom_shortcut_row_type_id__once)) {
		GType keyboard_shortcuts_custom_shortcut_row_type_id;
		keyboard_shortcuts_custom_shortcut_row_type_id = keyboard_shortcuts_custom_shortcut_row_get_type_once ();
		g_once_init_leave (&keyboard_shortcuts_custom_shortcut_row_type_id__once, keyboard_shortcuts_custom_shortcut_row_type_id);
	}
	return keyboard_shortcuts_custom_shortcut_row_type_id__once;
}

static void
_vala_keyboard_shortcuts_custom_shortcut_row_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	KeyboardShortcutsCustomShortcutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, KeyboardShortcutsCustomShortcutRow);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_PROPERTY:
		{
			KeyboardShortcutsCustomShortcutsParsedShortcut* boxed;
			boxed = keyboard_shortcuts_custom_shortcut_row_get_shortcut (self);
			g_value_set_boxed (value, boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_shortcuts_custom_shortcut_row_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	KeyboardShortcutsCustomShortcutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_TYPE_CUSTOM_SHORTCUT_ROW, KeyboardShortcutsCustomShortcutRow);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_CUSTOM_SHORTCUT_ROW_SHORTCUT_PROPERTY:
		keyboard_shortcuts_custom_shortcut_row_set_shortcut (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

