/* DisplaysOverlay.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DisplaysOverlay.vala, do not modify */

/*-
 * Copyright (c) 2014-2019 elementary, Inc. (https://elementary.io)
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 *              Felix Andreas <fandreas@physik.hu-berlin.de>
 */

#include "display.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <granite-7.h>
#include <gio/gio.h>

#define DISPLAY_DISPLAYS_OVERLAY_SNAP_LIMIT (G_MAXINT - 1)
#define DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET 50
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_DISPLAYS_OVERLAY_0_PROPERTY,
	DISPLAY_DISPLAYS_OVERLAY_ACTIVE_DISPLAYS_PROPERTY,
	DISPLAY_DISPLAYS_OVERLAY_ONLY_DISPLAY_PROPERTY,
	DISPLAY_DISPLAYS_OVERLAY_NUM_PROPERTIES
};
static GParamSpec* display_displays_overlay_properties[DISPLAY_DISPLAYS_OVERLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block8Data Block8Data;
enum  {
	DISPLAY_DISPLAYS_OVERLAY_CONFIGURATION_CHANGED_SIGNAL,
	DISPLAY_DISPLAYS_OVERLAY_NUM_SIGNALS
};
static guint display_displays_overlay_signals[DISPLAY_DISPLAYS_OVERLAY_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DisplayDisplaysOverlayPrivate {
	GtkOverlay* overlay;
	gboolean scanning;
	gdouble current_ratio;
	gint current_width;
	gint current_height;
	gint default_x_margin;
	gint default_y_margin;
	DisplayMonitorManager* monitor_manager;
	gint _active_displays;
	GList* display_widgets;
	DisplayDisplayWidget* dragging_display;
	GtkGestureDrag* drag_gesture;
	gdouble prev_dx;
	gdouble prev_dy;
};

struct _Block8Data {
	int _ref_count_;
	DisplayDisplaysOverlay* self;
	DisplayDisplayWidget* display_widget;
	DisplayVirtualMonitor* virtual_monitor;
};

static gint DisplayDisplaysOverlay_private_offset;
static gpointer display_displays_overlay_parent_class = NULL;
static GalaDBus* display_displays_overlay_gala_dbus;
static GalaDBus* display_displays_overlay_gala_dbus = NULL;
static gchar** display_displays_overlay_colors;
static gint display_displays_overlay_colors_length1;
static gchar** display_displays_overlay_colors = NULL;
static gint display_displays_overlay_colors_length1 = 0;
static gint _display_displays_overlay_colors_size_ = 0;
static gchar** display_displays_overlay_text_colors;
static gint display_displays_overlay_text_colors_length1;
static gchar** display_displays_overlay_text_colors = NULL;
static gint display_displays_overlay_text_colors_length1 = 0;
static gint _display_displays_overlay_text_colors_size_ = 0;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void display_displays_overlay_on_drag_begin (DisplayDisplaysOverlay* self,
                                             gdouble x,
                                             gdouble y);
static gboolean display_displays_overlay_get_child_position (DisplayDisplaysOverlay* self,
                                                      GtkWidget* widget,
                                                      GdkRectangle* allocation);
static void display_displays_overlay_on_drag_update (DisplayDisplaysOverlay* self,
                                              gdouble dx,
                                              gdouble dy);
static void display_displays_overlay_on_drag_end (DisplayDisplaysOverlay* self);
static void display_displays_overlay_verify_layout (DisplayDisplaysOverlay* self,
                                             DisplayDisplayWidget* changed_widget);
static void display_displays_overlay_calculate_ratio (DisplayDisplaysOverlay* self);
static void __lambda15_ (DisplayDisplaysOverlay* self,
                  DisplayDisplayWidget* display_widget);
static void ___lambda15__gfunc (gconstpointer data,
                         gpointer self);
static void display_displays_overlay_add_output (DisplayDisplaysOverlay* self,
                                          DisplayVirtualMonitor* virtual_monitor);
static void display_displays_overlay_change_active_displays_sensitivity (DisplayDisplaysOverlay* self);
static void _vala_array_add8 (MonitorLabelInfo* * array,
                       gint* length,
                       gint* size,
                       const MonitorLabelInfo* value);
static void _vala_MonitorLabelInfo_array_free (MonitorLabelInfo * array,
                                        gssize array_length);
static void display_displays_overlay_check_configuration_change (DisplayDisplaysOverlay* self);
static gboolean display_displays_overlay_is_connected (DisplayDisplaysOverlay* self,
                                                DisplayDisplayWidget* dw1,
                                                DisplayDisplayWidget* dw2);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda16_ (Block8Data* _data8_);
static void display_displays_overlay_set_as_primary (DisplayDisplaysOverlay* self,
                                              DisplayVirtualMonitor* new_primary);
static void ___lambda16__display_display_widget_set_as_primary (DisplayDisplayWidget* _sender,
                                                         gpointer self);
static void __lambda17_ (Block8Data* _data8_);
static void ___lambda17__display_display_widget_check_position (DisplayDisplayWidget* _sender,
                                                         gpointer self);
static void _display_displays_overlay_check_configuration_change_display_display_widget_configuration_changed (DisplayDisplayWidget* _sender,
                                                                                                        gpointer self);
static void __lambda18_ (Block8Data* _data8_);
static void ___lambda18__display_display_widget_active_changed (DisplayDisplayWidget* _sender,
                                                         gpointer self);
static gboolean display_displays_overlay_check_intersects (DisplayDisplaysOverlay* self,
                                                    DisplayDisplayWidget* changed_widget,
                                                    gboolean moved,
                                                    guint level);
static gboolean display_displays_overlay_align_edges (DisplayDisplaysOverlay* self,
                                               DisplayDisplayWidget* changed_widget,
                                               gboolean moved,
                                               guint level);
static void display_displays_overlay_set_origin_zero (DisplayDisplaysOverlay* self);
static GObject * display_displays_overlay_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _display_displays_overlay_on_drag_begin_gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                                                          gdouble start_x,
                                                                          gdouble start_y,
                                                                          gpointer self);
static void _display_displays_overlay_on_drag_update_gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                                            gdouble offset_x,
                                                                            gdouble offset_y,
                                                                            gpointer self);
static void _display_displays_overlay_on_drag_end_gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                                                      gdouble offset_x,
                                                                      gdouble offset_y,
                                                                      gpointer self);
static void _display_displays_overlay___lambda19_ (DisplayDisplaysOverlay* self);
static void __display_displays_overlay___lambda19__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static gboolean _display_displays_overlay_get_child_position_gtk_overlay_get_child_position (GtkOverlay* _sender,
                                                                                      GtkWidget* widget,
                                                                                      GdkRectangle* allocation,
                                                                                      gpointer self);
static void _display_displays_overlay___lambda20_ (GObject* obj,
                                            GAsyncResult* res);
static void __display_displays_overlay___lambda20__gasync_ready_callback (GObject* source_object,
                                                                   GAsyncResult* res,
                                                                   gpointer self);
static void display_displays_overlay_finalize (GObject * obj);
static GType display_displays_overlay_get_type_once (void);
static void _vala_display_displays_overlay_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_display_displays_overlay_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
display_displays_overlay_get_instance_private (DisplayDisplaysOverlay* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayDisplaysOverlay_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
display_displays_overlay_on_drag_begin (DisplayDisplaysOverlay* self,
                                        gdouble x,
                                        gdouble y)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GdkRectangle start_rect = {0};
	GdkRectangle _tmp2_ = {0};
	GtkAllocation alloc = {0};
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = display_displays_overlay_get_only_display (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_.x = (gint) x;
	_tmp2_.y = (gint) y;
	_tmp2_.width = 1;
	_tmp2_.height = 1;
	start_rect = _tmp2_;
	self->priv->prev_dx = (gdouble) 0;
	self->priv->prev_dy = (gdouble) 0;
	_tmp3_ = self->priv->display_widgets;
	{
		GList* display_widget_collection = NULL;
		GList* display_widget_it = NULL;
		display_widget_collection = _tmp3_;
		for (display_widget_it = display_widget_collection; display_widget_it != NULL; display_widget_it = display_widget_it->next) {
			DisplayDisplayWidget* _tmp4_;
			DisplayDisplayWidget* display_widget = NULL;
			_tmp4_ = _g_object_ref0 ((DisplayDisplayWidget*) display_widget_it->data);
			display_widget = _tmp4_;
			{
				DisplayDisplayWidget* _tmp5_;
				GdkRectangle _tmp6_ = {0};
				GtkAllocation _tmp7_;
				_tmp5_ = display_widget;
				display_displays_overlay_get_child_position (self, (GtkWidget*) _tmp5_, &_tmp6_);
				alloc = _tmp6_;
				_tmp7_ = alloc;
				if (gdk_rectangle_intersect (&start_rect, &_tmp7_, NULL)) {
					DisplayDisplayWidget* _tmp8_;
					DisplayDisplayWidget* _tmp9_;
					_tmp8_ = display_widget;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (self->priv->dragging_display);
					self->priv->dragging_display = _tmp9_;
					_g_object_unref0 (display_widget);
					break;
				}
				_g_object_unref0 (display_widget);
			}
		}
	}
}

static void
display_displays_overlay_on_drag_update (DisplayDisplaysOverlay* self,
                                         gdouble dx,
                                         gdouble dy)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = display_displays_overlay_get_only_display (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		DisplayDisplayWidget* _tmp3_;
		_tmp3_ = self->priv->dragging_display;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		DisplayDisplayWidget* _tmp4_;
		DisplayDisplayWidget* _tmp5_;
		_tmp4_ = self->priv->dragging_display;
		display_display_widget_move_x (_tmp4_, (gint) ((dx - self->priv->prev_dx) / self->priv->current_ratio));
		_tmp5_ = self->priv->dragging_display;
		display_display_widget_move_y (_tmp5_, (gint) ((dy - self->priv->prev_dy) / self->priv->current_ratio));
		self->priv->prev_dx = dx;
		self->priv->prev_dy = dy;
	}
}

static void
display_displays_overlay_on_drag_end (DisplayDisplaysOverlay* self)
{
	DisplayDisplayWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dragging_display;
	if (_tmp0_ != NULL) {
		DisplayDisplayWidget* _tmp1_;
		_tmp1_ = self->priv->dragging_display;
		display_displays_overlay_verify_layout (self, _tmp1_);
		_g_object_unref0 (self->priv->dragging_display);
		self->priv->dragging_display = NULL;
	}
}

static gboolean
display_displays_overlay_get_child_position (DisplayDisplaysOverlay* self,
                                             GtkWidget* widget,
                                             GdkRectangle* allocation)
{
	GdkRectangle _vala_allocation = {0};
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	memset (&_vala_allocation, 0, sizeof (GdkRectangle));
	if (self->priv->current_width != gtk_widget_get_width ((GtkWidget*) self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current_height != gtk_widget_get_height ((GtkWidget*) self);
	}
	if (_tmp0_) {
		display_displays_overlay_calculate_ratio (self);
	}
	if (DISPLAY_IS_DISPLAY_WIDGET (widget)) {
		DisplayDisplayWidget* display_widget = NULL;
		DisplayDisplayWidget* _tmp1_;
		gint x = 0;
		gint y = 0;
		gint width = 0;
		gint height = 0;
		DisplayDisplayWidget* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint x_start = 0;
		gint y_start = 0;
		gint x_end = 0;
		gint y_end = 0;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, DISPLAY_TYPE_DISPLAY_WIDGET, DisplayDisplayWidget));
		display_widget = _tmp1_;
		_tmp2_ = display_widget;
		display_display_widget_get_virtual_monitor_geometry (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
		x = _tmp3_;
		y = _tmp4_;
		width = _tmp5_;
		height = _tmp6_;
		x_start = (gint) round (x * self->priv->current_ratio);
		y_start = (gint) round (y * self->priv->current_ratio);
		x_end = (gint) round ((x + width) * self->priv->current_ratio);
		y_end = (gint) round ((y + height) * self->priv->current_ratio);
		_vala_allocation.x = self->priv->default_x_margin + x_start;
		_vala_allocation.y = self->priv->default_y_margin + y_start;
		_vala_allocation.width = x_end - x_start;
		_vala_allocation.height = y_end - y_start;
		result = TRUE;
		_g_object_unref0 (display_widget);
		if (allocation) {
			*allocation = _vala_allocation;
		}
		return result;
	}
	result = FALSE;
	if (allocation) {
		*allocation = _vala_allocation;
	}
	return result;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
__lambda15_ (DisplayDisplaysOverlay* self,
             DisplayDisplayWidget* display_widget)
{
	GtkOverlay* _tmp0_;
	g_return_if_fail (display_widget != NULL);
	_tmp0_ = self->priv->overlay;
	gtk_overlay_remove_overlay (_tmp0_, (GtkWidget*) display_widget);
	g_signal_emit_by_name ((GtkWidget*) display_widget, "destroy");
	self->priv->display_widgets = vala_g_list_remove_full (self->priv->display_widgets, display_widget, _g_object_unref0_);
}

static void
___lambda15__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda15_ ((DisplayDisplaysOverlay*) self, (DisplayDisplayWidget*) data);
}

void
display_displays_overlay_rescan_displays (DisplayDisplaysOverlay* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->scanning = TRUE;
	_tmp0_ = self->priv->display_widgets;
	g_list_foreach (_tmp0_, ___lambda15__gfunc, self);
	display_displays_overlay_set_active_displays (self, 0);
	{
		GeeLinkedList* _virtual_monitor_list = NULL;
		DisplayMonitorManager* _tmp1_;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _virtual_monitor_size = 0;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _virtual_monitor_index = 0;
		_tmp1_ = self->priv->monitor_manager;
		_tmp2_ = display_monitor_manager_get_virtual_monitors (_tmp1_);
		_tmp3_ = _tmp2_;
		_virtual_monitor_list = _tmp3_;
		_tmp4_ = _virtual_monitor_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_virtual_monitor_size = _tmp6_;
		_virtual_monitor_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			DisplayVirtualMonitor* virtual_monitor = NULL;
			GeeLinkedList* _tmp9_;
			gpointer _tmp10_;
			gint _tmp11_ = 0;
			DisplayVirtualMonitor* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			gint _tmp15_;
			DisplayVirtualMonitor* _tmp16_;
			_virtual_monitor_index = _virtual_monitor_index + 1;
			_tmp7_ = _virtual_monitor_index;
			_tmp8_ = _virtual_monitor_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _virtual_monitor_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _virtual_monitor_index);
			virtual_monitor = (DisplayVirtualMonitor*) _tmp10_;
			_tmp12_ = virtual_monitor;
			_tmp13_ = display_virtual_monitor_get_is_active (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				_tmp11_ = 1;
			} else {
				_tmp11_ = 0;
			}
			_tmp15_ = self->priv->_active_displays;
			display_displays_overlay_set_active_displays (self, _tmp15_ + _tmp11_);
			_tmp16_ = virtual_monitor;
			display_displays_overlay_add_output (self, _tmp16_);
			_g_object_unref0 (virtual_monitor);
		}
	}
	display_displays_overlay_change_active_displays_sensitivity (self);
	display_displays_overlay_calculate_ratio (self);
	self->priv->scanning = FALSE;
}

static void
_vala_array_add8 (MonitorLabelInfo* * array,
                  gint* length,
                  gint* size,
                  const MonitorLabelInfo* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (MonitorLabelInfo, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_MonitorLabelInfo_array_free (MonitorLabelInfo * array,
                                   gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			monitor_label_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

void
display_displays_overlay_show_windows (DisplayDisplaysOverlay* self)
{
	GalaDBus* _tmp0_;
	DisplayMonitorManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	MonitorLabelInfo* label_infos = NULL;
	MonitorLabelInfo* _tmp4_;
	gint label_infos_length1;
	gint _label_infos_size_;
	GList* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = display_displays_overlay_gala_dbus;
	_vala_return_if_fail (_tmp0_ != NULL, "gala_dbus != null");
	_tmp1_ = self->priv->monitor_manager;
	_tmp2_ = display_monitor_manager_get_is_mirrored (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = g_new0 (MonitorLabelInfo, 0);
	label_infos = _tmp4_;
	label_infos_length1 = 0;
	_label_infos_size_ = label_infos_length1;
	_tmp5_ = self->priv->display_widgets;
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp5_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			DisplayDisplayWidget* widget = NULL;
			widget = (DisplayDisplayWidget*) widget_it->data;
			{
				DisplayDisplayWidget* _tmp6_;
				DisplayVirtualMonitor* _tmp7_;
				DisplayVirtualMonitor* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp6_ = widget;
				_tmp7_ = display_display_widget_get_virtual_monitor (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = display_virtual_monitor_get_is_active (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					MonitorLabelInfo* _tmp11_;
					gint _tmp11__length1;
					DisplayDisplayWidget* _tmp12_;
					DisplayVirtualMonitor* _tmp13_;
					DisplayVirtualMonitor* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					DisplayDisplayWidget* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					DisplayDisplayWidget* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					DisplayDisplayWidget* _tmp25_;
					DisplayVirtualMonitor* _tmp26_;
					DisplayVirtualMonitor* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					DisplayDisplayWidget* _tmp30_;
					DisplayVirtualMonitor* _tmp31_;
					DisplayVirtualMonitor* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					MonitorLabelInfo _tmp35_ = {0};
					_tmp11_ = label_infos;
					_tmp11__length1 = label_infos_length1;
					_tmp12_ = widget;
					_tmp13_ = display_display_widget_get_virtual_monitor (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = display_virtual_monitor_get_display_name (_tmp14_);
					_tmp16_ = g_strdup (_tmp15_);
					_tmp17_ = widget;
					_tmp18_ = display_display_widget_get_bg_color (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = g_strdup (_tmp19_);
					_tmp21_ = widget;
					_tmp22_ = display_display_widget_get_text_color (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strdup (_tmp23_);
					_tmp25_ = widget;
					_tmp26_ = display_display_widget_get_virtual_monitor (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = display_virtual_monitor_get_current_x (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = widget;
					_tmp31_ = display_display_widget_get_virtual_monitor (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = display_virtual_monitor_get_current_y (_tmp32_);
					_tmp34_ = _tmp33_;
					memset (&_tmp35_, 0, sizeof (MonitorLabelInfo));
					_tmp35_.monitor = _tmp11__length1;
					_g_free0 (_tmp35_.label);
					_tmp35_.label = _tmp16_;
					_g_free0 (_tmp35_.background_color);
					_tmp35_.background_color = _tmp20_;
					_g_free0 (_tmp35_.text_color);
					_tmp35_.text_color = _tmp24_;
					_tmp35_.x = _tmp29_;
					_tmp35_.y = _tmp34_;
					_vala_array_add8 (&label_infos, &label_infos_length1, &_label_infos_size_, &_tmp35_);
				}
			}
		}
	}
	{
		GalaDBus* _tmp36_;
		MonitorLabelInfo* _tmp37_;
		gint _tmp37__length1;
		_tmp36_ = display_displays_overlay_gala_dbus;
		_tmp37_ = label_infos;
		_tmp37__length1 = label_infos_length1;
		gala_dbus_show_monitor_labels (_tmp36_, _tmp37_, (gint) _tmp37__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("DisplaysOverlay.vala:230: Couldn't show monitor labels: %s", _tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		label_infos = (_vala_MonitorLabelInfo_array_free (label_infos, label_infos_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	label_infos = (_vala_MonitorLabelInfo_array_free (label_infos, label_infos_length1), NULL);
}

void
display_displays_overlay_hide_windows (DisplayDisplaysOverlay* self)
{
	GalaDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = display_displays_overlay_gala_dbus;
	_vala_return_if_fail (_tmp0_ != NULL, "gala_dbus != null");
	{
		GalaDBus* _tmp1_;
		_tmp1_ = display_displays_overlay_gala_dbus;
		gala_dbus_hide_monitor_labels (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("DisplaysOverlay.vala:238: Couldn't hide monitor labels: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
display_displays_overlay_change_active_displays_sensitivity (DisplayDisplaysOverlay* self)
{
	g_return_if_fail (self != NULL);
}

static void
display_displays_overlay_check_configuration_change (DisplayDisplaysOverlay* self)
{
	gint active_display_count = 0;
	GList* _tmp0_;
	gboolean _result_ = FALSE;
	GList* _tmp7_;
	GList* _tmp9_;
	GList* _tmp23_;
	g_return_if_fail (self != NULL);
	active_display_count = 0;
	_tmp0_ = self->priv->display_widgets;
	{
		GList* dw_collection = NULL;
		GList* dw_it = NULL;
		dw_collection = _tmp0_;
		for (dw_it = dw_collection; dw_it != NULL; dw_it = dw_it->next) {
			DisplayDisplayWidget* dw = NULL;
			dw = (DisplayDisplayWidget*) dw_it->data;
			{
				DisplayDisplayWidget* _tmp1_;
				DisplayVirtualMonitor* _tmp2_;
				DisplayVirtualMonitor* _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp5_;
				_tmp1_ = dw;
				_tmp2_ = display_display_widget_get_virtual_monitor (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = display_virtual_monitor_get_is_active (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_) {
					gint _tmp6_;
					_tmp6_ = active_display_count;
					active_display_count = _tmp6_ + 1;
				}
			}
		}
	}
	if (active_display_count == 1) {
		g_signal_emit (self, display_displays_overlay_signals[DISPLAY_DISPLAYS_OVERLAY_CONFIGURATION_CHANGED_SIGNAL], 0, TRUE);
		return;
	}
	_result_ = TRUE;
	_tmp7_ = self->priv->display_widgets;
	{
		GList* dw_collection = NULL;
		GList* dw_it = NULL;
		dw_collection = _tmp7_;
		for (dw_it = dw_collection; dw_it != NULL; dw_it = dw_it->next) {
			DisplayDisplayWidget* dw = NULL;
			dw = (DisplayDisplayWidget*) dw_it->data;
			{
				DisplayDisplayWidget* _tmp8_;
				_tmp8_ = dw;
				display_display_widget_set_connected (_tmp8_, FALSE);
			}
		}
	}
	_tmp9_ = self->priv->display_widgets;
	{
		GList* dw1_collection = NULL;
		GList* dw1_it = NULL;
		dw1_collection = _tmp9_;
		for (dw1_it = dw1_collection; dw1_it != NULL; dw1_it = dw1_it->next) {
			DisplayDisplayWidget* dw1 = NULL;
			dw1 = (DisplayDisplayWidget*) dw1_it->data;
			{
				GList* _tmp10_;
				_tmp10_ = self->priv->display_widgets;
				{
					GList* dw2_collection = NULL;
					GList* dw2_it = NULL;
					dw2_collection = _tmp10_;
					for (dw2_it = dw2_collection; dw2_it != NULL; dw2_it = dw2_it->next) {
						DisplayDisplayWidget* dw2 = NULL;
						dw2 = (DisplayDisplayWidget*) dw2_it->data;
						{
							DisplayDisplayWidget* _tmp11_;
							DisplayDisplayWidget* _tmp12_;
							DisplayDisplayWidget* _tmp16_;
							DisplayDisplayWidget* _tmp17_;
							DisplayDisplayWidget* _tmp18_;
							DisplayDisplayWidget* _tmp19_;
							gboolean _tmp20_;
							gboolean _tmp21_;
							_tmp11_ = dw2;
							_tmp12_ = dw1;
							if (_tmp11_ == _tmp12_) {
								continue;
							} else {
								DisplayDisplayWidget* _tmp13_;
								gboolean _tmp14_;
								gboolean _tmp15_;
								_tmp13_ = dw1;
								_tmp14_ = display_display_widget_get_connected (_tmp13_);
								_tmp15_ = _tmp14_;
								if (_tmp15_) {
									break;
								}
							}
							_tmp16_ = dw1;
							_tmp17_ = dw1;
							_tmp18_ = dw2;
							display_display_widget_set_connected (_tmp16_, display_displays_overlay_is_connected (self, _tmp17_, _tmp18_));
							_tmp19_ = dw1;
							_tmp20_ = display_display_widget_get_connected (_tmp19_);
							_tmp21_ = _tmp20_;
							if (_tmp21_) {
								DisplayDisplayWidget* _tmp22_;
								_tmp22_ = dw2;
								display_display_widget_set_connected (_tmp22_, TRUE);
							}
						}
					}
				}
			}
		}
	}
	_tmp23_ = self->priv->display_widgets;
	{
		GList* dw_collection = NULL;
		GList* dw_it = NULL;
		dw_collection = _tmp23_;
		for (dw_it = dw_collection; dw_it != NULL; dw_it = dw_it->next) {
			DisplayDisplayWidget* dw = NULL;
			dw = (DisplayDisplayWidget*) dw_it->data;
			{
				gboolean _tmp24_ = FALSE;
				DisplayDisplayWidget* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_tmp25_ = dw;
				_tmp26_ = display_display_widget_get_connected (_tmp25_);
				_tmp27_ = _tmp26_;
				if (!_tmp27_) {
					DisplayDisplayWidget* _tmp28_;
					DisplayVirtualMonitor* _tmp29_;
					DisplayVirtualMonitor* _tmp30_;
					gboolean _tmp31_;
					gboolean _tmp32_;
					_tmp28_ = dw;
					_tmp29_ = display_display_widget_get_virtual_monitor (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = display_virtual_monitor_get_is_active (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp24_ = _tmp32_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					_result_ = FALSE;
					break;
				}
			}
		}
	}
	g_signal_emit (self, display_displays_overlay_signals[DISPLAY_DISPLAYS_OVERLAY_CONFIGURATION_CHANGED_SIGNAL], 0, _result_);
}

static gboolean
display_displays_overlay_is_connected (DisplayDisplaysOverlay* self,
                                       DisplayDisplayWidget* dw1,
                                       DisplayDisplayWidget* dw2)
{
	gint x1 = 0;
	gint y1 = 0;
	gint width1 = 0;
	gint height1 = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint x2 = 0;
	gint y2 = 0;
	gint width2 = 0;
	gint height2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GdkRectangle rect1 = {0};
	GdkRectangle _tmp8_ = {0};
	GdkRectangle rect2 = {0};
	GdkRectangle _tmp9_ = {0};
	GdkRectangle intersection = {0};
	gboolean _tmp10_ = FALSE;
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_ = {0};
	gboolean _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dw1 != NULL, FALSE);
	g_return_val_if_fail (dw2 != NULL, FALSE);
	display_display_widget_get_virtual_monitor_geometry (dw1, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x1 = _tmp0_;
	y1 = _tmp1_;
	width1 = _tmp2_;
	height1 = _tmp3_;
	display_display_widget_get_virtual_monitor_geometry (dw2, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	x2 = _tmp4_;
	y2 = _tmp5_;
	width2 = _tmp6_;
	height2 = _tmp7_;
	_tmp8_.x = x1;
	_tmp8_.y = y1;
	_tmp8_.width = width1;
	_tmp8_.height = height1;
	rect1 = _tmp8_;
	_tmp9_.x = x2 - 1;
	_tmp9_.y = y2 - 1;
	_tmp9_.width = width2 + 2;
	_tmp9_.height = height2 + 2;
	rect2 = _tmp9_;
	_tmp11_ = rect2;
	_tmp13_ = gdk_rectangle_intersect (&rect1, &_tmp11_, &_tmp12_);
	intersection = _tmp12_;
	if (_tmp13_) {
		gboolean _tmp14_ = FALSE;
		GdkRectangle _tmp15_;
		_tmp15_ = intersection;
		if (_tmp15_.width == 1) {
			_tmp14_ = TRUE;
		} else {
			GdkRectangle _tmp16_;
			_tmp16_ = intersection;
			_tmp14_ = _tmp16_.height == 1;
		}
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = FALSE;
	}
	result = _tmp10_;
	return result;
}

static void
display_displays_overlay_calculate_ratio (DisplayDisplaysOverlay* self)
{
	gint added_width = 0;
	gint added_height = 0;
	gint max_width = 0;
	gint max_height = 0;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	added_width = 0;
	added_height = 0;
	max_width = G_MININT;
	max_height = G_MININT;
	_tmp0_ = self->priv->display_widgets;
	{
		GList* display_widget_collection = NULL;
		GList* display_widget_it = NULL;
		display_widget_collection = _tmp0_;
		for (display_widget_it = display_widget_collection; display_widget_it != NULL; display_widget_it = display_widget_it->next) {
			DisplayDisplayWidget* display_widget = NULL;
			display_widget = (DisplayDisplayWidget*) display_widget_it->data;
			{
				gint x = 0;
				gint y = 0;
				gint width = 0;
				gint height = 0;
				DisplayDisplayWidget* _tmp1_;
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp1_ = display_widget;
				display_display_widget_get_virtual_monitor_geometry (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
				x = _tmp2_;
				y = _tmp3_;
				width = _tmp4_;
				height = _tmp5_;
				added_width += width;
				added_height += height;
				max_width = MAX (max_width, x + width);
				max_height = MAX (max_height, y + height);
			}
		}
	}
	self->priv->current_width = gtk_widget_get_width ((GtkWidget*) self);
	self->priv->current_height = gtk_widget_get_height ((GtkWidget*) self);
	self->priv->current_ratio = MIN (((gdouble) (gtk_widget_get_width ((GtkWidget*) self) - 24)) / ((gdouble) added_width), ((gdouble) (gtk_widget_get_height ((GtkWidget*) self) - 24)) / ((gdouble) added_height));
	self->priv->default_x_margin = (gint) ((gtk_widget_get_width ((GtkWidget*) self) - (max_width * self->priv->current_ratio)) / 2);
	self->priv->default_y_margin = (gint) ((gtk_widget_get_height ((GtkWidget*) self) - (max_height * self->priv->current_ratio)) / 2);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		DisplayDisplaysOverlay* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->display_widget);
		_g_object_unref0 (_data8_->virtual_monitor);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda16_ (Block8Data* _data8_)
{
	DisplayDisplaysOverlay* self;
	DisplayDisplayWidget* _tmp0_;
	DisplayVirtualMonitor* _tmp1_;
	DisplayVirtualMonitor* _tmp2_;
	self = _data8_->self;
	_tmp0_ = _data8_->display_widget;
	_tmp1_ = display_display_widget_get_virtual_monitor (_tmp0_);
	_tmp2_ = _tmp1_;
	display_displays_overlay_set_as_primary (self, _tmp2_);
}

static void
___lambda16__display_display_widget_set_as_primary (DisplayDisplayWidget* _sender,
                                                    gpointer self)
{
	__lambda16_ (self);
}

static void
__lambda17_ (Block8Data* _data8_)
{
	DisplayDisplaysOverlay* self;
	DisplayDisplayWidget* _tmp0_;
	self = _data8_->self;
	_tmp0_ = _data8_->display_widget;
	display_displays_overlay_verify_layout (self, _tmp0_);
}

static void
___lambda17__display_display_widget_check_position (DisplayDisplayWidget* _sender,
                                                    gpointer self)
{
	__lambda17_ (self);
}

static void
_display_displays_overlay_check_configuration_change_display_display_widget_configuration_changed (DisplayDisplayWidget* _sender,
                                                                                                   gpointer self)
{
	display_displays_overlay_check_configuration_change ((DisplayDisplaysOverlay*) self);
}

static void
__lambda18_ (Block8Data* _data8_)
{
	DisplayDisplaysOverlay* self;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	self = _data8_->self;
	_tmp1_ = display_virtual_monitor_get_is_active (_data8_->virtual_monitor);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = -1;
	}
	_tmp3_ = self->priv->_active_displays;
	display_displays_overlay_set_active_displays (self, _tmp3_ + _tmp0_);
	display_displays_overlay_change_active_displays_sensitivity (self);
	display_displays_overlay_check_configuration_change (self);
	display_displays_overlay_calculate_ratio (self);
}

static void
___lambda18__display_display_widget_active_changed (DisplayDisplayWidget* _sender,
                                                    gpointer self)
{
	__lambda18_ (self);
}

static void
display_displays_overlay_add_output (DisplayDisplaysOverlay* self,
                                     DisplayVirtualMonitor* virtual_monitor)
{
	Block8Data* _data8_;
	DisplayVirtualMonitor* _tmp0_;
	guint color_number = 0U;
	GList* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	DisplayDisplayWidget* _tmp6_;
	DisplayDisplayWidget* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkOverlay* _tmp10_;
	DisplayDisplayWidget* _tmp11_;
	DisplayDisplayWidget* _tmp12_;
	DisplayDisplayWidget* _tmp13_;
	DisplayDisplayWidget* _tmp14_;
	DisplayDisplayWidget* _tmp15_;
	DisplayDisplayWidget* _tmp16_;
	DisplayDisplayWidget* _tmp17_;
	gboolean _tmp18_ = FALSE;
	DisplayMonitorManager* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (virtual_monitor != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (virtual_monitor);
	_g_object_unref0 (_data8_->virtual_monitor);
	_data8_->virtual_monitor = _tmp0_;
	self->priv->current_width = 0;
	self->priv->current_height = 0;
	_tmp1_ = self->priv->display_widgets;
	color_number = (g_list_length (_tmp1_) - 1) % 7;
	_tmp2_ = display_displays_overlay_colors;
	_tmp2__length1 = display_displays_overlay_colors_length1;
	_tmp3_ = _tmp2_[color_number];
	_tmp4_ = display_displays_overlay_text_colors;
	_tmp4__length1 = display_displays_overlay_text_colors_length1;
	_tmp5_ = _tmp4_[color_number];
	_tmp6_ = display_display_widget_new (_data8_->virtual_monitor, _tmp3_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	_data8_->display_widget = _tmp6_;
	_tmp7_ = _data8_->display_widget;
	_tmp8_ = g_strdup_printf ("color-%u", color_number);
	_tmp9_ = _tmp8_;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->overlay;
	_tmp11_ = _data8_->display_widget;
	gtk_overlay_add_overlay (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = _data8_->display_widget;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	self->priv->display_widgets = g_list_append (self->priv->display_widgets, _tmp13_);
	_tmp14_ = _data8_->display_widget;
	g_signal_connect_data (_tmp14_, "set-as-primary", (GCallback) ___lambda16__display_display_widget_set_as_primary, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp15_ = _data8_->display_widget;
	g_signal_connect_data (_tmp15_, "check-position", (GCallback) ___lambda17__display_display_widget_check_position, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp16_ = _data8_->display_widget;
	g_signal_connect_object (_tmp16_, "configuration-changed", (GCallback) _display_displays_overlay_check_configuration_change_display_display_widget_configuration_changed, self, 0);
	_tmp17_ = _data8_->display_widget;
	g_signal_connect_data (_tmp17_, "active-changed", (GCallback) ___lambda18__display_display_widget_active_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp19_ = self->priv->monitor_manager;
	_tmp20_ = display_monitor_manager_get_is_mirrored (_tmp19_);
	_tmp21_ = _tmp20_;
	if (!_tmp21_) {
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp22_ = display_virtual_monitor_get_is_active (_data8_->virtual_monitor);
		_tmp23_ = _tmp22_;
		_tmp18_ = _tmp23_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		display_displays_overlay_show_windows (self);
	}
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
display_displays_overlay_set_as_primary (DisplayDisplaysOverlay* self,
                                         DisplayVirtualMonitor* new_primary)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_primary != NULL);
	_tmp0_ = self->priv->display_widgets;
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp0_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			DisplayDisplayWidget* widget = NULL;
			widget = (DisplayDisplayWidget*) widget_it->data;
			{
				DisplayVirtualMonitor* virtual_monitor = NULL;
				DisplayDisplayWidget* _tmp1_;
				DisplayVirtualMonitor* _tmp2_;
				DisplayVirtualMonitor* _tmp3_;
				DisplayVirtualMonitor* _tmp4_;
				gboolean is_primary = FALSE;
				DisplayVirtualMonitor* _tmp5_;
				DisplayDisplayWidget* _tmp6_;
				DisplayVirtualMonitor* _tmp7_;
				_tmp1_ = widget;
				_tmp2_ = display_display_widget_get_virtual_monitor (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				virtual_monitor = _tmp4_;
				_tmp5_ = virtual_monitor;
				is_primary = _tmp5_ == new_primary;
				_tmp6_ = widget;
				display_display_widget_set_primary (_tmp6_, is_primary);
				_tmp7_ = virtual_monitor;
				display_virtual_monitor_set_primary (_tmp7_, is_primary);
				_g_object_unref0 (virtual_monitor);
			}
		}
	}
	{
		GeeLinkedList* _virtual_monitor_list = NULL;
		DisplayMonitorManager* _tmp8_;
		GeeLinkedList* _tmp9_;
		GeeLinkedList* _tmp10_;
		gint _virtual_monitor_size = 0;
		GeeLinkedList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _virtual_monitor_index = 0;
		_tmp8_ = self->priv->monitor_manager;
		_tmp9_ = display_monitor_manager_get_virtual_monitors (_tmp8_);
		_tmp10_ = _tmp9_;
		_virtual_monitor_list = _tmp10_;
		_tmp11_ = _virtual_monitor_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_virtual_monitor_size = _tmp13_;
		_virtual_monitor_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			DisplayVirtualMonitor* virtual_monitor = NULL;
			GeeLinkedList* _tmp16_;
			gpointer _tmp17_;
			DisplayVirtualMonitor* _tmp18_;
			DisplayVirtualMonitor* _tmp19_;
			_virtual_monitor_index = _virtual_monitor_index + 1;
			_tmp14_ = _virtual_monitor_index;
			_tmp15_ = _virtual_monitor_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _virtual_monitor_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _virtual_monitor_index);
			virtual_monitor = (DisplayVirtualMonitor*) _tmp17_;
			_tmp18_ = virtual_monitor;
			_tmp19_ = virtual_monitor;
			display_virtual_monitor_set_primary (_tmp18_, _tmp19_ == new_primary);
			_g_object_unref0 (virtual_monitor);
		}
	}
	display_displays_overlay_check_configuration_change (self);
}

static void
display_displays_overlay_verify_layout (DisplayDisplaysOverlay* self,
                                        DisplayDisplayWidget* changed_widget)
{
	guint iteration = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_widget != NULL);
	iteration = (guint) 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		guint _tmp2_;
		if (iteration < ((guint) 10)) {
			gboolean _tmp1_ = FALSE;
			if (display_displays_overlay_check_intersects (self, changed_widget, FALSE, (guint) 0)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = display_displays_overlay_align_edges (self, changed_widget, FALSE, (guint) 0);
			}
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp2_ = iteration;
		iteration = _tmp2_ + 1;
	}
	display_displays_overlay_set_origin_zero (self);
	display_displays_overlay_calculate_ratio (self);
	display_displays_overlay_check_configuration_change (self);
}

static gboolean
display_displays_overlay_align_edges (DisplayDisplaysOverlay* self,
                                      DisplayDisplayWidget* changed_widget,
                                      gboolean moved,
                                      guint level)
{
	gint x = 0;
	gint y = 0;
	gint width = 0;
	gint height = 0;
	GdkRectangle overlap = {0};
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (changed_widget != NULL, FALSE);
	_tmp0_ = self->priv->display_widgets;
	{
		GList* other_display_widget_collection = NULL;
		GList* other_display_widget_it = NULL;
		other_display_widget_collection = _tmp0_;
		for (other_display_widget_it = other_display_widget_collection; other_display_widget_it != NULL; other_display_widget_it = other_display_widget_it->next) {
			DisplayDisplayWidget* other_display_widget = NULL;
			other_display_widget = (DisplayDisplayWidget*) other_display_widget_it->data;
			{
				DisplayDisplayWidget* _tmp1_;
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				GdkRectangle source_rect = {0};
				GdkRectangle _tmp6_ = {0};
				gint dx = 0;
				gint dy = 0;
				gint other_x = 0;
				gint other_y = 0;
				gint other_width = 0;
				gint other_height = 0;
				DisplayDisplayWidget* _tmp7_;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint dx_left = 0;
				gint dx_right = 0;
				gint dy_top = 0;
				gint dy_bottom = 0;
				GdkRectangle rect_top = {0};
				GdkRectangle _tmp12_ = {0};
				GdkRectangle rect_bottom = {0};
				GdkRectangle _tmp13_ = {0};
				GdkRectangle rect_left = {0};
				GdkRectangle _tmp14_ = {0};
				GdkRectangle rect_right = {0};
				GdkRectangle _tmp15_ = {0};
				GdkRectangle _tmp16_;
				GdkRectangle _tmp17_ = {0};
				gboolean _tmp18_;
				DisplayDisplayWidget* _tmp28_;
				DisplayDisplayWidget* _tmp29_;
				gboolean _tmp30_ = FALSE;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				_tmp1_ = other_display_widget;
				if (_tmp1_ == changed_widget) {
					continue;
				}
				display_display_widget_get_virtual_monitor_geometry (changed_widget, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
				x = _tmp2_;
				y = _tmp3_;
				width = _tmp4_;
				height = _tmp5_;
				_tmp6_.x = x;
				_tmp6_.y = y;
				_tmp6_.width = width;
				_tmp6_.height = height;
				source_rect = _tmp6_;
				dx = 0;
				dy = 0;
				_tmp7_ = other_display_widget;
				display_display_widget_get_virtual_monitor_geometry (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
				other_x = _tmp8_;
				other_y = _tmp9_;
				other_width = _tmp10_;
				other_height = _tmp11_;
				dx_left = x - other_x;
				dx_right = (x + width) - (other_x + other_width);
				dy_top = y - other_y;
				dy_bottom = (y + height) - (other_y + other_height);
				_tmp12_.x = other_x;
				_tmp12_.y = other_y - other_height;
				_tmp12_.width = other_width;
				_tmp12_.height = height;
				rect_top = _tmp12_;
				_tmp13_.x = other_x;
				_tmp13_.y = other_y + other_height;
				_tmp13_.width = other_width;
				_tmp13_.height = height;
				rect_bottom = _tmp13_;
				_tmp14_.x = other_x - width;
				_tmp14_.y = other_y;
				_tmp14_.width = width;
				_tmp14_.height = other_height;
				rect_left = _tmp14_;
				_tmp15_.x = other_x + other_width;
				_tmp15_.y = other_y;
				_tmp15_.width = width;
				_tmp15_.height = other_height;
				rect_right = _tmp15_;
				_tmp16_ = rect_top;
				_tmp18_ = gdk_rectangle_intersect (&source_rect, &_tmp16_, &_tmp17_);
				overlap = _tmp17_;
				if (_tmp18_) {
					dy = other_y - (y + height);
					if (abs (dx_left) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
						dx = -dx_left;
					} else {
						if (abs (dx_right) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
							dx = -dx_right;
						}
					}
				} else {
					GdkRectangle _tmp19_;
					GdkRectangle _tmp20_ = {0};
					gboolean _tmp21_;
					_tmp19_ = rect_bottom;
					_tmp21_ = gdk_rectangle_intersect (&source_rect, &_tmp19_, &_tmp20_);
					overlap = _tmp20_;
					if (_tmp21_) {
						dy = (other_y + other_height) - y;
						if (abs (dx_left) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
							dx = -dx_left;
						} else {
							if (abs (dx_right) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
								dx = -dx_right;
							}
						}
					} else {
						GdkRectangle _tmp22_;
						GdkRectangle _tmp23_ = {0};
						gboolean _tmp24_;
						_tmp22_ = rect_left;
						_tmp24_ = gdk_rectangle_intersect (&source_rect, &_tmp22_, &_tmp23_);
						overlap = _tmp23_;
						if (_tmp24_) {
							dx = other_x - (x + width);
							if (abs (dy_top) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
								dy = -dy_top;
							} else {
								if (abs (dy_bottom) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
									dy = -dy_bottom;
								}
							}
						} else {
							GdkRectangle _tmp25_;
							GdkRectangle _tmp26_ = {0};
							gboolean _tmp27_;
							_tmp25_ = rect_right;
							_tmp27_ = gdk_rectangle_intersect (&source_rect, &_tmp25_, &_tmp26_);
							overlap = _tmp26_;
							if (_tmp27_) {
								dx = (other_x + other_width) - x;
								if (abs (dy_top) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
									dy = -dy_top;
								} else {
									if (abs (dy_bottom) < DISPLAY_DISPLAYS_OVERLAY_MINIMUM_WIDGET_OFFSET) {
										dy = -dy_bottom;
									}
								}
							}
						}
					}
				}
				_tmp28_ = other_display_widget;
				display_display_widget_move_x (_tmp28_, -dx);
				_tmp29_ = other_display_widget;
				display_display_widget_move_y (_tmp29_, -dy);
				if (moved) {
					_tmp31_ = TRUE;
				} else {
					_tmp31_ = dx != 0;
				}
				if (_tmp31_) {
					_tmp30_ = TRUE;
				} else {
					_tmp30_ = dy != 0;
				}
				moved = _tmp30_;
				if (dx != 0) {
					_tmp32_ = TRUE;
				} else {
					_tmp32_ = dy != 0;
				}
				if (_tmp32_) {
					DisplayDisplayWidget* _tmp33_;
					gboolean _tmp34_;
					guint _tmp35_;
					_tmp33_ = other_display_widget;
					_tmp34_ = moved;
					level = level + 1;
					_tmp35_ = level;
					display_displays_overlay_align_edges (self, _tmp33_, _tmp34_, _tmp35_);
				}
			}
		}
	}
	result = moved;
	return result;
}

static void
display_displays_overlay_set_origin_zero (DisplayDisplaysOverlay* self)
{
	gint min_x = 0;
	gint min_y = 0;
	GList* _tmp0_;
	gboolean _tmp6_ = FALSE;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	min_x = G_MAXINT;
	min_y = G_MAXINT;
	_tmp0_ = self->priv->display_widgets;
	{
		GList* display_widget_collection = NULL;
		GList* display_widget_it = NULL;
		display_widget_collection = _tmp0_;
		for (display_widget_it = display_widget_collection; display_widget_it != NULL; display_widget_it = display_widget_it->next) {
			DisplayDisplayWidget* display_widget = NULL;
			display_widget = (DisplayDisplayWidget*) display_widget_it->data;
			{
				gint x = 0;
				gint y = 0;
				gint width = 0;
				gint height = 0;
				DisplayDisplayWidget* _tmp1_;
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp1_ = display_widget;
				display_display_widget_get_virtual_monitor_geometry (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
				x = _tmp2_;
				y = _tmp3_;
				width = _tmp4_;
				height = _tmp5_;
				min_x = MIN (min_x, x);
				min_y = MIN (min_y, y);
			}
		}
	}
	if (min_x == 0) {
		_tmp6_ = min_y == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		return;
	}
	_tmp7_ = self->priv->display_widgets;
	{
		GList* display_widget_collection = NULL;
		GList* display_widget_it = NULL;
		display_widget_collection = _tmp7_;
		for (display_widget_it = display_widget_collection; display_widget_it != NULL; display_widget_it = display_widget_it->next) {
			DisplayDisplayWidget* display_widget = NULL;
			display_widget = (DisplayDisplayWidget*) display_widget_it->data;
			{
				gint x = 0;
				gint y = 0;
				gint width = 0;
				gint height = 0;
				DisplayDisplayWidget* _tmp8_;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				DisplayDisplayWidget* _tmp13_;
				_tmp8_ = display_widget;
				display_display_widget_get_virtual_monitor_geometry (_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
				x = _tmp9_;
				y = _tmp10_;
				width = _tmp11_;
				height = _tmp12_;
				_tmp13_ = display_widget;
				display_display_widget_set_virtual_monitor_geometry (_tmp13_, x - min_x, y - min_y, width, height);
			}
		}
	}
	return;
}

static gboolean
display_displays_overlay_check_intersects (DisplayDisplaysOverlay* self,
                                           DisplayDisplayWidget* changed_widget,
                                           gboolean moved,
                                           guint level)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint x = 0;
	gint y = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GdkRectangle src_rect = {0};
	GdkRectangle _tmp6_ = {0};
	GList* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (changed_widget != NULL, FALSE);
	_tmp0_ = display_displays_overlay_get_only_display (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	if (level > ((guint) 10)) {
		g_warning ("DisplaysOverlay.vala:523: Depth of recursion exceeds limit (10)");
		result = moved;
		return result;
	}
	display_display_widget_get_virtual_monitor_geometry (changed_widget, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp2_;
	y = _tmp3_;
	width = _tmp4_;
	height = _tmp5_;
	_tmp6_.x = x;
	_tmp6_.y = y;
	_tmp6_.width = width;
	_tmp6_.height = height;
	src_rect = _tmp6_;
	_tmp7_ = self->priv->display_widgets;
	{
		GList* other_display_widget_collection = NULL;
		GList* other_display_widget_it = NULL;
		other_display_widget_collection = _tmp7_;
		for (other_display_widget_it = other_display_widget_collection; other_display_widget_it != NULL; other_display_widget_it = other_display_widget_it->next) {
			DisplayDisplayWidget* other_display_widget = NULL;
			other_display_widget = (DisplayDisplayWidget*) other_display_widget_it->data;
			{
				gint distance_x = 0;
				gint distance_y = 0;
				DisplayDisplayWidget* _tmp8_;
				gint other_x = 0;
				gint other_y = 0;
				gint other_width = 0;
				gint other_height = 0;
				DisplayDisplayWidget* _tmp9_;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				GdkRectangle overlap = {0};
				GdkRectangle other_rect = {0};
				GdkRectangle _tmp14_ = {0};
				GdkRectangle _tmp15_;
				GdkRectangle _tmp16_ = {0};
				gboolean _tmp17_;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				distance_x = 0;
				distance_y = 0;
				_tmp8_ = other_display_widget;
				if (_tmp8_ == changed_widget) {
					continue;
				}
				_tmp9_ = other_display_widget;
				display_display_widget_get_virtual_monitor_geometry (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
				other_x = _tmp10_;
				other_y = _tmp11_;
				other_width = _tmp12_;
				other_height = _tmp13_;
				_tmp14_.x = other_x;
				_tmp14_.y = other_y;
				_tmp14_.width = other_width;
				_tmp14_.height = other_height;
				other_rect = _tmp14_;
				_tmp15_ = other_rect;
				_tmp17_ = gdk_rectangle_intersect (&src_rect, &_tmp15_, &_tmp16_);
				overlap = _tmp16_;
				if (_tmp17_) {
					gint dx_left = 0;
					gint dx_right = 0;
					gint dy_top = 0;
					gint dy_bottom = 0;
					DisplayDisplayWidget* _tmp42_;
					DisplayDisplayWidget* _tmp43_;
					DisplayDisplayWidget* _tmp44_;
					gboolean _tmp45_;
					guint _tmp46_;
					dx_left = abs ((x + width) - other_x);
					dx_right = abs ((other_x + other_width) - x);
					dy_top = abs ((y + height) - other_y);
					dy_bottom = abs ((other_y + other_height) - y);
					if (x < other_x) {
						if (y < other_y) {
							gint _tmp18_ = 0;
							GdkRectangle _tmp19_;
							GdkRectangle _tmp20_;
							gint _tmp21_ = 0;
							GdkRectangle _tmp22_;
							GdkRectangle _tmp23_;
							_tmp19_ = overlap;
							_tmp20_ = overlap;
							if (_tmp19_.width > _tmp20_.height) {
								_tmp18_ = 0;
							} else {
								_tmp18_ = dx_left;
							}
							distance_x = _tmp18_;
							_tmp22_ = overlap;
							_tmp23_ = overlap;
							if (_tmp22_.width > _tmp23_.height) {
								_tmp21_ = dy_top;
							} else {
								_tmp21_ = 0;
							}
							distance_y = _tmp21_;
						} else {
							gint _tmp24_ = 0;
							GdkRectangle _tmp25_;
							GdkRectangle _tmp26_;
							gint _tmp27_ = 0;
							GdkRectangle _tmp28_;
							GdkRectangle _tmp29_;
							_tmp25_ = overlap;
							_tmp26_ = overlap;
							if (_tmp25_.width > _tmp26_.height) {
								_tmp24_ = 0;
							} else {
								_tmp24_ = dx_left;
							}
							distance_x = _tmp24_;
							_tmp28_ = overlap;
							_tmp29_ = overlap;
							if (_tmp28_.width > _tmp29_.height) {
								_tmp27_ = -dy_bottom;
							} else {
								_tmp27_ = 0;
							}
							distance_y = _tmp27_;
						}
					} else {
						if (y < other_y) {
							gint _tmp30_ = 0;
							GdkRectangle _tmp31_;
							GdkRectangle _tmp32_;
							gint _tmp33_ = 0;
							GdkRectangle _tmp34_;
							GdkRectangle _tmp35_;
							_tmp31_ = overlap;
							_tmp32_ = overlap;
							if (_tmp31_.width > _tmp32_.height) {
								_tmp30_ = 0;
							} else {
								_tmp30_ = -dx_right;
							}
							distance_x = _tmp30_;
							_tmp34_ = overlap;
							_tmp35_ = overlap;
							if (_tmp34_.width > _tmp35_.height) {
								_tmp33_ = dy_top;
							} else {
								_tmp33_ = 0;
							}
							distance_y = _tmp33_;
						} else {
							gint _tmp36_ = 0;
							GdkRectangle _tmp37_;
							GdkRectangle _tmp38_;
							gint _tmp39_ = 0;
							GdkRectangle _tmp40_;
							GdkRectangle _tmp41_;
							_tmp37_ = overlap;
							_tmp38_ = overlap;
							if (_tmp37_.width > _tmp38_.height) {
								_tmp36_ = 0;
							} else {
								_tmp36_ = -dx_right;
							}
							distance_x = _tmp36_;
							_tmp40_ = overlap;
							_tmp41_ = overlap;
							if (_tmp40_.width > _tmp41_.height) {
								_tmp39_ = -dy_bottom;
							} else {
								_tmp39_ = 0;
							}
							distance_y = _tmp39_;
						}
					}
					_tmp42_ = other_display_widget;
					display_display_widget_move_x (_tmp42_, distance_x);
					_tmp43_ = other_display_widget;
					display_display_widget_move_y (_tmp43_, distance_y);
					_tmp44_ = other_display_widget;
					_tmp45_ = moved;
					level = level + 1;
					_tmp46_ = level;
					display_displays_overlay_check_intersects (self, _tmp44_, _tmp45_, _tmp46_);
				}
				if (moved) {
					_tmp48_ = TRUE;
				} else {
					_tmp48_ = distance_x != 0;
				}
				if (_tmp48_) {
					_tmp47_ = TRUE;
				} else {
					_tmp47_ = distance_y != 0;
				}
				moved = _tmp47_;
			}
		}
	}
	result = moved;
	return result;
}

DisplayDisplaysOverlay*
display_displays_overlay_construct (GType object_type)
{
	DisplayDisplaysOverlay * self = NULL;
	self = (DisplayDisplaysOverlay*) g_object_new (object_type, NULL);
	return self;
}

DisplayDisplaysOverlay*
display_displays_overlay_new (void)
{
	return display_displays_overlay_construct (DISPLAY_TYPE_DISPLAYS_OVERLAY);
}

gint
display_displays_overlay_get_active_displays (DisplayDisplaysOverlay* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_active_displays;
	return result;
}

void
display_displays_overlay_set_active_displays (DisplayDisplaysOverlay* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_displays_overlay_get_active_displays (self);
	if (old_value != value) {
		self->priv->_active_displays = value;
		g_object_notify_by_pspec ((GObject *) self, display_displays_overlay_properties[DISPLAY_DISPLAYS_OVERLAY_ACTIVE_DISPLAYS_PROPERTY]);
	}
}

gboolean
display_displays_overlay_get_only_display (DisplayDisplaysOverlay* self)
{
	gboolean result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active_displays;
	result = _tmp0_ <= 1;
	return result;
}

static void
_display_displays_overlay_on_drag_begin_gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                                                     gdouble start_x,
                                                                     gdouble start_y,
                                                                     gpointer self)
{
	display_displays_overlay_on_drag_begin ((DisplayDisplaysOverlay*) self, start_x, start_y);
}

static void
_display_displays_overlay_on_drag_update_gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                                       gdouble offset_x,
                                                                       gdouble offset_y,
                                                                       gpointer self)
{
	display_displays_overlay_on_drag_update ((DisplayDisplaysOverlay*) self, offset_x, offset_y);
}

static void
_display_displays_overlay_on_drag_end_gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                                                 gdouble offset_x,
                                                                 gdouble offset_y,
                                                                 gpointer self)
{
	display_displays_overlay_on_drag_end ((DisplayDisplaysOverlay*) self);
}

static void
_display_displays_overlay___lambda19_ (DisplayDisplaysOverlay* self)
{
	display_displays_overlay_rescan_displays (self);
}

static void
__display_displays_overlay___lambda19__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	_display_displays_overlay___lambda19_ ((DisplayDisplaysOverlay*) self);
}

static gboolean
_display_displays_overlay_get_child_position_gtk_overlay_get_child_position (GtkOverlay* _sender,
                                                                             GtkWidget* widget,
                                                                             GdkRectangle* allocation,
                                                                             gpointer self)
{
	gboolean result;
	result = display_displays_overlay_get_child_position ((DisplayDisplaysOverlay*) self, widget, allocation);
	return result;
}

static GObject *
display_displays_overlay_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DisplayDisplaysOverlay * self;
	GtkOverlay* _tmp0_;
	GtkOverlay* _tmp1_;
	GtkGestureDrag* _tmp2_;
	GtkGestureDrag* _tmp3_;
	GtkGestureDrag* _tmp4_;
	GtkGestureDrag* _tmp5_;
	GtkGestureDrag* _tmp6_;
	GtkEventController* _tmp7_;
	DisplayMonitorManager* _tmp8_;
	DisplayMonitorManager* _tmp9_;
	GtkOverlay* _tmp10_;
	parent_class = G_OBJECT_CLASS (display_displays_overlay_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_DISPLAYS_OVERLAY, DisplayDisplaysOverlay);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_VIEW);
	_tmp0_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp0_;
	_tmp1_ = self->priv->overlay;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp1_);
	(self->priv->display_widgets == NULL) ? NULL : (self->priv->display_widgets = (_g_list_free__g_object_unref0_ (self->priv->display_widgets), NULL));
	self->priv->display_widgets = NULL;
	_tmp2_ = (GtkGestureDrag*) gtk_gesture_drag_new ();
	_g_object_unref0 (self->priv->drag_gesture);
	self->priv->drag_gesture = _tmp2_;
	_tmp3_ = self->priv->drag_gesture;
	g_signal_connect_object (_tmp3_, "drag-begin", (GCallback) _display_displays_overlay_on_drag_begin_gtk_gesture_drag_drag_begin, self, 0);
	_tmp4_ = self->priv->drag_gesture;
	g_signal_connect_object (_tmp4_, "drag-update", (GCallback) _display_displays_overlay_on_drag_update_gtk_gesture_drag_drag_update, self, 0);
	_tmp5_ = self->priv->drag_gesture;
	g_signal_connect_object (_tmp5_, "drag-end", (GCallback) _display_displays_overlay_on_drag_end_gtk_gesture_drag_drag_end, self, 0);
	_tmp6_ = self->priv->drag_gesture;
	_tmp7_ = _g_object_ref0 ((GtkEventController*) _tmp6_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp7_);
	_tmp8_ = display_monitor_manager_get_default ();
	self->priv->monitor_manager = _tmp8_;
	_tmp9_ = self->priv->monitor_manager;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::virtual-monitor-number", (GCallback) __display_displays_overlay___lambda19__g_object_notify, self, 0);
	display_displays_overlay_rescan_displays (self);
	_tmp10_ = self->priv->overlay;
	g_signal_connect_object (_tmp10_, "get-child-position", (GCallback) _display_displays_overlay_get_child_position_gtk_overlay_get_child_position, self, 0);
	return obj;
}

static void
_display_displays_overlay___lambda20_ (GObject* obj,
                                       GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GalaDBus* _tmp0_ = NULL;
		GalaDBus* _tmp1_;
		GalaDBus* _tmp2_;
		GalaDBus* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (GalaDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (GalaDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (display_displays_overlay_gala_dbus);
		display_displays_overlay_gala_dbus = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("DisplaysOverlay.vala:116: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__display_displays_overlay___lambda20__gasync_ready_callback (GObject* source_object,
                                                              GAsyncResult* res,
                                                              gpointer self)
{
	_display_displays_overlay___lambda20_ (source_object, res);
}

static void
display_displays_overlay_class_init (DisplayDisplaysOverlayClass * klass,
                                     gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	GtkCssProvider* display_provider = NULL;
	GtkCssProvider* _tmp16_;
	GtkCssProvider* _tmp17_;
	GdkDisplay* _tmp18_;
	GtkCssProvider* _tmp19_;
	GError* _inner_error0_ = NULL;
	display_displays_overlay_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayDisplaysOverlay_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_display_displays_overlay_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_display_displays_overlay_set_property;
	G_OBJECT_CLASS (klass)->constructor = display_displays_overlay_constructor;
	G_OBJECT_CLASS (klass)->finalize = display_displays_overlay_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAYS_OVERLAY_ACTIVE_DISPLAYS_PROPERTY, display_displays_overlay_properties[DISPLAY_DISPLAYS_OVERLAY_ACTIVE_DISPLAYS_PROPERTY] = g_param_spec_int ("active-displays", "active-displays", "active-displays", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAYS_OVERLAY_ONLY_DISPLAY_PROPERTY, display_displays_overlay_properties[DISPLAY_DISPLAYS_OVERLAY_ONLY_DISPLAY_PROPERTY] = g_param_spec_boolean ("only-display", "only-display", "only-display", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	display_displays_overlay_signals[DISPLAY_DISPLAYS_OVERLAY_CONFIGURATION_CHANGED_SIGNAL] = g_signal_new ("configuration-changed", DISPLAY_TYPE_DISPLAYS_OVERLAY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	_tmp0_ = g_strdup ("@BLUEBERRY_100");
	_tmp1_ = g_strdup ("@STRAWBERRY_100");
	_tmp2_ = g_strdup ("@ORANGE_100");
	_tmp3_ = g_strdup ("@BANANA_100");
	_tmp4_ = g_strdup ("@LIME_100");
	_tmp5_ = g_strdup ("@GRAPE_100");
	_tmp6_ = g_strdup ("@COCOA_100");
	_tmp7_ = g_new0 (gchar*, 7 + 1);
	_tmp7_[0] = _tmp0_;
	_tmp7_[1] = _tmp1_;
	_tmp7_[2] = _tmp2_;
	_tmp7_[3] = _tmp3_;
	_tmp7_[4] = _tmp4_;
	_tmp7_[5] = _tmp5_;
	_tmp7_[6] = _tmp6_;
	display_displays_overlay_colors = _tmp7_;
	display_displays_overlay_colors_length1 = 7;
	_display_displays_overlay_colors_size_ = display_displays_overlay_colors_length1;
	_tmp8_ = g_strdup ("@BLUEBERRY_900");
	_tmp9_ = g_strdup ("@STRAWBERRY_900");
	_tmp10_ = g_strdup ("@ORANGE_900");
	_tmp11_ = g_strdup ("@BANANA_900");
	_tmp12_ = g_strdup ("@LIME_900");
	_tmp13_ = g_strdup ("@GRAPE_900");
	_tmp14_ = g_strdup ("@COCOA_900");
	_tmp15_ = g_new0 (gchar*, 7 + 1);
	_tmp15_[0] = _tmp8_;
	_tmp15_[1] = _tmp9_;
	_tmp15_[2] = _tmp10_;
	_tmp15_[3] = _tmp11_;
	_tmp15_[4] = _tmp12_;
	_tmp15_[5] = _tmp13_;
	_tmp15_[6] = _tmp14_;
	display_displays_overlay_text_colors = _tmp15_;
	display_displays_overlay_text_colors_length1 = 7;
	_display_displays_overlay_text_colors_size_ = display_displays_overlay_text_colors_length1;
	_tmp16_ = gtk_css_provider_new ();
	display_provider = _tmp16_;
	_tmp17_ = display_provider;
	gtk_css_provider_load_from_resource (_tmp17_, "io/elementary/settings/display/Display.css");
	_tmp18_ = gdk_display_get_default ();
	_tmp19_ = display_provider;
	gtk_style_context_add_provider_for_display (_tmp18_, (GtkStyleProvider*) _tmp19_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	g_async_initable_new_async (TYPE_GALA_DBUS_PROXY, 0, NULL, __display_displays_overlay___lambda20__gasync_ready_callback, NULL, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.pantheon.gala.daemon", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/pantheon/gala/daemon", "g-interface-name", "org.pantheon.gala.daemon", NULL);
	_g_object_unref0 (display_provider);
}

static void
display_displays_overlay_instance_init (DisplayDisplaysOverlay * self,
                                        gpointer klass)
{
	self->priv = display_displays_overlay_get_instance_private (self);
	self->priv->scanning = FALSE;
	self->priv->current_ratio = (gdouble) 1.0f;
	self->priv->current_width = 0;
	self->priv->current_height = 0;
	self->priv->default_x_margin = 0;
	self->priv->default_y_margin = 0;
	self->priv->_active_displays = 0;
	self->priv->dragging_display = NULL;
	self->priv->prev_dx = (gdouble) 0;
	self->priv->prev_dy = (gdouble) 0;
}

static void
display_displays_overlay_finalize (GObject * obj)
{
	DisplayDisplaysOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_DISPLAYS_OVERLAY, DisplayDisplaysOverlay);
	_g_object_unref0 (self->priv->overlay);
	(self->priv->display_widgets == NULL) ? NULL : (self->priv->display_widgets = (_g_list_free__g_object_unref0_ (self->priv->display_widgets), NULL));
	_g_object_unref0 (self->priv->dragging_display);
	_g_object_unref0 (self->priv->drag_gesture);
	G_OBJECT_CLASS (display_displays_overlay_parent_class)->finalize (obj);
}

static GType
display_displays_overlay_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayDisplaysOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_displays_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayDisplaysOverlay), 0, (GInstanceInitFunc) display_displays_overlay_instance_init, NULL };
	GType display_displays_overlay_type_id;
	display_displays_overlay_type_id = g_type_register_static (gtk_box_get_type (), "DisplayDisplaysOverlay", &g_define_type_info, 0);
	DisplayDisplaysOverlay_private_offset = g_type_add_instance_private (display_displays_overlay_type_id, sizeof (DisplayDisplaysOverlayPrivate));
	return display_displays_overlay_type_id;
}

GType
display_displays_overlay_get_type (void)
{
	static volatile gsize display_displays_overlay_type_id__once = 0;
	if (g_once_init_enter (&display_displays_overlay_type_id__once)) {
		GType display_displays_overlay_type_id;
		display_displays_overlay_type_id = display_displays_overlay_get_type_once ();
		g_once_init_leave (&display_displays_overlay_type_id__once, display_displays_overlay_type_id);
	}
	return display_displays_overlay_type_id__once;
}

static void
_vala_display_displays_overlay_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	DisplayDisplaysOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_DISPLAYS_OVERLAY, DisplayDisplaysOverlay);
	switch (property_id) {
		case DISPLAY_DISPLAYS_OVERLAY_ACTIVE_DISPLAYS_PROPERTY:
		g_value_set_int (value, display_displays_overlay_get_active_displays (self));
		break;
		case DISPLAY_DISPLAYS_OVERLAY_ONLY_DISPLAY_PROPERTY:
		g_value_set_boolean (value, display_displays_overlay_get_only_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_display_displays_overlay_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	DisplayDisplaysOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_DISPLAYS_OVERLAY, DisplayDisplaysOverlay);
	switch (property_id) {
		case DISPLAY_DISPLAYS_OVERLAY_ACTIVE_DISPLAYS_PROPERTY:
		display_displays_overlay_set_active_displays (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

