/* Clipboard.c generated by valac 0.56.18, the Vala compiler
 * generated from Clipboard.vala, do not modify */

/*
* Copyright (c) 2018 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define SPICE_CLIPBOARD_SPICE_UP_TARGET_NAME "x-application/spice-up-data"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_CLIPBOARD (spice_clipboard_get_type ())
#define SPICE_CLIPBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CLIPBOARD, SpiceClipboard))
#define SPICE_CLIPBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CLIPBOARD, SpiceClipboardClass))
#define SPICE_IS_CLIPBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CLIPBOARD))
#define SPICE_IS_CLIPBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CLIPBOARD))
#define SPICE_CLIPBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CLIPBOARD, SpiceClipboardClass))

typedef struct _SpiceClipboard SpiceClipboard;
typedef struct _SpiceClipboardClass SpiceClipboardClass;
typedef struct _SpiceClipboardPrivate SpiceClipboardPrivate;
typedef enum  {
	SPICE_CLIPBOARD_TARGET_STRING,
	SPICE_CLIPBOARD_TARGET_IMAGE,
	SPICE_CLIPBOARD_TARGET_SPICE
} SpiceClipboardTarget;

#define SPICE_CLIPBOARD_TYPE_TARGET (spice_clipboard_target_get_type ())

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;

#define SPICE_TYPE_TEXT_ITEM (spice_text_item_get_type ())
#define SPICE_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItem))
#define SPICE_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))
#define SPICE_IS_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_TEXT_ITEM))
#define SPICE_IS_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_TEXT_ITEM))
#define SPICE_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))

typedef struct _SpiceTextItem SpiceTextItem;
typedef struct _SpiceTextItemClass SpiceTextItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_TYPE_IMAGE_ITEM (spice_image_item_get_type ())
#define SPICE_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItem))
#define SPICE_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))
#define SPICE_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))

typedef struct _SpiceImageItem SpiceImageItem;
typedef struct _SpiceImageItemClass SpiceImageItemClass;

#define SPICE_TYPE_IMAGE_HANDLER (spice_image_handler_get_type ())
#define SPICE_IMAGE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandler))
#define SPICE_IMAGE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandlerClass))
#define SPICE_IS_IMAGE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_HANDLER))
#define SPICE_IS_IMAGE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_HANDLER))
#define SPICE_IMAGE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandlerClass))

typedef struct _SpiceImageHandler SpiceImageHandler;
typedef struct _SpiceImageHandlerClass SpiceImageHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SPICE_TYPE_SLIDE_MANAGER (spice_slide_manager_get_type ())
#define SPICE_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager))
#define SPICE_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))
#define SPICE_IS_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_IS_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_SLIDE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))

typedef struct _SpiceSlideManager SpiceSlideManager;
typedef struct _SpiceSlideManagerClass SpiceSlideManagerClass;
typedef struct _SpiceCanvasItemPrivate SpiceCanvasItemPrivate;
typedef struct _SpiceTextItemPrivate SpiceTextItemPrivate;

#define SPICE_TYPE_SLIDE (spice_slide_get_type ())
#define SPICE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE, SpiceSlide))
#define SPICE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE, SpiceSlideClass))
#define SPICE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE))
#define SPICE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE))
#define SPICE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE, SpiceSlideClass))

typedef struct _SpiceSlide SpiceSlide;
typedef struct _SpiceSlideClass SpiceSlideClass;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _SpiceSlidePrivate SpiceSlidePrivate;
typedef struct _SpiceCanvasPrivate SpiceCanvasPrivate;

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_CANVAS_TYPE_CANVAS_GRID (spice_canvas_canvas_grid_get_type ())
#define SPICE_CANVAS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid))
#define SPICE_CANVAS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))
#define SPICE_CANVAS_IS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_IS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_CANVAS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))

typedef struct _SpiceCanvasCanvasGrid SpiceCanvasCanvasGrid;
typedef struct _SpiceCanvasCanvasGridClass SpiceCanvasCanvasGridClass;
typedef struct _Block1Data Block1Data;
typedef enum  {
	SPICE_CANVAS_ITEM_TYPE_TEXT,
	SPICE_CANVAS_ITEM_TYPE_IMAGE,
	SPICE_CANVAS_ITEM_TYPE_SHAPE
} SpiceCanvasItemType;

#define SPICE_TYPE_CANVAS_ITEM_TYPE (spice_canvas_item_type_get_type ())
typedef struct _SpiceParamSpecClipboard SpiceParamSpecClipboard;

struct _SpiceClipboard {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SpiceClipboardPrivate * priv;
};

struct _SpiceClipboardClass {
	GTypeClass parent_class;
	void (*finalize) (SpiceClipboard *self);
};

struct _SpiceCanvasItem {
	GtkEventBox parent_instance;
	SpiceCanvasItemPrivate * priv;
	gdouble start_x;
	gdouble start_y;
	gint start_w;
	gint start_h;
	gboolean holding;
	gint holding_id;
	gint real_width;
	gint real_height;
	gint real_x;
	gint real_y;
	GtkGrid* grid;
	GtkRevealer* grabber_revealer;
};

struct _SpiceCanvasItemClass {
	GtkEventBoxClass parent_class;
	gchar* (*serialise_item) (SpiceCanvasItem* self);
	void (*load_item_data) (SpiceCanvasItem* self);
	void (*style) (SpiceCanvasItem* self);
};

struct _SpiceTextItem {
	SpiceCanvasItem parent_instance;
	SpiceTextItemPrivate * priv;
	GtkTextView* entry;
	gboolean setting_text;
	gboolean first_change_in_edit;
	gchar* previous_text;
	gboolean underlined;
};

struct _SpiceTextItemClass {
	SpiceCanvasItemClass parent_class;
};

struct _SpiceSlide {
	GObject parent_instance;
	SpiceSlidePrivate * priv;
	JsonObject* save_data;
	SpiceCanvas* canvas;
	GtkImage* preview;
};

struct _SpiceSlideClass {
	GObjectClass parent_class;
};

struct _SpiceCanvas {
	GtkOverlay parent_instance;
	SpiceCanvasPrivate * priv;
	SpiceWindow* window;
	gdouble current_allocated_width;
	gdouble current_allocated_height;
	SpiceCanvasCanvasGrid* grid;
	JsonObject* save_data;
	GraniteDrawingBufferSurface* surface;
};

struct _SpiceCanvasClass {
	GtkOverlayClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	SpiceSlideManager* manager;
};

struct _SpiceParamSpecClipboard {
	GParamSpec parent_instance;
};

static gpointer spice_clipboard_parent_class = NULL;
static GdkAtom spice_clipboard_SPICE_ATOM;
static GdkAtom spice_clipboard_SPICE_ATOM = 0U;
static GObject* spice_clipboard_object_ref;
static GObject* spice_clipboard_object_ref = NULL;
static gchar* spice_clipboard_object_data;
static gchar* spice_clipboard_object_data = NULL;
static gboolean spice_clipboard_set_internally;
static gboolean spice_clipboard_set_internally = FALSE;

VALA_EXTERN gpointer spice_clipboard_ref (gpointer instance);
VALA_EXTERN void spice_clipboard_unref (gpointer instance);
VALA_EXTERN GParamSpec* spice_param_spec_clipboard (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void spice_value_set_clipboard (GValue* value,
                                gpointer v_object);
VALA_EXTERN void spice_value_take_clipboard (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer spice_value_get_clipboard (const GValue* value);
VALA_EXTERN GType spice_clipboard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceClipboard, spice_clipboard_unref)
static GType spice_clipboard_target_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN void spice_clipboard_set_with_data (GtkClipboard* clipboard,
                                    GtkSelectionData* selection_data,
                                    guint info,
                                    void* user_data_or_owner);
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN GType spice_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceTextItem, g_object_unref)
VALA_EXTERN gchar* spice_text_item_get_text (SpiceTextItem* self);
VALA_EXTERN GType spice_image_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageItem, g_object_unref)
VALA_EXTERN GType spice_image_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageHandler, g_object_unref)
VALA_EXTERN SpiceImageHandler* spice_image_item_get_image (SpiceImageItem* self);
VALA_EXTERN const gchar* spice_image_handler_get_url (SpiceImageHandler* self);
VALA_EXTERN void spice_clipboard_clear_data (GtkClipboard* clipboard,
                                 void* user_data_or_owner);
VALA_EXTERN GType spice_slide_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideManager, g_object_unref)
VALA_EXTERN void spice_clipboard_copy (SpiceSlideManager* manager,
                           GObject* object);
VALA_EXTERN SpiceCanvasItem* spice_slide_manager_get_current_item (SpiceSlideManager* self);
VALA_EXTERN gchar* spice_clipboard_clone (GObject* object);
static void _spice_clipboard_set_with_data_gtk_clipboard_get_func (GtkClipboard* clipboard,
                                                            GtkSelectionData* selection_data,
                                                            guint info,
                                                            void* user_data_or_owner);
static void _spice_clipboard_clear_data_gtk_clipboard_clear_func (GtkClipboard* clipboard,
                                                           void* user_data_or_owner);
VALA_EXTERN GType spice_slide_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlide, g_object_unref)
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN SpiceCanvasItem* spice_utils_canvas_item_from_data (JsonObject* data,
                                                    SpiceCanvas* canvas);
VALA_EXTERN JsonObject* spice_utils_get_json_object (const gchar* raw_json);
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType spice_canvas_canvas_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasCanvasGrid, g_object_unref)
VALA_EXTERN void spice_clipboard_paste (SpiceSlideManager* manager);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GdkAtom* _gdk_atom_dup (GdkAtom* self);
static void ___lambda72_ (Block1Data* _data1_,
                   GtkClipboard* c,
                   GtkSelectionData* raw_data);
VALA_EXTERN SpiceSlide* spice_slide_manager_new_slide (SpiceSlideManager* self,
                                           JsonObject* save_data,
                                           gboolean undoable_action);
VALA_EXTERN SpiceSlide* spice_slide_manager_get_current_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_add_item (SpiceSlide* self,
                           SpiceCanvasItem* item,
                           gboolean select_item,
                           gboolean save_history);
static void ____lambda72__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                GtkSelectionData* selection_data,
                                                gpointer self);
static void ____lambda73_ (Block1Data* _data1_,
                    GtkClipboard* c,
                    GtkSelectionData* raw_data);
VALA_EXTERN gchar* spice_utils_pixbuf_to_base64 (GdkPixbuf* pixbuf);
VALA_EXTERN SpiceImageItem* spice_image_item_new_from_data (SpiceCanvas* _canvas,
                                                const gchar* base64_image,
                                                const gchar* extension);
VALA_EXTERN SpiceImageItem* spice_image_item_construct_from_data (GType object_type,
                                                      SpiceCanvas* _canvas,
                                                      const gchar* base64_image,
                                                      const gchar* extension);
static void _____lambda73__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                 GtkSelectionData* selection_data,
                                                 gpointer self);
static void _____lambda74_ (Block1Data* _data1_,
                     GtkClipboard* c,
                     GtkSelectionData* raw_data);
VALA_EXTERN GType spice_canvas_item_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SpiceCanvasItem* spice_slide_manager_request_new_item (SpiceSlideManager* self,
                                                       SpiceCanvasItemType type);
VALA_EXTERN void spice_text_item_set_text (SpiceTextItem* self,
                               const gchar* value);
static void ______lambda74__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                  GtkSelectionData* selection_data,
                                                  gpointer self);
VALA_EXTERN SpiceWindow* spice_application_get_active_spice_window (void);
VALA_EXTERN void spice_window_add_toast_notification (SpiceWindow* self,
                                          GraniteWidgetsToast* toast);
VALA_EXTERN void spice_clipboard_cut (SpiceSlideManager* manager,
                          GObject* object);
VALA_EXTERN void spice_clipboard_delete (GObject* object);
VALA_EXTERN void spice_canvas_item_delete (SpiceCanvasItem* self);
VALA_EXTERN void spice_slide_delete (SpiceSlide* self);
VALA_EXTERN gchar* spice_canvas_item_serialise (SpiceCanvasItem* self);
VALA_EXTERN gchar* spice_slide_serialise (SpiceSlide* self);
VALA_EXTERN void spice_clipboard_duplicate (SpiceSlideManager* manager,
                                GObject* object);
VALA_EXTERN SpiceClipboard* spice_clipboard_new (void);
VALA_EXTERN SpiceClipboard* spice_clipboard_construct (GType object_type);
static void spice_clipboard_finalize (SpiceClipboard * obj);
static GType spice_clipboard_get_type_once (void);

static const GtkTargetEntry SPICE_CLIPBOARD_text_target_list[3] = {{"text/plain", (guint) 0, (guint) SPICE_CLIPBOARD_TARGET_STRING}, {"STRING", (guint) 0, (guint) SPICE_CLIPBOARD_TARGET_STRING}, {SPICE_CLIPBOARD_SPICE_UP_TARGET_NAME, (guint) 0, (guint) SPICE_CLIPBOARD_TARGET_SPICE}};
static const GtkTargetEntry SPICE_CLIPBOARD_image_target_list[2] = {{"image/png", (guint) 0, (guint) SPICE_CLIPBOARD_TARGET_IMAGE}, {SPICE_CLIPBOARD_SPICE_UP_TARGET_NAME, (guint) 0, (guint) SPICE_CLIPBOARD_TARGET_SPICE}};
static const GtkTargetEntry SPICE_CLIPBOARD_spice_target_list[1] = {{SPICE_CLIPBOARD_SPICE_UP_TARGET_NAME, (guint) 0, (guint) SPICE_CLIPBOARD_TARGET_SPICE}};

static GType
spice_clipboard_target_get_type_once (void)
{
	static const GEnumValue values[] = {{SPICE_CLIPBOARD_TARGET_STRING, "SPICE_CLIPBOARD_TARGET_STRING", "string"}, {SPICE_CLIPBOARD_TARGET_IMAGE, "SPICE_CLIPBOARD_TARGET_IMAGE", "image"}, {SPICE_CLIPBOARD_TARGET_SPICE, "SPICE_CLIPBOARD_TARGET_SPICE", "spice"}, {0, NULL, NULL}};
	GType spice_clipboard_target_type_id;
	spice_clipboard_target_type_id = g_enum_register_static ("SpiceClipboardTarget", values);
	return spice_clipboard_target_type_id;
}

static GType
spice_clipboard_target_get_type (void)
{
	static volatile gsize spice_clipboard_target_type_id__once = 0;
	if (g_once_init_enter (&spice_clipboard_target_type_id__once)) {
		GType spice_clipboard_target_type_id;
		spice_clipboard_target_type_id = spice_clipboard_target_get_type_once ();
		g_once_init_leave (&spice_clipboard_target_type_id__once, spice_clipboard_target_type_id);
	}
	return spice_clipboard_target_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 62 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return self ? g_object_ref (self) : NULL;
#line 423 "Clipboard.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1609 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1610 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1610 "glib-2.0.vapi"
	res_length1 = -1;
#line 1610 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1611 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1611 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1611 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1612 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1612 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1612 "glib-2.0.vapi"
	if (result_length1) {
#line 1612 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 460 "Clipboard.c"
	}
#line 1612 "glib-2.0.vapi"
	result = _tmp2_;
#line 1612 "glib-2.0.vapi"
	return result;
#line 466 "Clipboard.c"
}

void
spice_clipboard_set_with_data (GtkClipboard* clipboard,
                               GtkSelectionData* selection_data,
                               guint info,
                               void* user_data_or_owner)
{
	GError* _inner_error0_ = NULL;
#line 51 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (clipboard != NULL);
#line 51 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (selection_data != NULL);
#line 52 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	switch (info) {
#line 52 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		case SPICE_CLIPBOARD_TARGET_STRING:
#line 484 "Clipboard.c"
		{
			GObject* _tmp0_;
#line 54 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			g_debug ("Clipboard.vala:54: String requested\n");
#line 55 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp0_ = spice_clipboard_object_ref;
#line 55 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			if (SPICE_IS_TEXT_ITEM (_tmp0_)) {
#line 493 "Clipboard.c"
				GObject* _tmp1_;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
#line 56 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp1_ = spice_clipboard_object_ref;
#line 56 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp2_ = spice_text_item_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SPICE_TYPE_TEXT_ITEM, SpiceTextItem));
#line 56 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp3_ = _tmp2_;
#line 56 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp4_ = _tmp3_;
#line 56 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				gtk_selection_data_set_text (selection_data, _tmp4_, -1);
#line 56 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_g_free0 (_tmp4_);
#line 510 "Clipboard.c"
			}
#line 58 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			break;
#line 514 "Clipboard.c"
		}
#line 52 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		case SPICE_CLIPBOARD_TARGET_IMAGE:
#line 518 "Clipboard.c"
		{
			GObject* _tmp5_;
#line 60 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			g_debug ("Clipboard.vala:60: Image requested\n");
#line 61 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp5_ = spice_clipboard_object_ref;
#line 61 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			if (SPICE_IS_IMAGE_ITEM (_tmp5_)) {
#line 527 "Clipboard.c"
				SpiceImageItem* image_item = NULL;
				GObject* _tmp6_;
				SpiceImageItem* _tmp7_;
				GdkPixbuf* pixbuf = NULL;
				SpiceImageItem* _tmp8_;
				SpiceImageHandler* _tmp9_;
				SpiceImageHandler* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				GdkPixbuf* _tmp13_;
				GdkPixbuf* _tmp14_;
#line 62 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp6_ = spice_clipboard_object_ref;
#line 62 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SPICE_TYPE_IMAGE_ITEM, SpiceImageItem));
#line 62 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				image_item = _tmp7_;
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp8_ = image_item;
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp9_ = spice_image_item_get_image (_tmp8_);
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp10_ = _tmp9_;
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp11_ = spice_image_handler_get_url (_tmp10_);
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp12_ = _tmp11_;
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp13_ = gdk_pixbuf_new_from_file (_tmp12_, &_inner_error0_);
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				pixbuf = _tmp13_;
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					_g_object_unref0 (image_item);
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					g_clear_error (&_inner_error0_);
#line 63 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					return;
#line 569 "Clipboard.c"
				}
#line 64 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp14_ = pixbuf;
#line 64 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				gtk_selection_data_set_pixbuf (selection_data, _tmp14_);
#line 61 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_g_object_unref0 (pixbuf);
#line 61 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_g_object_unref0 (image_item);
#line 579 "Clipboard.c"
			} else {
				GObject* _tmp15_;
#line 65 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp15_ = spice_clipboard_object_ref;
#line 65 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gdk_pixbuf_get_type ())) {
#line 586 "Clipboard.c"
					GdkPixbuf* pixbuf = NULL;
					GObject* _tmp16_;
					GdkPixbuf* _tmp17_;
					GdkPixbuf* _tmp18_;
#line 66 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					_tmp16_ = spice_clipboard_object_ref;
#line 66 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gdk_pixbuf_get_type (), GdkPixbuf));
#line 66 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					pixbuf = _tmp17_;
#line 67 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					_tmp18_ = pixbuf;
#line 67 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					gtk_selection_data_set_pixbuf (selection_data, _tmp18_);
#line 65 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					_g_object_unref0 (pixbuf);
#line 603 "Clipboard.c"
				}
			}
#line 69 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			break;
#line 608 "Clipboard.c"
		}
#line 52 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		case SPICE_CLIPBOARD_TARGET_SPICE:
#line 612 "Clipboard.c"
		{
			const gchar* _tmp19_;
			guint8* _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_ = 0;
			guint8* _tmp22_;
			gint _tmp22__length1;
#line 71 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			g_debug ("Clipboard.vala:71: Spice object requested\n");
#line 72 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp19_ = spice_clipboard_object_data;
#line 72 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp20_ = string_get_data (_tmp19_, &_tmp21_);
#line 72 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp20__length1 = _tmp21_;
#line 72 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp22_ = _tmp20_;
#line 72 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp22__length1 = _tmp20__length1;
#line 72 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			gtk_selection_data_set (selection_data, spice_clipboard_SPICE_ATOM, 0, _tmp22_, (gint) _tmp22__length1);
#line 73 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			break;
#line 636 "Clipboard.c"
		}
		default:
		{
#line 75 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			g_debug ("Clipboard.vala:75: Other data %u\n", info);
#line 75 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			break;
#line 644 "Clipboard.c"
		}
	}
}

void
spice_clipboard_clear_data (GtkClipboard* clipboard,
                            void* user_data_or_owner)
{
#line 79 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (clipboard != NULL);
#line 80 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (!spice_clipboard_set_internally) {
#line 81 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (spice_clipboard_object_ref);
#line 81 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_clipboard_object_ref = NULL;
#line 82 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (spice_clipboard_object_data);
#line 82 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_clipboard_object_data = NULL;
#line 665 "Clipboard.c"
	}
#line 85 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_set_internally = FALSE;
#line 669 "Clipboard.c"
}

static void
_spice_clipboard_set_with_data_gtk_clipboard_get_func (GtkClipboard* clipboard,
                                                       GtkSelectionData* selection_data,
                                                       guint info,
                                                       void* user_data_or_owner)
{
#line 108 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_set_with_data (clipboard, selection_data, info, user_data_or_owner);
#line 680 "Clipboard.c"
}

static void
_spice_clipboard_clear_data_gtk_clipboard_clear_func (GtkClipboard* clipboard,
                                                      void* user_data_or_owner)
{
#line 108 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_clear_data (clipboard, user_data_or_owner);
#line 689 "Clipboard.c"
}

void
spice_clipboard_copy (SpiceSlideManager* manager,
                      GObject* object)
{
	gboolean _tmp0_ = FALSE;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp9_;
	GtkClipboard* _tmp10_;
	GtkClipboard* _tmp11_;
	gchar* _tmp12_;
#line 88 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (manager != NULL);
#line 88 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (object != NULL);
#line 89 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (object == NULL) {
#line 89 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 712 "Clipboard.c"
	}
#line 92 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp1_ = spice_slide_manager_get_current_item (manager);
#line 92 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp2_ = _tmp1_;
#line 92 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (object == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject)) {
#line 92 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp0_ = SPICE_IS_TEXT_ITEM (object);
#line 722 "Clipboard.c"
	} else {
#line 92 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp0_ = FALSE;
#line 726 "Clipboard.c"
	}
#line 92 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp0_) {
#line 730 "Clipboard.c"
		GtkTextView* text_entry = NULL;
		GtkTextView* _tmp3_;
		GtkTextView* _tmp4_;
		GtkTextView* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* _tmp7_;
#line 93 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_TEXT_ITEM, SpiceTextItem)->entry;
#line 93 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 93 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		text_entry = _tmp4_;
#line 94 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp5_ = text_entry;
#line 94 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
#line 94 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp7_ = _tmp6_;
#line 94 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (gtk_text_buffer_get_has_selection (_tmp7_)) {
#line 751 "Clipboard.c"
			GtkTextView* _tmp8_;
#line 95 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp8_ = text_entry;
#line 95 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			g_signal_emit_by_name (_tmp8_, "copy-clipboard");
#line 96 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_g_object_unref0 (text_entry);
#line 96 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			return;
#line 761 "Clipboard.c"
		}
#line 92 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (text_entry);
#line 765 "Clipboard.c"
	}
#line 100 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_set_internally = TRUE;
#line 102 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp9_ = gdk_display_get_default ();
#line 102 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp10_ = gtk_clipboard_get_default (_tmp9_);
#line 102 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 102 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	clipboard = _tmp11_;
#line 104 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp12_ = spice_clipboard_clone (object);
#line 104 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (spice_clipboard_object_data);
#line 104 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_object_data = _tmp12_;
#line 106 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (SPICE_IS_TEXT_ITEM (object)) {
#line 785 "Clipboard.c"
		GtkClipboard* _tmp13_;
#line 107 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_debug ("Clipboard.vala:107: set text target list");
#line 108 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp13_ = clipboard;
#line 108 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		gtk_clipboard_set_with_data (_tmp13_, SPICE_CLIPBOARD_text_target_list, (guint) G_N_ELEMENTS (SPICE_CLIPBOARD_text_target_list), _spice_clipboard_set_with_data_gtk_clipboard_get_func, _spice_clipboard_clear_data_gtk_clipboard_clear_func, NULL);
#line 793 "Clipboard.c"
	} else {
		gboolean _tmp14_ = FALSE;
#line 109 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (SPICE_IS_IMAGE_ITEM (object)) {
#line 109 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp14_ = TRUE;
#line 800 "Clipboard.c"
		} else {
#line 109 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp14_ = SPICE_IS_SLIDE (object);
#line 804 "Clipboard.c"
		}
#line 109 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (_tmp14_) {
#line 808 "Clipboard.c"
			GtkClipboard* _tmp15_;
#line 110 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			g_debug ("Clipboard.vala:110: set image target list");
#line 111 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp15_ = clipboard;
#line 111 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			gtk_clipboard_set_with_data (_tmp15_, SPICE_CLIPBOARD_image_target_list, (guint) G_N_ELEMENTS (SPICE_CLIPBOARD_image_target_list), _spice_clipboard_set_with_data_gtk_clipboard_get_func, _spice_clipboard_clear_data_gtk_clipboard_clear_func, NULL);
#line 816 "Clipboard.c"
		} else {
			GtkClipboard* _tmp16_;
#line 113 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp16_ = clipboard;
#line 113 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			gtk_clipboard_set_with_data (_tmp16_, SPICE_CLIPBOARD_spice_target_list, (guint) G_N_ELEMENTS (SPICE_CLIPBOARD_spice_target_list), _spice_clipboard_set_with_data_gtk_clipboard_get_func, _spice_clipboard_clear_data_gtk_clipboard_clear_func, NULL);
#line 823 "Clipboard.c"
		}
	}
#line 116 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (SPICE_IS_CANVAS_ITEM (object)) {
#line 828 "Clipboard.c"
		const gchar* _tmp17_;
		JsonObject* _tmp18_;
		JsonObject* _tmp19_;
		SpiceCanvasItem* _tmp20_;
#line 117 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp17_ = spice_clipboard_object_data;
#line 117 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp18_ = spice_utils_get_json_object (_tmp17_);
#line 117 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp19_ = _tmp18_;
#line 117 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp20_ = spice_utils_canvas_item_from_data (_tmp19_, NULL);
#line 117 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (spice_clipboard_object_ref);
#line 117 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_clipboard_object_ref = (GObject*) _tmp20_;
#line 117 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_json_object_unref0 (_tmp19_);
#line 847 "Clipboard.c"
	} else {
#line 118 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (SPICE_IS_SLIDE (object)) {
#line 851 "Clipboard.c"
			SpiceCanvas* _tmp21_;
			GraniteDrawingBufferSurface* _tmp22_;
			GdkPixbuf* _tmp23_;
#line 119 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_SLIDE, SpiceSlide)->canvas;
#line 119 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp22_ = _tmp21_->surface;
#line 119 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp23_ = granite_drawing_buffer_surface_load_to_pixbuf (_tmp22_);
#line 119 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_g_object_unref0 (spice_clipboard_object_ref);
#line 119 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			spice_clipboard_object_ref = (GObject*) _tmp23_;
#line 865 "Clipboard.c"
		}
	}
#line 88 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_object_unref0 (clipboard);
#line 870 "Clipboard.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return _data1_;
#line 880 "Clipboard.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (_data1_->manager);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_slice_free (Block1Data, _data1_);
#line 894 "Clipboard.c"
	}
}

static GdkAtom*
_gdk_atom_dup (GdkAtom* self)
{
	GdkAtom* dup;
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	dup = g_new0 (GdkAtom, 1);
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	memcpy (dup, self, sizeof (GdkAtom));
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return dup;
#line 908 "Clipboard.c"
}

static gpointer
__gdk_atom_dup0 (gpointer self)
{
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return self ? _gdk_atom_dup (self) : NULL;
#line 916 "Clipboard.c"
}

static void
___lambda72_ (Block1Data* _data1_,
              GtkClipboard* c,
              GtkSelectionData* raw_data)
{
	gchar* data = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	JsonObject* root_object = NULL;
	const gchar* _tmp3_;
	JsonObject* _tmp4_;
	JsonObject* _tmp5_;
	JsonObject* _tmp6_;
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (c != NULL);
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (raw_data != NULL);
#line 150 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp0_ = gtk_selection_data_get_data (raw_data);
#line 150 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
#line 150 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	data = _tmp1_;
#line 151 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp2_ = data;
#line 151 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp2_ == NULL) {
#line 151 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (data);
#line 151 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 951 "Clipboard.c"
	}
#line 153 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp3_ = data;
#line 153 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp4_ = spice_utils_get_json_object (_tmp3_);
#line 153 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	root_object = _tmp4_;
#line 154 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp5_ = root_object;
#line 154 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp5_ == NULL) {
#line 154 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_json_object_unref0 (root_object);
#line 154 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (data);
#line 154 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 969 "Clipboard.c"
	}
#line 156 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp6_ = root_object;
#line 156 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (json_object_has_member (_tmp6_, "preview")) {
#line 975 "Clipboard.c"
		JsonObject* _tmp7_;
		SpiceSlide* _tmp8_;
		SpiceSlide* _tmp9_;
#line 157 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp7_ = root_object;
#line 157 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp8_ = spice_slide_manager_new_slide (_data1_->manager, _tmp7_, TRUE);
#line 157 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp9_ = _tmp8_;
#line 157 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (_tmp9_);
#line 987 "Clipboard.c"
	} else {
		SpiceCanvasItem* item = NULL;
		JsonObject* _tmp10_;
		SpiceSlide* _tmp11_;
		SpiceSlide* _tmp12_;
		SpiceCanvas* _tmp13_;
		SpiceCanvasItem* _tmp14_;
		SpiceSlide* _tmp15_;
		SpiceSlide* _tmp16_;
		SpiceCanvasItem* _tmp17_;
#line 159 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp10_ = root_object;
#line 159 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp11_ = spice_slide_manager_get_current_slide (_data1_->manager);
#line 159 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp12_ = _tmp11_;
#line 159 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp13_ = _tmp12_->canvas;
#line 159 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp14_ = spice_utils_canvas_item_from_data (_tmp10_, _tmp13_);
#line 159 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		item = _tmp14_;
#line 160 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp15_ = spice_slide_manager_get_current_slide (_data1_->manager);
#line 160 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp16_ = _tmp15_;
#line 160 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp17_ = item;
#line 160 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_slide_add_item (_tmp16_, _tmp17_, TRUE, TRUE);
#line 156 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (item);
#line 1020 "Clipboard.c"
	}
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_json_object_unref0 (root_object);
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (data);
#line 1026 "Clipboard.c"
}

static void
____lambda72__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                           GtkSelectionData* selection_data,
                                           gpointer self)
{
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	___lambda72_ (self, clipboard, selection_data);
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	block1_data_unref (self);
#line 1038 "Clipboard.c"
}

static void
____lambda73_ (Block1Data* _data1_,
               GtkClipboard* c,
               GtkSelectionData* raw_data)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	gchar* data = NULL;
	GdkPixbuf* _tmp2_;
	gchar* _tmp3_;
	SpiceImageItem* item = NULL;
	SpiceSlide* _tmp4_;
	SpiceSlide* _tmp5_;
	SpiceCanvas* _tmp6_;
	const gchar* _tmp7_;
	SpiceImageItem* _tmp8_;
	SpiceSlide* _tmp9_;
	SpiceSlide* _tmp10_;
	SpiceImageItem* _tmp11_;
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (c != NULL);
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (raw_data != NULL);
#line 166 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_debug ("Clipboard.vala:166: Getting image data");
#line 167 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp0_ = gtk_selection_data_get_pixbuf (raw_data);
#line 167 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	pixbuf = _tmp0_;
#line 168 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp1_ = pixbuf;
#line 168 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp1_ == NULL) {
#line 168 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (pixbuf);
#line 168 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1079 "Clipboard.c"
	}
#line 170 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp2_ = pixbuf;
#line 170 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp3_ = spice_utils_pixbuf_to_base64 (_tmp2_);
#line 170 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	data = _tmp3_;
#line 172 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp4_ = spice_slide_manager_get_current_slide (_data1_->manager);
#line 172 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp5_ = _tmp4_;
#line 172 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp6_ = _tmp5_->canvas;
#line 172 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp7_ = data;
#line 172 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp8_ = spice_image_item_new_from_data (_tmp6_, _tmp7_, "png");
#line 172 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_object_ref_sink (_tmp8_);
#line 172 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	item = _tmp8_;
#line 173 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp9_ = spice_slide_manager_get_current_slide (_data1_->manager);
#line 173 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp10_ = _tmp9_;
#line 173 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp11_ = item;
#line 173 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_slide_add_item (_tmp10_, (SpiceCanvasItem*) _tmp11_, TRUE, TRUE);
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_object_unref0 (item);
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (data);
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_object_unref0 (pixbuf);
#line 1115 "Clipboard.c"
}

static void
_____lambda73__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                            GtkSelectionData* selection_data,
                                            gpointer self)
{
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	____lambda73_ (self, clipboard, selection_data);
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	block1_data_unref (self);
#line 1127 "Clipboard.c"
}

static void
_____lambda74_ (Block1Data* _data1_,
                GtkClipboard* c,
                GtkSelectionData* raw_data)
{
	gchar* data = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	SpiceTextItem* item = NULL;
	SpiceCanvasItem* _tmp3_;
	SpiceTextItem* _tmp4_;
	const gchar* _tmp5_;
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (c != NULL);
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (raw_data != NULL);
#line 177 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_debug ("Clipboard.vala:177: Getting text data");
#line 178 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp0_ = gtk_selection_data_get_data (raw_data);
#line 178 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
#line 178 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	data = _tmp1_;
#line 179 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp2_ = data;
#line 179 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp2_ == NULL) {
#line 179 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (data);
#line 179 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1163 "Clipboard.c"
	}
#line 181 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp3_ = spice_slide_manager_request_new_item (_data1_->manager, SPICE_CANVAS_ITEM_TYPE_TEXT);
#line 181 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	item = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SPICE_TYPE_TEXT_ITEM, SpiceTextItem);
#line 182 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp4_ = item;
#line 182 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp5_ = data;
#line 182 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_text_item_set_text (_tmp4_, _tmp5_);
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_object_unref0 (item);
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (data);
#line 1179 "Clipboard.c"
}

static void
______lambda74__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                             GtkSelectionData* selection_data,
                                             gpointer self)
{
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_____lambda74_ (self, clipboard, selection_data);
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	block1_data_unref (self);
#line 1191 "Clipboard.c"
}

void
spice_clipboard_paste (SpiceSlideManager* manager)
{
	Block1Data* _data1_;
	SpiceSlideManager* _tmp0_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	GdkAtom* targets = NULL;
	gint targets_length1 = 0;
	gint _targets_size_ = 0;
	GtkClipboard* _tmp4_;
	GdkAtom* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GdkAtom* spice_atom = NULL;
	GdkAtom* text_atom = NULL;
	GdkAtom* image_atom = NULL;
	GdkAtom* _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	GdkAtom* _tmp19_;
	GdkAtom* _tmp26_;
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (manager != NULL);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_data1_->_ref_count_ = 1;
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp0_ = _g_object_ref0 (manager);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_object_unref0 (_data1_->manager);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_data1_->manager = _tmp0_;
#line 124 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp1_ = gdk_display_get_default ();
#line 124 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp2_ = gtk_clipboard_get_default (_tmp1_);
#line 124 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 124 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	clipboard = _tmp3_;
#line 127 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp4_ = clipboard;
#line 127 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	gtk_clipboard_wait_for_targets (_tmp4_, &_tmp5_, &_tmp6_);
#line 127 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	targets = (g_free (targets), NULL);
#line 127 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	targets = _tmp5_;
#line 127 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	targets_length1 = _tmp6_;
#line 127 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_targets_size_ = targets_length1;
#line 129 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_atom = NULL;
#line 130 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	text_atom = NULL;
#line 131 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	image_atom = NULL;
#line 133 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp7_ = targets;
#line 133 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp7__length1 = targets_length1;
#line 1260 "Clipboard.c"
	{
		GdkAtom* target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
#line 133 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		target_collection = _tmp7_;
#line 133 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		target_collection_length1 = _tmp7__length1;
#line 133 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
#line 1272 "Clipboard.c"
			GdkAtom target = (GdkAtom) 0U;
#line 133 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			target = target_collection[target_it];
#line 1276 "Clipboard.c"
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GQuark _tmp13_ = 0U;
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				static GQuark _tmp12_label0 = 0;
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				static GQuark _tmp12_label1 = 0;
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				static GQuark _tmp12_label2 = 0;
#line 134 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp8_ = gdk_atom_name (target);
#line 134 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp9_ = _tmp8_;
#line 134 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				g_debug ("Clipboard.vala:134: %s\n", _tmp9_);
#line 134 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_g_free0 (_tmp9_);
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp10_ = gdk_atom_name (target);
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp11_ = _tmp10_;
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				g_free (_tmp11_);
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string (SPICE_CLIPBOARD_SPICE_UP_TARGET_NAME)))) {
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					switch (0) {
#line 1309 "Clipboard.c"
						default:
						{
							GdkAtom* _tmp14_;
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							_tmp14_ = __gdk_atom_dup0 (&target);
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							_g_free0 (spice_atom);
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							spice_atom = _tmp14_;
#line 136 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							break;
#line 1321 "Clipboard.c"
						}
					}
				} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("text/plain")))) {
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					switch (0) {
#line 1327 "Clipboard.c"
						default:
						{
							GdkAtom* _tmp15_;
#line 137 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							_tmp15_ = __gdk_atom_dup0 (&target);
#line 137 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							_g_free0 (text_atom);
#line 137 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							text_atom = _tmp15_;
#line 137 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							break;
#line 1339 "Clipboard.c"
						}
					}
				} else if (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("image/png")))) {
#line 135 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
					switch (0) {
#line 1345 "Clipboard.c"
						default:
						{
							GdkAtom* _tmp16_;
#line 138 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							_tmp16_ = __gdk_atom_dup0 (&target);
#line 138 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							_g_free0 (image_atom);
#line 138 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							image_atom = _tmp16_;
#line 138 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
							break;
#line 1357 "Clipboard.c"
						}
					}
				}
			}
		}
	}
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp19_ = text_atom;
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp19_ != NULL) {
#line 1368 "Clipboard.c"
		GdkAtom* _tmp20_;
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp20_ = image_atom;
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp18_ = _tmp20_ == NULL;
#line 1374 "Clipboard.c"
	} else {
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp18_ = FALSE;
#line 1378 "Clipboard.c"
	}
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp18_) {
#line 1382 "Clipboard.c"
		SpiceCanvasItem* _tmp21_;
		SpiceCanvasItem* _tmp22_;
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp21_ = spice_slide_manager_get_current_item (_data1_->manager);
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp22_ = _tmp21_;
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp17_ = SPICE_IS_TEXT_ITEM (_tmp22_);
#line 1391 "Clipboard.c"
	} else {
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp17_ = FALSE;
#line 1395 "Clipboard.c"
	}
#line 143 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp17_) {
#line 1399 "Clipboard.c"
		SpiceCanvasItem* _tmp23_;
		SpiceCanvasItem* _tmp24_;
		GtkTextView* _tmp25_;
#line 144 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp23_ = spice_slide_manager_get_current_item (_data1_->manager);
#line 144 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp24_ = _tmp23_;
#line 144 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, SPICE_TYPE_TEXT_ITEM, SpiceTextItem)->entry;
#line 144 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_signal_emit_by_name (_tmp25_, "paste-clipboard");
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (image_atom);
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (text_atom);
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (spice_atom);
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		targets = (g_free (targets), NULL);
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (clipboard);
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		block1_data_unref (_data1_);
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_data1_ = NULL;
#line 145 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1427 "Clipboard.c"
	}
#line 148 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp26_ = spice_atom;
#line 148 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp26_ != NULL) {
#line 1433 "Clipboard.c"
		GtkClipboard* _tmp27_;
		GdkAtom* _tmp28_;
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp27_ = clipboard;
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp28_ = spice_atom;
#line 149 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		gtk_clipboard_request_contents (_tmp27_, *_tmp28_, ____lambda72__gtk_clipboard_received_func, block1_data_ref (_data1_));
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (image_atom);
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (text_atom);
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (spice_atom);
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		targets = (g_free (targets), NULL);
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (clipboard);
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		block1_data_unref (_data1_);
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_data1_ = NULL;
#line 163 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1458 "Clipboard.c"
	} else {
		GdkAtom* _tmp29_;
#line 164 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp29_ = image_atom;
#line 164 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (_tmp29_ != NULL) {
#line 1465 "Clipboard.c"
			GtkClipboard* _tmp30_;
			GdkAtom* _tmp31_;
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp30_ = clipboard;
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp31_ = image_atom;
#line 165 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			gtk_clipboard_request_contents (_tmp30_, *_tmp31_, _____lambda73__gtk_clipboard_received_func, block1_data_ref (_data1_));
#line 1474 "Clipboard.c"
		} else {
			GdkAtom* _tmp32_;
#line 175 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp32_ = text_atom;
#line 175 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			if (_tmp32_ != NULL) {
#line 1481 "Clipboard.c"
				GtkClipboard* _tmp33_;
				GdkAtom* _tmp34_;
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp33_ = clipboard;
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp34_ = text_atom;
#line 176 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				gtk_clipboard_request_contents (_tmp33_, *_tmp34_, ______lambda74__gtk_clipboard_received_func, block1_data_ref (_data1_));
#line 1490 "Clipboard.c"
			} else {
				SpiceWindow* _tmp35_;
				GraniteWidgetsToast* _tmp36_;
				GraniteWidgetsToast* _tmp37_;
#line 186 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp35_ = spice_application_get_active_spice_window ();
#line 186 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp36_ = granite_widgets_toast_new (_ ("Unknown clipboard data"));
#line 186 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				g_object_ref_sink (_tmp36_);
#line 186 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_tmp37_ = _tmp36_;
#line 186 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				spice_window_add_toast_notification (_tmp35_, _tmp37_);
#line 186 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
				_g_object_unref0 (_tmp37_);
#line 1507 "Clipboard.c"
			}
		}
	}
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (image_atom);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (text_atom);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (spice_atom);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	targets = (g_free (targets), NULL);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_object_unref0 (clipboard);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	block1_data_unref (_data1_);
#line 123 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_data1_ = NULL;
#line 1525 "Clipboard.c"
}

void
spice_clipboard_cut (SpiceSlideManager* manager,
                     GObject* object)
{
	gboolean _tmp0_ = FALSE;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
#line 190 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (manager != NULL);
#line 190 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (object != NULL);
#line 191 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (object == NULL) {
#line 191 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1543 "Clipboard.c"
	}
#line 193 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp1_ = spice_slide_manager_get_current_item (manager);
#line 193 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp2_ = _tmp1_;
#line 193 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (object == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject)) {
#line 193 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp0_ = SPICE_IS_TEXT_ITEM (object);
#line 1553 "Clipboard.c"
	} else {
#line 193 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp0_ = FALSE;
#line 1557 "Clipboard.c"
	}
#line 193 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp0_) {
#line 1561 "Clipboard.c"
		GtkTextView* text_entry = NULL;
		GtkTextView* _tmp3_;
		GtkTextView* _tmp4_;
		GtkTextView* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* _tmp7_;
#line 194 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_TEXT_ITEM, SpiceTextItem)->entry;
#line 194 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 194 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		text_entry = _tmp4_;
#line 195 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp5_ = text_entry;
#line 195 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
#line 195 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp7_ = _tmp6_;
#line 195 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (gtk_text_buffer_get_has_selection (_tmp7_)) {
#line 1582 "Clipboard.c"
			GtkTextView* _tmp8_;
#line 196 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp8_ = text_entry;
#line 196 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			g_signal_emit_by_name (_tmp8_, "cut-clipboard");
#line 197 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_g_object_unref0 (text_entry);
#line 197 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			return;
#line 1592 "Clipboard.c"
		}
#line 193 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (text_entry);
#line 1596 "Clipboard.c"
	}
#line 201 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_copy (manager, object);
#line 203 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_delete (object);
#line 1602 "Clipboard.c"
}

void
spice_clipboard_delete (GObject* object)
{
#line 206 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (object != NULL);
#line 207 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (object == NULL) {
#line 207 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1614 "Clipboard.c"
	}
#line 209 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (SPICE_IS_CANVAS_ITEM (object)) {
#line 210 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_canvas_item_delete (G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 1620 "Clipboard.c"
	} else {
#line 211 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (SPICE_IS_SLIDE (object)) {
#line 212 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			spice_slide_delete (G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_SLIDE, SpiceSlide));
#line 1626 "Clipboard.c"
		}
	}
}

gchar*
spice_clipboard_clone (GObject* object)
{
	gchar* result;
#line 216 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_val_if_fail (object != NULL, NULL);
#line 217 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (object == NULL) {
#line 1639 "Clipboard.c"
		gchar* _tmp0_;
#line 217 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp0_ = g_strdup ("");
#line 217 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		result = _tmp0_;
#line 217 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return result;
#line 1647 "Clipboard.c"
	}
#line 219 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (SPICE_IS_CANVAS_ITEM (object)) {
#line 1651 "Clipboard.c"
		gchar* _tmp1_;
#line 220 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp1_ = spice_canvas_item_serialise (G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 220 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		result = _tmp1_;
#line 220 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return result;
#line 1659 "Clipboard.c"
	} else {
#line 221 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (SPICE_IS_SLIDE (object)) {
#line 1663 "Clipboard.c"
			gchar* _tmp2_;
#line 222 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp2_ = spice_slide_serialise (G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_SLIDE, SpiceSlide));
#line 222 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			result = _tmp2_;
#line 222 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			return result;
#line 1671 "Clipboard.c"
		} else {
			gchar* _tmp3_;
#line 224 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			_tmp3_ = g_strdup ("");
#line 224 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			result = _tmp3_;
#line 224 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			return result;
#line 1680 "Clipboard.c"
		}
	}
}

void
spice_clipboard_duplicate (SpiceSlideManager* manager,
                           GObject* object)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	JsonObject* root_object = NULL;
	const gchar* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
#line 228 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (manager != NULL);
#line 228 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (object != NULL);
#line 229 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (object == NULL) {
#line 229 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1703 "Clipboard.c"
	}
#line 231 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp0_ = spice_clipboard_clone (object);
#line 231 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	data = _tmp0_;
#line 233 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp1_ = data;
#line 233 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp2_ = spice_utils_get_json_object (_tmp1_);
#line 233 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	root_object = _tmp2_;
#line 234 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_tmp3_ = root_object;
#line 234 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (_tmp3_ == NULL) {
#line 234 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_json_object_unref0 (root_object);
#line 234 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_free0 (data);
#line 234 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return;
#line 1725 "Clipboard.c"
	}
#line 236 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (SPICE_IS_CANVAS_ITEM (object)) {
#line 1729 "Clipboard.c"
		SpiceCanvasItem* item = NULL;
		JsonObject* _tmp4_;
		SpiceSlide* _tmp5_;
		SpiceSlide* _tmp6_;
		SpiceCanvas* _tmp7_;
		SpiceCanvasItem* _tmp8_;
		SpiceSlide* _tmp9_;
		SpiceSlide* _tmp10_;
		SpiceCanvasItem* _tmp11_;
#line 237 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp4_ = root_object;
#line 237 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp5_ = spice_slide_manager_get_current_slide (manager);
#line 237 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp6_ = _tmp5_;
#line 237 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp7_ = _tmp6_->canvas;
#line 237 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp8_ = spice_utils_canvas_item_from_data (_tmp4_, _tmp7_);
#line 237 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		item = _tmp8_;
#line 238 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp9_ = spice_slide_manager_get_current_slide (manager);
#line 238 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp10_ = _tmp9_;
#line 238 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp11_ = item;
#line 238 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_slide_add_item (_tmp10_, _tmp11_, TRUE, TRUE);
#line 236 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (item);
#line 1761 "Clipboard.c"
	} else {
		JsonObject* _tmp12_;
		SpiceSlide* _tmp13_;
		SpiceSlide* _tmp14_;
#line 240 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp12_ = root_object;
#line 240 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp13_ = spice_slide_manager_new_slide (manager, _tmp12_, TRUE);
#line 240 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_tmp14_ = _tmp13_;
#line 240 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		_g_object_unref0 (_tmp14_);
#line 1774 "Clipboard.c"
	}
#line 228 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_json_object_unref0 (root_object);
#line 228 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	_g_free0 (data);
#line 1780 "Clipboard.c"
}

SpiceClipboard*
spice_clipboard_construct (GType object_type)
{
	SpiceClipboard* self = NULL;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	self = (SpiceClipboard*) g_type_create_instance (object_type);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return self;
#line 1791 "Clipboard.c"
}

SpiceClipboard*
spice_clipboard_new (void)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return spice_clipboard_construct (SPICE_TYPE_CLIPBOARD);
#line 1799 "Clipboard.c"
}

static void
spice_value_clipboard_init (GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	value->data[0].v_pointer = NULL;
#line 1807 "Clipboard.c"
}

static void
spice_value_clipboard_free_value (GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_clipboard_unref (value->data[0].v_pointer);
#line 1817 "Clipboard.c"
	}
}

static void
spice_value_clipboard_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		dest_value->data[0].v_pointer = spice_clipboard_ref (src_value->data[0].v_pointer);
#line 1829 "Clipboard.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1833 "Clipboard.c"
	}
}

static gpointer
spice_value_clipboard_peek_pointer (const GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return value->data[0].v_pointer;
#line 1842 "Clipboard.c"
}

static gchar*
spice_value_clipboard_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (collect_values[0].v_pointer) {
#line 1853 "Clipboard.c"
		SpiceClipboard * object;
		object = collect_values[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1860 "Clipboard.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1864 "Clipboard.c"
		}
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		value->data[0].v_pointer = spice_clipboard_ref (object);
#line 1868 "Clipboard.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		value->data[0].v_pointer = NULL;
#line 1872 "Clipboard.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return NULL;
#line 1876 "Clipboard.c"
}

static gchar*
spice_value_clipboard_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	SpiceClipboard ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (!object_p) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1891 "Clipboard.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		*object_p = NULL;
#line 1897 "Clipboard.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		*object_p = value->data[0].v_pointer;
#line 1901 "Clipboard.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		*object_p = spice_clipboard_ref (value->data[0].v_pointer);
#line 1905 "Clipboard.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return NULL;
#line 1909 "Clipboard.c"
}

GParamSpec*
spice_param_spec_clipboard (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	SpiceParamSpecClipboard* spec;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SPICE_TYPE_CLIPBOARD), NULL);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return G_PARAM_SPEC (spec);
#line 1928 "Clipboard.c"
}

gpointer
spice_value_get_clipboard (const GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_TYPE_CLIPBOARD), NULL);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return value->data[0].v_pointer;
#line 1938 "Clipboard.c"
}

void
spice_value_set_clipboard (GValue* value,
                           gpointer v_object)
{
	SpiceClipboard * old;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_TYPE_CLIPBOARD));
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	old = value->data[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (v_object) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPICE_TYPE_CLIPBOARD));
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_clipboard_ref (value->data[0].v_pointer);
#line 1960 "Clipboard.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		value->data[0].v_pointer = NULL;
#line 1964 "Clipboard.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (old) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_clipboard_unref (old);
#line 1970 "Clipboard.c"
	}
}

void
spice_value_take_clipboard (GValue* value,
                            gpointer v_object)
{
	SpiceClipboard * old;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_TYPE_CLIPBOARD));
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	old = value->data[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (v_object) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPICE_TYPE_CLIPBOARD));
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		value->data[0].v_pointer = v_object;
#line 1991 "Clipboard.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		value->data[0].v_pointer = NULL;
#line 1995 "Clipboard.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (old) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		spice_clipboard_unref (old);
#line 2001 "Clipboard.c"
	}
}

static void
spice_clipboard_class_init (SpiceClipboardClass * klass,
                            gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	((SpiceClipboardClass *) klass)->finalize = spice_clipboard_finalize;
#line 24 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	spice_clipboard_SPICE_ATOM = gdk_atom_intern_static_string (SPICE_CLIPBOARD_SPICE_UP_TARGET_NAME);
#line 2015 "Clipboard.c"
}

static void
spice_clipboard_instance_init (SpiceClipboard * self,
                               gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	self->ref_count = 1;
#line 2024 "Clipboard.c"
}

static void
spice_clipboard_finalize (SpiceClipboard * obj)
{
	SpiceClipboard * self;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_CLIPBOARD, SpiceClipboard);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_signal_handlers_destroy (self);
#line 2035 "Clipboard.c"
}

static GType
spice_clipboard_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { spice_value_clipboard_init, spice_value_clipboard_free_value, spice_value_clipboard_copy_value, spice_value_clipboard_peek_pointer, "p", spice_value_clipboard_collect_value, "p", spice_value_clipboard_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SpiceClipboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_clipboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceClipboard), 0, (GInstanceInitFunc) spice_clipboard_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType spice_clipboard_type_id;
	spice_clipboard_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SpiceClipboard", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return spice_clipboard_type_id;
}

GType
spice_clipboard_get_type (void)
{
	static volatile gsize spice_clipboard_type_id__once = 0;
	if (g_once_init_enter (&spice_clipboard_type_id__once)) {
		GType spice_clipboard_type_id;
		spice_clipboard_type_id = spice_clipboard_get_type_once ();
		g_once_init_leave (&spice_clipboard_type_id__once, spice_clipboard_type_id);
	}
	return spice_clipboard_type_id__once;
}

gpointer
spice_clipboard_ref (gpointer instance)
{
	SpiceClipboard * self;
	self = instance;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	return instance;
#line 2070 "Clipboard.c"
}

void
spice_clipboard_unref (gpointer instance)
{
	SpiceClipboard * self;
	self = instance;
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		SPICE_CLIPBOARD_GET_CLASS (self)->finalize (self);
#line 22 "../Spice-up-1.9.1/src/Services/Clipboard.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2084 "Clipboard.c"
	}
}

