// This file is generated by kconfig_compiler_kf6 from smb4kmountsettings_linux.kcfg.
// All changes you do to this file will be lost.

#include "smb4kmountsettings_linux.h"

#include <klocalizedstring.h>

#include <qglobal.h>
#include <QFile>

class Smb4KMountSettingsHelper
{
  public:
    Smb4KMountSettingsHelper() : q(nullptr) {}
    ~Smb4KMountSettingsHelper() { delete q; q = nullptr; }
    Smb4KMountSettingsHelper(const Smb4KMountSettingsHelper&) = delete;
    Smb4KMountSettingsHelper& operator=(const Smb4KMountSettingsHelper&) = delete;
    Smb4KMountSettings *q;
};
Q_GLOBAL_STATIC(Smb4KMountSettingsHelper, s_globalSmb4KMountSettings)
Smb4KMountSettings *Smb4KMountSettings::self()
{
  if (!s_globalSmb4KMountSettings()->q) {
    new Smb4KMountSettings;
    s_globalSmb4KMountSettings()->q->read();
  }

  return s_globalSmb4KMountSettings()->q;
}

Smb4KMountSettings::Smb4KMountSettings( )
  : KConfigSkeleton( QStringLiteral( "smb4krc" ) )
{
  Q_ASSERT(!s_globalSmb4KMountSettings()->q);
  s_globalSmb4KMountSettings()->q = this;
  setCurrentGroup( QStringLiteral( "Mounting" ) );

  mCifsUnixExtensionsSupportItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "CifsUnixExtensionsSupport" ), mCifsUnixExtensionsSupport, true );
  mCifsUnixExtensionsSupportItem->setLabel( i18nd("smb4k-core", "All or most of the servers support the CIFS Unix extensions") );
  mCifsUnixExtensionsSupportItem->setWhatsThis( i18nd("smb4k-core", "Most versions of Samba support the CIFS Unix or POSIX extensions. For these servers, some options are not needed, because the right values are negotiated during the mount process. For other servers, you might want to uncheck this option, so that predefined values can be passed to the server. Please note that if your computer is located in a Windows dominated network neighborhood with only a few Samba servers, you can safely uncheck this option and define custom options for the Samba servers.") );
  addItem( mCifsUnixExtensionsSupportItem, QStringLiteral( "CifsUnixExtensionsSupport" ) );
  mUseUserIdItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseUserId" ), mUseUserId, true );
  mUseUserIdItem->setLabel( i18nd("smb4k-core", "User ID:") );
  mUseUserIdItem->setWhatsThis( i18nd("smb4k-core", "This is the user ID (a number) that the files and directories of the mounted share will have. If you are using the CIFS filesystem under Linux and the remote server supports the CIFS Unix Extensions, this setting will be ignored unless the assignment of the user ID is forced.") );
  addItem( mUseUserIdItem, QStringLiteral( "UseUserId" ) );
  mUserIdItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "UserId" ), mUserId, KUserId::currentUserId().toString() );
  mUserIdItem->setLabel( i18nd("smb4k-core", "UserId") );
  mUserIdItem->setWhatsThis( i18nd("smb4k-core", "This is the user ID (a number) that the files and directories of the mounted share will have. If you are using the CIFS filesystem under Linux and the remote server supports the CIFS Unix Extensions, this setting will be ignored unless the assignment of the user ID is forced.") );
  addItem( mUserIdItem, QStringLiteral( "UserId" ) );
  mUseGroupIdItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseGroupId" ), mUseGroupId, true );
  mUseGroupIdItem->setLabel( i18nd("smb4k-core", "Group ID:") );
  mUseGroupIdItem->setWhatsThis( i18nd("smb4k-core", "This is the group ID (a number) that the files and directories of the mounted share will have. If you are using the CIFS filesystem under Linux and the remote server supports the CIFS Unix Extensions, this setting will be ignored unless the assignment of the group ID is forced.") );
  addItem( mUseGroupIdItem, QStringLiteral( "UseGroupId" ) );
  mGroupIdItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "GroupId" ), mGroupId, KGroupId::currentGroupId().toString() );
  mGroupIdItem->setLabel( i18nd("smb4k-core", "GroupId") );
  mGroupIdItem->setWhatsThis( i18nd("smb4k-core", "This is the group ID (a number) that the files and directories of the mounted share will have. If you are using the CIFS filesystem under Linux and the remote server supports the CIFS Unix Extensions, this setting will be ignored unless the assignment of the group ID is forced.") );
  addItem( mGroupIdItem, QStringLiteral( "GroupId" ) );
  mUseFileModeItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseFileMode" ), mUseFileMode, true );
  mUseFileModeItem->setLabel( i18nd("smb4k-core", "File mode:") );
  mUseFileModeItem->setWhatsThis( i18nd("smb4k-core", "This is the file mode that will be used for creating files. It must be defined in octal. In case the CIFS file system is used, this setting only takes effect if the server does not support the CIFS Unix Extensions.") );
  addItem( mUseFileModeItem, QStringLiteral( "UseFileMode" ) );
  mFileModeItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "FileMode" ), mFileMode, QStringLiteral( "0755" ) );
  mFileModeItem->setLabel( i18nd("smb4k-core", "FileMode") );
  mFileModeItem->setWhatsThis( i18nd("smb4k-core", "This is the filemode that will be used for creating files. It must be defined in octal. In case the CIFS file system is used, this setting only takes effect if the server does not support the CIFS Unix Extensions.") );
  addItem( mFileModeItem, QStringLiteral( "FileMode" ) );
  mUseDirectoryModeItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseDirectoryMode" ), mUseDirectoryMode, true );
  mUseDirectoryModeItem->setLabel( i18nd("smb4k-core", "Directory mode:") );
  mUseDirectoryModeItem->setWhatsThis( i18nd("smb4k-core", "This is the directory mode that will be used for creating directories. It must be defined in octal. In case the CIFS file system is used, this setting only takes effect if the server does not support the CIFS Unix Extensions.") );
  addItem( mUseDirectoryModeItem, QStringLiteral( "UseDirectoryMode" ) );
  mDirectoryModeItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "DirectoryMode" ), mDirectoryMode, QStringLiteral( "0755" ) );
  mDirectoryModeItem->setLabel( i18nd("smb4k-core", "DirectoryMode") );
  mDirectoryModeItem->setWhatsThis( i18nd("smb4k-core", "This is the directory mode that will be used for creating directories. It must be defined in octal. In case the CIFS file system is used, this setting only takes effect if the server does not support the CIFS Unix Extensions.") );
  addItem( mDirectoryModeItem, QStringLiteral( "DirectoryMode" ) );
  mUseRemoteFileSystemPortItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseRemoteFileSystemPort" ), mUseRemoteFileSystemPort, false );
  mUseRemoteFileSystemPortItem->setLabel( i18nd("smb4k-core", "File system port:") );
  mUseRemoteFileSystemPortItem->setWhatsThis( i18nd("smb4k-core", "This is the port that is exclusively used to mount shares from remote servers. The default value is 445 (CIFS file system).") );
  addItem( mUseRemoteFileSystemPortItem, QStringLiteral( "UseRemoteFileSystemPort" ) );
  mRemoteFileSystemPortItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "RemoteFileSystemPort" ), mRemoteFileSystemPort, 445 );
  mRemoteFileSystemPortItem->setMinValue(1);
  mRemoteFileSystemPortItem->setMaxValue(65535);
  mRemoteFileSystemPortItem->setLabel( i18nd("smb4k-core", "RemoteFileSystemPort") );
  mRemoteFileSystemPortItem->setWhatsThis( i18nd("smb4k-core", "This is the port that is exclusively used to mount shares from remote servers. The default value is 445 (CIFS file system).") );
  addItem( mRemoteFileSystemPortItem, QStringLiteral( "RemoteFileSystemPort" ) );
  mUseClientCharsetItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseClientCharset" ), mUseClientCharset, false );
  mUseClientCharsetItem->setLabel( i18nd("smb4k-core", "Client character set:") );
  mUseClientCharsetItem->setWhatsThis( i18nd("smb4k-core", "This is the character set that is used by the client side (i.e. your side) either to convert local path names to and from Unicode (CIFS, Linux) or for codepage to charset translations (SMBFS, FreeBSD). If you keep the default setting, Smb4K will try to automatically determine the charset by looking up the \"unix charset\" option in the smb.conf.") );
  addItem( mUseClientCharsetItem, QStringLiteral( "UseClientCharset" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesClientCharset;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("default_charset");
    choice.label = i18nd("smb4k-core", "default");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_1");
    choice.label = i18nd("smb4k-core", "iso8859-1");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_2");
    choice.label = i18nd("smb4k-core", "iso8859-2");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_3");
    choice.label = i18nd("smb4k-core", "iso8859-3");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_4");
    choice.label = i18nd("smb4k-core", "iso8859-4");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_5");
    choice.label = i18nd("smb4k-core", "iso8859-5");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_6");
    choice.label = i18nd("smb4k-core", "iso8859-6");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_7");
    choice.label = i18nd("smb4k-core", "iso8859-7");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_8");
    choice.label = i18nd("smb4k-core", "iso8859-8");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_9");
    choice.label = i18nd("smb4k-core", "iso8859-9");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_13");
    choice.label = i18nd("smb4k-core", "iso8859-13");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_14");
    choice.label = i18nd("smb4k-core", "iso8859-14");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("iso8859_15");
    choice.label = i18nd("smb4k-core", "iso8859-15");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("utf8");
    choice.label = i18nd("smb4k-core", "utf8");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("koi8_r");
    choice.label = i18nd("smb4k-core", "koi8-r");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("koi8_u");
    choice.label = i18nd("smb4k-core", "koi8-u");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("koi8_ru");
    choice.label = i18nd("smb4k-core", "koi8-ru");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("cp1251");
    choice.label = i18nd("smb4k-core", "cp1251");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("gb2312");
    choice.label = i18nd("smb4k-core", "gb2312");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("big5");
    choice.label = i18nd("smb4k-core", "big5");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("euc_jp");
    choice.label = i18nd("smb4k-core", "euc-jp");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("euc_kr");
    choice.label = i18nd("smb4k-core", "euc-kr");
    valuesClientCharset.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("tis_620");
    choice.label = i18nd("smb4k-core", "tis-620");
    valuesClientCharset.append( choice );
  }
  mClientCharsetItem = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "ClientCharset" ), mClientCharset, valuesClientCharset, EnumClientCharset::default_charset );
  mClientCharsetItem->setLabel( i18nd("smb4k-core", "ClientCharset") );
  mClientCharsetItem->setWhatsThis( i18nd("smb4k-core", "This is the character set that is used by the client side (i.e. your side) either to convert local path names to and from Unicode (CIFS, Linux) or for codepage to charset translations (SMBFS, FreeBSD). If you keep the default setting, Smb4K will try to automatically determine the charset by looking up the \"unix charset\" option in the smb.conf.") );
  addItem( mClientCharsetItem, QStringLiteral( "ClientCharset" ) );
  mUseWriteAccessItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseWriteAccess" ), mUseWriteAccess, false );
  mUseWriteAccessItem->setLabel( i18nd("smb4k-core", "Write access:") );
  mUseWriteAccessItem->setWhatsThis( i18nd("smb4k-core", "Here you can choose if the shares should be mounted in read-write or read-only mode.") );
  addItem( mUseWriteAccessItem, QStringLiteral( "UseWriteAccess" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesWriteAccess;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ReadWrite");
    choice.label = i18nd("smb4k-core", "read-write");
    valuesWriteAccess.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ReadOnly");
    choice.label = i18nd("smb4k-core", "read-only");
    valuesWriteAccess.append( choice );
  }
  mWriteAccessItem = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "WriteAccess" ), mWriteAccess, valuesWriteAccess, EnumWriteAccess::ReadWrite );
  mWriteAccessItem->setLabel( i18nd("smb4k-core", "WriteAccess") );
  mWriteAccessItem->setWhatsThis( i18nd("smb4k-core", "Here you can choose if the shares should be mounted in read-write or read-only mode.") );
  addItem( mWriteAccessItem, QStringLiteral( "WriteAccess" ) );
  mForceUIDItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ForceUID" ), mForceUID, false );
  mForceUIDItem->setLabel( i18nd("smb4k-core", "Definitely assign the UID") );
  mForceUIDItem->setWhatsThis( i18nd("smb4k-core", "Instruct the client (i.e. your side) to ignore any user ID (UID) provided by the server for files and directories and to always assign the owner to be the value of the transmitted UID.") );
  addItem( mForceUIDItem, QStringLiteral( "ForceUID" ) );
  mForceGIDItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ForceGID" ), mForceGID, false );
  mForceGIDItem->setLabel( i18nd("smb4k-core", "Definitely assign the GID") );
  mForceGIDItem->setWhatsThis( i18nd("smb4k-core", "Instruct the client (i.e. your side) to ignore any group ID (GID) provided by the server for files and directories and to always assign the owner to be the value of the transmitted GID.") );
  addItem( mForceGIDItem, QStringLiteral( "ForceGID" ) );
  mPermissionChecksItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "PermissionChecks" ), mPermissionChecks, false );
  mPermissionChecksItem->setLabel( i18nd("smb4k-core", "Do permission checks") );
  mPermissionChecksItem->setWhatsThis( i18nd("smb4k-core", "The client side (i.e. your side) will check if you have the right UID/GID to manipulate a file or directory. You might want to switch this feature off if the server(s) support the CIFS Unix Extensions and you are not allowed to access the files and directories. This setting does not affect the normal ACL check.") );
  addItem( mPermissionChecksItem, QStringLiteral( "PermissionChecks" ) );
  mClientControlsIDsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ClientControlsIDs" ), mClientControlsIDs, false );
  mClientControlsIDsItem->setLabel( i18nd("smb4k-core", "Attempt to set UID and GID") );
  mClientControlsIDsItem->setWhatsThis( i18nd("smb4k-core", "In case the server supports the CIFS Unix Extensions, the client side (i.e. your side) attempts to set the effective UID and GID of the current process on newly created files, directories and devices. If this feature is turned off, the server will set the UID and GID to the default for the share. It is recommended that you read the manual page of mount.cifs before you change this setting.") );
  addItem( mClientControlsIDsItem, QStringLiteral( "ClientControlsIDs" ) );
  mServerInodeNumbersItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ServerInodeNumbers" ), mServerInodeNumbers, true );
  mServerInodeNumbersItem->setLabel( i18nd("smb4k-core", "Use server inode numbers") );
  mServerInodeNumbersItem->setWhatsThis( i18nd("smb4k-core", "Use inode numbers (unique persistent file identifiers) returned by the server instead of automatically generating temporary inode numbers on the client side.") );
  addItem( mServerInodeNumbersItem, QStringLiteral( "ServerInodeNumbers" ) );
  mNoLockingItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "NoLocking" ), mNoLocking, false );
  mNoLockingItem->setLabel( i18nd("smb4k-core", "Do not send byte range lock requests") );
  mNoLockingItem->setWhatsThis( i18nd("smb4k-core", "Do not send byte range lock requests to the server. This is necessary for certain applications that break with CIFS style mandatory byte range locks (and most CIFS servers do not yet support requesting advisory byte range locks).") );
  addItem( mNoLockingItem, QStringLiteral( "NoLocking" ) );
  mTranslateReservedCharsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "TranslateReservedChars" ), mTranslateReservedChars, false );
  mTranslateReservedCharsItem->setLabel( i18nd("smb4k-core", "Translate reserved characters") );
  mTranslateReservedCharsItem->setWhatsThis( i18nd("smb4k-core", "Translate six of the seven reserved characters (including the colon, question mark, pipe, asterisk, greater than and less than characters but not the backslash) to remap range (above 0xF000). This allows you to open files that were created with such characters. This has no effect if the server does not support Unicode.") );
  addItem( mTranslateReservedCharsItem, QStringLiteral( "TranslateReservedChars" ) );
  mUseSmbProtocolVersionItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseSmbProtocolVersion" ), mUseSmbProtocolVersion, false );
  mUseSmbProtocolVersionItem->setLabel( i18nd("smb4k-core", "SMB protocol version:") );
  mUseSmbProtocolVersionItem->setWhatsThis( i18nd("smb4k-core", "Define which version of the SMB protocol is to be used.") );
  addItem( mUseSmbProtocolVersionItem, QStringLiteral( "UseSmbProtocolVersion" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesSmbProtocolVersion;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("OnePointZero");
    choice.label = i18nd("smb4k-core", "1.0 (Classic CIFS/SMBv1 protocol)");
    valuesSmbProtocolVersion.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TwoPointZero");
    choice.label = i18nd("smb4k-core", "2.0 (Windows Vista SP1/Windows Server 2008)");
    valuesSmbProtocolVersion.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TwoPointOne");
    choice.label = i18nd("smb4k-core", "2.1 (Windows 7/Windows Server 2008R2)");
    valuesSmbProtocolVersion.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ThreePointZero");
    choice.label = i18nd("smb4k-core", "3.0 (Windows 8/Windows Server 2012)");
    valuesSmbProtocolVersion.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ThreePointZeroPointTwo");
    choice.label = i18nd("smb4k-core", "3.0.2 (Windows 8.1/Windows Server 2012R2)");
    valuesSmbProtocolVersion.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ThreePointOnePointOne");
    choice.label = i18nd("smb4k-core", "3.1.1 (Windows Server 2016)");
    valuesSmbProtocolVersion.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ThreeAndAbove");
    choice.label = i18nd("smb4k-core", "3 (Version 3.0 and above)");
    valuesSmbProtocolVersion.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Default");
    choice.label = i18nd("smb4k-core", "default (Negotiate the highest version)");
    valuesSmbProtocolVersion.append( choice );
  }
  mSmbProtocolVersionItem = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "SmbProtocolVersion" ), mSmbProtocolVersion, valuesSmbProtocolVersion, EnumSmbProtocolVersion::Default );
  mSmbProtocolVersionItem->setLabel( i18nd("smb4k-core", "SmbProtocolVersion") );
  mSmbProtocolVersionItem->setWhatsThis( i18nd("smb4k-core", "Define which version of the SMB protocol is to be used.") );
  addItem( mSmbProtocolVersionItem, QStringLiteral( "SmbProtocolVersion" ) );
  mUseCacheModeItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseCacheMode" ), mUseCacheMode, false );
  mUseCacheModeItem->setLabel( i18nd("smb4k-core", "Cache mode:") );
  mUseCacheModeItem->setWhatsThis( i18nd("smb4k-core", "Define how read and write requests are handled. In case you choose to not cache file data at all, the client never utilizes the cache for normal reads and writes. It always accesses the server directly to satisfy a read or write request. If you choose to follow the CIFS/SMB2 protocol strictly, the cache is only trusted if the client holds an oplock. If the client does not hold an oplock, then the client bypasses the cache and accesses the server directly to satisfy a read or write request. Choosing to allow loose caching semantics can sometimes provide better performance on the expense of cache coherency. This option might cause data corruption, if several clients access the same set of files on the server at the same time. Because of this, the strict cache mode is recommended.") );
  addItem( mUseCacheModeItem, QStringLiteral( "UseCacheMode" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesCacheMode;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    choice.label = i18nd("smb4k-core", "Do not cache file data at all");
    valuesCacheMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Strict");
    choice.label = i18nd("smb4k-core", "Follow the CIFS/SMB2 protocol strictly");
    valuesCacheMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Loose");
    choice.label = i18nd("smb4k-core", "Allow loose caching semantics");
    valuesCacheMode.append( choice );
  }
  mCacheModeItem = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "CacheMode" ), mCacheMode, valuesCacheMode, EnumCacheMode::Strict );
  mCacheModeItem->setLabel( i18nd("smb4k-core", "CacheMode") );
  mCacheModeItem->setWhatsThis( i18nd("smb4k-core", "Define how read and write requests are handled. In case you choose to not cache file data at all, the client never utilizes the cache for normal reads and writes. It always accesses the server directly to satisfy a read or write request. If you choose to follow the CIFS/SMB2 protocol strictly, the cache is only trusted if the client holds an oplock. If the client does not hold an oplock, then the client bypasses the cache and accesses the server directly to satisfy a read or write request. Choosing to allow loose caching semantics can sometimes provide better performance on the expense of cache coherency. This option might cause data corruption, if several clients access the same set of files on the server at the same time. Because of this, the strict cache mode is recommended.") );
  addItem( mCacheModeItem, QStringLiteral( "CacheMode" ) );
  mUseSecurityModeItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseSecurityMode" ), mUseSecurityMode, false );
  mUseSecurityModeItem->setLabel( i18nd("smb4k-core", "Security mode:") );
  mUseSecurityModeItem->setWhatsThis( i18nd("smb4k-core", "Security mode for mount.cifs. To be able to use this mode, the CIFS kernel module 1.40 or later is required.") );
  addItem( mUseSecurityModeItem, QStringLiteral( "UseSecurityMode" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesSecurityMode;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    choice.label = i18nd("smb4k-core", "Connect as a null user (no name)");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Krb5");
    choice.label = i18nd("smb4k-core", "Kerberos 5 authentication");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Krb5i");
    choice.label = i18nd("smb4k-core", "Kerberos 5 authentication and packet signing");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Ntlm");
    choice.label = i18nd("smb4k-core", "NTLM protocol");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Ntlmi");
    choice.label = i18nd("smb4k-core", "NTLM protocol and packet signing");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Ntlmv2");
    choice.label = i18nd("smb4k-core", "NTLMv2 protocol");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Ntlmv2i");
    choice.label = i18nd("smb4k-core", "NTLMv2 protocol and packet signing");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Ntlmssp");
    choice.label = i18nd("smb4k-core", "NTLMSSP protocol");
    valuesSecurityMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Ntlmsspi");
    choice.label = i18nd("smb4k-core", "NTLMSSP protocol and packet signing");
    valuesSecurityMode.append( choice );
  }
  mSecurityModeItem = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "SecurityMode" ), mSecurityMode, valuesSecurityMode, EnumSecurityMode::Ntlmssp );
  mSecurityModeItem->setLabel( i18nd("smb4k-core", "SecurityMode") );
  mSecurityModeItem->setWhatsThis( i18nd("smb4k-core", "Security mode for mount.cifs. To be able to use this mode, the CIFS kernel module 1.40 or later is required.") );
  addItem( mSecurityModeItem, QStringLiteral( "SecurityMode" ) );
  mUseCustomCifsOptionsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseCustomCifsOptions" ), mUseCustomCifsOptions, false );
  mUseCustomCifsOptionsItem->setLabel( i18nd("smb4k-core", "Additional options:") );
  mUseCustomCifsOptionsItem->setWhatsThis( i18nd("smb4k-core", "Here you can enter advanced options for the CIFS file system in a comma-separated list (refer to the manual page of mount.cifs to learn more). The list will be added AS IS to the \"-o\" argument of mount.cifs. Please do not enter options that have already been defined in the configuration dialog.") );
  addItem( mUseCustomCifsOptionsItem, QStringLiteral( "UseCustomCifsOptions" ) );
  mCustomCIFSOptionsItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "CustomCIFSOptions" ), mCustomCIFSOptions );
  mCustomCIFSOptionsItem->setLabel( i18nd("smb4k-core", "CustomCIFSOptions") );
  mCustomCIFSOptionsItem->setWhatsThis( i18nd("smb4k-core", "Here you can enter advanced options for the CIFS file system in a comma-separated list (refer to the manual page of mount.cifs to learn more). The list will be added AS IS to the \"-o\" argument of mount.cifs. Please do not enter options that have already been defined in the configuration dialog.") );
  addItem( mCustomCIFSOptionsItem, QStringLiteral( "CustomCIFSOptions" ) );
  mMountPrefixItem = new KConfigSkeleton::ItemUrl( currentGroup(), QStringLiteral( "MountPrefix" ), mMountPrefix, QUrl::fromLocalFile(QDir::homePath()+QStringLiteral("/smb4k/")) );
  mMountPrefixItem->setLabel( i18nd("smb4k-core", "Mount prefix:") );
  mMountPrefixItem->setWhatsThis( i18nd("smb4k-core", "This is the prefix where Smb4K will create the mount points and mount the remote shares.") );
  addItem( mMountPrefixItem, QStringLiteral( "MountPrefix" ) );
  mForceLowerCaseSubdirsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ForceLowerCaseSubdirs" ), mForceLowerCaseSubdirs, false );
  mForceLowerCaseSubdirsItem->setLabel( i18nd("smb4k-core", "Force generated subdirectories to be lower case") );
  mForceLowerCaseSubdirsItem->setWhatsThis( i18nd("smb4k-core", "All names of the subdirectories created by Smb4K below the mount prefix will be lowercase.") );
  addItem( mForceLowerCaseSubdirsItem, QStringLiteral( "ForceLowerCaseSubdirs" ) );
  mUnmountSharesOnExitItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UnmountSharesOnExit" ), mUnmountSharesOnExit, false );
  mUnmountSharesOnExitItem->setLabel( i18nd("smb4k-core", "Unmount all personal shares on exit") );
  mUnmountSharesOnExitItem->setWhatsThis( i18nd("smb4k-core", "Unmount all shares that belong to you when the program exits. Shares that are owned by other users are ignored.") );
  addItem( mUnmountSharesOnExitItem, QStringLiteral( "UnmountSharesOnExit" ) );
  mRemountSharesItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "RemountShares" ), mRemountShares, false );
  mRemountSharesItem->setLabel( i18nd("smb4k-core", "Remount shares") );
  mRemountSharesItem->setWhatsThis( i18nd("smb4k-core", "Remount all your shares that were mounted when you exited the program or changed a profile. If the remounting of a share fails, Smb4K will retry the next time it is started. Shares that were mounted by other users are ignored. Please note that this setting does not affect the automatic remounting of shares when your computer woke up from a sleep state.") );
  addItem( mRemountSharesItem, QStringLiteral( "RemountShares" ) );
  mRemountAttemptsItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "RemountAttempts" ), mRemountAttempts, 1 );
  mRemountAttemptsItem->setMinValue(1);
  mRemountAttemptsItem->setMaxValue(100);
  mRemountAttemptsItem->setLabel( i18nd("smb4k-core", "Number of remount attempts:") );
  mRemountAttemptsItem->setWhatsThis( i18nd("smb4k-core", "Set the number of attempts that are made to remount shares before Smb4K gives up.") );
  addItem( mRemountAttemptsItem, QStringLiteral( "RemountAttempts" ) );
  mRemountIntervalItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "RemountInterval" ), mRemountInterval, 5 );
  mRemountIntervalItem->setMinValue(1);
  mRemountIntervalItem->setMaxValue(30);
  mRemountIntervalItem->setLabel( i18nd("smb4k-core", "Interval between remount attempts:") );
  mRemountIntervalItem->setWhatsThis( i18nd("smb4k-core", "Set the time that elapses between attempts to remount shares.") );
  addItem( mRemountIntervalItem, QStringLiteral( "RemountInterval" ) );
  mUnmountForeignSharesItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UnmountForeignShares" ), mUnmountForeignShares, false );
  mUnmountForeignSharesItem->setLabel( i18nd("smb4k-core", "Allow the unmounting of shares that are owned by other users") );
  mUnmountForeignSharesItem->setWhatsThis( i18nd("smb4k-core", "Allow the unmounting of shares that were mounted by other users. Please think before you enable this option.") );
  addItem( mUnmountForeignSharesItem, QStringLiteral( "UnmountForeignShares" ) );
  mForceUnmountInaccessibleItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ForceUnmountInaccessible" ), mForceUnmountInaccessible, false );
  mForceUnmountInaccessibleItem->setLabel( i18nd("smb4k-core", "Force the unmounting of inaccessible shares") );
  mForceUnmountInaccessibleItem->setWhatsThis( i18nd("smb4k-core", "Force the unmounting of inaccessible shares (Linux only). In case a share is inaccessible, a lazy unmount is performed. Before the actual unmount is performed, a warning dialog is shown asking to approve the unmount.") );
  addItem( mForceUnmountInaccessibleItem, QStringLiteral( "ForceUnmountInaccessible" ) );
  mDetectAllSharesItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "DetectAllShares" ), mDetectAllShares, false );
  mDetectAllSharesItem->setLabel( i18nd("smb4k-core", "Detect all shares that are mounted on the system") );
  mDetectAllSharesItem->setWhatsThis( i18nd("smb4k-core", "You will not only see the shares that were mounted and are owned by you, but also all other mounts using the SMBFS and CIFS file system that are present on the system.") );
  addItem( mDetectAllSharesItem, QStringLiteral( "DetectAllShares" ) );
}

Smb4KMountSettings::~Smb4KMountSettings()
{
  if (s_globalSmb4KMountSettings.exists() && !s_globalSmb4KMountSettings.isDestroyed()) {
    s_globalSmb4KMountSettings()->q = nullptr;
  }
}

