/* Easing.c generated by valac 0.56.17, the Vala compiler
 * generated from Easing.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/
/**
 * Utility functions to calculate progress of transitions.
 * Initially ported from clutter's clutter-enums.h and clutter-easing.c
 */

#include "plank.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef gdouble (*PlankEasingFunc) (gdouble t, gdouble d);

#define PLANK_TYPE_ANIMATION_MODE_MAPPING (plank_animation_mode_mapping_get_type ())
typedef struct _PlankAnimationModeMapping PlankAnimationModeMapping;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankAnimationModeMapping {
	PlankAnimationMode mode;
	PlankEasingFunc func;
	gchar* name;
};

VALA_EXTERN GType plank_animation_mode_mapping_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PlankAnimationModeMapping* plank_animation_mode_mapping_dup (const PlankAnimationModeMapping* self);
VALA_EXTERN void plank_animation_mode_mapping_free (PlankAnimationModeMapping* self);
VALA_EXTERN void plank_animation_mode_mapping_copy (const PlankAnimationModeMapping* self,
                                        PlankAnimationModeMapping* dest);
VALA_EXTERN void plank_animation_mode_mapping_destroy (PlankAnimationModeMapping* self);
VALA_EXTERN gdouble plank_linear (gdouble t,
                      gdouble d);
static gdouble _plank_linear_plank_easing_func (gdouble t,
                                         gdouble d);
VALA_EXTERN gdouble plank_ease_in_quad (gdouble t,
                            gdouble d);
static gdouble _plank_ease_in_quad_plank_easing_func (gdouble t,
                                               gdouble d);
VALA_EXTERN gdouble plank_ease_out_quad (gdouble t,
                             gdouble d);
static gdouble _plank_ease_out_quad_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_quad (gdouble t,
                                gdouble d);
static gdouble _plank_ease_in_out_quad_plank_easing_func (gdouble t,
                                                   gdouble d);
VALA_EXTERN gdouble plank_ease_in_cubic (gdouble t,
                             gdouble d);
static gdouble _plank_ease_in_cubic_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_out_cubic (gdouble t,
                              gdouble d);
static gdouble _plank_ease_out_cubic_plank_easing_func (gdouble t,
                                                 gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_cubic (gdouble t,
                                 gdouble d);
static gdouble _plank_ease_in_out_cubic_plank_easing_func (gdouble t,
                                                    gdouble d);
VALA_EXTERN gdouble plank_ease_in_quart (gdouble t,
                             gdouble d);
static gdouble _plank_ease_in_quart_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_out_quart (gdouble t,
                              gdouble d);
static gdouble _plank_ease_out_quart_plank_easing_func (gdouble t,
                                                 gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_quart (gdouble t,
                                 gdouble d);
static gdouble _plank_ease_in_out_quart_plank_easing_func (gdouble t,
                                                    gdouble d);
VALA_EXTERN gdouble plank_ease_in_quint (gdouble t,
                             gdouble d);
static gdouble _plank_ease_in_quint_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_out_quint (gdouble t,
                              gdouble d);
static gdouble _plank_ease_out_quint_plank_easing_func (gdouble t,
                                                 gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_quint (gdouble t,
                                 gdouble d);
static gdouble _plank_ease_in_out_quint_plank_easing_func (gdouble t,
                                                    gdouble d);
VALA_EXTERN gdouble plank_ease_in_sine (gdouble t,
                            gdouble d);
static gdouble _plank_ease_in_sine_plank_easing_func (gdouble t,
                                               gdouble d);
VALA_EXTERN gdouble plank_ease_out_sine (gdouble t,
                             gdouble d);
static gdouble _plank_ease_out_sine_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_sine (gdouble t,
                                gdouble d);
static gdouble _plank_ease_in_out_sine_plank_easing_func (gdouble t,
                                                   gdouble d);
VALA_EXTERN gdouble plank_ease_in_expo (gdouble t,
                            gdouble d);
static gdouble _plank_ease_in_expo_plank_easing_func (gdouble t,
                                               gdouble d);
VALA_EXTERN gdouble plank_ease_out_expo (gdouble t,
                             gdouble d);
static gdouble _plank_ease_out_expo_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_expo (gdouble t,
                                gdouble d);
static gdouble _plank_ease_in_out_expo_plank_easing_func (gdouble t,
                                                   gdouble d);
VALA_EXTERN gdouble plank_ease_in_circ (gdouble t,
                            gdouble d);
static gdouble _plank_ease_in_circ_plank_easing_func (gdouble t,
                                               gdouble d);
VALA_EXTERN gdouble plank_ease_out_circ (gdouble t,
                             gdouble d);
static gdouble _plank_ease_out_circ_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_circ (gdouble t,
                                gdouble d);
static gdouble _plank_ease_in_out_circ_plank_easing_func (gdouble t,
                                                   gdouble d);
VALA_EXTERN gdouble plank_ease_in_elastic (gdouble t,
                               gdouble d);
static gdouble _plank_ease_in_elastic_plank_easing_func (gdouble t,
                                                  gdouble d);
VALA_EXTERN gdouble plank_ease_out_elastic (gdouble t,
                                gdouble d);
static gdouble _plank_ease_out_elastic_plank_easing_func (gdouble t,
                                                   gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_elastic (gdouble t,
                                   gdouble d);
static gdouble _plank_ease_in_out_elastic_plank_easing_func (gdouble t,
                                                      gdouble d);
VALA_EXTERN gdouble plank_ease_in_back (gdouble t,
                            gdouble d);
static gdouble _plank_ease_in_back_plank_easing_func (gdouble t,
                                               gdouble d);
VALA_EXTERN gdouble plank_ease_out_back (gdouble t,
                             gdouble d);
static gdouble _plank_ease_out_back_plank_easing_func (gdouble t,
                                                gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_back (gdouble t,
                                gdouble d);
static gdouble _plank_ease_in_out_back_plank_easing_func (gdouble t,
                                                   gdouble d);
VALA_EXTERN gdouble plank_ease_in_bounce (gdouble t,
                              gdouble d);
static gdouble _plank_ease_in_bounce_plank_easing_func (gdouble t,
                                                 gdouble d);
VALA_EXTERN gdouble plank_ease_out_bounce (gdouble t,
                               gdouble d);
static gdouble _plank_ease_out_bounce_plank_easing_func (gdouble t,
                                                  gdouble d);
VALA_EXTERN gdouble plank_ease_in_out_bounce (gdouble t,
                                  gdouble d);
static gdouble _plank_ease_in_out_bounce_plank_easing_func (gdouble t,
                                                     gdouble d);
VALA_EXTERN PlankEasingFunc plank_easing_func_for_mode (PlankAnimationMode mode);
VALA_EXTERN const gchar* plank_easing_name_for_mode (PlankAnimationMode mode);
VALA_EXTERN gdouble plank_ease_out_bounce_internal (gdouble t,
                                        gdouble d);
VALA_EXTERN gdouble plank_ease_in_bounce_internal (gdouble t,
                                       gdouble d);

const PlankAnimationModeMapping PLANK_ANIMATION_MODES[33] = {{PLANK_ANIMATION_MODE_CUSTOM, NULL, "custom"}, {PLANK_ANIMATION_MODE_LINEAR, _plank_linear_plank_easing_func, "linear"}, {PLANK_ANIMATION_MODE_EASE_IN_QUAD, _plank_ease_in_quad_plank_easing_func, "easeInQuad"}, {PLANK_ANIMATION_MODE_EASE_OUT_QUAD, _plank_ease_out_quad_plank_easing_func, "easeOutQuad"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_QUAD, _plank_ease_in_out_quad_plank_easing_func, "easeInOutQuad"}, {PLANK_ANIMATION_MODE_EASE_IN_CUBIC, _plank_ease_in_cubic_plank_easing_func, "easeInCubic"}, {PLANK_ANIMATION_MODE_EASE_OUT_CUBIC, _plank_ease_out_cubic_plank_easing_func, "easeOutCubic"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_CUBIC, _plank_ease_in_out_cubic_plank_easing_func, "easeInOutCubic"}, {PLANK_ANIMATION_MODE_EASE_IN_QUART, _plank_ease_in_quart_plank_easing_func, "easeInQuart"}, {PLANK_ANIMATION_MODE_EASE_OUT_QUART, _plank_ease_out_quart_plank_easing_func, "easeOutQuart"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_QUART, _plank_ease_in_out_quart_plank_easing_func, "easeInOutQuart"}, {PLANK_ANIMATION_MODE_EASE_IN_QUINT, _plank_ease_in_quint_plank_easing_func, "easeInQuint"}, {PLANK_ANIMATION_MODE_EASE_OUT_QUINT, _plank_ease_out_quint_plank_easing_func, "easeOutQuint"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_QUINT, _plank_ease_in_out_quint_plank_easing_func, "easeInOutQuint"}, {PLANK_ANIMATION_MODE_EASE_IN_SINE, _plank_ease_in_sine_plank_easing_func, "easeInSine"}, {PLANK_ANIMATION_MODE_EASE_OUT_SINE, _plank_ease_out_sine_plank_easing_func, "easeOutSine"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_SINE, _plank_ease_in_out_sine_plank_easing_func, "easeInOutSine"}, {PLANK_ANIMATION_MODE_EASE_IN_EXPO, _plank_ease_in_expo_plank_easing_func, "easeInExpo"}, {PLANK_ANIMATION_MODE_EASE_OUT_EXPO, _plank_ease_out_expo_plank_easing_func, "easeOutExpo"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_EXPO, _plank_ease_in_out_expo_plank_easing_func, "easeInOutExpo"}, {PLANK_ANIMATION_MODE_EASE_IN_CIRC, _plank_ease_in_circ_plank_easing_func, "easeInCirc"}, {PLANK_ANIMATION_MODE_EASE_OUT_CIRC, _plank_ease_out_circ_plank_easing_func, "easeOutCirc"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_CIRC, _plank_ease_in_out_circ_plank_easing_func, "easeInOutCirc"}, {PLANK_ANIMATION_MODE_EASE_IN_ELASTIC, _plank_ease_in_elastic_plank_easing_func, "easeInElastic"}, {PLANK_ANIMATION_MODE_EASE_OUT_ELASTIC, _plank_ease_out_elastic_plank_easing_func, "easeOutElastic"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_ELASTIC, _plank_ease_in_out_elastic_plank_easing_func, "easeInOutElastic"}, {PLANK_ANIMATION_MODE_EASE_IN_BACK, _plank_ease_in_back_plank_easing_func, "easeInBack"}, {PLANK_ANIMATION_MODE_EASE_OUT_BACK, _plank_ease_out_back_plank_easing_func, "easeOutBack"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_BACK, _plank_ease_in_out_back_plank_easing_func, "easeInOutBack"}, {PLANK_ANIMATION_MODE_EASE_IN_BOUNCE, _plank_ease_in_bounce_plank_easing_func, "easeInBounce"}, {PLANK_ANIMATION_MODE_EASE_OUT_BOUNCE, _plank_ease_out_bounce_plank_easing_func, "easeOutBounce"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_BOUNCE, _plank_ease_in_out_bounce_plank_easing_func, "easeInOutBounce"}, {PLANK_ANIMATION_MODE_LAST, NULL, "sentinel"}};

/**
 * The available animation modes
 */
static GType
plank_animation_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_ANIMATION_MODE_CUSTOM, "PLANK_ANIMATION_MODE_CUSTOM", "custom"}, {PLANK_ANIMATION_MODE_LINEAR, "PLANK_ANIMATION_MODE_LINEAR", "linear"}, {PLANK_ANIMATION_MODE_EASE_IN_QUAD, "PLANK_ANIMATION_MODE_EASE_IN_QUAD", "ease-in-quad"}, {PLANK_ANIMATION_MODE_EASE_OUT_QUAD, "PLANK_ANIMATION_MODE_EASE_OUT_QUAD", "ease-out-quad"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_QUAD, "PLANK_ANIMATION_MODE_EASE_IN_OUT_QUAD", "ease-in-out-quad"}, {PLANK_ANIMATION_MODE_EASE_IN_CUBIC, "PLANK_ANIMATION_MODE_EASE_IN_CUBIC", "ease-in-cubic"}, {PLANK_ANIMATION_MODE_EASE_OUT_CUBIC, "PLANK_ANIMATION_MODE_EASE_OUT_CUBIC", "ease-out-cubic"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_CUBIC, "PLANK_ANIMATION_MODE_EASE_IN_OUT_CUBIC", "ease-in-out-cubic"}, {PLANK_ANIMATION_MODE_EASE_IN_QUART, "PLANK_ANIMATION_MODE_EASE_IN_QUART", "ease-in-quart"}, {PLANK_ANIMATION_MODE_EASE_OUT_QUART, "PLANK_ANIMATION_MODE_EASE_OUT_QUART", "ease-out-quart"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_QUART, "PLANK_ANIMATION_MODE_EASE_IN_OUT_QUART", "ease-in-out-quart"}, {PLANK_ANIMATION_MODE_EASE_IN_QUINT, "PLANK_ANIMATION_MODE_EASE_IN_QUINT", "ease-in-quint"}, {PLANK_ANIMATION_MODE_EASE_OUT_QUINT, "PLANK_ANIMATION_MODE_EASE_OUT_QUINT", "ease-out-quint"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_QUINT, "PLANK_ANIMATION_MODE_EASE_IN_OUT_QUINT", "ease-in-out-quint"}, {PLANK_ANIMATION_MODE_EASE_IN_SINE, "PLANK_ANIMATION_MODE_EASE_IN_SINE", "ease-in-sine"}, {PLANK_ANIMATION_MODE_EASE_OUT_SINE, "PLANK_ANIMATION_MODE_EASE_OUT_SINE", "ease-out-sine"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_SINE, "PLANK_ANIMATION_MODE_EASE_IN_OUT_SINE", "ease-in-out-sine"}, {PLANK_ANIMATION_MODE_EASE_IN_EXPO, "PLANK_ANIMATION_MODE_EASE_IN_EXPO", "ease-in-expo"}, {PLANK_ANIMATION_MODE_EASE_OUT_EXPO, "PLANK_ANIMATION_MODE_EASE_OUT_EXPO", "ease-out-expo"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_EXPO, "PLANK_ANIMATION_MODE_EASE_IN_OUT_EXPO", "ease-in-out-expo"}, {PLANK_ANIMATION_MODE_EASE_IN_CIRC, "PLANK_ANIMATION_MODE_EASE_IN_CIRC", "ease-in-circ"}, {PLANK_ANIMATION_MODE_EASE_OUT_CIRC, "PLANK_ANIMATION_MODE_EASE_OUT_CIRC", "ease-out-circ"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_CIRC, "PLANK_ANIMATION_MODE_EASE_IN_OUT_CIRC", "ease-in-out-circ"}, {PLANK_ANIMATION_MODE_EASE_IN_ELASTIC, "PLANK_ANIMATION_MODE_EASE_IN_ELASTIC", "ease-in-elastic"}, {PLANK_ANIMATION_MODE_EASE_OUT_ELASTIC, "PLANK_ANIMATION_MODE_EASE_OUT_ELASTIC", "ease-out-elastic"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_ELASTIC, "PLANK_ANIMATION_MODE_EASE_IN_OUT_ELASTIC", "ease-in-out-elastic"}, {PLANK_ANIMATION_MODE_EASE_IN_BACK, "PLANK_ANIMATION_MODE_EASE_IN_BACK", "ease-in-back"}, {PLANK_ANIMATION_MODE_EASE_OUT_BACK, "PLANK_ANIMATION_MODE_EASE_OUT_BACK", "ease-out-back"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_BACK, "PLANK_ANIMATION_MODE_EASE_IN_OUT_BACK", "ease-in-out-back"}, {PLANK_ANIMATION_MODE_EASE_IN_BOUNCE, "PLANK_ANIMATION_MODE_EASE_IN_BOUNCE", "ease-in-bounce"}, {PLANK_ANIMATION_MODE_EASE_OUT_BOUNCE, "PLANK_ANIMATION_MODE_EASE_OUT_BOUNCE", "ease-out-bounce"}, {PLANK_ANIMATION_MODE_EASE_IN_OUT_BOUNCE, "PLANK_ANIMATION_MODE_EASE_IN_OUT_BOUNCE", "ease-in-out-bounce"}, {PLANK_ANIMATION_MODE_LAST, "PLANK_ANIMATION_MODE_LAST", "last"}, {0, NULL, NULL}};
	GType plank_animation_mode_type_id;
	plank_animation_mode_type_id = g_enum_register_static ("PlankAnimationMode", values);
	return plank_animation_mode_type_id;
}

GType
plank_animation_mode_get_type (void)
{
	static volatile gsize plank_animation_mode_type_id__once = 0;
	if (g_once_init_enter (&plank_animation_mode_type_id__once)) {
		GType plank_animation_mode_type_id;
		plank_animation_mode_type_id = plank_animation_mode_get_type_once ();
		g_once_init_leave (&plank_animation_mode_type_id__once, plank_animation_mode_type_id);
	}
	return plank_animation_mode_type_id__once;
}

void
plank_animation_mode_mapping_copy (const PlankAnimationModeMapping* self,
                                   PlankAnimationModeMapping* dest)
{
	PlankEasingFunc _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	(*dest).mode = (*self).mode;
	_tmp0_ = (*self).func;
	(*dest).func = _tmp0_;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
}

void
plank_animation_mode_mapping_destroy (PlankAnimationModeMapping* self)
{
	_g_free0 ((*self).name);
}

PlankAnimationModeMapping*
plank_animation_mode_mapping_dup (const PlankAnimationModeMapping* self)
{
	PlankAnimationModeMapping* dup;
	dup = g_new0 (PlankAnimationModeMapping, 1);
	plank_animation_mode_mapping_copy (self, dup);
	return dup;
}

void
plank_animation_mode_mapping_free (PlankAnimationModeMapping* self)
{
	plank_animation_mode_mapping_destroy (self);
	g_free (self);
}

static GType
plank_animation_mode_mapping_get_type_once (void)
{
	GType plank_animation_mode_mapping_type_id;
	plank_animation_mode_mapping_type_id = g_boxed_type_register_static ("PlankAnimationModeMapping", (GBoxedCopyFunc) plank_animation_mode_mapping_dup, (GBoxedFreeFunc) plank_animation_mode_mapping_free);
	return plank_animation_mode_mapping_type_id;
}

GType
plank_animation_mode_mapping_get_type (void)
{
	static volatile gsize plank_animation_mode_mapping_type_id__once = 0;
	if (g_once_init_enter (&plank_animation_mode_mapping_type_id__once)) {
		GType plank_animation_mode_mapping_type_id;
		plank_animation_mode_mapping_type_id = plank_animation_mode_mapping_get_type_once ();
		g_once_init_leave (&plank_animation_mode_mapping_type_id__once, plank_animation_mode_mapping_type_id);
	}
	return plank_animation_mode_mapping_type_id__once;
}

static gdouble
_plank_linear_plank_easing_func (gdouble t,
                                 gdouble d)
{
	gdouble result;
	result = plank_linear (t, d);
	return result;
}

static gdouble
_plank_ease_in_quad_plank_easing_func (gdouble t,
                                       gdouble d)
{
	gdouble result;
	result = plank_ease_in_quad (t, d);
	return result;
}

static gdouble
_plank_ease_out_quad_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_out_quad (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_quad_plank_easing_func (gdouble t,
                                           gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_quad (t, d);
	return result;
}

static gdouble
_plank_ease_in_cubic_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_in_cubic (t, d);
	return result;
}

static gdouble
_plank_ease_out_cubic_plank_easing_func (gdouble t,
                                         gdouble d)
{
	gdouble result;
	result = plank_ease_out_cubic (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_cubic_plank_easing_func (gdouble t,
                                            gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_cubic (t, d);
	return result;
}

static gdouble
_plank_ease_in_quart_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_in_quart (t, d);
	return result;
}

static gdouble
_plank_ease_out_quart_plank_easing_func (gdouble t,
                                         gdouble d)
{
	gdouble result;
	result = plank_ease_out_quart (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_quart_plank_easing_func (gdouble t,
                                            gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_quart (t, d);
	return result;
}

static gdouble
_plank_ease_in_quint_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_in_quint (t, d);
	return result;
}

static gdouble
_plank_ease_out_quint_plank_easing_func (gdouble t,
                                         gdouble d)
{
	gdouble result;
	result = plank_ease_out_quint (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_quint_plank_easing_func (gdouble t,
                                            gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_quint (t, d);
	return result;
}

static gdouble
_plank_ease_in_sine_plank_easing_func (gdouble t,
                                       gdouble d)
{
	gdouble result;
	result = plank_ease_in_sine (t, d);
	return result;
}

static gdouble
_plank_ease_out_sine_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_out_sine (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_sine_plank_easing_func (gdouble t,
                                           gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_sine (t, d);
	return result;
}

static gdouble
_plank_ease_in_expo_plank_easing_func (gdouble t,
                                       gdouble d)
{
	gdouble result;
	result = plank_ease_in_expo (t, d);
	return result;
}

static gdouble
_plank_ease_out_expo_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_out_expo (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_expo_plank_easing_func (gdouble t,
                                           gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_expo (t, d);
	return result;
}

static gdouble
_plank_ease_in_circ_plank_easing_func (gdouble t,
                                       gdouble d)
{
	gdouble result;
	result = plank_ease_in_circ (t, d);
	return result;
}

static gdouble
_plank_ease_out_circ_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_out_circ (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_circ_plank_easing_func (gdouble t,
                                           gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_circ (t, d);
	return result;
}

static gdouble
_plank_ease_in_elastic_plank_easing_func (gdouble t,
                                          gdouble d)
{
	gdouble result;
	result = plank_ease_in_elastic (t, d);
	return result;
}

static gdouble
_plank_ease_out_elastic_plank_easing_func (gdouble t,
                                           gdouble d)
{
	gdouble result;
	result = plank_ease_out_elastic (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_elastic_plank_easing_func (gdouble t,
                                              gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_elastic (t, d);
	return result;
}

static gdouble
_plank_ease_in_back_plank_easing_func (gdouble t,
                                       gdouble d)
{
	gdouble result;
	result = plank_ease_in_back (t, d);
	return result;
}

static gdouble
_plank_ease_out_back_plank_easing_func (gdouble t,
                                        gdouble d)
{
	gdouble result;
	result = plank_ease_out_back (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_back_plank_easing_func (gdouble t,
                                           gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_back (t, d);
	return result;
}

static gdouble
_plank_ease_in_bounce_plank_easing_func (gdouble t,
                                         gdouble d)
{
	gdouble result;
	result = plank_ease_in_bounce (t, d);
	return result;
}

static gdouble
_plank_ease_out_bounce_plank_easing_func (gdouble t,
                                          gdouble d)
{
	gdouble result;
	result = plank_ease_out_bounce (t, d);
	return result;
}

static gdouble
_plank_ease_in_out_bounce_plank_easing_func (gdouble t,
                                             gdouble d)
{
	gdouble result;
	result = plank_ease_in_out_bounce (t, d);
	return result;
}

PlankEasingFunc
plank_easing_func_for_mode (PlankAnimationMode mode)
{
	PlankAnimationModeMapping* animation = NULL;
	PlankEasingFunc _tmp0_;
	PlankEasingFunc _tmp1_;
	PlankEasingFunc result;
	animation = &PLANK_ANIMATION_MODES[mode];
	_vala_assert ((*animation).mode == mode, "animation.mode == mode");
	_tmp0_ = (*animation).func;
	_vala_assert (_tmp0_ != NULL, "animation.func != null");
	_tmp1_ = (*animation).func;
	result = _tmp1_;
	return result;
}

const gchar*
plank_easing_name_for_mode (PlankAnimationMode mode)
{
	PlankAnimationModeMapping* animation = NULL;
	PlankEasingFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
	animation = &PLANK_ANIMATION_MODES[mode];
	_vala_assert ((*animation).mode == mode, "animation.mode == mode");
	_tmp0_ = (*animation).func;
	_vala_assert (_tmp0_ != NULL, "animation.func != null");
	_tmp1_ = (*animation).name;
	result = _tmp1_;
	return result;
}

/**
 * Calculate an interpolated value for selected animation-mode, and given
 * elapsed time and total duration.
 *
 * @param mode animation-mode to be used
 * @param t elapsed time
 * @param d total duration
 * @return the interpolated value, between -1.0 and 2.0
 */
gdouble
plank_easing_for_mode (PlankAnimationMode mode,
                       gdouble t,
                       gdouble d)
{
	PlankAnimationModeMapping* animation = NULL;
	PlankEasingFunc _tmp0_;
	PlankEasingFunc _tmp1_;
	gdouble result;
	_vala_return_val_if_fail ((t >= 0.0) && (d > 0.0), "t >= 0.0 && d > 0.0", 0.0);
	_vala_return_val_if_fail (t <= d, "t <= d", 0.0);
	animation = &PLANK_ANIMATION_MODES[mode];
	_vala_assert ((*animation).mode == mode, "animation.mode == mode");
	_tmp0_ = (*animation).func;
	_vala_assert (_tmp0_ != NULL, "animation.func != null");
	_tmp1_ = (*animation).func;
	result = _tmp1_ (t, d);
	_vala_warn_if_fail ((result >= (-1.0)) && (result <= 2.0), "result >= -1.0 && result <= 2.0");
	return result;
}

gdouble
plank_linear (gdouble t,
              gdouble d)
{
	gdouble result;
	result = t / d;
	return result;
}

gdouble
plank_ease_in_quad (gdouble t,
                    gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	result = p * p;
	return result;
}

gdouble
plank_ease_out_quad (gdouble t,
                     gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	result = ((-1.0) * p) * (p - 2);
	return result;
}

gdouble
plank_ease_in_out_quad (gdouble t,
                        gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / (d / 2);
	if (p < ((gdouble) 1)) {
		result = (0.5 * p) * p;
		return result;
	}
	p -= (gdouble) 1;
	result = (-0.5) * ((p * (p - 2)) - 1);
	return result;
}

gdouble
plank_ease_in_cubic (gdouble t,
                     gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	result = (p * p) * p;
	return result;
}

gdouble
plank_ease_out_cubic (gdouble t,
                      gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = (t / d) - 1;
	result = ((p * p) * p) + 1;
	return result;
}

gdouble
plank_ease_in_out_cubic (gdouble t,
                         gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / (d / 2);
	if (p < ((gdouble) 1)) {
		result = ((0.5 * p) * p) * p;
		return result;
	}
	p -= (gdouble) 2;
	result = 0.5 * (((p * p) * p) + 2);
	return result;
}

gdouble
plank_ease_in_quart (gdouble t,
                     gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	result = ((p * p) * p) * p;
	return result;
}

gdouble
plank_ease_out_quart (gdouble t,
                      gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = (t / d) - 1;
	result = (-1.0) * ((((p * p) * p) * p) - 1);
	return result;
}

gdouble
plank_ease_in_out_quart (gdouble t,
                         gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / (d / 2);
	if (p < ((gdouble) 1)) {
		result = (((0.5 * p) * p) * p) * p;
		return result;
	}
	p -= (gdouble) 2;
	result = (-0.5) * ((((p * p) * p) * p) - 2);
	return result;
}

gdouble
plank_ease_in_quint (gdouble t,
                     gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	result = (((p * p) * p) * p) * p;
	return result;
}

gdouble
plank_ease_out_quint (gdouble t,
                      gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = (t / d) - 1;
	result = ((((p * p) * p) * p) * p) + 1;
	return result;
}

gdouble
plank_ease_in_out_quint (gdouble t,
                         gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / (d / 2);
	if (p < ((gdouble) 1)) {
		result = ((((0.5 * p) * p) * p) * p) * p;
		return result;
	}
	p -= (gdouble) 2;
	result = 0.5 * (((((p * p) * p) * p) * p) + 2);
	return result;
}

gdouble
plank_ease_in_sine (gdouble t,
                    gdouble d)
{
	gdouble result;
	result = ((-1.0) * cos ((t / d) * G_PI_2)) + 1.0;
	return result;
}

gdouble
plank_ease_out_sine (gdouble t,
                     gdouble d)
{
	gdouble result;
	result = sin ((t / d) * G_PI_2);
	return result;
}

gdouble
plank_ease_in_out_sine (gdouble t,
                        gdouble d)
{
	gdouble result;
	result = (-0.5) * (cos ((G_PI * t) / d) - 1);
	return result;
}

gdouble
plank_ease_in_expo (gdouble t,
                    gdouble d)
{
	gdouble _tmp0_ = 0.0;
	gdouble result;
	if (t == ((gdouble) 0)) {
		_tmp0_ = 0.0;
	} else {
		_tmp0_ = pow ((gdouble) 2, 10 * ((t / d) - 1));
	}
	result = _tmp0_;
	return result;
}

gdouble
plank_ease_out_expo (gdouble t,
                     gdouble d)
{
	gdouble _tmp0_ = 0.0;
	gdouble result;
	if (t == d) {
		_tmp0_ = 1.0;
	} else {
		_tmp0_ = (-pow ((gdouble) 2, (-10 * t) / d)) + 1;
	}
	result = _tmp0_;
	return result;
}

gdouble
plank_ease_in_out_expo (gdouble t,
                        gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	if (t == ((gdouble) 0)) {
		result = 0.0;
		return result;
	}
	if (t == d) {
		result = 1.0;
		return result;
	}
	p = t / (d / 2);
	if (p < ((gdouble) 1)) {
		result = 0.5 * pow ((gdouble) 2, 10 * (p - 1));
		return result;
	}
	p -= (gdouble) 1;
	result = 0.5 * ((-pow ((gdouble) 2, -10 * p)) + 2);
	return result;
}

gdouble
plank_ease_in_circ (gdouble t,
                    gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	result = (-1.0) * (sqrt (1 - (p * p)) - 1);
	return result;
}

gdouble
plank_ease_out_circ (gdouble t,
                     gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = (t / d) - 1;
	result = sqrt (1 - (p * p));
	return result;
}

gdouble
plank_ease_in_out_circ (gdouble t,
                        gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / (d / 2);
	if (p < ((gdouble) 1)) {
		result = (-0.5) * (sqrt (1 - (p * p)) - 1);
		return result;
	}
	p -= (gdouble) 2;
	result = 0.5 * (sqrt (1 - (p * p)) + 1);
	return result;
}

gdouble
plank_ease_in_elastic (gdouble t,
                       gdouble d)
{
	gdouble p = 0.0;
	gdouble s = 0.0;
	gdouble q = 0.0;
	gdouble result;
	p = d * 0.3;
	s = p / 4;
	q = t / d;
	if (q == ((gdouble) 1)) {
		result = 1.0;
		return result;
	}
	q -= (gdouble) 1;
	result = -(pow ((gdouble) 2, 10 * q) * sin ((((q * d) - s) * (2 * G_PI)) / p));
	return result;
}

gdouble
plank_ease_out_elastic (gdouble t,
                        gdouble d)
{
	gdouble p = 0.0;
	gdouble s = 0.0;
	gdouble q = 0.0;
	gdouble result;
	p = d * 0.3;
	s = p / 4;
	q = t / d;
	if (q == ((gdouble) 1)) {
		result = 1.0;
		return result;
	}
	result = (pow ((gdouble) 2, -10 * q) * sin ((((q * d) - s) * (2 * G_PI)) / p)) + 1.0;
	return result;
}

gdouble
plank_ease_in_out_elastic (gdouble t,
                           gdouble d)
{
	gdouble p = 0.0;
	gdouble s = 0.0;
	gdouble q = 0.0;
	gdouble result;
	p = d * (0.3 * 1.5);
	s = p / 4;
	q = t / (d / 2);
	if (q == ((gdouble) 2)) {
		result = 1.0;
		return result;
	}
	if (q < ((gdouble) 1)) {
		q -= (gdouble) 1;
		result = (-0.5) * (pow ((gdouble) 2, 10 * q) * sin ((((q * d) - s) * (2 * G_PI)) / p));
		return result;
	} else {
		q -= (gdouble) 1;
		result = ((pow ((gdouble) 2, -10 * q) * sin ((((q * d) - s) * (2 * G_PI)) / p)) * 0.5) + 1.0;
		return result;
	}
}

gdouble
plank_ease_in_back (gdouble t,
                    gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	result = (p * p) * (((1.70158 + 1) * p) - 1.70158);
	return result;
}

gdouble
plank_ease_out_back (gdouble t,
                     gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = (t / d) - 1;
	result = ((p * p) * (((1.70158 + 1) * p) + 1.70158)) + 1;
	return result;
}

gdouble
plank_ease_in_out_back (gdouble t,
                        gdouble d)
{
	gdouble p = 0.0;
	gdouble s = 0.0;
	gdouble result;
	p = t / (d / 2);
	s = 1.70158 * 1.525;
	if (p < ((gdouble) 1)) {
		result = 0.5 * ((p * p) * (((s + 1) * p) - s));
		return result;
	}
	p -= (gdouble) 2;
	result = 0.5 * (((p * p) * (((s + 1) * p) + s)) + 2);
	return result;
}

inline gdouble
plank_ease_out_bounce_internal (gdouble t,
                                gdouble d)
{
	gdouble p = 0.0;
	gdouble result;
	p = t / d;
	if (p < (1 / 2.75)) {
		result = (7.5625 * p) * p;
		return result;
	} else {
		if (p < (2 / 2.75)) {
			p -= 1.5 / 2.75;
			result = ((7.5625 * p) * p) + 0.75;
			return result;
		} else {
			if (p < (2.5 / 2.75)) {
				p -= 2.25 / 2.75;
				result = ((7.5625 * p) * p) + 0.9375;
				return result;
			} else {
				p -= 2.625 / 2.75;
				result = ((7.5625 * p) * p) + 0.984375;
				return result;
			}
		}
	}
}

inline gdouble
plank_ease_in_bounce_internal (gdouble t,
                               gdouble d)
{
	gdouble result;
	result = 1.0 - plank_ease_out_bounce_internal (d - t, d);
	return result;
}

gdouble
plank_ease_in_bounce (gdouble t,
                      gdouble d)
{
	gdouble result;
	result = plank_ease_in_bounce_internal (t, d);
	return result;
}

gdouble
plank_ease_out_bounce (gdouble t,
                       gdouble d)
{
	gdouble result;
	result = plank_ease_out_bounce_internal (t, d);
	return result;
}

gdouble
plank_ease_in_out_bounce (gdouble t,
                          gdouble d)
{
	gdouble result;
	if (t < (d / 2)) {
		result = plank_ease_in_bounce_internal (t * 2, d) * 0.5;
		return result;
	} else {
		result = (plank_ease_out_bounce_internal ((t * 2) - d, d) * 0.5) + (1.0 * 0.5);
		return result;
	}
}

