/* ClippyDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from ClippyDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2010-2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <plank.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define DOCKY_TYPE_CLIPPY_DOCK_ITEM (docky_clippy_dock_item_get_type ())
#define DOCKY_CLIPPY_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_CLIPPY_DOCK_ITEM, DockyClippyDockItem))
#define DOCKY_CLIPPY_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCKY_TYPE_CLIPPY_DOCK_ITEM, DockyClippyDockItemClass))
#define DOCKY_IS_CLIPPY_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_CLIPPY_DOCK_ITEM))
#define DOCKY_IS_CLIPPY_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCKY_TYPE_CLIPPY_DOCK_ITEM))
#define DOCKY_CLIPPY_DOCK_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCKY_TYPE_CLIPPY_DOCK_ITEM, DockyClippyDockItemClass))

typedef struct _DockyClippyDockItem DockyClippyDockItem;
typedef struct _DockyClippyDockItemClass DockyClippyDockItemClass;
typedef struct _DockyClippyDockItemPrivate DockyClippyDockItemPrivate;
enum  {
	DOCKY_CLIPPY_DOCK_ITEM_0_PROPERTY,
	DOCKY_CLIPPY_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* docky_clippy_dock_item_properties[DOCKY_CLIPPY_DOCK_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DOCKY_TYPE_CLIPPY_PREFERENCES (docky_clippy_preferences_get_type ())
#define DOCKY_CLIPPY_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_CLIPPY_PREFERENCES, DockyClippyPreferences))
#define DOCKY_CLIPPY_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCKY_TYPE_CLIPPY_PREFERENCES, DockyClippyPreferencesClass))
#define DOCKY_IS_CLIPPY_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_CLIPPY_PREFERENCES))
#define DOCKY_IS_CLIPPY_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCKY_TYPE_CLIPPY_PREFERENCES))
#define DOCKY_CLIPPY_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCKY_TYPE_CLIPPY_PREFERENCES, DockyClippyPreferencesClass))

typedef struct _DockyClippyPreferences DockyClippyPreferences;
typedef struct _DockyClippyPreferencesClass DockyClippyPreferencesClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _DockyClippyDockItem {
	PlankDockletItem parent_instance;
	DockyClippyDockItemPrivate * priv;
};

struct _DockyClippyDockItemClass {
	PlankDockletItemClass parent_class;
};

struct _DockyClippyDockItemPrivate {
	GtkClipboard* clipboard;
	GeeArrayList* clips;
	gint cur_position;
	gulong handler_id;
};

struct _Block1Data {
	int _ref_count_;
	DockyClippyDockItem* self;
	gint pos;
};

static gint DockyClippyDockItem_private_offset;
static gpointer docky_clippy_dock_item_parent_class = NULL;

VALA_EXTERN GType docky_clippy_dock_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyClippyDockItem, g_object_unref)
VALA_EXTERN DockyClippyDockItem* docky_clippy_dock_item_new_with_dockitem_file (GFile* file);
VALA_EXTERN DockyClippyDockItem* docky_clippy_dock_item_construct_with_dockitem_file (GType object_type,
                                                                          GFile* file);
VALA_EXTERN DockyClippyPreferences* docky_clippy_preferences_new_with_file (GFile* file);
VALA_EXTERN DockyClippyPreferences* docky_clippy_preferences_construct_with_file (GType object_type,
                                                                      GFile* file);
VALA_EXTERN GType docky_clippy_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyClippyPreferences, g_object_unref)
static void docky_clippy_dock_item_check_clipboard (GtkClipboard* clipboard,
                                             GdkEvent* event,
                                             DockyClippyDockItem* self);
static void docky_clippy_dock_item_clipboard_text_received (GtkClipboard* clipboard,
                                                     const gchar* text,
                                                     DockyClippyDockItem* self);
VALA_EXTERN guint docky_clippy_preferences_get_MaxEntries (DockyClippyPreferences* self);
static void docky_clippy_dock_item_updated (DockyClippyDockItem* self);
static gchar* docky_clippy_dock_item_get_entry_at (DockyClippyDockItem* self,
                                            gint pos);
static void docky_clippy_dock_item_copy_entry_at (DockyClippyDockItem* self,
                                           gint pos);
static void docky_clippy_dock_item_copy_entry (DockyClippyDockItem* self);
static void docky_clippy_dock_item_clear (DockyClippyDockItem* self);
static PlankAnimationType docky_clippy_dock_item_real_on_scrolled (PlankDockElement* base,
                                                            GdkScrollDirection direction,
                                                            GdkModifierType mod,
                                                            guint32 event_time);
static PlankAnimationType docky_clippy_dock_item_real_on_clicked (PlankDockElement* base,
                                                           PlankPopupButton button,
                                                           GdkModifierType mod,
                                                           guint32 event_time);
static GeeArrayList* docky_clippy_dock_item_real_get_menu_items (PlankDockElement* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _____lambda4_ (Block1Data* _data1_);
static void ______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void _docky_clippy_dock_item_clear_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                           gpointer self);
VALA_EXTERN DockyClippyDockItem* docky_clippy_dock_item_new (void);
VALA_EXTERN DockyClippyDockItem* docky_clippy_dock_item_construct (GType object_type);
static GObject * docky_clippy_dock_item_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN gboolean docky_clippy_preferences_get_TrackMouseSelections (DockyClippyPreferences* self);
static void _docky_clippy_dock_item_check_clipboard_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                         GdkEventOwnerChange* event,
                                                                         gpointer self);
static void docky_clippy_dock_item_finalize (GObject * obj);
static GType docky_clippy_dock_item_get_type_once (void);

static inline gpointer
docky_clippy_dock_item_get_instance_private (DockyClippyDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, DockyClippyDockItem_private_offset);
}

/**
 * {@inheritDoc}
 */
DockyClippyDockItem*
docky_clippy_dock_item_construct_with_dockitem_file (GType object_type,
                                                     GFile* file)
{
	DockyClippyDockItem * self = NULL;
	DockyClippyPreferences* _tmp0_;
	DockyClippyPreferences* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = docky_clippy_preferences_new_with_file (file);
	_tmp1_ = _tmp0_;
	self = (DockyClippyDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

DockyClippyDockItem*
docky_clippy_dock_item_new_with_dockitem_file (GFile* file)
{
	return docky_clippy_dock_item_construct_with_dockitem_file (DOCKY_TYPE_CLIPPY_DOCK_ITEM, file);
}

static void
docky_clippy_dock_item_check_clipboard (GtkClipboard* clipboard,
                                        GdkEvent* event,
                                        DockyClippyDockItem* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	g_return_if_fail (event != NULL);
	gtk_clipboard_request_text (clipboard, (GtkClipboardTextReceivedFunc) docky_clippy_dock_item_clipboard_text_received, self);
}

static void
docky_clippy_dock_item_clipboard_text_received (GtkClipboard* clipboard,
                                                const gchar* text,
                                                DockyClippyDockItem* self)
{
	gboolean _tmp0_ = FALSE;
	DockyClippyPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp1_;
	PlankDockItemPreferences* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	if (text == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (text, "") == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp2_ = _tmp1_;
	prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, DOCKY_TYPE_CLIPPY_PREFERENCES, DockyClippyPreferences);
	_tmp3_ = self->priv->clips;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, text);
	_tmp4_ = self->priv->clips;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, text);
	while (TRUE) {
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		DockyClippyPreferences* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		GeeArrayList* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = self->priv->clips;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = prefs;
		_tmp9_ = docky_clippy_preferences_get_MaxEntries (_tmp8_);
		_tmp10_ = _tmp9_;
		if (!(((guint) _tmp7_) > _tmp10_)) {
			break;
		}
		_tmp11_ = self->priv->clips;
		_tmp12_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp11_, 0);
		_tmp13_ = (gchar*) _tmp12_;
		_g_free0 (_tmp13_);
	}
	_tmp14_ = self->priv->clips;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	self->priv->cur_position = _tmp16_;
	docky_clippy_dock_item_updated (self);
}

static void
docky_clippy_dock_item_updated (DockyClippyDockItem* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clips;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		plank_dock_element_set_Text ((PlankDockElement*) self, _ ("Clipboard is currently empty."));
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->cur_position == 0) {
			_tmp3_ = TRUE;
		} else {
			GeeArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			_tmp4_ = self->priv->clips;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp3_ = self->priv->cur_position > _tmp6_;
		}
		if (_tmp3_) {
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = self->priv->clips;
			_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = docky_clippy_dock_item_get_entry_at (self, _tmp9_);
			_tmp11_ = _tmp10_;
			plank_dock_element_set_Text ((PlankDockElement*) self, _tmp11_);
			_g_free0 (_tmp11_);
		} else {
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = docky_clippy_dock_item_get_entry_at (self, self->priv->cur_position);
			_tmp13_ = _tmp12_;
			plank_dock_element_set_Text ((PlankDockElement*) self, _tmp13_);
			_g_free0 (_tmp13_);
		}
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
docky_clippy_dock_item_get_entry_at (DockyClippyDockItem* self,
                                     gint pos)
{
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->clips;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, pos - 1);
	_tmp2_ = (gchar*) _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "\n", "");
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "\t", "");
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static void
docky_clippy_dock_item_copy_entry_at (DockyClippyDockItem* self,
                                      gint pos)
{
	gboolean _tmp0_ = FALSE;
	gchar* str = NULL;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	GtkClipboard* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	if (pos < 1) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->clips;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = pos > _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->clips;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, pos - 1);
	str = (gchar*) _tmp5_;
	_tmp6_ = self->priv->clipboard;
	_tmp7_ = str;
	_tmp8_ = str;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_clipboard_set_text (_tmp6_, _tmp7_, (gint) _tmp10_);
	docky_clippy_dock_item_updated (self);
	_g_free0 (str);
}

static void
docky_clippy_dock_item_copy_entry (DockyClippyDockItem* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->cur_position == 0) {
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->clips;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		docky_clippy_dock_item_copy_entry_at (self, _tmp2_);
	} else {
		docky_clippy_dock_item_copy_entry_at (self, self->priv->cur_position);
	}
}

static void
docky_clippy_dock_item_clear (DockyClippyDockItem* self)
{
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clipboard;
	gtk_clipboard_set_text (_tmp0_, "", 0);
	_tmp1_ = self->priv->clipboard;
	gtk_clipboard_clear (_tmp1_);
	_tmp2_ = self->priv->clips;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	self->priv->cur_position = 0;
	docky_clippy_dock_item_updated (self);
}

static PlankAnimationType
docky_clippy_dock_item_real_on_scrolled (PlankDockElement* base,
                                         GdkScrollDirection direction,
                                         GdkModifierType mod,
                                         guint32 event_time)
{
	DockyClippyDockItem * self;
	PlankAnimationType result;
	self = (DockyClippyDockItem*) base;
	if (direction == GDK_SCROLL_UP) {
		gint _tmp0_;
		_tmp0_ = self->priv->cur_position;
		self->priv->cur_position = _tmp0_ + 1;
	} else {
		gint _tmp1_;
		_tmp1_ = self->priv->cur_position;
		self->priv->cur_position = _tmp1_ - 1;
	}
	if (self->priv->cur_position < 1) {
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->clips;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		self->priv->cur_position = _tmp4_;
	} else {
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->clips;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (self->priv->cur_position > _tmp7_) {
			self->priv->cur_position = 1;
		}
	}
	docky_clippy_dock_item_updated (self);
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

static PlankAnimationType
docky_clippy_dock_item_real_on_clicked (PlankDockElement* base,
                                        PlankPopupButton button,
                                        GdkModifierType mod,
                                        guint32 event_time)
{
	DockyClippyDockItem * self;
	gboolean _tmp0_ = FALSE;
	PlankAnimationType result;
	self = (DockyClippyDockItem*) base;
	if (button == PLANK_POPUP_BUTTON_LEFT) {
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->clips;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		docky_clippy_dock_item_copy_entry (self);
		result = PLANK_ANIMATION_TYPE_BOUNCE;
		return result;
	}
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DockyClippyDockItem* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_____lambda4_ (Block1Data* _data1_)
{
	DockyClippyDockItem* self;
	self = _data1_->self;
	docky_clippy_dock_item_copy_entry_at (self, _data1_->pos);
}

static void
______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	_____lambda4_ (self);
}

static void
_docky_clippy_dock_item_clear_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                      gpointer self)
{
	docky_clippy_dock_item_clear ((DockyClippyDockItem*) self);
}

static GeeArrayList*
docky_clippy_dock_item_real_get_menu_items (PlankDockElement* base)
{
	DockyClippyDockItem * self;
	GeeArrayList* items = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeArrayList* result;
	self = (DockyClippyDockItem*) base;
	_tmp0_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	items = _tmp0_;
	{
		gint i = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->clips;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				Block1Data* _data1_;
				GtkMenuItem* item = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				gchar* _tmp8_;
				GtkMenuItem* _tmp9_;
				GtkMenuItem* _tmp10_;
				GtkMenuItem* _tmp11_;
				GeeArrayList* _tmp12_;
				GtkMenuItem* _tmp13_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i > 0)) {
					block1_data_unref (_data1_);
					_data1_ = NULL;
					break;
				}
				_tmp6_ = self->priv->clips;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, i - 1);
				_tmp8_ = (gchar*) _tmp7_;
				_tmp9_ = plank_dock_element_create_literal_menu_item (_tmp8_, "edit-cut", TRUE);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				item = _tmp10_;
				_data1_->pos = i;
				_tmp11_ = item;
				g_signal_connect_data (_tmp11_, "activate", (GCallback) ______lambda4__gtk_menu_item_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				_tmp12_ = items;
				_tmp13_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				_g_object_unref0 (item);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
	}
	_tmp14_ = self->priv->clips;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ > 0) {
		GtkMenuItem* item = NULL;
		GtkMenuItem* _tmp17_;
		GtkMenuItem* _tmp18_;
		GeeArrayList* _tmp19_;
		GtkMenuItem* _tmp20_;
		_tmp17_ = plank_dock_element_create_menu_item (_ ("_Clear"), "edit-clear-all", TRUE);
		item = _tmp17_;
		_tmp18_ = item;
		g_signal_connect_object (_tmp18_, "activate", (GCallback) _docky_clippy_dock_item_clear_gtk_menu_item_activate, self, 0);
		_tmp19_ = items;
		_tmp20_ = item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
		_g_object_unref0 (item);
	}
	result = items;
	return result;
}

DockyClippyDockItem*
docky_clippy_dock_item_construct (GType object_type)
{
	DockyClippyDockItem * self = NULL;
	self = (DockyClippyDockItem*) plank_docklet_item_construct (object_type);
	return self;
}

DockyClippyDockItem*
docky_clippy_dock_item_new (void)
{
	return docky_clippy_dock_item_construct (DOCKY_TYPE_CLIPPY_DOCK_ITEM);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_docky_clippy_dock_item_check_clipboard_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                    GdkEventOwnerChange* event,
                                                                    gpointer self)
{
	docky_clippy_dock_item_check_clipboard (_sender, event, (DockyClippyDockItem*) self);
}

static GObject *
docky_clippy_dock_item_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DockyClippyDockItem * self;
	DockyClippyPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	DockyClippyPreferences* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeArrayList* _tmp9_;
	GtkClipboard* _tmp10_;
	gulong _tmp11_;
	parent_class = G_OBJECT_CLASS (docky_clippy_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_CLIPPY_DOCK_ITEM, DockyClippyDockItem);
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	prefs = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, DOCKY_TYPE_CLIPPY_PREFERENCES, DockyClippyPreferences);
	plank_dock_item_set_Icon ((PlankDockItem*) self, "edit-cut");
	_tmp2_ = prefs;
	_tmp3_ = docky_clippy_preferences_get_TrackMouseSelections (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkClipboard* _tmp5_;
		GtkClipboard* _tmp6_;
		_tmp5_ = gtk_clipboard_get (gdk_atom_intern ("PRIMARY", TRUE));
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (self->priv->clipboard);
		self->priv->clipboard = _tmp6_;
	} else {
		GtkClipboard* _tmp7_;
		GtkClipboard* _tmp8_;
		_tmp7_ = gtk_clipboard_get (gdk_atom_intern ("CLIPBOARD", TRUE));
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (self->priv->clipboard);
		self->priv->clipboard = _tmp8_;
	}
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->clips);
	self->priv->clips = _tmp9_;
	_tmp10_ = self->priv->clipboard;
	_tmp11_ = g_signal_connect_object (_tmp10_, "owner-change", (GCallback) _docky_clippy_dock_item_check_clipboard_gtk_clipboard_owner_change, self, 0);
	self->priv->handler_id = _tmp11_;
	docky_clippy_dock_item_updated (self);
	return obj;
}

static void
docky_clippy_dock_item_class_init (DockyClippyDockItemClass * klass,
                                   gpointer klass_data)
{
	docky_clippy_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DockyClippyDockItem_private_offset);
	((PlankDockElementClass *) klass)->on_scrolled = (PlankAnimationType (*) (PlankDockElement*, GdkScrollDirection, GdkModifierType, guint32)) docky_clippy_dock_item_real_on_scrolled;
	((PlankDockElementClass *) klass)->on_clicked = (PlankAnimationType (*) (PlankDockElement*, PlankPopupButton, GdkModifierType, guint32)) docky_clippy_dock_item_real_on_clicked;
	((PlankDockElementClass *) klass)->get_menu_items = (GeeArrayList* (*) (PlankDockElement*)) docky_clippy_dock_item_real_get_menu_items;
	G_OBJECT_CLASS (klass)->constructor = docky_clippy_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = docky_clippy_dock_item_finalize;
}

static void
docky_clippy_dock_item_instance_init (DockyClippyDockItem * self,
                                      gpointer klass)
{
	self->priv = docky_clippy_dock_item_get_instance_private (self);
	self->priv->cur_position = 0;
	self->priv->handler_id = (gulong) 0U;
}

static void
docky_clippy_dock_item_finalize (GObject * obj)
{
	DockyClippyDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_CLIPPY_DOCK_ITEM, DockyClippyDockItem);
	if (self->priv->handler_id > ((gulong) 0U)) {
		GtkClipboard* _tmp0_;
		_tmp0_ = self->priv->clipboard;
		g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->handler_id);
	}
	_g_object_unref0 (self->priv->clipboard);
	_g_object_unref0 (self->priv->clips);
	G_OBJECT_CLASS (docky_clippy_dock_item_parent_class)->finalize (obj);
}

static GType
docky_clippy_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DockyClippyDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) docky_clippy_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockyClippyDockItem), 0, (GInstanceInitFunc) docky_clippy_dock_item_instance_init, NULL };
	GType docky_clippy_dock_item_type_id;
	docky_clippy_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCKLET_ITEM, "DockyClippyDockItem", &g_define_type_info, 0);
	DockyClippyDockItem_private_offset = g_type_add_instance_private (docky_clippy_dock_item_type_id, sizeof (DockyClippyDockItemPrivate));
	return docky_clippy_dock_item_type_id;
}

GType
docky_clippy_dock_item_get_type (void)
{
	static volatile gsize docky_clippy_dock_item_type_id__once = 0;
	if (g_once_init_enter (&docky_clippy_dock_item_type_id__once)) {
		GType docky_clippy_dock_item_type_id;
		docky_clippy_dock_item_type_id = docky_clippy_dock_item_get_type_once ();
		g_once_init_leave (&docky_clippy_dock_item_type_id__once, docky_clippy_dock_item_type_id);
	}
	return docky_clippy_dock_item_type_id__once;
}

