/* SettingsPopover.c generated by valac 0.56.17, the Vala compiler
 * generated from SettingsPopover.vala, do not modify */

/*-
 * Copyright 2013-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gst/tag/tag.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER (audience_widgets_settings_popover_get_type ())
#define AUDIENCE_WIDGETS_SETTINGS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopover))
#define AUDIENCE_WIDGETS_SETTINGS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopoverClass))
#define AUDIENCE_WIDGETS_IS_SETTINGS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER))
#define AUDIENCE_WIDGETS_IS_SETTINGS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER))
#define AUDIENCE_WIDGETS_SETTINGS_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopoverClass))

typedef struct _AudienceWidgetsSettingsPopover AudienceWidgetsSettingsPopover;
typedef struct _AudienceWidgetsSettingsPopoverClass AudienceWidgetsSettingsPopoverClass;
typedef struct _AudienceWidgetsSettingsPopoverPrivate AudienceWidgetsSettingsPopoverPrivate;
enum  {
	AUDIENCE_WIDGETS_SETTINGS_POPOVER_0_PROPERTY,
	AUDIENCE_WIDGETS_SETTINGS_POPOVER_NUM_PROPERTIES
};
static GParamSpec* audience_widgets_settings_popover_properties[AUDIENCE_WIDGETS_SETTINGS_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;

struct _AudienceWidgetsSettingsPopover {
	GtkPopover parent_instance;
	AudienceWidgetsSettingsPopoverPrivate * priv;
	gboolean is_setup;
};

struct _AudienceWidgetsSettingsPopoverClass {
	GtkPopoverClass parent_class;
};

struct _AudienceWidgetsSettingsPopoverPrivate {
	GtkComboBoxText* languages;
	GtkComboBoxText* subtitles;
	GtkLabel* external_subtitle_file_label;
};

struct _Block20Data {
	int _ref_count_;
	AudienceWidgetsSettingsPopover* self;
	GtkFileChooserNative* file;
};

struct _Block21Data {
	int _ref_count_;
	AudienceWidgetsSettingsPopover* self;
	guint track;
};

struct _Block22Data {
	int _ref_count_;
	AudienceWidgetsSettingsPopover* self;
	guint track;
};

static gint AudienceWidgetsSettingsPopover_private_offset;
static gpointer audience_widgets_settings_popover_parent_class = NULL;

VALA_EXTERN GType audience_widgets_settings_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWidgetsSettingsPopover, g_object_unref)
static void audience_widgets_settings_popover_set_external_subtitel_label (AudienceWidgetsSettingsPopover* self);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN const gchar* audience_playback_manager_get_subtitle_uri (AudiencePlaybackManager* self);
static void audience_widgets_settings_popover_get_external_subtitle_file (AudienceWidgetsSettingsPopover* self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda44_ (Block20Data* _data20_,
                  gint response);
VALA_EXTERN void audience_playback_manager_set_subtitle (AudiencePlaybackManager* self,
                                             const gchar* uri);
static void ___lambda44__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void audience_widgets_settings_popover_setup (AudienceWidgetsSettingsPopover* self);
static void audience_widgets_settings_popover_setup_text (AudienceWidgetsSettingsPopover* self);
static void audience_widgets_settings_popover_setup_audio (AudienceWidgetsSettingsPopover* self);
static void audience_widgets_settings_popover_on_subtitles_changed (AudienceWidgetsSettingsPopover* self);
VALA_EXTERN void audience_playback_manager_set_subtitle_track (AudiencePlaybackManager* self,
                                                   gint track);
static void audience_widgets_settings_popover_on_languages_changed (AudienceWidgetsSettingsPopover* self);
VALA_EXTERN void audience_playback_manager_set_audio_track (AudiencePlaybackManager* self,
                                                gint track);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void _audience_widgets_settings_popover_on_subtitles_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                    gpointer self);
VALA_EXTERN GList* audience_playback_manager_get_subtitle_tracks (AudiencePlaybackManager* self);
static void __lambda45_ (Block21Data* _data21_,
                  const gchar* lang);
static void ___lambda45__gfunc (gconstpointer data,
                         gpointer self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN gint audience_playback_manager_get_subtitle_track (AudiencePlaybackManager* self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void _audience_widgets_settings_popover_on_languages_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                    gpointer self);
VALA_EXTERN GList* audience_playback_manager_get_audio_tracks (AudiencePlaybackManager* self);
static void __lambda46_ (Block22Data* _data22_,
                  const gchar* language_code);
static void ___lambda46__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN gint audience_playback_manager_get_audio_track (AudiencePlaybackManager* self);
static void audience_widgets_settings_popover_next_audio (AudienceWidgetsSettingsPopover* self);
static void audience_widgets_settings_popover_next_text (AudienceWidgetsSettingsPopover* self);
VALA_EXTERN AudienceWidgetsSettingsPopover* audience_widgets_settings_popover_new (void);
VALA_EXTERN AudienceWidgetsSettingsPopover* audience_widgets_settings_popover_construct (GType object_type);
static GObject * audience_widgets_settings_popover_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _audience_widgets_settings_popover_next_audio_audience_playback_manager_next_audio (AudiencePlaybackManager* _sender,
                                                                                         gpointer self);
static void _audience_widgets_settings_popover_next_text_audience_playback_manager_next_text (AudiencePlaybackManager* _sender,
                                                                                       gpointer self);
static void _audience_widgets_settings_popover_get_external_subtitle_file_gtk_button_clicked (GtkButton* _sender,
                                                                                       gpointer self);
static void _audience_widgets_settings_popover_set_external_subtitel_label_g_object_notify (GObject* _sender,
                                                                                     GParamSpec* pspec,
                                                                                     gpointer self);
static void _audience_widgets_settings_popover___lambda47_ (AudienceWidgetsSettingsPopover* self);
static void __audience_widgets_settings_popover___lambda47__audience_playback_manager_uri_changed (AudiencePlaybackManager* _sender,
                                                                                            const gchar* uri,
                                                                                            gpointer self);
static void _audience_widgets_settings_popover___lambda48_ (AudienceWidgetsSettingsPopover* self);
static void __audience_widgets_settings_popover___lambda48__gtk_widget_map (GtkWidget* _sender,
                                                                     gpointer self);
static void audience_widgets_settings_popover_finalize (GObject * obj);
static GType audience_widgets_settings_popover_get_type_once (void);

static inline gpointer
audience_widgets_settings_popover_get_instance_private (AudienceWidgetsSettingsPopover* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceWidgetsSettingsPopover_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
audience_widgets_settings_popover_set_external_subtitel_label (AudienceWidgetsSettingsPopover* self)
{
	AudiencePlaybackManager* playback_manager = NULL;
	AudiencePlaybackManager* _tmp0_;
	AudiencePlaybackManager* _tmp1_;
	AudiencePlaybackManager* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = audience_playback_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	playback_manager = _tmp1_;
	_tmp2_ = playback_manager;
	_tmp3_ = audience_playback_manager_get_subtitle_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		GFile* file = NULL;
		AudiencePlaybackManager* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GtkLabel* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp5_ = playback_manager;
		_tmp6_ = audience_playback_manager_get_subtitle_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_new_for_uri (_tmp7_);
		file = _tmp8_;
		_tmp9_ = self->priv->external_subtitle_file_label;
		_tmp10_ = file;
		_tmp11_ = g_file_get_basename (_tmp10_);
		_tmp12_ = _tmp11_;
		gtk_label_set_label (_tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_object_unref0 (file);
	} else {
		GtkLabel* _tmp13_;
		_tmp13_ = self->priv->external_subtitle_file_label;
		gtk_label_set_label (_tmp13_, _ ("None"));
	}
	_g_object_unref0 (playback_manager);
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		AudienceWidgetsSettingsPopover* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->file);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
__lambda44_ (Block20Data* _data20_,
             gint response)
{
	AudienceWidgetsSettingsPopover* self;
	self = _data20_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		AudiencePlaybackManager* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = audience_playback_manager_get_default ();
		_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data20_->file);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		audience_playback_manager_set_subtitle (_tmp0_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
	}
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data20_->file);
}

static void
___lambda44__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda44_ (self, response_id);
}

static void
audience_widgets_settings_popover_get_external_subtitle_file (AudienceWidgetsSettingsPopover* self)
{
	Block20Data* _data20_;
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* subtitle_files_filter = NULL;
	GtkFileFilter* _tmp1_;
	GtkRoot* _tmp2_;
	GtkFileChooserNative* _tmp3_;
	g_return_if_fail (self != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp0_ = gtk_file_filter_new ();
	all_files_filter = _tmp0_;
	gtk_file_filter_set_name (all_files_filter, _ ("All files"));
	gtk_file_filter_add_pattern (all_files_filter, "*");
	_tmp1_ = gtk_file_filter_new ();
	subtitle_files_filter = _tmp1_;
	gtk_file_filter_set_name (subtitle_files_filter, _ ("Subtitle files"));
	gtk_file_filter_add_mime_type (subtitle_files_filter, "application/smil");
	gtk_file_filter_add_mime_type (subtitle_files_filter, "application/x-subrip");
	gtk_file_filter_add_mime_type (subtitle_files_filter, "text/x-microdvd");
	gtk_file_filter_add_mime_type (subtitle_files_filter, "text/x-ssa");
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp3_ = gtk_file_chooser_native_new (_ ("Open"), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Open"), _ ("_Cancel"));
	_data20_->file = _tmp3_;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _data20_->file, FALSE);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data20_->file, subtitle_files_filter);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data20_->file, all_files_filter);
	g_signal_connect_data ((GtkNativeDialog*) _data20_->file, "response", (GCallback) ___lambda44__gtk_native_dialog_response, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data20_->file);
	_g_object_unref0 (subtitle_files_filter);
	_g_object_unref0 (all_files_filter);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static void
audience_widgets_settings_popover_setup (AudienceWidgetsSettingsPopover* self)
{
	g_return_if_fail (self != NULL);
	if (!self->is_setup) {
		self->is_setup = TRUE;
		audience_widgets_settings_popover_setup_text (self);
		audience_widgets_settings_popover_setup_audio (self);
	}
}

static void
audience_widgets_settings_popover_on_subtitles_changed (AudienceWidgetsSettingsPopover* self)
{
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkComboBoxText* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->subtitles;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 0) {
		return;
	}
	_tmp3_ = self->priv->subtitles;
	_tmp4_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp5_, "none") == 0) {
		AudiencePlaybackManager* _tmp6_;
		_tmp6_ = audience_playback_manager_get_default ();
		audience_playback_manager_set_subtitle_track (_tmp6_, -1);
	} else {
		AudiencePlaybackManager* _tmp7_;
		GtkComboBoxText* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = audience_playback_manager_get_default ();
		_tmp8_ = self->priv->subtitles;
		_tmp9_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp8_);
		_tmp10_ = _tmp9_;
		audience_playback_manager_set_subtitle_track (_tmp7_, _tmp10_);
	}
}

static void
audience_widgets_settings_popover_on_languages_changed (AudienceWidgetsSettingsPopover* self)
{
	gboolean _tmp0_ = FALSE;
	GtkComboBoxText* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	AudiencePlaybackManager* _tmp7_;
	GtkComboBoxText* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->languages;
	_tmp2_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 0) {
		_tmp0_ = TRUE;
	} else {
		GtkComboBoxText* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->languages;
		_tmp5_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp6_, "def") == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = audience_playback_manager_get_default ();
	_tmp8_ = self->priv->languages;
	_tmp9_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp8_);
	_tmp10_ = _tmp9_;
	audience_playback_manager_set_audio_track (_tmp7_, _tmp10_);
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		AudienceWidgetsSettingsPopover* self;
		self = _data21_->self;
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
_audience_widgets_settings_popover_on_subtitles_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                               gpointer self)
{
	audience_widgets_settings_popover_on_subtitles_changed ((AudienceWidgetsSettingsPopover*) self);
}

static void
__lambda45_ (Block21Data* _data21_,
             const gchar* lang)
{
	AudienceWidgetsSettingsPopover* self;
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = _data21_->self;
	g_return_if_fail (lang != NULL);
	_tmp0_ = self->priv->subtitles;
	_tmp1_ = lang;
	_tmp2_ = _data21_->track;
	_data21_->track = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf (_ ("Track %u"), _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_combo_box_text_append (_tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}

static void
___lambda45__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda45_ (self, (const gchar*) data);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
audience_widgets_settings_popover_setup_text (AudienceWidgetsSettingsPopover* self)
{
	Block21Data* _data21_;
	GtkComboBoxText* _tmp0_;
	guint _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	AudiencePlaybackManager* playback_manager = NULL;
	AudiencePlaybackManager* _tmp6_;
	AudiencePlaybackManager* _tmp7_;
	AudiencePlaybackManager* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GtkComboBoxText* _tmp11_;
	gint count = 0;
	GtkComboBoxText* _tmp12_;
	GtkTreeModel* _tmp13_;
	GtkTreeModel* _tmp14_;
	GtkComboBoxText* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GtkComboBoxText* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GtkComboBoxText* _tmp24_;
	g_return_if_fail (self != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = self->priv->subtitles;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _audience_widgets_settings_popover_on_subtitles_changed_gtk_combo_box_changed, self);
	_tmp2_ = self->priv->subtitles;
	_tmp3_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (gtk_tree_model_iter_n_children (_tmp4_, NULL) > 0) {
		GtkComboBoxText* _tmp5_;
		_tmp5_ = self->priv->subtitles;
		gtk_combo_box_text_remove_all (_tmp5_);
	}
	_tmp6_ = audience_playback_manager_get_default ();
	_tmp7_ = _g_object_ref0 (_tmp6_);
	playback_manager = _tmp7_;
	_data21_->track = (guint) 1;
	_tmp8_ = playback_manager;
	_tmp9_ = audience_playback_manager_get_subtitle_tracks (_tmp8_);
	_tmp10_ = _tmp9_;
	g_list_foreach (_tmp10_, ___lambda45__gfunc, _data21_);
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (_g_list_free__g_free0_ (_tmp10_), NULL));
	_tmp11_ = self->priv->subtitles;
	gtk_combo_box_text_append (_tmp11_, "none", _ ("None"));
	_tmp12_ = self->priv->subtitles;
	_tmp13_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp12_);
	_tmp14_ = _tmp13_;
	count = gtk_tree_model_iter_n_children (_tmp14_, NULL);
	_tmp15_ = self->priv->subtitles;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, count > 1);
	_tmp17_ = self->priv->subtitles;
	_tmp18_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		AudiencePlaybackManager* _tmp20_;
		_tmp20_ = playback_manager;
		_tmp16_ = audience_playback_manager_get_subtitle_track (_tmp20_) >= 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GtkComboBoxText* _tmp21_;
		AudiencePlaybackManager* _tmp22_;
		_tmp21_ = self->priv->subtitles;
		_tmp22_ = playback_manager;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp21_, audience_playback_manager_get_subtitle_track (_tmp22_));
	} else {
		GtkComboBoxText* _tmp23_;
		_tmp23_ = self->priv->subtitles;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp23_, count - 1);
	}
	_tmp24_ = self->priv->subtitles;
	g_signal_connect_object ((GtkComboBox*) _tmp24_, "changed", (GCallback) _audience_widgets_settings_popover_on_subtitles_changed_gtk_combo_box_changed, self, 0);
	_g_object_unref0 (playback_manager);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		AudienceWidgetsSettingsPopover* self;
		self = _data22_->self;
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
_audience_widgets_settings_popover_on_languages_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                               gpointer self)
{
	audience_widgets_settings_popover_on_languages_changed ((AudienceWidgetsSettingsPopover*) self);
}

static void
__lambda46_ (Block22Data* _data22_,
             const gchar* language_code)
{
	AudienceWidgetsSettingsPopover* self;
	gchar* audio_stream_lang = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	guint _tmp8_;
	self = _data22_->self;
	g_return_if_fail (language_code != NULL);
	_tmp0_ = gst_tag_get_language_name (language_code);
	_tmp1_ = g_strdup (_tmp0_);
	audio_stream_lang = _tmp1_;
	_tmp2_ = audio_stream_lang;
	if (_tmp2_ != NULL) {
		GtkComboBoxText* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->languages;
		_tmp4_ = audio_stream_lang;
		gtk_combo_box_text_append (_tmp3_, language_code, _tmp4_);
	} else {
		GtkComboBoxText* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->languages;
		_tmp6_ = g_strdup_printf (_ ("Track %u"), _data22_->track);
		_tmp7_ = _tmp6_;
		gtk_combo_box_text_append (_tmp5_, language_code, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = _data22_->track;
	_data22_->track = _tmp8_ + 1;
	_g_free0 (audio_stream_lang);
}

static void
___lambda46__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda46_ (self, (const gchar*) data);
}

static void
audience_widgets_settings_popover_setup_audio (AudienceWidgetsSettingsPopover* self)
{
	Block22Data* _data22_;
	GtkComboBoxText* _tmp0_;
	guint _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	AudiencePlaybackManager* playback_manager = NULL;
	AudiencePlaybackManager* _tmp6_;
	AudiencePlaybackManager* _tmp7_;
	AudiencePlaybackManager* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	gint count = 0;
	GtkComboBoxText* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeModel* _tmp13_;
	GtkComboBoxText* _tmp14_;
	GtkComboBoxText* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GtkComboBoxText* _tmp23_;
	g_return_if_fail (self != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = self->priv->languages;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkComboBox*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _audience_widgets_settings_popover_on_languages_changed_gtk_combo_box_changed, self);
	_tmp2_ = self->priv->languages;
	_tmp3_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (gtk_tree_model_iter_n_children (_tmp4_, NULL) > 0) {
		GtkComboBoxText* _tmp5_;
		_tmp5_ = self->priv->languages;
		gtk_combo_box_text_remove_all (_tmp5_);
	}
	_tmp6_ = audience_playback_manager_get_default ();
	_tmp7_ = _g_object_ref0 (_tmp6_);
	playback_manager = _tmp7_;
	_data22_->track = (guint) 1;
	_tmp8_ = playback_manager;
	_tmp9_ = audience_playback_manager_get_audio_tracks (_tmp8_);
	_tmp10_ = _tmp9_;
	g_list_foreach (_tmp10_, ___lambda46__gfunc, _data22_);
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (_g_list_free__g_free0_ (_tmp10_), NULL));
	_tmp11_ = self->priv->languages;
	_tmp12_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp11_);
	_tmp13_ = _tmp12_;
	count = gtk_tree_model_iter_n_children (_tmp13_, NULL);
	_tmp14_ = self->priv->languages;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, count > 1);
	_tmp15_ = self->priv->languages;
	_tmp16_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		GtkComboBoxText* _tmp18_;
		AudiencePlaybackManager* _tmp19_;
		_tmp18_ = self->priv->languages;
		_tmp19_ = playback_manager;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp18_, audience_playback_manager_get_audio_track (_tmp19_));
	} else {
		GtkComboBoxText* _tmp21_;
		GtkComboBoxText* _tmp22_;
		if (count != 0) {
			GtkComboBoxText* _tmp20_;
			_tmp20_ = self->priv->languages;
			gtk_combo_box_text_remove_all (_tmp20_);
		}
		_tmp21_ = self->priv->languages;
		gtk_combo_box_text_append (_tmp21_, "def", _ ("Default"));
		_tmp22_ = self->priv->languages;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp22_, 0);
	}
	_tmp23_ = self->priv->languages;
	g_signal_connect_object ((GtkComboBox*) _tmp23_, "changed", (GCallback) _audience_widgets_settings_popover_on_languages_changed_gtk_combo_box_changed, self, 0);
	_g_object_unref0 (playback_manager);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static void
audience_widgets_settings_popover_next_audio (AudienceWidgetsSettingsPopover* self)
{
	gint count = 0;
	GtkComboBoxText* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	g_return_if_fail (self != NULL);
	audience_widgets_settings_popover_setup (self);
	_tmp0_ = self->priv->languages;
	_tmp1_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	count = gtk_tree_model_iter_n_children (_tmp2_, NULL);
	if (count > 0) {
		GtkComboBoxText* _tmp3_;
		GtkComboBoxText* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = self->priv->languages;
		_tmp4_ = self->priv->languages;
		_tmp5_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp4_);
		_tmp6_ = _tmp5_;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp3_, (_tmp6_ + 1) % count);
	}
}

static void
audience_widgets_settings_popover_next_text (AudienceWidgetsSettingsPopover* self)
{
	gint count = 0;
	GtkComboBoxText* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	g_return_if_fail (self != NULL);
	audience_widgets_settings_popover_setup (self);
	_tmp0_ = self->priv->subtitles;
	_tmp1_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	count = gtk_tree_model_iter_n_children (_tmp2_, NULL);
	if (count > 0) {
		GtkComboBoxText* _tmp3_;
		GtkComboBoxText* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = self->priv->subtitles;
		_tmp4_ = self->priv->subtitles;
		_tmp5_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp4_);
		_tmp6_ = _tmp5_;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp3_, (_tmp6_ + 1) % count);
	}
}

AudienceWidgetsSettingsPopover*
audience_widgets_settings_popover_construct (GType object_type)
{
	AudienceWidgetsSettingsPopover * self = NULL;
	self = (AudienceWidgetsSettingsPopover*) g_object_new (object_type, NULL);
	return self;
}

AudienceWidgetsSettingsPopover*
audience_widgets_settings_popover_new (void)
{
	return audience_widgets_settings_popover_construct (AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER);
}

static void
_audience_widgets_settings_popover_next_audio_audience_playback_manager_next_audio (AudiencePlaybackManager* _sender,
                                                                                    gpointer self)
{
	audience_widgets_settings_popover_next_audio ((AudienceWidgetsSettingsPopover*) self);
}

static void
_audience_widgets_settings_popover_next_text_audience_playback_manager_next_text (AudiencePlaybackManager* _sender,
                                                                                  gpointer self)
{
	audience_widgets_settings_popover_next_text ((AudienceWidgetsSettingsPopover*) self);
}

static void
_audience_widgets_settings_popover_get_external_subtitle_file_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self)
{
	audience_widgets_settings_popover_get_external_subtitle_file ((AudienceWidgetsSettingsPopover*) self);
}

static void
_audience_widgets_settings_popover_set_external_subtitel_label_g_object_notify (GObject* _sender,
                                                                                GParamSpec* pspec,
                                                                                gpointer self)
{
	audience_widgets_settings_popover_set_external_subtitel_label ((AudienceWidgetsSettingsPopover*) self);
}

static void
_audience_widgets_settings_popover___lambda47_ (AudienceWidgetsSettingsPopover* self)
{
	self->is_setup = FALSE;
}

static void
__audience_widgets_settings_popover___lambda47__audience_playback_manager_uri_changed (AudiencePlaybackManager* _sender,
                                                                                       const gchar* uri,
                                                                                       gpointer self)
{
	_audience_widgets_settings_popover___lambda47_ ((AudienceWidgetsSettingsPopover*) self);
}

static void
_audience_widgets_settings_popover___lambda48_ (AudienceWidgetsSettingsPopover* self)
{
	audience_widgets_settings_popover_setup (self);
}

static void
__audience_widgets_settings_popover___lambda48__gtk_widget_map (GtkWidget* _sender,
                                                                gpointer self)
{
	_audience_widgets_settings_popover___lambda48_ ((AudienceWidgetsSettingsPopover*) self);
}

static GObject *
audience_widgets_settings_popover_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceWidgetsSettingsPopover * self;
	GtkComboBoxText* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkLabel* _tmp2_;
	GtkImage* external_subtitle_file_image = NULL;
	GtkImage* _tmp3_;
	GtkBox* external_subtitle_file_box = NULL;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	GtkBox* _tmp7_;
	GtkSeparator* _tmp8_;
	GtkSeparator* _tmp9_;
	GtkBox* _tmp10_;
	GtkImage* _tmp11_;
	GtkButton* external_subtitle_file = NULL;
	GtkBox* _tmp12_;
	GtkWidget* _tmp13_;
	GtkButton* _tmp14_ = NULL;
	GtkLabel* lang_label = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* sub_label = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* sub_ext_label = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkGrid* setupgrid = NULL;
	GtkGrid* _tmp18_ = NULL;
	GtkGrid* _tmp19_;
	GtkLabel* _tmp20_;
	GtkGrid* _tmp21_;
	GtkComboBoxText* _tmp22_;
	GtkGrid* _tmp23_;
	GtkLabel* _tmp24_;
	GtkGrid* _tmp25_;
	GtkComboBoxText* _tmp26_;
	GtkGrid* _tmp27_;
	GtkLabel* _tmp28_;
	GtkGrid* _tmp29_;
	GtkButton* _tmp30_;
	GtkGrid* _tmp31_;
	AudiencePlaybackManager* playback_manager = NULL;
	AudiencePlaybackManager* _tmp32_;
	AudiencePlaybackManager* _tmp33_;
	AudiencePlaybackManager* _tmp34_;
	AudiencePlaybackManager* _tmp35_;
	GtkButton* _tmp36_;
	AudiencePlaybackManager* _tmp37_;
	AudiencePlaybackManager* _tmp38_;
	GtkComboBoxText* _tmp39_;
	GtkComboBoxText* _tmp40_;
	parent_class = G_OBJECT_CLASS (audience_widgets_settings_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopover);
	_tmp0_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->languages);
	self->priv->languages = _tmp0_;
	_tmp1_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->subtitles);
	self->priv->subtitles = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->external_subtitle_file_label);
	self->priv->external_subtitle_file_label = _tmp2_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-symbolic");
	g_object_ref_sink (_tmp3_);
	external_subtitle_file_image = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp4_);
	external_subtitle_file_box = _tmp4_;
	_tmp5_ = external_subtitle_file_box;
	_tmp6_ = self->priv->external_subtitle_file_label;
	gtk_box_append (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = external_subtitle_file_box;
	_tmp8_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_box_append (_tmp7_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = external_subtitle_file_box;
	_tmp11_ = external_subtitle_file_image;
	gtk_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = external_subtitle_file_box;
	_tmp13_ = _g_object_ref0 ((GtkWidget*) _tmp12_);
	_tmp14_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp14_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	external_subtitle_file = _tmp14_;
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Audio:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp15_);
	lang_label = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Subtitles:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp16_);
	sub_label = _tmp16_;
	_tmp17_ = (GtkLabel*) gtk_label_new (_ ("External Subtitles:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp17_);
	sub_ext_label = _tmp17_;
	_tmp18_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp18_, 12);
	gtk_grid_set_row_spacing (_tmp18_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp18_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp18_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp18_, 6);
	g_object_ref_sink (_tmp18_);
	setupgrid = _tmp18_;
	_tmp19_ = setupgrid;
	_tmp20_ = lang_label;
	gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, 0, 1, 1, 1);
	_tmp21_ = setupgrid;
	_tmp22_ = self->priv->languages;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 1, 1, 1, 1);
	_tmp23_ = setupgrid;
	_tmp24_ = sub_label;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 0, 2, 1, 1);
	_tmp25_ = setupgrid;
	_tmp26_ = self->priv->subtitles;
	gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 1, 2, 1, 1);
	_tmp27_ = setupgrid;
	_tmp28_ = sub_ext_label;
	gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 0, 3, 1, 1);
	_tmp29_ = setupgrid;
	_tmp30_ = external_subtitle_file;
	gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 1, 3, 1, 1);
	gtk_popover_set_position ((GtkPopover*) self, GTK_POS_TOP);
	_tmp31_ = setupgrid;
	gtk_popover_set_child ((GtkPopover*) self, (GtkWidget*) _tmp31_);
	audience_widgets_settings_popover_set_external_subtitel_label (self);
	_tmp32_ = audience_playback_manager_get_default ();
	_tmp33_ = _g_object_ref0 (_tmp32_);
	playback_manager = _tmp33_;
	_tmp34_ = playback_manager;
	g_signal_connect_object (_tmp34_, "next-audio", (GCallback) _audience_widgets_settings_popover_next_audio_audience_playback_manager_next_audio, self, 0);
	_tmp35_ = playback_manager;
	g_signal_connect_object (_tmp35_, "next-text", (GCallback) _audience_widgets_settings_popover_next_text_audience_playback_manager_next_text, self, 0);
	_tmp36_ = external_subtitle_file;
	g_signal_connect_object (_tmp36_, "clicked", (GCallback) _audience_widgets_settings_popover_get_external_subtitle_file_gtk_button_clicked, self, 0);
	_tmp37_ = playback_manager;
	g_signal_connect_object ((GObject*) _tmp37_, "notify::subtitle-uri", (GCallback) _audience_widgets_settings_popover_set_external_subtitel_label_g_object_notify, self, 0);
	_tmp38_ = playback_manager;
	g_signal_connect_object (_tmp38_, "uri-changed", (GCallback) __audience_widgets_settings_popover___lambda47__audience_playback_manager_uri_changed, self, 0);
	_tmp39_ = self->priv->subtitles;
	g_signal_connect_object ((GtkComboBox*) _tmp39_, "changed", (GCallback) _audience_widgets_settings_popover_on_subtitles_changed_gtk_combo_box_changed, self, 0);
	_tmp40_ = self->priv->languages;
	g_signal_connect_object ((GtkComboBox*) _tmp40_, "changed", (GCallback) _audience_widgets_settings_popover_on_languages_changed_gtk_combo_box_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __audience_widgets_settings_popover___lambda48__gtk_widget_map, self, 0);
	_g_object_unref0 (playback_manager);
	_g_object_unref0 (setupgrid);
	_g_object_unref0 (sub_ext_label);
	_g_object_unref0 (sub_label);
	_g_object_unref0 (lang_label);
	_g_object_unref0 (external_subtitle_file);
	_g_object_unref0 (external_subtitle_file_box);
	_g_object_unref0 (external_subtitle_file_image);
	return obj;
}

static void
audience_widgets_settings_popover_class_init (AudienceWidgetsSettingsPopoverClass * klass,
                                              gpointer klass_data)
{
	audience_widgets_settings_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceWidgetsSettingsPopover_private_offset);
	G_OBJECT_CLASS (klass)->constructor = audience_widgets_settings_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_widgets_settings_popover_finalize;
}

static void
audience_widgets_settings_popover_instance_init (AudienceWidgetsSettingsPopover * self,
                                                 gpointer klass)
{
	self->priv = audience_widgets_settings_popover_get_instance_private (self);
	self->is_setup = FALSE;
}

static void
audience_widgets_settings_popover_finalize (GObject * obj)
{
	AudienceWidgetsSettingsPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopover);
	_g_object_unref0 (self->priv->languages);
	_g_object_unref0 (self->priv->subtitles);
	_g_object_unref0 (self->priv->external_subtitle_file_label);
	G_OBJECT_CLASS (audience_widgets_settings_popover_parent_class)->finalize (obj);
}

static GType
audience_widgets_settings_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceWidgetsSettingsPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_widgets_settings_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceWidgetsSettingsPopover), 0, (GInstanceInitFunc) audience_widgets_settings_popover_instance_init, NULL };
	GType audience_widgets_settings_popover_type_id;
	audience_widgets_settings_popover_type_id = g_type_register_static (gtk_popover_get_type (), "AudienceWidgetsSettingsPopover", &g_define_type_info, 0);
	AudienceWidgetsSettingsPopover_private_offset = g_type_add_instance_private (audience_widgets_settings_popover_type_id, sizeof (AudienceWidgetsSettingsPopoverPrivate));
	return audience_widgets_settings_popover_type_id;
}

GType
audience_widgets_settings_popover_get_type (void)
{
	static volatile gsize audience_widgets_settings_popover_type_id__once = 0;
	if (g_once_init_enter (&audience_widgets_settings_popover_type_id__once)) {
		GType audience_widgets_settings_popover_type_id;
		audience_widgets_settings_popover_type_id = audience_widgets_settings_popover_get_type_once ();
		g_once_init_leave (&audience_widgets_settings_popover_type_id__once, audience_widgets_settings_popover_type_id);
	}
	return audience_widgets_settings_popover_type_id__once;
}

