/* Tombstone.c generated by valac 0.56.18, the Vala compiler
 * generated from Tombstone.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _TombstoneSourceCollectionAsyncScanData TombstoneSourceCollectionAsyncScanData;
typedef struct _ParamSpecTombstonedFile ParamSpecTombstonedFile;
enum  {
	TOMBSTONE_0_PROPERTY,
	TOMBSTONE_NUM_PROPERTIES
};
static GParamSpec* tombstone_properties[TOMBSTONE_NUM_PROPERTIES];
#define _tombstone_row_unref0(var) ((var == NULL) ? NULL : (var = (tombstone_row_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _tombstoned_file_unref0(var) ((var == NULL) ? NULL : (var = (tombstoned_file_unref (var), NULL)))
#define _backing_file_state_unref0(var) ((var == NULL) ? NULL : (var = (backing_file_state_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TombstoneSourceCollectionPrivate {
	GeeHashMap* file_map;
};

struct _TombstoneSourceCollectionAsyncScanData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TombstoneSourceCollection* self;
	DirectoryMonitor* monitor;
	GCancellable* cancellable;
	Marker* marker;
	Marker* _tmp0_;
	GeeIterator* _object_it;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	DataObject* object;
	GeeIterator* _tmp6_;
	gpointer _tmp7_;
	Tombstone* tombstone;
	DataObject* _tmp8_;
	Tombstone* _tmp9_;
	GFile* file;
	Tombstone* _tmp10_;
	GFile* _tmp11_;
	GFileInfo* info;
	GFile* _tmp12_;
	GFileInfo* _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	GFile* _tmp16_;
	GFileInfo* _tmp17_;
	GFileInfo* _tmp18_;
	GError* err;
	GError* _tmp19_;
	GError* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GFileInfo* _tmp26_;
	Marker* _tmp27_;
	Tombstone* _tmp28_;
	Marker* _tmp29_;
	Marker* _tmp30_;
	Marker* _tmp31_;
	GError* err2;
	GError* _tmp32_;
	GError* _inner_error0_;
};

struct _ParamSpecTombstonedFile {
	GParamSpec parent_instance;
};

struct _TombstonePrivate {
	TombstoneRow* row;
	GFile* file;
};

static gint TombstoneSourceCollection_private_offset;
static gpointer tombstone_source_collection_parent_class = NULL;
static gpointer tombstoned_file_parent_class = NULL;
static gint Tombstone_private_offset;
static gpointer tombstone_parent_class = NULL;
TombstoneSourceCollection* tombstone_global = NULL;

static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static gint64 tombstone_source_collection_get_tombstone_id (DataSource* source);
static gint64 _tombstone_source_collection_get_tombstone_id_get_source_database_key (DataSource* source,
                                                                              gpointer self);
static gboolean tombstone_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                                DataSource* source);
static void tombstone_source_collection_real_notify_contents_altered (DataCollection* base,
                                                               GeeIterable* added,
                                                               GeeIterable* removed);
static void tombstone_source_collection_real_notify_items_altered (DataCollection* base,
                                                            GeeMap* items);
static void tombstone_source_collection_async_scan (TombstoneSourceCollection* self,
                                             DirectoryMonitor* monitor,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void tombstone_source_collection_async_scan_finish (TombstoneSourceCollection* self,
                                                    GAsyncResult* _res_);
static void tombstone_source_collection_async_scan_data_free (gpointer _data);
static gboolean tombstone_source_collection_async_scan_co (TombstoneSourceCollectionAsyncScanData* _data_);
static void tombstone_source_collection_async_scan_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static gboolean _tombstone_source_collection_async_scan_co_gsource_func (gpointer self);
static void tombstone_source_collection_finalize (DataCollection * obj);
static GType tombstone_source_collection_get_type_once (void);
static void tombstoned_file_finalize (TombstonedFile * obj);
static GType tombstoned_file_get_type_once (void);
static Tombstone* tombstone_new (TombstoneRow* row);
static Tombstone* tombstone_construct (GType object_type,
                                TombstoneRow* row);
static gchar* tombstone_real_get_typename (DataSource* base);
static gint64 tombstone_real_get_instance_id (DataSource* base);
static gchar* tombstone_real_get_name (DataObject* base);
static gchar* tombstone_real_to_string (DataObject* base);
static void tombstone_real_destroy (DataSource* base);
static void tombstone_finalize (GObject * obj);
static GType tombstone_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
tombstone_source_collection_get_instance_private (TombstoneSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, TombstoneSourceCollection_private_offset);
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static gint64
_tombstone_source_collection_get_tombstone_id_get_source_database_key (DataSource* source,
                                                                       gpointer self)
{
	gint64 result;
	result = tombstone_source_collection_get_tombstone_id (source);
	return result;
}

TombstoneSourceCollection*
tombstone_source_collection_construct (GType object_type)
{
	TombstoneSourceCollection* self = NULL;
	self = (TombstoneSourceCollection*) database_source_collection_construct (object_type, "Tombstones", _tombstone_source_collection_get_tombstone_id_get_source_database_key, NULL);
	return self;
}

TombstoneSourceCollection*
tombstone_source_collection_new (void)
{
	return tombstone_source_collection_construct (TYPE_TOMBSTONE_SOURCE_COLLECTION);
}

static gboolean
tombstone_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                       DataSource* source)
{
	TombstoneSourceCollection * self;
	gboolean result;
	self = (TombstoneSourceCollection*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	result = IS_TOMBSTONE (source);
	return result;
}

static gint64
tombstone_source_collection_get_tombstone_id (DataSource* source)
{
	TombstoneID _tmp0_ = {0};
	gint64 result;
	g_return_val_if_fail (source != NULL, 0LL);
	tombstone_get_tombstone_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TOMBSTONE, Tombstone), &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
tombstone_source_collection_real_notify_contents_altered (DataCollection* base,
                                                          GeeIterable* added,
                                                          GeeIterable* removed)
{
	TombstoneSourceCollection * self;
	self = (TombstoneSourceCollection*) base;
	if (added != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (added);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Tombstone* tombstone = NULL;
				DataObject* _tmp4_;
				Tombstone* _tmp5_;
				GeeHashMap* _tmp6_;
				Tombstone* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				Tombstone* _tmp10_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = object;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TOMBSTONE, Tombstone));
				tombstone = _tmp5_;
				_tmp6_ = self->priv->file_map;
				_tmp7_ = tombstone;
				_tmp8_ = tombstone_get_file (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = tombstone;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp9_, _tmp10_);
				_g_object_unref0 (_tmp9_);
				_g_object_unref0 (tombstone);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp11_;
			_tmp11_ = gee_iterable_iterator (removed);
			_object_it = _tmp11_;
			while (TRUE) {
				GeeIterator* _tmp12_;
				DataObject* object = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				Tombstone* tombstone = NULL;
				DataObject* _tmp15_;
				Tombstone* _tmp16_;
				GeeHashMap* _tmp17_;
				Tombstone* _tmp18_;
				GFile* _tmp19_;
				GFile* _tmp20_;
				gboolean _tmp21_;
				_tmp12_ = _object_it;
				if (!gee_iterator_next (_tmp12_)) {
					break;
				}
				_tmp13_ = _object_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				object = (DataObject*) _tmp14_;
				_tmp15_ = object;
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_TOMBSTONE, Tombstone));
				tombstone = _tmp16_;
				_tmp17_ = self->priv->file_map;
				_tmp18_ = tombstone;
				_tmp19_ = tombstone_get_file (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp20_);
				_g_object_unref0 (_tmp20_);
				if (_tmp21_) {
					gboolean is_removed = FALSE;
					GeeHashMap* _tmp22_;
					Tombstone* _tmp23_;
					GFile* _tmp24_;
					GFile* _tmp25_;
					gboolean _tmp26_;
					_tmp22_ = self->priv->file_map;
					_tmp23_ = tombstone;
					_tmp24_ = tombstone_get_file (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp22_, _tmp25_, NULL);
					_g_object_unref0 (_tmp25_);
					is_removed = _tmp26_;
					_vala_assert (is_removed, "is_removed");
				}
				_g_object_unref0 (tombstone);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	DATA_COLLECTION_CLASS (tombstone_source_collection_parent_class)->notify_contents_altered ((DataCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), added, removed);
}

static void
tombstone_source_collection_real_notify_items_altered (DataCollection* base,
                                                       GeeMap* items)
{
	TombstoneSourceCollection * self;
	self = (TombstoneSourceCollection*) base;
	g_return_if_fail (items != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Alteration* alteration = NULL;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			Alteration* _tmp10_;
			Tombstone* tombstone = NULL;
			DataObject* _tmp11_;
			Tombstone* _tmp12_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (items, _tmp8_);
			alteration = (Alteration*) _tmp9_;
			_tmp10_ = alteration;
			if (!alteration_has_subject (_tmp10_, "file")) {
				_alteration_unref0 (alteration);
				_g_object_unref0 (object);
				continue;
			}
			_tmp11_ = object;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_TOMBSTONE, Tombstone));
			tombstone = _tmp12_;
			{
				GeeIterator* _detail_it = NULL;
				Alteration* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				GeeIterator* _tmp16_;
				GeeIterator* _tmp17_;
				_tmp13_ = alteration;
				_tmp14_ = alteration_get_details (_tmp13_, "file");
				_tmp15_ = _tmp14_;
				_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
				_tmp17_ = _tmp16_;
				_g_object_unref0 (_tmp15_);
				_detail_it = _tmp17_;
				while (TRUE) {
					GeeIterator* _tmp18_;
					gchar* detail = NULL;
					GeeIterator* _tmp19_;
					gpointer _tmp20_;
					GFile* old_file = NULL;
					const gchar* _tmp21_;
					GFile* _tmp22_;
					gboolean removed = FALSE;
					GeeHashMap* _tmp23_;
					GFile* _tmp24_;
					GeeHashMap* _tmp25_;
					Tombstone* _tmp26_;
					GFile* _tmp27_;
					GFile* _tmp28_;
					Tombstone* _tmp29_;
					_tmp18_ = _detail_it;
					if (!gee_iterator_next (_tmp18_)) {
						break;
					}
					_tmp19_ = _detail_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					detail = (gchar*) _tmp20_;
					_tmp21_ = detail;
					_tmp22_ = g_file_new_for_path (_tmp21_);
					old_file = _tmp22_;
					_tmp23_ = self->priv->file_map;
					_tmp24_ = old_file;
					removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp23_, _tmp24_, NULL);
					_vala_assert (removed, "removed");
					_tmp25_ = self->priv->file_map;
					_tmp26_ = tombstone;
					_tmp27_ = tombstone_get_file (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = tombstone;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp28_, _tmp29_);
					_g_object_unref0 (_tmp28_);
					_g_object_unref0 (old_file);
					_g_free0 (detail);
					break;
				}
				_g_object_unref0 (_detail_it);
			}
			_g_object_unref0 (tombstone);
			_alteration_unref0 (alteration);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

Tombstone*
tombstone_source_collection_locate (TombstoneSourceCollection* self,
                                    GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	Tombstone* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->file_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, file);
	result = (Tombstone*) _tmp1_;
	return result;
}

gboolean
tombstone_source_collection_matches (TombstoneSourceCollection* self,
                                     GFile* file)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->file_map;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, file);
	return result;
}

void
tombstone_source_collection_resurrect (TombstoneSourceCollection* self,
                                       Tombstone* tombstone)
{
	Marker* _tmp0_;
	Marker* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tombstone != NULL);
	_tmp0_ = data_collection_mark ((DataCollection*) self, (DataObject*) tombstone);
	_tmp1_ = _tmp0_;
	source_collection_destroy_marked ((SourceCollection*) self, _tmp1_, FALSE, NULL, NULL, NULL);
	_g_object_unref0 (_tmp1_);
}

void
tombstone_source_collection_resurrect_many (TombstoneSourceCollection* self,
                                            GeeCollection* tombstones)
{
	Marker* marker = NULL;
	Marker* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tombstones != NULL);
	_tmp0_ = data_collection_mark_many ((DataCollection*) self, tombstones);
	marker = _tmp0_;
	data_collection_freeze_notifications ((DataCollection*) self);
	database_table_begin_transaction ();
	source_collection_destroy_marked ((SourceCollection*) self, marker, FALSE, NULL, NULL, NULL);
	{
		database_table_commit_transaction (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (marker);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		app_window_database_error (_tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (marker);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	data_collection_thaw_notifications ((DataCollection*) self);
	_g_object_unref0 (marker);
}

void
tombstone_source_collection_launch_scan (TombstoneSourceCollection* self,
                                         DirectoryMonitor* monitor,
                                         GCancellable* cancellable)
{
	g_return_if_fail (self != NULL);
	tombstone_source_collection_async_scan (self, monitor, cancellable, NULL, NULL);
}

static void
tombstone_source_collection_async_scan_data_free (gpointer _data)
{
	TombstoneSourceCollectionAsyncScanData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->monitor);
	_g_object_unref0 (_data_->cancellable);
	_data_collection_unref0 (_data_->self);
	g_slice_free (TombstoneSourceCollectionAsyncScanData, _data_);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static void
tombstone_source_collection_async_scan (TombstoneSourceCollection* self,
                                        DirectoryMonitor* monitor,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TombstoneSourceCollectionAsyncScanData* _data_;
	TombstoneSourceCollection* _tmp0_;
	DirectoryMonitor* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (TombstoneSourceCollectionAsyncScanData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tombstone_source_collection_async_scan_data_free);
	_tmp0_ = _data_collection_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (monitor);
	_g_object_unref0 (_data_->monitor);
	_data_->monitor = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	tombstone_source_collection_async_scan_co (_data_);
}

static void
tombstone_source_collection_async_scan_finish (TombstoneSourceCollection* self,
                                               GAsyncResult* _res_)
{
	TombstoneSourceCollectionAsyncScanData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
tombstone_source_collection_async_scan_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	TombstoneSourceCollectionAsyncScanData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tombstone_source_collection_async_scan_co (_data_);
}

static gboolean
_tombstone_source_collection_async_scan_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tombstone_source_collection_async_scan_co (self);
	return result;
}

static gboolean
tombstone_source_collection_async_scan_co (TombstoneSourceCollectionAsyncScanData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = data_collection_start_marking ((DataCollection*) _data_->self);
	_data_->marker = _data_->_tmp0_;
	{
		_data_->_tmp1_ = data_collection_get_all ((DataCollection*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp2_);
		_data_->_object_it = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_object_it;
			if (!gee_iterator_next (_data_->_tmp5_)) {
				break;
			}
			_data_->_tmp6_ = _data_->_object_it;
			_data_->_tmp7_ = gee_iterator_get (_data_->_tmp6_);
			_data_->object = (DataObject*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->object;
			_data_->_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, TYPE_TOMBSTONE, Tombstone));
			_data_->tombstone = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->tombstone;
			_data_->_tmp11_ = tombstone_get_file (_data_->_tmp10_);
			_data_->file = _data_->_tmp11_;
			_data_->info = NULL;
			if (_data_->monitor != NULL) {
				_data_->_tmp12_ = _data_->file;
				_data_->_tmp13_ = directory_monitor_get_file_info (_data_->monitor, _data_->_tmp12_);
				_g_object_unref0 (_data_->info);
				_data_->info = _data_->_tmp13_;
			}
			_data_->_tmp14_ = _data_->info;
			if (_data_->_tmp14_ == NULL) {
				{
					_data_->_tmp16_ = _data_->file;
					_data_->_state_ = 1;
					g_file_query_info_async (_data_->_tmp16_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_LOW, _data_->cancellable, tombstone_source_collection_async_scan_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp17_ = g_file_query_info_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
					_data_->_tmp15_ = _data_->_tmp17_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_data_->_tmp18_ = _data_->_tmp15_;
					_data_->_tmp15_ = NULL;
					_g_object_unref0 (_data_->info);
					_data_->info = _data_->_tmp18_;
					_g_object_unref0 (_data_->_tmp15_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->err = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp19_ = _data_->err;
					if (g_error_matches (_data_->_tmp19_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
						_g_error_free0 (_data_->err);
						_g_object_unref0 (_data_->info);
						_g_object_unref0 (_data_->file);
						_g_object_unref0 (_data_->tombstone);
						_g_object_unref0 (_data_->object);
						break;
					}
					_data_->_tmp20_ = _data_->err;
					if (!g_error_matches (_data_->_tmp20_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						_data_->_tmp21_ = _data_->file;
						_data_->_tmp22_ = g_file_get_path (_data_->_tmp21_);
						_data_->_tmp23_ = _data_->_tmp22_;
						_data_->_tmp24_ = _data_->err;
						_data_->_tmp25_ = _data_->_tmp24_->message;
						g_warning ("Tombstone.vala:148: Unable to check for existence of tombstoned file %" \
"s: %s", _data_->_tmp23_, _data_->_tmp25_);
						_g_free0 (_data_->_tmp23_);
					}
					_g_error_free0 (_data_->err);
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->info);
					_g_object_unref0 (_data_->file);
					_g_object_unref0 (_data_->tombstone);
					_g_object_unref0 (_data_->object);
					_g_object_unref0 (_data_->_object_it);
					_g_object_unref0 (_data_->marker);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp26_ = _data_->info;
			if (_data_->_tmp26_ == NULL) {
				_data_->_tmp27_ = _data_->marker;
				_data_->_tmp28_ = _data_->tombstone;
				marker_mark (_data_->_tmp27_, (DataObject*) _data_->_tmp28_);
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tombstone_source_collection_async_scan_co_gsource_func, _data_, NULL);
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
			_g_object_unref0 (_data_->info);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->tombstone);
			_g_object_unref0 (_data_->object);
		}
		_g_object_unref0 (_data_->_object_it);
	}
	_data_->_tmp29_ = _data_->marker;
	if (marker_get_count (_data_->_tmp29_) > 0) {
		_data_->_tmp30_ = _data_->marker;
		g_debug ("Tombstone.vala:163: Resurrecting %d tombstones with no backing file", marker_get_count (_data_->_tmp30_));
		database_table_begin_transaction ();
		_data_->_tmp31_ = _data_->marker;
		source_collection_destroy_marked ((SourceCollection*) _data_->self, _data_->_tmp31_, FALSE, NULL, NULL, NULL);
		{
			database_table_commit_transaction (&_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch1_database_error;
				}
				_g_object_unref0 (_data_->marker);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_database_error:
		{
			_data_->err2 = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp32_ = _data_->err2;
			app_window_database_error (_data_->_tmp32_);
			_g_error_free0 (_data_->err2);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->marker);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->marker);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tombstone_source_collection_class_init (TombstoneSourceCollectionClass * klass,
                                        gpointer klass_data)
{
	tombstone_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = tombstone_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &TombstoneSourceCollection_private_offset);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) tombstone_source_collection_real_holds_type_of_source;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) tombstone_source_collection_real_notify_contents_altered;
	((DataCollectionClass *) klass)->notify_items_altered = (void (*) (DataCollection*, GeeMap*)) tombstone_source_collection_real_notify_items_altered;
}

static void
tombstone_source_collection_instance_init (TombstoneSourceCollection * self,
                                           gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = tombstone_source_collection_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_TOMBSTONE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->file_map = _tmp0_;
}

static void
tombstone_source_collection_finalize (DataCollection * obj)
{
	TombstoneSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollection);
	_g_object_unref0 (self->priv->file_map);
	DATA_COLLECTION_CLASS (tombstone_source_collection_parent_class)->finalize (obj);
}

static GType
tombstone_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TombstoneSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstoneSourceCollection), 0, (GInstanceInitFunc) tombstone_source_collection_instance_init, NULL };
	GType tombstone_source_collection_type_id;
	tombstone_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "TombstoneSourceCollection", &g_define_type_info, 0);
	TombstoneSourceCollection_private_offset = g_type_add_instance_private (tombstone_source_collection_type_id, sizeof (TombstoneSourceCollectionPrivate));
	return tombstone_source_collection_type_id;
}

GType
tombstone_source_collection_get_type (void)
{
	static volatile gsize tombstone_source_collection_type_id__once = 0;
	if (g_once_init_enter (&tombstone_source_collection_type_id__once)) {
		GType tombstone_source_collection_type_id;
		tombstone_source_collection_type_id = tombstone_source_collection_get_type_once ();
		g_once_init_leave (&tombstone_source_collection_type_id__once, tombstone_source_collection_type_id);
	}
	return tombstone_source_collection_type_id__once;
}

TombstonedFile*
tombstoned_file_construct (GType object_type,
                           GFile* file,
                           gint64 filesize,
                           const gchar* md5)
{
	TombstonedFile* self = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (TombstonedFile*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	self->filesize = filesize;
	_tmp1_ = g_strdup (md5);
	_g_free0 (self->md5);
	self->md5 = _tmp1_;
	return self;
}

TombstonedFile*
tombstoned_file_new (GFile* file,
                     gint64 filesize,
                     const gchar* md5)
{
	return tombstoned_file_construct (TYPE_TOMBSTONED_FILE, file, filesize, md5);
}

static void
value_tombstoned_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_tombstoned_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tombstoned_file_unref (value->data[0].v_pointer);
	}
}

static void
value_tombstoned_file_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tombstoned_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_tombstoned_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_tombstoned_file_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TombstonedFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tombstoned_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_tombstoned_file_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	TombstonedFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tombstoned_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_tombstoned_file (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecTombstonedFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TOMBSTONED_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_tombstoned_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONED_FILE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_tombstoned_file (GValue* value,
                           gpointer v_object)
{
	TombstonedFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tombstoned_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tombstoned_file_unref (old);
	}
}

void
value_take_tombstoned_file (GValue* value,
                            gpointer v_object)
{
	TombstonedFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tombstoned_file_unref (old);
	}
}

static void
tombstoned_file_class_init (TombstonedFileClass * klass,
                            gpointer klass_data)
{
	tombstoned_file_parent_class = g_type_class_peek_parent (klass);
	((TombstonedFileClass *) klass)->finalize = tombstoned_file_finalize;
}

static void
tombstoned_file_instance_init (TombstonedFile * self,
                               gpointer klass)
{
	self->ref_count = 1;
}

static void
tombstoned_file_finalize (TombstonedFile * obj)
{
	TombstonedFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONED_FILE, TombstonedFile);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
	_g_free0 (self->md5);
}

static GType
tombstoned_file_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_tombstoned_file_init, value_tombstoned_file_free_value, value_tombstoned_file_copy_value, value_tombstoned_file_peek_pointer, "p", value_tombstoned_file_collect_value, "p", value_tombstoned_file_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TombstonedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstoned_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstonedFile), 0, (GInstanceInitFunc) tombstoned_file_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tombstoned_file_type_id;
	tombstoned_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TombstonedFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tombstoned_file_type_id;
}

GType
tombstoned_file_get_type (void)
{
	static volatile gsize tombstoned_file_type_id__once = 0;
	if (g_once_init_enter (&tombstoned_file_type_id__once)) {
		GType tombstoned_file_type_id;
		tombstoned_file_type_id = tombstoned_file_get_type_once ();
		g_once_init_leave (&tombstoned_file_type_id__once, tombstoned_file_type_id);
	}
	return tombstoned_file_type_id__once;
}

gpointer
tombstoned_file_ref (gpointer instance)
{
	TombstonedFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tombstoned_file_unref (gpointer instance)
{
	TombstonedFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TOMBSTONED_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
tombstone_get_instance_private (Tombstone* self)
{
	return G_STRUCT_MEMBER_P (self, Tombstone_private_offset);
}

gint
tombstone_reason_serialize (TombstoneReason self)
{
	gint result;
	result = (gint) self;
	return result;
}

TombstoneReason
tombstone_reason_unserialize (gint value)
{
	TombstoneReason result;
	switch ((TombstoneReason) value) {
		case TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE:
		{
			result = TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE;
			return result;
		}
		default:
		case TOMBSTONE_REASON_REMOVED_BY_USER:
		{
			result = TOMBSTONE_REASON_REMOVED_BY_USER;
			return result;
		}
	}
}

static GType
tombstone_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{TOMBSTONE_REASON_REMOVED_BY_USER, "TOMBSTONE_REASON_REMOVED_BY_USER", "removed-by-user"}, {TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE, "TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE", "auto-detected-duplicate"}, {0, NULL, NULL}};
	GType tombstone_reason_type_id;
	tombstone_reason_type_id = g_enum_register_static ("TombstoneReason", values);
	return tombstone_reason_type_id;
}

GType
tombstone_reason_get_type (void)
{
	static volatile gsize tombstone_reason_type_id__once = 0;
	if (g_once_init_enter (&tombstone_reason_type_id__once)) {
		GType tombstone_reason_type_id;
		tombstone_reason_type_id = tombstone_reason_get_type_once ();
		g_once_init_leave (&tombstone_reason_type_id__once, tombstone_reason_type_id);
	}
	return tombstone_reason_type_id__once;
}

static gpointer
_tombstone_row_ref0 (gpointer self)
{
	return self ? tombstone_row_ref (self) : NULL;
}

static Tombstone*
tombstone_construct (GType object_type,
                     TombstoneRow* row)
{
	Tombstone * self = NULL;
	TombstoneRow* _tmp0_;
	g_return_val_if_fail (row != NULL, NULL);
	self = (Tombstone*) data_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
	_tmp0_ = _tombstone_row_ref0 (row);
	_tombstone_row_unref0 (self->priv->row);
	self->priv->row = _tmp0_;
	return self;
}

static Tombstone*
tombstone_new (TombstoneRow* row)
{
	return tombstone_construct (TYPE_TOMBSTONE, row);
}

void
tombstone_init (void)
{
	TombstoneSourceCollection* _tmp0_;
	TombstoneRow** rows = NULL;
	gint rows_length1;
	gint _rows_size_;
	TombstoneRow** _tmp9_;
	gint _tmp9__length1;
	GError* _inner_error0_ = NULL;
	_tmp0_ = tombstone_source_collection_new ();
	_data_collection_unref0 (tombstone_global);
	tombstone_global = _tmp0_;
	rows = NULL;
	rows_length1 = 0;
	_rows_size_ = rows_length1;
	{
		TombstoneRow** _tmp1_ = NULL;
		TombstoneTable* _tmp2_;
		TombstoneTable* _tmp3_;
		gint _tmp4_ = 0;
		TombstoneRow** _tmp5_;
		TombstoneRow** _tmp6_;
		gint _tmp6__length1;
		gint _tmp1__length1;
		gint __tmp1__size_;
		TombstoneRow** _tmp7_;
		gint _tmp7__length1;
		_tmp2_ = tombstone_table_get_instance ();
		_tmp3_ = _tmp2_;
		_tmp5_ = tombstone_table_fetch_all (_tmp3_, &_tmp4_, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp4_;
		_database_table_unref0 (_tmp3_);
		_tmp1_ = _tmp6_;
		_tmp1__length1 = _tmp6__length1;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp7_ = _tmp1_;
		_tmp7__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
		rows = _tmp7_;
		rows_length1 = _tmp7__length1;
		_rows_size_ = rows_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) tombstone_row_unref), NULL);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		app_window_database_error (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = rows;
	_tmp9__length1 = rows_length1;
	if (_tmp9_ != NULL) {
		GeeArrayList* tombstones = NULL;
		GeeArrayList* _tmp10_;
		TombstoneRow** _tmp11_;
		gint _tmp11__length1;
		TombstoneSourceCollection* _tmp17_;
		GeeArrayList* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		_tmp10_ = gee_array_list_new (TYPE_TOMBSTONE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		tombstones = _tmp10_;
		_tmp11_ = rows;
		_tmp11__length1 = rows_length1;
		{
			TombstoneRow** row_collection = NULL;
			gint row_collection_length1 = 0;
			gint _row_collection_size_ = 0;
			gint row_it = 0;
			row_collection = _tmp11_;
			row_collection_length1 = _tmp11__length1;
			for (row_it = 0; row_it < row_collection_length1; row_it = row_it + 1) {
				TombstoneRow* _tmp12_;
				TombstoneRow* row = NULL;
				_tmp12_ = _tombstone_row_ref0 (row_collection[row_it]);
				row = _tmp12_;
				{
					GeeArrayList* _tmp13_;
					TombstoneRow* _tmp14_;
					Tombstone* _tmp15_;
					Tombstone* _tmp16_;
					_tmp13_ = tombstones;
					_tmp14_ = row;
					_tmp15_ = tombstone_new (_tmp14_);
					_tmp16_ = _tmp15_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
					_g_object_unref0 (_tmp16_);
					_tombstone_row_unref0 (row);
				}
			}
		}
		_tmp17_ = tombstone_global;
		_tmp18_ = tombstones;
		_tmp19_ = data_collection_add_many ((DataCollection*) _tmp17_, (GeeCollection*) _tmp18_, NULL, NULL);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (tombstones);
	}
	rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
}

void
tombstone_terminate (void)
{
}

static gpointer
_backing_file_state_ref0 (gpointer self)
{
	return self ? backing_file_state_ref (self) : NULL;
}

void
tombstone_entomb_many_sources (GeeCollection* sources,
                               TombstoneReason reason,
                               GError** error)
{
	GeeCollection* files = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (sources != NULL);
	_tmp0_ = gee_array_list_new (TYPE_TOMBSTONED_FILE, (GBoxedCopyFunc) tombstoned_file_ref, (GDestroyNotify) tombstoned_file_unref, NULL, NULL, NULL);
	files = (GeeCollection*) _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) sources);
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			MediaSource* _tmp5_;
			gint _tmp6_ = 0;
			BackingFileState** _tmp7_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (MediaSource*) _tmp4_;
			_tmp5_ = source;
			_tmp7_ = media_source_get_backing_files_state (_tmp5_, &_tmp6_);
			{
				BackingFileState** state_collection = NULL;
				gint state_collection_length1 = 0;
				gint _state_collection_size_ = 0;
				gint state_it = 0;
				state_collection = _tmp7_;
				state_collection_length1 = _tmp6_;
				for (state_it = 0; state_it < state_collection_length1; state_it = state_it + 1) {
					BackingFileState* _tmp8_;
					BackingFileState* state = NULL;
					_tmp8_ = _backing_file_state_ref0 (state_collection[state_it]);
					state = _tmp8_;
					{
						GeeCollection* _tmp9_;
						BackingFileState* _tmp10_;
						GFile* _tmp11_;
						GFile* _tmp12_;
						BackingFileState* _tmp13_;
						BackingFileState* _tmp14_;
						const gchar* _tmp15_;
						TombstonedFile* _tmp16_;
						TombstonedFile* _tmp17_;
						_tmp9_ = files;
						_tmp10_ = state;
						_tmp11_ = backing_file_state_get_file (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = state;
						_tmp14_ = state;
						_tmp15_ = _tmp14_->md5;
						_tmp16_ = tombstoned_file_new (_tmp12_, _tmp13_->filesize, _tmp15_);
						_tmp17_ = _tmp16_;
						gee_collection_add (_tmp9_, _tmp17_);
						_tombstoned_file_unref0 (_tmp17_);
						_g_object_unref0 (_tmp12_);
						_backing_file_state_unref0 (state);
					}
				}
				state_collection = (_vala_array_free (state_collection, state_collection_length1, (GDestroyNotify) backing_file_state_unref), NULL);
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp18_ = files;
	tombstone_entomb_many_files (_tmp18_, reason, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (files);
			return;
		} else {
			_g_object_unref0 (files);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (files);
}

void
tombstone_entomb_many_files (GeeCollection* files,
                             TombstoneReason reason,
                             GError** error)
{
	Marker* to_destroy = NULL;
	TombstoneSourceCollection* _tmp0_;
	Marker* _tmp1_;
	TombstoneSourceCollection* _tmp13_;
	Marker* _tmp14_;
	GeeArrayList* tombstones = NULL;
	GeeArrayList* _tmp15_;
	TombstoneSourceCollection* _tmp35_;
	GeeArrayList* _tmp36_;
	GeeCollection* _tmp37_;
	GeeCollection* _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (files != NULL);
	_tmp0_ = tombstone_global;
	_tmp1_ = data_collection_start_marking ((DataCollection*) _tmp0_);
	to_destroy = _tmp1_;
	{
		GeeIterator* _file_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) files);
		_file_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			TombstonedFile* file = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			Tombstone* tombstone = NULL;
			TombstoneSourceCollection* _tmp6_;
			TombstonedFile* _tmp7_;
			GFile* _tmp8_;
			Tombstone* _tmp9_;
			Tombstone* _tmp10_;
			_tmp3_ = _file_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _file_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			file = (TombstonedFile*) _tmp5_;
			_tmp6_ = tombstone_global;
			_tmp7_ = file;
			_tmp8_ = _tmp7_->file;
			_tmp9_ = tombstone_source_collection_locate (_tmp6_, _tmp8_);
			tombstone = _tmp9_;
			_tmp10_ = tombstone;
			if (_tmp10_ != NULL) {
				Marker* _tmp11_;
				Tombstone* _tmp12_;
				_tmp11_ = to_destroy;
				_tmp12_ = tombstone;
				marker_mark (_tmp11_, (DataObject*) _tmp12_);
			}
			_g_object_unref0 (tombstone);
			_tombstoned_file_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	_tmp13_ = tombstone_global;
	_tmp14_ = to_destroy;
	source_collection_destroy_marked ((SourceCollection*) _tmp13_, _tmp14_, FALSE, NULL, NULL, NULL);
	_tmp15_ = gee_array_list_new (TYPE_TOMBSTONE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	tombstones = _tmp15_;
	{
		GeeIterator* _file_it = NULL;
		GeeIterator* _tmp16_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) files);
		_file_it = _tmp16_;
		while (TRUE) {
			GeeIterator* _tmp17_;
			TombstonedFile* file = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			TombstoneRow* _tmp20_ = NULL;
			TombstoneTable* _tmp21_;
			TombstoneTable* _tmp22_;
			TombstonedFile* _tmp23_;
			GFile* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			TombstonedFile* _tmp27_;
			TombstonedFile* _tmp28_;
			const gchar* _tmp29_;
			TombstoneRow* _tmp30_;
			TombstoneRow* _tmp31_;
			GeeArrayList* _tmp32_;
			Tombstone* _tmp33_;
			Tombstone* _tmp34_;
			_tmp17_ = _file_it;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _file_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			file = (TombstonedFile*) _tmp19_;
			_tmp21_ = tombstone_table_get_instance ();
			_tmp22_ = _tmp21_;
			_tmp23_ = file;
			_tmp24_ = _tmp23_->file;
			_tmp25_ = g_file_get_path (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = file;
			_tmp28_ = file;
			_tmp29_ = _tmp28_->md5;
			_tmp30_ = tombstone_table_add (_tmp22_, _tmp26_, _tmp27_->filesize, _tmp29_, reason, &_inner_error0_);
			_tmp31_ = _tmp30_;
			_g_free0 (_tmp26_);
			_database_table_unref0 (_tmp22_);
			_tmp20_ = _tmp31_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_tombstoned_file_unref0 (file);
					_g_object_unref0 (_file_it);
					_g_object_unref0 (tombstones);
					_g_object_unref0 (to_destroy);
					return;
				} else {
					_tombstoned_file_unref0 (file);
					_g_object_unref0 (_file_it);
					_g_object_unref0 (tombstones);
					_g_object_unref0 (to_destroy);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp32_ = tombstones;
			_tmp33_ = tombstone_new (_tmp20_);
			_tmp34_ = _tmp33_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp34_);
			_g_object_unref0 (_tmp34_);
			_tombstone_row_unref0 (_tmp20_);
			_tombstoned_file_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	_tmp35_ = tombstone_global;
	_tmp36_ = tombstones;
	_tmp37_ = data_collection_add_many ((DataCollection*) _tmp35_, (GeeCollection*) _tmp36_, NULL, NULL);
	_tmp38_ = _tmp37_;
	_g_object_unref0 (_tmp38_);
	_g_object_unref0 (tombstones);
	_g_object_unref0 (to_destroy);
}

static gchar*
tombstone_real_get_typename (DataSource* base)
{
	Tombstone * self;
	gchar* _tmp0_;
	gchar* result;
	self = (Tombstone*) base;
	_tmp0_ = g_strdup ("tombstone");
	result = _tmp0_;
	return result;
}

static gint64
tombstone_real_get_instance_id (DataSource* base)
{
	Tombstone * self;
	TombstoneID _tmp0_ = {0};
	gint64 result;
	self = (Tombstone*) base;
	tombstone_get_tombstone_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static gchar*
tombstone_real_get_name (DataObject* base)
{
	Tombstone * self;
	TombstoneRow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (Tombstone*) base;
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->filepath;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
tombstone_real_to_string (DataObject* base)
{
	Tombstone * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (Tombstone*) base;
	_tmp0_ = data_object_get_name ((DataObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("Tombstone %s", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
tombstone_get_tombstone_id (Tombstone* self,
                            TombstoneID* result)
{
	TombstoneRow* _tmp0_;
	TombstoneID _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->id;
	*result = _tmp1_;
	return;
}

GFile*
tombstone_get_file (Tombstone* self)
{
	GFile* _tmp0_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	if (_tmp0_ == NULL) {
		TombstoneRow* _tmp1_;
		const gchar* _tmp2_;
		GFile* _tmp3_;
		_tmp1_ = self->priv->row;
		_tmp2_ = _tmp1_->filepath;
		_tmp3_ = g_file_new_for_path (_tmp2_);
		_g_object_unref0 (self->priv->file);
		self->priv->file = _tmp3_;
	}
	_tmp4_ = self->priv->file;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

gchar*
tombstone_get_md5 (Tombstone* self)
{
	const gchar* _tmp0_ = NULL;
	TombstoneRow* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->row;
	_tmp2_ = _tmp1_->md5;
	if (is_string_empty (_tmp2_)) {
		_tmp0_ = NULL;
	} else {
		TombstoneRow* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->row;
		_tmp4_ = _tmp3_->md5;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp0_);
	result = _tmp5_;
	return result;
}

TombstoneReason
tombstone_get_reason (Tombstone* self)
{
	TombstoneRow* _tmp0_;
	TombstoneReason result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->row;
	result = _tmp0_->reason;
	return result;
}

void
tombstone_move (Tombstone* self,
                GFile* file)
{
	gchar* old_filepath = NULL;
	TombstoneRow* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	TombstoneRow* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	Alteration* _tmp13_;
	Alteration* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		TombstoneTable* _tmp0_;
		TombstoneTable* _tmp1_;
		TombstoneRow* _tmp2_;
		TombstoneID _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = tombstone_table_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->row;
		_tmp3_ = _tmp2_->id;
		_tmp4_ = g_file_get_path (file);
		_tmp5_ = _tmp4_;
		tombstone_table_update_file (_tmp1_, &_tmp3_, _tmp5_, &_inner_error0_);
		_g_free0 (_tmp5_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		app_window_database_error (_tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = self->priv->row;
	_tmp8_ = _tmp7_->filepath;
	_tmp9_ = g_strdup (_tmp8_);
	old_filepath = _tmp9_;
	_tmp10_ = self->priv->row;
	_tmp11_ = g_file_get_path (file);
	_g_free0 (_tmp10_->filepath);
	_tmp10_->filepath = _tmp11_;
	_tmp12_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp12_;
	_tmp13_ = alteration_new ("file", old_filepath);
	_tmp14_ = _tmp13_;
	data_object_notify_altered ((DataObject*) self, _tmp14_);
	_alteration_unref0 (_tmp14_);
	_g_free0 (old_filepath);
}

gboolean
tombstone_matches (Tombstone* self,
                   GFile* file,
                   gint64 filesize,
                   const gchar* md5)
{
	TombstoneRow* _tmp0_;
	const gchar* _tmp1_ = NULL;
	TombstoneRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* this_md5 = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* other_md5 = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->row;
	if (_tmp0_->filesize != filesize) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->row;
	_tmp3_ = _tmp2_->md5;
	if (is_string_empty (_tmp3_)) {
		_tmp1_ = NULL;
	} else {
		TombstoneRow* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->row;
		_tmp5_ = _tmp4_->md5;
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp1_);
	this_md5 = _tmp6_;
	if (is_string_empty (md5)) {
		_tmp7_ = NULL;
	} else {
		_tmp7_ = md5;
	}
	_tmp8_ = g_strdup (_tmp7_);
	other_md5 = _tmp8_;
	_tmp9_ = this_md5;
	_tmp10_ = other_md5;
	if (g_strcmp0 (_tmp9_, _tmp10_) != 0) {
		result = FALSE;
		_g_free0 (other_md5);
		_g_free0 (this_md5);
		return result;
	}
	_tmp11_ = tombstone_get_file (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = !g_file_equal (_tmp12_, file);
	_g_object_unref0 (_tmp12_);
	if (_tmp13_) {
		result = FALSE;
		_g_free0 (other_md5);
		_g_free0 (this_md5);
		return result;
	}
	result = TRUE;
	_g_free0 (other_md5);
	_g_free0 (this_md5);
	return result;
}

static void
tombstone_real_destroy (DataSource* base)
{
	Tombstone * self;
	GError* _inner_error0_ = NULL;
	self = (Tombstone*) base;
	{
		TombstoneTable* _tmp0_;
		TombstoneTable* _tmp1_;
		TombstoneRow* _tmp2_;
		TombstoneID _tmp3_;
		_tmp0_ = tombstone_table_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->row;
		_tmp3_ = _tmp2_->id;
		tombstone_table_remove (_tmp1_, &_tmp3_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		app_window_database_error (_tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	DATA_SOURCE_CLASS (tombstone_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
}

static void
tombstone_class_init (TombstoneClass * klass,
                      gpointer klass_data)
{
	tombstone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Tombstone_private_offset);
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) tombstone_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) tombstone_real_get_instance_id;
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) tombstone_real_get_name;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) tombstone_real_to_string;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) tombstone_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = tombstone_finalize;
}

static void
tombstone_instance_init (Tombstone * self,
                         gpointer klass)
{
	self->priv = tombstone_get_instance_private (self);
	self->priv->file = NULL;
}

static void
tombstone_finalize (GObject * obj)
{
	Tombstone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE, Tombstone);
	_tombstone_row_unref0 (self->priv->row);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (tombstone_parent_class)->finalize (obj);
}

static GType
tombstone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TombstoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tombstone), 0, (GInstanceInitFunc) tombstone_instance_init, NULL };
	GType tombstone_type_id;
	tombstone_type_id = g_type_register_static (TYPE_DATA_SOURCE, "Tombstone", &g_define_type_info, 0);
	Tombstone_private_offset = g_type_add_instance_private (tombstone_type_id, sizeof (TombstonePrivate));
	return tombstone_type_id;
}

GType
tombstone_get_type (void)
{
	static volatile gsize tombstone_type_id__once = 0;
	if (g_once_init_enter (&tombstone_type_id__once)) {
		GType tombstone_type_id;
		tombstone_type_id = tombstone_get_type_once ();
		g_once_init_leave (&tombstone_type_id__once, tombstone_type_id);
	}
	return tombstone_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

