/* Terminal.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Terminal.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022 elementary, Inc. (https://elementary.io)
 *                         2011-2013 Mario Guerriero <mario@elementaryos.org>
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <vte/vte.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <signal.h>
#include <sys/types.h>
#include <glib/gstdio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#define CODE_TERMINAL_ACTION_GROUP "term"
#define CODE_TERMINAL_ACTION_PREFIX CODE_TERMINAL_ACTION_GROUP "."
#define CODE_TERMINAL_ACTION_COPY "action-copy"
#define CODE_TERMINAL_ACTION_PASTE "action-paste"
#define CODE_TERMINAL_MAX_SCALE 5.0
#define CODE_TERMINAL_MIN_SCALE 0.2
#define CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA "org.pantheon.terminal.settings"
#define CODE_TERMINAL_SETTINGS_SCHEMA "io.elementary.terminal.settings"
#define SCRATCH_MAIN_WINDOW_ACTION_GROUP "win"
#define SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_GROUP "."
#define SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_TERMINAL "action-toggle-terminal"
#define CONSTANTS_PROJECT_NAME "io.elementary.code"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef gboolean (*_LocalFunc0_) (guint keyval, guint code, gpointer user_data);

#define CODE_TYPE_TERMINAL (code_terminal_get_type ())
#define CODE_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CODE_TYPE_TERMINAL, CodeTerminal))
#define CODE_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CODE_TYPE_TERMINAL, CodeTerminalClass))
#define CODE_IS_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CODE_TYPE_TERMINAL))
#define CODE_IS_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CODE_TYPE_TERMINAL))
#define CODE_TERMINAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CODE_TYPE_TERMINAL, CodeTerminalClass))

typedef struct _CodeTerminal CodeTerminal;
typedef struct _CodeTerminalClass CodeTerminalClass;
typedef struct _CodeTerminalPrivate CodeTerminalPrivate;
enum  {
	CODE_TERMINAL_0_PROPERTY,
	CODE_TERMINAL_TERMINAL_PROPERTY,
	CODE_TERMINAL_ACTIONS_PROPERTY,
	CODE_TERMINAL_NUM_PROPERTIES
};
static GParamSpec* code_terminal_properties[CODE_TERMINAL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _Block52Data Block52Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

struct _CodeTerminal {
	GtkBox parent_instance;
	CodeTerminalPrivate * priv;
};

struct _CodeTerminalClass {
	GtkBoxClass parent_class;
};

struct _CodeTerminalPrivate {
	VteTerminal* _terminal;
	GtkEventControllerKey* key_controller;
	GSettings* pantheon_terminal_settings;
	GSimpleActionGroup* _actions;
	GPid child_pid;
	GtkClipboard* current_clipboard;
};

struct _Block52Data {
	int _ref_count_;
	CodeTerminal* self;
	GSimpleAction* copy_action;
	GSimpleAction* paste_action;
	GtkMenu* menu;
	GSettings* settings;
};

static gint CodeTerminal_private_offset;
static gpointer code_terminal_parent_class = NULL;

VALA_EXTERN GType code_terminal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CodeTerminal, g_object_unref)
static void code_terminal_spawn_shell (CodeTerminal* self,
                                const gchar* dir);
VALA_EXTERN VteTerminal* code_terminal_get_terminal (CodeTerminal* self);
VALA_EXTERN void code_terminal_change_location (CodeTerminal* self,
                                    const gchar* dir);
static gchar* code_terminal_get_shell_location (CodeTerminal* self);
static void code_terminal_update_terminal_settings (CodeTerminal* self,
                                             const gchar* settings_schema);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void code_terminal_increment_size (CodeTerminal* self);
VALA_EXTERN void code_terminal_decrement_size (CodeTerminal* self);
VALA_EXTERN void code_terminal_set_default_font_size (CodeTerminal* self);
static gboolean code_terminal_key_pressed (CodeTerminal* self,
                                    guint keyval,
                                    guint keycode,
                                    GdkModifierType modifiers);
static gboolean __lambda126_ (CodeTerminal* self,
                       guint keyval,
                       guint code);
static gboolean ___lambda126___localfunc0_ (guint keyval,
                                     guint code,
                                     gpointer self);
VALA_EXTERN GSimpleActionGroup* code_terminal_get_actions (CodeTerminal* self);
VALA_EXTERN CodeTerminal* code_terminal_new (void);
VALA_EXTERN CodeTerminal* code_terminal_construct (GType object_type);
static void code_terminal_set_terminal (CodeTerminal* self,
                                 VteTerminal* value);
static void code_terminal_set_actions (CodeTerminal* self,
                                GSimpleActionGroup* value);
static GObject * code_terminal_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void _code_terminal___lambda127_ (CodeTerminal* self);
static void __code_terminal___lambda127__vte_terminal_child_exited (VteTerminal* _sender,
                                                             gint status,
                                                             gpointer self);
static void _code_terminal___lambda128_ (CodeTerminal* self);
static void __code_terminal___lambda128__g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static void _code_terminal___lambda129_ (CodeTerminal* self);
static void __code_terminal___lambda129__g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static gboolean _code_terminal_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                          guint keyval,
                                                                          guint keycode,
                                                                          GdkModifierType state,
                                                                          gpointer self);
static gboolean _code_terminal___lambda130_ (Block52Data* _data52_,
                                      GdkEventButton* event);
static gboolean __code_terminal___lambda130__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self);
static void _code_terminal___lambda131_ (Block52Data* _data52_);
static void __code_terminal___lambda131__gtk_widget_realize (GtkWidget* _sender,
                                                      gpointer self);
static void _code_terminal___lambda132_ (Block52Data* _data52_);
static void __code_terminal___lambda132__vte_terminal_selection_changed (VteTerminal* _sender,
                                                                  gpointer self);
static void _code_terminal___lambda133_ (Block52Data* _data52_);
static void __code_terminal___lambda133__gtk_widget_destroy (GtkWidget* _sender,
                                                      gpointer self);
static void code_terminal_finalize (GObject * obj);
static GType code_terminal_get_type_once (void);
static void _vala_code_terminal_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_code_terminal_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
code_terminal_get_instance_private (CodeTerminal* self)
{
	return G_STRUCT_MEMBER_P (self, CodeTerminal_private_offset);
}

static void
code_terminal_spawn_shell (CodeTerminal* self,
                           const gchar* dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	{
		VteTerminal* _tmp0_;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		GPid _tmp4_ = 0;
		_tmp0_ = self->priv->_terminal;
		_tmp1_ = vte_get_user_shell ();
		_tmp2_ = g_new0 (gchar*, 1 + 1);
		_tmp2_[0] = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 1;
		vte_terminal_spawn_sync (_tmp0_, VTE_PTY_DEFAULT, dir, _tmp3_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, NULL, &_inner_error0_);
		self->priv->child_pid = _tmp4_;
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("Terminal.vala:120: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
code_terminal_change_location (CodeTerminal* self,
                               const gchar* dir)
{
	VteTerminal* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	kill ((pid_t) self->priv->child_pid, (gint) SIGTERM);
	_tmp0_ = self->priv->_terminal;
	vte_terminal_reset (_tmp0_, TRUE, TRUE);
	code_terminal_spawn_shell (self, dir);
}

static gchar*
code_terminal_get_shell_location (CodeTerminal* self)
{
	gint pid = 0;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	pid = (gint) ((GPid) self->priv->child_pid);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_strdup_printf ("/proc/%d/cwd", pid);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_read_link (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("Terminal.vala:135: An error occurred while fetching the current dir of" \
" shell: %s", _tmp7_);
		_tmp8_ = g_strdup ("");
		result = _tmp8_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
code_terminal_update_terminal_settings (CodeTerminal* self,
                                        const gchar* settings_schema)
{
	GSettings* _tmp0_;
	gchar* font_name = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	PangoFontDescription* fd = NULL;
	const gchar* _tmp7_;
	PangoFontDescription* _tmp8_;
	VteTerminal* _tmp9_;
	PangoFontDescription* _tmp10_;
	gboolean audible_bell_setting = FALSE;
	GSettings* _tmp11_;
	VteTerminal* _tmp12_;
	gchar* cursor_shape_setting = NULL;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GQuark _tmp18_ = 0U;
	static GQuark _tmp17_label0 = 0;
	static GQuark _tmp17_label1 = 0;
	static GQuark _tmp17_label2 = 0;
	gchar* background_setting = NULL;
	GSettings* _tmp22_;
	gchar* _tmp23_;
	GdkRGBA background_color = {0};
	const gchar* _tmp24_;
	gchar* foreground_setting = NULL;
	GSettings* _tmp25_;
	gchar* _tmp26_;
	GdkRGBA foreground_color = {0};
	const gchar* _tmp27_;
	gchar* palette_setting = NULL;
	GSettings* _tmp28_;
	gchar* _tmp29_;
	gchar** hex_palette = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gint hex_palette_length1;
	gint _hex_palette_size_;
	gchar* current_string = NULL;
	gchar* _tmp47_;
	gint current_color = 0;
	GdkRGBA* palette = NULL;
	GdkRGBA* _tmp64_;
	gint palette_length1;
	gint _palette_size_;
	VteTerminal* _tmp72_;
	GdkRGBA _tmp73_;
	GdkRGBA _tmp74_;
	GdkRGBA* _tmp75_;
	gint _tmp75__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings_schema != NULL);
	_tmp0_ = g_settings_new (settings_schema);
	_g_object_unref0 (self->priv->pantheon_terminal_settings);
	self->priv->pantheon_terminal_settings = _tmp0_;
	_tmp1_ = self->priv->pantheon_terminal_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "font");
	font_name = _tmp2_;
	_tmp3_ = font_name;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GSettings* system_settings = NULL;
		GSettings* _tmp4_;
		GSettings* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = g_settings_new ("org.gnome.desktop.interface");
		system_settings = _tmp4_;
		_tmp5_ = system_settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "monospace-font-name");
		_g_free0 (font_name);
		font_name = _tmp6_;
		_g_object_unref0 (system_settings);
	}
	_tmp7_ = font_name;
	_tmp8_ = pango_font_description_from_string (_tmp7_);
	fd = _tmp8_;
	_tmp9_ = self->priv->_terminal;
	_tmp10_ = fd;
	vte_terminal_set_font (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->pantheon_terminal_settings;
	audible_bell_setting = g_settings_get_boolean (_tmp11_, "audible-bell");
	_tmp12_ = self->priv->_terminal;
	vte_terminal_set_audible_bell (_tmp12_, audible_bell_setting);
	_tmp13_ = self->priv->pantheon_terminal_settings;
	_tmp14_ = g_settings_get_string (_tmp13_, "cursor-shape");
	cursor_shape_setting = _tmp14_;
	_tmp15_ = cursor_shape_setting;
	_tmp16_ = _tmp15_;
	_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
	if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("Block")))) {
		switch (0) {
			default:
			{
				VteTerminal* _tmp19_;
				_tmp19_ = self->priv->_terminal;
				vte_terminal_set_cursor_shape (_tmp19_, VTE_CURSOR_SHAPE_BLOCK);
				break;
			}
		}
	} else if (_tmp18_ == ((0 != _tmp17_label1) ? _tmp17_label1 : (_tmp17_label1 = g_quark_from_static_string ("I-Beam")))) {
		switch (0) {
			default:
			{
				VteTerminal* _tmp20_;
				_tmp20_ = self->priv->_terminal;
				vte_terminal_set_cursor_shape (_tmp20_, VTE_CURSOR_SHAPE_IBEAM);
				break;
			}
		}
	} else if (_tmp18_ == ((0 != _tmp17_label2) ? _tmp17_label2 : (_tmp17_label2 = g_quark_from_static_string ("Underline")))) {
		switch (0) {
			default:
			{
				VteTerminal* _tmp21_;
				_tmp21_ = self->priv->_terminal;
				vte_terminal_set_cursor_shape (_tmp21_, VTE_CURSOR_SHAPE_UNDERLINE);
				break;
			}
		}
	}
	_tmp22_ = self->priv->pantheon_terminal_settings;
	_tmp23_ = g_settings_get_string (_tmp22_, "background");
	background_setting = _tmp23_;
	memset (&background_color, 0, sizeof (GdkRGBA));
	_tmp24_ = background_setting;
	gdk_rgba_parse (&background_color, _tmp24_);
	_tmp25_ = self->priv->pantheon_terminal_settings;
	_tmp26_ = g_settings_get_string (_tmp25_, "foreground");
	foreground_setting = _tmp26_;
	memset (&foreground_color, 0, sizeof (GdkRGBA));
	_tmp27_ = foreground_setting;
	gdk_rgba_parse (&foreground_color, _tmp27_);
	_tmp28_ = self->priv->pantheon_terminal_settings;
	_tmp29_ = g_settings_get_string (_tmp28_, "palette");
	palette_setting = _tmp29_;
	_tmp30_ = g_strdup ("#000000");
	_tmp31_ = g_strdup ("#FF6C60");
	_tmp32_ = g_strdup ("#A8FF60");
	_tmp33_ = g_strdup ("#FFFFCC");
	_tmp34_ = g_strdup ("#96CBFE");
	_tmp35_ = g_strdup ("#FF73FE");
	_tmp36_ = g_strdup ("#C6C5FE");
	_tmp37_ = g_strdup ("#EEEEEE");
	_tmp38_ = g_strdup ("#000000");
	_tmp39_ = g_strdup ("#FF6C60");
	_tmp40_ = g_strdup ("#A8FF60");
	_tmp41_ = g_strdup ("#FFFFB6");
	_tmp42_ = g_strdup ("#96CBFE");
	_tmp43_ = g_strdup ("#FF73FE");
	_tmp44_ = g_strdup ("#C6C5FE");
	_tmp45_ = g_strdup ("#EEEEEE");
	_tmp46_ = g_new0 (gchar*, 16 + 1);
	_tmp46_[0] = _tmp30_;
	_tmp46_[1] = _tmp31_;
	_tmp46_[2] = _tmp32_;
	_tmp46_[3] = _tmp33_;
	_tmp46_[4] = _tmp34_;
	_tmp46_[5] = _tmp35_;
	_tmp46_[6] = _tmp36_;
	_tmp46_[7] = _tmp37_;
	_tmp46_[8] = _tmp38_;
	_tmp46_[9] = _tmp39_;
	_tmp46_[10] = _tmp40_;
	_tmp46_[11] = _tmp41_;
	_tmp46_[12] = _tmp42_;
	_tmp46_[13] = _tmp43_;
	_tmp46_[14] = _tmp44_;
	_tmp46_[15] = _tmp45_;
	hex_palette = _tmp46_;
	hex_palette_length1 = 16;
	_hex_palette_size_ = hex_palette_length1;
	_tmp47_ = g_strdup ("");
	current_string = _tmp47_;
	current_color = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp48_ = FALSE;
			_tmp48_ = TRUE;
			while (TRUE) {
				const gchar* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				const gchar* _tmp53_;
				if (!_tmp48_) {
					gint _tmp49_;
					_tmp49_ = i;
					i = _tmp49_ + 1;
				}
				_tmp48_ = FALSE;
				_tmp50_ = palette_setting;
				_tmp51_ = strlen (_tmp50_);
				_tmp52_ = _tmp51_;
				if (!(i < _tmp52_)) {
					break;
				}
				_tmp53_ = palette_setting;
				if (string_get (_tmp53_, (glong) i) == ':') {
					gchar** _tmp54_;
					gint _tmp54__length1;
					const gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gint _tmp58_;
					_tmp54_ = hex_palette;
					_tmp54__length1 = hex_palette_length1;
					_tmp55_ = current_string;
					_tmp56_ = g_strdup (_tmp55_);
					_g_free0 (_tmp54_[current_color]);
					_tmp54_[current_color] = _tmp56_;
					_tmp57_ = g_strdup ("");
					_g_free0 (current_string);
					current_string = _tmp57_;
					_tmp58_ = current_color;
					current_color = _tmp58_ + 1;
				} else {
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					_tmp59_ = current_string;
					_tmp60_ = palette_setting;
					_tmp61_ = g_strdup_printf ("%c", string_get (_tmp60_, (glong) i));
					_tmp62_ = _tmp61_;
					_tmp63_ = g_strconcat (_tmp59_, _tmp62_, NULL);
					_g_free0 (current_string);
					current_string = _tmp63_;
					_g_free0 (_tmp62_);
				}
			}
		}
	}
	_tmp64_ = g_new0 (GdkRGBA, 16);
	palette = _tmp64_;
	palette_length1 = 16;
	_palette_size_ = palette_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				gchar** _tmp67_;
				gint _tmp67__length1;
				GdkRGBA new_color = {0};
				gchar** _tmp68_;
				gint _tmp68__length1;
				const gchar* _tmp69_;
				GdkRGBA* _tmp70_;
				gint _tmp70__length1;
				GdkRGBA _tmp71_;
				if (!_tmp65_) {
					gint _tmp66_;
					_tmp66_ = i;
					i = _tmp66_ + 1;
				}
				_tmp65_ = FALSE;
				_tmp67_ = hex_palette;
				_tmp67__length1 = hex_palette_length1;
				if (!(i < _tmp67__length1)) {
					break;
				}
				memset (&new_color, 0, sizeof (GdkRGBA));
				_tmp68_ = hex_palette;
				_tmp68__length1 = hex_palette_length1;
				_tmp69_ = _tmp68_[i];
				gdk_rgba_parse (&new_color, _tmp69_);
				_tmp70_ = palette;
				_tmp70__length1 = palette_length1;
				_tmp71_ = new_color;
				_tmp70_[i] = _tmp71_;
			}
		}
	}
	_tmp72_ = self->priv->_terminal;
	_tmp73_ = foreground_color;
	_tmp74_ = background_color;
	_tmp75_ = palette;
	_tmp75__length1 = palette_length1;
	vte_terminal_set_colors (_tmp72_, &_tmp73_, &_tmp74_, _tmp75_, (gsize) _tmp75__length1);
	palette = (g_free (palette), NULL);
	_g_free0 (current_string);
	hex_palette = (_vala_array_free (hex_palette, hex_palette_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (palette_setting);
	_g_free0 (foreground_setting);
	_g_free0 (background_setting);
	_g_free0 (cursor_shape_setting);
	__vala_PangoFontDescription_free0 (fd);
	_g_free0 (font_name);
}

void
code_terminal_increment_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	VteTerminal* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = self->priv->_terminal;
	_tmp2_ = vte_terminal_get_font_scale (_tmp1_);
	_tmp3_ = _tmp2_;
	vte_terminal_set_font_scale (_tmp0_, CLAMP (_tmp3_ + 0.1, CODE_TERMINAL_MIN_SCALE, CODE_TERMINAL_MAX_SCALE));
}

void
code_terminal_decrement_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	VteTerminal* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = self->priv->_terminal;
	_tmp2_ = vte_terminal_get_font_scale (_tmp1_);
	_tmp3_ = _tmp2_;
	vte_terminal_set_font_scale (_tmp0_, CLAMP (_tmp3_ - 0.1, CODE_TERMINAL_MIN_SCALE, CODE_TERMINAL_MAX_SCALE));
}

void
code_terminal_set_default_font_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	vte_terminal_set_font_scale (_tmp0_, 1.0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda126_ (CodeTerminal* self,
              guint keyval,
              guint code)
{
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkKeymap* keymap = NULL;
	GdkDisplay* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	GdkKeymap* _tmp3_;
	GdkKeymapKey* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean result;
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gdk_keymap_get_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keymap = _tmp2_;
	_tmp3_ = keymap;
	_tmp6_ = gdk_keymap_get_entries_for_keyval (_tmp3_, keyval, &_tmp4_, &_tmp5_);
	keys = (g_free (keys), NULL);
	keys = _tmp4_;
	keys_length1 = _tmp5_;
	_keys_size_ = keys_length1;
	if (_tmp6_) {
		GdkKeymapKey* _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = keys;
		_tmp7__length1 = keys_length1;
		{
			GdkKeymapKey* key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp7_;
			key_collection_length1 = _tmp7__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				GdkKeymapKey key = {0};
				key = key_collection[key_it];
				{
					GdkKeymapKey _tmp8_;
					_tmp8_ = key;
					if (code == _tmp8_.keycode) {
						result = GDK_EVENT_STOP;
						_g_object_unref0 (keymap);
						keys = (g_free (keys), NULL);
						return result;
					}
				}
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (keymap);
	keys = (g_free (keys), NULL);
	return result;
}

static gboolean
___lambda126___localfunc0_ (guint keyval,
                            guint code,
                            gpointer self)
{
	gboolean result;
	result = __lambda126_ ((CodeTerminal*) self, keyval, code);
	return result;
}

static gboolean
code_terminal_key_pressed (CodeTerminal* self,
                           guint keyval,
                           guint keycode,
                           GdkModifierType modifiers)
{
	_LocalFunc0_ match_keycode = NULL;
	gpointer match_keycode_target;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	match_keycode = ___lambda126___localfunc0_;
	match_keycode_target = self;
	if ((modifiers & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->pantheon_terminal_settings;
		_tmp0_ = g_settings_get_boolean (_tmp1_, "natural-copy-paste");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp2_ = FALSE;
		_LocalFunc0_ _tmp3_;
		gpointer _tmp3__target;
		_tmp3_ = match_keycode;
		_tmp3__target = match_keycode_target;
		if (_tmp3_ (GDK_KEY_c, keycode, _tmp3__target)) {
			VteTerminal* _tmp4_;
			_tmp4_ = self->priv->_terminal;
			_tmp2_ = vte_terminal_get_has_selection (_tmp4_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GSimpleActionGroup* _tmp5_;
			_tmp5_ = self->priv->_actions;
			g_action_group_activate_action ((GActionGroup*) _tmp5_, CODE_TERMINAL_ACTION_COPY, NULL);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			gboolean _tmp6_ = FALSE;
			_LocalFunc0_ _tmp7_;
			gpointer _tmp7__target;
			_tmp7_ = match_keycode;
			_tmp7__target = match_keycode_target;
			if (_tmp7_ (GDK_KEY_v, keycode, _tmp7__target)) {
				GtkClipboard* _tmp8_;
				_tmp8_ = self->priv->current_clipboard;
				_tmp6_ = gtk_clipboard_wait_is_text_available (_tmp8_);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				GSimpleActionGroup* _tmp9_;
				_tmp9_ = self->priv->_actions;
				g_action_group_activate_action ((GActionGroup*) _tmp9_, CODE_TERMINAL_ACTION_PASTE, NULL);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

CodeTerminal*
code_terminal_construct (GType object_type)
{
	CodeTerminal * self = NULL;
	self = (CodeTerminal*) g_object_new (object_type, NULL);
	return self;
}

CodeTerminal*
code_terminal_new (void)
{
	return code_terminal_construct (CODE_TYPE_TERMINAL);
}

VteTerminal*
code_terminal_get_terminal (CodeTerminal* self)
{
	VteTerminal* result;
	VteTerminal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_terminal;
	result = _tmp0_;
	return result;
}

static void
code_terminal_set_terminal (CodeTerminal* self,
                            VteTerminal* value)
{
	VteTerminal* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_terminal_get_terminal (self);
	if (old_value != value) {
		VteTerminal* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_terminal);
		self->priv->_terminal = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_terminal_properties[CODE_TERMINAL_TERMINAL_PROPERTY]);
	}
}

GSimpleActionGroup*
code_terminal_get_actions (CodeTerminal* self)
{
	GSimpleActionGroup* result;
	GSimpleActionGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	result = _tmp0_;
	return result;
}

static void
code_terminal_set_actions (CodeTerminal* self,
                           GSimpleActionGroup* value)
{
	GSimpleActionGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_terminal_get_actions (self);
	if (old_value != value) {
		GSimpleActionGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actions);
		self->priv->_actions = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_terminal_properties[CODE_TERMINAL_ACTIONS_PROPERTY]);
	}
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		CodeTerminal* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->settings);
		_g_object_unref0 (_data52_->menu);
		_g_object_unref0 (_data52_->paste_action);
		_g_object_unref0 (_data52_->copy_action);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_code_terminal___lambda127_ (CodeTerminal* self)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	g_action_group_activate_action ((GActionGroup*) _tmp0_, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_TERMINAL, NULL);
}

static void
__code_terminal___lambda127__vte_terminal_child_exited (VteTerminal* _sender,
                                                        gint status,
                                                        gpointer self)
{
	_code_terminal___lambda127_ ((CodeTerminal*) self);
}

static void
_code_terminal___lambda128_ (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	_tmp0_ = self->priv->_terminal;
	vte_terminal_copy_clipboard (_tmp0_);
}

static void
__code_terminal___lambda128__g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	_code_terminal___lambda128_ ((CodeTerminal*) self);
}

static void
_code_terminal___lambda129_ (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	_tmp0_ = self->priv->_terminal;
	vte_terminal_paste_clipboard (_tmp0_);
}

static void
__code_terminal___lambda129__g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	_code_terminal___lambda129_ ((CodeTerminal*) self);
}

static gboolean
_code_terminal_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                 guint keyval,
                                                                 guint keycode,
                                                                 GdkModifierType state,
                                                                 gpointer self)
{
	gboolean result;
	result = code_terminal_key_pressed ((CodeTerminal*) self, keyval, keycode, state);
	return result;
}

static gboolean
_code_terminal___lambda130_ (Block52Data* _data52_,
                             GdkEventButton* event)
{
	CodeTerminal* self;
	gboolean result;
	self = _data52_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 3)) {
		GSimpleAction* _tmp0_;
		GtkClipboard* _tmp1_;
		GtkMenu* _tmp2_;
		GtkMenu* _tmp3_;
		_tmp0_ = _data52_->paste_action;
		_tmp1_ = self->priv->current_clipboard;
		g_simple_action_set_enabled (_tmp0_, gtk_clipboard_wait_is_text_available (_tmp1_));
		_tmp2_ = _data52_->menu;
		gtk_menu_shell_select_first ((GtkMenuShell*) _tmp2_, FALSE);
		_tmp3_ = _data52_->menu;
		gtk_menu_popup_at_pointer (_tmp3_, (GdkEvent*) event);
	}
	result = FALSE;
	return result;
}

static gboolean
__code_terminal___lambda130__gtk_widget_button_press_event (GtkWidget* _sender,
                                                            GdkEventButton* event,
                                                            gpointer self)
{
	gboolean result;
	result = _code_terminal___lambda130_ (self, event);
	return result;
}

static void
_code_terminal___lambda131_ (Block52Data* _data52_)
{
	CodeTerminal* self;
	VteTerminal* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	GSimpleAction* _tmp3_;
	VteTerminal* _tmp4_;
	self = _data52_->self;
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = gtk_widget_get_clipboard ((GtkWidget*) _tmp0_, GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->current_clipboard);
	self->priv->current_clipboard = _tmp2_;
	_tmp3_ = _data52_->copy_action;
	_tmp4_ = self->priv->_terminal;
	g_simple_action_set_enabled (_tmp3_, vte_terminal_get_has_selection (_tmp4_));
}

static void
__code_terminal___lambda131__gtk_widget_realize (GtkWidget* _sender,
                                                 gpointer self)
{
	_code_terminal___lambda131_ (self);
}

static void
_code_terminal___lambda132_ (Block52Data* _data52_)
{
	CodeTerminal* self;
	GSimpleAction* _tmp0_;
	VteTerminal* _tmp1_;
	self = _data52_->self;
	_tmp0_ = _data52_->copy_action;
	_tmp1_ = self->priv->_terminal;
	g_simple_action_set_enabled (_tmp0_, vte_terminal_get_has_selection (_tmp1_));
}

static void
__code_terminal___lambda132__vte_terminal_selection_changed (VteTerminal* _sender,
                                                             gpointer self)
{
	_code_terminal___lambda132_ (self);
}

static void
_code_terminal___lambda133_ (Block52Data* _data52_)
{
	CodeTerminal* self;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data52_->self;
	_tmp0_ = _data52_->settings;
	_tmp1_ = code_terminal_get_shell_location (self);
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "last-opened-path", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__code_terminal___lambda133__gtk_widget_destroy (GtkWidget* _sender,
                                                 gpointer self)
{
	_code_terminal___lambda133_ (self);
}

static GObject *
code_terminal_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CodeTerminal * self;
	Block52Data* _data52_;
	VteTerminal* _tmp0_ = NULL;
	VteTerminal* _tmp1_;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSettingsSchema* terminal_schema = NULL;
	GSettingsSchemaSource* _tmp4_;
	GSettingsSchema* _tmp5_;
	GSettingsSchema* _tmp6_;
	VteTerminal* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleActionGroup* _tmp16_;
	GSimpleActionGroup* _tmp17_;
	GSimpleActionGroup* _tmp18_;
	GSimpleAction* _tmp19_;
	GSimpleActionGroup* _tmp20_;
	GSimpleAction* _tmp21_;
	GMenu* menu_model = NULL;
	GMenu* _tmp22_;
	GMenu* _tmp23_;
	GMenu* _tmp24_;
	GMenu* _tmp25_;
	GtkMenu* _tmp26_;
	GtkMenu* _tmp27_;
	GSimpleActionGroup* _tmp28_;
	GtkMenu* _tmp29_;
	VteTerminal* _tmp30_;
	GtkEventControllerKey* _tmp31_ = NULL;
	GtkEventControllerKey* _tmp32_;
	VteTerminal* _tmp33_;
	VteTerminal* _tmp34_;
	GSettings* _tmp35_;
	GSettings* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GtkScrolledWindow* scrolled_window = NULL;
	VteTerminal* _tmp39_;
	GtkAdjustment* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	VteTerminal* _tmp43_;
	GtkScrolledWindow* _tmp44_;
	parent_class = G_OBJECT_CLASS (code_terminal_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_TERMINAL, CodeTerminal);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_tmp0_ = (VteTerminal*) vte_terminal_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, TRUE);
	vte_terminal_set_scrollback_lines (_tmp0_, (guint) -1);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	code_terminal_set_terminal (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	schema_source = _tmp3_;
	_tmp4_ = schema_source;
	_tmp5_ = g_settings_schema_source_lookup (_tmp4_, CODE_TERMINAL_SETTINGS_SCHEMA, TRUE);
	terminal_schema = _tmp5_;
	_tmp6_ = terminal_schema;
	if (_tmp6_ != NULL) {
		code_terminal_update_terminal_settings (self, CODE_TERMINAL_SETTINGS_SCHEMA);
	} else {
		GSettingsSchema* legacy_terminal_schema = NULL;
		GSettingsSchemaSource* _tmp7_;
		GSettingsSchema* _tmp8_;
		GSettingsSchema* _tmp9_;
		_tmp7_ = schema_source;
		_tmp8_ = g_settings_schema_source_lookup (_tmp7_, CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA, TRUE);
		legacy_terminal_schema = _tmp8_;
		_tmp9_ = legacy_terminal_schema;
		if (_tmp9_ != NULL) {
			code_terminal_update_terminal_settings (self, CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA);
		}
		_g_settings_schema_unref0 (legacy_terminal_schema);
	}
	_tmp10_ = self->priv->_terminal;
	g_signal_connect_object (_tmp10_, "child-exited", (GCallback) __code_terminal___lambda127__vte_terminal_child_exited, self, 0);
	_tmp11_ = g_simple_action_new (CODE_TERMINAL_ACTION_COPY, NULL);
	_data52_->copy_action = _tmp11_;
	_tmp12_ = _data52_->copy_action;
	g_simple_action_set_enabled (_tmp12_, FALSE);
	_tmp13_ = _data52_->copy_action;
	g_signal_connect_object (_tmp13_, "activate", (GCallback) __code_terminal___lambda128__g_simple_action_activate, self, 0);
	_tmp14_ = g_simple_action_new (CODE_TERMINAL_ACTION_PASTE, NULL);
	_data52_->paste_action = _tmp14_;
	_tmp15_ = _data52_->paste_action;
	g_signal_connect_object (_tmp15_, "activate", (GCallback) __code_terminal___lambda129__g_simple_action_activate, self, 0);
	_tmp16_ = g_simple_action_group_new ();
	_tmp17_ = _tmp16_;
	code_terminal_set_actions (self, _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->_actions;
	_tmp19_ = _data52_->copy_action;
	g_action_map_add_action ((GActionMap*) _tmp18_, (GAction*) _tmp19_);
	_tmp20_ = self->priv->_actions;
	_tmp21_ = _data52_->paste_action;
	g_action_map_add_action ((GActionMap*) _tmp20_, (GAction*) _tmp21_);
	_tmp22_ = g_menu_new ();
	menu_model = _tmp22_;
	_tmp23_ = menu_model;
	g_menu_append (_tmp23_, _ ("Copy"), CODE_TERMINAL_ACTION_PREFIX CODE_TERMINAL_ACTION_COPY);
	_tmp24_ = menu_model;
	g_menu_append (_tmp24_, _ ("Paste"), CODE_TERMINAL_ACTION_PREFIX CODE_TERMINAL_ACTION_PASTE);
	_tmp25_ = menu_model;
	_tmp26_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp25_);
	g_object_ref_sink (_tmp26_);
	_data52_->menu = _tmp26_;
	_tmp27_ = _data52_->menu;
	_tmp28_ = self->priv->_actions;
	gtk_widget_insert_action_group ((GtkWidget*) _tmp27_, CODE_TERMINAL_ACTION_GROUP, (GActionGroup*) _tmp28_);
	_tmp29_ = _data52_->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->_terminal;
	_tmp31_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp30_);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp31_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp31_;
	_tmp32_ = self->priv->key_controller;
	g_signal_connect_object (_tmp32_, "key-pressed", (GCallback) _code_terminal_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp33_ = self->priv->_terminal;
	g_signal_connect_data ((GtkWidget*) _tmp33_, "button-press-event", (GCallback) __code_terminal___lambda130__gtk_widget_button_press_event, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) __code_terminal___lambda131__gtk_widget_realize, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	_tmp34_ = self->priv->_terminal;
	g_signal_connect_data (_tmp34_, "selection-changed", (GCallback) __code_terminal___lambda132__vte_terminal_selection_changed, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	_tmp35_ = g_settings_new (CONSTANTS_PROJECT_NAME ".saved-state");
	_data52_->settings = _tmp35_;
	_tmp36_ = _data52_->settings;
	_tmp37_ = g_settings_get_string (_tmp36_, "last-opened-path");
	_tmp38_ = _tmp37_;
	code_terminal_spawn_shell (self, _tmp38_);
	_g_free0 (_tmp38_);
	_tmp39_ = self->priv->_terminal;
	_tmp40_ = gtk_scrollable_get_vadjustment ((GtkScrollable*) _tmp39_);
	_tmp41_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, _tmp40_);
	g_object_ref_sink (_tmp41_);
	scrolled_window = _tmp41_;
	_tmp42_ = scrolled_window;
	_tmp43_ = self->priv->_terminal;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp44_);
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __code_terminal___lambda133__gtk_widget_destroy, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (menu_model);
	_g_settings_schema_unref0 (terminal_schema);
	_g_settings_schema_source_unref0 (schema_source);
	block52_data_unref (_data52_);
	_data52_ = NULL;
	return obj;
}

static void
code_terminal_class_init (CodeTerminalClass * klass,
                          gpointer klass_data)
{
	code_terminal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodeTerminal_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_code_terminal_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_terminal_set_property;
	G_OBJECT_CLASS (klass)->constructor = code_terminal_constructor;
	G_OBJECT_CLASS (klass)->finalize = code_terminal_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_TERMINAL_TERMINAL_PROPERTY, code_terminal_properties[CODE_TERMINAL_TERMINAL_PROPERTY] = g_param_spec_object ("terminal", "terminal", "terminal", vte_terminal_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_TERMINAL_ACTIONS_PROPERTY, code_terminal_properties[CODE_TERMINAL_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", g_simple_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
code_terminal_instance_init (CodeTerminal * self,
                             gpointer klass)
{
	self->priv = code_terminal_get_instance_private (self);
}

static void
code_terminal_finalize (GObject * obj)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_TERMINAL, CodeTerminal);
	_g_object_unref0 (self->priv->_terminal);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->pantheon_terminal_settings);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->current_clipboard);
	G_OBJECT_CLASS (code_terminal_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
code_terminal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodeTerminalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_terminal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodeTerminal), 0, (GInstanceInitFunc) code_terminal_instance_init, NULL };
	GType code_terminal_type_id;
	code_terminal_type_id = g_type_register_static (gtk_box_get_type (), "CodeTerminal", &g_define_type_info, 0);
	CodeTerminal_private_offset = g_type_add_instance_private (code_terminal_type_id, sizeof (CodeTerminalPrivate));
	return code_terminal_type_id;
}

GType
code_terminal_get_type (void)
{
	static gsize code_terminal_type_id__once = 0;
	if (g_once_init_enter (&code_terminal_type_id__once)) {
		GType code_terminal_type_id;
		code_terminal_type_id = code_terminal_get_type_once ();
		g_once_init_leave (&code_terminal_type_id__once, code_terminal_type_id);
	}
	return code_terminal_type_id__once;
}

static void
_vala_code_terminal_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_TERMINAL, CodeTerminal);
	switch (property_id) {
		case CODE_TERMINAL_TERMINAL_PROPERTY:
		g_value_set_object (value, code_terminal_get_terminal (self));
		break;
		case CODE_TERMINAL_ACTIONS_PROPERTY:
		g_value_set_object (value, code_terminal_get_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_terminal_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_TERMINAL, CodeTerminal);
	switch (property_id) {
		case CODE_TERMINAL_TERMINAL_PROPERTY:
		code_terminal_set_terminal (self, g_value_get_object (value));
		break;
		case CODE_TERMINAL_ACTIONS_PROPERTY:
		code_terminal_set_actions (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

