/* Header.c generated by valac 0.56.17, the Vala compiler
 * generated from Header.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2015 Maya Developers (http://launchpad.net/maya)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include "elementary-calendar.h"
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_HEADER (maya_view_header_get_type ())
#define MAYA_VIEW_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_HEADER, MayaViewHeader))
#define MAYA_VIEW_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_HEADER, MayaViewHeaderClass))
#define MAYA_VIEW_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_HEADER))
#define MAYA_VIEW_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_HEADER))
#define MAYA_VIEW_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_HEADER, MayaViewHeaderClass))

typedef struct _MayaViewHeader MayaViewHeader;
typedef struct _MayaViewHeaderClass MayaViewHeaderClass;
typedef struct _MayaViewHeaderPrivate MayaViewHeaderPrivate;
enum  {
	MAYA_VIEW_HEADER_0_PROPERTY,
	MAYA_VIEW_HEADER_NUM_PROPERTIES
};
static GParamSpec* maya_view_header_properties[MAYA_VIEW_HEADER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MayaViewHeader {
	GtkEventBox parent_instance;
	MayaViewHeaderPrivate * priv;
};

struct _MayaViewHeaderClass {
	GtkEventBoxClass parent_class;
};

struct _MayaViewHeaderPrivate {
	GtkGrid* header_grid;
	GtkLabel** labels;
	gint labels_length1;
	gint _labels_size_;
};

static gint MayaViewHeader_private_offset;
static gpointer maya_view_header_parent_class = NULL;
static GSettings* maya_view_header_show_weeks;
static GSettings* maya_view_header_show_weeks = NULL;
static GtkCssProvider* maya_view_header_style_provider;
static GtkCssProvider* maya_view_header_style_provider = NULL;
VALA_EXTERN GSettings* maya_application_wingpanel_settings;
VALA_EXTERN GSettings* maya_application_saved_state;

VALA_EXTERN GType maya_view_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewHeader, g_object_unref)
VALA_EXTERN void maya_view_header_update_columns (MayaViewHeader* self,
                                      gint week_starts_on);
VALA_EXTERN MayaViewHeader* maya_view_header_new (void);
VALA_EXTERN MayaViewHeader* maya_view_header_construct (GType object_type);
static GObject * maya_view_header_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static gboolean _maya_view_header___lambda7_ (MayaViewHeader* self,
                                       GdkEventButton* event);
static void ___lambda8_ (MayaViewHeader* self);
static void ____lambda8__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static gboolean __maya_view_header___lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self);
static void maya_view_header_finalize (GObject * obj);
static GType maya_view_header_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
maya_view_header_get_instance_private (MayaViewHeader* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewHeader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
maya_view_header_update_columns (MayaViewHeader* self,
                                 gint week_starts_on)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GtkLabel** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = calendar_util_datetime_strip_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	date = _tmp3_;
	_tmp4_ = date;
	_tmp5_ = date;
	_tmp6_ = g_date_time_add_days (_tmp4_, week_starts_on - g_date_time_get_day_of_week (_tmp5_));
	_g_date_time_unref0 (date);
	date = _tmp6_;
	_tmp7_ = self->priv->labels;
	_tmp7__length1 = self->priv->labels_length1;
	{
		GtkLabel** label_collection = NULL;
		gint label_collection_length1 = 0;
		gint _label_collection_size_ = 0;
		gint label_it = 0;
		label_collection = _tmp7_;
		label_collection_length1 = _tmp7__length1;
		for (label_it = 0; label_it < label_collection_length1; label_it = label_it + 1) {
			GtkLabel* _tmp8_;
			GtkLabel* label = NULL;
			_tmp8_ = _g_object_ref0 (label_collection[label_it]);
			label = _tmp8_;
			{
				GtkLabel* _tmp9_;
				GDateTime* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GDateTime* _tmp13_;
				GDateTime* _tmp14_;
				_tmp9_ = label;
				_tmp10_ = date;
				_tmp11_ = g_date_time_format (_tmp10_, "%a");
				_tmp12_ = _tmp11_;
				gtk_label_set_label (_tmp9_, _tmp12_);
				_g_free0 (_tmp12_);
				_tmp13_ = date;
				_tmp14_ = g_date_time_add_days (_tmp13_, 1);
				_g_date_time_unref0 (date);
				date = _tmp14_;
				_g_object_unref0 (label);
			}
		}
	}
	_g_date_time_unref0 (date);
}

MayaViewHeader*
maya_view_header_construct (GType object_type)
{
	MayaViewHeader * self = NULL;
	self = (MayaViewHeader*) g_object_new (object_type, NULL);
	return self;
}

MayaViewHeader*
maya_view_header_new (void)
{
	return maya_view_header_construct (MAYA_VIEW_TYPE_HEADER);
}

static void
___lambda8_ (MayaViewHeader* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = maya_view_header_show_weeks;
	_tmp1_ = maya_view_header_show_weeks;
	g_settings_set_boolean (_tmp0_, "show-weeks", !g_settings_get_boolean (_tmp1_, "show-weeks"));
}

static void
____lambda8__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	___lambda8_ ((MayaViewHeader*) self);
}

static gboolean
_maya_view_header___lambda7_ (MayaViewHeader* self,
                              GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type == GDK_BUTTON_PRESS) {
		_tmp0_ = event->button == ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMenuItem* show_weeks_menuitem = NULL;
		GtkMenuItem* _tmp1_;
		GSettings* _tmp2_;
		GtkMenuItem* _tmp5_;
		GtkMenu* menu = NULL;
		GtkMenu* _tmp6_;
		GtkMenu* _tmp7_;
		GtkMenu* _tmp8_;
		GtkMenuItem* _tmp9_;
		GtkMenu* _tmp10_;
		GtkMenu* _tmp11_;
		_tmp1_ = (GtkMenuItem*) gtk_menu_item_new ();
		g_object_ref_sink (_tmp1_);
		show_weeks_menuitem = _tmp1_;
		_tmp2_ = maya_view_header_show_weeks;
		if (g_settings_get_boolean (_tmp2_, "show-weeks")) {
			GtkMenuItem* _tmp3_;
			_tmp3_ = show_weeks_menuitem;
			gtk_menu_item_set_label (_tmp3_, _ ("Hide Week Numbers"));
		} else {
			GtkMenuItem* _tmp4_;
			_tmp4_ = show_weeks_menuitem;
			gtk_menu_item_set_label (_tmp4_, _ ("Show Week Numbers"));
		}
		_tmp5_ = show_weeks_menuitem;
		g_signal_connect_object (_tmp5_, "activate", (GCallback) ____lambda8__gtk_menu_item_activate, self, 0);
		_tmp6_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp6_);
		menu = _tmp6_;
		_tmp7_ = menu;
		gtk_menu_attach_to_widget (_tmp7_, (GtkWidget*) self, NULL);
		_tmp8_ = menu;
		_tmp9_ = show_weeks_menuitem;
		gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
		_tmp10_ = menu;
		gtk_widget_show_all ((GtkWidget*) _tmp10_);
		_tmp11_ = menu;
		gtk_menu_popup_at_pointer (_tmp11_, (GdkEvent*) event);
		_g_object_unref0 (menu);
		_g_object_unref0 (show_weeks_menuitem);
	}
	result = FALSE;
	return result;
}

static gboolean
__maya_view_header___lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                                             GdkEventButton* event,
                                                             gpointer self)
{
	gboolean result;
	result = _maya_view_header___lambda7_ ((MayaViewHeader*) self, event);
	return result;
}

static GObject *
maya_view_header_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewHeader * self;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkCssProvider* _tmp10_;
	GtkLabel** _tmp11_;
	GtkGrid* _tmp27_;
	parent_class = G_OBJECT_CLASS (maya_view_header_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_HEADER, MayaViewHeader);
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_BUTTON_PRESS_MASK);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->header_grid);
	self->priv->header_grid = _tmp2_;
	_tmp3_ = self->priv->header_grid;
	gtk_grid_insert_column (_tmp3_, 7);
	_tmp4_ = self->priv->header_grid;
	gtk_grid_insert_row (_tmp4_, 1);
	_tmp5_ = self->priv->header_grid;
	gtk_grid_set_column_homogeneous (_tmp5_, TRUE);
	_tmp6_ = self->priv->header_grid;
	gtk_grid_set_row_homogeneous (_tmp6_, TRUE);
	_tmp7_ = self->priv->header_grid;
	gtk_grid_set_column_spacing (_tmp7_, 0);
	_tmp8_ = self->priv->header_grid;
	gtk_grid_set_row_spacing (_tmp8_, 0);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, TRUE);
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp10_ = maya_view_header_style_provider;
	gtk_style_context_add_provider (_tmp9_, (GtkStyleProvider*) _tmp10_, (guint) 600);
	_tmp11_ = g_new0 (GtkLabel*, 7 + 1);
	self->priv->labels = (_vala_array_free (self->priv->labels, self->priv->labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->labels = _tmp11_;
	self->priv->labels_length1 = 7;
	self->priv->_labels_size_ = self->priv->labels_length1;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GtkLabel** _tmp14_;
				gint _tmp14__length1;
				GtkLabel* _tmp15_;
				GtkLabel** _tmp16_;
				gint _tmp16__length1;
				GtkLabel* _tmp17_;
				GtkStyleContext* label_context = NULL;
				GtkLabel** _tmp18_;
				gint _tmp18__length1;
				GtkLabel* _tmp19_;
				GtkStyleContext* _tmp20_;
				GtkStyleContext* _tmp21_;
				GtkCssProvider* _tmp22_;
				GtkStyleContext* _tmp23_;
				GtkGrid* _tmp24_;
				GtkLabel** _tmp25_;
				gint _tmp25__length1;
				GtkLabel* _tmp26_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = c;
					c = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(c < 7)) {
					break;
				}
				_tmp14_ = self->priv->labels;
				_tmp14__length1 = self->priv->labels_length1;
				_tmp15_ = (GtkLabel*) gtk_label_new ("");
				g_object_ref_sink (_tmp15_);
				_g_object_unref0 (_tmp14_[c]);
				_tmp14_[c] = _tmp15_;
				_tmp16_ = self->priv->labels;
				_tmp16__length1 = self->priv->labels_length1;
				_tmp17_ = _tmp16_[c];
				gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
				_tmp18_ = self->priv->labels;
				_tmp18__length1 = self->priv->labels_length1;
				_tmp19_ = _tmp18_[c];
				_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
				label_context = _tmp20_;
				_tmp21_ = label_context;
				_tmp22_ = maya_view_header_style_provider;
				gtk_style_context_add_provider (_tmp21_, (GtkStyleProvider*) _tmp22_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
				_tmp23_ = label_context;
				gtk_style_context_add_class (_tmp23_, "daylabel");
				_tmp24_ = self->priv->header_grid;
				_tmp25_ = self->priv->labels;
				_tmp25__length1 = self->priv->labels_length1;
				_tmp26_ = _tmp25_[c];
				gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp26_, c, 0, 1, 1);
			}
		}
	}
	_tmp27_ = self->priv->header_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp27_);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) __maya_view_header___lambda7__gtk_widget_button_press_event, self, 0);
	return obj;
}

static void
maya_view_header_class_init (MayaViewHeaderClass * klass,
                             gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GSettings* _tmp2_;
	maya_view_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewHeader_private_offset);
	G_OBJECT_CLASS (klass)->constructor = maya_view_header_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_header_finalize;
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (maya_view_header_style_provider);
	maya_view_header_style_provider = _tmp0_;
	_tmp1_ = maya_view_header_style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/calendar/Header.css");
	_tmp2_ = maya_application_wingpanel_settings;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp3_ = maya_application_wingpanel_settings;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (maya_view_header_show_weeks);
		maya_view_header_show_weeks = _tmp4_;
	} else {
		GSettings* _tmp5_;
		GSettings* _tmp6_;
		_tmp5_ = maya_application_saved_state;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (maya_view_header_show_weeks);
		maya_view_header_show_weeks = _tmp6_;
	}
}

static void
maya_view_header_instance_init (MayaViewHeader * self,
                                gpointer klass)
{
	self->priv = maya_view_header_get_instance_private (self);
}

static void
maya_view_header_finalize (GObject * obj)
{
	MayaViewHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_HEADER, MayaViewHeader);
	_g_object_unref0 (self->priv->header_grid);
	self->priv->labels = (_vala_array_free (self->priv->labels, self->priv->labels_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (maya_view_header_parent_class)->finalize (obj);
}

/**
 * Represents the header at the top of the calendar grid.
 */
static GType
maya_view_header_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewHeader), 0, (GInstanceInitFunc) maya_view_header_instance_init, NULL };
	GType maya_view_header_type_id;
	maya_view_header_type_id = g_type_register_static (gtk_event_box_get_type (), "MayaViewHeader", &g_define_type_info, 0);
	MayaViewHeader_private_offset = g_type_add_instance_private (maya_view_header_type_id, sizeof (MayaViewHeaderPrivate));
	return maya_view_header_type_id;
}

GType
maya_view_header_get_type (void)
{
	static volatile gsize maya_view_header_type_id__once = 0;
	if (g_once_init_enter (&maya_view_header_type_id__once)) {
		GType maya_view_header_type_id;
		maya_view_header_type_id = maya_view_header_get_type_once ();
		g_once_init_leave (&maya_view_header_type_id__once, maya_view_header_type_id);
	}
	return maya_view_header_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

