/* CalDAVBackend.c generated by valac 0.56.17, the Vala compiler
 * generated from CalDAVBackend.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2013 Maya Developers (https://launchpad.net/maya)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "caldav.h"
#include <gmodule.h>
#include "elementary-calendar.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAYA_CAL_DAV_BACKEND_0_PROPERTY,
	MAYA_CAL_DAV_BACKEND_NUM_PROPERTIES
};
static GParamSpec* maya_cal_dav_backend_properties[MAYA_CAL_DAV_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

MayaBackend* backend = NULL;
static gpointer maya_cal_dav_backend_parent_class = NULL;
static MayaBackendIface * maya_cal_dav_backend_maya_backend_parent_iface = NULL;

static gchar* maya_cal_dav_backend_real_get_name (MayaBackend* base);
static gchar* maya_cal_dav_backend_real_get_uid (MayaBackend* base);
static GeeCollection* maya_cal_dav_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                                  ESource* to_edit);
static void maya_cal_dav_backend_real_add_new_calendar (MayaBackend* base,
                                                 const gchar* name,
                                                 const gchar* color,
                                                 gboolean set_default,
                                                 GeeCollection* widgets);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void maya_cal_dav_backend_real_modify_calendar (MayaBackend* base,
                                                const gchar* name,
                                                const gchar* color,
                                                gboolean set_default,
                                                GeeCollection* widgets,
                                                ESource* source);
static GType maya_cal_dav_backend_get_type_once (void);

MayaBackend*
get_backend (GModule* module)
{
	MayaCalDavBackend* b = NULL;
	MayaCalDavBackend* _tmp0_;
	MayaBackend* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("CalDAVBackend.vala:24: Activating CalDAV Backend");
	_tmp0_ = maya_cal_dav_backend_new ();
	b = _tmp0_;
	g_object_ref ((GObject*) b);
	result = (MayaBackend*) b;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MayaCalDavBackend*
maya_cal_dav_backend_construct (GType object_type)
{
	MayaCalDavBackend * self = NULL;
	MayaBackend* _tmp0_;
	self = (MayaCalDavBackend*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 ((MayaBackend*) self);
	_g_object_unref0 (backend);
	backend = _tmp0_;
	return self;
}

MayaCalDavBackend*
maya_cal_dav_backend_new (void)
{
	return maya_cal_dav_backend_construct (MAYA_TYPE_CAL_DAV_BACKEND);
}

static gchar*
maya_cal_dav_backend_real_get_name (MayaBackend* base)
{
	MayaCalDavBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaCalDavBackend*) base;
	_tmp0_ = g_strdup (_ ("CalDAV"));
	result = _tmp0_;
	return result;
}

static gchar*
maya_cal_dav_backend_real_get_uid (MayaBackend* base)
{
	MayaCalDavBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaCalDavBackend*) base;
	_tmp0_ = g_strdup ("caldav-stub");
	result = _tmp0_;
	return result;
}

static GeeCollection*
maya_cal_dav_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                   ESource* to_edit)
{
	MayaCalDavBackend * self;
	GeeLinkedList* collection = NULL;
	GeeLinkedList* _tmp0_;
	gboolean keep_copy = FALSE;
	GeeLinkedList* _tmp6_;
	MayaPlacementWidget* _tmp7_;
	MayaPlacementWidget* _tmp8_;
	MayaPlacementWidget* url_label = NULL;
	MayaPlacementWidget* _tmp9_;
	MayaPlacementWidget* _tmp10_;
	GtkLabel* _tmp11_;
	MayaPlacementWidget* _tmp12_;
	GtkWidget* _tmp13_;
	MayaPlacementWidget* _tmp14_;
	GtkWidget* _tmp15_;
	MayaPlacementWidget* _tmp16_;
	MayaPlacementWidget* _tmp17_;
	MayaPlacementWidget* _tmp18_;
	gchar* _tmp19_;
	GeeLinkedList* _tmp20_;
	MayaPlacementWidget* _tmp21_;
	MayaPlacementWidget* url_entry = NULL;
	MayaPlacementWidget* _tmp22_;
	MayaPlacementWidget* _tmp23_;
	GtkEntry* _tmp24_;
	MayaPlacementWidget* _tmp25_;
	GtkWidget* _tmp26_;
	MayaPlacementWidget* _tmp27_;
	MayaPlacementWidget* _tmp28_;
	MayaPlacementWidget* _tmp29_;
	gchar* _tmp30_;
	MayaPlacementWidget* _tmp31_;
	GeeLinkedList* _tmp32_;
	MayaPlacementWidget* _tmp33_;
	MayaPlacementWidget* secure_checkbutton = NULL;
	MayaPlacementWidget* _tmp60_;
	MayaPlacementWidget* _tmp61_;
	GtkCheckButton* _tmp62_;
	MayaPlacementWidget* _tmp63_;
	MayaPlacementWidget* _tmp64_;
	MayaPlacementWidget* _tmp65_;
	gchar* _tmp66_;
	GeeLinkedList* _tmp67_;
	MayaPlacementWidget* _tmp68_;
	gchar* user = NULL;
	gchar* _tmp76_;
	GeeLinkedList* _tmp86_;
	const gchar* _tmp87_;
	GeeLinkedList* _tmp88_;
	GeeLinkedList* _tmp89_;
	gchar* email = NULL;
	gchar* _tmp90_;
	GeeLinkedList* _tmp100_;
	const gchar* _tmp101_;
	GeeLinkedList* _tmp102_;
	GeeLinkedList* _tmp103_;
	MayaPlacementWidget* server_checkbutton = NULL;
	MayaPlacementWidget* _tmp104_;
	MayaPlacementWidget* _tmp105_;
	GtkCheckButton* _tmp106_;
	MayaPlacementWidget* _tmp107_;
	MayaPlacementWidget* _tmp108_;
	MayaPlacementWidget* _tmp109_;
	gchar* _tmp110_;
	GeeLinkedList* _tmp118_;
	MayaPlacementWidget* _tmp119_;
	GeeCollection* result;
	self = (MayaCalDavBackend*) base;
	_tmp0_ = gee_linked_list_new (MAYA_TYPE_PLACEMENT_WIDGET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	collection = _tmp0_;
	keep_copy = FALSE;
	if (to_edit != NULL) {
		ESourceOffline* source_offline = NULL;
		ESourceExtension* _tmp1_;
		ESourceOffline* _tmp2_;
		ESourceOffline* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_OFFLINE);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_offline_get_type (), ESourceOffline));
		source_offline = _tmp2_;
		_tmp3_ = source_offline;
		_tmp4_ = e_source_offline_get_stay_synchronized (_tmp3_);
		_tmp5_ = _tmp4_;
		keep_copy = _tmp5_;
		_g_object_unref0 (source_offline);
	}
	_tmp6_ = collection;
	_tmp7_ = maya_default_placement_widgets_get_keep_copy (0, keep_copy);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = maya_placement_widget_new ();
	url_label = _tmp9_;
	_tmp10_ = url_label;
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("URL:"));
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (_tmp10_->widget);
	_tmp10_->widget = (GtkWidget*) _tmp11_;
	_tmp12_ = url_label;
	_tmp13_ = _tmp12_->widget;
	g_object_set ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_label_get_type (), GtkLabel), "expand", TRUE, NULL);
	_tmp14_ = url_label;
	_tmp15_ = _tmp14_->widget;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_misc_get_type (), GtkMisc), "xalign", 1.0f, NULL);
	_tmp16_ = url_label;
	_tmp16_->row = 1;
	_tmp17_ = url_label;
	_tmp17_->column = 0;
	_tmp18_ = url_label;
	_tmp19_ = g_strdup ("url_label");
	_g_free0 (_tmp18_->ref_name);
	_tmp18_->ref_name = _tmp19_;
	_tmp20_ = collection;
	_tmp21_ = url_label;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
	_tmp22_ = maya_placement_widget_new ();
	url_entry = _tmp22_;
	_tmp23_ = url_entry;
	_tmp24_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (_tmp23_->widget);
	_tmp23_->widget = (GtkWidget*) _tmp24_;
	_tmp25_ = url_entry;
	_tmp26_ = _tmp25_->widget;
	gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_entry_get_type (), GtkEntry), "http://");
	_tmp27_ = url_entry;
	_tmp27_->row = 1;
	_tmp28_ = url_entry;
	_tmp28_->column = 1;
	_tmp29_ = url_entry;
	_tmp30_ = g_strdup ("url_entry");
	_g_free0 (_tmp29_->ref_name);
	_tmp29_->ref_name = _tmp30_;
	_tmp31_ = url_entry;
	_tmp31_->needed = TRUE;
	_tmp32_ = collection;
	_tmp33_ = url_entry;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
	if (to_edit != NULL) {
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp34_;
		ESourceWebdav* _tmp35_;
		GUri* uri = NULL;
		ESourceWebdav* _tmp36_;
		GUri* _tmp37_;
		GUri* _tmp38_;
		_tmp34_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp35_;
		_tmp36_ = webdav;
		_tmp37_ = e_source_webdav_dup_uri (_tmp36_);
		uri = _tmp37_;
		_tmp38_ = uri;
		if (g_uri_get_port (_tmp38_) != 80) {
			MayaPlacementWidget* _tmp39_;
			GtkWidget* _tmp40_;
			GUri* _tmp41_;
			const gchar* _tmp42_;
			GUri* _tmp43_;
			const gchar* _tmp44_;
			GUri* _tmp45_;
			GUri* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp39_ = url_entry;
			_tmp40_ = _tmp39_->widget;
			_tmp41_ = uri;
			_tmp42_ = g_uri_get_scheme (_tmp41_);
			_tmp43_ = uri;
			_tmp44_ = g_uri_get_host (_tmp43_);
			_tmp45_ = uri;
			_tmp46_ = uri;
			_tmp47_ = g_uri_get_path (_tmp46_);
			_tmp48_ = g_strdup_printf ("%s://%s:%u%s", _tmp42_, _tmp44_, (guint) g_uri_get_port (_tmp45_), _tmp47_);
			_tmp49_ = _tmp48_;
			gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_entry_get_type (), GtkEntry), _tmp49_);
			_g_free0 (_tmp49_);
		} else {
			MayaPlacementWidget* _tmp50_;
			GtkWidget* _tmp51_;
			GUri* _tmp52_;
			const gchar* _tmp53_;
			GUri* _tmp54_;
			const gchar* _tmp55_;
			GUri* _tmp56_;
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp50_ = url_entry;
			_tmp51_ = _tmp50_->widget;
			_tmp52_ = uri;
			_tmp53_ = g_uri_get_scheme (_tmp52_);
			_tmp54_ = uri;
			_tmp55_ = g_uri_get_host (_tmp54_);
			_tmp56_ = uri;
			_tmp57_ = g_uri_get_path (_tmp56_);
			_tmp58_ = g_strdup_printf ("%s://%s%s", _tmp53_, _tmp55_, _tmp57_);
			_tmp59_ = _tmp58_;
			gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_entry_get_type (), GtkEntry), _tmp59_);
			_g_free0 (_tmp59_);
		}
		_g_uri_unref0 (uri);
		_g_object_unref0 (webdav);
	}
	_tmp60_ = maya_placement_widget_new ();
	secure_checkbutton = _tmp60_;
	_tmp61_ = secure_checkbutton;
	_tmp62_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Use a secure connection"));
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (_tmp61_->widget);
	_tmp61_->widget = (GtkWidget*) _tmp62_;
	_tmp63_ = secure_checkbutton;
	_tmp63_->row = 3;
	_tmp64_ = secure_checkbutton;
	_tmp64_->column = 1;
	_tmp65_ = secure_checkbutton;
	_tmp66_ = g_strdup ("secure_checkbutton");
	_g_free0 (_tmp65_->ref_name);
	_tmp65_->ref_name = _tmp66_;
	_tmp67_ = collection;
	_tmp68_ = secure_checkbutton;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp68_);
	if (to_edit != NULL) {
		ESourceSecurity* security = NULL;
		ESourceExtension* _tmp69_;
		ESourceSecurity* _tmp70_;
		MayaPlacementWidget* _tmp71_;
		GtkWidget* _tmp72_;
		ESourceSecurity* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp69_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_SECURITY);
		_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, e_source_security_get_type (), ESourceSecurity));
		security = _tmp70_;
		_tmp71_ = secure_checkbutton;
		_tmp72_ = _tmp71_->widget;
		_tmp73_ = security;
		_tmp74_ = e_source_security_get_secure (_tmp73_);
		_tmp75_ = _tmp74_;
		gtk_toggle_button_set_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_check_button_get_type (), GtkCheckButton), _tmp75_);
		_g_object_unref0 (security);
	}
	_tmp76_ = g_strdup ("");
	user = _tmp76_;
	if (to_edit != NULL) {
		ESourceAuthentication* auth = NULL;
		ESourceExtension* _tmp77_;
		ESourceAuthentication* _tmp78_;
		ESourceAuthentication* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		_tmp77_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp78_;
		_tmp79_ = auth;
		_tmp80_ = e_source_authentication_get_user (_tmp79_);
		_tmp81_ = _tmp80_;
		if (_tmp81_ != NULL) {
			ESourceAuthentication* _tmp82_;
			const gchar* _tmp83_;
			const gchar* _tmp84_;
			gchar* _tmp85_;
			_tmp82_ = auth;
			_tmp83_ = e_source_authentication_get_user (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = g_strdup (_tmp84_);
			_g_free0 (user);
			user = _tmp85_;
		}
		_g_object_unref0 (auth);
	}
	_tmp86_ = collection;
	_tmp87_ = user;
	_tmp88_ = maya_default_placement_widgets_get_user (4, TRUE, _tmp87_, NULL);
	_tmp89_ = _tmp88_;
	gee_collection_add_all ((GeeCollection*) _tmp86_, (GeeCollection*) _tmp89_);
	_g_object_unref0 (_tmp89_);
	_tmp90_ = g_strdup ("");
	email = _tmp90_;
	if (to_edit != NULL) {
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp91_;
		ESourceWebdav* _tmp92_;
		ESourceWebdav* _tmp93_;
		const gchar* _tmp94_;
		const gchar* _tmp95_;
		_tmp91_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp92_;
		_tmp93_ = webdav;
		_tmp94_ = e_source_webdav_get_email_address (_tmp93_);
		_tmp95_ = _tmp94_;
		if (_tmp95_ != NULL) {
			ESourceWebdav* _tmp96_;
			const gchar* _tmp97_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			_tmp96_ = webdav;
			_tmp97_ = e_source_webdav_get_email_address (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strdup (_tmp98_);
			_g_free0 (email);
			email = _tmp99_;
		}
		_g_object_unref0 (webdav);
	}
	_tmp100_ = collection;
	_tmp101_ = email;
	_tmp102_ = maya_default_placement_widgets_get_email (5, FALSE, _tmp101_, NULL);
	_tmp103_ = _tmp102_;
	gee_collection_add_all ((GeeCollection*) _tmp100_, (GeeCollection*) _tmp103_);
	_g_object_unref0 (_tmp103_);
	_tmp104_ = maya_placement_widget_new ();
	server_checkbutton = _tmp104_;
	_tmp105_ = server_checkbutton;
	_tmp106_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Server handles meeting invitations"));
	g_object_ref_sink (_tmp106_);
	_g_object_unref0 (_tmp105_->widget);
	_tmp105_->widget = (GtkWidget*) _tmp106_;
	_tmp107_ = server_checkbutton;
	_tmp107_->row = 6;
	_tmp108_ = server_checkbutton;
	_tmp108_->column = 1;
	_tmp109_ = server_checkbutton;
	_tmp110_ = g_strdup ("server_checkbutton");
	_g_free0 (_tmp109_->ref_name);
	_tmp109_->ref_name = _tmp110_;
	if (to_edit != NULL) {
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp111_;
		ESourceWebdav* _tmp112_;
		MayaPlacementWidget* _tmp113_;
		GtkWidget* _tmp114_;
		ESourceWebdav* _tmp115_;
		gboolean _tmp116_;
		gboolean _tmp117_;
		_tmp111_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp112_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp112_;
		_tmp113_ = server_checkbutton;
		_tmp114_ = _tmp113_->widget;
		_tmp115_ = webdav;
		_tmp116_ = e_source_webdav_get_calendar_auto_schedule (_tmp115_);
		_tmp117_ = _tmp116_;
		gtk_toggle_button_set_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, gtk_check_button_get_type (), GtkCheckButton), _tmp117_);
		_g_object_unref0 (webdav);
	}
	_tmp118_ = collection;
	_tmp119_ = server_checkbutton;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp118_, _tmp119_);
	result = (GeeCollection*) collection;
	_g_object_unref0 (server_checkbutton);
	_g_free0 (email);
	_g_free0 (user);
	_g_object_unref0 (secure_checkbutton);
	_g_object_unref0 (url_entry);
	_g_object_unref0 (url_label);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
maya_cal_dav_backend_real_add_new_calendar (MayaBackend* base,
                                            const gchar* name,
                                            const gchar* color,
                                            gboolean set_default,
                                            GeeCollection* widgets)
{
	MayaCalDavBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaCalDavBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	{
		ESource* new_source = NULL;
		ESource* _tmp0_;
		ESource* _tmp1_;
		ESource* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ESourceCalendar* cal = NULL;
		ESource* _tmp5_;
		ESourceExtension* _tmp6_;
		ESourceCalendar* _tmp7_;
		ESourceCalendar* _tmp8_;
		ESourceCalendar* _tmp9_;
		ESourceWebdav* webdav = NULL;
		ESource* _tmp10_;
		ESourceExtension* _tmp11_;
		ESourceWebdav* _tmp12_;
		ESourceAuthentication* auth = NULL;
		ESource* _tmp13_;
		ESourceExtension* _tmp14_;
		ESourceAuthentication* _tmp15_;
		ESourceOffline* offline = NULL;
		ESource* _tmp16_;
		ESourceExtension* _tmp17_;
		ESourceOffline* _tmp18_;
		CalendarEventStore* calmodel = NULL;
		CalendarEventStore* _tmp55_;
		ESourceRegistry* registry = NULL;
		CalendarEventStore* _tmp56_;
		ESourceRegistry* _tmp57_;
		ESourceRegistry* _tmp58_;
		ESourceRegistry* _tmp59_;
		GList* list = NULL;
		ESource* _tmp60_;
		ESource* _tmp61_;
		ESourceRegistry* _tmp62_;
		GList* _tmp63_;
		CalendarEventStore* _tmp64_;
		ESource* _tmp65_;
		_tmp0_ = e_source_new (NULL, NULL, &_inner_error0_);
		new_source = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = new_source;
		e_source_set_display_name (_tmp1_, name);
		_tmp2_ = new_source;
		_tmp3_ = maya_backend_get_uid ((MayaBackend*) self);
		_tmp4_ = _tmp3_;
		e_source_set_parent (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = new_source;
		_tmp6_ = e_source_get_extension (_tmp5_, E_SOURCE_EXTENSION_CALENDAR);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp7_;
		_tmp8_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp8_, color);
		_tmp9_ = cal;
		e_source_backend_set_backend_name ((ESourceBackend*) _tmp9_, "caldav");
		_tmp10_ = new_source;
		_tmp11_ = e_source_get_extension (_tmp10_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp12_;
		_tmp13_ = new_source;
		_tmp14_ = e_source_get_extension (_tmp13_, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp15_;
		_tmp16_ = new_source;
		_tmp17_ = e_source_get_extension (_tmp16_, E_SOURCE_EXTENSION_OFFLINE);
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp18_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp19_;
			_tmp19_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp19_;
			while (TRUE) {
				GeeIterator* _tmp20_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				MayaPlacementWidget* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				GQuark _tmp27_ = 0U;
				static GQuark _tmp26_label0 = 0;
				static GQuark _tmp26_label1 = 0;
				static GQuark _tmp26_label2 = 0;
				static GQuark _tmp26_label3 = 0;
				static GQuark _tmp26_label4 = 0;
				_tmp20_ = _widget_it;
				if (!gee_iterator_next (_tmp20_)) {
					break;
				}
				_tmp21_ = _widget_it;
				_tmp22_ = gee_iterator_get (_tmp21_);
				widget = (MayaPlacementWidget*) _tmp22_;
				_tmp23_ = widget;
				_tmp24_ = _tmp23_->ref_name;
				_tmp25_ = _tmp24_;
				_tmp27_ = (NULL == _tmp25_) ? 0 : g_quark_from_string (_tmp25_);
				if (_tmp27_ == ((0 != _tmp26_label0) ? _tmp26_label0 : (_tmp26_label0 = g_quark_from_static_string ("url_entry")))) {
					switch (0) {
						default:
						{
							GUri* _tmp28_ = NULL;
							MayaPlacementWidget* _tmp29_;
							GtkWidget* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							GUri* _tmp33_;
							ESourceWebdav* _tmp34_;
							_tmp29_ = widget;
							_tmp30_ = _tmp29_->widget;
							_tmp31_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_entry_get_type (), GtkEntry));
							_tmp32_ = _tmp31_;
							_tmp33_ = g_uri_parse (_tmp32_, G_URI_FLAGS_NONE, &_inner_error0_);
							_tmp28_ = _tmp33_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (widget);
								_g_object_unref0 (_widget_it);
								_g_object_unref0 (offline);
								_g_object_unref0 (auth);
								_g_object_unref0 (webdav);
								_g_object_unref0 (cal);
								_g_object_unref0 (new_source);
								goto __catch0_g_error;
							}
							_tmp34_ = webdav;
							g_object_set (_tmp34_, "uri", _tmp28_, NULL);
							_g_uri_unref0 (_tmp28_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label1) ? _tmp26_label1 : (_tmp26_label1 = g_quark_from_static_string ("user_entry")))) {
					switch (0) {
						default:
						{
							ESourceAuthentication* _tmp35_;
							MayaPlacementWidget* _tmp36_;
							GtkWidget* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							_tmp35_ = auth;
							_tmp36_ = widget;
							_tmp37_ = _tmp36_->widget;
							_tmp38_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_entry_get_type (), GtkEntry));
							_tmp39_ = _tmp38_;
							e_source_authentication_set_user (_tmp35_, _tmp39_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label2) ? _tmp26_label2 : (_tmp26_label2 = g_quark_from_static_string ("email_entry")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp40_;
							MayaPlacementWidget* _tmp41_;
							GtkWidget* _tmp42_;
							const gchar* _tmp43_;
							const gchar* _tmp44_;
							_tmp40_ = webdav;
							_tmp41_ = widget;
							_tmp42_ = _tmp41_->widget;
							_tmp43_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_entry_get_type (), GtkEntry));
							_tmp44_ = _tmp43_;
							e_source_webdav_set_email_address (_tmp40_, _tmp44_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label3) ? _tmp26_label3 : (_tmp26_label3 = g_quark_from_static_string ("server_checkbutton")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp45_;
							MayaPlacementWidget* _tmp46_;
							GtkWidget* _tmp47_;
							gboolean _tmp48_;
							gboolean _tmp49_;
							_tmp45_ = webdav;
							_tmp46_ = widget;
							_tmp47_ = _tmp46_->widget;
							_tmp48_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp49_ = _tmp48_;
							e_source_webdav_set_calendar_auto_schedule (_tmp45_, _tmp49_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label4) ? _tmp26_label4 : (_tmp26_label4 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp50_;
							MayaPlacementWidget* _tmp51_;
							GtkWidget* _tmp52_;
							gboolean _tmp53_;
							gboolean _tmp54_;
							_tmp50_ = offline;
							_tmp51_ = widget;
							_tmp52_ = _tmp51_->widget;
							_tmp53_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp54_ = _tmp53_;
							e_source_offline_set_stay_synchronized (_tmp50_, _tmp54_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		_tmp55_ = calendar_event_store_get_default ();
		calmodel = _tmp55_;
		_tmp56_ = calmodel;
		_tmp57_ = calendar_event_store_get_registry (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = _g_object_ref0 (_tmp58_);
		registry = _tmp59_;
		list = NULL;
		_tmp60_ = new_source;
		_tmp61_ = _g_object_ref0 (_tmp60_);
		list = g_list_append (list, _tmp61_);
		_tmp62_ = registry;
		_tmp63_ = list;
		e_source_registry_create_sources_sync (_tmp62_, _tmp63_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (calmodel);
			_g_object_unref0 (offline);
			_g_object_unref0 (auth);
			_g_object_unref0 (webdav);
			_g_object_unref0 (cal);
			_g_object_unref0 (new_source);
			goto __catch0_g_error;
		}
		_tmp64_ = calmodel;
		_tmp65_ = new_source;
		calendar_event_store_add_source (_tmp64_, _tmp65_);
		if (set_default) {
			ESourceRegistry* _tmp66_;
			ESource* _tmp67_;
			_tmp66_ = registry;
			_tmp67_ = new_source;
			g_object_set (_tmp66_, "default-calendar", _tmp67_, NULL);
		}
		(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
		_g_object_unref0 (registry);
		_g_object_unref0 (calmodel);
		_g_object_unref0 (offline);
		_g_object_unref0 (auth);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
		_g_object_unref0 (new_source);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp68_;
		const gchar* _tmp69_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp68_ = _error_;
		_tmp69_ = _tmp68_->message;
		g_critical ("CalDAVBackend.vala:186: %s", _tmp69_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_cal_dav_backend_real_modify_calendar (MayaBackend* base,
                                           const gchar* name,
                                           const gchar* color,
                                           gboolean set_default,
                                           GeeCollection* widgets,
                                           ESource* source)
{
	MayaCalDavBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaCalDavBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	g_return_if_fail (source != NULL);
	{
		ESourceCalendar* cal = NULL;
		ESourceExtension* _tmp0_;
		ESourceCalendar* _tmp1_;
		ESourceCalendar* _tmp2_;
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp3_;
		ESourceWebdav* _tmp4_;
		ESourceAuthentication* auth = NULL;
		ESourceExtension* _tmp5_;
		ESourceAuthentication* _tmp6_;
		ESourceOffline* offline = NULL;
		ESourceExtension* _tmp7_;
		ESourceOffline* _tmp8_;
		e_source_set_display_name (source, name);
		_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp1_;
		_tmp2_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp2_, color);
		_tmp3_ = e_source_get_extension (source, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp4_;
		_tmp5_ = e_source_get_extension (source, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp6_;
		_tmp7_ = e_source_get_extension (source, E_SOURCE_EXTENSION_OFFLINE);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp8_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp9_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				MayaPlacementWidget* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				GQuark _tmp17_ = 0U;
				static GQuark _tmp16_label0 = 0;
				static GQuark _tmp16_label1 = 0;
				static GQuark _tmp16_label2 = 0;
				static GQuark _tmp16_label3 = 0;
				static GQuark _tmp16_label4 = 0;
				_tmp10_ = _widget_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _widget_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				widget = (MayaPlacementWidget*) _tmp12_;
				_tmp13_ = widget;
				_tmp14_ = _tmp13_->ref_name;
				_tmp15_ = _tmp14_;
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("url_entry")))) {
					switch (0) {
						default:
						{
							GUri* _tmp18_ = NULL;
							MayaPlacementWidget* _tmp19_;
							GtkWidget* _tmp20_;
							const gchar* _tmp21_;
							const gchar* _tmp22_;
							GUri* _tmp23_;
							ESourceWebdav* _tmp24_;
							_tmp19_ = widget;
							_tmp20_ = _tmp19_->widget;
							_tmp21_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_entry_get_type (), GtkEntry));
							_tmp22_ = _tmp21_;
							_tmp23_ = g_uri_parse (_tmp22_, G_URI_FLAGS_NONE, &_inner_error0_);
							_tmp18_ = _tmp23_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (widget);
								_g_object_unref0 (_widget_it);
								_g_object_unref0 (offline);
								_g_object_unref0 (auth);
								_g_object_unref0 (webdav);
								_g_object_unref0 (cal);
								goto __catch0_g_error;
							}
							_tmp24_ = webdav;
							g_object_set (_tmp24_, "uri", _tmp18_, NULL);
							_g_uri_unref0 (_tmp18_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("user_entry")))) {
					switch (0) {
						default:
						{
							ESourceAuthentication* _tmp25_;
							MayaPlacementWidget* _tmp26_;
							GtkWidget* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							_tmp25_ = auth;
							_tmp26_ = widget;
							_tmp27_ = _tmp26_->widget;
							_tmp28_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_entry_get_type (), GtkEntry));
							_tmp29_ = _tmp28_;
							e_source_authentication_set_user (_tmp25_, _tmp29_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label2) ? _tmp16_label2 : (_tmp16_label2 = g_quark_from_static_string ("email_entry")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp30_;
							MayaPlacementWidget* _tmp31_;
							GtkWidget* _tmp32_;
							const gchar* _tmp33_;
							const gchar* _tmp34_;
							_tmp30_ = webdav;
							_tmp31_ = widget;
							_tmp32_ = _tmp31_->widget;
							_tmp33_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_entry_get_type (), GtkEntry));
							_tmp34_ = _tmp33_;
							e_source_webdav_set_email_address (_tmp30_, _tmp34_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label3) ? _tmp16_label3 : (_tmp16_label3 = g_quark_from_static_string ("server_checkbutton")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp35_;
							MayaPlacementWidget* _tmp36_;
							GtkWidget* _tmp37_;
							gboolean _tmp38_;
							gboolean _tmp39_;
							_tmp35_ = webdav;
							_tmp36_ = widget;
							_tmp37_ = _tmp36_->widget;
							_tmp38_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp39_ = _tmp38_;
							e_source_webdav_set_calendar_auto_schedule (_tmp35_, _tmp39_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label4) ? _tmp16_label4 : (_tmp16_label4 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp40_;
							MayaPlacementWidget* _tmp41_;
							GtkWidget* _tmp42_;
							gboolean _tmp43_;
							gboolean _tmp44_;
							_tmp40_ = offline;
							_tmp41_ = widget;
							_tmp42_ = _tmp41_->widget;
							_tmp43_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp44_ = _tmp43_;
							e_source_offline_set_stay_synchronized (_tmp40_, _tmp44_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		e_source_write (source, NULL, NULL, NULL);
		if (set_default) {
			ESourceRegistry* registry = NULL;
			ESourceRegistry* _tmp45_;
			ESourceRegistry* _tmp46_;
			_tmp45_ = e_source_registry_new_sync (NULL, &_inner_error0_);
			registry = _tmp45_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (offline);
				_g_object_unref0 (auth);
				_g_object_unref0 (webdav);
				_g_object_unref0 (cal);
				goto __catch0_g_error;
			}
			_tmp46_ = registry;
			g_object_set (_tmp46_, "default-calendar", source, NULL);
			_g_object_unref0 (registry);
		}
		_g_object_unref0 (offline);
		_g_object_unref0 (auth);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = _error_;
		_tmp48_ = _tmp47_->message;
		g_critical ("CalDAVBackend.vala:229: %s", _tmp48_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_cal_dav_backend_class_init (MayaCalDavBackendClass * klass,
                                 gpointer klass_data)
{
	maya_cal_dav_backend_parent_class = g_type_class_peek_parent (klass);
}

static void
maya_cal_dav_backend_maya_backend_interface_init (MayaBackendIface * iface,
                                                  gpointer iface_data)
{
	maya_cal_dav_backend_maya_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (MayaBackend*)) maya_cal_dav_backend_real_get_name;
	iface->get_uid = (gchar* (*) (MayaBackend*)) maya_cal_dav_backend_real_get_uid;
	iface->get_new_calendar_widget = (GeeCollection* (*) (MayaBackend*, ESource*)) maya_cal_dav_backend_real_get_new_calendar_widget;
	iface->add_new_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*)) maya_cal_dav_backend_real_add_new_calendar;
	iface->modify_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*, ESource*)) maya_cal_dav_backend_real_modify_calendar;
}

static void
maya_cal_dav_backend_instance_init (MayaCalDavBackend * self,
                                    gpointer klass)
{
}

static GType
maya_cal_dav_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaCalDavBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_cal_dav_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaCalDavBackend), 0, (GInstanceInitFunc) maya_cal_dav_backend_instance_init, NULL };
	static const GInterfaceInfo maya_backend_info = { (GInterfaceInitFunc) maya_cal_dav_backend_maya_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType maya_cal_dav_backend_type_id;
	maya_cal_dav_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaCalDavBackend", &g_define_type_info, 0);
	g_type_add_interface_static (maya_cal_dav_backend_type_id, MAYA_TYPE_BACKEND, &maya_backend_info);
	return maya_cal_dav_backend_type_id;
}

GType
maya_cal_dav_backend_get_type (void)
{
	static volatile gsize maya_cal_dav_backend_type_id__once = 0;
	if (g_once_init_enter (&maya_cal_dav_backend_type_id__once)) {
		GType maya_cal_dav_backend_type_id;
		maya_cal_dav_backend_type_id = maya_cal_dav_backend_get_type_once ();
		g_once_init_leave (&maya_cal_dav_backend_type_id__once, maya_cal_dav_backend_type_id);
	}
	return maya_cal_dav_backend_type_id__once;
}

