/* file-bookmarks-plugin.c generated by valac 0.56.18, the Vala compiler
 * generated from file-bookmarks-plugin.vala, do not modify */

/*
* Copyright (c) 2017 David Hewitt <davidmhewitt@gmail.com>
*               2015-2020 elementary LLC. <https://elementary.io>
*               2021 Justin Haygood <jhaygood86@gmail.com>
*               1999, 2000 Eazel, Inc.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include "slingshot.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_FILE_BOOKMARK_PLUGIN_0_PROPERTY,
	SYNAPSE_FILE_BOOKMARK_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_FILE_BOOKMARK_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_file_bookmark_plugin_properties[SYNAPSE_FILE_BOOKMARK_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseFileBookmarkPluginSearchData SynapseFileBookmarkPluginSearchData;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _SynapseFileBookmarkPluginCheckForMatchData SynapseFileBookmarkPluginCheckForMatchData;
enum  {
	SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_file_bookmark_plugin_result_properties[SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_NUM_PROPERTIES];

struct _SynapseFileBookmarkPluginPrivate {
	gboolean _enabled;
};

struct _SynapseFileBookmarkPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseFileBookmarkPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	GeeList* matchers;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp3_;
	SynapseResultSet* _tmp4_;
	GeeList* _tmp5_;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_;
	SynapseResultSet* _tmp10_;
	GeeList* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	SynapseResultSet* _tmp15_;
	GeeList* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gboolean _tmp19_;
	gchar* filename;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GFile* file;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	guint8* contents_bytes;
	gint contents_bytes_length1;
	gint _contents_bytes_size_;
	GFile* _tmp25_;
	guint8* _tmp26_;
	gsize _tmp27_;
	GError* err;
	GError* _tmp28_;
	const gchar* _tmp29_;
	guint8* _tmp30_;
	gint _tmp30__length1;
	gchar* contents;
	guint8* _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** lines;
	const gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar** line_collection;
	gint line_collection_length1;
	gint _line_collection_size_;
	gint line_it;
	gchar* _tmp37_;
	gchar* line;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar** parts;
	const gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint parts_length1;
	gint _parts_size_;
	gchar* uri;
	gchar** _tmp44_;
	gint _tmp44__length1;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar** _tmp49_;
	gint _tmp49__length1;
	const gchar* _tmp50_;
	gchar* custom_name;
	gchar* _tmp51_;
	gboolean _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gboolean _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GFile* location;
	const gchar* _tmp64_;
	GFile* _tmp65_;
	gboolean matched;
	SynapseResultSet* _tmp66_;
	GeeList* _tmp67_;
	GFile* _tmp68_;
	const gchar* _tmp69_;
	GError* _inner_error0_;
};

struct _SynapseFileBookmarkPluginCheckForMatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseFileBookmarkPlugin* self;
	SynapseResultSet* results;
	GeeList* matchers;
	GFile* location;
	gchar* custom_name;
	gboolean result;
	GMatchInfo* info;
	gboolean is_hidden;
	GFileInfo* location_info;
	GFileInfo* _tmp0_;
	gboolean _tmp1_;
	GError* err;
	GError* _tmp2_;
	const gchar* _tmp3_;
	gchar* uri;
	gchar* _tmp4_;
	gchar* basename;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* custom_name_for_match;
	gchar* _tmp9_;
	gboolean matched;
	GeeList* _matcher_list;
	gint _matcher_size;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _matcher_index;
	gint _tmp13_;
	gint _tmp14_;
	GeeMapEntry* matcher;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	GeeMapEntry* _tmp17_;
	gconstpointer _tmp18_;
	gconstpointer _tmp19_;
	const gchar* _tmp20_;
	GMatchInfo* _tmp21_;
	gboolean _tmp22_;
	SynapseFileBookmarkPluginResult* _tmp23_;
	SynapseFileBookmarkPluginResult* _tmp24_;
	const gchar* _tmp25_;
	GeeMapEntry* _tmp26_;
	gconstpointer _tmp27_;
	gconstpointer _tmp28_;
	GeeMapEntry* _tmp29_;
	gconstpointer _tmp30_;
	gconstpointer _tmp31_;
	const gchar* _tmp32_;
	GMatchInfo* _tmp33_;
	gboolean _tmp34_;
	SynapseFileBookmarkPluginResult* _tmp35_;
	SynapseFileBookmarkPluginResult* _tmp36_;
	const gchar* _tmp37_;
	GeeMapEntry* _tmp38_;
	gconstpointer _tmp39_;
	gconstpointer _tmp40_;
	GError* _inner_error0_;
};

struct _SynapseFileBookmarkPluginResultPrivate {
	gint _default_relevancy;
	GFile* location;
};

static gint SynapseFileBookmarkPlugin_private_offset;
static gpointer synapse_file_bookmark_plugin_parent_class = NULL;
static gint SynapseFileBookmarkPluginResult_private_offset;
static gpointer synapse_file_bookmark_plugin_result_parent_class = NULL;
static SynapseActivatableIface * synapse_file_bookmark_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_file_bookmark_plugin_synapse_item_provider_parent_iface = NULL;

static void synapse_file_bookmark_plugin_real_activate (SynapseActivatable* base);
static void synapse_file_bookmark_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_file_bookmark_plugin_register_plugin (void);
static void _synapse_file_bookmark_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_file_bookmark_plugin_real_search_data_free (gpointer _data);
static void synapse_file_bookmark_plugin_real_search (SynapseItemProvider* base,
                                               SynapseQuery* q,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean synapse_file_bookmark_plugin_real_search_co (SynapseFileBookmarkPluginSearchData* _data_);
static void synapse_file_bookmark_plugin_check_for_match (SynapseFileBookmarkPlugin* self,
                                                   SynapseResultSet* results,
                                                   GeeList* matchers,
                                                   GFile* location,
                                                   const gchar* custom_name,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean synapse_file_bookmark_plugin_check_for_match_finish (SynapseFileBookmarkPlugin* self,
                                                              GAsyncResult* _res_);
static void synapse_file_bookmark_plugin_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void synapse_file_bookmark_plugin_check_for_match_data_free (gpointer _data);
static gboolean synapse_file_bookmark_plugin_check_for_match_co (SynapseFileBookmarkPluginCheckForMatchData* _data_);
static void synapse_file_bookmark_plugin_check_for_match_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static gint synapse_file_bookmark_plugin_compute_relevancy (SynapseFileBookmarkPlugin* self,
                                                     const gchar* uri,
                                                     gint base_relevancy);
static gchar* synapse_file_bookmark_plugin_result_get_icon_user_special_dirs (SynapseFileBookmarkPluginResult* self,
                                                                       const gchar* path);
static void synapse_file_bookmark_plugin_result_real_execute (SynapseMatch* base,
                                                       SynapseMatch* match);
static guint synapse_file_bookmark_plugin_result_get_number_of_uri_parts (SynapseFileBookmarkPluginResult* self);
static void synapse_file_bookmark_plugin_result_finalize (GObject * obj);
static GType synapse_file_bookmark_plugin_result_get_type_once (void);
static void _vala_synapse_file_bookmark_plugin_result_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_synapse_file_bookmark_plugin_result_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static void synapse_file_bookmark_plugin_finalize (GObject * obj);
static GType synapse_file_bookmark_plugin_get_type_once (void);
static void _vala_synapse_file_bookmark_plugin_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_synapse_file_bookmark_plugin_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_file_bookmark_plugin_get_instance_private (SynapseFileBookmarkPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseFileBookmarkPlugin_private_offset);
}

static void
synapse_file_bookmark_plugin_real_activate (SynapseActivatable* base)
{
	SynapseFileBookmarkPlugin * self;
	self = (SynapseFileBookmarkPlugin*) base;
}

static void
synapse_file_bookmark_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseFileBookmarkPlugin * self;
	self = (SynapseFileBookmarkPlugin*) base;
}

static void
_synapse_file_bookmark_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_file_bookmark_plugin_register_plugin ();
}

static void
synapse_file_bookmark_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_FILE_BOOKMARK_PLUGIN, "help-about", _synapse_file_bookmark_plugin_register_plugin_synapse_plugin_register_func, TRUE);
	_g_object_unref0 (_tmp1_);
}

static void
synapse_file_bookmark_plugin_real_search_data_free (gpointer _data)
{
	SynapseFileBookmarkPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->q);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseFileBookmarkPluginSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_file_bookmark_plugin_real_search (SynapseItemProvider* base,
                                          SynapseQuery* q,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SynapseFileBookmarkPlugin * self;
	SynapseFileBookmarkPluginSearchData* _data_;
	SynapseFileBookmarkPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	g_return_if_fail (q != NULL);
	self = (SynapseFileBookmarkPlugin*) base;
	_data_ = g_slice_new0 (SynapseFileBookmarkPluginSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_file_bookmark_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *q;
	_tmp2_ = _tmp1_;
	synapse_query_copy (&_tmp2_, &_tmp3_);
	synapse_query_destroy (&_data_->q);
	_data_->q = _tmp3_;
	synapse_file_bookmark_plugin_real_search_co (_data_);
}

static SynapseResultSet*
synapse_file_bookmark_plugin_search_finish (SynapseItemProvider* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	SynapseResultSet* result;
	SynapseFileBookmarkPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
synapse_file_bookmark_plugin_search_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	SynapseFileBookmarkPluginSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_file_bookmark_plugin_real_search_co (_data_);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
synapse_file_bookmark_plugin_real_search_co (SynapseFileBookmarkPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->q;
	_data_->_tmp1_ = _data_->_tmp0_.query_string_folded;
	_data_->_tmp2_ = synapse_query_get_matchers_for_query (_data_->_tmp1_, 0, G_REGEX_OPTIMIZE);
	_data_->matchers = _data_->_tmp2_;
	_data_->_tmp3_ = synapse_result_set_new ();
	_data_->results = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->results;
	_data_->_tmp5_ = _data_->matchers;
	_data_->_tmp6_ = g_get_home_dir ();
	_data_->_tmp7_ = g_file_new_for_path (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_state_ = 1;
	synapse_file_bookmark_plugin_check_for_match (_data_->self, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp8_, _ ("Home"), synapse_file_bookmark_plugin_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = synapse_file_bookmark_plugin_check_for_match_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->_tmp8_);
	if (_data_->_tmp9_) {
		_data_->result = _data_->results;
		_g_object_unref0 (_data_->matchers);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->results;
	_data_->_tmp11_ = _data_->matchers;
	_data_->_tmp12_ = g_file_new_for_uri ("recent://");
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_state_ = 2;
	synapse_file_bookmark_plugin_check_for_match (_data_->self, _data_->_tmp10_, _data_->_tmp11_, _data_->_tmp13_, _ ("Recent"), synapse_file_bookmark_plugin_search_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp14_ = synapse_file_bookmark_plugin_check_for_match_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->_tmp13_);
	if (_data_->_tmp14_) {
		_data_->result = _data_->results;
		_g_object_unref0 (_data_->matchers);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->results;
	_data_->_tmp16_ = _data_->matchers;
	_data_->_tmp17_ = g_file_new_for_uri ("trash://");
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_state_ = 3;
	synapse_file_bookmark_plugin_check_for_match (_data_->self, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp18_, _ ("Trash"), synapse_file_bookmark_plugin_search_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp19_ = synapse_file_bookmark_plugin_check_for_match_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->_tmp18_);
	if (_data_->_tmp19_) {
		_data_->result = _data_->results;
		_g_object_unref0 (_data_->matchers);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = g_get_home_dir ();
	_data_->_tmp21_ = g_build_filename (_data_->_tmp20_, ".config", "gtk-3.0", "bookmarks", NULL, NULL);
	_data_->filename = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->filename;
	_data_->_tmp23_ = g_file_new_for_path (_data_->_tmp22_);
	_data_->file = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->file;
	_data_->_state_ = 4;
	synapse_utils_query_exists_async (_data_->_tmp24_, synapse_file_bookmark_plugin_search_ready, _data_);
	return FALSE;
	_state_4:
	if (synapse_utils_query_exists_finish (_data_->_res_)) {
		_data_->contents_bytes_length1 = 0;
		_data_->_contents_bytes_size_ = 0;
		synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->matchers);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->matchers);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		{
			_data_->_tmp25_ = _data_->file;
			_data_->_tmp26_ = NULL;
			_data_->_tmp27_ = 0;
			_data_->_state_ = 5;
			g_file_load_contents_async (_data_->_tmp25_, NULL, synapse_file_bookmark_plugin_search_ready, _data_);
			return FALSE;
			_state_5:
			g_file_load_contents_finish (_data_->_tmp25_, _data_->_res_, &_data_->_tmp26_, &_data_->_tmp27_, NULL, &_data_->_inner_error0_);
			_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
			_data_->contents_bytes = _data_->_tmp26_;
			_data_->contents_bytes_length1 = _data_->_tmp27_;
			_data_->_contents_bytes_size_ = _data_->contents_bytes_length1;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp28_ = _data_->err;
			_data_->_tmp29_ = _data_->_tmp28_->message;
			g_warning ("file-bookmarks-plugin.vala:244: %s", _data_->_tmp29_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->matchers);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->matchers);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->matchers);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->matchers);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp30_ = _data_->contents_bytes;
		_data_->_tmp30__length1 = _data_->contents_bytes_length1;
		if (_data_->_tmp30_ != NULL) {
			_data_->_tmp31_ = _data_->contents_bytes;
			_data_->_tmp31__length1 = _data_->contents_bytes_length1;
			_data_->_tmp32_ = g_strdup ((const gchar*) _data_->_tmp31_);
			_data_->contents = _data_->_tmp32_;
			_data_->_tmp33_ = _data_->contents;
			_data_->_tmp35_ = _data_->_tmp34_ = g_strsplit (_data_->_tmp33_, "\n", 0);
			_data_->lines = _data_->_tmp35_;
			_data_->lines_length1 = _vala_array_length (_data_->_tmp34_);
			_data_->_lines_size_ = _data_->lines_length1;
			_data_->_tmp36_ = _data_->lines;
			_data_->_tmp36__length1 = _data_->lines_length1;
			{
				_data_->line_collection_length1 = 0;
				_data_->_line_collection_size_ = 0;
				_data_->line_collection = _data_->_tmp36_;
				_data_->line_collection_length1 = _data_->_tmp36__length1;
				for (_data_->line_it = 0; _data_->line_it < _data_->line_collection_length1; _data_->line_it = _data_->line_it + 1) {
					_data_->_tmp37_ = g_strdup (_data_->line_collection[_data_->line_it]);
					_data_->line = _data_->_tmp37_;
					{
						synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
								g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
								_g_free0 (_data_->line);
								_data_->lines = (_vala_array_free (_data_->lines, _data_->lines_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (_data_->contents);
								_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
								_g_object_unref0 (_data_->file);
								_g_free0 (_data_->filename);
								_g_object_unref0 (_data_->results);
								_g_object_unref0 (_data_->matchers);
								g_object_unref (_data_->_async_result);
								return FALSE;
							} else {
								_g_free0 (_data_->line);
								_data_->lines = (_vala_array_free (_data_->lines, _data_->lines_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (_data_->contents);
								_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
								_g_object_unref0 (_data_->file);
								_g_free0 (_data_->filename);
								_g_object_unref0 (_data_->results);
								_g_object_unref0 (_data_->matchers);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
								g_clear_error (&_data_->_inner_error0_);
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
						}
						_data_->_tmp39_ = _data_->line;
						if (string_get (_data_->_tmp39_, (glong) 0) == '\0') {
							_data_->_tmp38_ = TRUE;
						} else {
							_data_->_tmp40_ = _data_->line;
							_data_->_tmp38_ = string_get (_data_->_tmp40_, (glong) 0) == ' ';
						}
						if (_data_->_tmp38_) {
							_g_free0 (_data_->line);
							continue;
						}
						_data_->_tmp41_ = _data_->line;
						_data_->_tmp43_ = _data_->_tmp42_ = g_strsplit (_data_->_tmp41_, " ", 2);
						_data_->parts = _data_->_tmp43_;
						_data_->parts_length1 = _vala_array_length (_data_->_tmp42_);
						_data_->_parts_size_ = _data_->parts_length1;
						_data_->_tmp44_ = _data_->parts;
						_data_->_tmp44__length1 = _data_->parts_length1;
						_data_->_tmp45_ = _data_->_tmp44_[0];
						_data_->_tmp46_ = g_strdup (_data_->_tmp45_);
						_data_->uri = _data_->_tmp46_;
						_data_->_tmp48_ = _data_->parts;
						_data_->_tmp48__length1 = _data_->parts_length1;
						if (_data_->_tmp48__length1 == 2) {
							_data_->_tmp49_ = _data_->parts;
							_data_->_tmp49__length1 = _data_->parts_length1;
							_data_->_tmp50_ = _data_->_tmp49_[1];
							_data_->_tmp47_ = _data_->_tmp50_;
						} else {
							_data_->_tmp47_ = "";
						}
						_data_->_tmp51_ = g_strdup (_data_->_tmp47_);
						_data_->custom_name = _data_->_tmp51_;
						_data_->_tmp53_ = _data_->custom_name;
						if (g_strcmp0 (_data_->_tmp53_, "") != 0) {
							_data_->_tmp55_ = _data_->custom_name;
							_data_->_tmp56_ = string_strip (_data_->_tmp55_);
							_data_->_tmp57_ = _data_->_tmp56_;
							_data_->_tmp58_ = g_strcmp0 (_data_->_tmp57_, "") == 0;
							_g_free0 (_data_->_tmp57_);
							if (_data_->_tmp58_) {
								_data_->_tmp54_ = TRUE;
							} else {
								_data_->_tmp59_ = _data_->custom_name;
								_data_->_tmp60_ = _data_->uri;
								_data_->_tmp61_ = g_path_get_basename (_data_->_tmp60_);
								_data_->_tmp62_ = _data_->_tmp61_;
								_data_->_tmp54_ = g_strcmp0 (_data_->_tmp59_, _data_->_tmp62_) == 0;
								_g_free0 (_data_->_tmp62_);
							}
							_data_->_tmp52_ = _data_->_tmp54_;
						} else {
							_data_->_tmp52_ = FALSE;
						}
						if (_data_->_tmp52_) {
							_data_->_tmp63_ = g_strdup ("");
							_g_free0 (_data_->custom_name);
							_data_->custom_name = _data_->_tmp63_;
						}
						_data_->_tmp64_ = _data_->uri;
						_data_->_tmp65_ = g_file_new_for_uri (_data_->_tmp64_);
						_data_->location = _data_->_tmp65_;
						_data_->_tmp66_ = _data_->results;
						_data_->_tmp67_ = _data_->matchers;
						_data_->_tmp68_ = _data_->location;
						_data_->_tmp69_ = _data_->custom_name;
						_data_->_state_ = 6;
						synapse_file_bookmark_plugin_check_for_match (_data_->self, _data_->_tmp66_, _data_->_tmp67_, _data_->_tmp68_, _data_->_tmp69_, synapse_file_bookmark_plugin_search_ready, _data_);
						return FALSE;
						_state_6:
						_data_->matched = synapse_file_bookmark_plugin_check_for_match_finish (_data_->self, _data_->_res_);
						if (_data_->matched) {
							_g_object_unref0 (_data_->location);
							_g_free0 (_data_->custom_name);
							_g_free0 (_data_->uri);
							_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (_data_->line);
							break;
						}
						_g_object_unref0 (_data_->location);
						_g_free0 (_data_->custom_name);
						_g_free0 (_data_->uri);
						_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_data_->line);
					}
				}
			}
			_data_->lines = (_vala_array_free (_data_->lines, _data_->lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->contents);
		}
		_data_->contents_bytes = (g_free (_data_->contents_bytes), NULL);
	}
	_data_->result = _data_->results;
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->matchers);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
synapse_file_bookmark_plugin_check_for_match_data_free (gpointer _data)
{
	SynapseFileBookmarkPluginCheckForMatchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->results);
	_g_object_unref0 (_data_->matchers);
	_g_object_unref0 (_data_->location);
	_g_free0 (_data_->custom_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseFileBookmarkPluginCheckForMatchData, _data_);
}

static void
synapse_file_bookmark_plugin_check_for_match (SynapseFileBookmarkPlugin* self,
                                              SynapseResultSet* results,
                                              GeeList* matchers,
                                              GFile* location,
                                              const gchar* custom_name,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SynapseFileBookmarkPluginCheckForMatchData* _data_;
	SynapseFileBookmarkPlugin* _tmp0_;
	SynapseResultSet* _tmp1_;
	GeeList* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (matchers != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (custom_name != NULL);
	_data_ = g_slice_new0 (SynapseFileBookmarkPluginCheckForMatchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_file_bookmark_plugin_check_for_match_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (results);
	_g_object_unref0 (_data_->results);
	_data_->results = _tmp1_;
	_tmp2_ = _g_object_ref0 (matchers);
	_g_object_unref0 (_data_->matchers);
	_data_->matchers = _tmp2_;
	_tmp3_ = _g_object_ref0 (location);
	_g_object_unref0 (_data_->location);
	_data_->location = _tmp3_;
	_tmp4_ = g_strdup (custom_name);
	_g_free0 (_data_->custom_name);
	_data_->custom_name = _tmp4_;
	synapse_file_bookmark_plugin_check_for_match_co (_data_);
}

static gboolean
synapse_file_bookmark_plugin_check_for_match_finish (SynapseFileBookmarkPlugin* self,
                                                     GAsyncResult* _res_)
{
	gboolean result;
	SynapseFileBookmarkPluginCheckForMatchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
synapse_file_bookmark_plugin_check_for_match_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	SynapseFileBookmarkPluginCheckForMatchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_file_bookmark_plugin_check_for_match_co (_data_);
}

static gboolean
synapse_file_bookmark_plugin_check_for_match_co (SynapseFileBookmarkPluginCheckForMatchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->is_hidden = FALSE;
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->location, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, synapse_file_bookmark_plugin_check_for_match_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_file_query_info_finish (_data_->location, _data_->_res_, &_data_->_inner_error0_);
		_data_->location_info = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (g_file_info_get_is_hidden (_data_->location_info)) {
			_data_->_tmp1_ = TRUE;
		} else {
			_data_->_tmp1_ = g_file_info_get_is_backup (_data_->location_info);
		}
		_data_->is_hidden = _data_->_tmp1_;
		_g_object_unref0 (_data_->location_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->err;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("file-bookmarks-plugin.vala:300: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_match_info_unref0 (_data_->info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->is_hidden) {
		_data_->result = FALSE;
		_g_match_info_unref0 (_data_->info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = g_file_get_uri (_data_->location);
	_data_->uri = _data_->_tmp4_;
	_data_->_tmp5_ = g_file_get_basename (_data_->location);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_utf8_strdown (_data_->_tmp6_, (gssize) -1);
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_free0 (_data_->_tmp6_);
	_data_->basename = _data_->_tmp8_;
	_data_->_tmp9_ = g_utf8_strdown (_data_->custom_name, (gssize) -1);
	_data_->custom_name_for_match = _data_->_tmp9_;
	_data_->matched = FALSE;
	{
		_data_->_matcher_list = _data_->matchers;
		_data_->_tmp10_ = _data_->_matcher_list;
		_data_->_tmp11_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_matcher_size = _data_->_tmp12_;
		_data_->_matcher_index = -1;
		while (TRUE) {
			_data_->_matcher_index = _data_->_matcher_index + 1;
			_data_->_tmp13_ = _data_->_matcher_index;
			_data_->_tmp14_ = _data_->_matcher_size;
			if (!(_data_->_tmp13_ < _data_->_tmp14_)) {
				break;
			}
			_data_->_tmp15_ = _data_->_matcher_list;
			_data_->_tmp16_ = gee_list_get (_data_->_tmp15_, _data_->_matcher_index);
			_data_->matcher = (GeeMapEntry*) _data_->_tmp16_;
			_data_->_tmp17_ = _data_->matcher;
			_data_->_tmp18_ = gee_map_entry_get_key (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = _data_->basename;
			_data_->_tmp21_ = NULL;
			_data_->_tmp22_ = g_regex_match ((GRegex*) _data_->_tmp19_, _data_->_tmp20_, G_REGEX_MATCH_PARTIAL, &_data_->_tmp21_);
			_g_match_info_unref0 (_data_->info);
			_data_->info = _data_->_tmp21_;
			if (_data_->_tmp22_) {
				_data_->_tmp23_ = synapse_file_bookmark_plugin_result_new (_data_->location, _data_->custom_name);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = _data_->uri;
				_data_->_tmp26_ = _data_->matcher;
				_data_->_tmp27_ = gee_map_entry_get_value (_data_->_tmp26_);
				_data_->_tmp28_ = _data_->_tmp27_;
				synapse_result_set_add (_data_->results, (SynapseMatch*) _data_->_tmp24_, synapse_file_bookmark_plugin_compute_relevancy (_data_->self, _data_->_tmp25_, (gint) ((gintptr) _data_->_tmp28_)));
				_g_object_unref0 (_data_->_tmp24_);
				_data_->matched = TRUE;
				_g_object_unref0 (_data_->matcher);
				break;
			} else {
				_data_->_tmp29_ = _data_->matcher;
				_data_->_tmp30_ = gee_map_entry_get_key (_data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = _data_->custom_name_for_match;
				_data_->_tmp33_ = NULL;
				_data_->_tmp34_ = g_regex_match ((GRegex*) _data_->_tmp31_, _data_->_tmp32_, G_REGEX_MATCH_PARTIAL, &_data_->_tmp33_);
				_g_match_info_unref0 (_data_->info);
				_data_->info = _data_->_tmp33_;
				if (_data_->_tmp34_) {
					_data_->_tmp35_ = synapse_file_bookmark_plugin_result_new (_data_->location, _data_->custom_name);
					_data_->_tmp36_ = _data_->_tmp35_;
					_data_->_tmp37_ = _data_->uri;
					_data_->_tmp38_ = _data_->matcher;
					_data_->_tmp39_ = gee_map_entry_get_value (_data_->_tmp38_);
					_data_->_tmp40_ = _data_->_tmp39_;
					synapse_result_set_add (_data_->results, (SynapseMatch*) _data_->_tmp36_, synapse_file_bookmark_plugin_compute_relevancy (_data_->self, _data_->_tmp37_, (gint) ((gintptr) _data_->_tmp40_)));
					_g_object_unref0 (_data_->_tmp36_);
					_data_->matched = TRUE;
					_g_object_unref0 (_data_->matcher);
					break;
				}
			}
			_g_object_unref0 (_data_->matcher);
		}
	}
	_data_->result = _data_->matched;
	_g_free0 (_data_->custom_name_for_match);
	_g_free0 (_data_->basename);
	_g_free0 (_data_->uri);
	_g_match_info_unref0 (_data_->info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
synapse_file_bookmark_plugin_compute_relevancy (SynapseFileBookmarkPlugin* self,
                                                const gchar* uri,
                                                gint base_relevancy)
{
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat popularity = 0.0F;
	gint r = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_tmp0_ = synapse_relevancy_service_get_default ();
	rs = _tmp0_;
	popularity = synapse_relevancy_service_get_uri_popularity (rs, uri);
	r = synapse_relevancy_service_compute_relevancy (base_relevancy, popularity);
	g_debug ("file-bookmarks-plugin.vala:335: relevancy for %s: %d", uri, r);
	result = r;
	_g_object_unref0 (rs);
	return result;
}

SynapseFileBookmarkPlugin*
synapse_file_bookmark_plugin_construct (GType object_type)
{
	SynapseFileBookmarkPlugin * self = NULL;
	self = (SynapseFileBookmarkPlugin*) g_object_new (object_type, NULL);
	return self;
}

SynapseFileBookmarkPlugin*
synapse_file_bookmark_plugin_new (void)
{
	return synapse_file_bookmark_plugin_construct (SYNAPSE_TYPE_FILE_BOOKMARK_PLUGIN);
}

static gboolean
synapse_file_bookmark_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseFileBookmarkPlugin* self;
	self = (SynapseFileBookmarkPlugin*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_file_bookmark_plugin_real_set_enabled (SynapseActivatable* base,
                                               gboolean value)
{
	SynapseFileBookmarkPlugin* self;
	gboolean old_value;
	self = (SynapseFileBookmarkPlugin*) base;
	old_value = synapse_file_bookmark_plugin_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_file_bookmark_plugin_properties[SYNAPSE_FILE_BOOKMARK_PLUGIN_ENABLED_PROPERTY]);
	}
}

static inline gpointer
synapse_file_bookmark_plugin_result_get_instance_private (SynapseFileBookmarkPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseFileBookmarkPluginResult_private_offset);
}

SynapseFileBookmarkPluginResult*
synapse_file_bookmark_plugin_result_construct (GType object_type,
                                               GFile* file,
                                               const gchar* custom_name)
{
	SynapseFileBookmarkPluginResult * self = NULL;
	GFile* _tmp0_;
	gchar* _name = NULL;
	gchar* _tmp1_;
	gchar* _icon_name = NULL;
	gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	const gchar* _tmp20_;
	gboolean _tmp22_ = FALSE;
	GAppInfo* appinfo = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GAppInfo* _tmp30_;
	GAppInfo* _tmp31_;
	GAppInfo* _tmp32_;
	gchar* _title = NULL;
	const gchar* _tmp43_;
	GAppInfo* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (SynapseFileBookmarkPluginResult*) synapse_match_construct (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->location);
	self->priv->location = _tmp0_;
	_tmp1_ = g_strdup ("");
	_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	_icon_name = _tmp2_;
	_tmp3_ = self->priv->location;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = synapse_file_bookmark_plugin_result_get_icon_user_special_dirs (self, _tmp5_);
	_g_free0 (_icon_name);
	_icon_name = _tmp6_;
	_g_free0 (_tmp5_);
	_tmp9_ = _icon_name;
	if (_tmp9_ == NULL) {
		GFile* _tmp10_;
		_tmp10_ = self->priv->location;
		_tmp8_ = !g_file_is_native (_tmp10_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = synapse_file_bookmark_plugin_result_is_remote_uri_scheme (self);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("folder-remote");
		_g_free0 (_icon_name);
		_icon_name = _tmp11_;
	}
	_tmp13_ = _icon_name;
	if (_tmp13_ == NULL) {
		GFile* _tmp14_;
		_tmp14_ = self->priv->location;
		_tmp12_ = g_file_has_uri_scheme (_tmp14_, "recent");
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("document-open-recent");
		_g_free0 (_icon_name);
		_icon_name = _tmp15_;
	}
	_tmp17_ = _icon_name;
	if (_tmp17_ == NULL) {
		GFile* _tmp18_;
		_tmp18_ = self->priv->location;
		_tmp16_ = g_file_has_uri_scheme (_tmp18_, "trash");
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("user-trash");
		_g_free0 (_icon_name);
		_icon_name = _tmp19_;
	}
	_tmp20_ = _icon_name;
	if (_tmp20_ == NULL) {
		gchar* _tmp21_;
		_tmp21_ = g_strdup ("folder");
		_g_free0 (_icon_name);
		_icon_name = _tmp21_;
	}
	if (custom_name != NULL) {
		gint _tmp23_;
		gint _tmp24_;
		_tmp23_ = strlen (custom_name);
		_tmp24_ = _tmp23_;
		_tmp22_ = _tmp24_ > 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup (custom_name);
		_g_free0 (_name);
		_name = _tmp25_;
	} else {
		GFile* _tmp26_;
		gchar* _tmp27_;
		_tmp26_ = self->priv->location;
		_tmp27_ = g_file_get_basename (_tmp26_);
		_g_free0 (_name);
		_name = _tmp27_;
	}
	_tmp28_ = g_file_get_uri_scheme (file);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_app_info_get_default_for_uri_scheme (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	appinfo = _tmp31_;
	_tmp32_ = appinfo;
	if (_tmp32_ == NULL) {
		GAppInfo* _tmp41_;
		{
			GFileInfo* info = NULL;
			GFileInfo* _tmp33_;
			const gchar* content_type = NULL;
			GFileInfo* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp33_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			info = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp34_ = info;
			_tmp35_ = g_file_info_get_content_type (_tmp34_);
			content_type = _tmp35_;
			_tmp36_ = content_type;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_;
				GAppInfo* _tmp38_;
				_tmp37_ = content_type;
				_tmp38_ = g_app_info_get_default_for_type (_tmp37_, TRUE);
				_g_object_unref0 (appinfo);
				appinfo = _tmp38_;
			}
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp39_;
			const gchar* _tmp40_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp39_ = e;
			_tmp40_ = _tmp39_->message;
			g_debug ("file-bookmarks-plugin.vala:79: %s", _tmp40_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			_g_free0 (_icon_name);
			_g_free0 (_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp41_ = appinfo;
		if (_tmp41_ == NULL) {
			GDesktopAppInfo* _tmp42_;
			_tmp42_ = g_desktop_app_info_new ("io.elementary.files.desktop");
			_g_object_unref0 (appinfo);
			appinfo = (GAppInfo*) _tmp42_;
		}
	}
	_tmp43_ = _name;
	_tmp44_ = appinfo;
	_tmp45_ = g_app_info_get_display_name (_tmp44_);
	_tmp46_ = g_strdup_printf (_ ("Open %s in %s"), _tmp43_, _tmp45_);
	_title = _tmp46_;
	synapse_match_set_title ((SynapseMatch*) self, _title);
	_tmp47_ = _icon_name;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp47_);
	synapse_match_set_description ((SynapseMatch*) self, _ ("Open the selected directory"));
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, FALSE);
	synapse_match_set_match_type ((SynapseMatch*) self, SYNAPSE_MATCH_TYPE_BOOKMARK);
	_g_free0 (_title);
	_g_object_unref0 (appinfo);
	_g_free0 (_icon_name);
	_g_free0 (_name);
	return self;
}

SynapseFileBookmarkPluginResult*
synapse_file_bookmark_plugin_result_new (GFile* file,
                                         const gchar* custom_name)
{
	return synapse_file_bookmark_plugin_result_construct (SYNAPSE_FILE_BOOKMARK_PLUGIN_TYPE_RESULT, file, custom_name);
}

static void
synapse_file_bookmark_plugin_result_real_execute (SynapseMatch* base,
                                                  SynapseMatch* match)
{
	SynapseFileBookmarkPluginResult * self;
	GError* _inner_error0_ = NULL;
	self = (SynapseFileBookmarkPluginResult*) base;
	{
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->location;
		_tmp1_ = g_file_get_uri (_tmp0_);
		_tmp2_ = _tmp1_;
		g_app_info_launch_default_for_uri (_tmp2_, NULL, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("file-bookmarks-plugin.vala:100: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
synapse_file_bookmark_plugin_result_is_remote_uri_scheme (SynapseFileBookmarkPluginResult* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (synapse_file_bookmark_plugin_result_is_root_network_folder (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = synapse_file_bookmark_plugin_result_is_other_uri_scheme (self);
	}
	result = _tmp0_;
	return result;
}

gboolean
synapse_file_bookmark_plugin_result_is_root_network_folder (SynapseFileBookmarkPluginResult* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (synapse_file_bookmark_plugin_result_is_network_uri_scheme (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = synapse_file_bookmark_plugin_result_is_smb_server (self);
	}
	result = _tmp0_;
	return result;
}

gboolean
synapse_file_bookmark_plugin_result_is_smb_server (SynapseFileBookmarkPluginResult* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (synapse_file_bookmark_plugin_result_is_smb_uri_scheme (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = synapse_file_bookmark_plugin_result_is_network_uri_scheme (self);
	}
	if (_tmp0_) {
		result = synapse_file_bookmark_plugin_result_get_number_of_uri_parts (self) == ((guint) 2);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
synapse_file_bookmark_plugin_result_is_network_uri_scheme (SynapseFileBookmarkPluginResult* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_file_get_type ())) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->location;
	result = g_file_has_uri_scheme (_tmp1_, "network");
	return result;
}

gboolean
synapse_file_bookmark_plugin_result_is_smb_uri_scheme (SynapseFileBookmarkPluginResult* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_file_get_type ())) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->location;
	result = g_file_has_uri_scheme (_tmp1_, "smb");
	return result;
}

gboolean
synapse_file_bookmark_plugin_result_is_other_uri_scheme (SynapseFileBookmarkPluginResult* self)
{
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_file_get_type ())) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->location;
	if (g_file_has_uri_scheme (_tmp5_, "ftp")) {
		_tmp4_ = TRUE;
	} else {
		GFile* _tmp6_;
		_tmp6_ = self->priv->location;
		_tmp4_ = g_file_has_uri_scheme (_tmp6_, "sftp");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		GFile* _tmp7_;
		_tmp7_ = self->priv->location;
		_tmp3_ = g_file_has_uri_scheme (_tmp7_, "afp");
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		GFile* _tmp8_;
		_tmp8_ = self->priv->location;
		_tmp2_ = g_file_has_uri_scheme (_tmp8_, "dav");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp9_;
		_tmp9_ = self->priv->location;
		_tmp1_ = g_file_has_uri_scheme (_tmp9_, "davs");
	}
	result = _tmp1_;
	return result;
}

static guint
synapse_file_bookmark_plugin_result_get_number_of_uri_parts (SynapseFileBookmarkPluginResult* self)
{
	const gchar* target_uri = NULL;
	GFileInfo* info = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	guint _tmp17_;
	GError* _inner_error0_ = NULL;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	target_uri = NULL;
	info = NULL;
	{
		GFileInfo* _tmp0_ = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		GFileInfo* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->location;
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TARGET_URI, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (info);
		info = _tmp3_;
		_tmp4_ = info;
		_tmp5_ = g_file_info_get_attribute_string (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_TARGET_URI);
		target_uri = _tmp5_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("file-bookmarks-plugin.vala:157: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint _tmp8_ = 0U;
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp9_ = target_uri;
	if (_tmp9_ == NULL) {
		gchar* uri = NULL;
		GFile* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = self->priv->location;
		_tmp11_ = g_file_get_uri (_tmp10_);
		uri = _tmp11_;
		_tmp12_ = uri;
		target_uri = _tmp12_;
		_g_free0 (uri);
	}
	_tmp13_ = target_uri;
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 6);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _vala_array_length (_tmp14_);
	_tmp17_ = (guint) _vala_array_length (_tmp14_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp17_;
	_g_object_unref0 (info);
	return result;
}

static gchar*
synapse_file_bookmark_plugin_result_get_icon_user_special_dirs (SynapseFileBookmarkPluginResult* self,
                                                                const gchar* path)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (path == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_get_home_dir ();
	if (g_strcmp0 (path, _tmp0_) == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("user-home");
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
		if (g_strcmp0 (path, _tmp2_) == 0) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("user-desktop");
			result = _tmp3_;
			return result;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
			if (g_strcmp0 (path, _tmp4_) == 0) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("folder-documents");
				result = _tmp5_;
				return result;
			} else {
				const gchar* _tmp6_;
				_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
				if (g_strcmp0 (path, _tmp6_) == 0) {
					gchar* _tmp7_;
					_tmp7_ = g_strdup ("folder-download");
					result = _tmp7_;
					return result;
				} else {
					const gchar* _tmp8_;
					_tmp8_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
					if (g_strcmp0 (path, _tmp8_) == 0) {
						gchar* _tmp9_;
						_tmp9_ = g_strdup ("folder-music");
						result = _tmp9_;
						return result;
					} else {
						const gchar* _tmp10_;
						_tmp10_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
						if (g_strcmp0 (path, _tmp10_) == 0) {
							gchar* _tmp11_;
							_tmp11_ = g_strdup ("folder-pictures");
							result = _tmp11_;
							return result;
						} else {
							const gchar* _tmp12_;
							_tmp12_ = g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE);
							if (g_strcmp0 (path, _tmp12_) == 0) {
								gchar* _tmp13_;
								_tmp13_ = g_strdup ("folder-publicshare");
								result = _tmp13_;
								return result;
							} else {
								const gchar* _tmp14_;
								_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES);
								if (g_strcmp0 (path, _tmp14_) == 0) {
									gchar* _tmp15_;
									_tmp15_ = g_strdup ("folder-templates");
									result = _tmp15_;
									return result;
								} else {
									const gchar* _tmp16_;
									_tmp16_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
									if (g_strcmp0 (path, _tmp16_) == 0) {
										gchar* _tmp17_;
										_tmp17_ = g_strdup ("folder-videos");
										result = _tmp17_;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

gint
synapse_file_bookmark_plugin_result_get_default_relevancy (SynapseFileBookmarkPluginResult* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}

void
synapse_file_bookmark_plugin_result_set_default_relevancy (SynapseFileBookmarkPluginResult* self,
                                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_file_bookmark_plugin_result_get_default_relevancy (self);
	if (old_value != value) {
		self->priv->_default_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_file_bookmark_plugin_result_properties[SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
	}
}

static void
synapse_file_bookmark_plugin_result_class_init (SynapseFileBookmarkPluginResultClass * klass,
                                                gpointer klass_data)
{
	synapse_file_bookmark_plugin_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseFileBookmarkPluginResult_private_offset);
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_file_bookmark_plugin_result_real_execute;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_file_bookmark_plugin_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_file_bookmark_plugin_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_file_bookmark_plugin_result_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_file_bookmark_plugin_result_properties[SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_file_bookmark_plugin_result_instance_init (SynapseFileBookmarkPluginResult * self,
                                                   gpointer klass)
{
	self->priv = synapse_file_bookmark_plugin_result_get_instance_private (self);
	self->priv->_default_relevancy = 0;
}

static void
synapse_file_bookmark_plugin_result_finalize (GObject * obj)
{
	SynapseFileBookmarkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_FILE_BOOKMARK_PLUGIN_TYPE_RESULT, SynapseFileBookmarkPluginResult);
	_g_object_unref0 (self->priv->location);
	G_OBJECT_CLASS (synapse_file_bookmark_plugin_result_parent_class)->finalize (obj);
}

static GType
synapse_file_bookmark_plugin_result_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseFileBookmarkPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_file_bookmark_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseFileBookmarkPluginResult), 0, (GInstanceInitFunc) synapse_file_bookmark_plugin_result_instance_init, NULL };
	GType synapse_file_bookmark_plugin_result_type_id;
	synapse_file_bookmark_plugin_result_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseFileBookmarkPluginResult", &g_define_type_info, 0);
	SynapseFileBookmarkPluginResult_private_offset = g_type_add_instance_private (synapse_file_bookmark_plugin_result_type_id, sizeof (SynapseFileBookmarkPluginResultPrivate));
	return synapse_file_bookmark_plugin_result_type_id;
}

GType
synapse_file_bookmark_plugin_result_get_type (void)
{
	static volatile gsize synapse_file_bookmark_plugin_result_type_id__once = 0;
	if (g_once_init_enter (&synapse_file_bookmark_plugin_result_type_id__once)) {
		GType synapse_file_bookmark_plugin_result_type_id;
		synapse_file_bookmark_plugin_result_type_id = synapse_file_bookmark_plugin_result_get_type_once ();
		g_once_init_leave (&synapse_file_bookmark_plugin_result_type_id__once, synapse_file_bookmark_plugin_result_type_id);
	}
	return synapse_file_bookmark_plugin_result_type_id__once;
}

static void
_vala_synapse_file_bookmark_plugin_result_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	SynapseFileBookmarkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_FILE_BOOKMARK_PLUGIN_TYPE_RESULT, SynapseFileBookmarkPluginResult);
	switch (property_id) {
		case SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		g_value_set_int (value, synapse_file_bookmark_plugin_result_get_default_relevancy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_file_bookmark_plugin_result_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	SynapseFileBookmarkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_FILE_BOOKMARK_PLUGIN_TYPE_RESULT, SynapseFileBookmarkPluginResult);
	switch (property_id) {
		case SYNAPSE_FILE_BOOKMARK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		synapse_file_bookmark_plugin_result_set_default_relevancy (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
synapse_file_bookmark_plugin_class_init (SynapseFileBookmarkPluginClass * klass,
                                         gpointer klass_data)
{
	synapse_file_bookmark_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseFileBookmarkPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_file_bookmark_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_file_bookmark_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_file_bookmark_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_FILE_BOOKMARK_PLUGIN_ENABLED_PROPERTY, synapse_file_bookmark_plugin_properties[SYNAPSE_FILE_BOOKMARK_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_file_bookmark_plugin_register_plugin ();
}

static void
synapse_file_bookmark_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                                 gpointer iface_data)
{
	synapse_file_bookmark_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_file_bookmark_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_file_bookmark_plugin_real_deactivate;
	iface->get_enabled = synapse_file_bookmark_plugin_real_get_enabled;
	iface->set_enabled = synapse_file_bookmark_plugin_real_set_enabled;
}

static void
synapse_file_bookmark_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                   gpointer iface_data)
{
	synapse_file_bookmark_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_file_bookmark_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_file_bookmark_plugin_search_finish;
}

static void
synapse_file_bookmark_plugin_instance_init (SynapseFileBookmarkPlugin * self,
                                            gpointer klass)
{
	self->priv = synapse_file_bookmark_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}

static void
synapse_file_bookmark_plugin_finalize (GObject * obj)
{
	SynapseFileBookmarkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_FILE_BOOKMARK_PLUGIN, SynapseFileBookmarkPlugin);
	G_OBJECT_CLASS (synapse_file_bookmark_plugin_parent_class)->finalize (obj);
}

static GType
synapse_file_bookmark_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseFileBookmarkPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_file_bookmark_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseFileBookmarkPlugin), 0, (GInstanceInitFunc) synapse_file_bookmark_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_file_bookmark_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_file_bookmark_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_file_bookmark_plugin_type_id;
	synapse_file_bookmark_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseFileBookmarkPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_file_bookmark_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_file_bookmark_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseFileBookmarkPlugin_private_offset = g_type_add_instance_private (synapse_file_bookmark_plugin_type_id, sizeof (SynapseFileBookmarkPluginPrivate));
	return synapse_file_bookmark_plugin_type_id;
}

GType
synapse_file_bookmark_plugin_get_type (void)
{
	static volatile gsize synapse_file_bookmark_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_file_bookmark_plugin_type_id__once)) {
		GType synapse_file_bookmark_plugin_type_id;
		synapse_file_bookmark_plugin_type_id = synapse_file_bookmark_plugin_get_type_once ();
		g_once_init_leave (&synapse_file_bookmark_plugin_type_id__once, synapse_file_bookmark_plugin_type_id);
	}
	return synapse_file_bookmark_plugin_type_id__once;
}

static void
_vala_synapse_file_bookmark_plugin_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SynapseFileBookmarkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_FILE_BOOKMARK_PLUGIN, SynapseFileBookmarkPlugin);
	switch (property_id) {
		case SYNAPSE_FILE_BOOKMARK_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_file_bookmark_plugin_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SynapseFileBookmarkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_FILE_BOOKMARK_PLUGIN, SynapseFileBookmarkPlugin);
	switch (property_id) {
		case SYNAPSE_FILE_BOOKMARK_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

