/* AppContextMenu.c generated by valac 0.56.18, the Vala compiler
 * generated from AppContextMenu.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2020-2021 Justin Haygood
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_APP_CONTEXT_MENU_0_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_NUM_PROPERTIES
};
static GParamSpec* slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SlingshotAppContextMenuOnAppcenterDbusChangedData SlingshotAppContextMenuOnAppcenterDbusChangedData;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
enum  {
	SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_APP_CONTEXT_MENU_NUM_SIGNALS
};
static guint slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_NUM_SIGNALS] = {0};

struct _SlingshotAppContextMenuPrivate {
	gchar* _desktop_id;
	gchar* _desktop_path;
	GDesktopAppInfo* app_info;
	gboolean has_system_item;
	gchar* appstream_comp_id;
	SlingshotBackendSwitcherooControl* switcheroo_control;
	GtkMenuItem* uninstall_menuitem;
	GtkMenuItem* appcenter_menuitem;
	GtkCheckMenuItem* dock_menuitem;
};

struct _Block10Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* appcenter;
};

struct _SlingshotAppContextMenuOnAppcenterDbusChangedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* appcenter;
	AppCenterDBus* _tmp0_;
	AppCenterDBus* _tmp1_;
	gchar* _tmp2_;
	AppCenterDBus* _tmp3_;
	AppCenterDBus* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* e;
	gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GtkMenuItem* _tmp12_;
	const gchar* _tmp13_;
	GtkMenuItem* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _Block11Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	gchar* action;
};

struct _Block12Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	gboolean prefers_non_default_gpu;
};

struct _Block13Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	SlingshotBackendDock* dock;
};

struct _Block14Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* appcenter;
};

static gint SlingshotAppContextMenu_private_offset;
static gpointer slingshot_app_context_menu_parent_class = NULL;

static void slingshot_app_context_menu_uninstall_menuitem_activate (SlingshotAppContextMenu* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda28_ (Block10Data* _data10_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda28__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void slingshot_app_context_menu_open_in_appcenter (SlingshotAppContextMenu* self);
static void __lambda29_ (SlingshotAppContextMenu* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda29__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void slingshot_app_context_menu_on_appcenter_dbus_changed_data_free (gpointer _data);
static void slingshot_app_context_menu_on_appcenter_dbus_changed (SlingshotAppContextMenu* self,
                                                           SlingshotBackendAppCenter* appcenter,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void slingshot_app_context_menu_on_appcenter_dbus_changed_finish (SlingshotAppContextMenu* self,
                                                                  GAsyncResult* _res_);
static gboolean slingshot_app_context_menu_on_appcenter_dbus_changed_co (SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_);
static void slingshot_app_context_menu_on_appcenter_dbus_changed_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void slingshot_app_context_menu_on_dock_dbus_changed (SlingshotAppContextMenu* self,
                                                      SlingshotBackendDock* dock);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void slingshot_app_context_menu_dock_menuitem_activate (SlingshotAppContextMenu* self);
static GObject * slingshot_app_context_menu_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void _slingshot_app_context_menu_____lambda34_ (Block11Data* _data11_,
                                                GtkMenuItem* target);
static void __slingshot_app_context_menu_____lambda34__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void _slingshot_app_context_menu____lambda35_ (Block12Data* _data12_,
                                               GtkMenuItem* target);
static void __slingshot_app_context_menu____lambda35__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                       gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void _slingshot_app_context_menu_dock_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                                gpointer self);
static void _slingshot_app_context_menu____lambda36_ (Block13Data* _data13_);
static void __slingshot_app_context_menu____lambda36__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void _slingshot_app_context_menu_uninstall_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                                     gpointer self);
static void _slingshot_app_context_menu_open_in_appcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                           gpointer self);
static void _slingshot_app_context_menu____lambda37_ (Block14Data* _data14_);
static void __slingshot_app_context_menu____lambda37__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void slingshot_app_context_menu_finalize (GObject * obj);
static GType slingshot_app_context_menu_get_type_once (void);
static void _vala_slingshot_app_context_menu_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_slingshot_app_context_menu_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_app_context_menu_get_instance_private (SlingshotAppContextMenu* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotAppContextMenu_private_offset);
}

SlingshotAppContextMenu*
slingshot_app_context_menu_construct (GType object_type,
                                      const gchar* desktop_id,
                                      const gchar* desktop_path)
{
	SlingshotAppContextMenu * self = NULL;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	g_return_val_if_fail (desktop_path != NULL, NULL);
	self = (SlingshotAppContextMenu*) g_object_new (object_type, "desktop-id", desktop_id, "desktop-path", desktop_path, NULL);
	return self;
}

SlingshotAppContextMenu*
slingshot_app_context_menu_new (const gchar* desktop_id,
                                const gchar* desktop_path)
{
	return slingshot_app_context_menu_construct (SLINGSHOT_TYPE_APP_CONTEXT_MENU, desktop_id, desktop_path);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->appcenter);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda28_ (Block10Data* _data10_,
             GObject* obj,
             GAsyncResult* res)
{
	SlingshotAppContextMenu* self;
	GError* _inner_error0_ = NULL;
	self = _data10_->self;
	g_return_if_fail (res != NULL);
	{
		SlingshotBackendAppCenter* _tmp0_;
		AppCenterDBus* _tmp1_;
		AppCenterDBus* _tmp2_;
		_tmp0_ = _data10_->appcenter;
		_tmp1_ = slingshot_backend_app_center_get_dbus (_tmp0_);
		_tmp2_ = _tmp1_;
		app_center_dbus_uninstall_finish (_tmp2_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("AppContextMenu.vala:144: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda28__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda28_ (self, source_object, res);
	block10_data_unref (self);
}

static void
slingshot_app_context_menu_uninstall_menuitem_activate (SlingshotAppContextMenu* self)
{
	Block10Data* _data10_;
	SlingshotBackendAppCenter* _tmp0_;
	SlingshotBackendAppCenter* _tmp1_;
	gboolean _tmp2_ = FALSE;
	SlingshotBackendAppCenter* _tmp3_;
	AppCenterDBus* _tmp4_;
	AppCenterDBus* _tmp5_;
	SlingshotBackendAppCenter* _tmp7_;
	AppCenterDBus* _tmp8_;
	AppCenterDBus* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = slingshot_backend_app_center_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data10_->appcenter = _tmp1_;
	_tmp3_ = _data10_->appcenter;
	_tmp4_ = slingshot_backend_app_center_get_dbus (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->appstream_comp_id;
		_tmp2_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp2_) {
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
	_tmp7_ = _data10_->appcenter;
	_tmp8_ = slingshot_backend_app_center_get_dbus (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->appstream_comp_id;
	app_center_dbus_uninstall (_tmp9_, _tmp10_, ___lambda28__gasync_ready_callback, block10_data_ref (_data10_));
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
__lambda29_ (SlingshotAppContextMenu* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		g_app_info_launch_default_for_uri_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GraniteMessageDialog* message_dialog = NULL;
		GDesktopAppInfo* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GraniteMessageDialog* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		GraniteMessageDialog* _tmp10_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = self->priv->app_info;
		_tmp1_ = g_app_info_get_display_name ((GAppInfo*) _tmp0_);
		_tmp2_ = g_strdup_printf ("Unable to open %s in AppCenter", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = granite_message_dialog_new_with_image_from_icon_name (_tmp3_, "", "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		message_dialog = _tmp5_;
		_tmp6_ = message_dialog;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		granite_message_dialog_show_error_details (_tmp6_, _tmp8_);
		_tmp9_ = message_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp9_);
		_tmp10_ = message_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp10_);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (_error_);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda29__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda29_ ((SlingshotAppContextMenu*) self, source_object, res);
	g_object_unref (self);
}

static void
slingshot_app_context_menu_open_in_appcenter (SlingshotAppContextMenu* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->appstream_comp_id;
	_tmp1_ = g_strconcat ("appstream://", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	g_app_info_launch_default_for_uri_async (_tmp2_, NULL, NULL, ___lambda29__gasync_ready_callback, g_object_ref (self));
	_g_free0 (_tmp2_);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed_data_free (gpointer _data)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->appcenter);
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotAppContextMenuOnAppcenterDbusChangedData, _data_);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed (SlingshotAppContextMenu* self,
                                                      SlingshotBackendAppCenter* appcenter,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	SlingshotAppContextMenu* _tmp0_;
	SlingshotBackendAppCenter* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (appcenter != NULL);
	_data_ = g_slice_new0 (SlingshotAppContextMenuOnAppcenterDbusChangedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_app_context_menu_on_appcenter_dbus_changed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (appcenter);
	_g_object_unref0 (_data_->appcenter);
	_data_->appcenter = _tmp1_;
	slingshot_app_context_menu_on_appcenter_dbus_changed_co (_data_);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed_finish (SlingshotAppContextMenu* self,
                                                             GAsyncResult* _res_)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_app_context_menu_on_appcenter_dbus_changed_co (_data_);
}

static gboolean
slingshot_app_context_menu_on_appcenter_dbus_changed_co (SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = slingshot_backend_app_center_get_dbus (_data_->appcenter);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		{
			_data_->_tmp3_ = slingshot_backend_app_center_get_dbus (_data_->appcenter);
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp5_ = _data_->self->priv->_desktop_id;
			_data_->_state_ = 1;
			app_center_dbus_get_component_from_desktop_id (_data_->_tmp4_, _data_->_tmp5_, slingshot_app_context_menu_on_appcenter_dbus_changed_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = app_center_dbus_get_component_from_desktop_id_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp2_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp2_;
			_data_->_tmp2_ = NULL;
			_g_free0 (_data_->self->priv->appstream_comp_id);
			_data_->self->priv->appstream_comp_id = _data_->_tmp7_;
			_g_free0 (_data_->_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp8_ = g_strdup ("");
			_g_free0 (_data_->self->priv->appstream_comp_id);
			_data_->self->priv->appstream_comp_id = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			g_warning ("AppContextMenu.vala:175: %s", _data_->_tmp10_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp11_ = g_strdup ("");
		_g_free0 (_data_->self->priv->appstream_comp_id);
		_data_->self->priv->appstream_comp_id = _data_->_tmp11_;
	}
	_data_->_tmp12_ = _data_->self->priv->uninstall_menuitem;
	_data_->_tmp13_ = _data_->self->priv->appstream_comp_id;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp12_, g_strcmp0 (_data_->_tmp13_, "") != 0);
	_data_->_tmp14_ = _data_->self->priv->appcenter_menuitem;
	_data_->_tmp15_ = _data_->self->priv->appstream_comp_id;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp14_, g_strcmp0 (_data_->_tmp15_, "") != 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
slingshot_app_context_menu_on_dock_dbus_changed (SlingshotAppContextMenu* self,
                                                 SlingshotBackendDock* dock)
{
	DockDBus* _tmp0_;
	DockDBus* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dock != NULL);
	_tmp0_ = slingshot_backend_dock_get_dbus (dock);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkCheckMenuItem* _tmp2_;
		_tmp2_ = self->priv->dock_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		{
			gchar** _tmp3_ = NULL;
			DockDBus* _tmp4_;
			DockDBus* _tmp5_;
			gint _tmp6_ = 0;
			gchar** _tmp7_;
			gint _tmp3__length1;
			gint __tmp3__size_;
			GtkCheckMenuItem* _tmp8_;
			const gchar* _tmp9_;
			_tmp4_ = slingshot_backend_dock_get_dbus (dock);
			_tmp5_ = _tmp4_;
			_tmp7_ = dock_dbus_list_launchers (_tmp5_, &_tmp6_, &_inner_error0_);
			_tmp3_ = _tmp7_;
			_tmp3__length1 = _tmp6_;
			__tmp3__size_ = _tmp3__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = self->priv->dock_menuitem;
			_tmp9_ = self->priv->_desktop_id;
			gtk_check_menu_item_set_active (_tmp8_, _vala_string_array_contains (_tmp3_, _tmp3__length1, _tmp9_));
			_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_critical ("AppContextMenu.vala:192: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GtkCheckMenuItem* _tmp12_;
		_tmp12_ = self->priv->dock_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
	}
}

static void
slingshot_app_context_menu_dock_menuitem_activate (SlingshotAppContextMenu* self)
{
	SlingshotBackendDock* dock = NULL;
	SlingshotBackendDock* _tmp0_;
	SlingshotBackendDock* _tmp1_;
	SlingshotBackendDock* _tmp2_;
	DockDBus* _tmp3_;
	DockDBus* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = slingshot_backend_dock_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	dock = _tmp1_;
	_tmp2_ = dock;
	_tmp3_ = slingshot_backend_dock_get_dbus (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (dock);
		return;
	}
	{
		GtkCheckMenuItem* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->dock_menuitem;
		_tmp6_ = gtk_check_menu_item_get_active (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			SlingshotBackendDock* _tmp8_;
			DockDBus* _tmp9_;
			DockDBus* _tmp10_;
			const gchar* _tmp11_;
			_tmp8_ = dock;
			_tmp9_ = slingshot_backend_dock_get_dbus (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_desktop_id;
			dock_dbus_add_launcher (_tmp10_, _tmp11_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			SlingshotBackendDock* _tmp12_;
			DockDBus* _tmp13_;
			DockDBus* _tmp14_;
			const gchar* _tmp15_;
			_tmp12_ = dock;
			_tmp13_ = slingshot_backend_dock_get_dbus (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_desktop_id;
			dock_dbus_remove_launcher (_tmp14_, _tmp15_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("AppContextMenu.vala:212: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dock);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dock);
}

const gchar*
slingshot_app_context_menu_get_desktop_id (SlingshotAppContextMenu* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_context_menu_set_desktop_id (SlingshotAppContextMenu* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_context_menu_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY]);
	}
}

const gchar*
slingshot_app_context_menu_get_desktop_path (SlingshotAppContextMenu* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_context_menu_set_desktop_path (SlingshotAppContextMenu* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_context_menu_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY]);
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data11_->self;
		_g_free0 (_data11_->action);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
_slingshot_app_context_menu_____lambda34_ (Block11Data* _data11_,
                                           GtkMenuItem* target)
{
	SlingshotAppContextMenu* self;
	GdkAppLaunchContext* context = NULL;
	GdkDisplay* _tmp0_;
	GdkAppLaunchContext* _tmp1_;
	GdkAppLaunchContext* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	const gchar* _tmp4_;
	GdkAppLaunchContext* _tmp5_;
	self = _data11_->self;
	g_return_if_fail (target != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) target);
	_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
	context = _tmp1_;
	_tmp2_ = context;
	gdk_app_launch_context_set_timestamp (_tmp2_, gtk_get_current_event_time ());
	_tmp3_ = self->priv->app_info;
	_tmp4_ = _data11_->action;
	_tmp5_ = context;
	g_desktop_app_info_launch_action (_tmp3_, _tmp4_, (GAppLaunchContext*) _tmp5_);
	g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
	_g_object_unref0 (context);
}

static void
__slingshot_app_context_menu_____lambda34__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	_slingshot_app_context_menu_____lambda34_ (self, _sender);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data12_->self;
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
_slingshot_app_context_menu____lambda35_ (Block12Data* _data12_,
                                          GtkMenuItem* target)
{
	SlingshotAppContextMenu* self;
	GError* _inner_error0_ = NULL;
	self = _data12_->self;
	g_return_if_fail (target != NULL);
	{
		GdkAppLaunchContext* context = NULL;
		GdkDisplay* _tmp0_;
		GdkAppLaunchContext* _tmp1_;
		GdkAppLaunchContext* _tmp2_;
		SlingshotBackendSwitcherooControl* _tmp3_;
		GdkAppLaunchContext* _tmp4_;
		GDesktopAppInfo* _tmp5_;
		GdkAppLaunchContext* _tmp6_;
		_tmp0_ = gtk_widget_get_display ((GtkWidget*) target);
		_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
		context = _tmp1_;
		_tmp2_ = context;
		gdk_app_launch_context_set_timestamp (_tmp2_, gtk_get_current_event_time ());
		_tmp3_ = self->priv->switcheroo_control;
		_tmp4_ = context;
		slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp3_, (GAppLaunchContext*) _tmp4_, _data12_->prefers_non_default_gpu);
		_tmp5_ = self->priv->app_info;
		_tmp6_ = context;
		g_app_info_launch ((GAppInfo*) _tmp5_, NULL, (GAppLaunchContext*) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (context);
			goto __catch0_g_error;
		}
		g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
		_g_object_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = gtk_widget_get_name ((GtkWidget*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("AppContextMenu.vala:77: Failed to launch %s: %s", _tmp8_, _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__slingshot_app_context_menu____lambda35__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                  gpointer self)
{
	_slingshot_app_context_menu____lambda35_ (self, _sender);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->dock);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
_slingshot_app_context_menu_dock_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                           gpointer self)
{
	slingshot_app_context_menu_dock_menuitem_activate ((SlingshotAppContextMenu*) self);
}

static void
_slingshot_app_context_menu____lambda36_ (Block13Data* _data13_)
{
	SlingshotAppContextMenu* self;
	SlingshotBackendDock* _tmp0_;
	self = _data13_->self;
	_tmp0_ = _data13_->dock;
	slingshot_app_context_menu_on_dock_dbus_changed (self, _tmp0_);
}

static void
__slingshot_app_context_menu____lambda36__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_slingshot_app_context_menu____lambda36_ (self);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->appcenter);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
_slingshot_app_context_menu_uninstall_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                                gpointer self)
{
	slingshot_app_context_menu_uninstall_menuitem_activate ((SlingshotAppContextMenu*) self);
}

static void
_slingshot_app_context_menu_open_in_appcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                      gpointer self)
{
	slingshot_app_context_menu_open_in_appcenter ((SlingshotAppContextMenu*) self);
}

static void
_slingshot_app_context_menu____lambda37_ (Block14Data* _data14_)
{
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* _tmp0_;
	self = _data14_->self;
	_tmp0_ = _data14_->appcenter;
	slingshot_app_context_menu_on_appcenter_dbus_changed (self, _tmp0_, NULL, NULL);
}

static void
__slingshot_app_context_menu____lambda37__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_slingshot_app_context_menu____lambda37_ (self);
}

static GObject *
slingshot_app_context_menu_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotAppContextMenu * self;
	SlingshotBackendSwitcherooControl* _tmp0_;
	const gchar* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gboolean _tmp16_ = FALSE;
	SlingshotBackendSwitcherooControl* _tmp17_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gboolean _tmp48_;
	parent_class = G_OBJECT_CLASS (slingshot_app_context_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	_tmp0_ = slingshot_backend_switcheroo_control_new ();
	_g_object_unref0 (self->priv->switcheroo_control);
	self->priv->switcheroo_control = _tmp0_;
	_tmp1_ = self->priv->_desktop_id;
	_tmp2_ = g_desktop_app_info_new (_tmp1_);
	_g_object_unref0 (self->priv->app_info);
	self->priv->app_info = _tmp2_;
	_tmp3_ = self->priv->app_info;
	_tmp5_ = _tmp4_ = g_desktop_app_info_list_actions (_tmp3_);
	{
		gchar** _action_collection = NULL;
		gint _action_collection_length1 = 0;
		gint __action_collection_size_ = 0;
		gint _action_it = 0;
		_action_collection = _tmp5_;
		_action_collection_length1 = _vala_array_length (_tmp4_);
		for (_action_it = 0; _action_it < _action_collection_length1; _action_it = _action_it + 1) {
			const gchar* _action = NULL;
			_action = _action_collection[_action_it];
			{
				Block11Data* _data11_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GtkMenuItem* menuitem = NULL;
				GDesktopAppInfo* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GtkMenuItem* _tmp12_;
				GtkMenuItem* _tmp13_;
				GtkMenuItem* _tmp14_;
				GtkMenuItem* _tmp15_;
				_data11_ = g_slice_new0 (Block11Data);
				_data11_->_ref_count_ = 1;
				_data11_->self = g_object_ref (self);
				_tmp6_ = _action;
				_tmp7_ = g_strdup (_tmp6_);
				_data11_->action = _tmp7_;
				_tmp8_ = self->priv->app_info;
				_tmp9_ = _data11_->action;
				_tmp10_ = g_desktop_app_info_get_action_name (_tmp8_, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp11_);
				g_object_ref_sink (_tmp12_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				menuitem = _tmp13_;
				_tmp14_ = menuitem;
				gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
				_tmp15_ = menuitem;
				g_signal_connect_data (_tmp15_, "activate", (GCallback) __slingshot_app_context_menu_____lambda34__gtk_menu_item_activate, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
				_g_object_unref0 (menuitem);
				block11_data_unref (_data11_);
				_data11_ = NULL;
			}
		}
	}
	_tmp17_ = self->priv->switcheroo_control;
	if (_tmp17_ != NULL) {
		SlingshotBackendSwitcherooControl* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->switcheroo_control;
		_tmp19_ = slingshot_backend_switcheroo_control_get_has_dual_gpu (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		Block12Data* _data12_;
		GDesktopAppInfo* _tmp21_;
		gchar* gpu_name = NULL;
		SlingshotBackendSwitcherooControl* _tmp22_;
		gchar* _tmp23_;
		gchar* label = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		GtkMenuItem* menu_item = NULL;
		const gchar* _tmp26_;
		GtkMenuItem* _tmp27_;
		GtkMenuItem* _tmp28_;
		GtkMenuItem* _tmp29_;
		_data12_ = g_slice_new0 (Block12Data);
		_data12_->_ref_count_ = 1;
		_data12_->self = g_object_ref (self);
		_tmp21_ = self->priv->app_info;
		_data12_->prefers_non_default_gpu = g_desktop_app_info_get_boolean (_tmp21_, "PrefersNonDefaultGPU");
		_tmp22_ = self->priv->switcheroo_control;
		_tmp23_ = slingshot_backend_switcheroo_control_get_gpu_name (_tmp22_, _data12_->prefers_non_default_gpu);
		gpu_name = _tmp23_;
		_tmp24_ = gpu_name;
		_tmp25_ = g_strdup_printf (_ ("Open with %s Graphics"), _tmp24_);
		label = _tmp25_;
		_tmp26_ = label;
		_tmp27_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp26_);
		g_object_ref_sink (_tmp27_);
		menu_item = _tmp27_;
		_tmp28_ = menu_item;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
		_tmp29_ = menu_item;
		g_signal_connect_data (_tmp29_, "activate", (GCallback) __slingshot_app_context_menu____lambda35__gtk_menu_item_activate, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
		_g_object_unref0 (menu_item);
		_g_free0 (label);
		_g_free0 (gpu_name);
		block12_data_unref (_data12_);
		_data12_ = NULL;
	}
	_tmp30_ = g_find_program_in_path ("io.elementary.dock");
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_ != NULL;
	_g_free0 (_tmp31_);
	if (_tmp32_) {
		Block13Data* _data13_;
		GList* _tmp33_;
		GList* _tmp34_;
		gboolean _tmp35_;
		SlingshotBackendDock* _tmp38_;
		SlingshotBackendDock* _tmp39_;
		gchar* _tmp40_;
		GtkCheckMenuItem* _tmp41_ = NULL;
		GtkCheckMenuItem* _tmp42_;
		GtkCheckMenuItem* _tmp43_;
		SlingshotBackendDock* _tmp44_;
		SlingshotBackendDock* _tmp45_;
		_data13_ = g_slice_new0 (Block13Data);
		_data13_->_ref_count_ = 1;
		_data13_->self = g_object_ref (self);
		_tmp33_ = gtk_container_get_children ((GtkContainer*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_list_length (_tmp34_) > ((guint) 0);
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (g_list_free (_tmp34_), NULL));
		if (_tmp35_) {
			GtkSeparatorMenuItem* _tmp36_;
			GtkSeparatorMenuItem* _tmp37_;
			_tmp36_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp36_);
			_tmp37_ = _tmp36_;
			gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp37_);
			_g_object_unref0 (_tmp37_);
		}
		self->priv->has_system_item = TRUE;
		_tmp38_ = slingshot_backend_dock_get_default ();
		_tmp39_ = _g_object_ref0 (_tmp38_);
		_data13_->dock = _tmp39_;
		_tmp40_ = g_strdup (_ ("Keep in _Dock"));
		_tmp41_ = (GtkCheckMenuItem*) gtk_check_menu_item_new ();
		gtk_menu_item_set_label ((GtkMenuItem*) _tmp41_, _tmp40_);
		_g_free0 (_tmp40_);
		gtk_menu_item_set_use_underline ((GtkMenuItem*) _tmp41_, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) _tmp41_, FALSE);
		g_object_ref_sink (_tmp41_);
		_g_object_unref0 (self->priv->dock_menuitem);
		self->priv->dock_menuitem = _tmp41_;
		_tmp42_ = self->priv->dock_menuitem;
		g_signal_connect_object ((GtkMenuItem*) _tmp42_, "activate", (GCallback) _slingshot_app_context_menu_dock_menuitem_activate_gtk_menu_item_activate, self, 0);
		_tmp43_ = self->priv->dock_menuitem;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
		_tmp44_ = _data13_->dock;
		g_signal_connect_data ((GObject*) _tmp44_, "notify::dbus", (GCallback) __slingshot_app_context_menu____lambda36__g_object_notify, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		_tmp45_ = _data13_->dock;
		slingshot_app_context_menu_on_dock_dbus_changed (self, _tmp45_);
		block13_data_unref (_data13_);
		_data13_ = NULL;
	}
	_tmp46_ = g_find_program_in_path ("io.elementary.appcenter");
	_tmp47_ = _tmp46_;
	_tmp48_ = _tmp47_ != NULL;
	_g_free0 (_tmp47_);
	if (_tmp48_) {
		Block14Data* _data14_;
		gboolean _tmp49_ = FALSE;
		GtkMenuItem* _tmp54_ = NULL;
		GtkMenuItem* _tmp55_;
		GtkMenuItem* _tmp56_ = NULL;
		GtkMenuItem* _tmp57_;
		GtkMenuItem* _tmp58_;
		GtkMenuItem* _tmp59_;
		SlingshotBackendAppCenter* _tmp60_;
		SlingshotBackendAppCenter* _tmp61_;
		SlingshotBackendAppCenter* _tmp62_;
		SlingshotBackendAppCenter* _tmp63_;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->self = g_object_ref (self);
		if (!self->priv->has_system_item) {
			GList* _tmp50_;
			GList* _tmp51_;
			_tmp50_ = gtk_container_get_children ((GtkContainer*) self);
			_tmp51_ = _tmp50_;
			_tmp49_ = g_list_length (_tmp51_) > ((guint) 0);
			(_tmp51_ == NULL) ? NULL : (_tmp51_ = (g_list_free (_tmp51_), NULL));
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			GtkSeparatorMenuItem* _tmp52_;
			GtkSeparatorMenuItem* _tmp53_;
			_tmp52_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp52_);
			_tmp53_ = _tmp52_;
			gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp53_);
			_g_object_unref0 (_tmp53_);
		}
		_tmp54_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Uninstall"));
		gtk_widget_set_sensitive ((GtkWidget*) _tmp54_, FALSE);
		g_object_ref_sink (_tmp54_);
		_g_object_unref0 (self->priv->uninstall_menuitem);
		self->priv->uninstall_menuitem = _tmp54_;
		_tmp55_ = self->priv->uninstall_menuitem;
		g_signal_connect_object (_tmp55_, "activate", (GCallback) _slingshot_app_context_menu_uninstall_menuitem_activate_gtk_menu_item_activate, self, 0);
		_tmp56_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("View in AppCenter"));
		gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, FALSE);
		g_object_ref_sink (_tmp56_);
		_g_object_unref0 (self->priv->appcenter_menuitem);
		self->priv->appcenter_menuitem = _tmp56_;
		_tmp57_ = self->priv->appcenter_menuitem;
		g_signal_connect_object (_tmp57_, "activate", (GCallback) _slingshot_app_context_menu_open_in_appcenter_gtk_menu_item_activate, self, 0);
		_tmp58_ = self->priv->uninstall_menuitem;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp58_);
		_tmp59_ = self->priv->appcenter_menuitem;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp59_);
		_tmp60_ = slingshot_backend_app_center_get_default ();
		_tmp61_ = _g_object_ref0 (_tmp60_);
		_data14_->appcenter = _tmp61_;
		_tmp62_ = _data14_->appcenter;
		g_signal_connect_data ((GObject*) _tmp62_, "notify::dbus", (GCallback) __slingshot_app_context_menu____lambda37__g_object_notify, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
		_tmp63_ = _data14_->appcenter;
		slingshot_app_context_menu_on_appcenter_dbus_changed (self, _tmp63_, NULL, NULL);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
slingshot_app_context_menu_class_init (SlingshotAppContextMenuClass * klass,
                                       gpointer klass_data)
{
	slingshot_app_context_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotAppContextMenu_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_app_context_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_app_context_menu_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_app_context_menu_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_app_context_menu_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL] = g_signal_new ("app-launched", SLINGSHOT_TYPE_APP_CONTEXT_MENU, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_app_context_menu_instance_init (SlingshotAppContextMenu * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = slingshot_app_context_menu_get_instance_private (self);
	self->priv->has_system_item = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->appstream_comp_id = _tmp0_;
}

static void
slingshot_app_context_menu_finalize (GObject * obj)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_desktop_path);
	_g_object_unref0 (self->priv->app_info);
	_g_free0 (self->priv->appstream_comp_id);
	_g_object_unref0 (self->priv->switcheroo_control);
	_g_object_unref0 (self->priv->uninstall_menuitem);
	_g_object_unref0 (self->priv->appcenter_menuitem);
	_g_object_unref0 (self->priv->dock_menuitem);
	G_OBJECT_CLASS (slingshot_app_context_menu_parent_class)->finalize (obj);
}

static GType
slingshot_app_context_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotAppContextMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_app_context_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotAppContextMenu), 0, (GInstanceInitFunc) slingshot_app_context_menu_instance_init, NULL };
	GType slingshot_app_context_menu_type_id;
	slingshot_app_context_menu_type_id = g_type_register_static (gtk_menu_get_type (), "SlingshotAppContextMenu", &g_define_type_info, 0);
	SlingshotAppContextMenu_private_offset = g_type_add_instance_private (slingshot_app_context_menu_type_id, sizeof (SlingshotAppContextMenuPrivate));
	return slingshot_app_context_menu_type_id;
}

GType
slingshot_app_context_menu_get_type (void)
{
	static volatile gsize slingshot_app_context_menu_type_id__once = 0;
	if (g_once_init_enter (&slingshot_app_context_menu_type_id__once)) {
		GType slingshot_app_context_menu_type_id;
		slingshot_app_context_menu_type_id = slingshot_app_context_menu_get_type_once ();
		g_once_init_leave (&slingshot_app_context_menu_type_id__once, slingshot_app_context_menu_type_id);
	}
	return slingshot_app_context_menu_type_id__once;
}

static void
_vala_slingshot_app_context_menu_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	switch (property_id) {
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, slingshot_app_context_menu_get_desktop_id (self));
		break;
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, slingshot_app_context_menu_get_desktop_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_app_context_menu_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	switch (property_id) {
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY:
		slingshot_app_context_menu_set_desktop_id (self, g_value_get_string (value));
		break;
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY:
		slingshot_app_context_menu_set_desktop_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

