/* AppSystem.c generated by valac 0.56.18, the Vala compiler
 * generated from AppSystem.vala, do not modify */

/*
 * Copyright 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <float.h>
#include <math.h>

#define SLINGSHOT_BACKEND_APP_SYSTEM_MENU_REFRESH_TIMEOUT_SECONDS 3
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_BACKEND_APP_SYSTEM_0_PROPERTY,
	SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY,
	SLINGSHOT_BACKEND_APP_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL,
	SLINGSHOT_BACKEND_APP_SYSTEM_NUM_SIGNALS
};
static guint slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_NUM_SIGNALS] = {0};

struct _SlingshotBackendAppSystemPrivate {
	GeeHashMap* _apps;
	guint refresh_timeout_id;
	GeeArrayList* categories_cache;
	GAppInfoMonitor* app_monitor;
	SlingshotBackendRelevancyService* rl_service;
};

static gint SlingshotBackendAppSystem_private_offset;
static gpointer slingshot_backend_app_system_parent_class = NULL;

static void slingshot_backend_app_system_queue_update_app_system (SlingshotBackendAppSystem* self);
static gboolean __lambda24_ (SlingshotBackendAppSystem* self);
static void slingshot_backend_app_system_update_app_system (SlingshotBackendAppSystem* self);
static gboolean ___lambda24__gsource_func (gpointer self);
static void slingshot_backend_app_system_update_categories_index (SlingshotBackendAppSystem* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void slingshot_backend_app_system_update_popularity (SlingshotBackendAppSystem* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gint slingshot_backend_app_system_sort_apps_by_name (SlingshotBackendApp* a,
                                                     SlingshotBackendApp* b);
static gint _slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void slingshot_backend_app_system_set_apps (SlingshotBackendAppSystem* self,
                                            GeeHashMap* value);
static GObject * slingshot_backend_app_system_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _slingshot_backend_app_system_update_popularity_slingshot_backend_relevancy_service_update_complete (SlingshotBackendRelevancyService* _sender,
                                                                                                          gpointer self);
static void _slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                                       gpointer self);
static void slingshot_backend_app_system_finalize (GObject * obj);
static GType slingshot_backend_app_system_get_type_once (void);
static void _vala_slingshot_backend_app_system_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_slingshot_backend_app_system_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
slingshot_backend_app_system_get_instance_private (SlingshotBackendAppSystem* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendAppSystem_private_offset);
}

static gboolean
__lambda24_ (SlingshotBackendAppSystem* self)
{
	gboolean result;
	slingshot_backend_app_system_update_app_system (self);
	self->priv->refresh_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda24__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda24_ ((SlingshotBackendAppSystem*) self);
	return result;
}

static void
slingshot_backend_app_system_queue_update_app_system (SlingshotBackendAppSystem* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->refresh_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->refresh_timeout_id);
		self->priv->refresh_timeout_id = (guint) 0;
	}
	self->priv->refresh_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) SLINGSHOT_BACKEND_APP_SYSTEM_MENU_REFRESH_TIMEOUT_SECONDS, ___lambda24__gsource_func, g_object_ref (self), g_object_unref);
}

static void
slingshot_backend_app_system_update_app_system (SlingshotBackendAppSystem* self)
{
	SlingshotBackendRelevancyService* _tmp0_;
	g_return_if_fail (self != NULL);
	g_debug ("AppSystem.vala:64: Updating Applications menu tree…");
	_tmp0_ = self->priv->rl_service;
	slingshot_backend_relevancy_service_refresh_popularity (_tmp0_);
	slingshot_backend_app_system_update_categories_index (self);
	g_signal_emit (self, slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL], 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
slingshot_backend_app_system_update_categories_index (SlingshotBackendAppSystem* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	SlingshotBackendCategory* _tmp10_ = NULL;
	SlingshotBackendCategory* _tmp11_;
	GeeArrayList* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	SlingshotBackendCategory* _tmp19_ = NULL;
	SlingshotBackendCategory* _tmp20_;
	GeeArrayList* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	SlingshotBackendCategory* _tmp24_ = NULL;
	SlingshotBackendCategory* _tmp25_;
	GeeArrayList* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	SlingshotBackendCategory* _tmp31_ = NULL;
	SlingshotBackendCategory* _tmp32_;
	GeeArrayList* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	SlingshotBackendCategory* _tmp37_ = NULL;
	SlingshotBackendCategory* _tmp38_;
	GeeArrayList* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	SlingshotBackendCategory* _tmp42_ = NULL;
	SlingshotBackendCategory* _tmp43_;
	GeeArrayList* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	SlingshotBackendCategory* _tmp47_ = NULL;
	SlingshotBackendCategory* _tmp48_;
	GeeArrayList* _tmp49_;
	gchar* _tmp50_;
	gchar** _tmp51_;
	SlingshotBackendCategory* _tmp52_ = NULL;
	SlingshotBackendCategory* _tmp53_;
	GeeArrayList* _tmp54_;
	gchar* _tmp55_;
	gchar** _tmp56_;
	SlingshotBackendCategory* _tmp57_ = NULL;
	SlingshotBackendCategory* _tmp58_;
	GeeArrayList* _tmp59_;
	gchar* _tmp60_;
	gchar** _tmp61_;
	SlingshotBackendCategory* _tmp62_ = NULL;
	SlingshotBackendCategory* _tmp63_;
	GeeArrayList* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar** _tmp67_;
	gchar* _tmp68_;
	gchar** _tmp69_;
	gchar* _tmp70_;
	gchar** _tmp71_;
	SlingshotBackendCategory* _tmp72_ = NULL;
	SlingshotBackendCategory* _tmp73_;
	SlingshotBackendCategory* other_category = NULL;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar** _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar** _tmp82_;
	SlingshotBackendCategory* _tmp83_ = NULL;
	GList* _tmp84_;
	SlingshotBackendCategory* _tmp102_;
	GeeArrayList* _tmp103_;
	GeeArrayList* _tmp104_;
	gint _tmp105_;
	gint _tmp106_;
	GeeHashMap* _tmp109_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->categories_cache;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->categories_cache;
	_tmp2_ = g_strdup ("Utility");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = g_strdup ("Accessibility");
	_tmp5_ = g_strdup ("System");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = g_strdup ("org.gnome.font-viewer.desktop");
	_tmp8_ = g_strdup ("org.gnome.FileRoller.desktop");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = slingshot_backend_category_new (_ ("Accessories"), FALSE);
	_tmp10_->included_categories = (_vala_array_free (_tmp10_->included_categories, _tmp10_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_->included_categories = _tmp3_;
	_tmp10_->included_categories_length1 = 1;
	_tmp10_->excluded_categories = (_vala_array_free (_tmp10_->excluded_categories, _tmp10_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_->excluded_categories = _tmp6_;
	_tmp10_->excluded_categories_length1 = 2;
	_tmp10_->excluded_applications = (_vala_array_free (_tmp10_->excluded_applications, _tmp10_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_->excluded_applications = _tmp9_;
	_tmp10_->excluded_applications_length1 = 2;
	_tmp11_ = _tmp10_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->categories_cache;
	_tmp13_ = g_strdup ("Accessibility");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = g_strdup ("Settings");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = g_strdup ("onboard.desktop");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = slingshot_backend_category_new (_ ("Universal Access"), FALSE);
	_tmp19_->included_categories = (_vala_array_free (_tmp19_->included_categories, _tmp19_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp19_->included_categories = _tmp14_;
	_tmp19_->included_categories_length1 = 1;
	_tmp19_->excluded_categories = (_vala_array_free (_tmp19_->excluded_categories, _tmp19_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp19_->excluded_categories = _tmp16_;
	_tmp19_->excluded_categories_length1 = 1;
	_tmp19_->excluded_applications = (_vala_array_free (_tmp19_->excluded_applications, _tmp19_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp19_->excluded_applications = _tmp18_;
	_tmp19_->excluded_applications_length1 = 1;
	_tmp20_ = _tmp19_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->categories_cache;
	_tmp22_ = g_strdup ("Development");
	_tmp23_ = g_new0 (gchar*, 1 + 1);
	_tmp23_[0] = _tmp22_;
	_tmp24_ = slingshot_backend_category_new (_ ("Programming"), FALSE);
	_tmp24_->included_categories = (_vala_array_free (_tmp24_->included_categories, _tmp24_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp24_->included_categories = _tmp23_;
	_tmp24_->included_categories_length1 = 1;
	_tmp25_ = _tmp24_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = self->priv->categories_cache;
	_tmp27_ = g_strdup ("Education");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = g_strdup ("Science");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = slingshot_backend_category_new (_ ("Education"), FALSE);
	_tmp31_->included_categories = (_vala_array_free (_tmp31_->included_categories, _tmp31_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp31_->included_categories = _tmp28_;
	_tmp31_->included_categories_length1 = 1;
	_tmp31_->excluded_categories = (_vala_array_free (_tmp31_->excluded_categories, _tmp31_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp31_->excluded_categories = _tmp30_;
	_tmp31_->excluded_categories_length1 = 1;
	_tmp32_ = _tmp31_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp32_);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = self->priv->categories_cache;
	_tmp34_ = g_strdup ("Science");
	_tmp35_ = g_strdup ("Education");
	_tmp36_ = g_new0 (gchar*, 2 + 1);
	_tmp36_[0] = _tmp34_;
	_tmp36_[1] = _tmp35_;
	_tmp37_ = slingshot_backend_category_new (_ ("Science"), FALSE);
	_tmp37_->included_categories = (_vala_array_free (_tmp37_->included_categories, _tmp37_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp37_->included_categories = _tmp36_;
	_tmp37_->included_categories_length1 = 2;
	_tmp38_ = _tmp37_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp38_);
	_g_object_unref0 (_tmp38_);
	_tmp39_ = self->priv->categories_cache;
	_tmp40_ = g_strdup ("Game");
	_tmp41_ = g_new0 (gchar*, 1 + 1);
	_tmp41_[0] = _tmp40_;
	_tmp42_ = slingshot_backend_category_new (_ ("Games"), FALSE);
	_tmp42_->included_categories = (_vala_array_free (_tmp42_->included_categories, _tmp42_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp42_->included_categories = _tmp41_;
	_tmp42_->included_categories_length1 = 1;
	_tmp43_ = _tmp42_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = self->priv->categories_cache;
	_tmp45_ = g_strdup ("Graphics");
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	_tmp47_ = slingshot_backend_category_new (_ ("Graphics"), FALSE);
	_tmp47_->included_categories = (_vala_array_free (_tmp47_->included_categories, _tmp47_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp47_->included_categories = _tmp46_;
	_tmp47_->included_categories_length1 = 1;
	_tmp48_ = _tmp47_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = self->priv->categories_cache;
	_tmp50_ = g_strdup ("Network");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = slingshot_backend_category_new (_ ("Internet"), FALSE);
	_tmp52_->included_categories = (_vala_array_free (_tmp52_->included_categories, _tmp52_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp52_->included_categories = _tmp51_;
	_tmp52_->included_categories_length1 = 1;
	_tmp53_ = _tmp52_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp53_);
	_g_object_unref0 (_tmp53_);
	_tmp54_ = self->priv->categories_cache;
	_tmp55_ = g_strdup ("AudioVideo");
	_tmp56_ = g_new0 (gchar*, 1 + 1);
	_tmp56_[0] = _tmp55_;
	_tmp57_ = slingshot_backend_category_new (_ ("Sound & Video"), FALSE);
	_tmp57_->included_categories = (_vala_array_free (_tmp57_->included_categories, _tmp57_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp57_->included_categories = _tmp56_;
	_tmp57_->included_categories_length1 = 1;
	_tmp58_ = _tmp57_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp58_);
	_g_object_unref0 (_tmp58_);
	_tmp59_ = self->priv->categories_cache;
	_tmp60_ = g_strdup ("Office");
	_tmp61_ = g_new0 (gchar*, 1 + 1);
	_tmp61_[0] = _tmp60_;
	_tmp62_ = slingshot_backend_category_new (_ ("Office"), FALSE);
	_tmp62_->included_categories = (_vala_array_free (_tmp62_->included_categories, _tmp62_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp62_->included_categories = _tmp61_;
	_tmp62_->included_categories_length1 = 1;
	_tmp63_ = _tmp62_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, _tmp63_);
	_g_object_unref0 (_tmp63_);
	_tmp64_ = self->priv->categories_cache;
	_tmp65_ = g_strdup ("System");
	_tmp66_ = g_strdup ("Administration");
	_tmp67_ = g_new0 (gchar*, 2 + 1);
	_tmp67_[0] = _tmp65_;
	_tmp67_[1] = _tmp66_;
	_tmp68_ = g_strdup ("Game");
	_tmp69_ = g_new0 (gchar*, 1 + 1);
	_tmp69_[0] = _tmp68_;
	_tmp70_ = g_strdup ("htop.desktop");
	_tmp71_ = g_new0 (gchar*, 1 + 1);
	_tmp71_[0] = _tmp70_;
	_tmp72_ = slingshot_backend_category_new (_ ("System Tools"), FALSE);
	_tmp72_->included_categories = (_vala_array_free (_tmp72_->included_categories, _tmp72_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp72_->included_categories = _tmp67_;
	_tmp72_->included_categories_length1 = 2;
	_tmp72_->excluded_categories = (_vala_array_free (_tmp72_->excluded_categories, _tmp72_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp72_->excluded_categories = _tmp69_;
	_tmp72_->excluded_categories_length1 = 1;
	_tmp72_->excluded_applications = (_vala_array_free (_tmp72_->excluded_applications, _tmp72_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp72_->excluded_applications = _tmp71_;
	_tmp72_->excluded_applications_length1 = 1;
	_tmp73_ = _tmp72_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, _tmp73_);
	_g_object_unref0 (_tmp73_);
	_tmp74_ = g_strdup ("Core");
	_tmp75_ = g_strdup ("Screensaver");
	_tmp76_ = g_strdup ("Settings");
	_tmp77_ = g_new0 (gchar*, 3 + 1);
	_tmp77_[0] = _tmp74_;
	_tmp77_[1] = _tmp75_;
	_tmp77_[2] = _tmp76_;
	_tmp78_ = g_strdup ("htop.desktop");
	_tmp79_ = g_strdup ("onboard.desktop");
	_tmp80_ = g_strdup ("org.gnome.FileRoller.desktop");
	_tmp81_ = g_strdup ("org.gnome.font-viewer.desktop");
	_tmp82_ = g_new0 (gchar*, 4 + 1);
	_tmp82_[0] = _tmp78_;
	_tmp82_[1] = _tmp79_;
	_tmp82_[2] = _tmp80_;
	_tmp82_[3] = _tmp81_;
	_tmp83_ = slingshot_backend_category_new (_ ("Other"), TRUE);
	_tmp83_->excluded_categories = (_vala_array_free (_tmp83_->excluded_categories, _tmp83_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp83_->excluded_categories = _tmp77_;
	_tmp83_->excluded_categories_length1 = 3;
	_tmp83_->excluded_applications = (_vala_array_free (_tmp83_->excluded_applications, _tmp83_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp83_->excluded_applications = _tmp82_;
	_tmp83_->excluded_applications_length1 = 4;
	other_category = _tmp83_;
	_tmp84_ = g_app_info_get_all ();
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp84_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GAppInfo* _tmp85_;
			GAppInfo* app = NULL;
			_tmp85_ = _g_object_ref0 ((GAppInfo*) app_it->data);
			app = _tmp85_;
			{
				GDesktopAppInfo* desktop_app = NULL;
				GAppInfo* _tmp86_;
				GDesktopAppInfo* _tmp87_;
				GDesktopAppInfo* _tmp88_;
				GDesktopAppInfo* _tmp89_;
				gboolean found_category = FALSE;
				_tmp86_ = app;
				desktop_app = G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp86_) : NULL;
				_tmp87_ = desktop_app;
				if (_tmp87_ == NULL) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp88_ = desktop_app;
				if (!g_app_info_should_show ((GAppInfo*) _tmp88_)) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp89_ = desktop_app;
				if (g_desktop_app_info_get_boolean (_tmp89_, "Terminal")) {
					_g_object_unref0 (app);
					continue;
				}
				found_category = FALSE;
				{
					GeeArrayList* _category_list = NULL;
					GeeArrayList* _tmp90_;
					gint _category_size = 0;
					GeeArrayList* _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					gint _category_index = 0;
					_tmp90_ = self->priv->categories_cache;
					_category_list = _tmp90_;
					_tmp91_ = _category_list;
					_tmp92_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp91_);
					_tmp93_ = _tmp92_;
					_category_size = _tmp93_;
					_category_index = -1;
					while (TRUE) {
						gint _tmp94_;
						gint _tmp95_;
						SlingshotBackendCategory* category = NULL;
						GeeArrayList* _tmp96_;
						gpointer _tmp97_;
						SlingshotBackendCategory* _tmp98_;
						GDesktopAppInfo* _tmp99_;
						_category_index = _category_index + 1;
						_tmp94_ = _category_index;
						_tmp95_ = _category_size;
						if (!(_tmp94_ < _tmp95_)) {
							break;
						}
						_tmp96_ = _category_list;
						_tmp97_ = gee_abstract_list_get ((GeeAbstractList*) _tmp96_, _category_index);
						category = (SlingshotBackendCategory*) _tmp97_;
						_tmp98_ = category;
						_tmp99_ = desktop_app;
						if (slingshot_backend_category_add_app_if_matches (_tmp98_, _tmp99_)) {
							found_category = TRUE;
						}
						_g_object_unref0 (category);
					}
				}
				if (!found_category) {
					SlingshotBackendCategory* _tmp100_;
					GDesktopAppInfo* _tmp101_;
					_tmp100_ = other_category;
					_tmp101_ = desktop_app;
					slingshot_backend_category_add_app_if_matches (_tmp100_, _tmp101_);
				}
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_list_free__g_object_unref0_ (app_collection), NULL));
	}
	_tmp102_ = other_category;
	_tmp103_ = slingshot_backend_category_get_apps (_tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp104_);
	_tmp106_ = _tmp105_;
	if (_tmp106_ > 0) {
		GeeArrayList* _tmp107_;
		SlingshotBackendCategory* _tmp108_;
		_tmp107_ = self->priv->categories_cache;
		_tmp108_ = other_category;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp107_, _tmp108_);
	}
	_tmp109_ = self->priv->_apps;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp109_);
	{
		GeeArrayList* _cat_list = NULL;
		GeeArrayList* _tmp110_;
		gint _cat_size = 0;
		GeeArrayList* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		gint _cat_index = 0;
		_tmp110_ = self->priv->categories_cache;
		_cat_list = _tmp110_;
		_tmp111_ = _cat_list;
		_tmp112_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp111_);
		_tmp113_ = _tmp112_;
		_cat_size = _tmp113_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp114_;
			gint _tmp115_;
			SlingshotBackendCategory* cat = NULL;
			GeeArrayList* _tmp116_;
			gpointer _tmp117_;
			SlingshotBackendCategory* _tmp118_;
			GeeArrayList* _tmp119_;
			GeeArrayList* _tmp120_;
			gint _tmp121_;
			gint _tmp122_;
			_cat_index = _cat_index + 1;
			_tmp114_ = _cat_index;
			_tmp115_ = _cat_size;
			if (!(_tmp114_ < _tmp115_)) {
				break;
			}
			_tmp116_ = _cat_list;
			_tmp117_ = gee_abstract_list_get ((GeeAbstractList*) _tmp116_, _cat_index);
			cat = (SlingshotBackendCategory*) _tmp117_;
			_tmp118_ = cat;
			_tmp119_ = slingshot_backend_category_get_apps (_tmp118_);
			_tmp120_ = _tmp119_;
			_tmp121_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp120_);
			_tmp122_ = _tmp121_;
			if (_tmp122_ > 0) {
				GeeHashMap* _tmp123_;
				SlingshotBackendCategory* _tmp124_;
				const gchar* _tmp125_;
				const gchar* _tmp126_;
				SlingshotBackendCategory* _tmp127_;
				GeeArrayList* _tmp128_;
				GeeArrayList* _tmp129_;
				_tmp123_ = self->priv->_apps;
				_tmp124_ = cat;
				_tmp125_ = slingshot_backend_category_get_name (_tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = cat;
				_tmp128_ = slingshot_backend_category_get_apps (_tmp127_);
				_tmp129_ = _tmp128_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp123_, _tmp126_, _tmp129_);
			}
			_g_object_unref0 (cat);
		}
	}
	_g_object_unref0 (other_category);
}

static void
slingshot_backend_app_system_update_popularity (SlingshotBackendAppSystem* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _category_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->_apps;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_category_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeArrayList* category = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			_tmp6_ = _category_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _category_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			category = (GeeArrayList*) _tmp8_;
			{
				GeeArrayList* _app_list = NULL;
				GeeArrayList* _tmp9_;
				gint _app_size = 0;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _app_index = 0;
				_tmp9_ = category;
				_app_list = _tmp9_;
				_tmp10_ = _app_list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_app_size = _tmp12_;
				_app_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					SlingshotBackendApp* app = NULL;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					SlingshotBackendApp* _tmp17_;
					SlingshotBackendRelevancyService* _tmp18_;
					SlingshotBackendApp* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					_app_index = _app_index + 1;
					_tmp13_ = _app_index;
					_tmp14_ = _app_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _app_list;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _app_index);
					app = (SlingshotBackendApp*) _tmp16_;
					_tmp17_ = app;
					_tmp18_ = self->priv->rl_service;
					_tmp19_ = app;
					_tmp20_ = slingshot_backend_app_get_desktop_id (_tmp19_);
					_tmp21_ = _tmp20_;
					slingshot_backend_app_set_popularity (_tmp17_, (gdouble) slingshot_backend_relevancy_service_get_app_popularity (_tmp18_, _tmp21_));
					_g_object_unref0 (app);
				}
			}
			_g_object_unref0 (category);
		}
		_g_object_unref0 (_category_it);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gint
_slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self)
{
	gint result;
	result = slingshot_backend_app_system_sort_apps_by_name ((SlingshotBackendApp*) a, (SlingshotBackendApp*) b);
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GSList*
slingshot_backend_app_system_get_apps_by_name (SlingshotBackendAppSystem* self)
{
	GSList* sorted_apps = NULL;
	gchar** sorted_apps_execs = NULL;
	gchar** _tmp0_;
	gint sorted_apps_execs_length1;
	gint _sorted_apps_execs_size_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	sorted_apps = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	sorted_apps_execs = _tmp0_;
	sorted_apps_execs_length1 = 0;
	_sorted_apps_execs_size_ = sorted_apps_execs_length1;
	{
		GeeIterator* _category_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->_apps;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_category_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GeeArrayList* category = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			_tmp7_ = _category_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _category_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			category = (GeeArrayList*) _tmp9_;
			{
				GeeArrayList* _app_list = NULL;
				GeeArrayList* _tmp10_;
				gint _app_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _app_index = 0;
				_tmp10_ = category;
				_app_list = _tmp10_;
				_tmp11_ = _app_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_app_size = _tmp13_;
				_app_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					SlingshotBackendApp* app = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					SlingshotBackendApp* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					_app_index = _app_index + 1;
					_tmp14_ = _app_index;
					_tmp15_ = _app_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _app_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _app_index);
					app = (SlingshotBackendApp*) _tmp17_;
					_tmp18_ = app;
					_tmp19_ = slingshot_backend_app_get_exec (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = sorted_apps_execs;
					_tmp21__length1 = sorted_apps_execs_length1;
					if (!_vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_)) {
						SlingshotBackendApp* _tmp22_;
						SlingshotBackendApp* _tmp23_;
						SlingshotBackendApp* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp22_ = app;
						_tmp23_ = _g_object_ref0 (_tmp22_);
						sorted_apps = g_slist_insert_sorted_with_data (sorted_apps, _tmp23_, _slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func, NULL);
						_tmp24_ = app;
						_tmp25_ = slingshot_backend_app_get_exec (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strdup (_tmp26_);
						_vala_array_add3 (&sorted_apps_execs, &sorted_apps_execs_length1, &_sorted_apps_execs_size_, _tmp27_);
					}
					_g_object_unref0 (app);
				}
			}
			_g_object_unref0 (category);
		}
		_g_object_unref0 (_category_it);
	}
	result = sorted_apps;
	sorted_apps_execs = (_vala_array_free (sorted_apps_execs, sorted_apps_execs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
slingshot_backend_app_system_sort_apps_by_name (SlingshotBackendApp* a,
                                                SlingshotBackendApp* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = slingshot_backend_app_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = slingshot_backend_app_get_name (b);
	_tmp3_ = _tmp2_;
	result = g_utf8_collate (_tmp1_, _tmp3_);
	return result;
}

SlingshotBackendAppSystem*
slingshot_backend_app_system_construct (GType object_type)
{
	SlingshotBackendAppSystem * self = NULL;
	self = (SlingshotBackendAppSystem*) g_object_new (object_type, NULL);
	return self;
}

SlingshotBackendAppSystem*
slingshot_backend_app_system_new (void)
{
	return slingshot_backend_app_system_construct (SLINGSHOT_BACKEND_TYPE_APP_SYSTEM);
}

GeeHashMap*
slingshot_backend_app_system_get_apps (SlingshotBackendAppSystem* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apps;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_system_set_apps (SlingshotBackendAppSystem* self,
                                       GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_system_get_apps (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_apps);
		self->priv->_apps = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY]);
	}
}

static void
_slingshot_backend_app_system_update_popularity_slingshot_backend_relevancy_service_update_complete (SlingshotBackendRelevancyService* _sender,
                                                                                                     gpointer self)
{
	slingshot_backend_app_system_update_popularity ((SlingshotBackendAppSystem*) self);
}

static void
_slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                                  gpointer self)
{
	slingshot_backend_app_system_queue_update_app_system ((SlingshotBackendAppSystem*) self);
}

static GObject *
slingshot_backend_app_system_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotBackendAppSystem * self;
	SlingshotBackendRelevancyService* _tmp0_;
	SlingshotBackendRelevancyService* _tmp1_;
	GAppInfoMonitor* _tmp2_;
	GAppInfoMonitor* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeArrayList* _tmp6_;
	parent_class = G_OBJECT_CLASS (slingshot_backend_app_system_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	_tmp0_ = slingshot_backend_relevancy_service_new ();
	_g_object_unref0 (self->priv->rl_service);
	self->priv->rl_service = _tmp0_;
	_tmp1_ = self->priv->rl_service;
	g_signal_connect_object (_tmp1_, "update-complete", (GCallback) _slingshot_backend_app_system_update_popularity_slingshot_backend_relevancy_service_update_complete, self, 0);
	_tmp2_ = g_app_info_monitor_get ();
	_g_object_unref0 (self->priv->app_monitor);
	self->priv->app_monitor = _tmp2_;
	_tmp3_ = self->priv->app_monitor;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed, self, 0);
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	slingshot_backend_app_system_set_apps (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = gee_array_list_new (SLINGSHOT_BACKEND_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->categories_cache);
	self->priv->categories_cache = _tmp6_;
	slingshot_backend_app_system_update_app_system (self);
	return obj;
}

static void
slingshot_backend_app_system_class_init (SlingshotBackendAppSystemClass * klass,
                                         gpointer klass_data)
{
	slingshot_backend_app_system_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendAppSystem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_app_system_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_app_system_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_backend_app_system_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_app_system_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY, slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY] = g_param_spec_object ("apps", "apps", "apps", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL] = g_signal_new ("changed", SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_backend_app_system_instance_init (SlingshotBackendAppSystem * self,
                                            gpointer klass)
{
	self->priv = slingshot_backend_app_system_get_instance_private (self);
	self->priv->_apps = NULL;
	self->priv->refresh_timeout_id = (guint) 0;
	self->priv->categories_cache = NULL;
}

static void
slingshot_backend_app_system_finalize (GObject * obj)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	_g_object_unref0 (self->priv->_apps);
	_g_object_unref0 (self->priv->categories_cache);
	_g_object_unref0 (self->priv->app_monitor);
	_g_object_unref0 (self->priv->rl_service);
	G_OBJECT_CLASS (slingshot_backend_app_system_parent_class)->finalize (obj);
}

static GType
slingshot_backend_app_system_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendAppSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_app_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendAppSystem), 0, (GInstanceInitFunc) slingshot_backend_app_system_instance_init, NULL };
	GType slingshot_backend_app_system_type_id;
	slingshot_backend_app_system_type_id = g_type_register_static (G_TYPE_OBJECT, "SlingshotBackendAppSystem", &g_define_type_info, 0);
	SlingshotBackendAppSystem_private_offset = g_type_add_instance_private (slingshot_backend_app_system_type_id, sizeof (SlingshotBackendAppSystemPrivate));
	return slingshot_backend_app_system_type_id;
}

GType
slingshot_backend_app_system_get_type (void)
{
	static volatile gsize slingshot_backend_app_system_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_app_system_type_id__once)) {
		GType slingshot_backend_app_system_type_id;
		slingshot_backend_app_system_type_id = slingshot_backend_app_system_get_type_once ();
		g_once_init_leave (&slingshot_backend_app_system_type_id__once, slingshot_backend_app_system_type_id);
	}
	return slingshot_backend_app_system_type_id__once;
}

static void
_vala_slingshot_backend_app_system_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_system_get_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_app_system_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY:
		slingshot_backend_app_system_set_apps (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

