/* Tagger.c generated by valac 0.56.18, the Vala compiler
 * generated from Tagger.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libxml/tree.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TAGGER (tagger_get_type ())
#define TAGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAGGER, Tagger))
#define TAGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAGGER, TaggerClass))
#define IS_TAGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAGGER))
#define IS_TAGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAGGER))
#define TAGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAGGER, TaggerClass))

typedef struct _Tagger Tagger;
typedef struct _TaggerClass TaggerClass;
typedef struct _TaggerPrivate TaggerPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TEXT_COMPLETION_ITEM (text_completion_item_get_type ())
#define TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItem))
#define TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))
#define IS_TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_COMPLETION_ITEM))
#define IS_TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_COMPLETION_ITEM))
#define TEXT_COMPLETION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))

typedef struct _TextCompletionItem TextCompletionItem;
typedef struct _TextCompletionItemClass TextCompletionItemClass;
#define _text_completion_item_unref0(var) ((var == NULL) ? NULL : (var = (text_completion_item_unref (var), NULL)))
typedef struct _Block52Data Block52Data;
#define _tagger_unref0(var) ((var == NULL) ? NULL : (var = (tagger_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block53Data Block53Data;
typedef struct _ParamSpecTagger ParamSpecTagger;

struct _Tagger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TaggerPrivate * priv;
};

struct _TaggerClass {
	GTypeClass parent_class;
	void (*finalize) (Tagger *self);
};

struct _TaggerPrivate {
	DrawArea* _da;
	GeeHashMap* _pre_tags;
	GeeHashMap* _tags;
	GtkSearchEntry* _entry;
};

struct _Block52Data {
	int _ref_count_;
	Tagger* self;
	GtkPopover* popover;
	GtkListBox* listbox;
};

struct _Block53Data {
	int _ref_count_;
	Tagger* self;
	GtkListBox* listbox;
};

struct _ParamSpecTagger {
	GParamSpec parent_instance;
};

static gint Tagger_private_offset;
static gpointer tagger_parent_class = NULL;

VALA_EXTERN gpointer tagger_ref (gpointer instance);
VALA_EXTERN void tagger_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_tagger (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_tagger (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_tagger (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_tagger (const GValue* value);
VALA_EXTERN GType tagger_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tagger, tagger_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN Tagger* tagger_new (DrawArea* da);
VALA_EXTERN Tagger* tagger_construct (GType object_type,
                          DrawArea* da);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN void tagger_preedit_load_tags (Tagger* self,
                               FormattedText* text);
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeHashMap* formatted_text_get_extras_for_tag (FormattedText* self,
                                               FormatTag tag);
VALA_EXTERN void tagger_postedit_load_tags (Tagger* self,
                                FormattedText* text);
VALA_EXTERN gpointer text_completion_item_ref (gpointer instance);
VALA_EXTERN void text_completion_item_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_completion_item (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_text_completion_item (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_text_completion_item (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_text_completion_item (const GValue* value);
VALA_EXTERN GType text_completion_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextCompletionItem, text_completion_item_unref)
VALA_EXTERN GList* tagger_get_matches (Tagger* self,
                           const gchar* partial);
VALA_EXTERN TextCompletionItem* text_completion_item_new (const gchar* label);
VALA_EXTERN TextCompletionItem* text_completion_item_construct (GType object_type,
                                                    const gchar* label);
VALA_EXTERN xmlNode* tagger_save (Tagger* self);
VALA_EXTERN void tagger_load (Tagger* self,
                  xmlNode* tags);
VALA_EXTERN void tagger_show_add_ui (Tagger* self);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN void canvas_text_get_char_pos (CanvasText* self,
                               gint pos,
                               gdouble* left,
                               gdouble* top,
                               gdouble* bottom,
                               gint* line);
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
static void __lambda146_ (Block52Data* _data52_,
                   GtkListBoxRow* row);
VALA_EXTERN void draw_area_add_tag (DrawArea* self,
                        const gchar* tag);
VALA_EXTERN void utils_hide_popover (GtkPopover* popover);
static void ___lambda146__gtk_list_box_row_activated (GtkListBox* _sender,
                                               GtkListBoxRow* row,
                                               gpointer self);
static void __lambda147_ (Block52Data* _data52_);
static void ___lambda147__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static void tagger_filter_tag_text (Tagger* self,
                             const gchar* str,
                             gint slen,
                             gint* pos);
static void _tagger_filter_tag_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                       const gchar* new_text,
                                                       gint new_text_length,
                                                       gint* position,
                                                       gpointer self);
static void __lambda148_ (Block52Data* _data52_);
static void tagger_populate_listbox (Tagger* self,
                              GtkListBox* listbox,
                              GList* tags);
static void _text_completion_item_unref0_ (gpointer var);
static inline void _g_list_free__text_completion_item_unref0_ (GList* self);
static void ___lambda148__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                    gpointer self);
VALA_EXTERN void utils_show_popover (GtkPopover* popover);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
static void __lambda149_ (Block53Data* _data53_,
                   GtkWidget* w);
static void ___lambda149__gtk_callback (GtkWidget* widget,
                                 gpointer self);
VALA_EXTERN GtkBox* text_completion_item_create_row (TextCompletionItem* self);
static void tagger_finalize (Tagger * obj);
static GType tagger_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
tagger_get_instance_private (Tagger* self)
{
	return G_STRUCT_MEMBER_P (self, Tagger_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Tagger*
tagger_construct (GType object_type,
                  DrawArea* da)
{
	Tagger* self = NULL;
	DrawArea* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (Tagger*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_tags);
	self->priv->_tags = _tmp1_;
	return self;
}

Tagger*
tagger_new (DrawArea* da)
{
	return tagger_construct (TYPE_TAGGER, da);
}

void
tagger_preedit_load_tags (Tagger* self,
                          FormattedText* text)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = formatted_text_get_extras_for_tag (text, FORMAT_TAG_TAG);
	_g_object_unref0 (self->priv->_pre_tags);
	self->priv->_pre_tags = _tmp0_;
}

void
tagger_postedit_load_tags (Tagger* self,
                           FormattedText* text)
{
	GeeHashMap* tags = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp1_;
	GeeMapIterator* _tmp2_;
	GeeMapIterator* pit = NULL;
	GeeHashMap* _tmp24_;
	GeeMapIterator* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = formatted_text_get_extras_for_tag (text, FORMAT_TAG_TAG);
	tags = _tmp0_;
	_tmp1_ = tags;
	_tmp2_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp1_);
	it = _tmp2_;
	while (TRUE) {
		GeeMapIterator* _tmp3_;
		GeeHashMap* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp3_ = it;
		if (!gee_map_iterator_next (_tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->_pre_tags;
		_tmp5_ = it;
		_tmp6_ = gee_map_iterator_get_key (_tmp5_);
		_tmp7_ = (gchar*) _tmp6_;
		_tmp8_ = !gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, _tmp7_, NULL);
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			gint _tmp9_ = 0;
			GeeHashMap* _tmp10_;
			GeeMapIterator* _tmp11_;
			gpointer _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			gint count = 0;
			GeeHashMap* _tmp20_;
			GeeMapIterator* _tmp21_;
			gpointer _tmp22_;
			gchar* _tmp23_;
			_tmp10_ = self->priv->_tags;
			_tmp11_ = it;
			_tmp12_ = gee_map_iterator_get_key (_tmp11_);
			_tmp13_ = (gchar*) _tmp12_;
			_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp13_);
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				GeeHashMap* _tmp15_;
				GeeMapIterator* _tmp16_;
				gpointer _tmp17_;
				gchar* _tmp18_;
				gpointer _tmp19_;
				_tmp15_ = self->priv->_tags;
				_tmp16_ = it;
				_tmp17_ = gee_map_iterator_get_key (_tmp16_);
				_tmp18_ = (gchar*) _tmp17_;
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp18_);
				_tmp9_ = (gint) ((gintptr) _tmp19_);
				_g_free0 (_tmp18_);
			} else {
				_tmp9_ = 0;
			}
			count = _tmp9_;
			_tmp20_ = self->priv->_tags;
			_tmp21_ = it;
			_tmp22_ = gee_map_iterator_get_key (_tmp21_);
			_tmp23_ = (gchar*) _tmp22_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp23_, (gpointer) ((gintptr) (count + 1)));
			_g_free0 (_tmp23_);
		}
	}
	_tmp24_ = self->priv->_pre_tags;
	_tmp25_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp24_);
	pit = _tmp25_;
	while (TRUE) {
		GeeMapIterator* _tmp26_;
		GeeHashMap* _tmp27_;
		GeeMapIterator* _tmp28_;
		gpointer _tmp29_;
		gchar* _tmp30_;
		gboolean _tmp31_;
		_tmp26_ = pit;
		if (!gee_map_iterator_next (_tmp26_)) {
			break;
		}
		_tmp27_ = self->priv->_tags;
		_tmp28_ = pit;
		_tmp29_ = gee_map_iterator_get_key (_tmp28_);
		_tmp30_ = (gchar*) _tmp29_;
		_tmp31_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp27_, _tmp30_);
		_g_free0 (_tmp30_);
		if (_tmp31_) {
			gint count = 0;
			GeeHashMap* _tmp32_;
			GeeMapIterator* _tmp33_;
			gpointer _tmp34_;
			gchar* _tmp35_;
			gpointer _tmp36_;
			gint _tmp37_;
			_tmp32_ = self->priv->_tags;
			_tmp33_ = pit;
			_tmp34_ = gee_map_iterator_get_key (_tmp33_);
			_tmp35_ = (gchar*) _tmp34_;
			_tmp36_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp35_);
			_tmp37_ = (gint) ((gintptr) _tmp36_);
			_g_free0 (_tmp35_);
			count = _tmp37_;
			if (count == 1) {
				GeeHashMap* _tmp38_;
				GeeMapIterator* _tmp39_;
				gpointer _tmp40_;
				gchar* _tmp41_;
				_tmp38_ = self->priv->_tags;
				_tmp39_ = pit;
				_tmp40_ = gee_map_iterator_get_key (_tmp39_);
				_tmp41_ = (gchar*) _tmp40_;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp38_, _tmp41_, NULL);
				_g_free0 (_tmp41_);
			} else {
				GeeHashMap* _tmp42_;
				GeeMapIterator* _tmp43_;
				gpointer _tmp44_;
				gchar* _tmp45_;
				_tmp42_ = self->priv->_tags;
				_tmp43_ = pit;
				_tmp44_ = gee_map_iterator_get_key (_tmp43_);
				_tmp45_ = (gchar*) _tmp44_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, _tmp45_, (gpointer) ((gintptr) (count - 1)));
				_g_free0 (_tmp45_);
			}
		}
	}
	_g_object_unref0 (pit);
	_g_object_unref0 (it);
	_g_object_unref0 (tags);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gpointer
_text_completion_item_ref0 (gpointer self)
{
	return self ? text_completion_item_ref (self) : NULL;
}

GList*
tagger_get_matches (Tagger* self,
                    const gchar* partial)
{
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GList* matches = NULL;
	GCompareFunc _tmp20_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (partial != NULL, NULL);
	_tmp0_ = self->priv->_tags;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	it = _tmp1_;
	matches = NULL;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		gchar* key = NULL;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp2_ = it;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = gee_map_iterator_get_key (_tmp3_);
		key = (gchar*) ((gchar*) _tmp4_);
		_tmp6_ = key;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = strlen (partial);
		_tmp10_ = _tmp9_;
		if (_tmp8_ >= _tmp10_) {
			const gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp11_ = key;
			_tmp12_ = strlen (partial);
			_tmp13_ = _tmp12_;
			_tmp14_ = string_substring (_tmp11_, (glong) 0, (glong) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp5_ = g_strcmp0 (_tmp15_, partial) == 0;
			_g_free0 (_tmp15_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			TextCompletionItem* item = NULL;
			const gchar* _tmp16_;
			TextCompletionItem* _tmp17_;
			TextCompletionItem* _tmp18_;
			TextCompletionItem* _tmp19_;
			_tmp16_ = key;
			_tmp17_ = text_completion_item_new (_tmp16_);
			item = _tmp17_;
			_tmp18_ = item;
			_tmp19_ = _text_completion_item_ref0 (_tmp18_);
			matches = g_list_append (matches, _tmp19_);
			_text_completion_item_unref0 (item);
		}
		_g_free0 (key);
	}
	_tmp20_ = ((GCompareFunc) g_strcmp0);
	matches = g_list_sort (matches, _tmp20_);
	result = matches;
	_g_object_unref0 (it);
	return result;
}

xmlNode*
tagger_save (Tagger* self)
{
	xmlNode* tags = NULL;
	xmlNode* _tmp0_;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp1_;
	GeeMapIterator* _tmp2_;
	xmlNode* _tmp16_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "tags");
	tags = _tmp0_;
	_tmp1_ = self->priv->_tags;
	_tmp2_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp1_);
	it = _tmp2_;
	while (TRUE) {
		GeeMapIterator* _tmp3_;
		xmlNode* tag = NULL;
		xmlNode* _tmp4_;
		xmlNode* _tmp5_;
		GeeMapIterator* _tmp6_;
		gpointer _tmp7_;
		gchar* _tmp8_;
		xmlNode* _tmp9_;
		GeeMapIterator* _tmp10_;
		gpointer _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		xmlNode* _tmp14_;
		xmlNode* _tmp15_;
		_tmp3_ = it;
		if (!gee_map_iterator_next (_tmp3_)) {
			break;
		}
		_tmp4_ = xmlNewNode (NULL, (xmlChar*) "tag");
		tag = _tmp4_;
		_tmp5_ = tag;
		_tmp6_ = it;
		_tmp7_ = gee_map_iterator_get_key (_tmp6_);
		_tmp8_ = (gchar*) ((gchar*) _tmp7_);
		xmlSetProp (_tmp5_, (xmlChar*) "value", (xmlChar*) _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = tag;
		_tmp10_ = it;
		_tmp11_ = gee_map_iterator_get_value (_tmp10_);
		_tmp12_ = g_strdup_printf ("%i", (gint) ((gint) ((gintptr) _tmp11_)));
		_tmp13_ = _tmp12_;
		xmlSetProp (_tmp9_, (xmlChar*) "count", (xmlChar*) _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = tags;
		_tmp15_ = tag;
		xmlAddChild (_tmp14_, _tmp15_);
	}
	_tmp16_ = tags;
	result = _tmp16_;
	_g_object_unref0 (it);
	return result;
}

void
tagger_load (Tagger* self,
             xmlNode* tags)
{
	g_return_if_fail (self != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = tags->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, "tag") == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gchar* n = NULL;
					xmlNode* _tmp9_;
					gchar* _tmp10_;
					gchar* c = NULL;
					xmlNode* _tmp11_;
					gchar* _tmp12_;
					gboolean _tmp13_ = FALSE;
					const gchar* _tmp14_;
					_tmp9_ = it;
					_tmp10_ = (gchar*) xmlGetProp (_tmp9_, (xmlChar*) "value");
					n = _tmp10_;
					_tmp11_ = it;
					_tmp12_ = (gchar*) xmlGetProp (_tmp11_, (xmlChar*) "count");
					c = _tmp12_;
					_tmp14_ = n;
					if (_tmp14_ != NULL) {
						const gchar* _tmp15_;
						_tmp15_ = c;
						_tmp13_ = _tmp15_ != NULL;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						GeeHashMap* _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						_tmp16_ = self->priv->_tags;
						_tmp17_ = n;
						_tmp18_ = c;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, (gpointer) ((gintptr) atoi (_tmp18_)));
					}
					_g_free0 (c);
					_g_free0 (n);
				}
			}
		}
	}
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		Tagger* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->listbox);
		_g_object_unref0 (_data52_->popover);
		_tagger_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static void
__lambda146_ (Block52Data* _data52_,
              GtkListBoxRow* row)
{
	Tagger* self;
	GtkLabel* label = NULL;
	GtkWidget* _tmp0_;
	GtkLabel* _tmp1_;
	gchar* value = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	DrawArea* _tmp4_;
	self = _data52_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_label_get_type (), GtkLabel));
	label = _tmp1_;
	_tmp2_ = gtk_label_get_text (label);
	_tmp3_ = g_strdup (_tmp2_);
	value = _tmp3_;
	_tmp4_ = self->priv->_da;
	draw_area_add_tag (_tmp4_, value);
	utils_hide_popover (_data52_->popover);
	_g_free0 (value);
	_g_object_unref0 (label);
}

static void
___lambda146__gtk_list_box_row_activated (GtkListBox* _sender,
                                          GtkListBoxRow* row,
                                          gpointer self)
{
	__lambda146_ (self, row);
}

static void
__lambda147_ (Block52Data* _data52_)
{
	Tagger* self;
	gchar* value = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	DrawArea* _tmp4_;
	self = _data52_->self;
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	value = _tmp3_;
	_tmp4_ = self->priv->_da;
	draw_area_add_tag (_tmp4_, value);
	utils_hide_popover (_data52_->popover);
	_g_free0 (value);
}

static void
___lambda147__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	__lambda147_ (self);
}

static void
_tagger_filter_tag_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                  const gchar* new_text,
                                                  gint new_text_length,
                                                  gint* position,
                                                  gpointer self)
{
	tagger_filter_tag_text ((Tagger*) self, new_text, new_text_length, position);
}

static void
_text_completion_item_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (text_completion_item_unref (var), NULL));
}

static inline void
_g_list_free__text_completion_item_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _text_completion_item_unref0_);
}

static void
__lambda148_ (Block52Data* _data52_)
{
	Tagger* self;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	self = _data52_->self;
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tagger_get_matches (self, _tmp2_);
	_tmp4_ = _tmp3_;
	tagger_populate_listbox (self, _data52_->listbox, _tmp4_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_list_free__text_completion_item_unref0_ (_tmp4_), NULL));
}

static void
___lambda148__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                               gpointer self)
{
	__lambda148_ (self);
}

void
tagger_show_add_ui (Tagger* self)
{
	Block52Data* _data52_;
	CanvasText* name = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	CanvasText* _tmp3_;
	CanvasText* _tmp4_;
	CanvasText* _tmp5_;
	CanvasText* _tmp6_;
	gdouble left = 0.0;
	gdouble top = 0.0;
	gdouble bottom = 0.0;
	gint line = 0;
	FormattedText* _tmp7_;
	FormattedText* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	gint int_left = 0;
	gint int_bottom = 0;
	GdkRectangle rect = {0};
	GdkRectangle _tmp15_ = {0};
	DrawArea* _tmp16_;
	GtkPopover* _tmp17_;
	GdkRectangle _tmp18_;
	GtkBox* box = NULL;
	GtkBox* _tmp19_;
	GtkLabel* lbl = NULL;
	GtkLabel* _tmp20_;
	GtkListBox* _tmp21_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp22_;
	GtkSearchEntry* _tmp23_;
	GtkSearchEntry* _tmp24_;
	GtkSearchEntry* _tmp25_;
	GtkSearchEntry* _tmp26_;
	GtkSearchEntry* _tmp27_;
	GtkSearchEntry* _tmp28_;
	GList* _tmp29_;
	GList* _tmp30_;
	g_return_if_fail (self != NULL);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = tagger_ref (self);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = node_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	name = _tmp6_;
	_tmp7_ = canvas_text_get_text (name);
	_tmp8_ = _tmp7_;
	_tmp9_ = formatted_text_get_text (_tmp8_);
	_tmp10_ = _tmp9_;
	canvas_text_get_char_pos (name, g_utf8_strlen (_tmp10_, (gssize) -1), &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	left = _tmp11_;
	top = _tmp12_;
	bottom = _tmp13_;
	line = _tmp14_;
	int_left = (gint) left;
	int_bottom = (gint) bottom;
	_tmp15_.x = int_left;
	_tmp15_.y = int_bottom;
	_tmp15_.width = 1;
	_tmp15_.height = 1;
	rect = _tmp15_;
	_tmp16_ = self->priv->_da;
	_tmp17_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp16_);
	g_object_ref_sink (_tmp17_);
	_data52_->popover = _tmp17_;
	_tmp18_ = rect;
	g_object_set (_data52_->popover, "pointing-to", &_tmp18_, NULL);
	gtk_popover_set_position (_data52_->popover, GTK_POS_BOTTOM);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp19_);
	box = _tmp19_;
	_tmp20_ = (GtkLabel*) gtk_label_new (_ ("Add Tag"));
	g_object_ref_sink (_tmp20_);
	lbl = _tmp20_;
	_tmp21_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp21_);
	_data52_->listbox = _tmp21_;
	gtk_list_box_set_selection_mode (_data52_->listbox, GTK_SELECTION_BROWSE);
	gtk_widget_set_halign ((GtkWidget*) _data52_->listbox, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _data52_->listbox, GTK_ALIGN_START);
	g_signal_connect_data (_data52_->listbox, "row-activated", (GCallback) ___lambda146__gtk_list_box_row_activated, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	_tmp22_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp22_);
	scroll = _tmp22_;
	g_object_set (scroll, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_EXTERNAL, NULL);
	gtk_scrolled_window_set_min_content_height (scroll, 200);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _data52_->listbox);
	_tmp23_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = _tmp23_;
	_tmp24_ = self->priv->_entry;
	gtk_entry_set_max_width_chars ((GtkEntry*) _tmp24_, 30);
	_tmp25_ = self->priv->_entry;
	g_signal_connect_data ((GtkEntry*) _tmp25_, "activate", (GCallback) ___lambda147__gtk_entry_activate, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	_tmp26_ = self->priv->_entry;
	g_signal_connect ((GtkEditable*) _tmp26_, "insert-text", (GCallback) _tagger_filter_tag_text_gtk_editable_insert_text, self);
	_tmp27_ = self->priv->_entry;
	g_signal_connect_data (_tmp27_, "search-changed", (GCallback) ___lambda148__gtk_search_entry_search_changed, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, TRUE, (guint) 5);
	_tmp28_ = self->priv->_entry;
	gtk_box_pack_start (box, (GtkWidget*) _tmp28_, FALSE, TRUE, (guint) 5);
	gtk_box_pack_start (box, (GtkWidget*) scroll, TRUE, TRUE, (guint) 5);
	gtk_widget_show_all ((GtkWidget*) box);
	gtk_container_add ((GtkContainer*) _data52_->popover, (GtkWidget*) box);
	utils_show_popover (_data52_->popover);
	_tmp29_ = tagger_get_matches (self, "");
	_tmp30_ = _tmp29_;
	tagger_populate_listbox (self, _data52_->listbox, _tmp30_);
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (_g_list_free__text_completion_item_unref0_ (_tmp30_), NULL));
	_g_object_unref0 (scroll);
	_g_object_unref0 (lbl);
	_g_object_unref0 (box);
	_g_object_unref0 (name);
	block52_data_unref (_data52_);
	_data52_ = NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
tagger_filter_tag_text (Tagger* self,
                        const gchar* str,
                        gint slen,
                        gint* pos)
{
	gchar* filtered = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = string_replace (str, " ", "");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "\t", "");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "@", "");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	filtered = _tmp5_;
	_tmp6_ = filtered;
	if (g_strcmp0 (str, _tmp6_) != 0) {
		void* void_entry = NULL;
		GtkSearchEntry* _tmp7_;
		void* _tmp8_;
		GtkSearchEntry* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		void* _tmp14_;
		GtkSearchEntry* _tmp15_;
		_tmp7_ = self->priv->_entry;
		void_entry = (void*) _tmp7_;
		_tmp8_ = void_entry;
		g_signal_handlers_block_by_func (_tmp8_, (void*) tagger_filter_tag_text, self);
		_tmp9_ = self->priv->_entry;
		_tmp10_ = filtered;
		_tmp11_ = filtered;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		g_signal_emit_by_name ((GtkEditable*) _tmp9_, "insert-text", _tmp10_, _tmp13_, pos);
		_tmp14_ = void_entry;
		g_signal_handlers_unblock_by_func (_tmp14_, (void*) tagger_filter_tag_text, self);
		_tmp15_ = self->priv->_entry;
		g_signal_stop_emission_by_name (_tmp15_, "insert_text");
	}
	_g_free0 (filtered);
}

static Block53Data*
block53_data_ref (Block53Data* _data53_)
{
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}

static void
block53_data_unref (void * _userdata_)
{
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		Tagger* self;
		self = _data53_->self;
		_g_object_unref0 (_data53_->listbox);
		_tagger_unref0 (self);
		g_slice_free (Block53Data, _data53_);
	}
}

static void
__lambda149_ (Block53Data* _data53_,
              GtkWidget* w)
{
	Tagger* self;
	self = _data53_->self;
	g_return_if_fail (w != NULL);
	gtk_container_remove ((GtkContainer*) _data53_->listbox, w);
}

static void
___lambda149__gtk_callback (GtkWidget* widget,
                            gpointer self)
{
	__lambda149_ (self, widget);
}

static void
tagger_populate_listbox (Tagger* self,
                         GtkListBox* listbox,
                         GList* tags)
{
	Block53Data* _data53_;
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	_data53_ = g_slice_new0 (Block53Data);
	_data53_->_ref_count_ = 1;
	_data53_->self = tagger_ref (self);
	_tmp0_ = _g_object_ref0 (listbox);
	_g_object_unref0 (_data53_->listbox);
	_data53_->listbox = _tmp0_;
	gtk_container_foreach ((GtkContainer*) _data53_->listbox, ___lambda149__gtk_callback, _data53_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = tags;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			TextCompletionItem* _tmp1_;
			TextCompletionItem* item = NULL;
			_tmp1_ = _text_completion_item_ref0 ((TextCompletionItem*) item_it->data);
			item = _tmp1_;
			{
				GtkBox* box = NULL;
				TextCompletionItem* _tmp2_;
				GtkBox* _tmp3_;
				GtkBox* _tmp4_;
				_tmp2_ = item;
				_tmp3_ = text_completion_item_create_row (_tmp2_);
				box = _tmp3_;
				_tmp4_ = box;
				gtk_container_add ((GtkContainer*) _data53_->listbox, (GtkWidget*) _tmp4_);
				_g_object_unref0 (box);
				_text_completion_item_unref0 (item);
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) _data53_->listbox);
	block53_data_unref (_data53_);
	_data53_ = NULL;
}

static void
value_tagger_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_tagger_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tagger_unref (value->data[0].v_pointer);
	}
}

static void
value_tagger_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tagger_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_tagger_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_tagger_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Tagger * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tagger_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_tagger_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Tagger ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tagger_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_tagger (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecTagger* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TAGGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_tagger (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAGGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_tagger (GValue* value,
                  gpointer v_object)
{
	Tagger * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tagger_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tagger_unref (old);
	}
}

void
value_take_tagger (GValue* value,
                   gpointer v_object)
{
	Tagger * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tagger_unref (old);
	}
}

static void
tagger_class_init (TaggerClass * klass,
                   gpointer klass_data)
{
	tagger_parent_class = g_type_class_peek_parent (klass);
	((TaggerClass *) klass)->finalize = tagger_finalize;
	g_type_class_adjust_private_offset (klass, &Tagger_private_offset);
}

static void
tagger_instance_init (Tagger * self,
                      gpointer klass)
{
	self->priv = tagger_get_instance_private (self);
	self->ref_count = 1;
}

static void
tagger_finalize (Tagger * obj)
{
	Tagger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAGGER, Tagger);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_pre_tags);
	_g_object_unref0 (self->priv->_tags);
	_g_object_unref0 (self->priv->_entry);
}

static GType
tagger_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_tagger_init, value_tagger_free_value, value_tagger_copy_value, value_tagger_peek_pointer, "p", value_tagger_collect_value, "p", value_tagger_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TaggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tagger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tagger), 0, (GInstanceInitFunc) tagger_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tagger_type_id;
	tagger_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Tagger", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Tagger_private_offset = g_type_add_instance_private (tagger_type_id, sizeof (TaggerPrivate));
	return tagger_type_id;
}

GType
tagger_get_type (void)
{
	static volatile gsize tagger_type_id__once = 0;
	if (g_once_init_enter (&tagger_type_id__once)) {
		GType tagger_type_id;
		tagger_type_id = tagger_get_type_once ();
		g_once_init_leave (&tagger_type_id__once, tagger_type_id);
	}
	return tagger_type_id__once;
}

gpointer
tagger_ref (gpointer instance)
{
	Tagger * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tagger_unref (gpointer instance)
{
	Tagger * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TAGGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

