/* StickerInspector.c generated by valac 0.56.18, the Vala compiler
 * generated from StickerInspector.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <handy.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_STICKER_INSPECTOR (sticker_inspector_get_type ())
#define STICKER_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STICKER_INSPECTOR, StickerInspector))
#define STICKER_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STICKER_INSPECTOR, StickerInspectorClass))
#define IS_STICKER_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STICKER_INSPECTOR))
#define IS_STICKER_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STICKER_INSPECTOR))
#define STICKER_INSPECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STICKER_INSPECTOR, StickerInspectorClass))

typedef struct _StickerInspector StickerInspector;
typedef struct _StickerInspectorClass StickerInspectorClass;
typedef struct _StickerInspectorPrivate StickerInspectorPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_STICKER_SET (sticker_set_get_type ())
#define STICKER_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STICKER_SET, StickerSet))
#define STICKER_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STICKER_SET, StickerSetClass))
#define IS_STICKER_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STICKER_SET))
#define IS_STICKER_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STICKER_SET))
#define STICKER_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STICKER_SET, StickerSetClass))

typedef struct _StickerSet StickerSet;
typedef struct _StickerSetClass StickerSetClass;
enum  {
	STICKER_INSPECTOR_0_PROPERTY,
	STICKER_INSPECTOR_NUM_PROPERTIES
};
static GParamSpec* sticker_inspector_properties[STICKER_INSPECTOR_NUM_PROPERTIES];
typedef enum  {
	DRAG_TYPES_URI,
	DRAG_TYPES_STICKER
} DragTypes;

#define TYPE_DRAG_TYPES (drag_types_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sticker_set_unref0(var) ((var == NULL) ? NULL : (var = (sticker_set_unref (var), NULL)))
typedef struct _Block37Data Block37Data;

#define STICKER_SET_TYPE_STICKER_INFO (sticker_set_sticker_info_get_type ())
#define STICKER_SET_STICKER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STICKER_SET_TYPE_STICKER_INFO, StickerSetStickerInfo))
#define STICKER_SET_STICKER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STICKER_SET_TYPE_STICKER_INFO, StickerSetStickerInfoClass))
#define STICKER_SET_IS_STICKER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STICKER_SET_TYPE_STICKER_INFO))
#define STICKER_SET_IS_STICKER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STICKER_SET_TYPE_STICKER_INFO))
#define STICKER_SET_STICKER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STICKER_SET_TYPE_STICKER_INFO, StickerSetStickerInfoClass))

typedef struct _StickerSetStickerInfo StickerSetStickerInfo;
typedef struct _StickerSetStickerInfoClass StickerSetStickerInfoClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block38Data Block38Data;
typedef struct _Block39Data Block39Data;
typedef struct _Block40Data Block40Data;
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
typedef struct _Block41Data Block41Data;
typedef struct _Block42Data Block42Data;

struct _StickerInspector {
	GtkBox parent_instance;
	StickerInspectorPrivate * priv;
};

struct _StickerInspectorClass {
	GtkBoxClass parent_class;
};

struct _StickerInspectorPrivate {
	gchar* favorites;
	MainWindow* _win;
	DrawArea* _da;
	GSettings* _settings;
	GtkSearchEntry* _search;
	GtkStack* _stack;
	GtkFlowBox* _favorites;
	GtkFlowBox* _matched_box;
	GtkImage* _dragged_sticker;
	gdouble _motion_x;
	gdouble _motion_y;
	GtkMenu* _favorite_menu;
	GtkMenu* _builtin_menu;
	GtkMenu* _custom_menu;
	GtkFlowBox* _clicked_category;
	StickerSet* _sticker_set;
	gchar* _clicked_sticker;
};

struct _Block37Data {
	int _ref_count_;
	StickerInspector* self;
	GtkMenuItem* bi_favorite;
	GtkMenuItem* cu_favorite;
};

struct _Block38Data {
	int _ref_count_;
	StickerInspector* self;
	GtkFlowBox* fbox;
	gchar* category;
};

struct _Block39Data {
	int _ref_count_;
	StickerInspector* self;
	gboolean exists;
	gchar* name;
};

struct _Block40Data {
	int _ref_count_;
	StickerInspector* self;
	xmlNode* root;
};

struct _Block41Data {
	int _ref_count_;
	StickerInspector* self;
	gchar* search_text;
};

struct _Block42Data {
	int _ref_count_;
	StickerInspector* self;
	GtkFlowBox* fbox;
	gchar* category;
};

static gint StickerInspector_private_offset;
static gpointer sticker_inspector_parent_class = NULL;

VALA_EXTERN GType sticker_inspector_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StickerInspector, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gpointer sticker_set_ref (gpointer instance);
VALA_EXTERN void sticker_set_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_sticker_set (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_sticker_set (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_sticker_set (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_sticker_set (const GValue* value);
VALA_EXTERN GType sticker_set_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StickerSet, sticker_set_unref)
VALA_EXTERN GType drag_types_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StickerInspector* sticker_inspector_new (MainWindow* win,
                                         GSettings* settings);
VALA_EXTERN StickerInspector* sticker_inspector_construct (GType object_type,
                                               MainWindow* win,
                                               GSettings* settings);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static void sticker_inspector_make_unfavorite (StickerInspector* self);
static void _sticker_inspector_make_unfavorite_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                gpointer self);
static void sticker_inspector_make_favorite (StickerInspector* self);
static void _sticker_inspector_make_favorite_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void __lambda73_ (Block37Data* _data37_);
static gboolean sticker_inspector_is_favorite (StickerInspector* self,
                                        const gchar* name);
static void ___lambda73__gtk_widget_show (GtkWidget* _sender,
                                   gpointer self);
static void sticker_inspector_handle_remove (StickerInspector* self);
static void _sticker_inspector_handle_remove_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void __lambda76_ (Block37Data* _data37_);
static void ___lambda76__gtk_widget_show (GtkWidget* _sender,
                                   gpointer self);
static void sticker_inspector_do_search (StickerInspector* self);
static void _sticker_inspector_do_search_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                   gpointer self);
static GtkFlowBox* sticker_inspector_create_icon_box (StickerInspector* self,
                                               const gchar* category);
VALA_EXTERN StickerSet* sticker_set_new (void);
VALA_EXTERN StickerSet* sticker_set_construct (GType object_type);
static GtkFlowBox* sticker_inspector_create_category (StickerInspector* self,
                                               GtkBox* box,
                                               const gchar* name);
static void sticker_inspector_load_favorites (StickerInspector* self);
static void sticker_inspector_create_from_sticker_set (StickerInspector* self,
                                                GtkBox* box);
static void __lambda81_ (StickerInspector* self);
VALA_EXTERN void utils_open_url (const gchar* url);
VALA_EXTERN gchar* sticker_set_sticker_dir (StickerSet* self);
static void ___lambda81__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN GArray* sticker_set_get_categories (StickerSet* self);
VALA_EXTERN gpointer sticker_set_sticker_info_ref (gpointer instance);
VALA_EXTERN void sticker_set_sticker_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* sticker_set_param_spec_sticker_info (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void sticker_set_value_set_sticker_info (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void sticker_set_value_take_sticker_info (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer sticker_set_value_get_sticker_info (const GValue* value);
VALA_EXTERN GType sticker_set_sticker_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StickerSetStickerInfo, sticker_set_sticker_info_unref)
VALA_EXTERN GArray* sticker_set_get_category_icons (StickerSet* self,
                                        const gchar* category);
static void sticker_inspector_create_image (StickerInspector* self,
                                     GtkFlowBox* box,
                                     const gchar* name,
                                     const gchar* tooltip,
                                     gboolean add);
VALA_EXTERN const gchar* sticker_set_sticker_info_get_resource (StickerSetStickerInfo* self);
VALA_EXTERN const gchar* sticker_set_sticker_info_get_tooltip (StickerSetStickerInfo* self);
static void sticker_inspector_create_import (StickerInspector* self,
                                      GtkFlowBox* box);
VALA_EXTERN gchar* utils_make_title (const gchar* str);
VALA_EXTERN GdkPixbuf* sticker_set_make_pixbuf (const gchar* resource,
                                    gint width);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void sticker_inspector_on_drag_begin (StickerInspector* self,
                                      GtkWidget* widget,
                                      GdkDragContext* context);
static void _sticker_inspector_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gpointer self);
static void sticker_inspector_on_drag_data_get (StickerInspector* self,
                                         GtkWidget* widget,
                                         GdkDragContext* context,
                                         GtkSelectionData* selection_data,
                                         guint target_type,
                                         guint time);
static void _sticker_inspector_on_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                   GdkDragContext* context,
                                                                   GtkSelectionData* selection_data,
                                                                   guint info,
                                                                   guint time_,
                                                                   gpointer self);
static gboolean __lambda78_ (StickerInspector* self,
                      GdkEventMotion* e);
static gboolean ___lambda78__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                      GdkEventMotion* event,
                                                      gpointer self);
static gboolean __lambda79_ (Block38Data* _data38_,
                      GdkEventButton* e);
static void sticker_inspector_import_stickers (StickerInspector* self,
                                        GtkFlowBox* fbox,
                                        const gchar* category);
VALA_EXTERN void utils_popup_menu (GtkMenu* menu,
                       GdkEvent* e);
static gboolean sticker_inspector_is_custom (StickerInspector* self,
                                      const gchar* name);
static gboolean ___lambda79__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void sticker_inspector_handle_favorite (StickerInspector* self);
VALA_EXTERN gboolean sticker_set_remove_sticker (StickerSet* self,
                                     const gchar* name);
static void ___lambda75_ (StickerInspector* self,
                   GtkWidget* w);
static void ____lambda75__gfunc (gconstpointer data,
                          gpointer self);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static void __lambda74_ (Block39Data* _data39_,
                  GtkWidget* w);
static void ___lambda74__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN gboolean sticker_set_get_icon_info (StickerSet* self,
                                    const gchar* resource,
                                    gchar** tooltip);
static void sticker_inspector_save_favorites (StickerInspector* self);
static void __lambda71_ (StickerInspector* self,
                  GtkWidget* w);
static void ___lambda71__gfunc (gconstpointer data,
                         gpointer self);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
static void __lambda72_ (Block40Data* _data40_,
                  GtkWidget* w);
static void ___lambda72__gfunc (gconstpointer data,
                         gpointer self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static gboolean ___lambda77_ (Block41Data* _data41_,
                       GtkFlowBoxChild* item);
static gboolean ____lambda77__gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                 gpointer self);
VALA_EXTERN void sticker_inspector_grab_first (StickerInspector* self);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static void ___lambda80_ (Block42Data* _data42_,
                   const gchar* sticker);
VALA_EXTERN gboolean sticker_set_load_sticker (StickerSet* self,
                                   const gchar* category,
                                   const gchar* name,
                                   const gchar* sticker_file,
                                   gboolean import);
static void ____lambda80__gfunc (gconstpointer data,
                          gpointer self);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void sticker_inspector_finalize (GObject * obj);
static GType sticker_inspector_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const GtkTargetEntry STICKER_INSPECTOR_DRAG_TARGETS[1] = {{"STRING", (guint) GTK_TARGET_SAME_APP, (guint) DRAG_TYPES_STICKER}};

static inline gpointer
sticker_inspector_get_instance_private (StickerInspector* self)
{
	return G_STRUCT_MEMBER_P (self, StickerInspector_private_offset);
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		StickerInspector* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->cu_favorite);
		_g_object_unref0 (_data37_->bi_favorite);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_sticker_inspector_make_unfavorite_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                           gpointer self)
{
	sticker_inspector_make_unfavorite ((StickerInspector*) self);
}

static void
_sticker_inspector_make_favorite_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	sticker_inspector_make_favorite ((StickerInspector*) self);
}

static void
__lambda73_ (Block37Data* _data37_)
{
	StickerInspector* self;
	const gchar* _tmp0_;
	self = _data37_->self;
	_tmp0_ = self->priv->_clicked_sticker;
	gtk_widget_set_sensitive ((GtkWidget*) _data37_->bi_favorite, !sticker_inspector_is_favorite (self, _tmp0_));
}

static void
___lambda73__gtk_widget_show (GtkWidget* _sender,
                              gpointer self)
{
	__lambda73_ (self);
}

static void
_sticker_inspector_handle_remove_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	sticker_inspector_handle_remove ((StickerInspector*) self);
}

static void
__lambda76_ (Block37Data* _data37_)
{
	StickerInspector* self;
	const gchar* _tmp0_;
	self = _data37_->self;
	_tmp0_ = self->priv->_clicked_sticker;
	gtk_widget_set_sensitive ((GtkWidget*) _data37_->cu_favorite, !sticker_inspector_is_favorite (self, _tmp0_));
}

static void
___lambda76__gtk_widget_show (GtkWidget* _sender,
                              gpointer self)
{
	__lambda76_ (self);
}

static void
_sticker_inspector_do_search_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                              gpointer self)
{
	sticker_inspector_do_search ((StickerInspector*) self);
}

static void
__lambda81_ (StickerInspector* self)
{
	StickerSet* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = self->priv->_sticker_set;
	_tmp1_ = sticker_set_sticker_dir (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("file://", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	utils_open_url (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

static void
___lambda81__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda81_ ((StickerInspector*) self);
}

StickerInspector*
sticker_inspector_construct (GType object_type,
                             MainWindow* win,
                             GSettings* settings)
{
	StickerInspector * self = NULL;
	Block37Data* _data37_;
	MainWindow* _tmp0_;
	GSettings* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* _tmp3_;
	GtkMenu* _tmp4_;
	GtkMenuItem* unfavorite = NULL;
	GtkMenuItem* _tmp5_;
	GtkMenu* _tmp6_;
	GtkMenu* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenu* _tmp9_;
	GtkMenu* _tmp10_;
	GtkMenu* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* cu_remove = NULL;
	GtkMenuItem* _tmp13_;
	GtkMenu* _tmp14_;
	GtkMenu* _tmp15_;
	GtkSeparatorMenuItem* _tmp16_;
	GtkSeparatorMenuItem* _tmp17_;
	GtkMenu* _tmp18_;
	GtkMenu* _tmp19_;
	GtkMenu* _tmp20_;
	GtkLabel* lbl = NULL;
	GtkLabel* _tmp21_;
	GtkSearchEntry* _tmp22_;
	GtkSearchEntry* _tmp23_;
	GtkSearchEntry* _tmp24_;
	GtkStack* _tmp25_;
	GtkBox* box = NULL;
	GtkBox* _tmp26_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp27_;
	GtkViewport* vp = NULL;
	GtkViewport* _tmp28_;
	GtkFlowBox* _tmp29_;
	GtkBox* mbox = NULL;
	GtkBox* _tmp30_;
	GtkScrolledWindow* msw = NULL;
	GtkScrolledWindow* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkFlowBox* _tmp33_;
	GtkStack* _tmp34_;
	GtkStack* _tmp35_;
	StickerSet* _tmp36_;
	GtkFlowBox* _tmp37_;
	GtkButton* show = NULL;
	GtkButton* _tmp38_;
	GtkSearchEntry* _tmp39_;
	GtkStack* _tmp40_;
	g_return_val_if_fail (win != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	self = (StickerInspector*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 10, NULL);
	_data37_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (self->priv->_win);
	self->priv->_win = _tmp0_;
	_tmp1_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	_tmp2_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_favorite_menu);
	self->priv->_favorite_menu = _tmp2_;
	_tmp3_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_builtin_menu);
	self->priv->_builtin_menu = _tmp3_;
	_tmp4_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_custom_menu);
	self->priv->_custom_menu = _tmp4_;
	_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Remove From Favorites"));
	g_object_ref_sink (_tmp5_);
	unfavorite = _tmp5_;
	g_signal_connect_object (unfavorite, "activate", (GCallback) _sticker_inspector_make_unfavorite_gtk_menu_item_activate, self, 0);
	_tmp6_ = self->priv->_favorite_menu;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) unfavorite);
	_tmp7_ = self->priv->_favorite_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp7_);
	_tmp8_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Add To Favorites"));
	g_object_ref_sink (_tmp8_);
	_data37_->bi_favorite = _tmp8_;
	g_signal_connect_object (_data37_->bi_favorite, "activate", (GCallback) _sticker_inspector_make_favorite_gtk_menu_item_activate, self, 0);
	_tmp9_ = self->priv->_builtin_menu;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _data37_->bi_favorite);
	_tmp10_ = self->priv->_builtin_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->_builtin_menu;
	g_signal_connect_data ((GtkWidget*) _tmp11_, "show", (GCallback) ___lambda73__gtk_widget_show, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	_tmp12_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Add To Favorites"));
	g_object_ref_sink (_tmp12_);
	_data37_->cu_favorite = _tmp12_;
	g_signal_connect_object (_data37_->cu_favorite, "activate", (GCallback) _sticker_inspector_make_favorite_gtk_menu_item_activate, self, 0);
	_tmp13_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Remove Custom Sticker"));
	g_object_ref_sink (_tmp13_);
	cu_remove = _tmp13_;
	g_signal_connect_object (cu_remove, "activate", (GCallback) _sticker_inspector_handle_remove_gtk_menu_item_activate, self, 0);
	_tmp14_ = self->priv->_custom_menu;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _data37_->cu_favorite);
	_tmp15_ = self->priv->_custom_menu;
	_tmp16_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->_custom_menu;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) cu_remove);
	_tmp19_ = self->priv->_custom_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->_custom_menu;
	g_signal_connect_data ((GtkWidget*) _tmp20_, "show", (GCallback) ___lambda76__gtk_widget_show, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("Drag and drop sticker onto a node or anywhere else in the map to add a" \
" sticker."));
	g_object_ref_sink (_tmp21_);
	lbl = _tmp21_;
	g_object_set (lbl, "wrap", TRUE, NULL);
	g_object_set (lbl, "wrap-mode", PANGO_WRAP_WORD, NULL);
	_tmp22_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->_search);
	self->priv->_search = _tmp22_;
	_tmp23_ = self->priv->_search;
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp23_, _ ("Search Stickers"));
	_tmp24_ = self->priv->_search;
	g_signal_connect_object (_tmp24_, "search-changed", (GCallback) _sticker_inspector_do_search_gtk_search_entry_search_changed, self, 0);
	_tmp25_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->_stack);
	self->priv->_stack = _tmp25_;
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp26_);
	box = _tmp26_;
	_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp27_);
	sw = _tmp27_;
	_tmp28_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp28_);
	vp = _tmp28_;
	gtk_widget_set_size_request ((GtkWidget*) vp, 200, 600);
	gtk_container_add ((GtkContainer*) vp, (GtkWidget*) box);
	gtk_container_add ((GtkContainer*) sw, (GtkWidget*) vp);
	_tmp29_ = sticker_inspector_create_icon_box (self, "");
	_g_object_unref0 (self->priv->_matched_box);
	self->priv->_matched_box = _tmp29_;
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp30_);
	mbox = _tmp30_;
	_tmp31_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp31_);
	msw = _tmp31_;
	g_object_set ((GtkWidget*) msw, "expand", FALSE, NULL);
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) msw);
	gtk_style_context_add_class (_tmp32_, GTK_STYLE_CLASS_VIEW);
	gtk_container_add ((GtkContainer*) msw, (GtkWidget*) mbox);
	_tmp33_ = self->priv->_matched_box;
	gtk_box_pack_start (mbox, (GtkWidget*) _tmp33_, FALSE, FALSE, (guint) 0);
	_tmp34_ = self->priv->_stack;
	gtk_stack_add_named (_tmp34_, (GtkWidget*) sw, "all");
	_tmp35_ = self->priv->_stack;
	gtk_stack_add_named (_tmp35_, (GtkWidget*) msw, "matched");
	_tmp36_ = sticker_set_new ();
	_sticker_set_unref0 (self->priv->_sticker_set);
	self->priv->_sticker_set = _tmp36_;
	_tmp37_ = sticker_inspector_create_category (self, box, _ ("Favorites"));
	_g_object_unref0 (self->priv->_favorites);
	self->priv->_favorites = _tmp37_;
	sticker_inspector_load_favorites (self);
	sticker_inspector_create_from_sticker_set (self, box);
	_tmp38_ = (GtkButton*) gtk_button_new_with_label (_ ("Show Custom Sticker Directory"));
	g_object_ref_sink (_tmp38_);
	show = _tmp38_;
	g_signal_connect_object (show, "clicked", (GCallback) ___lambda81__gtk_button_clicked, self, 0);
	gtk_box_pack_start (box, (GtkWidget*) show, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) lbl, FALSE, FALSE, (guint) 5);
	_tmp39_ = self->priv->_search;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 5);
	_tmp40_ = self->priv->_stack;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp40_, TRUE, TRUE, (guint) 5);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (show);
	_g_object_unref0 (msw);
	_g_object_unref0 (mbox);
	_g_object_unref0 (vp);
	_g_object_unref0 (sw);
	_g_object_unref0 (box);
	_g_object_unref0 (lbl);
	_g_object_unref0 (cu_remove);
	_g_object_unref0 (unfavorite);
	block37_data_unref (_data37_);
	_data37_ = NULL;
	return self;
}

StickerInspector*
sticker_inspector_new (MainWindow* win,
                       GSettings* settings)
{
	return sticker_inspector_construct (TYPE_STICKER_INSPECTOR, win, settings);
}

static void
sticker_inspector_create_from_sticker_set (StickerInspector* self,
                                           GtkBox* box)
{
	GArray* categories = NULL;
	StickerSet* _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->_sticker_set;
	_tmp1_ = sticker_set_get_categories (_tmp0_);
	categories = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				GtkFlowBox* category = NULL;
				GArray* _tmp5_;
				const gchar* _tmp6_;
				GtkFlowBox* _tmp7_;
				GArray* icons = NULL;
				StickerSet* _tmp8_;
				GArray* _tmp9_;
				const gchar* _tmp10_;
				GArray* _tmp11_;
				GtkFlowBox* _tmp33_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = categories;
				if (!(((guint) i) < _tmp4_->len)) {
					break;
				}
				_tmp5_ = categories;
				_tmp6_ = g_array_index (_tmp5_, gchar*, (guint) i);
				_tmp7_ = sticker_inspector_create_category (self, box, _tmp6_);
				category = _tmp7_;
				_tmp8_ = self->priv->_sticker_set;
				_tmp9_ = categories;
				_tmp10_ = g_array_index (_tmp9_, gchar*, (guint) i);
				_tmp11_ = sticker_set_get_category_icons (_tmp8_, _tmp10_);
				icons = _tmp11_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							GArray* _tmp14_;
							GtkFlowBox* _tmp15_;
							GArray* _tmp16_;
							StickerSetStickerInfo* _tmp17_;
							const gchar* _tmp18_;
							const gchar* _tmp19_;
							GArray* _tmp20_;
							StickerSetStickerInfo* _tmp21_;
							const gchar* _tmp22_;
							const gchar* _tmp23_;
							GtkFlowBox* _tmp24_;
							GArray* _tmp25_;
							StickerSetStickerInfo* _tmp26_;
							const gchar* _tmp27_;
							const gchar* _tmp28_;
							GArray* _tmp29_;
							StickerSetStickerInfo* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = j;
								j = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = icons;
							if (!(((guint) j) < _tmp14_->len)) {
								break;
							}
							_tmp15_ = category;
							_tmp16_ = icons;
							_tmp17_ = g_array_index (_tmp16_, StickerSetStickerInfo*, (guint) j);
							_tmp18_ = sticker_set_sticker_info_get_resource (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = icons;
							_tmp21_ = g_array_index (_tmp20_, StickerSetStickerInfo*, (guint) j);
							_tmp22_ = sticker_set_sticker_info_get_tooltip (_tmp21_);
							_tmp23_ = _tmp22_;
							sticker_inspector_create_image (self, _tmp15_, _tmp19_, _tmp23_, TRUE);
							_tmp24_ = self->priv->_matched_box;
							_tmp25_ = icons;
							_tmp26_ = g_array_index (_tmp25_, StickerSetStickerInfo*, (guint) j);
							_tmp27_ = sticker_set_sticker_info_get_resource (_tmp26_);
							_tmp28_ = _tmp27_;
							_tmp29_ = icons;
							_tmp30_ = g_array_index (_tmp29_, StickerSetStickerInfo*, (guint) j);
							_tmp31_ = sticker_set_sticker_info_get_tooltip (_tmp30_);
							_tmp32_ = _tmp31_;
							sticker_inspector_create_image (self, _tmp24_, _tmp28_, _tmp32_, TRUE);
						}
					}
				}
				_tmp33_ = category;
				sticker_inspector_create_import (self, _tmp33_);
				_g_array_unref0 (icons);
				_g_object_unref0 (category);
			}
		}
	}
	_g_array_unref0 (categories);
}

static GtkFlowBox*
sticker_inspector_create_category (StickerInspector* self,
                                   GtkBox* box,
                                   const gchar* name)
{
	GtkExpander* exp = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkExpander* _tmp2_ = NULL;
	GtkExpander* _tmp3_;
	GtkFlowBox* fbox = NULL;
	GtkFlowBox* _tmp4_;
	GtkFlowBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = utils_make_title (name);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkExpander*) gtk_expander_new (_tmp1_);
	gtk_expander_set_use_markup (_tmp2_, TRUE);
	gtk_expander_set_expanded (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	exp = _tmp3_;
	_tmp4_ = sticker_inspector_create_icon_box (self, name);
	fbox = _tmp4_;
	gtk_container_add ((GtkContainer*) exp, (GtkWidget*) fbox);
	gtk_box_pack_start (box, (GtkWidget*) exp, FALSE, FALSE, (guint) 20);
	result = fbox;
	_g_object_unref0 (exp);
	return result;
}

static void
sticker_inspector_create_image (StickerInspector* self,
                                GtkFlowBox* box,
                                const gchar* name,
                                const gchar* tooltip,
                                gboolean add)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (tooltip != NULL);
	_tmp0_ = sticker_set_make_pixbuf (name, -1);
	pixbuf = _tmp0_;
	_tmp1_ = pixbuf;
	if (_tmp1_ != NULL) {
		GtkImage* img = NULL;
		GdkPixbuf* _tmp2_;
		GtkImage* _tmp3_;
		GtkImage* _tmp4_;
		GtkImage* _tmp5_;
		_tmp2_ = pixbuf;
		_tmp3_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp2_);
		g_object_ref_sink (_tmp3_);
		img = _tmp3_;
		_tmp4_ = img;
		gtk_widget_set_name ((GtkWidget*) _tmp4_, name);
		_tmp5_ = img;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, tooltip);
		if (add) {
			GtkImage* _tmp6_;
			_tmp6_ = img;
			gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp6_);
		} else {
			GtkImage* _tmp7_;
			GList* _tmp8_;
			GList* _tmp9_;
			_tmp7_ = img;
			_tmp8_ = gtk_container_get_children ((GtkContainer*) box);
			_tmp9_ = _tmp8_;
			gtk_flow_box_insert (box, (GtkWidget*) _tmp7_, (gint) (g_list_length (_tmp9_) - 1));
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (g_list_free (_tmp9_), NULL));
		}
		_g_object_unref0 (img);
	}
	_g_object_unref0 (pixbuf);
}

static void
sticker_inspector_create_import (StickerInspector* self,
                                 GtkFlowBox* box)
{
	GtkImage* img = NULL;
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp0_);
	img = _tmp0_;
	gtk_widget_set_name ((GtkWidget*) img, "");
	gtk_widget_set_tooltip_text ((GtkWidget*) img, _ ("Add custom stickers"));
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) img);
	_g_object_unref0 (img);
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		StickerInspector* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->fbox);
		_g_free0 (_data38_->category);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static void
_sticker_inspector_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                        GdkDragContext* context,
                                                        gpointer self)
{
	sticker_inspector_on_drag_begin ((StickerInspector*) self, _sender, context);
}

static void
_sticker_inspector_on_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                              GdkDragContext* context,
                                                              GtkSelectionData* selection_data,
                                                              guint info,
                                                              guint time_,
                                                              gpointer self)
{
	sticker_inspector_on_drag_data_get ((StickerInspector*) self, _sender, context, selection_data, info, time_);
}

static gboolean
__lambda78_ (StickerInspector* self,
             GdkEventMotion* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	self->priv->_motion_x = e->x;
	self->priv->_motion_y = e->y;
	result = TRUE;
	return result;
}

static gboolean
___lambda78__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                             GdkEventMotion* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda78_ ((StickerInspector*) self, event);
	return result;
}

static gboolean
__lambda79_ (Block38Data* _data38_,
             GdkEventButton* e)
{
	StickerInspector* self;
	gint int_x = 0;
	gint int_y = 0;
	gboolean result;
	self = _data38_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	int_x = (gint) e->x;
	int_y = (gint) e->y;
	if (e->button == ((guint) GDK_BUTTON_PRIMARY)) {
		GtkFlowBoxChild* _tmp0_;
		GtkWidget* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = gtk_flow_box_get_child_at_pos (_data38_->fbox, int_x, int_y);
		_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
		_tmp2_ = gtk_widget_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, "") == 0) {
			sticker_inspector_import_stickers (self, _data38_->fbox, _data38_->category);
		}
	} else {
		if (e->button == ((guint) GDK_BUTTON_SECONDARY)) {
			GtkFlowBox* _tmp4_;
			GtkFlowBoxChild* _tmp5_;
			GtkWidget* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp4_ = _g_object_ref0 (_data38_->fbox);
			_g_object_unref0 (self->priv->_clicked_category);
			self->priv->_clicked_category = _tmp4_;
			_tmp5_ = gtk_flow_box_get_child_at_pos (_data38_->fbox, int_x, int_y);
			_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
			_tmp7_ = gtk_widget_get_name (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (self->priv->_clicked_sticker);
			self->priv->_clicked_sticker = _tmp9_;
			_tmp10_ = self->priv->_clicked_sticker;
			if (g_strcmp0 (_tmp10_, "") != 0) {
				GtkFlowBox* _tmp11_;
				GtkFlowBox* _tmp12_;
				_tmp11_ = self->priv->_clicked_category;
				_tmp12_ = self->priv->_favorites;
				if (_tmp11_ == _tmp12_) {
					GtkMenu* _tmp13_;
					_tmp13_ = self->priv->_favorite_menu;
					utils_popup_menu (_tmp13_, (GdkEvent*) e);
				} else {
					const gchar* _tmp14_;
					_tmp14_ = self->priv->_clicked_sticker;
					if (sticker_inspector_is_custom (self, _tmp14_)) {
						GtkMenu* _tmp15_;
						_tmp15_ = self->priv->_custom_menu;
						utils_popup_menu (_tmp15_, (GdkEvent*) e);
					} else {
						GtkMenu* _tmp16_;
						_tmp16_ = self->priv->_builtin_menu;
						utils_popup_menu (_tmp16_, (GdkEvent*) e);
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda79__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda79_ (self, event);
	return result;
}

static GtkFlowBox*
sticker_inspector_create_icon_box (StickerInspector* self,
                                   const gchar* category)
{
	Block38Data* _data38_;
	gchar* _tmp0_;
	GtkFlowBox* _tmp1_;
	GtkFlowBox* _tmp2_;
	GtkFlowBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = g_strdup (category);
	_g_free0 (_data38_->category);
	_data38_->category = _tmp0_;
	_tmp1_ = (GtkFlowBox*) gtk_flow_box_new ();
	g_object_ref_sink (_tmp1_);
	_data38_->fbox = _tmp1_;
	gtk_flow_box_set_homogeneous (_data38_->fbox, TRUE);
	gtk_flow_box_set_selection_mode (_data38_->fbox, GTK_SELECTION_NONE);
	gtk_drag_source_set ((GtkWidget*) _data38_->fbox, GDK_BUTTON1_MASK, STICKER_INSPECTOR_DRAG_TARGETS, (gint) G_N_ELEMENTS (STICKER_INSPECTOR_DRAG_TARGETS), GDK_ACTION_COPY);
	g_signal_connect_object ((GtkWidget*) _data38_->fbox, "drag-begin", (GCallback) _sticker_inspector_on_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) _data38_->fbox, "drag-data-get", (GCallback) _sticker_inspector_on_drag_data_get_gtk_widget_drag_data_get, self, 0);
	g_signal_connect_object ((GtkWidget*) _data38_->fbox, "motion-notify-event", (GCallback) ___lambda78__gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_data ((GtkWidget*) _data38_->fbox, "button-press-event", (GCallback) ___lambda79__gtk_widget_button_press_event, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
	_tmp2_ = _g_object_ref0 (_data38_->fbox);
	result = _tmp2_;
	block38_data_unref (_data38_);
	_data38_ = NULL;
	return result;
}

static void
sticker_inspector_handle_favorite (StickerInspector* self)
{
	GtkFlowBox* _tmp0_;
	GtkFlowBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_clicked_category;
	_tmp1_ = self->priv->_favorites;
	if (_tmp0_ == _tmp1_) {
		sticker_inspector_make_unfavorite (self);
	} else {
		sticker_inspector_make_favorite (self);
	}
}

static void
___lambda75_ (StickerInspector* self,
              GtkWidget* w)
{
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) (G_TYPE_CHECK_INSTANCE_TYPE (w, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) w) : NULL));
	_tmp1_ = gtk_widget_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_clicked_sticker;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		GtkFlowBox* _tmp4_;
		_tmp4_ = self->priv->_clicked_category;
		gtk_container_remove ((GtkContainer*) _tmp4_, w);
	}
}

static void
____lambda75__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda75_ ((StickerInspector*) self, (GtkWidget*) data);
}

static void
sticker_inspector_handle_remove (StickerInspector* self)
{
	StickerSet* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sticker_set;
	_tmp1_ = self->priv->_clicked_sticker;
	if (sticker_set_remove_sticker (_tmp0_, _tmp1_)) {
		GtkFlowBox* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		sticker_inspector_make_unfavorite (self);
		_tmp2_ = self->priv->_clicked_category;
		_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_list_foreach (_tmp4_, ____lambda75__gfunc, self);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	}
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		StickerInspector* self;
		self = _data39_->self;
		_g_free0 (_data39_->name);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}

static void
__lambda74_ (Block39Data* _data39_,
             GtkWidget* w)
{
	StickerInspector* self;
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data39_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) (G_TYPE_CHECK_INSTANCE_TYPE (w, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) w) : NULL));
	_tmp1_ = gtk_widget_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_data39_->exists |= g_strcmp0 (_tmp2_, _data39_->name) == 0;
}

static void
___lambda74__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda74_ (self, (GtkWidget*) data);
}

static gboolean
sticker_inspector_is_favorite (StickerInspector* self,
                               const gchar* name)
{
	Block39Data* _data39_;
	gchar* _tmp0_;
	GtkFlowBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	_tmp0_ = g_strdup (name);
	_g_free0 (_data39_->name);
	_data39_->name = _tmp0_;
	_data39_->exists = FALSE;
	_tmp1_ = self->priv->_favorites;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda74__gfunc, _data39_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
	result = _data39_->exists;
	block39_data_unref (_data39_);
	_data39_ = NULL;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
sticker_inspector_is_custom (StickerInspector* self,
                             const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	result = string_get_char (name, (glong) 0) == ((gunichar) '/');
	return result;
}

static void
sticker_inspector_make_favorite (StickerInspector* self)
{
	gchar* tooltip = NULL;
	StickerSet* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sticker_set;
	_tmp1_ = self->priv->_clicked_sticker;
	_tmp3_ = sticker_set_get_icon_info (_tmp0_, _tmp1_, &_tmp2_);
	_g_free0 (tooltip);
	tooltip = _tmp2_;
	if (_tmp3_) {
		GtkFlowBox* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GtkFlowBox* _tmp7_;
		_tmp4_ = self->priv->_favorites;
		_tmp5_ = self->priv->_clicked_sticker;
		_tmp6_ = tooltip;
		sticker_inspector_create_image (self, _tmp4_, _tmp5_, _tmp6_, TRUE);
		_tmp7_ = self->priv->_favorites;
		gtk_widget_show_all ((GtkWidget*) _tmp7_);
		sticker_inspector_save_favorites (self);
	}
	_g_free0 (tooltip);
}

static void
__lambda71_ (StickerInspector* self,
             GtkWidget* w)
{
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) (G_TYPE_CHECK_INSTANCE_TYPE (w, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) w) : NULL));
	_tmp1_ = gtk_widget_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_clicked_sticker;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		GtkFlowBox* _tmp4_;
		_tmp4_ = self->priv->_favorites;
		gtk_container_remove ((GtkContainer*) _tmp4_, w);
		sticker_inspector_save_favorites (self);
	}
}

static void
___lambda71__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda71_ ((StickerInspector*) self, (GtkWidget*) data);
}

static void
sticker_inspector_make_unfavorite (StickerInspector* self)
{
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_favorites;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda71__gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
}

static Block40Data*
block40_data_ref (Block40Data* _data40_)
{
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}

static void
block40_data_unref (void * _userdata_)
{
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		StickerInspector* self;
		self = _data40_->self;
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}

static void
__lambda72_ (Block40Data* _data40_,
             GtkWidget* w)
{
	StickerInspector* self;
	gchar* name = NULL;
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	xmlNode* n = NULL;
	xmlNode* _tmp4_;
	self = _data40_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) (G_TYPE_CHECK_INSTANCE_TYPE (w, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) w) : NULL));
	_tmp1_ = gtk_widget_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = xmlNewNode (NULL, (xmlChar*) "sticker");
	n = _tmp4_;
	xmlSetProp (n, (xmlChar*) "name", (xmlChar*) name);
	xmlAddChild (_data40_->root, n);
	_g_free0 (name);
}

static void
___lambda72__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda72_ (self, (GtkWidget*) data);
}

static void
sticker_inspector_save_favorites (StickerInspector* self)
{
	Block40Data* _data40_;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlNode* _tmp1_;
	GtkFlowBox* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_data40_->self = g_object_ref (self);
	_tmp0_ = xmlNewDoc ((xmlChar*) NULL);
	doc = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "favorites");
	_data40_->root = _tmp1_;
	xmlDocSetRootElement (doc, _data40_->root);
	_tmp2_ = self->priv->_favorites;
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_list_foreach (_tmp4_, ___lambda72__gfunc, _data40_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	_tmp5_ = self->priv->favorites;
	xmlSaveFormatFile (_tmp5_, doc, 1);
	_xmlFreeDoc0 (doc);
	block40_data_unref (_data40_);
	_data40_ = NULL;
}

static void
sticker_inspector_load_favorites (StickerInspector* self)
{
	const gchar* _tmp0_;
	xmlDoc* doc = NULL;
	const gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlDoc* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->favorites;
	if (!g_file_test (_tmp0_, G_FILE_TEST_EXISTS)) {
		return;
	}
	_tmp1_ = self->priv->favorites;
	_tmp2_ = xmlParseFile (_tmp1_);
	doc = _tmp2_;
	_tmp3_ = doc;
	if (_tmp3_ == NULL) {
		return;
	}
	{
		xmlNode* it = NULL;
		xmlDoc* _tmp4_;
		xmlNode* _tmp5_;
		xmlNode* _tmp6_;
		_tmp4_ = doc;
		_tmp5_ = xmlDocGetRootElement (_tmp4_);
		_tmp6_ = _tmp5_->children;
		it = _tmp6_;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp10_;
				gboolean _tmp11_ = FALSE;
				xmlNode* _tmp12_;
				if (!_tmp7_) {
					xmlNode* _tmp8_;
					xmlNode* _tmp9_;
					_tmp8_ = it;
					_tmp9_ = _tmp8_->next;
					it = _tmp9_;
				}
				_tmp7_ = FALSE;
				_tmp10_ = it;
				if (!(_tmp10_ != NULL)) {
					break;
				}
				_tmp12_ = it;
				if (_tmp12_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp13_;
					const gchar* _tmp14_;
					_tmp13_ = it;
					_tmp14_ = _tmp13_->name;
					_tmp11_ = g_strcmp0 (_tmp14_, "sticker") == 0;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					gchar* name = NULL;
					xmlNode* _tmp15_;
					gchar* _tmp16_;
					gchar* tooltip = NULL;
					StickerSet* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_ = NULL;
					gboolean _tmp20_;
					_tmp15_ = it;
					_tmp16_ = (gchar*) xmlGetProp (_tmp15_, (xmlChar*) "name");
					name = _tmp16_;
					_tmp17_ = self->priv->_sticker_set;
					_tmp18_ = name;
					_tmp20_ = sticker_set_get_icon_info (_tmp17_, _tmp18_, &_tmp19_);
					_g_free0 (tooltip);
					tooltip = _tmp19_;
					if (_tmp20_) {
						GtkFlowBox* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						_tmp21_ = self->priv->_favorites;
						_tmp22_ = name;
						_tmp23_ = tooltip;
						sticker_inspector_create_image (self, _tmp21_, _tmp22_, _tmp23_, TRUE);
					}
					_g_free0 (tooltip);
					_g_free0 (name);
				}
			}
		}
	}
	_tmp24_ = doc;
	_xmlFreeDoc0 (_tmp24_);
}

static void
sticker_inspector_on_drag_begin (StickerInspector* self,
                                 GtkWidget* widget,
                                 GdkDragContext* context)
{
	GtkFlowBox* fbox = NULL;
	GtkFlowBox* _tmp0_;
	gint int_x = 0;
	gint int_y = 0;
	GtkFlowBoxChild* _tmp1_;
	GtkWidget* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_flow_box_get_type (), GtkFlowBox));
	fbox = _tmp0_;
	int_x = (gint) self->priv->_motion_x;
	int_y = (gint) self->priv->_motion_y;
	_tmp1_ = gtk_flow_box_get_child_at_pos (fbox, int_x, int_y);
	_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_image_get_type (), GtkImage));
	_g_object_unref0 (self->priv->_dragged_sticker);
	self->priv->_dragged_sticker = _tmp3_;
	_tmp4_ = self->priv->_dragged_sticker;
	g_object_get (_tmp4_, "pixbuf", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	gtk_drag_set_icon_pixbuf (context, _tmp7_, 0, 0);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (fbox);
}

static void
sticker_inspector_on_drag_data_get (StickerInspector* self,
                                    GtkWidget* widget,
                                    GdkDragContext* context,
                                    GtkSelectionData* selection_data,
                                    guint target_type,
                                    guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	if (target_type == ((guint) DRAG_TYPES_STICKER)) {
		GtkImage* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->_dragged_sticker;
		_tmp1_ = gtk_widget_get_name ((GtkWidget*) _tmp0_);
		_tmp2_ = _tmp1_;
		gtk_selection_data_set_text (selection_data, _tmp2_, -1);
	}
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		StickerInspector* self;
		self = _data41_->self;
		_g_free0 (_data41_->search_text);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
___lambda77_ (Block41Data* _data41_,
              GtkFlowBoxChild* item)
{
	StickerInspector* self;
	gchar** search_keys = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint search_keys_length1;
	gint _search_keys_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gboolean result;
	self = _data41_->self;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = _data41_->search_text;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	search_keys = _tmp2_;
	search_keys_length1 = _vala_array_length (_tmp1_);
	_search_keys_size_ = search_keys_length1;
	_tmp3_ = search_keys;
	_tmp3__length1 = search_keys_length1;
	{
		gchar** sk_collection = NULL;
		gint sk_collection_length1 = 0;
		gint _sk_collection_size_ = 0;
		gint sk_it = 0;
		sk_collection = _tmp3_;
		sk_collection_length1 = _tmp3__length1;
		for (sk_it = 0; sk_it < sk_collection_length1; sk_it = sk_it + 1) {
			gchar* _tmp4_;
			gchar* sk = NULL;
			_tmp4_ = g_strdup (sk_collection[sk_it]);
			sk = _tmp4_;
			{
				GtkWidget* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gboolean _tmp11_;
				_tmp5_ = gtk_bin_get_child ((GtkBin*) item);
				_tmp6_ = gtk_widget_get_tooltip_text (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_utf8_casefold (_tmp7_, (gssize) -1);
				_tmp9_ = _tmp8_;
				_tmp10_ = sk;
				_tmp11_ = !string_contains (_tmp9_, _tmp10_);
				_g_free0 (_tmp9_);
				_g_free0 (_tmp7_);
				if (_tmp11_) {
					result = FALSE;
					_g_free0 (sk);
					search_keys = (_vala_array_free (search_keys, search_keys_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (sk);
			}
		}
	}
	result = TRUE;
	search_keys = (_vala_array_free (search_keys, search_keys_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
____lambda77__gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                        gpointer self)
{
	gboolean result;
	result = ___lambda77_ (self, child);
	return result;
}

static void
sticker_inspector_do_search (StickerInspector* self)
{
	Block41Data* _data41_;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = self->priv->_search;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_data41_->search_text = _tmp3_;
	_tmp4_ = _data41_->search_text;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		GtkFlowBox* _tmp5_;
		GtkStack* _tmp6_;
		_tmp5_ = self->priv->_matched_box;
		gtk_flow_box_invalidate_filter (_tmp5_);
		_tmp6_ = self->priv->_stack;
		gtk_stack_set_visible_child_name (_tmp6_, "all");
	} else {
		GtkFlowBox* _tmp7_;
		GtkStack* _tmp8_;
		_tmp7_ = self->priv->_matched_box;
		gtk_flow_box_set_filter_func (_tmp7_, ____lambda77__gtk_flow_box_filter_func, block41_data_ref (_data41_), block41_data_unref);
		_tmp8_ = self->priv->_stack;
		gtk_stack_set_visible_child_name (_tmp8_, "matched");
	}
	block41_data_unref (_data41_);
	_data41_ = NULL;
}

void
sticker_inspector_grab_first (StickerInspector* self)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		StickerInspector* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->fbox);
		_g_free0 (_data42_->category);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static void
___lambda80_ (Block42Data* _data42_,
              const gchar* sticker)
{
	StickerInspector* self;
	gchar** parts = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint parts_length1;
	gint _parts_size_;
	StickerSet* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	self = _data42_->self;
	g_return_if_fail (sticker != NULL);
	_tmp0_ = g_path_get_basename (sticker);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	parts = _tmp4_;
	parts_length1 = _tmp4__length1;
	_parts_size_ = parts_length1;
	_tmp5_ = self->priv->_sticker_set;
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	_tmp7_ = _tmp6_[0];
	if (sticker_set_load_sticker (_tmp5_, _data42_->category, _tmp7_, sticker, TRUE)) {
		gchar* tooltip = NULL;
		StickerSet* _tmp8_;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		_tmp8_ = self->priv->_sticker_set;
		sticker_set_get_icon_info (_tmp8_, sticker, &_tmp9_);
		_g_free0 (tooltip);
		tooltip = _tmp9_;
		_tmp10_ = tooltip;
		sticker_inspector_create_image (self, _data42_->fbox, sticker, _tmp10_, FALSE);
		gtk_widget_show_all ((GtkWidget*) _data42_->fbox);
		_g_free0 (tooltip);
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}

static void
____lambda80__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda80_ (self, (const gchar*) data);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
sticker_inspector_import_stickers (StickerInspector* self,
                                   GtkFlowBox* fbox,
                                   const gchar* category)
{
	Block42Data* _data42_;
	GtkFlowBox* _tmp0_;
	gchar* _tmp1_;
	GtkFileChooserNative* dialog = NULL;
	MainWindow* _tmp2_;
	GtkFileChooserNative* _tmp3_ = NULL;
	GtkFileChooserNative* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fbox != NULL);
	g_return_if_fail (category != NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (fbox);
	_g_object_unref0 (_data42_->fbox);
	_data42_->fbox = _tmp0_;
	_tmp1_ = g_strdup (category);
	_g_free0 (_data42_->category);
	_data42_->category = _tmp1_;
	_tmp2_ = self->priv->_win;
	_tmp3_ = gtk_file_chooser_native_new (_ ("Import Sticker(s)"), (GtkWindow*) _tmp2_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Import"), _ ("Cancel"));
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp3_, TRUE);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp4_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GSList* stickers = NULL;
		GtkFileChooserNative* _tmp5_;
		GSList* _tmp6_;
		GSList* _tmp7_;
		_tmp5_ = dialog;
		_tmp6_ = gtk_file_chooser_get_filenames ((GtkFileChooser*) _tmp5_);
		stickers = _tmp6_;
		_tmp7_ = stickers;
		g_slist_foreach (_tmp7_, ____lambda80__gfunc, _data42_);
		(stickers == NULL) ? NULL : (stickers = (_g_slist_free__g_free0_ (stickers), NULL));
	}
	_g_object_unref0 (dialog);
	block42_data_unref (_data42_);
	_data42_ = NULL;
}

static void
sticker_inspector_class_init (StickerInspectorClass * klass,
                              gpointer klass_data)
{
	sticker_inspector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StickerInspector_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sticker_inspector_finalize;
}

static void
sticker_inspector_instance_init (StickerInspector * self,
                                 gpointer klass)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = sticker_inspector_get_instance_private (self);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "minder", "favorites.xml", NULL);
	self->priv->favorites = _tmp1_;
	self->priv->_da = NULL;
}

static void
sticker_inspector_finalize (GObject * obj)
{
	StickerInspector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STICKER_INSPECTOR, StickerInspector);
	_g_free0 (self->priv->favorites);
	_g_object_unref0 (self->priv->_win);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_search);
	_g_object_unref0 (self->priv->_stack);
	_g_object_unref0 (self->priv->_favorites);
	_g_object_unref0 (self->priv->_matched_box);
	_g_object_unref0 (self->priv->_dragged_sticker);
	_g_object_unref0 (self->priv->_favorite_menu);
	_g_object_unref0 (self->priv->_builtin_menu);
	_g_object_unref0 (self->priv->_custom_menu);
	_g_object_unref0 (self->priv->_clicked_category);
	_sticker_set_unref0 (self->priv->_sticker_set);
	_g_free0 (self->priv->_clicked_sticker);
	G_OBJECT_CLASS (sticker_inspector_parent_class)->finalize (obj);
}

static GType
sticker_inspector_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StickerInspectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sticker_inspector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StickerInspector), 0, (GInstanceInitFunc) sticker_inspector_instance_init, NULL };
	GType sticker_inspector_type_id;
	sticker_inspector_type_id = g_type_register_static (gtk_box_get_type (), "StickerInspector", &g_define_type_info, 0);
	StickerInspector_private_offset = g_type_add_instance_private (sticker_inspector_type_id, sizeof (StickerInspectorPrivate));
	return sticker_inspector_type_id;
}

GType
sticker_inspector_get_type (void)
{
	static volatile gsize sticker_inspector_type_id__once = 0;
	if (g_once_init_enter (&sticker_inspector_type_id__once)) {
		GType sticker_inspector_type_id;
		sticker_inspector_type_id = sticker_inspector_get_type_once ();
		g_once_init_leave (&sticker_inspector_type_id__once, sticker_inspector_type_id);
	}
	return sticker_inspector_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

