// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: ha_tracker.proto

package distributor

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ReplicaDesc struct {
	Replica string `protobuf:"bytes,1,opt,name=replica,proto3" json:"replica,omitempty"`
	// Unix timestamp in milliseconds when we have last received request from this replica.
	ReceivedAt int64 `protobuf:"varint,2,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	// Unix timestamp in milliseconds when this entry was marked for deletion.
	// Reason for doing marking first, and delete later, is to make sure that distributors
	// watching the prefix will receive notification on "marking" -- at which point they can
	// already remove entry from memory. Actual deletion from KV store does *not* trigger
	// "watch" notification with a key for all KV stores.
	DeletedAt int64 `protobuf:"varint,3,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// This is the most recent timestamp when this replica was elected as the leader.
	ElectedAt int64 `protobuf:"varint,4,opt,name=elected_at,json=electedAt,proto3" json:"elected_at,omitempty"`
	// This is incremented every time a new replica is elected as the leader.
	ElectedChanges int64 `protobuf:"varint,5,opt,name=elected_changes,json=electedChanges,proto3" json:"elected_changes,omitempty"`
}

func (m *ReplicaDesc) Reset()      { *m = ReplicaDesc{} }
func (*ReplicaDesc) ProtoMessage() {}
func (*ReplicaDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_86f0e7bcf71d860b, []int{0}
}
func (m *ReplicaDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicaDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicaDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicaDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaDesc.Merge(m, src)
}
func (m *ReplicaDesc) XXX_Size() int {
	return m.Size()
}
func (m *ReplicaDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaDesc.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaDesc proto.InternalMessageInfo

func (m *ReplicaDesc) GetReplica() string {
	if m != nil {
		return m.Replica
	}
	return ""
}

func (m *ReplicaDesc) GetReceivedAt() int64 {
	if m != nil {
		return m.ReceivedAt
	}
	return 0
}

func (m *ReplicaDesc) GetDeletedAt() int64 {
	if m != nil {
		return m.DeletedAt
	}
	return 0
}

func (m *ReplicaDesc) GetElectedAt() int64 {
	if m != nil {
		return m.ElectedAt
	}
	return 0
}

func (m *ReplicaDesc) GetElectedChanges() int64 {
	if m != nil {
		return m.ElectedChanges
	}
	return 0
}

func init() {
	proto.RegisterType((*ReplicaDesc)(nil), "distributor.ReplicaDesc")
}

func init() { proto.RegisterFile("ha_tracker.proto", fileDescriptor_86f0e7bcf71d860b) }

var fileDescriptor_86f0e7bcf71d860b = []byte{
	// 240 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x34, 0xcf, 0x3f, 0x4e, 0xc3, 0x30,
	0x14, 0xc7, 0x71, 0x3f, 0xca, 0x1f, 0xf5, 0x45, 0x02, 0x64, 0x31, 0x44, 0x48, 0x3c, 0x2a, 0x16,
	0x3a, 0xc1, 0x00, 0x17, 0x28, 0x70, 0x82, 0x5c, 0xa0, 0x72, 0x9d, 0xa7, 0x34, 0x22, 0xc2, 0x95,
	0xf3, 0x60, 0xe6, 0x08, 0x1c, 0x83, 0x8d, 0x6b, 0x30, 0x66, 0xec, 0x48, 0x9c, 0x85, 0xb1, 0x47,
	0x40, 0xc4, 0xc9, 0xe6, 0xf7, 0xfd, 0xfc, 0x16, 0xe3, 0xe9, 0xda, 0x2c, 0xc5, 0x1b, 0xfb, 0xcc,
	0xfe, 0x66, 0xe3, 0x9d, 0x38, 0x9d, 0xe4, 0x65, 0x2d, 0xbe, 0x5c, 0xbd, 0x8a, 0xf3, 0xe7, 0x67,
	0x85, 0x2b, 0x5c, 0xdf, 0x6f, 0xff, 0x5f, 0x71, 0x72, 0xf5, 0x05, 0x98, 0x64, 0xbc, 0xa9, 0x4a,
	0x6b, 0x9e, 0xb8, 0xb6, 0x3a, 0xc5, 0x23, 0x1f, 0xcf, 0x14, 0x66, 0x30, 0x9f, 0x66, 0xe3, 0xa9,
	0x2f, 0x31, 0xf1, 0x6c, 0xb9, 0x7c, 0xe3, 0x7c, 0x69, 0x24, 0xdd, 0x9b, 0xc1, 0x7c, 0x92, 0xe1,
	0x98, 0x16, 0xa2, 0x2f, 0x10, 0x73, 0xae, 0x58, 0xa2, 0x4f, 0x7a, 0x9f, 0x0e, 0x25, 0x32, 0x57,
	0x6c, 0x07, 0xde, 0x8f, 0x3c, 0x94, 0x85, 0xe8, 0x6b, 0x3c, 0x19, 0xd9, 0xae, 0xcd, 0x4b, 0xc1,
	0x75, 0x7a, 0xd0, 0x6f, 0x8e, 0x87, 0xfc, 0x18, 0xeb, 0xc3, 0x7d, 0xd3, 0x92, 0xda, 0xb6, 0xa4,
	0x76, 0x2d, 0xc1, 0x7b, 0x20, 0xf8, 0x0c, 0x04, 0xdf, 0x81, 0xa0, 0x09, 0x04, 0x3f, 0x81, 0xe0,
	0x37, 0x90, 0xda, 0x05, 0x82, 0x8f, 0x8e, 0x54, 0xd3, 0x91, 0xda, 0x76, 0xa4, 0x56, 0x87, 0xfd,
	0x77, 0xef, 0xfe, 0x02, 0x00, 0x00, 0xff, 0xff, 0x1f, 0x77, 0xe4, 0x87, 0x25, 0x01, 0x00, 0x00,
}

func (this *ReplicaDesc) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicaDesc)
	if !ok {
		that2, ok := that.(ReplicaDesc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Replica != that1.Replica {
		return false
	}
	if this.ReceivedAt != that1.ReceivedAt {
		return false
	}
	if this.DeletedAt != that1.DeletedAt {
		return false
	}
	if this.ElectedAt != that1.ElectedAt {
		return false
	}
	if this.ElectedChanges != that1.ElectedChanges {
		return false
	}
	return true
}
func (this *ReplicaDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&distributor.ReplicaDesc{")
	s = append(s, "Replica: "+fmt.Sprintf("%#v", this.Replica)+",\n")
	s = append(s, "ReceivedAt: "+fmt.Sprintf("%#v", this.ReceivedAt)+",\n")
	s = append(s, "DeletedAt: "+fmt.Sprintf("%#v", this.DeletedAt)+",\n")
	s = append(s, "ElectedAt: "+fmt.Sprintf("%#v", this.ElectedAt)+",\n")
	s = append(s, "ElectedChanges: "+fmt.Sprintf("%#v", this.ElectedChanges)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringHaTracker(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *ReplicaDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicaDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ElectedChanges != 0 {
		i = encodeVarintHaTracker(dAtA, i, uint64(m.ElectedChanges))
		i--
		dAtA[i] = 0x28
	}
	if m.ElectedAt != 0 {
		i = encodeVarintHaTracker(dAtA, i, uint64(m.ElectedAt))
		i--
		dAtA[i] = 0x20
	}
	if m.DeletedAt != 0 {
		i = encodeVarintHaTracker(dAtA, i, uint64(m.DeletedAt))
		i--
		dAtA[i] = 0x18
	}
	if m.ReceivedAt != 0 {
		i = encodeVarintHaTracker(dAtA, i, uint64(m.ReceivedAt))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Replica) > 0 {
		i -= len(m.Replica)
		copy(dAtA[i:], m.Replica)
		i = encodeVarintHaTracker(dAtA, i, uint64(len(m.Replica)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintHaTracker(dAtA []byte, offset int, v uint64) int {
	offset -= sovHaTracker(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ReplicaDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Replica)
	if l > 0 {
		n += 1 + l + sovHaTracker(uint64(l))
	}
	if m.ReceivedAt != 0 {
		n += 1 + sovHaTracker(uint64(m.ReceivedAt))
	}
	if m.DeletedAt != 0 {
		n += 1 + sovHaTracker(uint64(m.DeletedAt))
	}
	if m.ElectedAt != 0 {
		n += 1 + sovHaTracker(uint64(m.ElectedAt))
	}
	if m.ElectedChanges != 0 {
		n += 1 + sovHaTracker(uint64(m.ElectedChanges))
	}
	return n
}

func sovHaTracker(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozHaTracker(x uint64) (n int) {
	return sovHaTracker(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ReplicaDesc) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicaDesc{`,
		`Replica:` + fmt.Sprintf("%v", this.Replica) + `,`,
		`ReceivedAt:` + fmt.Sprintf("%v", this.ReceivedAt) + `,`,
		`DeletedAt:` + fmt.Sprintf("%v", this.DeletedAt) + `,`,
		`ElectedAt:` + fmt.Sprintf("%v", this.ElectedAt) + `,`,
		`ElectedChanges:` + fmt.Sprintf("%v", this.ElectedChanges) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringHaTracker(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ReplicaDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHaTracker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHaTracker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHaTracker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHaTracker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Replica = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReceivedAt", wireType)
			}
			m.ReceivedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHaTracker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReceivedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			m.DeletedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHaTracker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DeletedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ElectedAt", wireType)
			}
			m.ElectedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHaTracker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ElectedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ElectedChanges", wireType)
			}
			m.ElectedChanges = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHaTracker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ElectedChanges |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipHaTracker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHaTracker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHaTracker(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHaTracker
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHaTracker
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHaTracker
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthHaTracker
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupHaTracker
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthHaTracker
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthHaTracker        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHaTracker          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupHaTracker = fmt.Errorf("proto: unexpected end of group")
)
