/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   Mupen64plus - reset.c                                                 *
 *   Mupen64Plus homepage: http://code.google.com/p/mupen64plus/           *
 *   Copyright (C) 2011 CasualJames                                        *
 *   Copyright (C) 2008-2009 Richard Goedeken                              *
 *   Copyright (C) 2008 Ebenblues Nmn Okaygo Tillin9                       *
 *   Hard reset based on code by hacktarux.                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdint.h>

#include "cached_interp.h"
#include "interrupt.h"
#include "main/device.h"
#include "pifbootrom/pifbootrom.h"
#include "main/main.h"
#include "r4300.h"
#include "r4300_core.h"
#include "reset.h"

int reset_hard_job = 0;

void reset_hard(void)
{
   poweron_device(&g_dev);

   pifbootrom_hle_execute(&g_dev);
   last_addr = UINT32_C(0xa4000040);
   next_interrupt = 624999;
   init_interrupt();

   g_dev.vi.delay = g_dev.vi.next_vi = 5000;
   add_interrupt_event_count(VI_INT, g_dev.vi.next_vi);

   if(r4300emu != CORE_PURE_INTERPRETER)
   {
      free_blocks();
      init_blocks();
   }
   generic_jump_to(last_addr);
}

void reset_soft(void)
{
   add_interrupt_event(HW2_INT, 0);  	    /* Hardware 2 Interrupt immediately */
   add_interrupt_event(NMI_INT, 50000000);  /* Non maskable Interrupt after 1/2 second */
}
