// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

#ifndef CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_VALTYPES_HXX
#define CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_VALTYPES_HXX

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (LIBXSD_VERSION != 400002000000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace icalendar_2_0
{
  class CalAddressType;
  class DateTimeType;
  class UTCDateTimeType;
  class DurationValueType;
  class PeriodType;
  class RecurType;
  class FreqRecurType;
  class UntilRecurType;
  class WeekdayRecurType;
  class BysecondRecurType;
  class ByminuteRecurType;
  class ByhourRecurType;
  class BydayRecurType;
  class ByyeardayRecurType;
  class BymonthdayRecurType;
  class ByweeknoRecurType;
  class BymonthRecurType;
  class UriType;
  class UtcOffsetType;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

namespace icalendar_2_0
{
  class CalAddressType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    CalAddressType ();

    CalAddressType (const char*);

    CalAddressType (const ::std::string&);

    CalAddressType (const ::xml_schema::string&);

    CalAddressType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    CalAddressType (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    CalAddressType (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    CalAddressType (const CalAddressType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual CalAddressType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    CalAddressType&
    operator= (const CalAddressType&) = default;
#endif

    virtual 
    ~CalAddressType ();
  };

  class DateTimeType: public ::xml_schema::date_time
  {
    public:
    // Constructors.
    //
    DateTimeType (const ::xml_schema::date_time&);

    DateTimeType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    DateTimeType (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    DateTimeType (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    DateTimeType (const DateTimeType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual DateTimeType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DateTimeType&
    operator= (const DateTimeType&) = default;
#endif

    virtual 
    ~DateTimeType ();
  };

  class UTCDateTimeType: public ::xml_schema::date_time
  {
    public:
    // Constructors.
    //
    UTCDateTimeType (const ::xml_schema::date_time&);

    UTCDateTimeType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    UTCDateTimeType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    UTCDateTimeType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    UTCDateTimeType (const UTCDateTimeType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual UTCDateTimeType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    UTCDateTimeType&
    operator= (const UTCDateTimeType&) = default;
#endif

    virtual 
    ~UTCDateTimeType ();
  };

  class DurationValueType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    DurationValueType ();

    DurationValueType (const char*);

    DurationValueType (const ::std::string&);

    DurationValueType (const ::xml_schema::string&);

    DurationValueType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    DurationValueType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    DurationValueType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    DurationValueType (const DurationValueType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual DurationValueType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DurationValueType&
    operator= (const DurationValueType&) = default;
#endif

    virtual 
    ~DurationValueType ();
  };

  class PeriodType: public ::xml_schema::type
  {
    public:
    // start
    //
    typedef ::icalendar_2_0::DateTimeType start_type;
    typedef ::xsd::cxx::tree::traits< start_type, char > start_traits;

    const start_type&
    start () const;

    start_type&
    start ();

    void
    start (const start_type& x);

    void
    start (::std::unique_ptr< start_type > p);

    // end
    //
    typedef ::icalendar_2_0::DateTimeType end_type;
    typedef ::xsd::cxx::tree::optional< end_type > end_optional;
    typedef ::xsd::cxx::tree::traits< end_type, char > end_traits;

    const end_optional&
    end () const;

    end_optional&
    end ();

    void
    end (const end_type& x);

    void
    end (const end_optional& x);

    void
    end (::std::unique_ptr< end_type > p);

    // duration
    //
    typedef ::icalendar_2_0::DurationValueType duration_type;
    typedef ::xsd::cxx::tree::optional< duration_type > duration_optional;
    typedef ::xsd::cxx::tree::traits< duration_type, char > duration_traits;

    const duration_optional&
    duration () const;

    duration_optional&
    duration ();

    void
    duration (const duration_type& x);

    void
    duration (const duration_optional& x);

    void
    duration (::std::unique_ptr< duration_type > p);

    // Constructors.
    //
    PeriodType (const start_type&);

    PeriodType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    PeriodType (const PeriodType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual PeriodType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    PeriodType&
    operator= (const PeriodType& x);

    virtual 
    ~PeriodType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< start_type > start_;
    end_optional end_;
    duration_optional duration_;
  };

  class RecurType: public ::xml_schema::type
  {
    public:
    // freq
    //
    typedef ::icalendar_2_0::FreqRecurType freq_type;
    typedef ::xsd::cxx::tree::traits< freq_type, char > freq_traits;

    const freq_type&
    freq () const;

    freq_type&
    freq ();

    void
    freq (const freq_type& x);

    void
    freq (::std::unique_ptr< freq_type > p);

    // until
    //
    typedef ::icalendar_2_0::UntilRecurType until_type;
    typedef ::xsd::cxx::tree::optional< until_type > until_optional;
    typedef ::xsd::cxx::tree::traits< until_type, char > until_traits;

    const until_optional&
    until () const;

    until_optional&
    until ();

    void
    until (const until_type& x);

    void
    until (const until_optional& x);

    void
    until (::std::unique_ptr< until_type > p);

    // count
    //
    typedef ::xml_schema::integer count_type;
    typedef ::xsd::cxx::tree::optional< count_type > count_optional;
    typedef ::xsd::cxx::tree::traits< count_type, char > count_traits;

    const count_optional&
    count () const;

    count_optional&
    count ();

    void
    count (const count_type& x);

    void
    count (const count_optional& x);

    // interval
    //
    typedef ::xml_schema::positive_integer interval_type;
    typedef ::xsd::cxx::tree::optional< interval_type > interval_optional;
    typedef ::xsd::cxx::tree::traits< interval_type, char > interval_traits;

    const interval_optional&
    interval () const;

    interval_optional&
    interval ();

    void
    interval (const interval_type& x);

    void
    interval (const interval_optional& x);

    // bysecond
    //
    typedef ::icalendar_2_0::BysecondRecurType bysecond_type;
    typedef ::xsd::cxx::tree::sequence< bysecond_type > bysecond_sequence;
    typedef bysecond_sequence::iterator bysecond_iterator;
    typedef bysecond_sequence::const_iterator bysecond_const_iterator;
    typedef ::xsd::cxx::tree::traits< bysecond_type, char > bysecond_traits;

    const bysecond_sequence&
    bysecond () const;

    bysecond_sequence&
    bysecond ();

    void
    bysecond (const bysecond_sequence& s);

    // byminute
    //
    typedef ::icalendar_2_0::ByminuteRecurType byminute_type;
    typedef ::xsd::cxx::tree::sequence< byminute_type > byminute_sequence;
    typedef byminute_sequence::iterator byminute_iterator;
    typedef byminute_sequence::const_iterator byminute_const_iterator;
    typedef ::xsd::cxx::tree::traits< byminute_type, char > byminute_traits;

    const byminute_sequence&
    byminute () const;

    byminute_sequence&
    byminute ();

    void
    byminute (const byminute_sequence& s);

    // byhour
    //
    typedef ::icalendar_2_0::ByhourRecurType byhour_type;
    typedef ::xsd::cxx::tree::sequence< byhour_type > byhour_sequence;
    typedef byhour_sequence::iterator byhour_iterator;
    typedef byhour_sequence::const_iterator byhour_const_iterator;
    typedef ::xsd::cxx::tree::traits< byhour_type, char > byhour_traits;

    const byhour_sequence&
    byhour () const;

    byhour_sequence&
    byhour ();

    void
    byhour (const byhour_sequence& s);

    // byday
    //
    typedef ::icalendar_2_0::BydayRecurType byday_type;
    typedef ::xsd::cxx::tree::sequence< byday_type > byday_sequence;
    typedef byday_sequence::iterator byday_iterator;
    typedef byday_sequence::const_iterator byday_const_iterator;
    typedef ::xsd::cxx::tree::traits< byday_type, char > byday_traits;

    const byday_sequence&
    byday () const;

    byday_sequence&
    byday ();

    void
    byday (const byday_sequence& s);

    // byyearday
    //
    typedef ::icalendar_2_0::ByyeardayRecurType byyearday_type;
    typedef ::xsd::cxx::tree::sequence< byyearday_type > byyearday_sequence;
    typedef byyearday_sequence::iterator byyearday_iterator;
    typedef byyearday_sequence::const_iterator byyearday_const_iterator;
    typedef ::xsd::cxx::tree::traits< byyearday_type, char > byyearday_traits;

    const byyearday_sequence&
    byyearday () const;

    byyearday_sequence&
    byyearday ();

    void
    byyearday (const byyearday_sequence& s);

    // bymonthday
    //
    typedef ::icalendar_2_0::BymonthdayRecurType bymonthday_type;
    typedef ::xsd::cxx::tree::sequence< bymonthday_type > bymonthday_sequence;
    typedef bymonthday_sequence::iterator bymonthday_iterator;
    typedef bymonthday_sequence::const_iterator bymonthday_const_iterator;
    typedef ::xsd::cxx::tree::traits< bymonthday_type, char > bymonthday_traits;

    const bymonthday_sequence&
    bymonthday () const;

    bymonthday_sequence&
    bymonthday ();

    void
    bymonthday (const bymonthday_sequence& s);

    // byweekno
    //
    typedef ::icalendar_2_0::ByweeknoRecurType byweekno_type;
    typedef ::xsd::cxx::tree::sequence< byweekno_type > byweekno_sequence;
    typedef byweekno_sequence::iterator byweekno_iterator;
    typedef byweekno_sequence::const_iterator byweekno_const_iterator;
    typedef ::xsd::cxx::tree::traits< byweekno_type, char > byweekno_traits;

    const byweekno_sequence&
    byweekno () const;

    byweekno_sequence&
    byweekno ();

    void
    byweekno (const byweekno_sequence& s);

    // bymonth
    //
    typedef ::icalendar_2_0::BymonthRecurType bymonth_type;
    typedef ::xsd::cxx::tree::sequence< bymonth_type > bymonth_sequence;
    typedef bymonth_sequence::iterator bymonth_iterator;
    typedef bymonth_sequence::const_iterator bymonth_const_iterator;
    typedef ::xsd::cxx::tree::traits< bymonth_type, char > bymonth_traits;

    const bymonth_sequence&
    bymonth () const;

    bymonth_sequence&
    bymonth ();

    void
    bymonth (const bymonth_sequence& s);

    // bysetpos
    //
    typedef ::xml_schema::integer bysetpos_type;
    typedef ::xsd::cxx::tree::sequence< bysetpos_type > bysetpos_sequence;
    typedef bysetpos_sequence::iterator bysetpos_iterator;
    typedef bysetpos_sequence::const_iterator bysetpos_const_iterator;
    typedef ::xsd::cxx::tree::traits< bysetpos_type, char > bysetpos_traits;

    const bysetpos_sequence&
    bysetpos () const;

    bysetpos_sequence&
    bysetpos ();

    void
    bysetpos (const bysetpos_sequence& s);

    // wkst
    //
    typedef ::icalendar_2_0::WeekdayRecurType wkst_type;
    typedef ::xsd::cxx::tree::optional< wkst_type > wkst_optional;
    typedef ::xsd::cxx::tree::traits< wkst_type, char > wkst_traits;

    const wkst_optional&
    wkst () const;

    wkst_optional&
    wkst ();

    void
    wkst (const wkst_type& x);

    void
    wkst (const wkst_optional& x);

    void
    wkst (::std::unique_ptr< wkst_type > p);

    // Constructors.
    //
    RecurType (const freq_type&);

    RecurType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    RecurType (const RecurType& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual RecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    RecurType&
    operator= (const RecurType& x);

    virtual 
    ~RecurType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< freq_type > freq_;
    until_optional until_;
    count_optional count_;
    interval_optional interval_;
    bysecond_sequence bysecond_;
    byminute_sequence byminute_;
    byhour_sequence byhour_;
    byday_sequence byday_;
    byyearday_sequence byyearday_;
    bymonthday_sequence bymonthday_;
    byweekno_sequence byweekno_;
    bymonth_sequence bymonth_;
    bysetpos_sequence bysetpos_;
    wkst_optional wkst_;
  };

  class FreqRecurType: public ::xml_schema::token
  {
    public:
    enum value
    {
      SECONDLY,
      MINUTELY,
      HOURLY,
      DAILY,
      WEEKLY,
      MONTHLY,
      YEARLY
    };

    FreqRecurType (value v);

    FreqRecurType (const char* v);

    FreqRecurType (const ::std::string& v);

    FreqRecurType (const ::xml_schema::token& v);

    FreqRecurType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    FreqRecurType (const ::xercesc::DOMAttr& a,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    FreqRecurType (const ::std::string& s,
                   const ::xercesc::DOMElement* e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    FreqRecurType (const FreqRecurType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    FreqRecurType&
    operator= (const FreqRecurType&) = default;
#endif

    virtual FreqRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    FreqRecurType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_FreqRecurType_convert ();
    }

    protected:
    value
    _xsd_FreqRecurType_convert () const;

    public:
    static const char* const _xsd_FreqRecurType_literals_[7];
    static const value _xsd_FreqRecurType_indexes_[7];
  };

  class UntilRecurType: public ::xml_schema::type
  {
    public:
    // date
    //
    typedef ::xml_schema::date date_type;
    typedef ::xsd::cxx::tree::optional< date_type > date_optional;
    typedef ::xsd::cxx::tree::traits< date_type, char > date_traits;

    const date_optional&
    date () const;

    date_optional&
    date ();

    void
    date (const date_type& x);

    void
    date (const date_optional& x);

    void
    date (::std::unique_ptr< date_type > p);

    // date-time
    //
    typedef ::icalendar_2_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::optional< date_time_type > date_time_optional;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_optional&
    date_time () const;

    date_time_optional&
    date_time ();

    void
    date_time (const date_time_type& x);

    void
    date_time (const date_time_optional& x);

    void
    date_time (::std::unique_ptr< date_time_type > p);

    // Constructors.
    //
    UntilRecurType ();

    UntilRecurType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    UntilRecurType (const UntilRecurType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual UntilRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    UntilRecurType&
    operator= (const UntilRecurType& x);

    virtual 
    ~UntilRecurType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    date_optional date_;
    date_time_optional date_time_;
  };

  class WeekdayRecurType: public ::xml_schema::token
  {
    public:
    enum value
    {
      SU,
      MO,
      TU,
      WE,
      TH,
      FR,
      SA
    };

    WeekdayRecurType (value v);

    WeekdayRecurType (const char* v);

    WeekdayRecurType (const ::std::string& v);

    WeekdayRecurType (const ::xml_schema::token& v);

    WeekdayRecurType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    WeekdayRecurType (const ::xercesc::DOMAttr& a,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    WeekdayRecurType (const ::std::string& s,
                      const ::xercesc::DOMElement* e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    WeekdayRecurType (const WeekdayRecurType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    WeekdayRecurType&
    operator= (const WeekdayRecurType&) = default;
#endif

    virtual WeekdayRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    WeekdayRecurType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_WeekdayRecurType_convert ();
    }

    protected:
    value
    _xsd_WeekdayRecurType_convert () const;

    public:
    static const char* const _xsd_WeekdayRecurType_literals_[7];
    static const value _xsd_WeekdayRecurType_indexes_[7];
  };

  class BysecondRecurType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    BysecondRecurType (const ::xml_schema::non_negative_integer&);

    BysecondRecurType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BysecondRecurType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BysecondRecurType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BysecondRecurType (const BysecondRecurType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual BysecondRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    BysecondRecurType&
    operator= (const BysecondRecurType&) = default;
#endif

    virtual 
    ~BysecondRecurType ();
  };

  class ByminuteRecurType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    ByminuteRecurType (const ::xml_schema::non_negative_integer&);

    ByminuteRecurType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ByminuteRecurType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ByminuteRecurType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ByminuteRecurType (const ByminuteRecurType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual ByminuteRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ByminuteRecurType&
    operator= (const ByminuteRecurType&) = default;
#endif

    virtual 
    ~ByminuteRecurType ();
  };

  class ByhourRecurType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    ByhourRecurType (const ::xml_schema::non_negative_integer&);

    ByhourRecurType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ByhourRecurType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ByhourRecurType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ByhourRecurType (const ByhourRecurType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual ByhourRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ByhourRecurType&
    operator= (const ByhourRecurType&) = default;
#endif

    virtual 
    ~ByhourRecurType ();
  };

  class BydayRecurType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    BydayRecurType ();

    BydayRecurType (const char*);

    BydayRecurType (const ::std::string&);

    BydayRecurType (const ::xml_schema::string&);

    BydayRecurType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    BydayRecurType (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    BydayRecurType (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    BydayRecurType (const BydayRecurType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual BydayRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    BydayRecurType&
    operator= (const BydayRecurType&) = default;
#endif

    virtual 
    ~BydayRecurType ();
  };

  class ByyeardayRecurType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    ByyeardayRecurType (const ::xml_schema::integer&);

    ByyeardayRecurType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    ByyeardayRecurType (const ::xercesc::DOMAttr& a,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    ByyeardayRecurType (const ::std::string& s,
                        const ::xercesc::DOMElement* e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    ByyeardayRecurType (const ByyeardayRecurType& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual ByyeardayRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ByyeardayRecurType&
    operator= (const ByyeardayRecurType&) = default;
#endif

    virtual 
    ~ByyeardayRecurType ();
  };

  class BymonthdayRecurType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    BymonthdayRecurType (const ::xml_schema::integer&);

    BymonthdayRecurType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    BymonthdayRecurType (const ::xercesc::DOMAttr& a,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    BymonthdayRecurType (const ::std::string& s,
                         const ::xercesc::DOMElement* e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    BymonthdayRecurType (const BymonthdayRecurType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual BymonthdayRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    BymonthdayRecurType&
    operator= (const BymonthdayRecurType&) = default;
#endif

    virtual 
    ~BymonthdayRecurType ();
  };

  class ByweeknoRecurType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    ByweeknoRecurType (const ::xml_schema::integer&);

    ByweeknoRecurType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ByweeknoRecurType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ByweeknoRecurType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ByweeknoRecurType (const ByweeknoRecurType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual ByweeknoRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ByweeknoRecurType&
    operator= (const ByweeknoRecurType&) = default;
#endif

    virtual 
    ~ByweeknoRecurType ();
  };

  class BymonthRecurType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    BymonthRecurType (const ::xml_schema::integer&);

    BymonthRecurType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    BymonthRecurType (const ::xercesc::DOMAttr& a,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    BymonthRecurType (const ::std::string& s,
                      const ::xercesc::DOMElement* e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    BymonthRecurType (const BymonthRecurType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual BymonthRecurType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    BymonthRecurType&
    operator= (const BymonthRecurType&) = default;
#endif

    virtual 
    ~BymonthRecurType ();
  };

  class UriType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    UriType ();

    UriType (const char*);

    UriType (const ::std::string&);

    UriType (const ::xml_schema::string&);

    UriType (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    UriType (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    UriType (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    UriType (const UriType& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual UriType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    UriType&
    operator= (const UriType&) = default;
#endif

    virtual 
    ~UriType ();
  };

  class UtcOffsetType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    UtcOffsetType ();

    UtcOffsetType (const char*);

    UtcOffsetType (const ::std::string&);

    UtcOffsetType (const ::xml_schema::string&);

    UtcOffsetType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    UtcOffsetType (const ::xercesc::DOMAttr& a,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    UtcOffsetType (const ::std::string& s,
                   const ::xercesc::DOMElement* e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    UtcOffsetType (const UtcOffsetType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual UtcOffsetType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    UtcOffsetType&
    operator= (const UtcOffsetType&) = default;
#endif

    virtual 
    ~UtcOffsetType ();
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace icalendar_2_0
{
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace icalendar_2_0
{
  void
  operator<< (::xercesc::DOMElement&, const CalAddressType&);

  void
  operator<< (::xercesc::DOMAttr&, const CalAddressType&);

  void
  operator<< (::xml_schema::list_stream&,
              const CalAddressType&);

  void
  operator<< (::xercesc::DOMElement&, const DateTimeType&);

  void
  operator<< (::xercesc::DOMAttr&, const DateTimeType&);

  void
  operator<< (::xml_schema::list_stream&,
              const DateTimeType&);

  void
  operator<< (::xercesc::DOMElement&, const UTCDateTimeType&);

  void
  operator<< (::xercesc::DOMAttr&, const UTCDateTimeType&);

  void
  operator<< (::xml_schema::list_stream&,
              const UTCDateTimeType&);

  void
  operator<< (::xercesc::DOMElement&, const DurationValueType&);

  void
  operator<< (::xercesc::DOMAttr&, const DurationValueType&);

  void
  operator<< (::xml_schema::list_stream&,
              const DurationValueType&);

  void
  operator<< (::xercesc::DOMElement&, const PeriodType&);

  void
  operator<< (::xercesc::DOMElement&, const RecurType&);

  void
  operator<< (::xercesc::DOMElement&, const FreqRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const FreqRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const FreqRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const UntilRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const WeekdayRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const WeekdayRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const WeekdayRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const BysecondRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const BysecondRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const BysecondRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const ByminuteRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const ByminuteRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ByminuteRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const ByhourRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const ByhourRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ByhourRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const BydayRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const BydayRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const BydayRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const ByyeardayRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const ByyeardayRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ByyeardayRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const BymonthdayRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const BymonthdayRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const BymonthdayRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const ByweeknoRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const ByweeknoRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ByweeknoRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const BymonthRecurType&);

  void
  operator<< (::xercesc::DOMAttr&, const BymonthRecurType&);

  void
  operator<< (::xml_schema::list_stream&,
              const BymonthRecurType&);

  void
  operator<< (::xercesc::DOMElement&, const UriType&);

  void
  operator<< (::xercesc::DOMAttr&, const UriType&);

  void
  operator<< (::xml_schema::list_stream&,
              const UriType&);

  void
  operator<< (::xercesc::DOMElement&, const UtcOffsetType&);

  void
  operator<< (::xercesc::DOMAttr&, const UtcOffsetType&);

  void
  operator<< (::xml_schema::list_stream&,
              const UtcOffsetType&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_VALTYPES_HXX
