/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5private.h"

H5_GCC_DIAG_OFF("larger-than=")
H5_CLANG_DIAG_OFF("overlength-strings")

const char H5build_settings[]=
    "       SUMMARY OF THE HDF5 CONFIGURATION\n"
    "       =================================\n"
    "\n"
    "General Information:\n"
    "-------------------\n"
    "                   HDF5 Version: 1.14.6\n"
    "                  Configured on: 2025-06-14\n"
    "                  Configured by: Unix Makefiles\n"
    "                    Host system:\n"
    "              Uname information: Linux\n"
    "                       Byte sex: \n"
    "             Installation point: /usr\n"
    "\n"
    "Compiling Options:\n"
    "------------------\n"
    "                     Build Mode: None\n"
    "              Debugging Symbols: OFF\n"
    "                        Asserts: OFF\n"
    "                      Profiling: OFF\n"
    "             Optimization Level: OFF\n"
    "\n"
    "Linking Options:\n"
    "----------------\n"
    "                      Libraries: \n"
    "  Statically Linked Executables: OFF\n"
    "                        LDFLAGS: -Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs -flto=auto\n"
    "                     H5_LDFLAGS: \n"
    "                     AM_LDFLAGS: \n"
    "                Extra libraries: m;dl\n"
    "                       Archiver: /usr/bin/ar\n"
    "                       AR_FLAGS: \n"
    "                         Ranlib: /usr/bin/ranlib\n"
    "\n"
    "Languages:\n"
    "----------\n"
    "                              C: YES\n"
    "                     C Compiler: /usr/bin/cc 15.1.1\n"
    "                       CPPFLAGS: \n"
    "                    H5_CPPFLAGS: \n"
    "                    AM_CPPFLAGS: \n"
    "                        C Flags:   -std=c99 -march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -g -ffile-prefix-map=/build/hdf5/src=/usr/src/debug/hdf5 -flto=auto -fstdarg-opt -fdiagnostics-urls=never -fno-diagnostics-color -fmessage-length=0\n"
    "                     H5 C Flags: -Wall;-Wcast-qual;-Wconversion;-Wextra;-Wfloat-equal;-Wformat=2;-Winit-self;-Winvalid-pch;-Wmissing-include-dirs;-Wshadow;-Wundef;-Wwrite-strings;-pedantic;-Wno-c++-compat;-Wbad-function-cast;-Wcast-align;-Wformat;-Wimplicit-function-declaration;-Wint-to-pointer-cast;-Wmissing-declarations;-Wmissing-prototypes;-Wnested-externs;-Wold-style-definition;-Wpacked;-Wpointer-sign;-Wpointer-to-int-cast;-Wredundant-decls;-Wstrict-prototypes;-Wswitch;-Wunused-but-set-variable;-Wunused-variable;-Wunused-function;-Wunused-parameter;-finline-functions;-Wno-aggregate-return;-Wno-inline;-Wno-missing-format-attribute;-Wno-missing-noreturn;-Wno-overlength-strings;-Wlarger-than=2560;-Wlogical-op;-Wframe-larger-than=16384;-Wpacked-bitfield-compat;-Wsync-nand;-Wno-unsuffixed-float-constants;-Wdouble-promotion;-Wtrampolines;-Wstack-usage=8192;-Wmaybe-uninitialized;-Wno-jump-misses-init;-Wstrict-overflow=2;-Wno-suggest-attribute=const;-Wno-suggest-attribute=noreturn;-Wno-suggest-attribute=pure;-Wno-suggest-attribute=format;-Wdate-time;-Warray-bounds=2;-Wc99-c11-compat;-Wincompatible-pointer-types;-Wint-conversion;-Wshadow;-Wduplicated-cond;-Whsa;-Wnormalized;-Wnull-dereference;-Wunused-const-variable;-Walloca;-Walloc-zero;-Wduplicated-branches;-Wformat-overflow=2;-Wformat-truncation=1;-Wrestrict;-Wattribute-alias;-Wshift-overflow=2;-Wcast-function-type;-Wmaybe-uninitialized;-Wcast-align=strict;-Wno-suggest-attribute=cold;-Wno-suggest-attribute=malloc;-Wattribute-alias=2;-Wmissing-profile;-Wc11-c2x-compat\n"
    "                     AM C Flags: \n"
    "               Shared C Library: YES\n"
    "               Static C Library: NO\n"
    "\n"
    "\n"
    "                        Fortran: ON\n"
    "               Fortran Compiler:  \n"
    "                  Fortran Flags: \n"
    "               H5 Fortran Flags: \n"
    "               AM Fortran Flags: \n"
    "         Shared Fortran Library: YES\n"
    "         Static Fortran Library: NO\n"
    "               Module Directory: /build/hdf5/src/hdf5-hdf5_1.14.6/build/mod\n"
    "\n"
    "                            C++: ON\n"
    "                   C++ Compiler:  \n"
    "                      C++ Flags: \n"
    "                   H5 C++ Flags: \n"
    "                   AM C++ Flags: \n"
    "             Shared C++ Library: YES\n"
    "             Static C++ Library: NO\n"
    "\n"
    "                           Java: ON\n"
    "                  Java Compiler:  \n"
    "\n"
    "\n"
    "Features:\n"
    "---------\n"
    "                     Parallel HDF5: OFF\n"
    "  Parallel Filtered Dataset Writes: \n"
    "                Large Parallel I/O: \n"
    "                High-level library: ON\n"
    "Dimension scales w/ new references: \n"
    "                  Build HDF5 Tests: \n"
    "                  Build HDF5 Tools: \n"
    "                   Build GIF Tools: \n"
    "                      Threadsafety: OFF\n"
    "               Default API mapping: v114\n"
    "    With deprecated public symbols: ON\n"
    "            I/O filters (external):  DEFLATE DECODE ENCODE\n"
    "                  _Float16 support: ON\n"
    "                     Map (H5M) API: \n"
    "                        Direct VFD: \n"
    "                        Mirror VFD: \n"
    "                     Subfiling VFD: \n"
    "                (Read-Only) S3 VFD: \n"
    "              (Read-Only) HDFS VFD: \n"
    "    Packages w/ extra debug output: \n"
    "                       API tracing: OFF\n"
    "              Using memory checker: OFF\n"
    "                  Use file locking: best-effort\n"
    "         Strict file format checks: OFF\n"
    "      Optimization instrumentation: \n"
;

H5_GCC_DIAG_ON("larger-than=")
H5_CLANG_DIAG_OFF("overlength-strings")
