#include "main.h"
#include "sysdeps.h"
#include "hatari-glue.h"
#include "maccess.h"
#include "memory.h"
#include "custom.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#include "debugmem.h"
#define SET_ALWAYS_CFLG(x) SET_CFLG(x)
#define SET_ALWAYS_NFLG(x) SET_NFLG(x)
#ifdef CPUEMU_0
const struct cputbl op_smalltbl_0[] = {
{ op_0000_0_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_0_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_0_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_0_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_0_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_0_ff, NULL, 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ op_0038_0_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_0_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_0_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_0_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_0_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_0_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_0_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_0_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_0_ff, NULL, 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ op_0078_0_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_0_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_0_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_0_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_0_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_0_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_0_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_0_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_0_ff, NULL, 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ op_00b8_0_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_0_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
#ifndef CPUEMU_68000_ONLY
{ op_00d0_0_ff, NULL, 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_00e8_0_ff, NULL, 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_00f0_0_ff, NULL, 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_00f8_0_ff, NULL, 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_00f9_0_ff, NULL, 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_00fa_0_ff, NULL, 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_00fb_0_ff, NULL, 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
{ op_0100_0_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_0_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_0_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_0_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_0_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_0_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_0_ff, NULL, 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ op_0138_0_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_0_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_0_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_0_ff, NULL, 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ op_013c_0_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_0_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_0_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_0_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_0_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_0_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_0_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_0_ff, NULL, 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ op_0178_0_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_0_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_0_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_0_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_0_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_0_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_0_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_0_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_0_ff, NULL, 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ op_01b8_0_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_0_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_0_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_0_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_0_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_0_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_0_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_0_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_0_ff, NULL, 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ op_01f8_0_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_0_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_0_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_0_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_0_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_0_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_0_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_0_ff, NULL, 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ op_0238_0_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_0_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_0_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_0_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_0_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_0_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_0_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_0_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_0_ff, NULL, 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ op_0278_0_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_0_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_0_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_0_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_0_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_0_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_0_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_0_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_0_ff, NULL, 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ op_02b8_0_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_0_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
#ifndef CPUEMU_68000_ONLY
{ op_02d0_0_ff, NULL, 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_02e8_0_ff, NULL, 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_02f0_0_ff, NULL, 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_02f8_0_ff, NULL, 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_02f9_0_ff, NULL, 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_02fa_0_ff, NULL, 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_02fb_0_ff, NULL, 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
{ op_0400_0_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_0_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_0_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_0_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_0_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_0_ff, NULL, 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0438_0_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_0_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_0_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_0_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_0_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_0_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_0_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_0_ff, NULL, 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0478_0_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_0_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_0_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_0_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_0_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_0_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_0_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_0_ff, NULL, 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ op_04b8_0_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_0_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
#ifndef CPUEMU_68000_ONLY
{ op_04d0_0_ff, NULL, 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_04e8_0_ff, NULL, 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_04f0_0_ff, NULL, 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_04f8_0_ff, NULL, 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_04f9_0_ff, NULL, 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_04fa_0_ff, NULL, 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_04fb_0_ff, NULL, 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
#endif
{ op_0600_0_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_0_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_0_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_0_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_0_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_0_ff, NULL, 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0638_0_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_0_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_0_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_0_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_0_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_0_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_0_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_0_ff, NULL, 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0678_0_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_0_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_0_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_0_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_0_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_0_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_0_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_0_ff, NULL, 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ op_06b8_0_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_0_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
#ifndef CPUEMU_68000_ONLY
{ op_06c0_0_ff, NULL, 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06c8_0_ff, NULL, 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06d0_0_ff, NULL, 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06e8_0_ff, NULL, 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06f0_0_ff, NULL, 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06f8_0_ff, NULL, 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06f9_0_ff, NULL, 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06fa_0_ff, NULL, 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_06fb_0_ff, NULL, 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
#endif
{ op_0800_0_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_0_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_0_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_0_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_0_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_0_ff, NULL, 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0838_0_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_0_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_0_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_0_ff, NULL, 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0840_0_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_0_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_0_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_0_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_0_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_0_ff, NULL, 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ op_0878_0_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_0_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_0_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_0_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_0_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_0_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_0_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_0_ff, NULL, 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ op_08b8_0_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_0_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_0_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_0_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_0_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_0_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_0_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_0_ff, NULL, 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ op_08f8_0_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_0_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_0_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_0_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_0_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_0_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_0_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_0_ff, NULL, 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a38_0_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_0_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_0_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_0_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_0_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_0_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_0_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_0_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_0_ff, NULL, 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a78_0_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_0_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_0_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_0_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_0_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_0_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_0_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_0_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_0_ff, NULL, 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ op_0ab8_0_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_0_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
#ifndef CPUEMU_68000_ONLY
{ op_0ad0_0_ff, NULL, 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ad8_0_ff, NULL, 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ae0_0_ff, NULL, 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ae8_0_ff, NULL, 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af0_0_ff, NULL, 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af8_0_ff, NULL, 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af9_0_ff, NULL, 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
{ op_0c00_0_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_0_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_0_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_0_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_0_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_0_ff, NULL, 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c38_0_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_0_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ op_0c3a_0_ff, NULL, 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0c3b_0_ff, NULL, 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
#endif
{ op_0c40_0_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_0_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_0_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_0_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_0_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_0_ff, NULL, 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c78_0_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_0_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ op_0c7a_0_ff, NULL, 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0c7b_0_ff, NULL, 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
#endif
{ op_0c80_0_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_0_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_0_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_0_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_0_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_0_ff, NULL, 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ op_0cb8_0_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_0_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ op_0cba_0_ff, NULL, 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cbb_0_ff, NULL, 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cd0_0_ff, NULL, 0x0cd0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cd8_0_ff, NULL, 0x0cd8, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ce0_0_ff, NULL, 0x0ce0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ce8_0_ff, NULL, 0x0ce8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf0_0_ff, NULL, 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf8_0_ff, NULL, 0x0cf8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf9_0_ff, NULL, 0x0cf9, 16, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cfc_0_ff, NULL, 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e10_0_ff, NULL, 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e18_0_ff, NULL, 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e20_0_ff, NULL, 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e28_0_ff, NULL, 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e30_0_ff, NULL, 0x0e30, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e38_0_ff, NULL, 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e39_0_ff, NULL, 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e50_0_ff, NULL, 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e58_0_ff, NULL, 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e60_0_ff, NULL, 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e68_0_ff, NULL, 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e70_0_ff, NULL, 0x0e70, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e78_0_ff, NULL, 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e79_0_ff, NULL, 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e90_0_ff, NULL, 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e98_0_ff, NULL, 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea0_0_ff, NULL, 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea8_0_ff, NULL, 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb0_0_ff, NULL, 0x0eb0, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb8_0_ff, NULL, 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb9_0_ff, NULL, 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ed0_0_ff, NULL, 0x0ed0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ed8_0_ff, NULL, 0x0ed8, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ee0_0_ff, NULL, 0x0ee0, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ee8_0_ff, NULL, 0x0ee8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef0_0_ff, NULL, 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef8_0_ff, NULL, 0x0ef8, 12, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef9_0_ff, NULL, 0x0ef9, 16, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0efc_0_ff, NULL, 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
{ op_1000_0_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_0_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_0_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_0_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_0_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_0_ff, NULL, 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1038_0_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_0_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_0_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_0_ff, NULL, 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_103c_0_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_0_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_0_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_0_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_0_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_0_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_0_ff, NULL, 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10b8_0_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_0_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_0_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_0_ff, NULL, 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10bc_0_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_0_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_0_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_0_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_0_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_0_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_0_ff, NULL, 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10f8_0_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_0_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_0_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_0_ff, NULL, 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10fc_0_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_0_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_0_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_0_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_0_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_0_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_0_ff, NULL, 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1138_0_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_0_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_0_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_0_ff, NULL, 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_113c_0_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_0_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_0_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_0_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_0_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_0_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_0_ff, NULL, 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1178_0_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_0_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_0_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_0_ff, NULL, 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_117c_0_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_0_ff, NULL, 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1190_0_ff, NULL, 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1198_0_ff, NULL, 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a0_0_ff, NULL, 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a8_0_ff, NULL, 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b0_0_ff, NULL, 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11b8_0_ff, NULL, 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b9_0_ff, NULL, 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_11ba_0_ff, NULL, 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11bb_0_ff, NULL, 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11bc_0_ff, NULL, 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11c0_0_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_0_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_0_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_0_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_0_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_0_ff, NULL, 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11f8_0_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_0_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_0_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_0_ff, NULL, 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11fc_0_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_0_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_0_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_0_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_0_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_0_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_0_ff, NULL, 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13f8_0_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_0_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_0_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_0_ff, NULL, 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13fc_0_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_0_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_0_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_0_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_0_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_0_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_0_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_0_ff, NULL, 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2038_0_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_0_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_0_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_0_ff, NULL, 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_203c_0_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_0_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_0_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_0_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_0_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_0_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_0_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_0_ff, NULL, 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_2078_0_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_0_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_0_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_0_ff, NULL, 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_207c_0_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_0_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_0_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_0_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_0_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_0_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_0_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_0_ff, NULL, 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20b8_0_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_0_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_0_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_0_ff, NULL, 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20bc_0_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_0_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_0_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_0_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_0_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_0_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_0_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_0_ff, NULL, 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20f8_0_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_0_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_0_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_0_ff, NULL, 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20fc_0_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_0_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_0_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_0_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_0_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_0_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_0_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_0_ff, NULL, 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2138_0_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_0_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_0_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_0_ff, NULL, 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_213c_0_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_0_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_0_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_0_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_0_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_0_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_0_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_0_ff, NULL, 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2178_0_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_0_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_0_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_0_ff, NULL, 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_217c_0_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_0_ff, NULL, 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2188_0_ff, NULL, 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2190_0_ff, NULL, 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2198_0_ff, NULL, 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a0_0_ff, NULL, 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a8_0_ff, NULL, 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b0_0_ff, NULL, 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21b8_0_ff, NULL, 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b9_0_ff, NULL, 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21ba_0_ff, NULL, 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21bb_0_ff, NULL, 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21bc_0_ff, NULL, 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21c0_0_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_0_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_0_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_0_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_0_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_0_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_0_ff, NULL, 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21f8_0_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_0_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_0_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_0_ff, NULL, 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21fc_0_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_0_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_0_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_0_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_0_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_0_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_0_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_0_ff, NULL, 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23f8_0_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_0_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_0_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_0_ff, NULL, 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23fc_0_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_0_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_0_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_0_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_0_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_0_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_0_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_0_ff, NULL, 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3038_0_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_0_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_0_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_0_ff, NULL, 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_303c_0_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_0_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_0_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_0_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_0_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_0_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_0_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_0_ff, NULL, 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_3078_0_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_0_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_0_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_0_ff, NULL, 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_307c_0_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_0_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_0_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_0_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_0_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_0_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_0_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_0_ff, NULL, 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30b8_0_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_0_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_0_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_0_ff, NULL, 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30bc_0_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_0_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_0_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_0_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_0_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_0_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_0_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_0_ff, NULL, 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30f8_0_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_0_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_0_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_0_ff, NULL, 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30fc_0_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_0_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_0_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_0_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_0_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_0_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_0_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_0_ff, NULL, 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3138_0_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_0_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_0_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_0_ff, NULL, 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_313c_0_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_0_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_0_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_0_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_0_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_0_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_0_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_0_ff, NULL, 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3178_0_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_0_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_0_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_0_ff, NULL, 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_317c_0_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_0_ff, NULL, 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3188_0_ff, NULL, 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3190_0_ff, NULL, 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3198_0_ff, NULL, 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a0_0_ff, NULL, 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a8_0_ff, NULL, 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b0_0_ff, NULL, 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31b8_0_ff, NULL, 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b9_0_ff, NULL, 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_31ba_0_ff, NULL, 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31bb_0_ff, NULL, 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31bc_0_ff, NULL, 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31c0_0_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_0_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_0_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_0_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_0_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_0_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_0_ff, NULL, 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31f8_0_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_0_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_0_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_0_ff, NULL, 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31fc_0_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_0_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_0_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_0_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_0_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_0_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_0_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_0_ff, NULL, 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33f8_0_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_0_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_0_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_0_ff, NULL, 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33fc_0_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_0_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_0_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_0_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_0_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_0_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_0_ff, NULL, 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4038_0_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_0_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_0_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_0_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_0_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_0_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_0_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_0_ff, NULL, 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4078_0_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_0_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_0_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_0_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_0_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_0_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_0_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_0_ff, NULL, 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_40b8_0_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_0_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_0_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_0_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_0_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_0_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_0_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_0_ff, NULL, 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ op_40f8_0_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_0_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#ifndef CPUEMU_68000_ONLY
{ op_4100_0_ff, NULL, 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4110_0_ff, NULL, 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4118_0_ff, NULL, 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4120_0_ff, NULL, 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4128_0_ff, NULL, 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4130_0_ff, NULL, 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4138_0_ff, NULL, 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4139_0_ff, NULL, 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_413a_0_ff, NULL, 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_413b_0_ff, NULL, 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_413c_0_ff, NULL, 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
#endif
{ op_4180_0_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_0_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_0_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_0_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_0_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_0_ff, NULL, 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41b8_0_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_0_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_0_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_0_ff, NULL, 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41bc_0_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_0_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_0_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_0_ff, NULL, 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ op_41f8_0_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_0_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_0_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_0_ff, NULL, 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ op_4200_0_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_0_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_0_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_0_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_0_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_0_ff, NULL, 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4238_0_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_0_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_0_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_0_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_0_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_0_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_0_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_0_ff, NULL, 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4278_0_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_0_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_0_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_0_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_0_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_0_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_0_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_0_ff, NULL, 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ op_42b8_0_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_0_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
#ifndef CPUEMU_68000_ONLY
{ op_42c0_0_ff, NULL, 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42d0_0_ff, NULL, 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42d8_0_ff, NULL, 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42e0_0_ff, NULL, 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42e8_0_ff, NULL, 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42f0_0_ff, NULL, 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42f8_0_ff, NULL, 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42f9_0_ff, NULL, 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#endif
{ op_4400_0_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_0_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_0_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_0_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_0_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_0_ff, NULL, 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4438_0_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_0_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_0_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_0_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_0_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_0_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_0_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_0_ff, NULL, 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4478_0_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_0_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_0_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_0_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_0_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_0_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_0_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_0_ff, NULL, 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ op_44b8_0_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_0_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_0_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_0_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_0_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_0_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_0_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_0_ff, NULL, 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44f8_0_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_0_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_0_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_0_ff, NULL, 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44fc_0_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_0_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_0_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_0_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_0_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_0_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_0_ff, NULL, 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4638_0_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_0_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_0_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_0_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_0_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_0_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_0_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_0_ff, NULL, 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4678_0_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_0_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_0_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_0_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_0_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_0_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_0_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_0_ff, NULL, 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ op_46b8_0_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_0_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_0_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_0_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_0_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_0_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_0_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_0_ff, NULL, 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46f8_0_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_0_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_0_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_0_ff, NULL, 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46fc_0_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_0_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
#ifndef CPUEMU_68000_ONLY
{ op_4808_0_ff, NULL, 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
#endif
{ op_4810_0_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_0_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_0_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_0_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_0_ff, NULL, 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ op_4838_0_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_0_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_0_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
#ifndef CPUEMU_68000_ONLY
{ op_4848_0_ff, NULL, 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
#endif
{ op_4850_0_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_0_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_0_ff, NULL, 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4878_0_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_0_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_0_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_0_ff, NULL, 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4880_0_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_0_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_0_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_0_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_0_ff, NULL, 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48b8_0_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_0_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_0_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_0_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_0_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_0_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_0_ff, NULL, 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48f8_0_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_0_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
#ifndef CPUEMU_68000_ONLY
{ op_49c0_0_ff, NULL, 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
#endif
{ op_4a00_0_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_0_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_0_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_0_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_0_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_0_ff, NULL, 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a38_0_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_0_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ op_4a3a_0_ff, NULL, 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4a3b_0_ff, NULL, 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4a3c_0_ff, NULL, 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
#endif
{ op_4a40_0_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ op_4a48_0_ff, NULL, 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
#endif
{ op_4a50_0_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_0_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_0_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_0_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_0_ff, NULL, 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a78_0_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_0_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ op_4a7a_0_ff, NULL, 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4a7b_0_ff, NULL, 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4a7c_0_ff, NULL, 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
#endif
{ op_4a80_0_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ op_4a88_0_ff, NULL, 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
#endif
{ op_4a90_0_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_0_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_0_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_0_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_0_ff, NULL, 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ op_4ab8_0_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_0_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
#ifndef CPUEMU_68000_ONLY
{ op_4aba_0_ff, NULL, 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4abb_0_ff, NULL, 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4abc_0_ff, NULL, 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
#endif
{ op_4ac0_0_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
#ifndef CPUEMU_68000_ONLY
{ op_4ac8_0_ff, NULL, 0x4ac8, 2, { 0, 0 }, 0 }, /* HALT */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4acc_0_ff, NULL, 0x4acc, 2, { 0, 0 }, 0 }, /* PULSE */
#endif
{ op_4ad0_0_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_0_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_0_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_0_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_0_ff, NULL, 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ op_4af8_0_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_0_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
#ifndef CPUEMU_68000_ONLY
{ op_4c00_0_ff, NULL, 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c10_0_ff, NULL, 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c18_0_ff, NULL, 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c20_0_ff, NULL, 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c28_0_ff, NULL, 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c30_0_ff, NULL, 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c38_0_ff, NULL, 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c39_0_ff, NULL, 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c3a_0_ff, NULL, 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c3b_0_ff, NULL, 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c3c_0_ff, NULL, 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c40_0_ff, NULL, 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c50_0_ff, NULL, 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c58_0_ff, NULL, 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c60_0_ff, NULL, 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c68_0_ff, NULL, 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c70_0_ff, NULL, 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c78_0_ff, NULL, 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c79_0_ff, NULL, 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c7a_0_ff, NULL, 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c7b_0_ff, NULL, 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4c7c_0_ff, NULL, 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
#endif
{ op_4c90_0_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_0_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_0_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_0_ff, NULL, 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cb8_0_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_0_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_0_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_0_ff, NULL, 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cd0_0_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_0_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_0_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_0_ff, NULL, 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cf8_0_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_0_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_0_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_0_ff, NULL, 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4e40_0_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_0_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_0_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_0_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_0_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_0_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_0_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_0_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_0_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
#ifndef CPUEMU_68000_ONLY
{ op_4e74_0_ff, NULL, 0x4e74, 4, { 0, 0 }, 2 }, /* RTD */
#endif
{ op_4e75_0_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_0_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_0_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
#ifndef CPUEMU_68000_ONLY
{ op_4e7a_0_ff, NULL, 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4e7b_0_ff, NULL, 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ op_4e90_0_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_0_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_0_ff, NULL, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4eb8_0_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_0_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_0_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_0_ff, NULL, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4ed0_0_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_0_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_0_ff, NULL, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ op_4ef8_0_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_0_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_0_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_0_ff, NULL, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ op_5000_0_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_0_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_0_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_0_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_0_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_0_ff, NULL, 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5038_0_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_0_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_0_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_0_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_0_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_0_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_0_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_0_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_0_ff, NULL, 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5078_0_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_0_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_0_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_0_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_0_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_0_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_0_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_0_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_0_ff, NULL, 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_50b8_0_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_0_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_0_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_0_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_0_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_0_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_0_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_0_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_0_ff, NULL, 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_50f8_0_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_0_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_50fa_0_ff, NULL, 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_50fb_0_ff, NULL, 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_50fc_0_ff, NULL, 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_5100_0_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_0_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_0_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_0_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_0_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_0_ff, NULL, 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5138_0_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_0_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_0_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_0_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_0_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_0_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_0_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_0_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_0_ff, NULL, 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5178_0_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_0_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_0_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_0_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_0_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_0_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_0_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_0_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_0_ff, NULL, 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_51b8_0_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_0_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_0_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_0_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_0_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_0_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_0_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_0_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_0_ff, NULL, 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_51f8_0_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_0_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_51fa_0_ff, NULL, 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_51fb_0_ff, NULL, 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_51fc_0_ff, NULL, 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_52c0_0_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_0_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_0_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_0_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_0_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_0_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_0_ff, NULL, 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_52f8_0_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_0_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_52fa_0_ff, NULL, 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_52fb_0_ff, NULL, 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_52fc_0_ff, NULL, 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_53c0_0_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_0_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_0_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_0_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_0_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_0_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_0_ff, NULL, 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_53f8_0_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_0_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_53fa_0_ff, NULL, 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_53fb_0_ff, NULL, 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_53fc_0_ff, NULL, 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_54c0_0_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_0_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_0_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_0_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_0_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_0_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_0_ff, NULL, 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_54f8_0_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_0_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_54fa_0_ff, NULL, 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_54fb_0_ff, NULL, 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_54fc_0_ff, NULL, 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_55c0_0_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_0_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_0_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_0_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_0_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_0_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_0_ff, NULL, 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_55f8_0_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_0_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_55fa_0_ff, NULL, 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_55fb_0_ff, NULL, 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_55fc_0_ff, NULL, 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_56c0_0_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_0_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_0_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_0_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_0_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_0_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_0_ff, NULL, 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_56f8_0_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_0_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_56fa_0_ff, NULL, 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_56fb_0_ff, NULL, 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_56fc_0_ff, NULL, 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_57c0_0_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_0_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_0_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_0_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_0_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_0_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_0_ff, NULL, 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_57f8_0_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_0_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_57fa_0_ff, NULL, 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_57fb_0_ff, NULL, 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_57fc_0_ff, NULL, 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_58c0_0_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_0_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_0_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_0_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_0_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_0_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_0_ff, NULL, 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_58f8_0_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_0_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_58fa_0_ff, NULL, 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_58fb_0_ff, NULL, 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_58fc_0_ff, NULL, 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_59c0_0_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_0_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_0_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_0_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_0_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_0_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_0_ff, NULL, 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_59f8_0_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_0_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_59fa_0_ff, NULL, 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_59fb_0_ff, NULL, 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_59fc_0_ff, NULL, 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_5ac0_0_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_0_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_0_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_0_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_0_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_0_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_0_ff, NULL, 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5af8_0_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_0_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_5afa_0_ff, NULL, 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5afb_0_ff, NULL, 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5afc_0_ff, NULL, 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_5bc0_0_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_0_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_0_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_0_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_0_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_0_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_0_ff, NULL, 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5bf8_0_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_0_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_5bfa_0_ff, NULL, 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5bfb_0_ff, NULL, 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5bfc_0_ff, NULL, 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_5cc0_0_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_0_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_0_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_0_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_0_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_0_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_0_ff, NULL, 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5cf8_0_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_0_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_5cfa_0_ff, NULL, 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5cfb_0_ff, NULL, 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5cfc_0_ff, NULL, 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_5dc0_0_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_0_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_0_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_0_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_0_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_0_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_0_ff, NULL, 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5df8_0_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_0_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_5dfa_0_ff, NULL, 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5dfb_0_ff, NULL, 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5dfc_0_ff, NULL, 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_5ec0_0_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_0_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_0_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_0_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_0_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_0_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_0_ff, NULL, 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ef8_0_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_0_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_5efa_0_ff, NULL, 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5efb_0_ff, NULL, 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5efc_0_ff, NULL, 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_5fc0_0_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_0_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_0_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_0_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_0_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_0_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_0_ff, NULL, 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ff8_0_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_0_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
#ifndef CPUEMU_68000_ONLY
{ op_5ffa_0_ff, NULL, 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5ffb_0_ff, NULL, 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_5ffc_0_ff, NULL, 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
#endif
{ op_6000_0_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_0_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_0_ff, NULL, 0x60ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6100_0_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_0_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_0_ff, NULL, 0x61ff, 6, { 0, 0 }, 3 }, /* BSR */
{ op_6200_0_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_0_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_0_ff, NULL, 0x62ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6300_0_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_0_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_0_ff, NULL, 0x63ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6400_0_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_0_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_0_ff, NULL, 0x64ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6500_0_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_0_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_0_ff, NULL, 0x65ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6600_0_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_0_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_0_ff, NULL, 0x66ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6700_0_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_0_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_0_ff, NULL, 0x67ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6800_0_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_0_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_0_ff, NULL, 0x68ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6900_0_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_0_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_0_ff, NULL, 0x69ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6a00_0_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_0_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_0_ff, NULL, 0x6aff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6b00_0_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_0_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_0_ff, NULL, 0x6bff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6c00_0_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_0_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_0_ff, NULL, 0x6cff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6d00_0_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_0_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_0_ff, NULL, 0x6dff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6e00_0_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_0_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_0_ff, NULL, 0x6eff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6f00_0_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_0_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_0_ff, NULL, 0x6fff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_7000_0_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_0_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_0_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_0_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_0_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_0_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_0_ff, NULL, 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ op_8038_0_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_0_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_0_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_0_ff, NULL, 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ op_803c_0_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_0_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_0_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_0_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_0_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_0_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_0_ff, NULL, 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ op_8078_0_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_0_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_0_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_0_ff, NULL, 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ op_807c_0_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_0_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_0_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_0_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_0_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_0_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_0_ff, NULL, 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_80b8_0_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_0_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_0_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_0_ff, NULL, 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ op_80bc_0_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_0_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_0_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_0_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_0_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_0_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_0_ff, NULL, 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80f8_0_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_0_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_0_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_0_ff, NULL, 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80fc_0_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_0_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_0_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_0_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_0_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_0_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_0_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_0_ff, NULL, 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ op_8138_0_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_0_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
#ifndef CPUEMU_68000_ONLY
{ op_8140_0_ff, NULL, 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_8148_0_ff, NULL, 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
#endif
{ op_8150_0_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_0_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_0_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_0_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_0_ff, NULL, 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ op_8178_0_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_0_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
#ifndef CPUEMU_68000_ONLY
{ op_8180_0_ff, NULL, 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_8188_0_ff, NULL, 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
#endif
{ op_8190_0_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_0_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_0_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_0_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_0_ff, NULL, 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_81b8_0_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_0_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_0_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_0_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_0_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_0_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_0_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_0_ff, NULL, 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81f8_0_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_0_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_0_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_0_ff, NULL, 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81fc_0_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_0_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_0_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_0_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_0_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_0_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_0_ff, NULL, 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9038_0_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_0_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_0_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_0_ff, NULL, 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_903c_0_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_0_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_0_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_0_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_0_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_0_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_0_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_0_ff, NULL, 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9078_0_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_0_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_0_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_0_ff, NULL, 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_907c_0_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_0_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_0_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_0_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_0_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_0_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_0_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_0_ff, NULL, 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90b8_0_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_0_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_0_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_0_ff, NULL, 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90bc_0_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_0_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_0_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_0_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_0_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_0_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_0_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_0_ff, NULL, 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90f8_0_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_0_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_0_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_0_ff, NULL, 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90fc_0_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_0_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_0_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_0_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_0_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_0_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_0_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_0_ff, NULL, 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9138_0_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_0_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_0_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_0_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_0_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_0_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_0_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_0_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_0_ff, NULL, 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9178_0_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_0_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_0_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_0_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_0_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_0_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_0_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_0_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_0_ff, NULL, 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_91b8_0_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_0_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_0_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_0_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_0_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_0_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_0_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_0_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_0_ff, NULL, 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91f8_0_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_0_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_0_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_0_ff, NULL, 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91fc_0_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_0_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_0_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_0_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_0_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_0_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_0_ff, NULL, 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b038_0_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_0_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_0_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_0_ff, NULL, 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b03c_0_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_0_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_0_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_0_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_0_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_0_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_0_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_0_ff, NULL, 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b078_0_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_0_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_0_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_0_ff, NULL, 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b07c_0_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_0_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_0_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_0_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_0_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_0_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_0_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_0_ff, NULL, 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0b8_0_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_0_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_0_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_0_ff, NULL, 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0bc_0_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_0_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_0_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_0_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_0_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_0_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_0_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_0_ff, NULL, 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0f8_0_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_0_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_0_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_0_ff, NULL, 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0fc_0_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_0_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_0_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_0_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_0_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_0_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_0_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_0_ff, NULL, 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b138_0_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_0_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_0_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_0_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_0_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_0_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_0_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_0_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_0_ff, NULL, 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b178_0_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_0_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_0_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_0_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_0_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_0_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_0_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_0_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_0_ff, NULL, 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b1b8_0_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_0_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_0_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_0_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_0_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_0_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_0_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_0_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_0_ff, NULL, 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1f8_0_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_0_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_0_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_0_ff, NULL, 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1fc_0_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_0_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_0_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_0_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_0_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_0_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_0_ff, NULL, 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ op_c038_0_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_0_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_0_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_0_ff, NULL, 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c03c_0_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_0_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_0_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_0_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_0_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_0_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_0_ff, NULL, 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ op_c078_0_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_0_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_0_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_0_ff, NULL, 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c07c_0_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_0_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_0_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_0_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_0_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_0_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_0_ff, NULL, 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0b8_0_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_0_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_0_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_0_ff, NULL, 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0bc_0_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_0_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_0_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_0_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_0_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_0_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_0_ff, NULL, 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0f8_0_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_0_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_0_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_0_ff, NULL, 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0fc_0_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_0_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_0_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_0_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_0_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_0_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_0_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_0_ff, NULL, 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ op_c138_0_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_0_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_0_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_0_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_0_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_0_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_0_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_0_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_0_ff, NULL, 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ op_c178_0_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_0_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_0_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_0_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_0_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_0_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_0_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_0_ff, NULL, 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c1b8_0_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_0_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_0_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_0_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_0_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_0_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_0_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_0_ff, NULL, 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1f8_0_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_0_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_0_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_0_ff, NULL, 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1fc_0_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_0_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_0_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_0_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_0_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_0_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_0_ff, NULL, 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d038_0_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_0_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_0_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_0_ff, NULL, 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d03c_0_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_0_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_0_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_0_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_0_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_0_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_0_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_0_ff, NULL, 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d078_0_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_0_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_0_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_0_ff, NULL, 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d07c_0_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_0_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_0_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_0_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_0_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_0_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_0_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_0_ff, NULL, 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0b8_0_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_0_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_0_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_0_ff, NULL, 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0bc_0_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_0_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_0_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_0_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_0_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_0_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_0_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_0_ff, NULL, 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0f8_0_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_0_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_0_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_0_ff, NULL, 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0fc_0_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_0_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_0_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_0_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_0_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_0_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_0_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_0_ff, NULL, 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d138_0_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_0_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_0_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_0_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_0_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_0_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_0_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_0_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_0_ff, NULL, 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d178_0_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_0_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_0_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_0_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_0_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_0_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_0_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_0_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_0_ff, NULL, 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d1b8_0_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_0_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_0_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_0_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_0_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_0_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_0_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_0_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_0_ff, NULL, 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1f8_0_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_0_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_0_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_0_ff, NULL, 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1fc_0_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_0_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_0_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_0_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_0_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_0_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_0_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_0_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_0_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_0_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_0_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_0_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_0_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_0_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_0_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_0_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_0_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_0_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_0_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_0_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_0_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_0_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_0_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_0_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_0_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_0_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_0_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_0_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_0_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_0_ff, NULL, 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ op_e0f8_0_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_0_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_0_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_0_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_0_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_0_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_0_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_0_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_0_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_0_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_0_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_0_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_0_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_0_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_0_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_0_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_0_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_0_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_0_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_0_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_0_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_0_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_0_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_0_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_0_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_0_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_0_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_0_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_0_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_0_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_0_ff, NULL, 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ op_e1f8_0_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_0_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_0_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_0_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_0_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_0_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_0_ff, NULL, 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ op_e2f8_0_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_0_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_0_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_0_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_0_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_0_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_0_ff, NULL, 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ op_e3f8_0_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_0_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_0_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_0_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_0_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_0_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_0_ff, NULL, 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ op_e4f8_0_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_0_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_0_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_0_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_0_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_0_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_0_ff, NULL, 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ op_e5f8_0_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_0_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_0_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_0_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_0_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_0_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_0_ff, NULL, 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ op_e6f8_0_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_0_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_0_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_0_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_0_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_0_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_0_ff, NULL, 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ op_e7f8_0_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_0_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
#ifndef CPUEMU_68000_ONLY
{ op_e8c0_0_ff, NULL, 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e8d0_0_ff, NULL, 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e8e8_0_ff, NULL, 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e8f0_0_ff, NULL, 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e8f8_0_ff, NULL, 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e8f9_0_ff, NULL, 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e8fa_0_ff, NULL, 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e8fb_0_ff, NULL, 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9c0_0_ff, NULL, 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9d0_0_ff, NULL, 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9e8_0_ff, NULL, 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9f0_0_ff, NULL, 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9f8_0_ff, NULL, 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9f9_0_ff, NULL, 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9fa_0_ff, NULL, 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_e9fb_0_ff, NULL, 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eac0_0_ff, NULL, 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ead0_0_ff, NULL, 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eae8_0_ff, NULL, 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eaf0_0_ff, NULL, 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eaf8_0_ff, NULL, 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eaf9_0_ff, NULL, 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebc0_0_ff, NULL, 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebd0_0_ff, NULL, 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebe8_0_ff, NULL, 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebf0_0_ff, NULL, 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebf8_0_ff, NULL, 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebf9_0_ff, NULL, 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebfa_0_ff, NULL, 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ebfb_0_ff, NULL, 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ecc0_0_ff, NULL, 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ecd0_0_ff, NULL, 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ece8_0_ff, NULL, 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ecf0_0_ff, NULL, 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ecf8_0_ff, NULL, 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ecf9_0_ff, NULL, 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_edc0_0_ff, NULL, 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_edd0_0_ff, NULL, 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_ede8_0_ff, NULL, 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_edf0_0_ff, NULL, 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_edf8_0_ff, NULL, 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_edf9_0_ff, NULL, 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_edfa_0_ff, NULL, 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_edfb_0_ff, NULL, 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eec0_0_ff, NULL, 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eed0_0_ff, NULL, 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eee8_0_ff, NULL, 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eef0_0_ff, NULL, 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eef8_0_ff, NULL, 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eef9_0_ff, NULL, 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_efc0_0_ff, NULL, 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_efd0_0_ff, NULL, 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_efe8_0_ff, NULL, 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eff0_0_ff, NULL, 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eff8_0_ff, NULL, 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_eff9_0_ff, NULL, 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f000_0_ff, NULL, 0xf000, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f008_0_ff, NULL, 0xf008, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f010_0_ff, NULL, 0xf010, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f018_0_ff, NULL, 0xf018, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f020_0_ff, NULL, 0xf020, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f028_0_ff, NULL, 0xf028, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f030_0_ff, NULL, 0xf030, -1, { -3, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f038_0_ff, NULL, 0xf038, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f039_0_ff, NULL, 0xf039, -1, { 0, 0 }, 0 }, /* MMUOP030 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f200_0_ff, NULL, 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f208_0_ff, NULL, 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f210_0_ff, NULL, 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f218_0_ff, NULL, 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f220_0_ff, NULL, 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f228_0_ff, NULL, 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f230_0_ff, NULL, 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f238_0_ff, NULL, 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f239_0_ff, NULL, 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f23a_0_ff, NULL, 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f23b_0_ff, NULL, 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f23c_0_ff, NULL, 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f240_0_ff, NULL, 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f248_0_ff, NULL, 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f250_0_ff, NULL, 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f258_0_ff, NULL, 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f260_0_ff, NULL, 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f268_0_ff, NULL, 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f270_0_ff, NULL, 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f278_0_ff, NULL, 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f279_0_ff, NULL, 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f27a_0_ff, NULL, 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f27b_0_ff, NULL, 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f27c_0_ff, NULL, 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f280_0_ff, NULL, 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f2c0_0_ff, NULL, 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f310_0_ff, NULL, 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f320_0_ff, NULL, 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f328_0_ff, NULL, 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f330_0_ff, NULL, 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f338_0_ff, NULL, 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f339_0_ff, NULL, 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f350_0_ff, NULL, 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f358_0_ff, NULL, 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f368_0_ff, NULL, 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f370_0_ff, NULL, 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f378_0_ff, NULL, 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f379_0_ff, NULL, 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f37a_0_ff, NULL, 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f37b_0_ff, NULL, 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f408_0_ff, NULL, 0xf408, -1, { 0, 0 }, 0 }, /* CINVL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f410_0_ff, NULL, 0xf410, -1, { 0, 0 }, 0 }, /* CINVP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f418_0_ff, NULL, 0xf418, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f419_0_ff, NULL, 0xf419, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f41a_0_ff, NULL, 0xf41a, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f41b_0_ff, NULL, 0xf41b, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f41c_0_ff, NULL, 0xf41c, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f41d_0_ff, NULL, 0xf41d, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f41e_0_ff, NULL, 0xf41e, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f41f_0_ff, NULL, 0xf41f, -1, { 0, 0 }, 0 }, /* CINVA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f428_0_ff, NULL, 0xf428, -1, { 0, 0 }, 0 }, /* CPUSHL */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f430_0_ff, NULL, 0xf430, -1, { 0, 0 }, 0 }, /* CPUSHP */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f438_0_ff, NULL, 0xf438, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f439_0_ff, NULL, 0xf439, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f43a_0_ff, NULL, 0xf43a, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f43b_0_ff, NULL, 0xf43b, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f43c_0_ff, NULL, 0xf43c, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f43d_0_ff, NULL, 0xf43d, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f43e_0_ff, NULL, 0xf43e, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f43f_0_ff, NULL, 0xf43f, -1, { 0, 0 }, 0 }, /* CPUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f500_0_ff, NULL, 0xf500, -1, { 0, 0 }, 0 }, /* PFLUSHN */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f508_0_ff, NULL, 0xf508, -1, { 0, 0 }, 0 }, /* PFLUSH */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f510_0_ff, NULL, 0xf510, -1, { 0, 0 }, 0 }, /* PFLUSHAN */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f518_0_ff, NULL, 0xf518, -1, { 0, 0 }, 0 }, /* PFLUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f548_0_ff, NULL, 0xf548, -1, { 0, 0 }, 0 }, /* PTESTW */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f568_0_ff, NULL, 0xf568, -1, { 0, 0 }, 0 }, /* PTESTR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f588_0_ff, NULL, 0xf588, -1, { 0, 0 }, 0 }, /* PLPAW */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f5c8_0_ff, NULL, 0xf5c8, -1, { 0, 0 }, 0 }, /* PLPAR */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f600_0_ff, NULL, 0xf600, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f608_0_ff, NULL, 0xf608, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f610_0_ff, NULL, 0xf610, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f618_0_ff, NULL, 0xf618, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f620_0_ff, NULL, 0xf620, -1, { 0, 0 }, 0 }, /* MOVE16 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f800_0_ff, NULL, 0xf800, -1, { 0, 0 }, 0 }, /* LPSTOP */
#endif
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_0 */
#ifndef CPUEMU_68000_ONLY
const struct cputbl op_smalltbl_1[] = {
{ op_0000_0_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_0_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_0_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_0_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_0_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_0_ff, NULL, 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ op_0038_0_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_0_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_1_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_0_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_0_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_0_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_0_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_0_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_0_ff, NULL, 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ op_0078_0_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_0_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_1_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_0_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_0_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_0_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_0_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_0_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_0_ff, NULL, 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ op_00b8_0_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_0_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ op_00d0_0_ff, NULL, 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_00e8_0_ff, NULL, 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00f0_0_ff, NULL, 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_00f8_0_ff, NULL, 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00f9_0_ff, NULL, 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_00fa_0_ff, NULL, 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00fb_0_ff, NULL, 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0100_0_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_0_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_0_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_0_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_0_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_0_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_0_ff, NULL, 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ op_0138_0_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_0_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_0_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_0_ff, NULL, 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ op_013c_0_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_0_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_0_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_0_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_0_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_0_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_0_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_0_ff, NULL, 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ op_0178_0_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_0_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_0_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_0_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_0_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_0_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_0_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_0_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_0_ff, NULL, 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ op_01b8_0_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_0_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_0_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_0_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_0_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_0_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_0_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_0_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_0_ff, NULL, 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ op_01f8_0_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_0_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_0_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_0_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_0_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_0_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_0_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_0_ff, NULL, 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ op_0238_0_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_0_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_1_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_0_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_0_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_0_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_0_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_0_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_0_ff, NULL, 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ op_0278_0_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_0_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_1_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_0_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_0_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_0_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_0_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_0_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_0_ff, NULL, 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ op_02b8_0_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_0_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ op_02d0_0_ff, NULL, 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_02e8_0_ff, NULL, 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02f0_0_ff, NULL, 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_02f8_0_ff, NULL, 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02f9_0_ff, NULL, 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_02fa_0_ff, NULL, 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02fb_0_ff, NULL, 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0400_0_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_0_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_0_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_0_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_0_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_0_ff, NULL, 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0438_0_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_0_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_0_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_0_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_0_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_0_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_0_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_0_ff, NULL, 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0478_0_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_0_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_0_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_0_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_0_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_0_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_0_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_0_ff, NULL, 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ op_04b8_0_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_0_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ op_04d0_0_ff, NULL, 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_04e8_0_ff, NULL, 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04f0_0_ff, NULL, 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_04f8_0_ff, NULL, 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04f9_0_ff, NULL, 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_04fa_0_ff, NULL, 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04fb_0_ff, NULL, 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0600_0_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_0_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_0_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_0_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_0_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_0_ff, NULL, 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0638_0_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_0_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_0_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_0_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_0_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_0_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_0_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_0_ff, NULL, 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0678_0_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_0_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_0_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_0_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_0_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_0_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_0_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_0_ff, NULL, 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ op_06b8_0_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_0_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ op_06c0_0_ff, NULL, 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
{ op_06c8_0_ff, NULL, 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
{ op_06d0_0_ff, NULL, 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06e8_0_ff, NULL, 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f0_0_ff, NULL, 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f8_0_ff, NULL, 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f9_0_ff, NULL, 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06fa_0_ff, NULL, 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06fb_0_ff, NULL, 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_0800_0_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_0_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_0_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_0_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_0_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_0_ff, NULL, 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0838_0_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_0_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_0_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_0_ff, NULL, 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0840_0_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_0_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_0_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_0_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_0_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_0_ff, NULL, 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ op_0878_0_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_0_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_0_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_0_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_0_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_0_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_0_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_0_ff, NULL, 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ op_08b8_0_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_0_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_0_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_0_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_0_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_0_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_0_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_0_ff, NULL, 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ op_08f8_0_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_0_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_0_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_0_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_0_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_0_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_0_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_0_ff, NULL, 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a38_0_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_0_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_1_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_0_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_0_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_0_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_0_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_0_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_0_ff, NULL, 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a78_0_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_0_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_1_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_0_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_0_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_0_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_0_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_0_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_0_ff, NULL, 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ op_0ab8_0_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_0_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
#ifndef CPUEMU_68000_ONLY
{ op_0ad0_1_ff, NULL, 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ad8_1_ff, NULL, 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ae0_1_ff, NULL, 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ae8_1_ff, NULL, 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af0_1_ff, NULL, 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af8_1_ff, NULL, 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af9_1_ff, NULL, 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
{ op_0c00_0_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_0_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_0_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_0_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_0_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_0_ff, NULL, 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c38_0_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_0_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c3a_0_ff, NULL, 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c3b_0_ff, NULL, 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c40_0_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_0_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_0_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_0_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_0_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_0_ff, NULL, 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c78_0_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_0_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c7a_0_ff, NULL, 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c7b_0_ff, NULL, 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c80_0_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_0_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_0_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_0_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_0_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_0_ff, NULL, 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ op_0cb8_0_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_0_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ op_0cba_0_ff, NULL, 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cbb_0_ff, NULL, 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ op_0cd0_1_ff, NULL, 0x0cd0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cd8_1_ff, NULL, 0x0cd8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ce0_1_ff, NULL, 0x0ce0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ce8_1_ff, NULL, 0x0ce8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf0_1_ff, NULL, 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf8_1_ff, NULL, 0x0cf8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf9_1_ff, NULL, 0x0cf9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cfc_1_ff, NULL, 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e10_1_ff, NULL, 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e18_1_ff, NULL, 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e20_1_ff, NULL, 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e28_1_ff, NULL, 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e30_1_ff, NULL, 0x0e30, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e38_1_ff, NULL, 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e39_1_ff, NULL, 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e50_1_ff, NULL, 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e58_1_ff, NULL, 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e60_1_ff, NULL, 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e68_1_ff, NULL, 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e70_1_ff, NULL, 0x0e70, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e78_1_ff, NULL, 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e79_1_ff, NULL, 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e90_1_ff, NULL, 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e98_1_ff, NULL, 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea0_1_ff, NULL, 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea8_1_ff, NULL, 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb0_1_ff, NULL, 0x0eb0, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb8_1_ff, NULL, 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb9_1_ff, NULL, 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ed0_1_ff, NULL, 0x0ed0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ed8_1_ff, NULL, 0x0ed8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ee0_1_ff, NULL, 0x0ee0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ee8_1_ff, NULL, 0x0ee8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef0_1_ff, NULL, 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef8_1_ff, NULL, 0x0ef8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef9_1_ff, NULL, 0x0ef9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0efc_1_ff, NULL, 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
{ op_1000_0_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_0_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_0_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_0_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_0_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_0_ff, NULL, 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1038_0_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_0_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_0_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_0_ff, NULL, 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_103c_0_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_0_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_0_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_0_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_0_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_0_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_0_ff, NULL, 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10b8_0_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_0_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_0_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_0_ff, NULL, 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10bc_0_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_0_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_0_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_0_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_0_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_0_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_0_ff, NULL, 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10f8_0_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_0_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_0_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_0_ff, NULL, 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10fc_0_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_0_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_0_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_0_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_0_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_0_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_0_ff, NULL, 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1138_0_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_0_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_0_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_0_ff, NULL, 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_113c_0_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_0_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_0_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_0_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_0_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_0_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_0_ff, NULL, 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1178_0_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_0_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_0_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_0_ff, NULL, 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_117c_0_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_0_ff, NULL, 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1190_0_ff, NULL, 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1198_0_ff, NULL, 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a0_0_ff, NULL, 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a8_0_ff, NULL, 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b0_0_ff, NULL, 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11b8_0_ff, NULL, 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b9_0_ff, NULL, 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_11ba_0_ff, NULL, 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11bb_0_ff, NULL, 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11bc_0_ff, NULL, 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11c0_0_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_0_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_0_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_0_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_0_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_0_ff, NULL, 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11f8_0_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_0_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_0_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_0_ff, NULL, 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11fc_0_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_0_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_0_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_0_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_0_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_0_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_0_ff, NULL, 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13f8_0_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_0_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_0_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_0_ff, NULL, 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13fc_0_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_0_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_0_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_0_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_0_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_0_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_0_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_0_ff, NULL, 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2038_0_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_0_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_0_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_0_ff, NULL, 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_203c_0_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_0_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_0_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_0_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_0_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_0_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_0_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_0_ff, NULL, 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_2078_0_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_0_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_0_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_0_ff, NULL, 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_207c_0_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_0_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_0_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_0_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_0_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_0_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_0_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_0_ff, NULL, 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20b8_0_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_0_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_0_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_0_ff, NULL, 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20bc_0_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_0_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_0_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_0_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_0_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_0_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_0_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_0_ff, NULL, 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20f8_0_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_0_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_0_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_0_ff, NULL, 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20fc_0_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_0_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_0_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_0_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_0_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_0_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_0_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_0_ff, NULL, 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2138_0_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_0_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_0_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_0_ff, NULL, 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_213c_0_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_0_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_0_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_0_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_0_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_0_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_0_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_0_ff, NULL, 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2178_0_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_0_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_0_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_0_ff, NULL, 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_217c_0_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_0_ff, NULL, 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2188_0_ff, NULL, 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2190_0_ff, NULL, 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2198_0_ff, NULL, 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a0_0_ff, NULL, 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a8_0_ff, NULL, 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b0_0_ff, NULL, 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21b8_0_ff, NULL, 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b9_0_ff, NULL, 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21ba_0_ff, NULL, 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21bb_0_ff, NULL, 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21bc_0_ff, NULL, 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21c0_0_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_0_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_0_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_0_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_0_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_0_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_0_ff, NULL, 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21f8_0_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_0_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_0_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_0_ff, NULL, 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21fc_0_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_0_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_0_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_0_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_0_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_0_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_0_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_0_ff, NULL, 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23f8_0_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_0_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_0_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_0_ff, NULL, 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23fc_0_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_0_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_0_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_0_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_0_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_0_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_0_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_0_ff, NULL, 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3038_0_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_0_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_0_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_0_ff, NULL, 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_303c_0_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_0_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_0_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_0_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_0_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_0_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_0_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_0_ff, NULL, 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_3078_0_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_0_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_0_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_0_ff, NULL, 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_307c_0_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_0_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_0_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_0_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_0_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_0_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_0_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_0_ff, NULL, 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30b8_0_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_0_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_0_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_0_ff, NULL, 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30bc_0_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_0_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_0_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_0_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_0_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_0_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_0_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_0_ff, NULL, 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30f8_0_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_0_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_0_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_0_ff, NULL, 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30fc_0_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_0_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_0_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_0_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_0_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_0_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_0_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_0_ff, NULL, 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3138_0_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_0_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_0_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_0_ff, NULL, 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_313c_0_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_0_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_0_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_0_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_0_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_0_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_0_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_0_ff, NULL, 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3178_0_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_0_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_0_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_0_ff, NULL, 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_317c_0_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_0_ff, NULL, 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3188_0_ff, NULL, 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3190_0_ff, NULL, 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3198_0_ff, NULL, 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a0_0_ff, NULL, 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a8_0_ff, NULL, 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b0_0_ff, NULL, 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31b8_0_ff, NULL, 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b9_0_ff, NULL, 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_31ba_0_ff, NULL, 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31bb_0_ff, NULL, 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31bc_0_ff, NULL, 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31c0_0_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_0_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_0_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_0_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_0_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_0_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_0_ff, NULL, 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31f8_0_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_0_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_0_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_0_ff, NULL, 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31fc_0_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_0_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_0_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_0_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_0_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_0_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_0_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_0_ff, NULL, 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33f8_0_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_0_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_0_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_0_ff, NULL, 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33fc_0_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_0_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_0_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_0_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_0_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_0_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_0_ff, NULL, 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4038_0_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_0_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_0_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_0_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_0_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_0_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_0_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_0_ff, NULL, 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4078_0_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_0_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_0_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_0_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_0_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_0_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_0_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_0_ff, NULL, 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_40b8_0_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_0_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_0_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_0_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_0_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_0_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_0_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_0_ff, NULL, 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ op_40f8_0_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_0_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4100_0_ff, NULL, 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4110_0_ff, NULL, 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4118_0_ff, NULL, 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4120_0_ff, NULL, 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4128_0_ff, NULL, 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
{ op_4130_0_ff, NULL, 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
{ op_4138_0_ff, NULL, 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
{ op_4139_0_ff, NULL, 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
{ op_413a_0_ff, NULL, 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
{ op_413b_0_ff, NULL, 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
{ op_413c_0_ff, NULL, 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
{ op_4180_0_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_0_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_0_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_0_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_0_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_0_ff, NULL, 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41b8_0_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_0_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_0_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_0_ff, NULL, 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41bc_0_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_0_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_0_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_0_ff, NULL, 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ op_41f8_0_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_0_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_0_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_0_ff, NULL, 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ op_4200_0_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_0_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_0_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_0_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_0_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_0_ff, NULL, 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4238_0_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_0_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_0_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_0_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_0_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_0_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_0_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_0_ff, NULL, 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4278_0_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_0_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_0_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_0_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_0_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_0_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_0_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_0_ff, NULL, 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ op_42b8_0_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_0_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ op_42c0_0_ff, NULL, 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d0_0_ff, NULL, 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d8_0_ff, NULL, 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e0_0_ff, NULL, 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e8_0_ff, NULL, 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42f0_0_ff, NULL, 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ op_42f8_0_ff, NULL, 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42f9_0_ff, NULL, 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4400_0_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_0_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_0_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_0_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_0_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_0_ff, NULL, 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4438_0_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_0_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_0_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_0_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_0_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_0_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_0_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_0_ff, NULL, 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4478_0_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_0_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_0_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_0_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_0_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_0_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_0_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_0_ff, NULL, 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ op_44b8_0_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_0_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_0_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_0_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_0_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_0_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_0_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_0_ff, NULL, 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44f8_0_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_0_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_0_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_0_ff, NULL, 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44fc_0_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_0_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_0_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_0_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_0_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_0_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_0_ff, NULL, 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4638_0_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_0_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_0_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_0_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_0_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_0_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_0_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_0_ff, NULL, 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4678_0_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_0_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_0_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_0_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_0_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_0_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_0_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_0_ff, NULL, 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ op_46b8_0_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_0_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_0_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_0_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_0_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_0_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_0_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_0_ff, NULL, 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46f8_0_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_0_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_0_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_0_ff, NULL, 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46fc_0_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_0_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
#ifndef CPUEMU_68000_ONLY
{ op_4808_1_ff, NULL, 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
#endif
{ op_4810_0_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_0_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_0_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_0_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_0_ff, NULL, 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ op_4838_0_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_0_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_0_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ op_4848_0_ff, NULL, 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
{ op_4850_0_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_0_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_0_ff, NULL, 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4878_0_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_0_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_0_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_0_ff, NULL, 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4880_0_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_0_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_0_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_0_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_0_ff, NULL, 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48b8_0_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_0_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_0_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_0_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_0_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_0_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_0_ff, NULL, 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48f8_0_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_0_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_49c0_0_ff, NULL, 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4a00_0_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_0_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_0_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_0_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_0_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_0_ff, NULL, 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a38_0_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_0_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a3a_0_ff, NULL, 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a3b_0_ff, NULL, 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a3c_0_ff, NULL, 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a40_0_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a48_0_ff, NULL, 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a50_0_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_0_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_0_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_0_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_0_ff, NULL, 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a78_0_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_0_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a7a_0_ff, NULL, 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a7b_0_ff, NULL, 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a7c_0_ff, NULL, 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a80_0_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a88_0_ff, NULL, 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a90_0_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_0_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_0_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_0_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_0_ff, NULL, 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ op_4ab8_0_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_0_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ op_4aba_0_ff, NULL, 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
{ op_4abb_0_ff, NULL, 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
{ op_4abc_0_ff, NULL, 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
{ op_4ac0_0_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad0_0_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_0_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_0_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_0_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_0_ff, NULL, 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ op_4af8_0_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_0_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ op_4c00_0_ff, NULL, 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c10_0_ff, NULL, 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c18_0_ff, NULL, 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c20_0_ff, NULL, 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c28_0_ff, NULL, 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c30_0_ff, NULL, 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
{ op_4c38_0_ff, NULL, 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c39_0_ff, NULL, 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
{ op_4c3a_0_ff, NULL, 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c3b_0_ff, NULL, 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
{ op_4c3c_0_ff, NULL, 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
{ op_4c40_0_ff, NULL, 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c50_0_ff, NULL, 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c58_0_ff, NULL, 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c60_0_ff, NULL, 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c68_0_ff, NULL, 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c70_0_ff, NULL, 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
{ op_4c78_0_ff, NULL, 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c79_0_ff, NULL, 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
{ op_4c7a_0_ff, NULL, 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c7b_0_ff, NULL, 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
{ op_4c7c_0_ff, NULL, 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
{ op_4c90_0_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_0_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_0_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_0_ff, NULL, 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cb8_0_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_0_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_0_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_0_ff, NULL, 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cd0_0_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_0_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_0_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_0_ff, NULL, 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cf8_0_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_0_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_0_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_0_ff, NULL, 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4e40_0_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_1_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_0_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_1_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_0_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_0_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_1_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_1_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_1_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ op_4e74_0_ff, NULL, 0x4e74, 4, { 0, 0 }, 2 }, /* RTD */
{ op_4e75_0_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_0_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_1_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ op_4e7a_0_ff, NULL, 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#ifndef CPUEMU_68000_ONLY
{ op_4e7b_1_ff, NULL, 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ op_4e90_0_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_0_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_0_ff, NULL, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4eb8_0_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_0_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_0_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_0_ff, NULL, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4ed0_0_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_0_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_0_ff, NULL, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ op_4ef8_0_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_0_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_0_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_0_ff, NULL, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ op_5000_0_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_0_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_0_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_0_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_0_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_0_ff, NULL, 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5038_0_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_0_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_0_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_0_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_0_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_0_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_0_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_0_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_0_ff, NULL, 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5078_0_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_0_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_0_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_0_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_0_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_0_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_0_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_0_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_0_ff, NULL, 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_50b8_0_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_0_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_0_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_0_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_0_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_0_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_0_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_0_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_0_ff, NULL, 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_50f8_0_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_0_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_50fa_0_ff, NULL, 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_50fb_0_ff, NULL, 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_50fc_0_ff, NULL, 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5100_0_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_0_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_0_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_0_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_0_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_0_ff, NULL, 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5138_0_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_0_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_0_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_0_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_0_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_0_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_0_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_0_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_0_ff, NULL, 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5178_0_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_0_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_0_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_0_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_0_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_0_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_0_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_0_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_0_ff, NULL, 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_51b8_0_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_0_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_0_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_0_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_0_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_0_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_0_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_0_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_0_ff, NULL, 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_51f8_0_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_0_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_51fa_0_ff, NULL, 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_51fb_0_ff, NULL, 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_51fc_0_ff, NULL, 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52c0_0_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_0_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_0_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_0_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_0_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_0_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_0_ff, NULL, 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_52f8_0_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_0_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_52fa_0_ff, NULL, 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52fb_0_ff, NULL, 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52fc_0_ff, NULL, 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53c0_0_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_0_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_0_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_0_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_0_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_0_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_0_ff, NULL, 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_53f8_0_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_0_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_53fa_0_ff, NULL, 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53fb_0_ff, NULL, 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53fc_0_ff, NULL, 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54c0_0_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_0_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_0_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_0_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_0_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_0_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_0_ff, NULL, 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_54f8_0_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_0_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_54fa_0_ff, NULL, 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54fb_0_ff, NULL, 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54fc_0_ff, NULL, 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55c0_0_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_0_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_0_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_0_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_0_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_0_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_0_ff, NULL, 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_55f8_0_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_0_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_55fa_0_ff, NULL, 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55fb_0_ff, NULL, 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55fc_0_ff, NULL, 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56c0_0_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_0_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_0_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_0_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_0_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_0_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_0_ff, NULL, 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_56f8_0_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_0_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_56fa_0_ff, NULL, 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56fb_0_ff, NULL, 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56fc_0_ff, NULL, 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57c0_0_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_0_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_0_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_0_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_0_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_0_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_0_ff, NULL, 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_57f8_0_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_0_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_57fa_0_ff, NULL, 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57fb_0_ff, NULL, 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57fc_0_ff, NULL, 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58c0_0_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_0_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_0_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_0_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_0_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_0_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_0_ff, NULL, 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_58f8_0_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_0_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_58fa_0_ff, NULL, 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58fb_0_ff, NULL, 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58fc_0_ff, NULL, 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59c0_0_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_0_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_0_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_0_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_0_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_0_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_0_ff, NULL, 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_59f8_0_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_0_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_59fa_0_ff, NULL, 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59fb_0_ff, NULL, 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59fc_0_ff, NULL, 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ac0_0_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_0_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_0_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_0_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_0_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_0_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_0_ff, NULL, 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5af8_0_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_0_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5afa_0_ff, NULL, 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5afb_0_ff, NULL, 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5afc_0_ff, NULL, 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bc0_0_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_0_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_0_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_0_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_0_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_0_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_0_ff, NULL, 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5bf8_0_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_0_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5bfa_0_ff, NULL, 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bfb_0_ff, NULL, 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bfc_0_ff, NULL, 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cc0_0_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_0_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_0_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_0_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_0_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_0_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_0_ff, NULL, 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5cf8_0_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_0_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5cfa_0_ff, NULL, 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cfb_0_ff, NULL, 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cfc_0_ff, NULL, 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dc0_0_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_0_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_0_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_0_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_0_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_0_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_0_ff, NULL, 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5df8_0_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_0_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5dfa_0_ff, NULL, 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dfb_0_ff, NULL, 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dfc_0_ff, NULL, 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ec0_0_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_0_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_0_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_0_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_0_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_0_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_0_ff, NULL, 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ef8_0_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_0_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5efa_0_ff, NULL, 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5efb_0_ff, NULL, 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5efc_0_ff, NULL, 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5fc0_0_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_0_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_0_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_0_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_0_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_0_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_0_ff, NULL, 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ff8_0_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_0_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ffa_0_ff, NULL, 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ffb_0_ff, NULL, 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ffc_0_ff, NULL, 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_6000_0_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_0_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_0_ff, NULL, 0x60ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6100_0_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_0_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_0_ff, NULL, 0x61ff, 6, { 0, 0 }, 3 }, /* BSR */
{ op_6200_0_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_0_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_0_ff, NULL, 0x62ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6300_0_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_0_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_0_ff, NULL, 0x63ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6400_0_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_0_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_0_ff, NULL, 0x64ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6500_0_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_0_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_0_ff, NULL, 0x65ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6600_0_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_0_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_0_ff, NULL, 0x66ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6700_0_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_0_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_0_ff, NULL, 0x67ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6800_0_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_0_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_0_ff, NULL, 0x68ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6900_0_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_0_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_0_ff, NULL, 0x69ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6a00_0_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_0_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_0_ff, NULL, 0x6aff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6b00_0_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_0_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_0_ff, NULL, 0x6bff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6c00_0_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_0_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_0_ff, NULL, 0x6cff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6d00_0_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_0_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_0_ff, NULL, 0x6dff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6e00_0_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_0_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_0_ff, NULL, 0x6eff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6f00_0_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_0_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_0_ff, NULL, 0x6fff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_7000_0_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_0_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_0_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_0_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_0_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_0_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_0_ff, NULL, 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ op_8038_0_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_0_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_0_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_0_ff, NULL, 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ op_803c_0_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_0_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_0_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_0_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_0_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_0_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_0_ff, NULL, 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ op_8078_0_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_0_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_0_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_0_ff, NULL, 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ op_807c_0_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_0_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_0_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_0_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_0_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_0_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_0_ff, NULL, 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_80b8_0_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_0_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_0_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_0_ff, NULL, 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ op_80bc_0_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_0_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_0_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_0_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_0_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_0_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_0_ff, NULL, 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80f8_0_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_0_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_0_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_0_ff, NULL, 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80fc_0_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_0_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_0_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_0_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_0_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_0_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_0_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_0_ff, NULL, 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ op_8138_0_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_0_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ op_8140_0_ff, NULL, 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
{ op_8148_0_ff, NULL, 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
{ op_8150_0_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_0_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_0_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_0_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_0_ff, NULL, 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ op_8178_0_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_0_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ op_8180_0_ff, NULL, 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
{ op_8188_0_ff, NULL, 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
{ op_8190_0_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_0_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_0_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_0_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_0_ff, NULL, 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_81b8_0_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_0_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_0_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_0_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_0_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_0_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_0_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_0_ff, NULL, 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81f8_0_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_0_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_0_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_0_ff, NULL, 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81fc_0_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_0_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_0_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_0_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_0_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_0_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_0_ff, NULL, 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9038_0_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_0_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_0_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_0_ff, NULL, 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_903c_0_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_0_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_0_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_0_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_0_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_0_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_0_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_0_ff, NULL, 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9078_0_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_0_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_0_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_0_ff, NULL, 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_907c_0_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_0_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_0_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_0_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_0_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_0_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_0_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_0_ff, NULL, 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90b8_0_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_0_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_0_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_0_ff, NULL, 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90bc_0_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_0_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_0_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_0_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_0_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_0_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_0_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_0_ff, NULL, 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90f8_0_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_0_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_0_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_0_ff, NULL, 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90fc_0_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_0_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_0_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_0_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_0_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_0_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_0_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_0_ff, NULL, 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9138_0_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_0_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_0_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_0_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_0_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_0_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_0_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_0_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_0_ff, NULL, 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9178_0_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_0_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_0_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_0_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_0_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_0_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_0_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_0_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_0_ff, NULL, 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_91b8_0_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_0_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_0_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_0_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_0_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_0_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_0_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_0_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_0_ff, NULL, 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91f8_0_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_0_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_0_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_0_ff, NULL, 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91fc_0_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_0_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_0_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_0_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_0_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_0_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_0_ff, NULL, 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b038_0_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_0_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_0_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_0_ff, NULL, 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b03c_0_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_0_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_0_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_0_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_0_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_0_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_0_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_0_ff, NULL, 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b078_0_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_0_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_0_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_0_ff, NULL, 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b07c_0_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_0_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_0_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_0_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_0_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_0_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_0_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_0_ff, NULL, 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0b8_0_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_0_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_0_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_0_ff, NULL, 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0bc_0_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_0_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_0_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_0_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_0_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_0_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_0_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_0_ff, NULL, 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0f8_0_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_0_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_0_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_0_ff, NULL, 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0fc_0_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_0_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_0_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_0_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_0_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_0_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_0_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_0_ff, NULL, 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b138_0_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_0_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_0_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_0_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_0_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_0_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_0_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_0_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_0_ff, NULL, 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b178_0_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_0_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_0_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_0_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_0_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_0_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_0_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_0_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_0_ff, NULL, 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b1b8_0_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_0_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_0_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_0_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_0_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_0_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_0_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_0_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_0_ff, NULL, 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1f8_0_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_0_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_0_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_0_ff, NULL, 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1fc_0_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_0_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_0_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_0_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_0_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_0_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_0_ff, NULL, 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ op_c038_0_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_0_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_0_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_0_ff, NULL, 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c03c_0_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_0_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_0_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_0_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_0_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_0_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_0_ff, NULL, 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ op_c078_0_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_0_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_0_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_0_ff, NULL, 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c07c_0_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_0_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_0_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_0_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_0_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_0_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_0_ff, NULL, 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0b8_0_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_0_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_0_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_0_ff, NULL, 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0bc_0_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_0_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_0_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_0_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_0_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_0_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_0_ff, NULL, 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0f8_0_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_0_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_0_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_0_ff, NULL, 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0fc_0_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_0_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_0_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_0_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_0_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_0_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_0_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_0_ff, NULL, 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ op_c138_0_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_0_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_0_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_0_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_0_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_0_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_0_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_0_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_0_ff, NULL, 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ op_c178_0_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_0_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_0_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_0_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_0_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_0_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_0_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_0_ff, NULL, 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c1b8_0_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_0_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_0_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_0_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_0_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_0_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_0_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_0_ff, NULL, 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1f8_0_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_0_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_0_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_0_ff, NULL, 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1fc_0_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_0_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_0_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_0_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_0_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_0_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_0_ff, NULL, 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d038_0_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_0_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_0_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_0_ff, NULL, 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d03c_0_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_0_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_0_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_0_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_0_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_0_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_0_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_0_ff, NULL, 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d078_0_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_0_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_0_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_0_ff, NULL, 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d07c_0_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_0_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_0_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_0_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_0_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_0_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_0_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_0_ff, NULL, 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0b8_0_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_0_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_0_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_0_ff, NULL, 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0bc_0_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_0_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_0_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_0_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_0_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_0_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_0_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_0_ff, NULL, 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0f8_0_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_0_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_0_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_0_ff, NULL, 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0fc_0_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_0_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_0_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_0_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_0_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_0_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_0_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_0_ff, NULL, 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d138_0_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_0_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_0_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_0_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_0_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_0_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_0_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_0_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_0_ff, NULL, 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d178_0_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_0_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_0_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_0_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_0_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_0_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_0_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_0_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_0_ff, NULL, 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d1b8_0_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_0_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_0_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_0_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_0_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_0_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_0_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_0_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_0_ff, NULL, 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1f8_0_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_0_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_0_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_0_ff, NULL, 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1fc_0_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_0_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_0_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_0_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_0_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_0_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_0_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_0_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_0_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_0_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_0_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_0_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_0_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_0_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_0_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_0_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_0_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_0_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_0_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_0_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_0_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_0_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_0_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_0_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_0_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_0_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_0_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_0_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_0_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_0_ff, NULL, 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ op_e0f8_0_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_0_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_0_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_0_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_0_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_0_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_0_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_0_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_0_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_0_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_0_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_0_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_0_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_0_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_0_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_0_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_0_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_0_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_0_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_0_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_0_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_0_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_0_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_0_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_0_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_0_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_0_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_0_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_0_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_0_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_0_ff, NULL, 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ op_e1f8_0_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_0_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_0_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_0_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_0_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_0_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_0_ff, NULL, 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ op_e2f8_0_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_0_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_0_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_0_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_0_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_0_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_0_ff, NULL, 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ op_e3f8_0_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_0_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_0_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_0_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_0_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_0_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_0_ff, NULL, 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ op_e4f8_0_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_0_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_0_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_0_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_0_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_0_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_0_ff, NULL, 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ op_e5f8_0_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_0_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_0_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_0_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_0_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_0_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_0_ff, NULL, 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ op_e6f8_0_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_0_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_0_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_0_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_0_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_0_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_0_ff, NULL, 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ op_e7f8_0_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_0_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ op_e8c0_0_ff, NULL, 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
{ op_e8d0_0_ff, NULL, 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
{ op_e8e8_0_ff, NULL, 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8f0_0_ff, NULL, 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
{ op_e8f8_0_ff, NULL, 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8f9_0_ff, NULL, 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
{ op_e8fa_0_ff, NULL, 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8fb_0_ff, NULL, 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
{ op_e9c0_0_ff, NULL, 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9d0_0_ff, NULL, 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9e8_0_ff, NULL, 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9f0_0_ff, NULL, 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ op_e9f8_0_ff, NULL, 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9f9_0_ff, NULL, 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9fa_0_ff, NULL, 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9fb_0_ff, NULL, 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ op_eac0_0_ff, NULL, 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ op_ead0_0_ff, NULL, 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ op_eae8_0_ff, NULL, 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ op_eaf0_0_ff, NULL, 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
{ op_eaf8_0_ff, NULL, 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ op_eaf9_0_ff, NULL, 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
{ op_ebc0_0_ff, NULL, 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebd0_0_ff, NULL, 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebe8_0_ff, NULL, 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebf0_0_ff, NULL, 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ op_ebf8_0_ff, NULL, 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebf9_0_ff, NULL, 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebfa_0_ff, NULL, 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebfb_0_ff, NULL, 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ op_ecc0_0_ff, NULL, 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecd0_0_ff, NULL, 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ op_ece8_0_ff, NULL, 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecf0_0_ff, NULL, 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
{ op_ecf8_0_ff, NULL, 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecf9_0_ff, NULL, 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
{ op_edc0_0_ff, NULL, 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ op_edd0_0_ff, NULL, 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ op_ede8_0_ff, NULL, 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edf0_0_ff, NULL, 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
{ op_edf8_0_ff, NULL, 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edf9_0_ff, NULL, 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
{ op_edfa_0_ff, NULL, 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edfb_0_ff, NULL, 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
{ op_eec0_0_ff, NULL, 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
{ op_eed0_0_ff, NULL, 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
{ op_eee8_0_ff, NULL, 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
{ op_eef0_0_ff, NULL, 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
{ op_eef8_0_ff, NULL, 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
{ op_eef9_0_ff, NULL, 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
{ op_efc0_0_ff, NULL, 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
{ op_efd0_0_ff, NULL, 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
{ op_efe8_0_ff, NULL, 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
{ op_eff0_0_ff, NULL, 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
{ op_eff8_0_ff, NULL, 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
{ op_eff9_0_ff, NULL, 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
{ op_f000_0_ff, NULL, 0xf000, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f008_0_ff, NULL, 0xf008, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f010_0_ff, NULL, 0xf010, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f018_0_ff, NULL, 0xf018, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f020_0_ff, NULL, 0xf020, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f028_0_ff, NULL, 0xf028, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f030_0_ff, NULL, 0xf030, -1, { -3, 0 }, 0 }, /* MMUOP030 */
{ op_f038_0_ff, NULL, 0xf038, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f039_0_ff, NULL, 0xf039, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f200_0_ff, NULL, 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f208_0_ff, NULL, 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f210_0_ff, NULL, 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f218_0_ff, NULL, 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f220_0_ff, NULL, 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f228_0_ff, NULL, 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f230_0_ff, NULL, 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f238_0_ff, NULL, 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f239_0_ff, NULL, 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23a_0_ff, NULL, 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23b_0_ff, NULL, 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23c_0_ff, NULL, 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f240_0_ff, NULL, 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f248_0_ff, NULL, 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
{ op_f250_0_ff, NULL, 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f258_0_ff, NULL, 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f260_0_ff, NULL, 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f268_0_ff, NULL, 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f270_0_ff, NULL, 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f278_0_ff, NULL, 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f279_0_ff, NULL, 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f27a_0_ff, NULL, 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f27b_0_ff, NULL, 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f27c_0_ff, NULL, 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f280_0_ff, NULL, 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
{ op_f2c0_0_ff, NULL, 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
{ op_f310_0_ff, NULL, 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f320_0_ff, NULL, 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f328_0_ff, NULL, 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f330_0_ff, NULL, 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f338_0_ff, NULL, 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f339_0_ff, NULL, 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f350_0_ff, NULL, 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f358_0_ff, NULL, 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f368_0_ff, NULL, 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f370_0_ff, NULL, 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f378_0_ff, NULL, 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f379_0_ff, NULL, 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f37a_0_ff, NULL, 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f37b_0_ff, NULL, 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f408_0_ff, NULL, 0xf408, -1, { 0, 0 }, 0 }, /* CINVL */
{ op_f410_0_ff, NULL, 0xf410, -1, { 0, 0 }, 0 }, /* CINVP */
{ op_f418_0_ff, NULL, 0xf418, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f419_0_ff, NULL, 0xf419, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f41a_0_ff, NULL, 0xf41a, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f41b_0_ff, NULL, 0xf41b, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f41c_0_ff, NULL, 0xf41c, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f41d_0_ff, NULL, 0xf41d, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f41e_0_ff, NULL, 0xf41e, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f41f_0_ff, NULL, 0xf41f, -1, { 0, 0 }, 0 }, /* CINVA */
{ op_f428_0_ff, NULL, 0xf428, -1, { 0, 0 }, 0 }, /* CPUSHL */
{ op_f430_0_ff, NULL, 0xf430, -1, { 0, 0 }, 0 }, /* CPUSHP */
{ op_f438_0_ff, NULL, 0xf438, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ op_f439_0_ff, NULL, 0xf439, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ op_f43a_0_ff, NULL, 0xf43a, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ op_f43b_0_ff, NULL, 0xf43b, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ op_f43c_0_ff, NULL, 0xf43c, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ op_f43d_0_ff, NULL, 0xf43d, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ op_f43e_0_ff, NULL, 0xf43e, -1, { 0, 0 }, 0 }, /* CPUSHA */
{ op_f43f_0_ff, NULL, 0xf43f, -1, { 0, 0 }, 0 }, /* CPUSHA */
#ifndef CPUEMU_68000_ONLY
{ op_f500_1_ff, NULL, 0xf500, -1, { 0, 0 }, 0 }, /* PFLUSHN */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f508_1_ff, NULL, 0xf508, -1, { 0, 0 }, 0 }, /* PFLUSH */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f510_1_ff, NULL, 0xf510, -1, { 0, 0 }, 0 }, /* PFLUSHAN */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f518_1_ff, NULL, 0xf518, -1, { 0, 0 }, 0 }, /* PFLUSHA */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f548_1_ff, NULL, 0xf548, -1, { 0, 0 }, 0 }, /* PTESTW */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_f568_1_ff, NULL, 0xf568, -1, { 0, 0 }, 0 }, /* PTESTR */
#endif
{ op_f600_0_ff, NULL, 0xf600, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ op_f608_0_ff, NULL, 0xf608, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ op_f610_0_ff, NULL, 0xf610, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ op_f618_0_ff, NULL, 0xf618, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ op_f620_0_ff, NULL, 0xf620, -1, { 0, 0 }, 0 }, /* MOVE16 */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_68000_ONLY */
#ifndef CPUEMU_68000_ONLY
const struct cputbl op_smalltbl_2[] = {
{ op_0000_0_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_0_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_0_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_0_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_0_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_0_ff, NULL, 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ op_0038_0_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_0_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_2_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_0_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_0_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_0_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_0_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_0_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_0_ff, NULL, 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ op_0078_0_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_0_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_2_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_0_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_0_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_0_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_0_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_0_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_0_ff, NULL, 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ op_00b8_0_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_0_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ op_00d0_0_ff, NULL, 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_00e8_0_ff, NULL, 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00f0_0_ff, NULL, 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_00f8_0_ff, NULL, 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00f9_0_ff, NULL, 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_00fa_0_ff, NULL, 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00fb_0_ff, NULL, 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0100_0_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_0_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_0_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_0_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_0_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_0_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_0_ff, NULL, 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ op_0138_0_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_0_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_0_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_0_ff, NULL, 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ op_013c_0_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_0_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_0_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_0_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_0_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_0_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_0_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_0_ff, NULL, 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ op_0178_0_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_0_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_0_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_0_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_0_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_0_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_0_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_0_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_0_ff, NULL, 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ op_01b8_0_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_0_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_0_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_0_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_0_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_0_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_0_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_0_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_0_ff, NULL, 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ op_01f8_0_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_0_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_0_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_0_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_0_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_0_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_0_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_0_ff, NULL, 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ op_0238_0_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_0_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_2_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_0_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_0_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_0_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_0_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_0_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_0_ff, NULL, 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ op_0278_0_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_0_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_2_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_0_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_0_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_0_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_0_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_0_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_0_ff, NULL, 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ op_02b8_0_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_0_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ op_02d0_0_ff, NULL, 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_02e8_0_ff, NULL, 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02f0_0_ff, NULL, 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_02f8_0_ff, NULL, 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02f9_0_ff, NULL, 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_02fa_0_ff, NULL, 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02fb_0_ff, NULL, 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0400_0_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_0_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_0_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_0_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_0_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_0_ff, NULL, 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0438_0_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_0_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_0_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_0_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_0_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_0_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_0_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_0_ff, NULL, 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0478_0_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_0_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_0_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_0_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_0_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_0_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_0_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_0_ff, NULL, 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ op_04b8_0_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_0_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ op_04d0_0_ff, NULL, 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_04e8_0_ff, NULL, 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04f0_0_ff, NULL, 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_04f8_0_ff, NULL, 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04f9_0_ff, NULL, 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_04fa_0_ff, NULL, 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04fb_0_ff, NULL, 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0600_0_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_0_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_0_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_0_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_0_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_0_ff, NULL, 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0638_0_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_0_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_0_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_0_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_0_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_0_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_0_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_0_ff, NULL, 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0678_0_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_0_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_0_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_0_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_0_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_0_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_0_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_0_ff, NULL, 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ op_06b8_0_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_0_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ op_06c0_0_ff, NULL, 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
{ op_06c8_0_ff, NULL, 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
{ op_06d0_0_ff, NULL, 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06e8_0_ff, NULL, 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f0_0_ff, NULL, 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f8_0_ff, NULL, 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f9_0_ff, NULL, 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06fa_0_ff, NULL, 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06fb_0_ff, NULL, 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_0800_0_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_0_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_0_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_0_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_0_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_0_ff, NULL, 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0838_0_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_0_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_0_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_0_ff, NULL, 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0840_0_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_0_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_0_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_0_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_0_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_0_ff, NULL, 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ op_0878_0_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_0_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_0_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_0_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_0_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_0_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_0_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_0_ff, NULL, 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ op_08b8_0_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_0_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_0_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_0_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_0_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_0_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_0_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_0_ff, NULL, 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ op_08f8_0_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_0_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_0_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_0_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_0_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_0_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_0_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_0_ff, NULL, 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a38_0_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_0_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_2_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_0_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_0_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_0_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_0_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_0_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_0_ff, NULL, 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a78_0_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_0_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_2_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_0_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_0_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_0_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_0_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_0_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_0_ff, NULL, 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ op_0ab8_0_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_0_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
#ifndef CPUEMU_68000_ONLY
{ op_0ad0_2_ff, NULL, 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ad8_2_ff, NULL, 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ae0_2_ff, NULL, 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ae8_2_ff, NULL, 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af0_2_ff, NULL, 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af8_2_ff, NULL, 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0af9_2_ff, NULL, 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
{ op_0c00_0_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_0_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_0_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_0_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_0_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_0_ff, NULL, 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c38_0_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_0_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c3a_0_ff, NULL, 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c3b_0_ff, NULL, 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c40_0_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_0_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_0_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_0_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_0_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_0_ff, NULL, 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c78_0_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_0_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c7a_0_ff, NULL, 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c7b_0_ff, NULL, 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c80_0_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_0_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_0_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_0_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_0_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_0_ff, NULL, 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ op_0cb8_0_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_0_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ op_0cba_0_ff, NULL, 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cbb_0_ff, NULL, 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ op_0cd0_2_ff, NULL, 0x0cd0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cd8_2_ff, NULL, 0x0cd8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ce0_2_ff, NULL, 0x0ce0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ce8_2_ff, NULL, 0x0ce8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf0_2_ff, NULL, 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf8_2_ff, NULL, 0x0cf8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cf9_2_ff, NULL, 0x0cf9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0cfc_2_ff, NULL, 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e10_2_ff, NULL, 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e18_2_ff, NULL, 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e20_2_ff, NULL, 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e28_2_ff, NULL, 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e30_2_ff, NULL, 0x0e30, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e38_2_ff, NULL, 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e39_2_ff, NULL, 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e50_2_ff, NULL, 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e58_2_ff, NULL, 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e60_2_ff, NULL, 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e68_2_ff, NULL, 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e70_2_ff, NULL, 0x0e70, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e78_2_ff, NULL, 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e79_2_ff, NULL, 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e90_2_ff, NULL, 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e98_2_ff, NULL, 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea0_2_ff, NULL, 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea8_2_ff, NULL, 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb0_2_ff, NULL, 0x0eb0, 4, { 2, 2 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb8_2_ff, NULL, 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb9_2_ff, NULL, 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ed0_2_ff, NULL, 0x0ed0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ed8_2_ff, NULL, 0x0ed8, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ee0_2_ff, NULL, 0x0ee0, 4, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ee8_2_ff, NULL, 0x0ee8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef0_2_ff, NULL, 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef8_2_ff, NULL, 0x0ef8, 6, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ef9_2_ff, NULL, 0x0ef9, 8, { 0, 0 }, 0 }, /* CAS */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0efc_2_ff, NULL, 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
#endif
{ op_1000_0_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_0_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_0_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_0_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_0_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_0_ff, NULL, 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1038_0_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_0_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_0_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_0_ff, NULL, 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_103c_0_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_0_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_0_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_0_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_0_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_0_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_0_ff, NULL, 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10b8_0_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_0_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_0_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_0_ff, NULL, 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10bc_0_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_0_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_0_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_0_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_0_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_0_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_0_ff, NULL, 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10f8_0_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_0_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_0_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_0_ff, NULL, 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10fc_0_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_0_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_0_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_0_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_0_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_0_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_0_ff, NULL, 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1138_0_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_0_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_0_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_0_ff, NULL, 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_113c_0_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_0_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_0_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_0_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_0_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_0_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_0_ff, NULL, 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1178_0_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_0_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_0_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_0_ff, NULL, 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_117c_0_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_0_ff, NULL, 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1190_0_ff, NULL, 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1198_0_ff, NULL, 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a0_0_ff, NULL, 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a8_0_ff, NULL, 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b0_0_ff, NULL, 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11b8_0_ff, NULL, 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b9_0_ff, NULL, 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_11ba_0_ff, NULL, 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11bb_0_ff, NULL, 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11bc_0_ff, NULL, 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11c0_0_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_0_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_0_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_0_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_0_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_0_ff, NULL, 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11f8_0_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_0_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_0_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_0_ff, NULL, 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11fc_0_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_0_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_0_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_0_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_0_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_0_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_0_ff, NULL, 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13f8_0_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_0_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_0_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_0_ff, NULL, 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13fc_0_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_0_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_0_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_0_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_0_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_0_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_0_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_0_ff, NULL, 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2038_0_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_0_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_0_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_0_ff, NULL, 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_203c_0_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_0_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_0_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_0_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_0_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_0_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_0_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_0_ff, NULL, 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_2078_0_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_0_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_0_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_0_ff, NULL, 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_207c_0_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_0_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_0_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_0_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_0_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_0_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_0_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_0_ff, NULL, 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20b8_0_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_0_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_0_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_0_ff, NULL, 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20bc_0_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_0_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_0_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_0_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_0_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_0_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_0_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_0_ff, NULL, 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20f8_0_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_0_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_0_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_0_ff, NULL, 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20fc_0_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_0_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_0_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_0_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_0_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_0_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_0_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_0_ff, NULL, 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2138_0_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_0_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_0_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_0_ff, NULL, 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_213c_0_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_0_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_0_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_0_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_0_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_0_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_0_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_0_ff, NULL, 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2178_0_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_0_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_0_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_0_ff, NULL, 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_217c_0_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_0_ff, NULL, 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2188_0_ff, NULL, 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2190_0_ff, NULL, 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2198_0_ff, NULL, 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a0_0_ff, NULL, 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a8_0_ff, NULL, 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b0_0_ff, NULL, 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21b8_0_ff, NULL, 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b9_0_ff, NULL, 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21ba_0_ff, NULL, 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21bb_0_ff, NULL, 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21bc_0_ff, NULL, 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21c0_0_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_0_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_0_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_0_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_0_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_0_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_0_ff, NULL, 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21f8_0_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_0_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_0_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_0_ff, NULL, 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21fc_0_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_0_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_0_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_0_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_0_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_0_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_0_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_0_ff, NULL, 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23f8_0_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_0_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_0_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_0_ff, NULL, 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23fc_0_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_0_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_0_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_0_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_0_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_0_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_0_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_0_ff, NULL, 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3038_0_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_0_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_0_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_0_ff, NULL, 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_303c_0_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_0_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_0_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_0_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_0_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_0_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_0_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_0_ff, NULL, 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_3078_0_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_0_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_0_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_0_ff, NULL, 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_307c_0_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_0_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_0_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_0_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_0_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_0_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_0_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_0_ff, NULL, 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30b8_0_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_0_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_0_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_0_ff, NULL, 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30bc_0_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_0_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_0_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_0_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_0_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_0_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_0_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_0_ff, NULL, 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30f8_0_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_0_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_0_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_0_ff, NULL, 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30fc_0_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_0_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_0_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_0_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_0_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_0_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_0_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_0_ff, NULL, 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3138_0_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_0_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_0_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_0_ff, NULL, 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_313c_0_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_0_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_0_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_0_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_0_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_0_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_0_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_0_ff, NULL, 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3178_0_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_0_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_0_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_0_ff, NULL, 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_317c_0_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_0_ff, NULL, 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3188_0_ff, NULL, 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3190_0_ff, NULL, 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3198_0_ff, NULL, 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a0_0_ff, NULL, 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a8_0_ff, NULL, 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b0_0_ff, NULL, 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31b8_0_ff, NULL, 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b9_0_ff, NULL, 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_31ba_0_ff, NULL, 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31bb_0_ff, NULL, 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31bc_0_ff, NULL, 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31c0_0_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_0_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_0_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_0_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_0_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_0_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_0_ff, NULL, 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31f8_0_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_0_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_0_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_0_ff, NULL, 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31fc_0_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_0_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_0_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_0_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_0_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_0_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_0_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_0_ff, NULL, 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33f8_0_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_0_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_0_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_0_ff, NULL, 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33fc_0_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_0_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_0_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_0_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_0_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_0_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_0_ff, NULL, 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4038_0_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_0_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_0_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_0_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_0_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_0_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_0_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_0_ff, NULL, 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4078_0_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_0_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_0_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_0_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_0_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_0_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_0_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_0_ff, NULL, 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_40b8_0_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_0_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_0_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_0_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_0_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_0_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_0_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_0_ff, NULL, 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ op_40f8_0_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_0_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4100_0_ff, NULL, 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4110_0_ff, NULL, 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4118_0_ff, NULL, 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4120_0_ff, NULL, 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4128_0_ff, NULL, 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
{ op_4130_0_ff, NULL, 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
{ op_4138_0_ff, NULL, 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
{ op_4139_0_ff, NULL, 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
{ op_413a_0_ff, NULL, 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
{ op_413b_0_ff, NULL, 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
{ op_413c_0_ff, NULL, 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
{ op_4180_0_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_0_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_0_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_0_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_0_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_0_ff, NULL, 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41b8_0_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_0_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_0_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_0_ff, NULL, 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41bc_0_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_0_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_0_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_0_ff, NULL, 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ op_41f8_0_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_0_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_0_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_0_ff, NULL, 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ op_4200_0_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_0_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_0_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_0_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_0_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_0_ff, NULL, 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4238_0_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_0_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_0_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_0_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_0_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_0_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_0_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_0_ff, NULL, 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4278_0_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_0_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_0_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_0_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_0_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_0_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_0_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_0_ff, NULL, 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ op_42b8_0_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_0_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ op_42c0_0_ff, NULL, 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d0_0_ff, NULL, 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d8_0_ff, NULL, 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e0_0_ff, NULL, 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e8_0_ff, NULL, 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42f0_0_ff, NULL, 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ op_42f8_0_ff, NULL, 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42f9_0_ff, NULL, 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4400_0_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_0_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_0_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_0_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_0_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_0_ff, NULL, 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4438_0_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_0_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_0_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_0_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_0_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_0_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_0_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_0_ff, NULL, 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4478_0_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_0_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_0_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_0_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_0_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_0_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_0_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_0_ff, NULL, 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ op_44b8_0_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_0_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_0_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_0_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_0_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_0_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_0_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_0_ff, NULL, 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44f8_0_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_0_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_0_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_0_ff, NULL, 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44fc_0_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_0_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_0_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_0_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_0_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_0_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_0_ff, NULL, 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4638_0_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_0_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_0_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_0_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_0_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_0_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_0_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_0_ff, NULL, 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4678_0_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_0_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_0_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_0_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_0_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_0_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_0_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_0_ff, NULL, 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ op_46b8_0_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_0_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_0_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_0_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_0_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_0_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_0_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_0_ff, NULL, 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46f8_0_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_0_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_0_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_0_ff, NULL, 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46fc_0_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_2_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4808_1_ff, NULL, 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
{ op_4810_2_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_2_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_2_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_2_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_2_ff, NULL, 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ op_4838_2_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_2_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_0_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ op_4848_0_ff, NULL, 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
{ op_4850_0_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_0_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_0_ff, NULL, 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4878_0_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_0_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_0_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_0_ff, NULL, 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4880_0_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_2_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_2_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_2_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_2_ff, NULL, 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48b8_2_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_2_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_0_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_2_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_2_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_2_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_2_ff, NULL, 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48f8_2_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_2_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_49c0_0_ff, NULL, 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4a00_0_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_0_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_0_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_0_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_0_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_0_ff, NULL, 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a38_0_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_0_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a3a_0_ff, NULL, 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a3b_0_ff, NULL, 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a3c_0_ff, NULL, 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a40_0_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a48_0_ff, NULL, 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a50_0_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_0_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_0_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_0_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_0_ff, NULL, 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a78_0_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_0_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a7a_0_ff, NULL, 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a7b_0_ff, NULL, 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a7c_0_ff, NULL, 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a80_0_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a88_0_ff, NULL, 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a90_0_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_0_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_0_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_0_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_0_ff, NULL, 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ op_4ab8_0_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_0_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ op_4aba_0_ff, NULL, 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
{ op_4abb_0_ff, NULL, 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
{ op_4abc_0_ff, NULL, 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
{ op_4ac0_0_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad0_0_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_0_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_0_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_0_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_0_ff, NULL, 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ op_4af8_0_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_0_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ op_4c00_0_ff, NULL, 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c10_0_ff, NULL, 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c18_0_ff, NULL, 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c20_0_ff, NULL, 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c28_0_ff, NULL, 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c30_0_ff, NULL, 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
{ op_4c38_0_ff, NULL, 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c39_0_ff, NULL, 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
{ op_4c3a_0_ff, NULL, 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c3b_0_ff, NULL, 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
{ op_4c3c_0_ff, NULL, 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
{ op_4c40_0_ff, NULL, 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c50_0_ff, NULL, 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c58_0_ff, NULL, 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c60_0_ff, NULL, 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c68_0_ff, NULL, 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c70_0_ff, NULL, 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
{ op_4c78_0_ff, NULL, 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c79_0_ff, NULL, 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
{ op_4c7a_0_ff, NULL, 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c7b_0_ff, NULL, 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
{ op_4c7c_0_ff, NULL, 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
{ op_4c90_2_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_2_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_2_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_2_ff, NULL, 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cb8_2_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_2_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_2_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_2_ff, NULL, 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cd0_2_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_2_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_2_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_2_ff, NULL, 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cf8_2_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_2_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_2_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_2_ff, NULL, 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4e40_0_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_1_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_0_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_2_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_0_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_0_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_2_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_2_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_2_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
#ifndef CPUEMU_68000_ONLY
{ op_4e74_2_ff, NULL, 0x4e74, 4, { 0, 0 }, 2 }, /* RTD */
#endif
{ op_4e75_2_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_0_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_2_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ op_4e7a_0_ff, NULL, 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#ifndef CPUEMU_68000_ONLY
{ op_4e7b_2_ff, NULL, 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ op_4e90_2_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_2_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_2_ff, NULL, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4eb8_2_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_2_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_2_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_2_ff, NULL, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4ed0_0_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_0_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_0_ff, NULL, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ op_4ef8_0_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_0_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_0_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_0_ff, NULL, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ op_5000_0_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_0_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_0_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_0_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_0_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_0_ff, NULL, 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5038_0_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_0_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_0_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_0_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_0_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_0_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_0_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_0_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_0_ff, NULL, 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5078_0_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_0_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_0_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_0_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_0_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_0_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_0_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_0_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_0_ff, NULL, 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_50b8_0_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_0_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_0_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_2_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_0_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_0_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_0_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_0_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_0_ff, NULL, 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_50f8_0_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_0_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_50fa_0_ff, NULL, 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_50fb_0_ff, NULL, 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_50fc_0_ff, NULL, 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5100_0_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_0_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_0_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_0_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_0_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_0_ff, NULL, 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5138_0_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_0_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_0_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_0_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_0_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_0_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_0_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_0_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_0_ff, NULL, 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5178_0_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_0_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_0_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_0_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_0_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_0_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_0_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_0_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_0_ff, NULL, 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_51b8_0_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_0_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_0_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_2_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_0_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_0_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_0_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_0_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_0_ff, NULL, 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_51f8_0_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_0_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_51fa_0_ff, NULL, 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_51fb_0_ff, NULL, 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_51fc_0_ff, NULL, 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52c0_0_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_2_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_0_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_0_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_0_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_0_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_0_ff, NULL, 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_52f8_0_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_0_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_52fa_0_ff, NULL, 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52fb_0_ff, NULL, 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52fc_0_ff, NULL, 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53c0_0_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_2_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_0_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_0_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_0_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_0_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_0_ff, NULL, 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_53f8_0_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_0_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_53fa_0_ff, NULL, 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53fb_0_ff, NULL, 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53fc_0_ff, NULL, 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54c0_0_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_2_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_0_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_0_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_0_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_0_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_0_ff, NULL, 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_54f8_0_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_0_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_54fa_0_ff, NULL, 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54fb_0_ff, NULL, 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54fc_0_ff, NULL, 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55c0_0_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_2_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_0_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_0_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_0_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_0_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_0_ff, NULL, 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_55f8_0_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_0_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_55fa_0_ff, NULL, 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55fb_0_ff, NULL, 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55fc_0_ff, NULL, 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56c0_0_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_2_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_0_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_0_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_0_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_0_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_0_ff, NULL, 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_56f8_0_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_0_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_56fa_0_ff, NULL, 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56fb_0_ff, NULL, 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56fc_0_ff, NULL, 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57c0_0_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_2_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_0_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_0_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_0_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_0_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_0_ff, NULL, 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_57f8_0_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_0_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_57fa_0_ff, NULL, 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57fb_0_ff, NULL, 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57fc_0_ff, NULL, 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58c0_0_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_2_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_0_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_0_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_0_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_0_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_0_ff, NULL, 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_58f8_0_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_0_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_58fa_0_ff, NULL, 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58fb_0_ff, NULL, 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58fc_0_ff, NULL, 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59c0_0_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_2_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_0_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_0_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_0_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_0_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_0_ff, NULL, 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_59f8_0_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_0_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_59fa_0_ff, NULL, 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59fb_0_ff, NULL, 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59fc_0_ff, NULL, 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ac0_0_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_2_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_0_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_0_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_0_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_0_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_0_ff, NULL, 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5af8_0_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_0_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5afa_0_ff, NULL, 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5afb_0_ff, NULL, 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5afc_0_ff, NULL, 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bc0_0_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_2_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_0_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_0_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_0_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_0_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_0_ff, NULL, 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5bf8_0_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_0_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5bfa_0_ff, NULL, 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bfb_0_ff, NULL, 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bfc_0_ff, NULL, 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cc0_0_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_2_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_0_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_0_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_0_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_0_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_0_ff, NULL, 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5cf8_0_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_0_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5cfa_0_ff, NULL, 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cfb_0_ff, NULL, 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cfc_0_ff, NULL, 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dc0_0_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_2_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_0_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_0_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_0_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_0_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_0_ff, NULL, 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5df8_0_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_0_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5dfa_0_ff, NULL, 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dfb_0_ff, NULL, 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dfc_0_ff, NULL, 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ec0_0_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_2_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_0_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_0_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_0_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_0_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_0_ff, NULL, 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ef8_0_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_0_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5efa_0_ff, NULL, 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5efb_0_ff, NULL, 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5efc_0_ff, NULL, 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5fc0_0_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_2_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_0_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_0_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_0_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_0_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_0_ff, NULL, 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ff8_0_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_0_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ffa_0_ff, NULL, 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ffb_0_ff, NULL, 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ffc_0_ff, NULL, 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_6000_2_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_2_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_2_ff, NULL, 0x60ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6100_2_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_2_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_2_ff, NULL, 0x61ff, 6, { 0, 0 }, 3 }, /* BSR */
{ op_6200_2_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_2_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_2_ff, NULL, 0x62ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6300_2_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_2_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_2_ff, NULL, 0x63ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6400_2_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_2_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_2_ff, NULL, 0x64ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6500_2_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_2_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_2_ff, NULL, 0x65ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6600_2_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_2_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_2_ff, NULL, 0x66ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6700_2_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_2_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_2_ff, NULL, 0x67ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6800_2_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_2_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_2_ff, NULL, 0x68ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6900_2_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_2_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_2_ff, NULL, 0x69ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6a00_2_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_2_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_2_ff, NULL, 0x6aff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6b00_2_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_2_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_2_ff, NULL, 0x6bff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6c00_2_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_2_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_2_ff, NULL, 0x6cff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6d00_2_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_2_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_2_ff, NULL, 0x6dff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6e00_2_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_2_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_2_ff, NULL, 0x6eff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6f00_2_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_2_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_2_ff, NULL, 0x6fff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_7000_0_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_0_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_0_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_0_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_0_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_0_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_0_ff, NULL, 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ op_8038_0_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_0_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_0_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_0_ff, NULL, 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ op_803c_0_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_0_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_0_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_0_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_0_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_0_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_0_ff, NULL, 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ op_8078_0_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_0_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_0_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_0_ff, NULL, 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ op_807c_0_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_0_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_0_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_0_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_0_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_0_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_0_ff, NULL, 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_80b8_0_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_0_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_0_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_0_ff, NULL, 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ op_80bc_0_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_0_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_0_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_0_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_0_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_0_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_0_ff, NULL, 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80f8_0_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_0_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_0_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_0_ff, NULL, 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80fc_0_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_2_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_2_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_0_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_0_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_0_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_0_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_0_ff, NULL, 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ op_8138_0_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_0_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ op_8140_0_ff, NULL, 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
{ op_8148_0_ff, NULL, 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
{ op_8150_0_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_0_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_0_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_0_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_0_ff, NULL, 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ op_8178_0_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_0_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ op_8180_0_ff, NULL, 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
{ op_8188_0_ff, NULL, 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
{ op_8190_0_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_0_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_0_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_0_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_0_ff, NULL, 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_81b8_0_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_0_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_0_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_0_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_0_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_0_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_0_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_0_ff, NULL, 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81f8_0_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_0_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_0_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_0_ff, NULL, 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81fc_0_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_0_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_0_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_0_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_0_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_0_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_0_ff, NULL, 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9038_0_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_0_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_0_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_0_ff, NULL, 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_903c_0_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_0_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_0_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_0_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_0_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_0_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_0_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_0_ff, NULL, 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9078_0_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_0_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_0_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_0_ff, NULL, 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_907c_0_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_0_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_0_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_0_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_0_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_0_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_0_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_0_ff, NULL, 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90b8_0_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_0_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_0_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_0_ff, NULL, 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90bc_0_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_0_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_0_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_0_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_0_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_0_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_0_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_0_ff, NULL, 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90f8_0_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_0_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_0_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_0_ff, NULL, 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90fc_0_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_0_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_0_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_0_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_0_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_0_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_0_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_0_ff, NULL, 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9138_0_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_0_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_0_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_0_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_0_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_0_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_0_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_0_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_0_ff, NULL, 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9178_0_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_0_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_0_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_0_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_0_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_0_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_0_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_0_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_0_ff, NULL, 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_91b8_0_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_0_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_0_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_0_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_0_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_0_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_0_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_0_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_0_ff, NULL, 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91f8_0_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_0_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_0_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_0_ff, NULL, 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91fc_0_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_0_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_0_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_0_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_0_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_0_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_0_ff, NULL, 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b038_0_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_0_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_0_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_0_ff, NULL, 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b03c_0_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_0_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_0_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_0_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_0_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_0_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_0_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_0_ff, NULL, 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b078_0_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_0_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_0_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_0_ff, NULL, 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b07c_0_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_0_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_0_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_0_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_0_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_0_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_0_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_0_ff, NULL, 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0b8_0_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_0_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_0_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_0_ff, NULL, 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0bc_0_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_0_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_0_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_0_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_0_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_0_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_0_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_0_ff, NULL, 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0f8_0_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_0_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_0_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_0_ff, NULL, 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0fc_0_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_0_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_0_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_0_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_0_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_0_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_0_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_0_ff, NULL, 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b138_0_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_0_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_0_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_0_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_0_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_0_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_0_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_0_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_0_ff, NULL, 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b178_0_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_0_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_0_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_0_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_0_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_0_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_0_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_0_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_0_ff, NULL, 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b1b8_0_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_0_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_0_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_0_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_0_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_0_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_0_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_0_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_0_ff, NULL, 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1f8_0_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_0_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_0_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_0_ff, NULL, 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1fc_0_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_0_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_0_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_0_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_0_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_0_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_0_ff, NULL, 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ op_c038_0_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_0_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_0_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_0_ff, NULL, 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c03c_0_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_0_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_0_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_0_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_0_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_0_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_0_ff, NULL, 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ op_c078_0_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_0_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_0_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_0_ff, NULL, 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c07c_0_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_0_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_0_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_0_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_0_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_0_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_0_ff, NULL, 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0b8_0_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_0_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_0_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_0_ff, NULL, 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0bc_0_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_0_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_0_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_0_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_0_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_0_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_0_ff, NULL, 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0f8_0_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_0_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_0_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_0_ff, NULL, 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0fc_0_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_2_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_2_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_0_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_0_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_0_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_0_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_0_ff, NULL, 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ op_c138_0_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_0_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_0_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_0_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_0_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_0_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_0_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_0_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_0_ff, NULL, 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ op_c178_0_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_0_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_0_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_0_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_0_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_0_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_0_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_0_ff, NULL, 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c1b8_0_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_0_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_0_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_0_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_0_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_0_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_0_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_0_ff, NULL, 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1f8_0_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_0_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_0_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_0_ff, NULL, 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1fc_0_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_0_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_0_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_0_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_0_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_0_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_0_ff, NULL, 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d038_0_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_0_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_0_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_0_ff, NULL, 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d03c_0_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_0_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_0_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_0_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_0_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_0_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_0_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_0_ff, NULL, 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d078_0_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_0_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_0_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_0_ff, NULL, 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d07c_0_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_0_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_0_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_0_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_0_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_0_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_0_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_0_ff, NULL, 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0b8_0_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_0_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_0_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_0_ff, NULL, 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0bc_0_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_0_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_0_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_0_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_0_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_0_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_0_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_0_ff, NULL, 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0f8_0_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_0_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_0_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_0_ff, NULL, 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0fc_0_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_0_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_0_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_0_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_0_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_0_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_0_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_0_ff, NULL, 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d138_0_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_0_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_0_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_0_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_0_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_0_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_0_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_0_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_0_ff, NULL, 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d178_0_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_0_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_0_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_0_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_0_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_0_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_0_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_0_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_0_ff, NULL, 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d1b8_0_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_0_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_0_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_0_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_0_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_0_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_0_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_0_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_0_ff, NULL, 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1f8_0_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_0_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_0_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_0_ff, NULL, 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1fc_0_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_0_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_0_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_0_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_0_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_0_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_0_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_0_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_0_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_0_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_0_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_0_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_0_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_0_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_0_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_0_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_0_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_0_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_0_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_0_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_0_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_0_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_0_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_0_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_0_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_0_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_0_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_0_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_0_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_0_ff, NULL, 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ op_e0f8_0_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_0_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_0_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_0_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_0_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_0_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_0_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_0_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_0_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_0_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_0_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_0_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_0_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_0_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_0_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_0_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_0_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_0_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_0_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_0_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_0_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_0_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_0_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_0_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_0_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_0_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_0_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_0_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_0_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_0_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_0_ff, NULL, 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ op_e1f8_0_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_0_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_0_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_0_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_0_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_0_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_0_ff, NULL, 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ op_e2f8_0_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_0_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_0_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_0_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_0_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_0_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_0_ff, NULL, 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ op_e3f8_0_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_0_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_0_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_0_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_0_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_0_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_0_ff, NULL, 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ op_e4f8_0_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_0_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_0_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_0_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_0_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_0_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_0_ff, NULL, 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ op_e5f8_0_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_0_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_0_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_0_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_0_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_0_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_0_ff, NULL, 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ op_e6f8_0_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_0_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_0_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_0_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_0_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_0_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_0_ff, NULL, 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ op_e7f8_0_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_0_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ op_e8c0_0_ff, NULL, 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
{ op_e8d0_0_ff, NULL, 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
{ op_e8e8_0_ff, NULL, 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8f0_0_ff, NULL, 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
{ op_e8f8_0_ff, NULL, 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8f9_0_ff, NULL, 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
{ op_e8fa_0_ff, NULL, 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8fb_0_ff, NULL, 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
{ op_e9c0_0_ff, NULL, 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9d0_0_ff, NULL, 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9e8_0_ff, NULL, 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9f0_0_ff, NULL, 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ op_e9f8_0_ff, NULL, 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9f9_0_ff, NULL, 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9fa_0_ff, NULL, 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9fb_0_ff, NULL, 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ op_eac0_0_ff, NULL, 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ op_ead0_0_ff, NULL, 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ op_eae8_0_ff, NULL, 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ op_eaf0_0_ff, NULL, 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
{ op_eaf8_0_ff, NULL, 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ op_eaf9_0_ff, NULL, 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
{ op_ebc0_0_ff, NULL, 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebd0_0_ff, NULL, 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebe8_0_ff, NULL, 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebf0_0_ff, NULL, 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ op_ebf8_0_ff, NULL, 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebf9_0_ff, NULL, 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebfa_0_ff, NULL, 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebfb_0_ff, NULL, 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ op_ecc0_0_ff, NULL, 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecd0_0_ff, NULL, 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ op_ece8_0_ff, NULL, 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecf0_0_ff, NULL, 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
{ op_ecf8_0_ff, NULL, 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecf9_0_ff, NULL, 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
{ op_edc0_0_ff, NULL, 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ op_edd0_0_ff, NULL, 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ op_ede8_0_ff, NULL, 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edf0_0_ff, NULL, 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
{ op_edf8_0_ff, NULL, 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edf9_0_ff, NULL, 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
{ op_edfa_0_ff, NULL, 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edfb_0_ff, NULL, 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
{ op_eec0_0_ff, NULL, 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
{ op_eed0_0_ff, NULL, 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
{ op_eee8_0_ff, NULL, 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
{ op_eef0_0_ff, NULL, 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
{ op_eef8_0_ff, NULL, 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
{ op_eef9_0_ff, NULL, 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
{ op_efc0_0_ff, NULL, 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
{ op_efd0_0_ff, NULL, 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
{ op_efe8_0_ff, NULL, 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
{ op_eff0_0_ff, NULL, 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
{ op_eff8_0_ff, NULL, 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
{ op_eff9_0_ff, NULL, 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
{ op_f000_0_ff, NULL, 0xf000, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f008_0_ff, NULL, 0xf008, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f010_0_ff, NULL, 0xf010, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f018_0_ff, NULL, 0xf018, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f020_0_ff, NULL, 0xf020, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f028_0_ff, NULL, 0xf028, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f030_0_ff, NULL, 0xf030, -1, { -3, 0 }, 0 }, /* MMUOP030 */
{ op_f038_0_ff, NULL, 0xf038, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f039_0_ff, NULL, 0xf039, -1, { 0, 0 }, 0 }, /* MMUOP030 */
{ op_f200_0_ff, NULL, 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f208_0_ff, NULL, 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f210_0_ff, NULL, 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f218_0_ff, NULL, 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f220_0_ff, NULL, 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f228_0_ff, NULL, 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f230_0_ff, NULL, 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f238_0_ff, NULL, 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f239_0_ff, NULL, 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23a_0_ff, NULL, 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23b_0_ff, NULL, 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23c_0_ff, NULL, 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f240_0_ff, NULL, 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f248_0_ff, NULL, 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
{ op_f250_0_ff, NULL, 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f258_0_ff, NULL, 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f260_0_ff, NULL, 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f268_0_ff, NULL, 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f270_0_ff, NULL, 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f278_0_ff, NULL, 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f279_0_ff, NULL, 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f27a_0_ff, NULL, 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f27b_0_ff, NULL, 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f27c_0_ff, NULL, 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f280_0_ff, NULL, 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
{ op_f2c0_0_ff, NULL, 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
{ op_f310_0_ff, NULL, 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f320_0_ff, NULL, 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f328_0_ff, NULL, 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f330_0_ff, NULL, 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f338_0_ff, NULL, 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f339_0_ff, NULL, 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f350_0_ff, NULL, 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f358_0_ff, NULL, 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f368_0_ff, NULL, 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f370_0_ff, NULL, 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f378_0_ff, NULL, 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f379_0_ff, NULL, 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f37a_0_ff, NULL, 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f37b_0_ff, NULL, 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_68000_ONLY */
#ifndef CPUEMU_68000_ONLY
const struct cputbl op_smalltbl_3[] = {
{ op_0000_0_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_0_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_0_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_0_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_0_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_0_ff, NULL, 0x0030, 4, { 2, 0 }, 0 }, /* OR */
{ op_0038_0_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_0_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_3_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_0_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_0_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_0_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_0_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_0_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_0_ff, NULL, 0x0070, 4, { 2, 0 }, 0 }, /* OR */
{ op_0078_0_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_0_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_3_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_0_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_0_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_0_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_0_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_0_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_0_ff, NULL, 0x00b0, 6, { 2, 0 }, 0 }, /* OR */
{ op_00b8_0_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_0_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ op_00d0_0_ff, NULL, 0x00d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_00e8_0_ff, NULL, 0x00e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00f0_0_ff, NULL, 0x00f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_00f8_0_ff, NULL, 0x00f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00f9_0_ff, NULL, 0x00f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_00fa_0_ff, NULL, 0x00fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_00fb_0_ff, NULL, 0x00fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0100_0_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_0_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_0_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_0_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_0_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_0_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_0_ff, NULL, 0x0130, 2, { 2, 0 }, 0 }, /* BTST */
{ op_0138_0_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_0_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_0_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_0_ff, NULL, 0x013b, 2, { 2, 0 }, 0 }, /* BTST */
{ op_013c_0_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_0_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_0_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_0_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_0_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_0_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_0_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_0_ff, NULL, 0x0170, 2, { 2, 0 }, 0 }, /* BCHG */
{ op_0178_0_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_0_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_0_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_0_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_0_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_0_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_0_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_0_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_0_ff, NULL, 0x01b0, 2, { 2, 0 }, 0 }, /* BCLR */
{ op_01b8_0_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_0_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_0_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_0_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_0_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_0_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_0_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_0_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_0_ff, NULL, 0x01f0, 2, { 2, 0 }, 0 }, /* BSET */
{ op_01f8_0_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_0_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_0_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_0_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_0_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_0_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_0_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_0_ff, NULL, 0x0230, 4, { 2, 0 }, 0 }, /* AND */
{ op_0238_0_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_0_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_3_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_0_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_0_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_0_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_0_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_0_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_0_ff, NULL, 0x0270, 4, { 2, 0 }, 0 }, /* AND */
{ op_0278_0_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_0_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_3_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_0_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_0_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_0_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_0_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_0_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_0_ff, NULL, 0x02b0, 6, { 2, 0 }, 0 }, /* AND */
{ op_02b8_0_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_0_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ op_02d0_0_ff, NULL, 0x02d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_02e8_0_ff, NULL, 0x02e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02f0_0_ff, NULL, 0x02f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_02f8_0_ff, NULL, 0x02f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02f9_0_ff, NULL, 0x02f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_02fa_0_ff, NULL, 0x02fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_02fb_0_ff, NULL, 0x02fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0400_0_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_0_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_0_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_0_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_0_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_0_ff, NULL, 0x0430, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0438_0_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_0_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_0_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_0_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_0_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_0_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_0_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_0_ff, NULL, 0x0470, 4, { 2, 0 }, 0 }, /* SUB */
{ op_0478_0_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_0_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_0_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_0_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_0_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_0_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_0_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_0_ff, NULL, 0x04b0, 6, { 2, 0 }, 0 }, /* SUB */
{ op_04b8_0_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_0_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ op_04d0_0_ff, NULL, 0x04d0, 4, { 0, 0 }, 0 }, /* CHK2 */
{ op_04e8_0_ff, NULL, 0x04e8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04f0_0_ff, NULL, 0x04f0, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_04f8_0_ff, NULL, 0x04f8, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04f9_0_ff, NULL, 0x04f9, 8, { 0, 0 }, 0 }, /* CHK2 */
{ op_04fa_0_ff, NULL, 0x04fa, 6, { 0, 0 }, 0 }, /* CHK2 */
{ op_04fb_0_ff, NULL, 0x04fb, 4, { 2, 0 }, 0 }, /* CHK2 */
{ op_0600_0_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_0_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_0_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_0_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_0_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_0_ff, NULL, 0x0630, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0638_0_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_0_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_0_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_0_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_0_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_0_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_0_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_0_ff, NULL, 0x0670, 4, { 2, 0 }, 0 }, /* ADD */
{ op_0678_0_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_0_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_0_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_0_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_0_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_0_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_0_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_0_ff, NULL, 0x06b0, 6, { 2, 0 }, 0 }, /* ADD */
{ op_06b8_0_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_0_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ op_06c0_0_ff, NULL, 0x06c0, 2, { 0, 0 }, 0 }, /* RTM */
{ op_06c8_0_ff, NULL, 0x06c8, 2, { 0, 0 }, 0 }, /* RTM */
{ op_06d0_0_ff, NULL, 0x06d0, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06e8_0_ff, NULL, 0x06e8, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f0_0_ff, NULL, 0x06f0, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f8_0_ff, NULL, 0x06f8, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06f9_0_ff, NULL, 0x06f9, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06fa_0_ff, NULL, 0x06fa, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_06fb_0_ff, NULL, 0x06fb, 2, { 0, 0 }, 0 }, /* CALLM */
{ op_0800_0_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_0_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_0_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_0_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_0_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_0_ff, NULL, 0x0830, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0838_0_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_0_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_0_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_0_ff, NULL, 0x083b, 4, { 2, 0 }, 0 }, /* BTST */
{ op_0840_0_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_0_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_0_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_0_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_0_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_0_ff, NULL, 0x0870, 4, { 2, 0 }, 0 }, /* BCHG */
{ op_0878_0_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_0_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_0_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_0_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_0_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_0_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_0_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_0_ff, NULL, 0x08b0, 4, { 2, 0 }, 0 }, /* BCLR */
{ op_08b8_0_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_0_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_0_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_0_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_0_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_0_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_0_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_0_ff, NULL, 0x08f0, 4, { 2, 0 }, 0 }, /* BSET */
{ op_08f8_0_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_0_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_0_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_0_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_0_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_0_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_0_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_0_ff, NULL, 0x0a30, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a38_0_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_0_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_3_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_0_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_0_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_0_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_0_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_0_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_0_ff, NULL, 0x0a70, 4, { 2, 0 }, 0 }, /* EOR */
{ op_0a78_0_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_0_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_3_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_0_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_0_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_0_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_0_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_0_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_0_ff, NULL, 0x0ab0, 6, { 2, 0 }, 0 }, /* EOR */
{ op_0ab8_0_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_0_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ op_0ad0_2_ff, NULL, 0x0ad0, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ad8_2_ff, NULL, 0x0ad8, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ae0_2_ff, NULL, 0x0ae0, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ae8_2_ff, NULL, 0x0ae8, 6, { 0, 0 }, 0 }, /* CAS */
{ op_0af0_2_ff, NULL, 0x0af0, 4, { 2, 0 }, 0 }, /* CAS */
{ op_0af8_2_ff, NULL, 0x0af8, 6, { 0, 0 }, 0 }, /* CAS */
{ op_0af9_2_ff, NULL, 0x0af9, 8, { 0, 0 }, 0 }, /* CAS */
{ op_0c00_0_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_0_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_0_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_0_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_0_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_0_ff, NULL, 0x0c30, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c38_0_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_0_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c3a_0_ff, NULL, 0x0c3a, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c3b_0_ff, NULL, 0x0c3b, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c40_0_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_0_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_0_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_0_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_0_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_0_ff, NULL, 0x0c70, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c78_0_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_0_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c7a_0_ff, NULL, 0x0c7a, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c7b_0_ff, NULL, 0x0c7b, 4, { 2, 0 }, 0 }, /* CMP */
{ op_0c80_0_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_0_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_0_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_0_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_0_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_0_ff, NULL, 0x0cb0, 6, { 2, 0 }, 0 }, /* CMP */
{ op_0cb8_0_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_0_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ op_0cba_0_ff, NULL, 0x0cba, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cbb_0_ff, NULL, 0x0cbb, 6, { 2, 0 }, 0 }, /* CMP */
{ op_0cd0_2_ff, NULL, 0x0cd0, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0cd8_2_ff, NULL, 0x0cd8, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ce0_2_ff, NULL, 0x0ce0, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ce8_2_ff, NULL, 0x0ce8, 6, { 0, 0 }, 0 }, /* CAS */
{ op_0cf0_2_ff, NULL, 0x0cf0, 4, { 2, 0 }, 0 }, /* CAS */
{ op_0cf8_2_ff, NULL, 0x0cf8, 6, { 0, 0 }, 0 }, /* CAS */
{ op_0cf9_2_ff, NULL, 0x0cf9, 8, { 0, 0 }, 0 }, /* CAS */
{ op_0cfc_2_ff, NULL, 0x0cfc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ op_0e10_2_ff, NULL, 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e18_2_ff, NULL, 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e20_2_ff, NULL, 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e28_2_ff, NULL, 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0e30_2_ff, NULL, 0x0e30, 4, { 2, 2 }, 0 }, /* MOVES */
{ op_0e38_2_ff, NULL, 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0e39_2_ff, NULL, 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
{ op_0e50_2_ff, NULL, 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e58_2_ff, NULL, 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e60_2_ff, NULL, 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e68_2_ff, NULL, 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0e70_2_ff, NULL, 0x0e70, 4, { 2, 2 }, 0 }, /* MOVES */
{ op_0e78_2_ff, NULL, 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0e79_2_ff, NULL, 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
{ op_0e90_2_ff, NULL, 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e98_2_ff, NULL, 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0ea0_2_ff, NULL, 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0ea8_2_ff, NULL, 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0eb0_2_ff, NULL, 0x0eb0, 4, { 2, 2 }, 0 }, /* MOVES */
{ op_0eb8_2_ff, NULL, 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0eb9_2_ff, NULL, 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
{ op_0ed0_2_ff, NULL, 0x0ed0, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ed8_2_ff, NULL, 0x0ed8, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ee0_2_ff, NULL, 0x0ee0, 4, { 0, 0 }, 0 }, /* CAS */
{ op_0ee8_2_ff, NULL, 0x0ee8, 6, { 0, 0 }, 0 }, /* CAS */
{ op_0ef0_2_ff, NULL, 0x0ef0, 4, { 2, 0 }, 0 }, /* CAS */
{ op_0ef8_2_ff, NULL, 0x0ef8, 6, { 0, 0 }, 0 }, /* CAS */
{ op_0ef9_2_ff, NULL, 0x0ef9, 8, { 0, 0 }, 0 }, /* CAS */
{ op_0efc_2_ff, NULL, 0x0efc, 6, { 0, 0 }, 0 }, /* CAS2 */
{ op_1000_0_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_0_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_0_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_0_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_0_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_0_ff, NULL, 0x1030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1038_0_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_0_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_0_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_0_ff, NULL, 0x103b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_103c_0_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_0_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_0_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_0_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_0_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_0_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_0_ff, NULL, 0x10b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10b8_0_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_0_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_0_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_0_ff, NULL, 0x10bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10bc_0_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_0_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_0_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_0_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_0_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_0_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_0_ff, NULL, 0x10f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10f8_0_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_0_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_0_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_0_ff, NULL, 0x10fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_10fc_0_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_0_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_0_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_0_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_0_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_0_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_0_ff, NULL, 0x1130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1138_0_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_0_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_0_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_0_ff, NULL, 0x113b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_113c_0_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_0_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_0_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_0_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_0_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_0_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_0_ff, NULL, 0x1170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1178_0_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_0_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_0_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_0_ff, NULL, 0x117b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_117c_0_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_0_ff, NULL, 0x1180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1190_0_ff, NULL, 0x1190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_1198_0_ff, NULL, 0x1198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a0_0_ff, NULL, 0x11a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_11a8_0_ff, NULL, 0x11a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b0_0_ff, NULL, 0x11b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11b8_0_ff, NULL, 0x11b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11b9_0_ff, NULL, 0x11b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_11ba_0_ff, NULL, 0x11ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11bb_0_ff, NULL, 0x11bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_11bc_0_ff, NULL, 0x11bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_11c0_0_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_0_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_0_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_0_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_0_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_0_ff, NULL, 0x11f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11f8_0_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_0_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_0_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_0_ff, NULL, 0x11fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11fc_0_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_0_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_0_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_0_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_0_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_0_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_0_ff, NULL, 0x13f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13f8_0_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_0_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_0_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_0_ff, NULL, 0x13fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_13fc_0_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_0_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_0_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_0_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_0_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_0_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_0_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_0_ff, NULL, 0x2030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2038_0_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_0_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_0_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_0_ff, NULL, 0x203b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_203c_0_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_0_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_0_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_0_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_0_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_0_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_0_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_0_ff, NULL, 0x2070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_2078_0_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_0_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_0_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_0_ff, NULL, 0x207b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_207c_0_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_0_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_0_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_0_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_0_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_0_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_0_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_0_ff, NULL, 0x20b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20b8_0_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_0_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_0_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_0_ff, NULL, 0x20bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20bc_0_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_0_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_0_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_0_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_0_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_0_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_0_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_0_ff, NULL, 0x20f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20f8_0_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_0_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_0_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_0_ff, NULL, 0x20fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_20fc_0_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_0_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_0_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_0_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_0_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_0_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_0_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_0_ff, NULL, 0x2130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2138_0_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_0_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_0_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_0_ff, NULL, 0x213b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_213c_0_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_0_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_0_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_0_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_0_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_0_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_0_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_0_ff, NULL, 0x2170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2178_0_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_0_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_0_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_0_ff, NULL, 0x217b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_217c_0_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_0_ff, NULL, 0x2180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2188_0_ff, NULL, 0x2188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2190_0_ff, NULL, 0x2190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_2198_0_ff, NULL, 0x2198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a0_0_ff, NULL, 0x21a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_21a8_0_ff, NULL, 0x21a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b0_0_ff, NULL, 0x21b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21b8_0_ff, NULL, 0x21b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21b9_0_ff, NULL, 0x21b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21ba_0_ff, NULL, 0x21ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_21bb_0_ff, NULL, 0x21bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_21bc_0_ff, NULL, 0x21bc, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_21c0_0_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_0_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_0_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_0_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_0_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_0_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_0_ff, NULL, 0x21f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21f8_0_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_0_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_0_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_0_ff, NULL, 0x21fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21fc_0_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_0_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_0_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_0_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_0_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_0_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_0_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_0_ff, NULL, 0x23f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23f8_0_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_0_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_0_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_0_ff, NULL, 0x23fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_23fc_0_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_0_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_0_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_0_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_0_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_0_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_0_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_0_ff, NULL, 0x3030, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3038_0_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_0_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_0_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_0_ff, NULL, 0x303b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_303c_0_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_0_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_0_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_0_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_0_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_0_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_0_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_0_ff, NULL, 0x3070, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_3078_0_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_0_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_0_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_0_ff, NULL, 0x307b, 2, { 2, 0 }, 0 }, /* MOVEA */
{ op_307c_0_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_0_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_0_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_0_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_0_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_0_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_0_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_0_ff, NULL, 0x30b0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30b8_0_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_0_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_0_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_0_ff, NULL, 0x30bb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30bc_0_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_0_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_0_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_0_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_0_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_0_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_0_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_0_ff, NULL, 0x30f0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30f8_0_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_0_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_0_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_0_ff, NULL, 0x30fb, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_30fc_0_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_0_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_0_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_0_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_0_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_0_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_0_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_0_ff, NULL, 0x3130, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3138_0_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_0_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_0_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_0_ff, NULL, 0x313b, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_313c_0_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_0_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_0_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_0_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_0_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_0_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_0_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_0_ff, NULL, 0x3170, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3178_0_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_0_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_0_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_0_ff, NULL, 0x317b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_317c_0_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_0_ff, NULL, 0x3180, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3188_0_ff, NULL, 0x3188, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3190_0_ff, NULL, 0x3190, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_3198_0_ff, NULL, 0x3198, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a0_0_ff, NULL, 0x31a0, 2, { 2, 0 }, 0 }, /* MOVE */
{ op_31a8_0_ff, NULL, 0x31a8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b0_0_ff, NULL, 0x31b0, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31b8_0_ff, NULL, 0x31b8, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31b9_0_ff, NULL, 0x31b9, 6, { 2, 0 }, 0 }, /* MOVE */
{ op_31ba_0_ff, NULL, 0x31ba, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31bb_0_ff, NULL, 0x31bb, 2, { 2, 2 }, 0 }, /* MOVE */
{ op_31bc_0_ff, NULL, 0x31bc, 4, { 2, 0 }, 0 }, /* MOVE */
{ op_31c0_0_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_0_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_0_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_0_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_0_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_0_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_0_ff, NULL, 0x31f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31f8_0_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_0_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_0_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_0_ff, NULL, 0x31fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31fc_0_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_0_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_0_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_0_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_0_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_0_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_0_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_0_ff, NULL, 0x33f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33f8_0_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_0_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_0_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_0_ff, NULL, 0x33fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_33fc_0_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_0_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_0_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_0_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_0_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_0_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_0_ff, NULL, 0x4030, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4038_0_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_0_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_0_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_0_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_0_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_0_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_0_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_0_ff, NULL, 0x4070, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_4078_0_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_0_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_0_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_0_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_0_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_0_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_0_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_0_ff, NULL, 0x40b0, 2, { 2, 0 }, 0 }, /* NEGX */
{ op_40b8_0_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_0_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_0_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_0_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_0_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_0_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_0_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_0_ff, NULL, 0x40f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ op_40f8_0_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_0_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4100_0_ff, NULL, 0x4100, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4110_0_ff, NULL, 0x4110, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4118_0_ff, NULL, 0x4118, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4120_0_ff, NULL, 0x4120, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4128_0_ff, NULL, 0x4128, 4, { 0, 0 }, 0 }, /* CHK */
{ op_4130_0_ff, NULL, 0x4130, 2, { 2, 0 }, 0 }, /* CHK */
{ op_4138_0_ff, NULL, 0x4138, 4, { 0, 0 }, 0 }, /* CHK */
{ op_4139_0_ff, NULL, 0x4139, 6, { 0, 0 }, 0 }, /* CHK */
{ op_413a_0_ff, NULL, 0x413a, 4, { 0, 0 }, 0 }, /* CHK */
{ op_413b_0_ff, NULL, 0x413b, 2, { 2, 0 }, 0 }, /* CHK */
{ op_413c_0_ff, NULL, 0x413c, 6, { 0, 0 }, 0 }, /* CHK */
{ op_4180_0_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_0_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_0_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_0_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_0_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_0_ff, NULL, 0x41b0, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41b8_0_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_0_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_0_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_0_ff, NULL, 0x41bb, 2, { 2, 0 }, 0 }, /* CHK */
{ op_41bc_0_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_0_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_0_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_0_ff, NULL, 0x41f0, 2, { 2, 0 }, 0 }, /* LEA */
{ op_41f8_0_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_0_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_0_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_0_ff, NULL, 0x41fb, 2, { 2, 0 }, 0 }, /* LEA */
{ op_4200_0_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_0_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_0_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_0_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_0_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_0_ff, NULL, 0x4230, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4238_0_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_0_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_0_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_0_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_0_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_0_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_0_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_0_ff, NULL, 0x4270, 2, { 2, 0 }, 0 }, /* CLR */
{ op_4278_0_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_0_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_0_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_0_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_0_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_0_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_0_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_0_ff, NULL, 0x42b0, 2, { 2, 0 }, 0 }, /* CLR */
{ op_42b8_0_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_0_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ op_42c0_0_ff, NULL, 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d0_0_ff, NULL, 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d8_0_ff, NULL, 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e0_0_ff, NULL, 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e8_0_ff, NULL, 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42f0_0_ff, NULL, 0x42f0, 2, { 2, 0 }, 0 }, /* MVSR2 */
{ op_42f8_0_ff, NULL, 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42f9_0_ff, NULL, 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4400_0_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_0_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_0_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_0_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_0_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_0_ff, NULL, 0x4430, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4438_0_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_0_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_0_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_0_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_0_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_0_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_0_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_0_ff, NULL, 0x4470, 2, { 2, 0 }, 0 }, /* NEG */
{ op_4478_0_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_0_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_0_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_0_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_0_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_0_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_0_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_0_ff, NULL, 0x44b0, 2, { 2, 0 }, 0 }, /* NEG */
{ op_44b8_0_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_0_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_0_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_0_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_0_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_0_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_0_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_0_ff, NULL, 0x44f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44f8_0_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_0_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_0_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_0_ff, NULL, 0x44fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_44fc_0_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_0_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_0_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_0_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_0_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_0_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_0_ff, NULL, 0x4630, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4638_0_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_0_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_0_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_0_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_0_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_0_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_0_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_0_ff, NULL, 0x4670, 2, { 2, 0 }, 0 }, /* NOT */
{ op_4678_0_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_0_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_0_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_0_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_0_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_0_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_0_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_0_ff, NULL, 0x46b0, 2, { 2, 0 }, 0 }, /* NOT */
{ op_46b8_0_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_0_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_0_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_0_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_0_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_0_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_0_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_0_ff, NULL, 0x46f0, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46f8_0_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_0_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_0_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_0_ff, NULL, 0x46fb, 2, { 2, 0 }, 0 }, /* MV2SR */
{ op_46fc_0_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_2_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4808_1_ff, NULL, 0x4808, 6, { 0, 0 }, 0 }, /* LINK */
{ op_4810_2_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_2_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_2_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_2_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_2_ff, NULL, 0x4830, 2, { 2, 0 }, 0 }, /* NBCD */
{ op_4838_2_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_2_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_0_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ op_4848_0_ff, NULL, 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
{ op_4850_0_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_0_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_0_ff, NULL, 0x4870, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4878_0_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_0_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_0_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_0_ff, NULL, 0x487b, 2, { 2, 0 }, 0 }, /* PEA */
{ op_4880_0_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_2_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_2_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_2_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_2_ff, NULL, 0x48b0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48b8_2_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_2_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_0_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_2_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_2_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_2_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_2_ff, NULL, 0x48f0, 4, { 2, 0 }, 0 }, /* MVMLE */
{ op_48f8_2_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_2_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_49c0_0_ff, NULL, 0x49c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4a00_0_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_0_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_0_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_0_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_0_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_0_ff, NULL, 0x4a30, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a38_0_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_0_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a3a_0_ff, NULL, 0x4a3a, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a3b_0_ff, NULL, 0x4a3b, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a3c_0_ff, NULL, 0x4a3c, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a40_0_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a48_0_ff, NULL, 0x4a48, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a50_0_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_0_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_0_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_0_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_0_ff, NULL, 0x4a70, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a78_0_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_0_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a7a_0_ff, NULL, 0x4a7a, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a7b_0_ff, NULL, 0x4a7b, 2, { 2, 0 }, 0 }, /* TST */
{ op_4a7c_0_ff, NULL, 0x4a7c, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a80_0_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a88_0_ff, NULL, 0x4a88, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a90_0_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_0_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_0_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_0_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_0_ff, NULL, 0x4ab0, 2, { 2, 0 }, 0 }, /* TST */
{ op_4ab8_0_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_0_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ op_4aba_0_ff, NULL, 0x4aba, 4, { 0, 0 }, 0 }, /* TST */
{ op_4abb_0_ff, NULL, 0x4abb, 2, { 2, 0 }, 0 }, /* TST */
{ op_4abc_0_ff, NULL, 0x4abc, 6, { 0, 0 }, 0 }, /* TST */
{ op_4ac0_0_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad0_0_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_0_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_0_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_0_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_0_ff, NULL, 0x4af0, 2, { 2, 0 }, 0 }, /* TAS */
{ op_4af8_0_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_0_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ op_4c00_0_ff, NULL, 0x4c00, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c10_0_ff, NULL, 0x4c10, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c18_0_ff, NULL, 0x4c18, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c20_0_ff, NULL, 0x4c20, 4, { 0, 0 }, 0 }, /* MULL */
{ op_4c28_0_ff, NULL, 0x4c28, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c30_0_ff, NULL, 0x4c30, 4, { 2, 0 }, 0 }, /* MULL */
{ op_4c38_0_ff, NULL, 0x4c38, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c39_0_ff, NULL, 0x4c39, 8, { 0, 0 }, 0 }, /* MULL */
{ op_4c3a_0_ff, NULL, 0x4c3a, 6, { 0, 0 }, 0 }, /* MULL */
{ op_4c3b_0_ff, NULL, 0x4c3b, 4, { 2, 0 }, 0 }, /* MULL */
{ op_4c3c_0_ff, NULL, 0x4c3c, 8, { 0, 0 }, 0 }, /* MULL */
{ op_4c40_0_ff, NULL, 0x4c40, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c50_0_ff, NULL, 0x4c50, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c58_0_ff, NULL, 0x4c58, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c60_0_ff, NULL, 0x4c60, 4, { 0, 0 }, 0 }, /* DIVL */
{ op_4c68_0_ff, NULL, 0x4c68, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c70_0_ff, NULL, 0x4c70, 4, { 2, 0 }, 0 }, /* DIVL */
{ op_4c78_0_ff, NULL, 0x4c78, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c79_0_ff, NULL, 0x4c79, 8, { 0, 0 }, 0 }, /* DIVL */
{ op_4c7a_0_ff, NULL, 0x4c7a, 6, { 0, 0 }, 0 }, /* DIVL */
{ op_4c7b_0_ff, NULL, 0x4c7b, 4, { 2, 0 }, 0 }, /* DIVL */
{ op_4c7c_0_ff, NULL, 0x4c7c, 8, { 0, 0 }, 0 }, /* DIVL */
{ op_4c90_2_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_2_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_2_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_2_ff, NULL, 0x4cb0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cb8_2_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_2_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_2_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_2_ff, NULL, 0x4cbb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cd0_2_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_2_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_2_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_2_ff, NULL, 0x4cf0, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4cf8_2_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_2_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_2_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_2_ff, NULL, 0x4cfb, 4, { 2, 0 }, 0 }, /* MVMEL */
{ op_4e40_0_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_1_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_0_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_2_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_0_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_0_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_2_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_3_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_3_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ op_4e74_2_ff, NULL, 0x4e74, 4, { 0, 0 }, 2 }, /* RTD */
{ op_4e75_2_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_0_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_3_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ op_4e7a_0_ff, NULL, 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
{ op_4e7b_2_ff, NULL, 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
{ op_4e90_2_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_2_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_2_ff, NULL, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4eb8_2_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_2_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_2_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_2_ff, NULL, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4ed0_0_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_0_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_0_ff, NULL, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ op_4ef8_0_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_0_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_0_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_0_ff, NULL, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ op_5000_0_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_0_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_0_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_0_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_0_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_0_ff, NULL, 0x5030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5038_0_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_0_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_0_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_0_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_0_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_0_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_0_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_0_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_0_ff, NULL, 0x5070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_5078_0_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_0_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_0_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_0_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_0_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_0_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_0_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_0_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_0_ff, NULL, 0x50b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_50b8_0_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_0_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_0_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_2_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_0_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_0_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_0_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_0_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_0_ff, NULL, 0x50f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_50f8_0_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_0_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_50fa_0_ff, NULL, 0x50fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_50fb_0_ff, NULL, 0x50fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_50fc_0_ff, NULL, 0x50fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5100_0_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_0_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_0_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_0_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_0_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_0_ff, NULL, 0x5130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5138_0_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_0_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_0_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_0_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_0_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_0_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_0_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_0_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_0_ff, NULL, 0x5170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_5178_0_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_0_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_0_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_0_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_0_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_0_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_0_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_0_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_0_ff, NULL, 0x51b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_51b8_0_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_0_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_0_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_2_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_0_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_0_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_0_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_0_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_0_ff, NULL, 0x51f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_51f8_0_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_0_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_51fa_0_ff, NULL, 0x51fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_51fb_0_ff, NULL, 0x51fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_51fc_0_ff, NULL, 0x51fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52c0_0_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_2_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_0_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_0_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_0_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_0_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_0_ff, NULL, 0x52f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_52f8_0_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_0_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_52fa_0_ff, NULL, 0x52fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52fb_0_ff, NULL, 0x52fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_52fc_0_ff, NULL, 0x52fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53c0_0_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_2_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_0_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_0_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_0_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_0_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_0_ff, NULL, 0x53f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_53f8_0_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_0_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_53fa_0_ff, NULL, 0x53fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53fb_0_ff, NULL, 0x53fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_53fc_0_ff, NULL, 0x53fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54c0_0_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_2_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_0_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_0_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_0_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_0_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_0_ff, NULL, 0x54f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_54f8_0_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_0_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_54fa_0_ff, NULL, 0x54fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54fb_0_ff, NULL, 0x54fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_54fc_0_ff, NULL, 0x54fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55c0_0_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_2_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_0_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_0_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_0_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_0_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_0_ff, NULL, 0x55f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_55f8_0_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_0_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_55fa_0_ff, NULL, 0x55fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55fb_0_ff, NULL, 0x55fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_55fc_0_ff, NULL, 0x55fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56c0_0_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_2_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_0_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_0_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_0_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_0_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_0_ff, NULL, 0x56f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_56f8_0_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_0_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_56fa_0_ff, NULL, 0x56fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56fb_0_ff, NULL, 0x56fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_56fc_0_ff, NULL, 0x56fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57c0_0_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_2_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_0_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_0_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_0_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_0_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_0_ff, NULL, 0x57f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_57f8_0_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_0_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_57fa_0_ff, NULL, 0x57fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57fb_0_ff, NULL, 0x57fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_57fc_0_ff, NULL, 0x57fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58c0_0_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_2_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_0_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_0_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_0_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_0_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_0_ff, NULL, 0x58f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_58f8_0_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_0_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_58fa_0_ff, NULL, 0x58fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58fb_0_ff, NULL, 0x58fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_58fc_0_ff, NULL, 0x58fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59c0_0_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_2_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_0_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_0_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_0_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_0_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_0_ff, NULL, 0x59f0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_59f8_0_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_0_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_59fa_0_ff, NULL, 0x59fa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59fb_0_ff, NULL, 0x59fb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_59fc_0_ff, NULL, 0x59fc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ac0_0_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_2_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_0_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_0_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_0_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_0_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_0_ff, NULL, 0x5af0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5af8_0_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_0_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5afa_0_ff, NULL, 0x5afa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5afb_0_ff, NULL, 0x5afb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5afc_0_ff, NULL, 0x5afc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bc0_0_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_2_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_0_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_0_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_0_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_0_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_0_ff, NULL, 0x5bf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5bf8_0_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_0_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5bfa_0_ff, NULL, 0x5bfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bfb_0_ff, NULL, 0x5bfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5bfc_0_ff, NULL, 0x5bfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cc0_0_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_2_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_0_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_0_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_0_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_0_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_0_ff, NULL, 0x5cf0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5cf8_0_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_0_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5cfa_0_ff, NULL, 0x5cfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cfb_0_ff, NULL, 0x5cfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5cfc_0_ff, NULL, 0x5cfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dc0_0_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_2_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_0_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_0_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_0_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_0_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_0_ff, NULL, 0x5df0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5df8_0_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_0_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5dfa_0_ff, NULL, 0x5dfa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dfb_0_ff, NULL, 0x5dfb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5dfc_0_ff, NULL, 0x5dfc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ec0_0_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_2_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_0_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_0_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_0_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_0_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_0_ff, NULL, 0x5ef0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ef8_0_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_0_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5efa_0_ff, NULL, 0x5efa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5efb_0_ff, NULL, 0x5efb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5efc_0_ff, NULL, 0x5efc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5fc0_0_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_2_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_0_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_0_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_0_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_0_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_0_ff, NULL, 0x5ff0, 2, { 2, 0 }, 0 }, /* Scc */
{ op_5ff8_0_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_0_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ffa_0_ff, NULL, 0x5ffa, 4, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ffb_0_ff, NULL, 0x5ffb, 6, { 0, 0 }, 0 }, /* TRAPcc */
{ op_5ffc_0_ff, NULL, 0x5ffc, 2, { 0, 0 }, 0 }, /* TRAPcc */
{ op_6000_2_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_2_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_2_ff, NULL, 0x60ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6100_2_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_2_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_2_ff, NULL, 0x61ff, 6, { 0, 0 }, 3 }, /* BSR */
{ op_6200_2_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_2_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_2_ff, NULL, 0x62ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6300_2_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_2_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_2_ff, NULL, 0x63ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6400_2_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_2_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_2_ff, NULL, 0x64ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6500_2_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_2_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_2_ff, NULL, 0x65ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6600_2_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_2_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_2_ff, NULL, 0x66ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6700_2_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_2_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_2_ff, NULL, 0x67ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6800_2_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_2_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_2_ff, NULL, 0x68ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6900_2_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_2_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_2_ff, NULL, 0x69ff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6a00_2_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_2_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_2_ff, NULL, 0x6aff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6b00_2_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_2_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_2_ff, NULL, 0x6bff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6c00_2_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_2_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_2_ff, NULL, 0x6cff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6d00_2_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_2_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_2_ff, NULL, 0x6dff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6e00_2_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_2_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_2_ff, NULL, 0x6eff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_6f00_2_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_2_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_2_ff, NULL, 0x6fff, 6, { 0, 0 }, -3 }, /* Bcc */
{ op_7000_0_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_0_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_0_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_0_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_0_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_0_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_0_ff, NULL, 0x8030, 2, { 2, 0 }, 0 }, /* OR */
{ op_8038_0_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_0_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_0_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_0_ff, NULL, 0x803b, 2, { 2, 0 }, 0 }, /* OR */
{ op_803c_0_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_0_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_0_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_0_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_0_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_0_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_0_ff, NULL, 0x8070, 2, { 2, 0 }, 0 }, /* OR */
{ op_8078_0_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_0_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_0_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_0_ff, NULL, 0x807b, 2, { 2, 0 }, 0 }, /* OR */
{ op_807c_0_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_0_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_0_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_0_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_0_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_0_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_0_ff, NULL, 0x80b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_80b8_0_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_0_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_0_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_0_ff, NULL, 0x80bb, 2, { 2, 0 }, 0 }, /* OR */
{ op_80bc_0_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_0_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_0_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_0_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_0_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_0_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_0_ff, NULL, 0x80f0, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80f8_0_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_0_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_0_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_0_ff, NULL, 0x80fb, 2, { 2, 0 }, 0 }, /* DIVU */
{ op_80fc_0_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_2_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_2_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_0_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_0_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_0_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_0_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_0_ff, NULL, 0x8130, 2, { 2, 0 }, 0 }, /* OR */
{ op_8138_0_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_0_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ op_8140_0_ff, NULL, 0x8140, 4, { 0, 0 }, 0 }, /* PACK */
{ op_8148_0_ff, NULL, 0x8148, 4, { 0, 0 }, 0 }, /* PACK */
{ op_8150_0_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_0_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_0_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_0_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_0_ff, NULL, 0x8170, 2, { 2, 0 }, 0 }, /* OR */
{ op_8178_0_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_0_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ op_8180_0_ff, NULL, 0x8180, 4, { 0, 0 }, 0 }, /* UNPK */
{ op_8188_0_ff, NULL, 0x8188, 4, { 0, 0 }, 0 }, /* UNPK */
{ op_8190_0_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_0_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_0_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_0_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_0_ff, NULL, 0x81b0, 2, { 2, 0 }, 0 }, /* OR */
{ op_81b8_0_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_0_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_0_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_0_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_0_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_0_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_0_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_0_ff, NULL, 0x81f0, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81f8_0_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_0_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_0_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_0_ff, NULL, 0x81fb, 2, { 2, 0 }, 0 }, /* DIVS */
{ op_81fc_0_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_0_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_0_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_0_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_0_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_0_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_0_ff, NULL, 0x9030, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9038_0_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_0_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_0_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_0_ff, NULL, 0x903b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_903c_0_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_0_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_0_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_0_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_0_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_0_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_0_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_0_ff, NULL, 0x9070, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9078_0_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_0_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_0_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_0_ff, NULL, 0x907b, 2, { 2, 0 }, 0 }, /* SUB */
{ op_907c_0_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_0_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_0_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_0_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_0_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_0_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_0_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_0_ff, NULL, 0x90b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90b8_0_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_0_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_0_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_0_ff, NULL, 0x90bb, 2, { 2, 0 }, 0 }, /* SUB */
{ op_90bc_0_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_0_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_0_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_0_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_0_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_0_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_0_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_0_ff, NULL, 0x90f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90f8_0_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_0_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_0_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_0_ff, NULL, 0x90fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_90fc_0_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_0_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_0_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_0_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_0_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_0_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_0_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_0_ff, NULL, 0x9130, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9138_0_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_0_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_0_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_0_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_0_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_0_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_0_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_0_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_0_ff, NULL, 0x9170, 2, { 2, 0 }, 0 }, /* SUB */
{ op_9178_0_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_0_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_0_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_0_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_0_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_0_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_0_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_0_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_0_ff, NULL, 0x91b0, 2, { 2, 0 }, 0 }, /* SUB */
{ op_91b8_0_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_0_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_0_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_0_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_0_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_0_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_0_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_0_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_0_ff, NULL, 0x91f0, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91f8_0_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_0_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_0_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_0_ff, NULL, 0x91fb, 2, { 2, 0 }, 0 }, /* SUBA */
{ op_91fc_0_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_0_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_0_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_0_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_0_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_0_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_0_ff, NULL, 0xb030, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b038_0_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_0_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_0_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_0_ff, NULL, 0xb03b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b03c_0_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_0_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_0_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_0_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_0_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_0_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_0_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_0_ff, NULL, 0xb070, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b078_0_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_0_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_0_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_0_ff, NULL, 0xb07b, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b07c_0_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_0_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_0_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_0_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_0_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_0_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_0_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_0_ff, NULL, 0xb0b0, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0b8_0_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_0_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_0_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_0_ff, NULL, 0xb0bb, 2, { 2, 0 }, 0 }, /* CMP */
{ op_b0bc_0_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_0_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_0_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_0_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_0_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_0_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_0_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_0_ff, NULL, 0xb0f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0f8_0_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_0_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_0_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_0_ff, NULL, 0xb0fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b0fc_0_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_0_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_0_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_0_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_0_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_0_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_0_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_0_ff, NULL, 0xb130, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b138_0_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_0_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_0_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_0_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_0_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_0_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_0_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_0_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_0_ff, NULL, 0xb170, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b178_0_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_0_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_0_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_0_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_0_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_0_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_0_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_0_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_0_ff, NULL, 0xb1b0, 2, { 2, 0 }, 0 }, /* EOR */
{ op_b1b8_0_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_0_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_0_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_0_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_0_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_0_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_0_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_0_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_0_ff, NULL, 0xb1f0, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1f8_0_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_0_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_0_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_0_ff, NULL, 0xb1fb, 2, { 2, 0 }, 0 }, /* CMPA */
{ op_b1fc_0_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_0_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_0_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_0_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_0_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_0_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_0_ff, NULL, 0xc030, 2, { 2, 0 }, 0 }, /* AND */
{ op_c038_0_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_0_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_0_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_0_ff, NULL, 0xc03b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c03c_0_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_0_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_0_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_0_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_0_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_0_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_0_ff, NULL, 0xc070, 2, { 2, 0 }, 0 }, /* AND */
{ op_c078_0_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_0_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_0_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_0_ff, NULL, 0xc07b, 2, { 2, 0 }, 0 }, /* AND */
{ op_c07c_0_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_0_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_0_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_0_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_0_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_0_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_0_ff, NULL, 0xc0b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0b8_0_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_0_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_0_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_0_ff, NULL, 0xc0bb, 2, { 2, 0 }, 0 }, /* AND */
{ op_c0bc_0_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_0_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_0_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_0_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_0_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_0_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_0_ff, NULL, 0xc0f0, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0f8_0_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_0_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_0_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_0_ff, NULL, 0xc0fb, 2, { 2, 0 }, 0 }, /* MULU */
{ op_c0fc_0_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_2_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_2_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_0_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_0_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_0_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_0_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_0_ff, NULL, 0xc130, 2, { 2, 0 }, 0 }, /* AND */
{ op_c138_0_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_0_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_0_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_0_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_0_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_0_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_0_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_0_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_0_ff, NULL, 0xc170, 2, { 2, 0 }, 0 }, /* AND */
{ op_c178_0_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_0_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_0_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_0_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_0_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_0_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_0_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_0_ff, NULL, 0xc1b0, 2, { 2, 0 }, 0 }, /* AND */
{ op_c1b8_0_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_0_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_0_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_0_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_0_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_0_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_0_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_0_ff, NULL, 0xc1f0, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1f8_0_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_0_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_0_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_0_ff, NULL, 0xc1fb, 2, { 2, 0 }, 0 }, /* MULS */
{ op_c1fc_0_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_0_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_0_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_0_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_0_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_0_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_0_ff, NULL, 0xd030, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d038_0_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_0_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_0_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_0_ff, NULL, 0xd03b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d03c_0_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_0_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_0_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_0_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_0_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_0_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_0_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_0_ff, NULL, 0xd070, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d078_0_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_0_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_0_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_0_ff, NULL, 0xd07b, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d07c_0_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_0_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_0_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_0_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_0_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_0_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_0_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_0_ff, NULL, 0xd0b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0b8_0_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_0_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_0_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_0_ff, NULL, 0xd0bb, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d0bc_0_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_0_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_0_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_0_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_0_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_0_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_0_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_0_ff, NULL, 0xd0f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0f8_0_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_0_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_0_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_0_ff, NULL, 0xd0fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d0fc_0_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_0_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_0_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_0_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_0_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_0_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_0_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_0_ff, NULL, 0xd130, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d138_0_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_0_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_0_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_0_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_0_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_0_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_0_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_0_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_0_ff, NULL, 0xd170, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d178_0_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_0_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_0_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_0_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_0_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_0_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_0_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_0_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_0_ff, NULL, 0xd1b0, 2, { 2, 0 }, 0 }, /* ADD */
{ op_d1b8_0_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_0_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_0_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_0_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_0_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_0_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_0_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_0_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_0_ff, NULL, 0xd1f0, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1f8_0_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_0_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_0_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_0_ff, NULL, 0xd1fb, 2, { 2, 0 }, 0 }, /* ADDA */
{ op_d1fc_0_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_0_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_0_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_0_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_0_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_0_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_0_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_0_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_0_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_0_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_0_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_0_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_0_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_0_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_0_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_0_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_0_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_0_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_0_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_0_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_0_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_0_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_0_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_0_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_0_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_0_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_0_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_0_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_0_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_0_ff, NULL, 0xe0f0, 2, { 2, 0 }, 0 }, /* ASRW */
{ op_e0f8_0_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_0_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_0_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_0_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_0_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_0_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_0_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_0_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_0_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_0_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_0_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_0_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_0_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_0_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_0_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_0_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_0_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_0_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_0_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_0_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_0_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_0_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_0_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_0_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_0_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_0_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_0_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_0_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_0_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_0_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_0_ff, NULL, 0xe1f0, 2, { 2, 0 }, 0 }, /* ASLW */
{ op_e1f8_0_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_0_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_0_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_0_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_0_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_0_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_0_ff, NULL, 0xe2f0, 2, { 2, 0 }, 0 }, /* LSRW */
{ op_e2f8_0_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_0_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_0_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_0_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_0_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_0_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_0_ff, NULL, 0xe3f0, 2, { 2, 0 }, 0 }, /* LSLW */
{ op_e3f8_0_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_0_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_0_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_0_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_0_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_0_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_0_ff, NULL, 0xe4f0, 2, { 2, 0 }, 0 }, /* ROXRW */
{ op_e4f8_0_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_0_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_0_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_0_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_0_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_0_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_0_ff, NULL, 0xe5f0, 2, { 2, 0 }, 0 }, /* ROXLW */
{ op_e5f8_0_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_0_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_0_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_0_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_0_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_0_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_0_ff, NULL, 0xe6f0, 2, { 2, 0 }, 0 }, /* RORW */
{ op_e6f8_0_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_0_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_0_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_0_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_0_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_0_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_0_ff, NULL, 0xe7f0, 2, { 2, 0 }, 0 }, /* ROLW */
{ op_e7f8_0_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_0_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ op_e8c0_0_ff, NULL, 0xe8c0, 4, { 0, 0 }, 0 }, /* BFTST */
{ op_e8d0_0_ff, NULL, 0xe8d0, 4, { 0, 0 }, 0 }, /* BFTST */
{ op_e8e8_0_ff, NULL, 0xe8e8, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8f0_0_ff, NULL, 0xe8f0, 4, { 2, 0 }, 0 }, /* BFTST */
{ op_e8f8_0_ff, NULL, 0xe8f8, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8f9_0_ff, NULL, 0xe8f9, 8, { 0, 0 }, 0 }, /* BFTST */
{ op_e8fa_0_ff, NULL, 0xe8fa, 6, { 0, 0 }, 0 }, /* BFTST */
{ op_e8fb_0_ff, NULL, 0xe8fb, 4, { 2, 0 }, 0 }, /* BFTST */
{ op_e9c0_0_ff, NULL, 0xe9c0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9d0_0_ff, NULL, 0xe9d0, 4, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9e8_0_ff, NULL, 0xe9e8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9f0_0_ff, NULL, 0xe9f0, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ op_e9f8_0_ff, NULL, 0xe9f8, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9f9_0_ff, NULL, 0xe9f9, 8, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9fa_0_ff, NULL, 0xe9fa, 6, { 0, 0 }, 0 }, /* BFEXTU */
{ op_e9fb_0_ff, NULL, 0xe9fb, 4, { 2, 0 }, 0 }, /* BFEXTU */
{ op_eac0_0_ff, NULL, 0xeac0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ op_ead0_0_ff, NULL, 0xead0, 4, { 0, 0 }, 0 }, /* BFCHG */
{ op_eae8_0_ff, NULL, 0xeae8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ op_eaf0_0_ff, NULL, 0xeaf0, 4, { 2, 0 }, 0 }, /* BFCHG */
{ op_eaf8_0_ff, NULL, 0xeaf8, 6, { 0, 0 }, 0 }, /* BFCHG */
{ op_eaf9_0_ff, NULL, 0xeaf9, 8, { 0, 0 }, 0 }, /* BFCHG */
{ op_ebc0_0_ff, NULL, 0xebc0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebd0_0_ff, NULL, 0xebd0, 4, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebe8_0_ff, NULL, 0xebe8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebf0_0_ff, NULL, 0xebf0, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ op_ebf8_0_ff, NULL, 0xebf8, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebf9_0_ff, NULL, 0xebf9, 8, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebfa_0_ff, NULL, 0xebfa, 6, { 0, 0 }, 0 }, /* BFEXTS */
{ op_ebfb_0_ff, NULL, 0xebfb, 4, { 2, 0 }, 0 }, /* BFEXTS */
{ op_ecc0_0_ff, NULL, 0xecc0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecd0_0_ff, NULL, 0xecd0, 4, { 0, 0 }, 0 }, /* BFCLR */
{ op_ece8_0_ff, NULL, 0xece8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecf0_0_ff, NULL, 0xecf0, 4, { 2, 0 }, 0 }, /* BFCLR */
{ op_ecf8_0_ff, NULL, 0xecf8, 6, { 0, 0 }, 0 }, /* BFCLR */
{ op_ecf9_0_ff, NULL, 0xecf9, 8, { 0, 0 }, 0 }, /* BFCLR */
{ op_edc0_0_ff, NULL, 0xedc0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ op_edd0_0_ff, NULL, 0xedd0, 4, { 0, 0 }, 0 }, /* BFFFO */
{ op_ede8_0_ff, NULL, 0xede8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edf0_0_ff, NULL, 0xedf0, 4, { 2, 0 }, 0 }, /* BFFFO */
{ op_edf8_0_ff, NULL, 0xedf8, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edf9_0_ff, NULL, 0xedf9, 8, { 0, 0 }, 0 }, /* BFFFO */
{ op_edfa_0_ff, NULL, 0xedfa, 6, { 0, 0 }, 0 }, /* BFFFO */
{ op_edfb_0_ff, NULL, 0xedfb, 4, { 2, 0 }, 0 }, /* BFFFO */
{ op_eec0_0_ff, NULL, 0xeec0, 4, { 0, 0 }, 0 }, /* BFSET */
{ op_eed0_0_ff, NULL, 0xeed0, 4, { 0, 0 }, 0 }, /* BFSET */
{ op_eee8_0_ff, NULL, 0xeee8, 6, { 0, 0 }, 0 }, /* BFSET */
{ op_eef0_0_ff, NULL, 0xeef0, 4, { 2, 0 }, 0 }, /* BFSET */
{ op_eef8_0_ff, NULL, 0xeef8, 6, { 0, 0 }, 0 }, /* BFSET */
{ op_eef9_0_ff, NULL, 0xeef9, 8, { 0, 0 }, 0 }, /* BFSET */
{ op_efc0_0_ff, NULL, 0xefc0, 4, { 0, 0 }, 0 }, /* BFINS */
{ op_efd0_0_ff, NULL, 0xefd0, 4, { 0, 0 }, 0 }, /* BFINS */
{ op_efe8_0_ff, NULL, 0xefe8, 6, { 0, 0 }, 0 }, /* BFINS */
{ op_eff0_0_ff, NULL, 0xeff0, 4, { 2, 0 }, 0 }, /* BFINS */
{ op_eff8_0_ff, NULL, 0xeff8, 6, { 0, 0 }, 0 }, /* BFINS */
{ op_eff9_0_ff, NULL, 0xeff9, 8, { 0, 0 }, 0 }, /* BFINS */
{ op_f200_0_ff, NULL, 0xf200, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f208_0_ff, NULL, 0xf208, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f210_0_ff, NULL, 0xf210, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f218_0_ff, NULL, 0xf218, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f220_0_ff, NULL, 0xf220, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f228_0_ff, NULL, 0xf228, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f230_0_ff, NULL, 0xf230, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f238_0_ff, NULL, 0xf238, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f239_0_ff, NULL, 0xf239, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23a_0_ff, NULL, 0xf23a, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23b_0_ff, NULL, 0xf23b, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f23c_0_ff, NULL, 0xf23c, -1, { 0, 0 }, 0 }, /* FPP */
{ op_f240_0_ff, NULL, 0xf240, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f248_0_ff, NULL, 0xf248, -1, { 0, 0 }, 0 }, /* FDBcc */
{ op_f250_0_ff, NULL, 0xf250, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f258_0_ff, NULL, 0xf258, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f260_0_ff, NULL, 0xf260, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f268_0_ff, NULL, 0xf268, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f270_0_ff, NULL, 0xf270, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f278_0_ff, NULL, 0xf278, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f279_0_ff, NULL, 0xf279, -1, { 0, 0 }, 0 }, /* FScc */
{ op_f27a_0_ff, NULL, 0xf27a, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f27b_0_ff, NULL, 0xf27b, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f27c_0_ff, NULL, 0xf27c, -1, { 0, 0 }, 0 }, /* FTRAPcc */
{ op_f280_0_ff, NULL, 0xf280, -1, { 0, 0 }, 0 }, /* FBcc */
{ op_f2c0_0_ff, NULL, 0xf2c0, -1, { 0, 0 }, 0 }, /* FBcc */
{ op_f310_0_ff, NULL, 0xf310, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f320_0_ff, NULL, 0xf320, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f328_0_ff, NULL, 0xf328, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f330_0_ff, NULL, 0xf330, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f338_0_ff, NULL, 0xf338, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f339_0_ff, NULL, 0xf339, -1, { 0, 0 }, 0 }, /* FSAVE */
{ op_f350_0_ff, NULL, 0xf350, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f358_0_ff, NULL, 0xf358, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f368_0_ff, NULL, 0xf368, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f370_0_ff, NULL, 0xf370, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f378_0_ff, NULL, 0xf378, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f379_0_ff, NULL, 0xf379, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f37a_0_ff, NULL, 0xf37a, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ op_f37b_0_ff, NULL, 0xf37b, -1, { 0, 0 }, 0 }, /* FRESTORE */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_68000_ONLY */
#ifndef CPUEMU_68000_ONLY
const struct cputbl op_smalltbl_4[] = {
{ op_0000_0_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_0_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_0_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_0_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_0_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_4_ff, NULL, 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ op_0038_0_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_0_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_4_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_0_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_0_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_0_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_0_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_0_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_4_ff, NULL, 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ op_0078_0_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_0_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_4_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_0_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_0_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_0_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_0_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_0_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_4_ff, NULL, 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ op_00b8_0_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_0_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ op_0100_0_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_0_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_0_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_0_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_0_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_0_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_4_ff, NULL, 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ op_0138_0_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_0_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_0_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_4_ff, NULL, 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ op_013c_0_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_4_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_0_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_0_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_0_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_0_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_0_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_4_ff, NULL, 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ op_0178_0_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_0_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_4_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_0_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_0_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_0_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_0_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_0_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_4_ff, NULL, 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ op_01b8_0_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_0_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_4_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_0_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_0_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_0_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_0_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_0_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_4_ff, NULL, 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ op_01f8_0_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_0_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_0_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_0_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_0_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_0_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_0_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_4_ff, NULL, 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ op_0238_0_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_0_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_4_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_0_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_0_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_0_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_0_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_0_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_4_ff, NULL, 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ op_0278_0_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_0_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_4_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_0_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_0_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_0_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_0_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_0_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_4_ff, NULL, 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ op_02b8_0_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_0_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ op_0400_0_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_0_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_0_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_0_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_0_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_4_ff, NULL, 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0438_0_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_0_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_0_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_0_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_0_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_0_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_0_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_4_ff, NULL, 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0478_0_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_0_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_0_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_0_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_0_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_0_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_0_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_4_ff, NULL, 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ op_04b8_0_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_0_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ op_0600_0_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_0_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_0_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_0_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_0_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_4_ff, NULL, 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0638_0_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_0_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_0_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_0_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_0_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_0_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_0_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_4_ff, NULL, 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0678_0_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_0_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_0_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_0_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_0_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_0_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_0_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_4_ff, NULL, 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ op_06b8_0_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_0_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ op_0800_0_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_0_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_0_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_0_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_0_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_4_ff, NULL, 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0838_0_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_0_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_0_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_4_ff, NULL, 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0840_4_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_0_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_0_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_0_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_0_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_4_ff, NULL, 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ op_0878_0_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_0_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_4_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_0_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_0_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_0_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_0_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_4_ff, NULL, 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ op_08b8_0_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_0_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_4_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_0_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_0_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_0_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_0_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_4_ff, NULL, 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ op_08f8_0_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_0_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_0_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_0_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_0_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_0_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_0_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_4_ff, NULL, 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a38_0_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_0_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_4_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_0_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_0_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_0_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_0_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_0_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_4_ff, NULL, 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a78_0_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_0_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_4_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_0_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_0_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_0_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_0_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_0_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_4_ff, NULL, 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ op_0ab8_0_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_0_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ op_0c00_0_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_0_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_0_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_0_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_0_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_4_ff, NULL, 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c38_0_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_0_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c40_0_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_0_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_0_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_0_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_0_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_4_ff, NULL, 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c78_0_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_0_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c80_0_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_0_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_0_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_0_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_0_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_4_ff, NULL, 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ op_0cb8_0_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_0_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ op_0e10_2_ff, NULL, 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e18_2_ff, NULL, 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e20_2_ff, NULL, 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e28_2_ff, NULL, 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
#ifndef CPUEMU_68000_ONLY
{ op_0e30_4_ff, NULL, 0x0e30, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
{ op_0e38_2_ff, NULL, 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0e39_2_ff, NULL, 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
{ op_0e50_2_ff, NULL, 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e58_2_ff, NULL, 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e60_2_ff, NULL, 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e68_2_ff, NULL, 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
#ifndef CPUEMU_68000_ONLY
{ op_0e70_4_ff, NULL, 0x0e70, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
{ op_0e78_2_ff, NULL, 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0e79_2_ff, NULL, 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
{ op_0e90_2_ff, NULL, 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0e98_2_ff, NULL, 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0ea0_2_ff, NULL, 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
{ op_0ea8_2_ff, NULL, 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
#ifndef CPUEMU_68000_ONLY
{ op_0eb0_4_ff, NULL, 0x0eb0, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
{ op_0eb8_2_ff, NULL, 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
{ op_0eb9_2_ff, NULL, 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
{ op_1000_0_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_0_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_0_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_0_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_0_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_4_ff, NULL, 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1038_0_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_0_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_0_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_4_ff, NULL, 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_103c_0_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_0_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_0_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_0_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_0_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_0_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_4_ff, NULL, 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10b8_0_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_0_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_0_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_4_ff, NULL, 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10bc_0_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_0_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_0_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_0_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_0_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_0_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_4_ff, NULL, 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10f8_0_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_0_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_0_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_4_ff, NULL, 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10fc_0_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_0_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_0_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_0_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_0_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_0_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_4_ff, NULL, 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1138_0_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_0_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_0_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_4_ff, NULL, 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_113c_0_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_0_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_0_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_0_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_0_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_0_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_4_ff, NULL, 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_1178_0_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_0_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_0_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_4_ff, NULL, 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_117c_0_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_4_ff, NULL, 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1190_4_ff, NULL, 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1198_4_ff, NULL, 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a0_4_ff, NULL, 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a8_4_ff, NULL, 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b0_4_ff, NULL, 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11b8_4_ff, NULL, 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b9_4_ff, NULL, 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_11ba_4_ff, NULL, 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11bb_4_ff, NULL, 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11bc_4_ff, NULL, 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11c0_0_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_0_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_0_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_0_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_0_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_4_ff, NULL, 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11f8_0_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_0_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_0_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_4_ff, NULL, 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11fc_0_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_0_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_0_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_0_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_0_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_0_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_4_ff, NULL, 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13f8_0_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_0_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_0_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_4_ff, NULL, 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13fc_0_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_0_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_0_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_0_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_0_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_0_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_0_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_4_ff, NULL, 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2038_0_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_0_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_0_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_4_ff, NULL, 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_203c_0_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_0_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_0_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_0_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_0_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_0_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_0_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_4_ff, NULL, 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_2078_0_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_0_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_0_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_4_ff, NULL, 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_207c_0_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_0_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_0_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_0_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_0_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_0_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_0_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_4_ff, NULL, 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20b8_0_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_0_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_0_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_4_ff, NULL, 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20bc_0_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_0_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_0_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_0_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_0_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_0_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_0_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_4_ff, NULL, 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20f8_0_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_0_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_0_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_4_ff, NULL, 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20fc_0_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_0_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_0_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_0_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_0_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_0_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_0_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_4_ff, NULL, 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2138_0_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_0_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_0_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_4_ff, NULL, 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_213c_0_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_0_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_0_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_0_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_0_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_0_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_0_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_4_ff, NULL, 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_2178_0_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_0_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_0_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_4_ff, NULL, 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_217c_0_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_4_ff, NULL, 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2188_4_ff, NULL, 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2190_4_ff, NULL, 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2198_4_ff, NULL, 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a0_4_ff, NULL, 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a8_4_ff, NULL, 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b0_4_ff, NULL, 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21b8_4_ff, NULL, 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b9_4_ff, NULL, 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21ba_4_ff, NULL, 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21bb_4_ff, NULL, 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21bc_4_ff, NULL, 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21c0_0_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_0_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_0_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_0_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_0_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_0_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_4_ff, NULL, 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21f8_0_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_0_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_0_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_4_ff, NULL, 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21fc_0_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_0_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_0_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_0_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_0_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_0_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_0_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_4_ff, NULL, 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23f8_0_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_0_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_0_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_4_ff, NULL, 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23fc_0_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_0_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_0_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_0_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_0_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_0_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_0_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_4_ff, NULL, 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3038_0_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_0_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_0_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_4_ff, NULL, 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_303c_0_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_0_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_0_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_0_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_0_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_0_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_0_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_4_ff, NULL, 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_3078_0_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_0_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_0_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_4_ff, NULL, 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_307c_0_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_0_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_0_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_0_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_0_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_0_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_0_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_4_ff, NULL, 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30b8_0_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_0_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_0_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_4_ff, NULL, 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30bc_0_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_0_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_0_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_0_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_0_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_0_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_0_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_4_ff, NULL, 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30f8_0_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_0_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_0_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_4_ff, NULL, 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30fc_0_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_0_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_0_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_0_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_0_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_0_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_0_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_4_ff, NULL, 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3138_0_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_0_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_0_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_4_ff, NULL, 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_313c_0_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_0_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_0_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_0_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_0_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_0_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_0_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_4_ff, NULL, 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_3178_0_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_0_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_0_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_4_ff, NULL, 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_317c_0_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_4_ff, NULL, 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3188_4_ff, NULL, 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3190_4_ff, NULL, 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3198_4_ff, NULL, 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a0_4_ff, NULL, 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a8_4_ff, NULL, 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b0_4_ff, NULL, 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31b8_4_ff, NULL, 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b9_4_ff, NULL, 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_31ba_4_ff, NULL, 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31bb_4_ff, NULL, 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31bc_4_ff, NULL, 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31c0_0_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_0_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_0_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_0_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_0_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_0_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_4_ff, NULL, 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31f8_0_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_0_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_0_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_4_ff, NULL, 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31fc_0_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_0_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_0_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_0_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_0_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_0_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_0_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_4_ff, NULL, 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33f8_0_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_0_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_0_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_4_ff, NULL, 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33fc_0_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_0_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_0_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_0_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_0_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_0_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_4_ff, NULL, 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4038_0_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_0_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_0_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_0_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_0_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_0_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_0_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_4_ff, NULL, 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4078_0_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_0_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_0_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_0_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_0_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_0_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_0_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_4_ff, NULL, 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_40b8_0_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_0_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_0_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_0_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_0_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_0_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_0_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_4_ff, NULL, 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ op_40f8_0_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_0_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4180_0_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_0_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_0_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_0_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_0_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_4_ff, NULL, 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41b8_0_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_0_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_0_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_4_ff, NULL, 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41bc_0_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_0_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_0_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_4_ff, NULL, 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ op_41f8_0_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_0_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_0_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_4_ff, NULL, 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ op_4200_0_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_0_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_0_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_0_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_0_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_4_ff, NULL, 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4238_0_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_0_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_0_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_0_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_0_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_0_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_0_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_4_ff, NULL, 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4278_0_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_0_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_0_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_0_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_0_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_0_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_0_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_4_ff, NULL, 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ op_42b8_0_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_0_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ op_42c0_0_ff, NULL, 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d0_0_ff, NULL, 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42d8_0_ff, NULL, 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e0_0_ff, NULL, 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42e8_0_ff, NULL, 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#ifndef CPUEMU_68000_ONLY
{ op_42f0_4_ff, NULL, 0x42f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
#endif
{ op_42f8_0_ff, NULL, 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_42f9_0_ff, NULL, 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4400_0_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_0_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_0_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_0_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_0_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_4_ff, NULL, 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4438_0_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_0_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_0_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_0_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_0_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_0_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_0_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_4_ff, NULL, 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4478_0_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_0_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_0_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_0_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_0_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_0_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_0_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_4_ff, NULL, 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ op_44b8_0_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_0_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_0_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_0_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_0_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_0_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_0_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_4_ff, NULL, 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44f8_0_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_0_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_0_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_4_ff, NULL, 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44fc_0_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_0_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_0_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_0_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_0_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_0_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_4_ff, NULL, 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4638_0_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_0_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_0_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_0_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_0_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_0_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_0_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_4_ff, NULL, 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4678_0_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_0_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_0_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_0_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_0_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_0_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_0_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_4_ff, NULL, 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ op_46b8_0_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_0_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_0_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_0_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_0_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_0_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_0_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_4_ff, NULL, 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46f8_0_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_0_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_0_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_4_ff, NULL, 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46fc_0_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_4_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4810_4_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_4_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_4_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_4_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_4_ff, NULL, 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ op_4838_4_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_4_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_0_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ op_4848_0_ff, NULL, 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
{ op_4850_0_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_0_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_4_ff, NULL, 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4878_0_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_0_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_0_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_4_ff, NULL, 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4880_0_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_4_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_4_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_4_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_4_ff, NULL, 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48b8_4_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_4_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_0_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_4_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_4_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_4_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_4_ff, NULL, 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48f8_4_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_4_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_4a00_0_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_0_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_0_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_0_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_0_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_4_ff, NULL, 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a38_0_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_0_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a40_0_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a50_0_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_0_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_0_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_0_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_4_ff, NULL, 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a78_0_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_0_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a80_0_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a90_0_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_0_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_0_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_0_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_4_ff, NULL, 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ op_4ab8_0_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_0_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ op_4ac0_4_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad0_4_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_4_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_4_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_4_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_4_ff, NULL, 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ op_4af8_4_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_4_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ op_4c90_4_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_4_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_4_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_4_ff, NULL, 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cb8_4_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_4_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_4_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_4_ff, NULL, 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cd0_4_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_4_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_4_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_4_ff, NULL, 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cf8_4_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_4_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_4_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_4_ff, NULL, 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4e40_0_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_4_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_0_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_2_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_0_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_0_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_2_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_4_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_4_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ op_4e74_2_ff, NULL, 0x4e74, 4, { 0, 0 }, 2 }, /* RTD */
{ op_4e75_4_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_0_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_4_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ op_4e7a_0_ff, NULL, 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
{ op_4e7b_2_ff, NULL, 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
{ op_4e90_2_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_2_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_4_ff, NULL, 0x4eb0, 4, { 4, 0 }, 2 }, /* JSR */
{ op_4eb8_2_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_2_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_2_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_4_ff, NULL, 0x4ebb, 4, { 4, 0 }, 2 }, /* JSR */
{ op_4ed0_0_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_0_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_4_ff, NULL, 0x4ef0, 4, { 4, 0 }, 2 }, /* JMP */
{ op_4ef8_0_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_0_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_0_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_4_ff, NULL, 0x4efb, 4, { 4, 0 }, 2 }, /* JMP */
{ op_5000_0_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_0_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_0_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_0_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_0_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_4_ff, NULL, 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5038_0_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_0_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_0_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_0_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_0_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_0_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_0_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_0_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_4_ff, NULL, 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5078_0_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_0_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_0_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_0_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_0_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_0_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_0_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_0_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_4_ff, NULL, 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_50b8_0_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_0_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_0_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_4_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_0_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_0_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_0_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_0_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_4_ff, NULL, 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_50f8_0_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_0_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5100_0_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_0_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_0_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_0_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_0_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_4_ff, NULL, 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5138_0_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_0_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_0_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_0_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_0_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_0_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_0_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_0_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_4_ff, NULL, 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5178_0_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_0_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_0_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_0_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_0_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_0_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_0_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_0_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_4_ff, NULL, 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_51b8_0_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_0_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_0_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_4_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_0_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_0_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_0_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_0_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_4_ff, NULL, 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_51f8_0_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_0_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_52c0_0_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_4_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_0_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_0_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_0_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_0_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_4_ff, NULL, 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_52f8_0_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_0_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_53c0_0_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_4_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_0_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_0_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_0_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_0_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_4_ff, NULL, 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_53f8_0_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_0_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_54c0_0_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_4_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_0_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_0_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_0_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_0_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_4_ff, NULL, 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_54f8_0_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_0_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_55c0_0_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_4_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_0_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_0_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_0_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_0_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_4_ff, NULL, 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_55f8_0_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_0_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_56c0_0_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_4_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_0_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_0_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_0_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_0_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_4_ff, NULL, 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_56f8_0_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_0_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_57c0_0_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_4_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_0_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_0_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_0_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_0_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_4_ff, NULL, 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_57f8_0_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_0_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_58c0_0_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_4_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_0_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_0_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_0_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_0_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_4_ff, NULL, 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_58f8_0_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_0_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_59c0_0_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_4_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_0_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_0_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_0_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_0_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_4_ff, NULL, 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_59f8_0_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_0_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ac0_0_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_4_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_0_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_0_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_0_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_0_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_4_ff, NULL, 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5af8_0_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_0_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5bc0_0_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_4_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_0_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_0_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_0_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_0_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_4_ff, NULL, 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5bf8_0_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_0_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5cc0_0_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_4_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_0_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_0_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_0_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_0_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_4_ff, NULL, 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5cf8_0_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_0_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5dc0_0_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_4_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_0_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_0_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_0_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_0_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_4_ff, NULL, 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5df8_0_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_0_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ec0_0_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_4_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_0_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_0_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_0_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_0_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_4_ff, NULL, 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ef8_0_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_0_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5fc0_0_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_4_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_0_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_0_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_0_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_0_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_4_ff, NULL, 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ff8_0_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_0_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_6000_4_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_4_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_4_ff, NULL, 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6100_4_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_4_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_4_ff, NULL, 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ op_6200_4_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_4_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_4_ff, NULL, 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6300_4_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_4_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_4_ff, NULL, 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6400_4_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_4_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_4_ff, NULL, 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6500_4_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_4_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_4_ff, NULL, 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6600_4_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_4_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_4_ff, NULL, 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6700_4_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_4_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_4_ff, NULL, 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6800_4_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_4_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_4_ff, NULL, 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6900_4_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_4_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_4_ff, NULL, 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6a00_4_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_4_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_4_ff, NULL, 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6b00_4_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_4_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_4_ff, NULL, 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6c00_4_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_4_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_4_ff, NULL, 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6d00_4_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_4_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_4_ff, NULL, 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6e00_4_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_4_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_4_ff, NULL, 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6f00_4_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_4_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_4_ff, NULL, 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_7000_0_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_0_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_0_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_0_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_0_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_0_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_4_ff, NULL, 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ op_8038_0_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_0_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_0_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_4_ff, NULL, 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ op_803c_0_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_0_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_0_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_0_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_0_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_0_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_4_ff, NULL, 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ op_8078_0_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_0_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_0_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_4_ff, NULL, 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ op_807c_0_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_0_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_0_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_0_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_0_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_0_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_4_ff, NULL, 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_80b8_0_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_0_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_0_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_4_ff, NULL, 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ op_80bc_0_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_4_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_4_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_4_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_4_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_4_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_4_ff, NULL, 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80f8_4_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_4_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_4_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_4_ff, NULL, 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80fc_4_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_4_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_4_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_0_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_0_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_0_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_0_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_4_ff, NULL, 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ op_8138_0_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_0_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ op_8150_0_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_0_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_0_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_0_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_4_ff, NULL, 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ op_8178_0_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_0_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ op_8190_0_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_0_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_0_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_0_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_4_ff, NULL, 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_81b8_0_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_0_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_4_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_4_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_4_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_4_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_4_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_4_ff, NULL, 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81f8_4_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_4_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_4_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_4_ff, NULL, 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81fc_4_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_0_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_0_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_0_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_0_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_0_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_4_ff, NULL, 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9038_0_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_0_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_0_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_4_ff, NULL, 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_903c_0_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_0_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_0_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_0_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_0_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_0_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_0_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_4_ff, NULL, 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9078_0_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_0_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_0_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_4_ff, NULL, 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_907c_0_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_0_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_0_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_0_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_0_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_0_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_0_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_4_ff, NULL, 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90b8_0_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_0_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_0_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_4_ff, NULL, 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90bc_0_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_0_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_0_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_0_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_0_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_0_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_0_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_4_ff, NULL, 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90f8_0_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_0_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_0_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_4_ff, NULL, 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90fc_0_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_0_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_0_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_0_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_0_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_0_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_0_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_4_ff, NULL, 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9138_0_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_0_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_0_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_0_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_0_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_0_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_0_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_0_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_4_ff, NULL, 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9178_0_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_0_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_0_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_0_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_0_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_0_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_0_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_0_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_4_ff, NULL, 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_91b8_0_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_0_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_0_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_0_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_0_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_0_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_0_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_0_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_4_ff, NULL, 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91f8_0_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_0_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_0_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_4_ff, NULL, 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91fc_0_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_0_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_0_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_0_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_0_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_0_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_4_ff, NULL, 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b038_0_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_0_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_0_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_4_ff, NULL, 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b03c_0_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_0_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_0_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_0_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_0_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_0_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_0_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_4_ff, NULL, 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b078_0_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_0_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_0_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_4_ff, NULL, 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b07c_0_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_0_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_0_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_0_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_0_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_0_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_0_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_4_ff, NULL, 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0b8_0_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_0_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_0_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_4_ff, NULL, 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0bc_0_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_0_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_0_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_0_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_0_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_0_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_0_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_4_ff, NULL, 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0f8_0_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_0_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_0_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_4_ff, NULL, 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0fc_0_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_0_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_0_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_0_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_0_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_0_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_0_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_4_ff, NULL, 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b138_0_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_0_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_0_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_0_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_0_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_0_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_0_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_0_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_4_ff, NULL, 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b178_0_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_0_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_0_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_0_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_0_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_0_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_0_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_0_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_4_ff, NULL, 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b1b8_0_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_0_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_0_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_0_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_0_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_0_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_0_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_0_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_4_ff, NULL, 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1f8_0_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_0_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_0_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_4_ff, NULL, 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1fc_0_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_0_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_0_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_0_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_0_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_0_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_4_ff, NULL, 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ op_c038_0_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_0_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_0_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_4_ff, NULL, 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c03c_0_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_0_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_0_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_0_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_0_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_0_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_4_ff, NULL, 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ op_c078_0_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_0_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_0_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_4_ff, NULL, 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c07c_0_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_0_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_0_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_0_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_0_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_0_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_4_ff, NULL, 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0b8_0_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_0_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_0_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_4_ff, NULL, 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0bc_0_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_4_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_4_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_4_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_4_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_4_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_4_ff, NULL, 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0f8_4_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_4_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_4_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_4_ff, NULL, 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0fc_4_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_4_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_4_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_0_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_0_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_0_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_0_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_4_ff, NULL, 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ op_c138_0_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_0_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_0_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_0_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_0_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_0_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_0_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_0_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_4_ff, NULL, 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ op_c178_0_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_0_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_0_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_0_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_0_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_0_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_0_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_4_ff, NULL, 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c1b8_0_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_0_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_4_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_4_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_4_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_4_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_4_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_4_ff, NULL, 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1f8_4_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_4_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_4_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_4_ff, NULL, 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1fc_4_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_0_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_0_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_0_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_0_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_0_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_4_ff, NULL, 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d038_0_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_0_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_0_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_4_ff, NULL, 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d03c_0_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_0_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_0_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_0_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_0_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_0_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_0_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_4_ff, NULL, 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d078_0_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_0_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_0_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_4_ff, NULL, 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d07c_0_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_0_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_0_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_0_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_0_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_0_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_0_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_4_ff, NULL, 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0b8_0_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_0_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_0_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_4_ff, NULL, 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0bc_0_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_0_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_0_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_0_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_0_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_0_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_0_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_4_ff, NULL, 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0f8_0_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_0_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_0_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_4_ff, NULL, 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0fc_0_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_0_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_0_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_0_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_0_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_0_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_0_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_4_ff, NULL, 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d138_0_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_0_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_0_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_0_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_0_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_0_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_0_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_0_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_4_ff, NULL, 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d178_0_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_0_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_0_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_0_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_0_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_0_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_0_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_0_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_4_ff, NULL, 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d1b8_0_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_0_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_0_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_0_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_0_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_0_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_0_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_0_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_4_ff, NULL, 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1f8_0_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_0_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_0_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_4_ff, NULL, 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1fc_0_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_4_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_4_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_4_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_4_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_4_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_4_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_4_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_4_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_4_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_4_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_4_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_4_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_4_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_4_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_4_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_4_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_4_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_4_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_4_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_4_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_4_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_4_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_4_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_4_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_0_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_0_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_0_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_0_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_4_ff, NULL, 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ op_e0f8_0_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_0_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_4_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_4_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_4_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_4_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_4_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_4_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_4_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_4_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_4_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_4_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_4_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_4_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_4_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_4_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_4_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_4_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_4_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_4_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_4_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_4_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_4_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_4_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_4_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_4_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_0_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_0_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_0_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_0_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_4_ff, NULL, 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ op_e1f8_0_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_0_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_0_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_0_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_0_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_0_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_4_ff, NULL, 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ op_e2f8_0_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_0_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_0_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_0_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_0_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_0_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_4_ff, NULL, 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ op_e3f8_0_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_0_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_0_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_0_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_0_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_0_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_4_ff, NULL, 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ op_e4f8_0_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_0_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_0_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_0_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_0_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_0_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_4_ff, NULL, 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ op_e5f8_0_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_0_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_0_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_0_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_0_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_0_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_4_ff, NULL, 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ op_e6f8_0_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_0_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_0_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_0_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_0_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_0_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_4_ff, NULL, 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ op_e7f8_0_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_0_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_68000_ONLY */
#ifndef CPUEMU_68000_ONLY
const struct cputbl op_smalltbl_5[] = {
{ op_0000_0_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_0_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_0_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_0_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_0_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_4_ff, NULL, 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ op_0038_0_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_0_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_5_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_0_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_0_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_0_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_0_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_0_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_4_ff, NULL, 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ op_0078_0_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_0_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_5_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_5_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_0_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_0_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_0_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_0_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_4_ff, NULL, 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ op_00b8_0_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_0_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ op_0100_0_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_5_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_0_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_0_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_0_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_0_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_4_ff, NULL, 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ op_0138_0_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_0_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_0_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_4_ff, NULL, 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ op_013c_0_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_4_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_5_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_0_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_0_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_0_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_0_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_4_ff, NULL, 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ op_0178_0_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_0_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_4_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_5_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_5_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_5_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_5_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_5_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_5_ff, NULL, 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ op_01b8_5_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_5_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_4_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_5_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_0_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_0_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_0_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_0_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_4_ff, NULL, 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ op_01f8_0_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_0_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_0_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_0_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_0_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_0_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_0_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_4_ff, NULL, 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ op_0238_0_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_0_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_5_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_0_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_0_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_0_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_0_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_0_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_4_ff, NULL, 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ op_0278_0_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_0_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_5_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_5_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_0_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_0_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_0_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_0_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_4_ff, NULL, 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ op_02b8_0_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_0_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ op_0400_0_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_0_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_0_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_0_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_0_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_4_ff, NULL, 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0438_0_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_0_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_0_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_0_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_0_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_0_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_0_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_4_ff, NULL, 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0478_0_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_0_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_5_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_0_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_0_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_0_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_0_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_4_ff, NULL, 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ op_04b8_0_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_0_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ op_0600_0_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_0_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_0_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_0_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_0_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_4_ff, NULL, 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0638_0_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_0_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_0_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_0_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_0_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_0_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_0_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_4_ff, NULL, 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0678_0_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_0_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_5_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_0_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_0_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_0_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_0_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_4_ff, NULL, 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ op_06b8_0_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_0_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ op_0800_0_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_0_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_0_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_0_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_0_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_4_ff, NULL, 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0838_0_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_0_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_0_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_4_ff, NULL, 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0840_4_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_0_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_0_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_0_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_0_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_4_ff, NULL, 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ op_0878_0_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_0_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_4_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_5_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_5_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_5_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_5_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_5_ff, NULL, 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ op_08b8_5_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_5_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_4_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_0_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_0_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_0_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_0_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_4_ff, NULL, 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ op_08f8_0_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_0_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_0_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_0_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_0_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_0_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_0_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_4_ff, NULL, 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a38_0_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_0_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_5_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_0_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_0_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_0_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_0_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_0_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_4_ff, NULL, 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a78_0_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_0_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_5_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_5_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_0_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_0_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_0_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_0_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_4_ff, NULL, 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ op_0ab8_0_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_0_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ op_0c00_0_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_0_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_0_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_0_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_0_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_4_ff, NULL, 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c38_0_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_0_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c40_0_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_0_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_0_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_0_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_0_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_4_ff, NULL, 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c78_0_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_0_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c80_0_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_0_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_0_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_0_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_0_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_4_ff, NULL, 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ op_0cb8_0_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_0_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ op_1000_0_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_0_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_0_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_0_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_0_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_4_ff, NULL, 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1038_0_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_0_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_0_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_4_ff, NULL, 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_103c_0_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_0_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_0_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_0_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_0_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_0_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_4_ff, NULL, 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10b8_0_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_0_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_0_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_4_ff, NULL, 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10bc_0_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_0_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_0_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_0_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_0_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_0_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_4_ff, NULL, 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10f8_0_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_0_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_0_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_4_ff, NULL, 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10fc_0_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_0_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_0_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_0_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_0_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_0_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_4_ff, NULL, 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1138_0_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_0_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_0_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_4_ff, NULL, 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_113c_0_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_0_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_0_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_0_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_0_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_0_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_4_ff, NULL, 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_1178_0_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_0_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_0_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_4_ff, NULL, 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_117c_0_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_4_ff, NULL, 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1190_4_ff, NULL, 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1198_4_ff, NULL, 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a0_4_ff, NULL, 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a8_4_ff, NULL, 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b0_4_ff, NULL, 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11b8_4_ff, NULL, 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b9_4_ff, NULL, 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_11ba_4_ff, NULL, 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11bb_4_ff, NULL, 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11bc_4_ff, NULL, 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11c0_0_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_0_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_0_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_0_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_0_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_4_ff, NULL, 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11f8_0_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_0_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_0_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_4_ff, NULL, 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11fc_0_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_0_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_0_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_0_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_0_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_0_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_4_ff, NULL, 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13f8_0_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_0_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_0_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_4_ff, NULL, 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13fc_0_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_0_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_0_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_0_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_0_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_0_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_0_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_4_ff, NULL, 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2038_0_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_0_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_0_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_4_ff, NULL, 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_203c_0_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_0_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_0_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_0_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_0_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_0_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_0_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_4_ff, NULL, 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_2078_0_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_0_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_0_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_4_ff, NULL, 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_207c_0_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_0_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_0_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_0_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_0_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_0_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_0_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_4_ff, NULL, 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20b8_0_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_0_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_0_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_4_ff, NULL, 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20bc_0_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_0_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_0_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_0_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_0_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_0_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_0_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_4_ff, NULL, 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20f8_0_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_0_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_0_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_4_ff, NULL, 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20fc_0_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_0_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_0_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_0_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_0_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_0_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_0_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_4_ff, NULL, 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2138_0_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_0_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_0_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_4_ff, NULL, 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_213c_0_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_0_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_0_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_0_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_0_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_0_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_0_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_4_ff, NULL, 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_2178_0_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_0_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_0_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_4_ff, NULL, 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_217c_0_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_4_ff, NULL, 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2188_4_ff, NULL, 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2190_4_ff, NULL, 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2198_4_ff, NULL, 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a0_4_ff, NULL, 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a8_4_ff, NULL, 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b0_4_ff, NULL, 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21b8_4_ff, NULL, 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b9_4_ff, NULL, 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21ba_4_ff, NULL, 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21bb_4_ff, NULL, 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21bc_4_ff, NULL, 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21c0_0_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_0_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_0_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_0_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_0_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_0_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_4_ff, NULL, 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21f8_0_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_0_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_0_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_4_ff, NULL, 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21fc_0_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_0_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_0_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_0_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_0_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_0_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_0_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_4_ff, NULL, 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23f8_0_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_0_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_0_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_4_ff, NULL, 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23fc_0_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_0_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_0_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_0_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_0_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_0_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_0_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_4_ff, NULL, 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3038_0_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_0_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_0_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_4_ff, NULL, 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_303c_0_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_0_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_0_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_0_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_0_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_0_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_0_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_4_ff, NULL, 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_3078_0_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_0_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_0_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_4_ff, NULL, 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_307c_0_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_0_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_0_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_0_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_0_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_0_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_0_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_4_ff, NULL, 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30b8_0_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_0_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_0_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_4_ff, NULL, 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30bc_0_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_0_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_0_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_0_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_0_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_0_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_0_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_4_ff, NULL, 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30f8_0_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_0_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_0_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_4_ff, NULL, 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30fc_0_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_0_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_0_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_0_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_0_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_0_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_0_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_4_ff, NULL, 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3138_0_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_0_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_0_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_4_ff, NULL, 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_313c_0_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_0_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_0_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_0_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_0_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_0_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_0_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_4_ff, NULL, 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_3178_0_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_0_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_0_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_4_ff, NULL, 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_317c_0_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_4_ff, NULL, 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3188_4_ff, NULL, 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3190_4_ff, NULL, 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3198_4_ff, NULL, 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a0_4_ff, NULL, 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a8_4_ff, NULL, 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b0_4_ff, NULL, 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31b8_4_ff, NULL, 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b9_4_ff, NULL, 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_31ba_4_ff, NULL, 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31bb_4_ff, NULL, 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31bc_4_ff, NULL, 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31c0_0_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_0_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_0_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_0_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_0_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_0_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_4_ff, NULL, 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31f8_0_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_0_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_0_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_4_ff, NULL, 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31fc_0_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_0_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_0_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_0_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_0_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_0_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_0_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_4_ff, NULL, 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33f8_0_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_0_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_0_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_4_ff, NULL, 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33fc_0_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_0_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_0_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_0_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_0_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_0_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_4_ff, NULL, 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4038_0_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_0_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_0_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_0_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_0_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_0_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_0_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_4_ff, NULL, 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4078_0_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_0_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_0_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_0_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_0_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_0_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_0_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_4_ff, NULL, 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_40b8_0_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_0_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_5_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_5_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_5_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_5_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_5_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_5_ff, NULL, 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ op_40f8_5_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_5_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4180_0_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_0_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_0_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_0_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_0_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_4_ff, NULL, 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41b8_0_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_0_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_0_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_4_ff, NULL, 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41bc_0_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_0_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_0_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_4_ff, NULL, 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ op_41f8_0_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_5_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_0_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_4_ff, NULL, 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ op_4200_5_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_5_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_5_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_5_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_5_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_5_ff, NULL, 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4238_5_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_5_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_5_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_5_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_5_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_5_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_5_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_5_ff, NULL, 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4278_5_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_5_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_5_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_5_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_5_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_5_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_5_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_5_ff, NULL, 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ op_42b8_5_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_5_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4400_0_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_0_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_0_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_0_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_0_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_4_ff, NULL, 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4438_0_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_0_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_0_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_0_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_0_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_0_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_0_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_4_ff, NULL, 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4478_0_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_0_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_0_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_0_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_0_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_0_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_0_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_4_ff, NULL, 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ op_44b8_0_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_0_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_5_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_5_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_5_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_5_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_5_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_5_ff, NULL, 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44f8_5_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_5_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_5_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_5_ff, NULL, 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44fc_5_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_0_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_0_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_0_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_0_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_0_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_4_ff, NULL, 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4638_0_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_0_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_0_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_0_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_0_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_0_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_0_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_4_ff, NULL, 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4678_0_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_0_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_0_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_0_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_0_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_0_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_0_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_4_ff, NULL, 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ op_46b8_0_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_0_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_5_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_5_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_5_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_5_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_5_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_5_ff, NULL, 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46f8_5_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_5_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_5_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_5_ff, NULL, 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46fc_5_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_4_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4810_4_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_4_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_4_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_4_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_4_ff, NULL, 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ op_4838_4_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_4_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_0_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ op_4850_0_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_0_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_4_ff, NULL, 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4878_0_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_0_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_0_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_4_ff, NULL, 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4880_0_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_4_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_4_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_4_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_4_ff, NULL, 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48b8_4_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_4_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_0_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_4_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_4_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_4_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_4_ff, NULL, 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48f8_4_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_4_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_4a00_0_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_0_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_0_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_0_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_0_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_4_ff, NULL, 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a38_0_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_0_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a40_0_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a50_0_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_0_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_0_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_0_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_4_ff, NULL, 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a78_0_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_0_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a80_0_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a90_0_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_0_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_0_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_0_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_4_ff, NULL, 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ op_4ab8_0_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_0_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ op_4ac0_5_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad0_5_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_5_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_5_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_5_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_5_ff, NULL, 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ op_4af8_5_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_5_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ op_4c90_4_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_4_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_4_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_4_ff, NULL, 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cb8_4_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_4_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_4_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_4_ff, NULL, 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cd0_4_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_4_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_4_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_4_ff, NULL, 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cf8_4_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_4_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_4_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_4_ff, NULL, 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4e40_0_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_4_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_0_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_5_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_5_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_0_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_2_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_5_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_5_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ op_4e75_5_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_5_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_5_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ op_4e90_5_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_5_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_5_ff, NULL, 0x4eb0, 4, { 4, 0 }, 2 }, /* JSR */
{ op_4eb8_5_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_5_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_5_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_5_ff, NULL, 0x4ebb, 4, { 4, 0 }, 2 }, /* JSR */
{ op_4ed0_5_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_5_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_5_ff, NULL, 0x4ef0, 4, { 4, 0 }, 2 }, /* JMP */
{ op_4ef8_5_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_5_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_5_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_5_ff, NULL, 0x4efb, 4, { 4, 0 }, 2 }, /* JMP */
{ op_5000_0_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_0_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_0_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_0_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_0_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_4_ff, NULL, 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5038_0_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_0_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_0_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_0_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_0_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_0_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_0_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_0_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_4_ff, NULL, 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5078_0_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_0_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_5_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_0_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_0_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_0_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_0_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_0_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_4_ff, NULL, 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_50b8_0_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_0_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_5_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_5_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_5_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_5_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_5_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_5_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_5_ff, NULL, 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_50f8_5_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_5_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5100_0_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_0_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_0_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_0_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_0_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_4_ff, NULL, 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5138_0_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_0_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_0_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_0_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_0_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_0_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_0_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_0_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_4_ff, NULL, 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5178_0_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_0_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_5_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_0_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_0_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_0_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_0_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_0_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_4_ff, NULL, 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_51b8_0_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_0_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_5_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_5_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_5_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_5_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_5_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_5_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_5_ff, NULL, 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_51f8_5_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_5_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_52c0_5_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_5_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_5_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_5_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_5_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_5_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_5_ff, NULL, 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_52f8_5_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_5_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_53c0_5_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_5_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_5_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_5_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_5_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_5_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_5_ff, NULL, 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_53f8_5_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_5_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_54c0_5_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_5_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_5_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_5_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_5_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_5_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_5_ff, NULL, 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_54f8_5_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_5_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_55c0_5_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_5_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_5_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_5_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_5_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_5_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_5_ff, NULL, 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_55f8_5_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_5_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_56c0_5_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_5_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_5_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_5_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_5_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_5_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_5_ff, NULL, 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_56f8_5_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_5_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_57c0_5_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_5_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_5_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_5_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_5_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_5_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_5_ff, NULL, 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_57f8_5_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_5_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_58c0_5_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_5_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_5_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_5_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_5_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_5_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_5_ff, NULL, 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_58f8_5_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_5_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_59c0_5_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_5_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_5_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_5_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_5_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_5_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_5_ff, NULL, 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_59f8_5_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_5_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ac0_5_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_5_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_5_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_5_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_5_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_5_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_5_ff, NULL, 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5af8_5_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_5_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5bc0_5_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_5_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_5_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_5_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_5_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_5_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_5_ff, NULL, 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5bf8_5_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_5_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5cc0_5_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_5_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_5_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_5_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_5_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_5_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_5_ff, NULL, 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5cf8_5_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_5_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5dc0_5_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_5_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_5_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_5_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_5_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_5_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_5_ff, NULL, 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5df8_5_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_5_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ec0_5_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_5_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_5_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_5_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_5_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_5_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_5_ff, NULL, 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ef8_5_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_5_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5fc0_5_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_5_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_5_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_5_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_5_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_5_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_5_ff, NULL, 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ff8_5_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_5_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_6000_4_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_4_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_4_ff, NULL, 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6100_5_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_5_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_5_ff, NULL, 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ op_6200_4_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_4_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_4_ff, NULL, 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6300_4_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_4_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_4_ff, NULL, 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6400_4_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_4_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_4_ff, NULL, 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6500_4_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_4_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_4_ff, NULL, 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6600_4_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_4_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_4_ff, NULL, 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6700_4_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_4_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_4_ff, NULL, 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6800_4_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_4_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_4_ff, NULL, 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6900_4_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_4_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_4_ff, NULL, 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6a00_4_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_4_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_4_ff, NULL, 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6b00_4_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_4_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_4_ff, NULL, 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6c00_4_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_4_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_4_ff, NULL, 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6d00_4_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_4_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_4_ff, NULL, 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6e00_4_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_4_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_4_ff, NULL, 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6f00_4_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_4_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_4_ff, NULL, 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_7000_0_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_0_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_0_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_0_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_0_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_0_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_4_ff, NULL, 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ op_8038_0_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_0_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_0_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_4_ff, NULL, 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ op_803c_0_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_0_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_0_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_0_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_0_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_0_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_4_ff, NULL, 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ op_8078_0_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_0_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_0_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_4_ff, NULL, 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ op_807c_0_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_5_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_5_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_5_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_5_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_5_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_5_ff, NULL, 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_80b8_5_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_5_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_5_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_5_ff, NULL, 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ op_80bc_5_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_4_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_4_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_4_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_4_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_4_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_4_ff, NULL, 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80f8_4_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_4_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_4_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_4_ff, NULL, 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80fc_4_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_4_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_4_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_0_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_0_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_0_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_0_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_4_ff, NULL, 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ op_8138_0_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_0_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ op_8150_0_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_0_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_0_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_0_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_4_ff, NULL, 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ op_8178_0_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_0_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ op_8190_0_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_0_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_0_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_0_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_4_ff, NULL, 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_81b8_0_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_0_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_4_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_4_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_4_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_4_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_4_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_4_ff, NULL, 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81f8_4_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_4_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_4_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_4_ff, NULL, 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81fc_4_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_0_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_0_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_0_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_0_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_0_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_4_ff, NULL, 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9038_0_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_0_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_0_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_4_ff, NULL, 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_903c_0_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_0_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_0_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_0_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_0_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_0_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_0_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_4_ff, NULL, 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9078_0_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_0_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_0_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_4_ff, NULL, 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_907c_0_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_5_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_5_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_5_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_5_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_5_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_5_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_5_ff, NULL, 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90b8_5_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_5_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_5_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_5_ff, NULL, 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90bc_5_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_0_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_0_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_0_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_0_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_0_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_0_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_4_ff, NULL, 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90f8_0_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_0_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_0_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_4_ff, NULL, 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90fc_0_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_5_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_5_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_0_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_0_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_0_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_0_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_4_ff, NULL, 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9138_0_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_0_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_5_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_5_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_0_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_0_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_0_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_0_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_4_ff, NULL, 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9178_0_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_0_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_5_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_5_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_0_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_0_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_0_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_0_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_4_ff, NULL, 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_91b8_0_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_0_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_0_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_0_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_0_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_0_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_0_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_0_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_4_ff, NULL, 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91f8_0_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_0_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_0_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_4_ff, NULL, 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91fc_0_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_0_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_0_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_0_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_0_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_0_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_4_ff, NULL, 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b038_0_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_0_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_0_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_4_ff, NULL, 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b03c_0_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_0_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_0_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_0_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_0_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_0_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_0_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_4_ff, NULL, 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b078_0_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_0_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_0_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_4_ff, NULL, 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b07c_0_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_0_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_0_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_0_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_0_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_0_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_0_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_4_ff, NULL, 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0b8_0_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_0_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_0_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_4_ff, NULL, 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0bc_0_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_0_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_0_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_0_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_0_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_0_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_0_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_4_ff, NULL, 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0f8_0_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_0_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_0_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_4_ff, NULL, 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0fc_0_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_0_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_0_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_0_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_0_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_0_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_0_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_4_ff, NULL, 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b138_0_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_0_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_0_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_0_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_0_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_0_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_0_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_0_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_4_ff, NULL, 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b178_0_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_0_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_5_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_0_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_0_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_0_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_0_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_0_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_4_ff, NULL, 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b1b8_0_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_0_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_0_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_0_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_0_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_0_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_0_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_0_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_4_ff, NULL, 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1f8_0_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_0_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_0_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_4_ff, NULL, 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1fc_0_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_0_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_0_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_0_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_0_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_0_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_4_ff, NULL, 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ op_c038_0_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_0_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_0_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_4_ff, NULL, 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c03c_0_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_0_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_0_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_0_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_0_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_0_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_4_ff, NULL, 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ op_c078_0_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_0_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_0_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_4_ff, NULL, 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c07c_0_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_5_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_5_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_5_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_5_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_5_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_5_ff, NULL, 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0b8_5_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_5_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_5_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_5_ff, NULL, 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0bc_5_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_4_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_4_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_4_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_4_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_4_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_4_ff, NULL, 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0f8_4_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_4_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_4_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_4_ff, NULL, 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0fc_4_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_4_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_4_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_0_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_0_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_0_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_0_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_4_ff, NULL, 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ op_c138_0_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_0_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_0_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_0_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_0_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_0_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_0_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_0_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_4_ff, NULL, 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ op_c178_0_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_0_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_0_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_0_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_0_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_0_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_0_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_4_ff, NULL, 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c1b8_0_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_0_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_4_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_4_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_4_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_4_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_4_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_4_ff, NULL, 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1f8_4_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_4_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_4_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_4_ff, NULL, 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1fc_4_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_0_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_0_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_0_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_0_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_0_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_4_ff, NULL, 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d038_0_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_0_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_0_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_4_ff, NULL, 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d03c_0_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_0_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_0_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_0_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_0_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_0_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_0_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_4_ff, NULL, 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d078_0_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_0_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_0_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_4_ff, NULL, 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d07c_0_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_5_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_5_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_5_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_5_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_5_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_5_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_5_ff, NULL, 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0b8_5_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_5_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_5_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_5_ff, NULL, 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0bc_5_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_0_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_0_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_0_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_0_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_0_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_0_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_4_ff, NULL, 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0f8_0_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_0_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_0_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_4_ff, NULL, 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0fc_0_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_5_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_5_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_0_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_0_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_0_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_0_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_4_ff, NULL, 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d138_0_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_0_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_5_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_5_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_0_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_0_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_0_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_0_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_4_ff, NULL, 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d178_0_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_0_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_5_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_5_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_0_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_0_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_0_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_0_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_4_ff, NULL, 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d1b8_0_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_0_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_0_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_0_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_0_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_0_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_0_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_0_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_4_ff, NULL, 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1f8_0_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_0_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_0_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_4_ff, NULL, 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1fc_0_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_4_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_4_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_4_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_4_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_4_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_4_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_4_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_4_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_4_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_4_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_4_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_4_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_4_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_4_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_4_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_4_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_4_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_4_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_4_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_4_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_4_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_4_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_4_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_4_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_0_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_0_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_0_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_0_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_4_ff, NULL, 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ op_e0f8_0_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_0_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_4_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_4_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_4_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_4_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_4_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_4_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_4_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_4_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_4_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_4_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_4_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_4_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_4_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_4_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_4_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_4_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_4_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_4_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_4_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_4_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_4_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_4_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_4_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_4_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_0_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_0_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_0_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_0_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_4_ff, NULL, 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ op_e1f8_0_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_0_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_0_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_0_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_0_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_0_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_4_ff, NULL, 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ op_e2f8_0_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_0_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_0_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_0_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_0_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_0_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_4_ff, NULL, 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ op_e3f8_0_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_0_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_0_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_0_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_0_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_0_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_4_ff, NULL, 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ op_e4f8_0_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_0_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_0_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_0_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_0_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_0_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_4_ff, NULL, 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ op_e5f8_0_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_0_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_0_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_0_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_0_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_0_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_4_ff, NULL, 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ op_e6f8_0_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_0_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_0_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_0_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_0_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_0_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_4_ff, NULL, 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ op_e7f8_0_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_0_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_68000_ONLY */
#ifdef CPUEMU_11
const struct cputbl op_smalltbl_11[] = {
{ op_0000_11_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_11_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_11_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_11_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_11_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_11_ff, NULL, 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ op_0038_11_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_11_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_11_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_11_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_11_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_11_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_11_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_11_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_11_ff, NULL, 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ op_0078_11_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_11_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_11_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_11_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_11_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_11_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_11_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_11_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_11_ff, NULL, 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ op_00b8_11_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_11_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ op_0100_11_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_11_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_11_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_11_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_11_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_11_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_11_ff, NULL, 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ op_0138_11_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_11_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_11_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_11_ff, NULL, 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ op_013c_11_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_11_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_11_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_11_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_11_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_11_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_11_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_11_ff, NULL, 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ op_0178_11_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_11_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_11_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_11_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_11_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_11_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_11_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_11_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_11_ff, NULL, 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ op_01b8_11_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_11_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_11_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_11_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_11_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_11_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_11_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_11_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_11_ff, NULL, 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ op_01f8_11_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_11_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_11_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_11_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_11_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_11_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_11_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_11_ff, NULL, 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ op_0238_11_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_11_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_11_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_11_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_11_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_11_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_11_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_11_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_11_ff, NULL, 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ op_0278_11_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_11_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_11_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_11_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_11_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_11_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_11_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_11_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_11_ff, NULL, 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ op_02b8_11_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_11_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ op_0400_11_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_11_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_11_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_11_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_11_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_11_ff, NULL, 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0438_11_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_11_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_11_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_11_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_11_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_11_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_11_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_11_ff, NULL, 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0478_11_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_11_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_11_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_11_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_11_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_11_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_11_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_11_ff, NULL, 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ op_04b8_11_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_11_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ op_0600_11_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_11_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_11_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_11_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_11_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_11_ff, NULL, 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0638_11_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_11_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_11_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_11_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_11_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_11_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_11_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_11_ff, NULL, 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0678_11_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_11_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_11_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_11_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_11_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_11_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_11_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_11_ff, NULL, 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ op_06b8_11_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_11_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ op_0800_11_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_11_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_11_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_11_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_11_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_11_ff, NULL, 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0838_11_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_11_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_11_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_11_ff, NULL, 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0840_11_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_11_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_11_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_11_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_11_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_11_ff, NULL, 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ op_0878_11_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_11_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_11_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_11_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_11_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_11_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_11_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_11_ff, NULL, 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ op_08b8_11_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_11_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_11_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_11_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_11_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_11_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_11_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_11_ff, NULL, 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ op_08f8_11_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_11_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_11_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_11_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_11_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_11_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_11_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_11_ff, NULL, 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a38_11_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_11_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_11_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_11_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_11_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_11_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_11_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_11_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_11_ff, NULL, 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a78_11_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_11_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_11_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_11_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_11_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_11_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_11_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_11_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_11_ff, NULL, 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ op_0ab8_11_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_11_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ op_0c00_11_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_11_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_11_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_11_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_11_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_11_ff, NULL, 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c38_11_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_11_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c40_11_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_11_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_11_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_11_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_11_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_11_ff, NULL, 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c78_11_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_11_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c80_11_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_11_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_11_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_11_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_11_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_11_ff, NULL, 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ op_0cb8_11_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_11_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ op_0e10_11_ff, NULL, 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e18_11_ff, NULL, 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e20_11_ff, NULL, 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e28_11_ff, NULL, 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e30_11_ff, NULL, 0x0e30, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e38_11_ff, NULL, 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e39_11_ff, NULL, 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e50_11_ff, NULL, 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e58_11_ff, NULL, 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e60_11_ff, NULL, 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e68_11_ff, NULL, 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e70_11_ff, NULL, 0x0e70, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e78_11_ff, NULL, 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e79_11_ff, NULL, 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e90_11_ff, NULL, 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0e98_11_ff, NULL, 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea0_11_ff, NULL, 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0ea8_11_ff, NULL, 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb0_11_ff, NULL, 0x0eb0, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb8_11_ff, NULL, 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_0eb9_11_ff, NULL, 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
{ op_1000_11_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_11_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_11_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_11_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_11_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_11_ff, NULL, 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1038_11_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_11_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_11_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_11_ff, NULL, 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_103c_11_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_11_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_11_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_11_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_11_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_11_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_11_ff, NULL, 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10b8_11_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_11_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_11_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_11_ff, NULL, 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10bc_11_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_11_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_11_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_11_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_11_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_11_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_11_ff, NULL, 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10f8_11_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_11_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_11_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_11_ff, NULL, 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10fc_11_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_11_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_11_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_11_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_11_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_11_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_11_ff, NULL, 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1138_11_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_11_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_11_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_11_ff, NULL, 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_113c_11_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_11_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_11_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_11_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_11_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_11_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_11_ff, NULL, 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_1178_11_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_11_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_11_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_11_ff, NULL, 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_117c_11_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_11_ff, NULL, 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1190_11_ff, NULL, 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1198_11_ff, NULL, 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a0_11_ff, NULL, 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a8_11_ff, NULL, 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b0_11_ff, NULL, 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11b8_11_ff, NULL, 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b9_11_ff, NULL, 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_11ba_11_ff, NULL, 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11bb_11_ff, NULL, 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11bc_11_ff, NULL, 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11c0_11_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_11_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_11_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_11_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_11_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_11_ff, NULL, 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11f8_11_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_11_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_11_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_11_ff, NULL, 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11fc_11_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_11_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_11_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_11_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_11_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_11_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_11_ff, NULL, 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13f8_11_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_11_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_11_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_11_ff, NULL, 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13fc_11_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_11_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_11_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_11_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_11_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_11_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_11_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_11_ff, NULL, 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2038_11_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_11_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_11_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_11_ff, NULL, 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_203c_11_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_11_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_11_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_11_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_11_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_11_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_11_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_11_ff, NULL, 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_2078_11_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_11_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_11_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_11_ff, NULL, 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_207c_11_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_11_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_11_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_11_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_11_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_11_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_11_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_11_ff, NULL, 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20b8_11_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_11_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_11_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_11_ff, NULL, 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20bc_11_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_11_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_11_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_11_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_11_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_11_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_11_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_11_ff, NULL, 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20f8_11_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_11_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_11_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_11_ff, NULL, 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20fc_11_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_11_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_11_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_11_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_11_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_11_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_11_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_11_ff, NULL, 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2138_11_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_11_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_11_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_11_ff, NULL, 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_213c_11_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_11_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_11_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_11_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_11_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_11_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_11_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_11_ff, NULL, 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_2178_11_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_11_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_11_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_11_ff, NULL, 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_217c_11_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_11_ff, NULL, 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2188_11_ff, NULL, 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2190_11_ff, NULL, 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2198_11_ff, NULL, 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a0_11_ff, NULL, 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a8_11_ff, NULL, 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b0_11_ff, NULL, 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21b8_11_ff, NULL, 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b9_11_ff, NULL, 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21ba_11_ff, NULL, 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21bb_11_ff, NULL, 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21bc_11_ff, NULL, 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21c0_11_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_11_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_11_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_11_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_11_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_11_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_11_ff, NULL, 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21f8_11_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_11_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_11_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_11_ff, NULL, 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21fc_11_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_11_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_11_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_11_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_11_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_11_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_11_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_11_ff, NULL, 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23f8_11_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_11_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_11_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_11_ff, NULL, 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23fc_11_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_11_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_11_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_11_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_11_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_11_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_11_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_11_ff, NULL, 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3038_11_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_11_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_11_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_11_ff, NULL, 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_303c_11_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_11_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_11_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_11_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_11_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_11_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_11_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_11_ff, NULL, 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_3078_11_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_11_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_11_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_11_ff, NULL, 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_307c_11_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_11_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_11_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_11_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_11_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_11_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_11_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_11_ff, NULL, 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30b8_11_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_11_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_11_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_11_ff, NULL, 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30bc_11_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_11_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_11_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_11_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_11_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_11_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_11_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_11_ff, NULL, 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30f8_11_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_11_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_11_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_11_ff, NULL, 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30fc_11_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_11_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_11_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_11_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_11_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_11_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_11_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_11_ff, NULL, 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3138_11_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_11_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_11_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_11_ff, NULL, 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_313c_11_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_11_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_11_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_11_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_11_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_11_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_11_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_11_ff, NULL, 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_3178_11_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_11_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_11_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_11_ff, NULL, 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_317c_11_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_11_ff, NULL, 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3188_11_ff, NULL, 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3190_11_ff, NULL, 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3198_11_ff, NULL, 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a0_11_ff, NULL, 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a8_11_ff, NULL, 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b0_11_ff, NULL, 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31b8_11_ff, NULL, 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b9_11_ff, NULL, 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_31ba_11_ff, NULL, 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31bb_11_ff, NULL, 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31bc_11_ff, NULL, 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31c0_11_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_11_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_11_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_11_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_11_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_11_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_11_ff, NULL, 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31f8_11_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_11_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_11_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_11_ff, NULL, 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31fc_11_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_11_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_11_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_11_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_11_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_11_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_11_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_11_ff, NULL, 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33f8_11_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_11_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_11_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_11_ff, NULL, 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33fc_11_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_11_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_11_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_11_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_11_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_11_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_11_ff, NULL, 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4038_11_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_11_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_11_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_11_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_11_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_11_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_11_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_11_ff, NULL, 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4078_11_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_11_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_11_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_11_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_11_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_11_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_11_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_11_ff, NULL, 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_40b8_11_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_11_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_11_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_11_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_11_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_11_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_11_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_11_ff, NULL, 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ op_40f8_11_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_11_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4180_11_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_11_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_11_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_11_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_11_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_11_ff, NULL, 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41b8_11_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_11_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_11_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_11_ff, NULL, 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41bc_11_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_11_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_11_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_11_ff, NULL, 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ op_41f8_11_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_11_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_11_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_11_ff, NULL, 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ op_4200_11_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_11_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_11_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_11_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_11_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_11_ff, NULL, 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4238_11_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_11_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_11_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_11_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_11_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_11_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_11_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_11_ff, NULL, 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4278_11_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_11_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_11_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_11_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_11_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_11_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_11_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_11_ff, NULL, 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ op_42b8_11_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_11_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
#ifndef CPUEMU_68000_ONLY
{ op_42c0_11_ff, NULL, 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42d0_11_ff, NULL, 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42d8_11_ff, NULL, 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42e0_11_ff, NULL, 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42e8_11_ff, NULL, 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42f0_11_ff, NULL, 0x42f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42f8_11_ff, NULL, 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_42f9_11_ff, NULL, 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#endif
{ op_4400_11_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_11_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_11_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_11_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_11_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_11_ff, NULL, 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4438_11_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_11_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_11_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_11_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_11_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_11_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_11_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_11_ff, NULL, 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4478_11_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_11_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_11_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_11_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_11_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_11_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_11_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_11_ff, NULL, 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ op_44b8_11_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_11_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_11_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_11_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_11_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_11_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_11_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_11_ff, NULL, 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44f8_11_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_11_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_11_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_11_ff, NULL, 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44fc_11_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_11_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_11_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_11_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_11_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_11_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_11_ff, NULL, 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4638_11_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_11_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_11_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_11_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_11_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_11_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_11_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_11_ff, NULL, 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4678_11_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_11_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_11_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_11_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_11_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_11_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_11_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_11_ff, NULL, 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ op_46b8_11_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_11_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_11_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_11_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_11_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_11_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_11_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_11_ff, NULL, 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46f8_11_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_11_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_11_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_11_ff, NULL, 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46fc_11_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_11_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4810_11_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_11_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_11_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_11_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_11_ff, NULL, 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ op_4838_11_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_11_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_11_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
#ifndef CPUEMU_68000_ONLY
{ op_4848_11_ff, NULL, 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
#endif
{ op_4850_11_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_11_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_11_ff, NULL, 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4878_11_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_11_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_11_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_11_ff, NULL, 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4880_11_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_11_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_11_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_11_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_11_ff, NULL, 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48b8_11_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_11_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_11_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_11_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_11_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_11_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_11_ff, NULL, 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48f8_11_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_11_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_4a00_11_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_11_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_11_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_11_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_11_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_11_ff, NULL, 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a38_11_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_11_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a40_11_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a50_11_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_11_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_11_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_11_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_11_ff, NULL, 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a78_11_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_11_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a80_11_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a90_11_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_11_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_11_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_11_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_11_ff, NULL, 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ op_4ab8_11_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_11_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ op_4ac0_11_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad0_11_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_11_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_11_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_11_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_11_ff, NULL, 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ op_4af8_11_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_11_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ op_4c90_11_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_11_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_11_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_11_ff, NULL, 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cb8_11_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_11_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_11_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_11_ff, NULL, 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cd0_11_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_11_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_11_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_11_ff, NULL, 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cf8_11_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_11_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_11_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_11_ff, NULL, 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4e40_11_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_11_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_11_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_11_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_11_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_11_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_11_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_11_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_11_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
#ifndef CPUEMU_68000_ONLY
{ op_4e74_11_ff, NULL, 0x4e74, 4, { 0, 0 }, 2 }, /* RTD */
#endif
{ op_4e75_11_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_11_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_11_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
#ifndef CPUEMU_68000_ONLY
{ op_4e7a_11_ff, NULL, 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ op_4e7b_11_ff, NULL, 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ op_4e90_11_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_11_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_11_ff, NULL, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4eb8_11_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_11_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_11_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_11_ff, NULL, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4ed0_11_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_11_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_11_ff, NULL, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ op_4ef8_11_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_11_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_11_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_11_ff, NULL, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ op_5000_11_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_11_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_11_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_11_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_11_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_11_ff, NULL, 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5038_11_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_11_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_11_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_11_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_11_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_11_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_11_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_11_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_11_ff, NULL, 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5078_11_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_11_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_11_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_11_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_11_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_11_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_11_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_11_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_11_ff, NULL, 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_50b8_11_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_11_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_11_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_11_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_11_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_11_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_11_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_11_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_11_ff, NULL, 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_50f8_11_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_11_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5100_11_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_11_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_11_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_11_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_11_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_11_ff, NULL, 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5138_11_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_11_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_11_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_11_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_11_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_11_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_11_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_11_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_11_ff, NULL, 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5178_11_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_11_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_11_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_11_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_11_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_11_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_11_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_11_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_11_ff, NULL, 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_51b8_11_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_11_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_11_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_11_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_11_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_11_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_11_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_11_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_11_ff, NULL, 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_51f8_11_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_11_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_52c0_11_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_11_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_11_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_11_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_11_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_11_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_11_ff, NULL, 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_52f8_11_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_11_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_53c0_11_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_11_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_11_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_11_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_11_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_11_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_11_ff, NULL, 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_53f8_11_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_11_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_54c0_11_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_11_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_11_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_11_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_11_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_11_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_11_ff, NULL, 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_54f8_11_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_11_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_55c0_11_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_11_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_11_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_11_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_11_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_11_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_11_ff, NULL, 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_55f8_11_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_11_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_56c0_11_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_11_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_11_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_11_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_11_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_11_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_11_ff, NULL, 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_56f8_11_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_11_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_57c0_11_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_11_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_11_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_11_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_11_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_11_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_11_ff, NULL, 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_57f8_11_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_11_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_58c0_11_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_11_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_11_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_11_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_11_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_11_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_11_ff, NULL, 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_58f8_11_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_11_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_59c0_11_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_11_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_11_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_11_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_11_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_11_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_11_ff, NULL, 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_59f8_11_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_11_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ac0_11_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_11_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_11_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_11_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_11_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_11_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_11_ff, NULL, 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5af8_11_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_11_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5bc0_11_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_11_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_11_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_11_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_11_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_11_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_11_ff, NULL, 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5bf8_11_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_11_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5cc0_11_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_11_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_11_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_11_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_11_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_11_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_11_ff, NULL, 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5cf8_11_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_11_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5dc0_11_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_11_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_11_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_11_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_11_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_11_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_11_ff, NULL, 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5df8_11_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_11_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ec0_11_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_11_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_11_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_11_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_11_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_11_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_11_ff, NULL, 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ef8_11_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_11_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5fc0_11_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_11_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_11_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_11_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_11_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_11_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_11_ff, NULL, 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ff8_11_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_11_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_6000_11_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_11_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_11_ff, NULL, 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6100_11_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_11_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_11_ff, NULL, 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ op_6200_11_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_11_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_11_ff, NULL, 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6300_11_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_11_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_11_ff, NULL, 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6400_11_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_11_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_11_ff, NULL, 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6500_11_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_11_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_11_ff, NULL, 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6600_11_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_11_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_11_ff, NULL, 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6700_11_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_11_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_11_ff, NULL, 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6800_11_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_11_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_11_ff, NULL, 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6900_11_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_11_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_11_ff, NULL, 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6a00_11_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_11_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_11_ff, NULL, 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6b00_11_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_11_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_11_ff, NULL, 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6c00_11_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_11_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_11_ff, NULL, 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6d00_11_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_11_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_11_ff, NULL, 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6e00_11_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_11_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_11_ff, NULL, 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6f00_11_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_11_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_11_ff, NULL, 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_7000_11_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_11_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_11_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_11_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_11_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_11_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_11_ff, NULL, 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ op_8038_11_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_11_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_11_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_11_ff, NULL, 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ op_803c_11_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_11_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_11_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_11_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_11_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_11_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_11_ff, NULL, 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ op_8078_11_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_11_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_11_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_11_ff, NULL, 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ op_807c_11_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_11_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_11_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_11_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_11_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_11_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_11_ff, NULL, 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_80b8_11_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_11_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_11_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_11_ff, NULL, 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ op_80bc_11_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_11_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_11_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_11_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_11_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_11_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_11_ff, NULL, 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80f8_11_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_11_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_11_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_11_ff, NULL, 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80fc_11_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_11_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_11_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_11_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_11_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_11_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_11_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_11_ff, NULL, 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ op_8138_11_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_11_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ op_8150_11_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_11_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_11_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_11_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_11_ff, NULL, 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ op_8178_11_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_11_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ op_8190_11_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_11_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_11_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_11_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_11_ff, NULL, 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_81b8_11_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_11_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_11_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_11_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_11_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_11_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_11_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_11_ff, NULL, 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81f8_11_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_11_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_11_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_11_ff, NULL, 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81fc_11_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_11_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_11_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_11_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_11_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_11_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_11_ff, NULL, 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9038_11_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_11_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_11_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_11_ff, NULL, 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_903c_11_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_11_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_11_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_11_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_11_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_11_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_11_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_11_ff, NULL, 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9078_11_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_11_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_11_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_11_ff, NULL, 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_907c_11_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_11_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_11_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_11_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_11_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_11_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_11_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_11_ff, NULL, 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90b8_11_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_11_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_11_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_11_ff, NULL, 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90bc_11_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_11_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_11_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_11_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_11_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_11_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_11_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_11_ff, NULL, 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90f8_11_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_11_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_11_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_11_ff, NULL, 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90fc_11_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_11_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_11_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_11_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_11_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_11_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_11_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_11_ff, NULL, 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9138_11_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_11_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_11_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_11_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_11_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_11_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_11_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_11_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_11_ff, NULL, 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9178_11_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_11_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_11_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_11_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_11_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_11_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_11_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_11_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_11_ff, NULL, 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_91b8_11_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_11_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_11_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_11_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_11_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_11_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_11_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_11_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_11_ff, NULL, 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91f8_11_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_11_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_11_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_11_ff, NULL, 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91fc_11_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_11_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_11_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_11_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_11_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_11_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_11_ff, NULL, 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b038_11_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_11_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_11_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_11_ff, NULL, 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b03c_11_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_11_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_11_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_11_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_11_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_11_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_11_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_11_ff, NULL, 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b078_11_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_11_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_11_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_11_ff, NULL, 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b07c_11_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_11_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_11_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_11_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_11_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_11_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_11_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_11_ff, NULL, 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0b8_11_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_11_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_11_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_11_ff, NULL, 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0bc_11_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_11_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_11_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_11_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_11_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_11_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_11_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_11_ff, NULL, 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0f8_11_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_11_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_11_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_11_ff, NULL, 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0fc_11_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_11_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_11_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_11_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_11_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_11_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_11_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_11_ff, NULL, 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b138_11_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_11_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_11_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_11_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_11_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_11_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_11_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_11_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_11_ff, NULL, 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b178_11_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_11_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_11_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_11_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_11_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_11_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_11_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_11_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_11_ff, NULL, 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b1b8_11_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_11_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_11_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_11_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_11_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_11_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_11_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_11_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_11_ff, NULL, 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1f8_11_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_11_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_11_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_11_ff, NULL, 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1fc_11_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_11_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_11_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_11_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_11_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_11_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_11_ff, NULL, 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ op_c038_11_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_11_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_11_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_11_ff, NULL, 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c03c_11_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_11_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_11_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_11_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_11_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_11_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_11_ff, NULL, 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ op_c078_11_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_11_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_11_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_11_ff, NULL, 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c07c_11_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_11_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_11_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_11_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_11_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_11_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_11_ff, NULL, 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0b8_11_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_11_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_11_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_11_ff, NULL, 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0bc_11_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_11_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_11_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_11_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_11_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_11_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_11_ff, NULL, 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0f8_11_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_11_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_11_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_11_ff, NULL, 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0fc_11_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_11_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_11_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_11_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_11_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_11_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_11_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_11_ff, NULL, 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ op_c138_11_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_11_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_11_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_11_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_11_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_11_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_11_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_11_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_11_ff, NULL, 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ op_c178_11_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_11_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_11_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_11_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_11_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_11_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_11_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_11_ff, NULL, 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c1b8_11_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_11_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_11_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_11_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_11_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_11_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_11_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_11_ff, NULL, 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1f8_11_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_11_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_11_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_11_ff, NULL, 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1fc_11_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_11_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_11_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_11_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_11_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_11_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_11_ff, NULL, 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d038_11_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_11_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_11_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_11_ff, NULL, 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d03c_11_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_11_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_11_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_11_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_11_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_11_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_11_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_11_ff, NULL, 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d078_11_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_11_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_11_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_11_ff, NULL, 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d07c_11_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_11_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_11_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_11_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_11_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_11_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_11_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_11_ff, NULL, 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0b8_11_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_11_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_11_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_11_ff, NULL, 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0bc_11_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_11_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_11_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_11_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_11_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_11_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_11_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_11_ff, NULL, 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0f8_11_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_11_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_11_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_11_ff, NULL, 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0fc_11_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_11_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_11_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_11_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_11_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_11_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_11_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_11_ff, NULL, 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d138_11_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_11_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_11_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_11_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_11_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_11_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_11_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_11_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_11_ff, NULL, 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d178_11_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_11_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_11_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_11_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_11_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_11_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_11_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_11_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_11_ff, NULL, 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d1b8_11_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_11_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_11_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_11_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_11_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_11_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_11_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_11_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_11_ff, NULL, 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1f8_11_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_11_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_11_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_11_ff, NULL, 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1fc_11_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_11_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_11_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_11_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_11_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_11_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_11_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_11_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_11_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_11_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_11_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_11_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_11_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_11_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_11_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_11_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_11_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_11_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_11_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_11_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_11_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_11_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_11_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_11_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_11_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_11_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_11_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_11_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_11_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_11_ff, NULL, 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ op_e0f8_11_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_11_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_11_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_11_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_11_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_11_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_11_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_11_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_11_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_11_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_11_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_11_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_11_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_11_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_11_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_11_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_11_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_11_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_11_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_11_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_11_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_11_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_11_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_11_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_11_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_11_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_11_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_11_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_11_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_11_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_11_ff, NULL, 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ op_e1f8_11_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_11_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_11_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_11_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_11_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_11_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_11_ff, NULL, 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ op_e2f8_11_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_11_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_11_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_11_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_11_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_11_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_11_ff, NULL, 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ op_e3f8_11_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_11_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_11_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_11_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_11_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_11_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_11_ff, NULL, 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ op_e4f8_11_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_11_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_11_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_11_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_11_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_11_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_11_ff, NULL, 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ op_e5f8_11_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_11_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_11_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_11_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_11_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_11_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_11_ff, NULL, 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ op_e6f8_11_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_11_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_11_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_11_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_11_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_11_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_11_ff, NULL, 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ op_e7f8_11_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_11_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_11 */
const struct cputbl op_smalltbl_12[] = {
{ op_0000_12_ff, NULL, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ op_0010_12_ff, NULL, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ op_0018_12_ff, NULL, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ op_0020_12_ff, NULL, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ op_0028_12_ff, NULL, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ op_0030_12_ff, NULL, 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ op_0038_12_ff, NULL, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ op_0039_12_ff, NULL, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ op_003c_12_ff, NULL, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0040_12_ff, NULL, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ op_0050_12_ff, NULL, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ op_0058_12_ff, NULL, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ op_0060_12_ff, NULL, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ op_0068_12_ff, NULL, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ op_0070_12_ff, NULL, 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ op_0078_12_ff, NULL, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ op_0079_12_ff, NULL, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ op_007c_12_ff, NULL, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ op_0080_12_ff, NULL, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ op_0090_12_ff, NULL, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ op_0098_12_ff, NULL, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a0_12_ff, NULL, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ op_00a8_12_ff, NULL, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b0_12_ff, NULL, 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ op_00b8_12_ff, NULL, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ op_00b9_12_ff, NULL, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ op_0100_12_ff, NULL, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0108_12_ff, NULL, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0110_12_ff, NULL, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0118_12_ff, NULL, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0120_12_ff, NULL, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ op_0128_12_ff, NULL, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0130_12_ff, NULL, 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ op_0138_12_ff, NULL, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0139_12_ff, NULL, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ op_013a_12_ff, NULL, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ op_013b_12_ff, NULL, 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ op_013c_12_ff, NULL, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0140_12_ff, NULL, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0148_12_ff, NULL, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ op_0150_12_ff, NULL, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0158_12_ff, NULL, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0160_12_ff, NULL, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ op_0168_12_ff, NULL, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0170_12_ff, NULL, 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ op_0178_12_ff, NULL, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0179_12_ff, NULL, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0180_12_ff, NULL, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0188_12_ff, NULL, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_0190_12_ff, NULL, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_0198_12_ff, NULL, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a0_12_ff, NULL, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ op_01a8_12_ff, NULL, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b0_12_ff, NULL, 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ op_01b8_12_ff, NULL, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_01b9_12_ff, NULL, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_01c0_12_ff, NULL, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01c8_12_ff, NULL, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ op_01d0_12_ff, NULL, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01d8_12_ff, NULL, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e0_12_ff, NULL, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ op_01e8_12_ff, NULL, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f0_12_ff, NULL, 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ op_01f8_12_ff, NULL, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_01f9_12_ff, NULL, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ op_0200_12_ff, NULL, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ op_0210_12_ff, NULL, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ op_0218_12_ff, NULL, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ op_0220_12_ff, NULL, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ op_0228_12_ff, NULL, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ op_0230_12_ff, NULL, 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ op_0238_12_ff, NULL, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ op_0239_12_ff, NULL, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ op_023c_12_ff, NULL, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0240_12_ff, NULL, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ op_0250_12_ff, NULL, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ op_0258_12_ff, NULL, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ op_0260_12_ff, NULL, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ op_0268_12_ff, NULL, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ op_0270_12_ff, NULL, 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ op_0278_12_ff, NULL, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ op_0279_12_ff, NULL, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ op_027c_12_ff, NULL, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ op_0280_12_ff, NULL, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ op_0290_12_ff, NULL, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ op_0298_12_ff, NULL, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a0_12_ff, NULL, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ op_02a8_12_ff, NULL, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b0_12_ff, NULL, 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ op_02b8_12_ff, NULL, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ op_02b9_12_ff, NULL, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ op_0400_12_ff, NULL, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0410_12_ff, NULL, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0418_12_ff, NULL, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0420_12_ff, NULL, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0428_12_ff, NULL, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0430_12_ff, NULL, 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0438_12_ff, NULL, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0439_12_ff, NULL, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0440_12_ff, NULL, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0450_12_ff, NULL, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0458_12_ff, NULL, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0460_12_ff, NULL, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ op_0468_12_ff, NULL, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0470_12_ff, NULL, 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ op_0478_12_ff, NULL, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0479_12_ff, NULL, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ op_0480_12_ff, NULL, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0490_12_ff, NULL, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ op_0498_12_ff, NULL, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a0_12_ff, NULL, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ op_04a8_12_ff, NULL, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b0_12_ff, NULL, 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ op_04b8_12_ff, NULL, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ op_04b9_12_ff, NULL, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ op_0600_12_ff, NULL, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0610_12_ff, NULL, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0618_12_ff, NULL, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0620_12_ff, NULL, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0628_12_ff, NULL, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0630_12_ff, NULL, 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0638_12_ff, NULL, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0639_12_ff, NULL, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0640_12_ff, NULL, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0650_12_ff, NULL, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0658_12_ff, NULL, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0660_12_ff, NULL, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ op_0668_12_ff, NULL, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0670_12_ff, NULL, 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ op_0678_12_ff, NULL, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0679_12_ff, NULL, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ op_0680_12_ff, NULL, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0690_12_ff, NULL, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ op_0698_12_ff, NULL, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a0_12_ff, NULL, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ op_06a8_12_ff, NULL, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b0_12_ff, NULL, 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ op_06b8_12_ff, NULL, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ op_06b9_12_ff, NULL, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ op_0800_12_ff, NULL, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0810_12_ff, NULL, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0818_12_ff, NULL, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0820_12_ff, NULL, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ op_0828_12_ff, NULL, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0830_12_ff, NULL, 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0838_12_ff, NULL, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ op_0839_12_ff, NULL, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ op_083a_12_ff, NULL, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ op_083b_12_ff, NULL, 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ op_0840_12_ff, NULL, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0850_12_ff, NULL, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0858_12_ff, NULL, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0860_12_ff, NULL, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ op_0868_12_ff, NULL, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0870_12_ff, NULL, 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ op_0878_12_ff, NULL, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ op_0879_12_ff, NULL, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ op_0880_12_ff, NULL, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0890_12_ff, NULL, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_0898_12_ff, NULL, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a0_12_ff, NULL, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ op_08a8_12_ff, NULL, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b0_12_ff, NULL, 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ op_08b8_12_ff, NULL, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ op_08b9_12_ff, NULL, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ op_08c0_12_ff, NULL, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d0_12_ff, NULL, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08d8_12_ff, NULL, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e0_12_ff, NULL, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ op_08e8_12_ff, NULL, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f0_12_ff, NULL, 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ op_08f8_12_ff, NULL, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ op_08f9_12_ff, NULL, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ op_0a00_12_ff, NULL, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a10_12_ff, NULL, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a18_12_ff, NULL, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a20_12_ff, NULL, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a28_12_ff, NULL, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a30_12_ff, NULL, 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a38_12_ff, NULL, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a39_12_ff, NULL, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a3c_12_ff, NULL, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a40_12_ff, NULL, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a50_12_ff, NULL, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a58_12_ff, NULL, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a60_12_ff, NULL, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ op_0a68_12_ff, NULL, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a70_12_ff, NULL, 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ op_0a78_12_ff, NULL, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a79_12_ff, NULL, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0a7c_12_ff, NULL, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ op_0a80_12_ff, NULL, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a90_12_ff, NULL, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0a98_12_ff, NULL, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa0_12_ff, NULL, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ op_0aa8_12_ff, NULL, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab0_12_ff, NULL, 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ op_0ab8_12_ff, NULL, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ op_0ab9_12_ff, NULL, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ op_0c00_12_ff, NULL, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c10_12_ff, NULL, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c18_12_ff, NULL, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c20_12_ff, NULL, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c28_12_ff, NULL, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c30_12_ff, NULL, 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c38_12_ff, NULL, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c39_12_ff, NULL, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c40_12_ff, NULL, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c50_12_ff, NULL, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c58_12_ff, NULL, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c60_12_ff, NULL, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ op_0c68_12_ff, NULL, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c70_12_ff, NULL, 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ op_0c78_12_ff, NULL, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c79_12_ff, NULL, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0c80_12_ff, NULL, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c90_12_ff, NULL, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0c98_12_ff, NULL, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca0_12_ff, NULL, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ op_0ca8_12_ff, NULL, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb0_12_ff, NULL, 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ op_0cb8_12_ff, NULL, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ op_0cb9_12_ff, NULL, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ op_1000_12_ff, NULL, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1010_12_ff, NULL, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1018_12_ff, NULL, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1020_12_ff, NULL, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1028_12_ff, NULL, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1030_12_ff, NULL, 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1038_12_ff, NULL, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1039_12_ff, NULL, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_103a_12_ff, NULL, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_103b_12_ff, NULL, 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_103c_12_ff, NULL, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1080_12_ff, NULL, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1090_12_ff, NULL, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1098_12_ff, NULL, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a0_12_ff, NULL, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10a8_12_ff, NULL, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b0_12_ff, NULL, 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10b8_12_ff, NULL, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10b9_12_ff, NULL, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10ba_12_ff, NULL, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10bb_12_ff, NULL, 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10bc_12_ff, NULL, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10c0_12_ff, NULL, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d0_12_ff, NULL, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10d8_12_ff, NULL, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e0_12_ff, NULL, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_10e8_12_ff, NULL, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f0_12_ff, NULL, 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10f8_12_ff, NULL, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10f9_12_ff, NULL, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_10fa_12_ff, NULL, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_10fb_12_ff, NULL, 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_10fc_12_ff, NULL, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1100_12_ff, NULL, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1110_12_ff, NULL, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1118_12_ff, NULL, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1120_12_ff, NULL, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_1128_12_ff, NULL, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1130_12_ff, NULL, 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1138_12_ff, NULL, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1139_12_ff, NULL, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_113a_12_ff, NULL, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_113b_12_ff, NULL, 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_113c_12_ff, NULL, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1140_12_ff, NULL, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1150_12_ff, NULL, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1158_12_ff, NULL, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1160_12_ff, NULL, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_1168_12_ff, NULL, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1170_12_ff, NULL, 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_1178_12_ff, NULL, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1179_12_ff, NULL, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_117a_12_ff, NULL, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_117b_12_ff, NULL, 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_117c_12_ff, NULL, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_1180_12_ff, NULL, 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1190_12_ff, NULL, 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_1198_12_ff, NULL, 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a0_12_ff, NULL, 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_11a8_12_ff, NULL, 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b0_12_ff, NULL, 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11b8_12_ff, NULL, 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11b9_12_ff, NULL, 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_11ba_12_ff, NULL, 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11bb_12_ff, NULL, 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_11bc_12_ff, NULL, 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_11c0_12_ff, NULL, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d0_12_ff, NULL, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11d8_12_ff, NULL, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e0_12_ff, NULL, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_11e8_12_ff, NULL, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f0_12_ff, NULL, 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11f8_12_ff, NULL, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11f9_12_ff, NULL, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_11fa_12_ff, NULL, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_11fb_12_ff, NULL, 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_11fc_12_ff, NULL, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13c0_12_ff, NULL, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d0_12_ff, NULL, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13d8_12_ff, NULL, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e0_12_ff, NULL, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_13e8_12_ff, NULL, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f0_12_ff, NULL, 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13f8_12_ff, NULL, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13f9_12_ff, NULL, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_13fa_12_ff, NULL, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_13fb_12_ff, NULL, 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_13fc_12_ff, NULL, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2000_12_ff, NULL, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2008_12_ff, NULL, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2010_12_ff, NULL, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2018_12_ff, NULL, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2020_12_ff, NULL, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2028_12_ff, NULL, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2030_12_ff, NULL, 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2038_12_ff, NULL, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2039_12_ff, NULL, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_203a_12_ff, NULL, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_203b_12_ff, NULL, 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_203c_12_ff, NULL, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2040_12_ff, NULL, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2048_12_ff, NULL, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2050_12_ff, NULL, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2058_12_ff, NULL, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2060_12_ff, NULL, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_2068_12_ff, NULL, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2070_12_ff, NULL, 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_2078_12_ff, NULL, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_2079_12_ff, NULL, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_207a_12_ff, NULL, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_207b_12_ff, NULL, 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_207c_12_ff, NULL, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_2080_12_ff, NULL, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2088_12_ff, NULL, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2090_12_ff, NULL, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2098_12_ff, NULL, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a0_12_ff, NULL, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20a8_12_ff, NULL, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b0_12_ff, NULL, 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20b8_12_ff, NULL, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20b9_12_ff, NULL, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20ba_12_ff, NULL, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20bb_12_ff, NULL, 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20bc_12_ff, NULL, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20c0_12_ff, NULL, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20c8_12_ff, NULL, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d0_12_ff, NULL, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20d8_12_ff, NULL, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e0_12_ff, NULL, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_20e8_12_ff, NULL, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f0_12_ff, NULL, 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20f8_12_ff, NULL, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20f9_12_ff, NULL, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_20fa_12_ff, NULL, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_20fb_12_ff, NULL, 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_20fc_12_ff, NULL, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2100_12_ff, NULL, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2108_12_ff, NULL, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2110_12_ff, NULL, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2118_12_ff, NULL, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2120_12_ff, NULL, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_2128_12_ff, NULL, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2130_12_ff, NULL, 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2138_12_ff, NULL, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2139_12_ff, NULL, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_213a_12_ff, NULL, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_213b_12_ff, NULL, 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_213c_12_ff, NULL, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2140_12_ff, NULL, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2148_12_ff, NULL, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2150_12_ff, NULL, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2158_12_ff, NULL, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2160_12_ff, NULL, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_2168_12_ff, NULL, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2170_12_ff, NULL, 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_2178_12_ff, NULL, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_2179_12_ff, NULL, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_217a_12_ff, NULL, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_217b_12_ff, NULL, 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_217c_12_ff, NULL, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_2180_12_ff, NULL, 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2188_12_ff, NULL, 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2190_12_ff, NULL, 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_2198_12_ff, NULL, 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a0_12_ff, NULL, 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_21a8_12_ff, NULL, 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b0_12_ff, NULL, 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21b8_12_ff, NULL, 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21b9_12_ff, NULL, 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21ba_12_ff, NULL, 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_21bb_12_ff, NULL, 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_21bc_12_ff, NULL, 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_21c0_12_ff, NULL, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21c8_12_ff, NULL, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d0_12_ff, NULL, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21d8_12_ff, NULL, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e0_12_ff, NULL, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_21e8_12_ff, NULL, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f0_12_ff, NULL, 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21f8_12_ff, NULL, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21f9_12_ff, NULL, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_21fa_12_ff, NULL, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_21fb_12_ff, NULL, 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_21fc_12_ff, NULL, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23c0_12_ff, NULL, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23c8_12_ff, NULL, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d0_12_ff, NULL, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23d8_12_ff, NULL, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e0_12_ff, NULL, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_23e8_12_ff, NULL, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f0_12_ff, NULL, 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23f8_12_ff, NULL, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23f9_12_ff, NULL, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_23fa_12_ff, NULL, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_23fb_12_ff, NULL, 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_23fc_12_ff, NULL, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_3000_12_ff, NULL, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3008_12_ff, NULL, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3010_12_ff, NULL, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3018_12_ff, NULL, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3020_12_ff, NULL, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3028_12_ff, NULL, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3030_12_ff, NULL, 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3038_12_ff, NULL, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3039_12_ff, NULL, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_303a_12_ff, NULL, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_303b_12_ff, NULL, 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_303c_12_ff, NULL, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3040_12_ff, NULL, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3048_12_ff, NULL, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3050_12_ff, NULL, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3058_12_ff, NULL, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3060_12_ff, NULL, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ op_3068_12_ff, NULL, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3070_12_ff, NULL, 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_3078_12_ff, NULL, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3079_12_ff, NULL, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ op_307a_12_ff, NULL, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_307b_12_ff, NULL, 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ op_307c_12_ff, NULL, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ op_3080_12_ff, NULL, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3088_12_ff, NULL, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3090_12_ff, NULL, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3098_12_ff, NULL, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a0_12_ff, NULL, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30a8_12_ff, NULL, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b0_12_ff, NULL, 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30b8_12_ff, NULL, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30b9_12_ff, NULL, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30ba_12_ff, NULL, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30bb_12_ff, NULL, 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30bc_12_ff, NULL, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30c0_12_ff, NULL, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30c8_12_ff, NULL, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d0_12_ff, NULL, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30d8_12_ff, NULL, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e0_12_ff, NULL, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_30e8_12_ff, NULL, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f0_12_ff, NULL, 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30f8_12_ff, NULL, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30f9_12_ff, NULL, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_30fa_12_ff, NULL, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_30fb_12_ff, NULL, 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_30fc_12_ff, NULL, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3100_12_ff, NULL, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3108_12_ff, NULL, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3110_12_ff, NULL, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3118_12_ff, NULL, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3120_12_ff, NULL, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_3128_12_ff, NULL, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3130_12_ff, NULL, 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3138_12_ff, NULL, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3139_12_ff, NULL, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_313a_12_ff, NULL, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_313b_12_ff, NULL, 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_313c_12_ff, NULL, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3140_12_ff, NULL, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3148_12_ff, NULL, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3150_12_ff, NULL, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3158_12_ff, NULL, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3160_12_ff, NULL, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_3168_12_ff, NULL, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3170_12_ff, NULL, 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_3178_12_ff, NULL, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3179_12_ff, NULL, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_317a_12_ff, NULL, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_317b_12_ff, NULL, 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_317c_12_ff, NULL, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_3180_12_ff, NULL, 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3188_12_ff, NULL, 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3190_12_ff, NULL, 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_3198_12_ff, NULL, 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a0_12_ff, NULL, 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ op_31a8_12_ff, NULL, 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b0_12_ff, NULL, 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31b8_12_ff, NULL, 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31b9_12_ff, NULL, 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ op_31ba_12_ff, NULL, 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31bb_12_ff, NULL, 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ op_31bc_12_ff, NULL, 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ op_31c0_12_ff, NULL, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31c8_12_ff, NULL, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d0_12_ff, NULL, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31d8_12_ff, NULL, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e0_12_ff, NULL, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ op_31e8_12_ff, NULL, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f0_12_ff, NULL, 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31f8_12_ff, NULL, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31f9_12_ff, NULL, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_31fa_12_ff, NULL, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_31fb_12_ff, NULL, 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ op_31fc_12_ff, NULL, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c0_12_ff, NULL, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33c8_12_ff, NULL, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d0_12_ff, NULL, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33d8_12_ff, NULL, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e0_12_ff, NULL, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ op_33e8_12_ff, NULL, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f0_12_ff, NULL, 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33f8_12_ff, NULL, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33f9_12_ff, NULL, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ op_33fa_12_ff, NULL, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_33fb_12_ff, NULL, 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ op_33fc_12_ff, NULL, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ op_4000_12_ff, NULL, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4010_12_ff, NULL, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4018_12_ff, NULL, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4020_12_ff, NULL, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4028_12_ff, NULL, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4030_12_ff, NULL, 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4038_12_ff, NULL, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4039_12_ff, NULL, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4040_12_ff, NULL, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4050_12_ff, NULL, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4058_12_ff, NULL, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4060_12_ff, NULL, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4068_12_ff, NULL, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4070_12_ff, NULL, 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_4078_12_ff, NULL, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_4079_12_ff, NULL, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_4080_12_ff, NULL, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4090_12_ff, NULL, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_4098_12_ff, NULL, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a0_12_ff, NULL, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ op_40a8_12_ff, NULL, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b0_12_ff, NULL, 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ op_40b8_12_ff, NULL, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ op_40b9_12_ff, NULL, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ op_40c0_12_ff, NULL, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d0_12_ff, NULL, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40d8_12_ff, NULL, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e0_12_ff, NULL, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40e8_12_ff, NULL, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f0_12_ff, NULL, 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ op_40f8_12_ff, NULL, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ op_40f9_12_ff, NULL, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ op_4180_12_ff, NULL, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4190_12_ff, NULL, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ op_4198_12_ff, NULL, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a0_12_ff, NULL, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ op_41a8_12_ff, NULL, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b0_12_ff, NULL, 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41b8_12_ff, NULL, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41b9_12_ff, NULL, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ op_41ba_12_ff, NULL, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41bb_12_ff, NULL, 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ op_41bc_12_ff, NULL, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ op_41d0_12_ff, NULL, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ op_41e8_12_ff, NULL, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f0_12_ff, NULL, 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ op_41f8_12_ff, NULL, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41f9_12_ff, NULL, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ op_41fa_12_ff, NULL, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ op_41fb_12_ff, NULL, 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ op_4200_12_ff, NULL, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4210_12_ff, NULL, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4218_12_ff, NULL, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4220_12_ff, NULL, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4228_12_ff, NULL, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4230_12_ff, NULL, 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4238_12_ff, NULL, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4239_12_ff, NULL, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4240_12_ff, NULL, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4250_12_ff, NULL, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4258_12_ff, NULL, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4260_12_ff, NULL, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4268_12_ff, NULL, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4270_12_ff, NULL, 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ op_4278_12_ff, NULL, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ op_4279_12_ff, NULL, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4280_12_ff, NULL, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4290_12_ff, NULL, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ op_4298_12_ff, NULL, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a0_12_ff, NULL, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ op_42a8_12_ff, NULL, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b0_12_ff, NULL, 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ op_42b8_12_ff, NULL, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ op_42b9_12_ff, NULL, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ op_4400_12_ff, NULL, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4410_12_ff, NULL, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4418_12_ff, NULL, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4420_12_ff, NULL, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4428_12_ff, NULL, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4430_12_ff, NULL, 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4438_12_ff, NULL, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4439_12_ff, NULL, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4440_12_ff, NULL, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4450_12_ff, NULL, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4458_12_ff, NULL, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4460_12_ff, NULL, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4468_12_ff, NULL, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4470_12_ff, NULL, 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ op_4478_12_ff, NULL, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ op_4479_12_ff, NULL, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ op_4480_12_ff, NULL, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4490_12_ff, NULL, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ op_4498_12_ff, NULL, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a0_12_ff, NULL, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ op_44a8_12_ff, NULL, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b0_12_ff, NULL, 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ op_44b8_12_ff, NULL, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ op_44b9_12_ff, NULL, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ op_44c0_12_ff, NULL, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d0_12_ff, NULL, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44d8_12_ff, NULL, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e0_12_ff, NULL, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_44e8_12_ff, NULL, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f0_12_ff, NULL, 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44f8_12_ff, NULL, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44f9_12_ff, NULL, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fa_12_ff, NULL, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_44fb_12_ff, NULL, 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_44fc_12_ff, NULL, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4600_12_ff, NULL, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4610_12_ff, NULL, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4618_12_ff, NULL, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4620_12_ff, NULL, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4628_12_ff, NULL, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4630_12_ff, NULL, 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4638_12_ff, NULL, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4639_12_ff, NULL, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4640_12_ff, NULL, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4650_12_ff, NULL, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4658_12_ff, NULL, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4660_12_ff, NULL, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4668_12_ff, NULL, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4670_12_ff, NULL, 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ op_4678_12_ff, NULL, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ op_4679_12_ff, NULL, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ op_4680_12_ff, NULL, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4690_12_ff, NULL, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ op_4698_12_ff, NULL, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a0_12_ff, NULL, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ op_46a8_12_ff, NULL, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b0_12_ff, NULL, 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ op_46b8_12_ff, NULL, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ op_46b9_12_ff, NULL, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ op_46c0_12_ff, NULL, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d0_12_ff, NULL, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46d8_12_ff, NULL, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e0_12_ff, NULL, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ op_46e8_12_ff, NULL, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f0_12_ff, NULL, 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46f8_12_ff, NULL, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46f9_12_ff, NULL, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fa_12_ff, NULL, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_46fb_12_ff, NULL, 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ op_46fc_12_ff, NULL, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ op_4800_12_ff, NULL, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4810_12_ff, NULL, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4818_12_ff, NULL, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4820_12_ff, NULL, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ op_4828_12_ff, NULL, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4830_12_ff, NULL, 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ op_4838_12_ff, NULL, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ op_4839_12_ff, NULL, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ op_4840_12_ff, NULL, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ op_4850_12_ff, NULL, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ op_4868_12_ff, NULL, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4870_12_ff, NULL, 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4878_12_ff, NULL, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ op_4879_12_ff, NULL, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ op_487a_12_ff, NULL, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ op_487b_12_ff, NULL, 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ op_4880_12_ff, NULL, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ op_4890_12_ff, NULL, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a0_12_ff, NULL, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48a8_12_ff, NULL, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b0_12_ff, NULL, 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48b8_12_ff, NULL, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48b9_12_ff, NULL, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_48c0_12_ff, NULL, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ op_48d0_12_ff, NULL, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e0_12_ff, NULL, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ op_48e8_12_ff, NULL, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f0_12_ff, NULL, 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ op_48f8_12_ff, NULL, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ op_48f9_12_ff, NULL, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ op_4a00_12_ff, NULL, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a10_12_ff, NULL, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a18_12_ff, NULL, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a20_12_ff, NULL, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a28_12_ff, NULL, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a30_12_ff, NULL, 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a38_12_ff, NULL, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a39_12_ff, NULL, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a40_12_ff, NULL, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a50_12_ff, NULL, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a58_12_ff, NULL, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a60_12_ff, NULL, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a68_12_ff, NULL, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a70_12_ff, NULL, 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ op_4a78_12_ff, NULL, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ op_4a79_12_ff, NULL, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ op_4a80_12_ff, NULL, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a90_12_ff, NULL, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ op_4a98_12_ff, NULL, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa0_12_ff, NULL, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ op_4aa8_12_ff, NULL, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab0_12_ff, NULL, 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ op_4ab8_12_ff, NULL, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ op_4ab9_12_ff, NULL, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ op_4ac0_12_ff, NULL, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad0_12_ff, NULL, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ad8_12_ff, NULL, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae0_12_ff, NULL, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ op_4ae8_12_ff, NULL, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af0_12_ff, NULL, 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ op_4af8_12_ff, NULL, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ op_4af9_12_ff, NULL, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ op_4c90_12_ff, NULL, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4c98_12_ff, NULL, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ca8_12_ff, NULL, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb0_12_ff, NULL, 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cb8_12_ff, NULL, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cb9_12_ff, NULL, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cba_12_ff, NULL, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cbb_12_ff, NULL, 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cd0_12_ff, NULL, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cd8_12_ff, NULL, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ op_4ce8_12_ff, NULL, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf0_12_ff, NULL, 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4cf8_12_ff, NULL, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cf9_12_ff, NULL, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfa_12_ff, NULL, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ op_4cfb_12_ff, NULL, 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ op_4e40_11_ff, NULL, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ op_4e50_12_ff, NULL, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ op_4e58_12_ff, NULL, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ op_4e60_12_ff, NULL, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ op_4e68_12_ff, NULL, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ op_4e70_12_ff, NULL, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ op_4e71_12_ff, NULL, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ op_4e72_12_ff, NULL, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ op_4e73_12_ff, NULL, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ op_4e75_12_ff, NULL, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ op_4e76_12_ff, NULL, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ op_4e77_12_ff, NULL, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ op_4e90_12_ff, NULL, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ op_4ea8_12_ff, NULL, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb0_12_ff, NULL, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4eb8_12_ff, NULL, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4eb9_12_ff, NULL, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ op_4eba_12_ff, NULL, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ op_4ebb_12_ff, NULL, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ op_4ed0_12_ff, NULL, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ op_4ee8_12_ff, NULL, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef0_12_ff, NULL, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ op_4ef8_12_ff, NULL, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4ef9_12_ff, NULL, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ op_4efa_12_ff, NULL, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ op_4efb_12_ff, NULL, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ op_5000_12_ff, NULL, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5010_12_ff, NULL, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5018_12_ff, NULL, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5020_12_ff, NULL, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5028_12_ff, NULL, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5030_12_ff, NULL, 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5038_12_ff, NULL, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5039_12_ff, NULL, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5040_12_ff, NULL, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5048_12_ff, NULL, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5050_12_ff, NULL, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5058_12_ff, NULL, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5060_12_ff, NULL, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5068_12_ff, NULL, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5070_12_ff, NULL, 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_5078_12_ff, NULL, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_5079_12_ff, NULL, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_5080_12_ff, NULL, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5088_12_ff, NULL, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_5090_12_ff, NULL, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_5098_12_ff, NULL, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a0_12_ff, NULL, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_50a8_12_ff, NULL, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b0_12_ff, NULL, 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_50b8_12_ff, NULL, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_50b9_12_ff, NULL, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_50c0_12_ff, NULL, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50c8_12_ff, NULL, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_50d0_12_ff, NULL, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50d8_12_ff, NULL, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e0_12_ff, NULL, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_50e8_12_ff, NULL, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f0_12_ff, NULL, 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_50f8_12_ff, NULL, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_50f9_12_ff, NULL, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5100_12_ff, NULL, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5110_12_ff, NULL, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5118_12_ff, NULL, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5120_12_ff, NULL, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5128_12_ff, NULL, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5130_12_ff, NULL, 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5138_12_ff, NULL, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5139_12_ff, NULL, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5140_12_ff, NULL, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5148_12_ff, NULL, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5150_12_ff, NULL, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5158_12_ff, NULL, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5160_12_ff, NULL, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5168_12_ff, NULL, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5170_12_ff, NULL, 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_5178_12_ff, NULL, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_5179_12_ff, NULL, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_5180_12_ff, NULL, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5188_12_ff, NULL, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_5190_12_ff, NULL, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_5198_12_ff, NULL, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a0_12_ff, NULL, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_51a8_12_ff, NULL, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b0_12_ff, NULL, 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_51b8_12_ff, NULL, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_51b9_12_ff, NULL, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_51c0_12_ff, NULL, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51c8_12_ff, NULL, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_51d0_12_ff, NULL, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51d8_12_ff, NULL, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e0_12_ff, NULL, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_51e8_12_ff, NULL, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f0_12_ff, NULL, 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_51f8_12_ff, NULL, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_51f9_12_ff, NULL, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_52c0_12_ff, NULL, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52c8_12_ff, NULL, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_52d0_12_ff, NULL, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52d8_12_ff, NULL, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e0_12_ff, NULL, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_52e8_12_ff, NULL, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f0_12_ff, NULL, 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_52f8_12_ff, NULL, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_52f9_12_ff, NULL, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_53c0_12_ff, NULL, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53c8_12_ff, NULL, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_53d0_12_ff, NULL, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53d8_12_ff, NULL, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e0_12_ff, NULL, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_53e8_12_ff, NULL, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f0_12_ff, NULL, 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_53f8_12_ff, NULL, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_53f9_12_ff, NULL, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_54c0_12_ff, NULL, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54c8_12_ff, NULL, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_54d0_12_ff, NULL, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54d8_12_ff, NULL, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e0_12_ff, NULL, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_54e8_12_ff, NULL, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f0_12_ff, NULL, 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_54f8_12_ff, NULL, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_54f9_12_ff, NULL, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_55c0_12_ff, NULL, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55c8_12_ff, NULL, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_55d0_12_ff, NULL, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55d8_12_ff, NULL, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e0_12_ff, NULL, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_55e8_12_ff, NULL, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f0_12_ff, NULL, 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_55f8_12_ff, NULL, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_55f9_12_ff, NULL, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_56c0_12_ff, NULL, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56c8_12_ff, NULL, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_56d0_12_ff, NULL, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56d8_12_ff, NULL, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e0_12_ff, NULL, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_56e8_12_ff, NULL, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f0_12_ff, NULL, 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_56f8_12_ff, NULL, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_56f9_12_ff, NULL, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_57c0_12_ff, NULL, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57c8_12_ff, NULL, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_57d0_12_ff, NULL, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57d8_12_ff, NULL, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e0_12_ff, NULL, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_57e8_12_ff, NULL, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f0_12_ff, NULL, 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_57f8_12_ff, NULL, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_57f9_12_ff, NULL, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_58c0_12_ff, NULL, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58c8_12_ff, NULL, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_58d0_12_ff, NULL, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58d8_12_ff, NULL, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e0_12_ff, NULL, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_58e8_12_ff, NULL, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f0_12_ff, NULL, 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_58f8_12_ff, NULL, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_58f9_12_ff, NULL, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_59c0_12_ff, NULL, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59c8_12_ff, NULL, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_59d0_12_ff, NULL, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59d8_12_ff, NULL, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e0_12_ff, NULL, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_59e8_12_ff, NULL, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f0_12_ff, NULL, 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_59f8_12_ff, NULL, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_59f9_12_ff, NULL, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ac0_12_ff, NULL, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ac8_12_ff, NULL, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ad0_12_ff, NULL, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ad8_12_ff, NULL, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae0_12_ff, NULL, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ae8_12_ff, NULL, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af0_12_ff, NULL, 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5af8_12_ff, NULL, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5af9_12_ff, NULL, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5bc0_12_ff, NULL, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bc8_12_ff, NULL, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5bd0_12_ff, NULL, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5bd8_12_ff, NULL, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be0_12_ff, NULL, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5be8_12_ff, NULL, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf0_12_ff, NULL, 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5bf8_12_ff, NULL, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5bf9_12_ff, NULL, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5cc0_12_ff, NULL, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cc8_12_ff, NULL, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5cd0_12_ff, NULL, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5cd8_12_ff, NULL, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce0_12_ff, NULL, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ce8_12_ff, NULL, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf0_12_ff, NULL, 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5cf8_12_ff, NULL, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5cf9_12_ff, NULL, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5dc0_12_ff, NULL, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dc8_12_ff, NULL, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5dd0_12_ff, NULL, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5dd8_12_ff, NULL, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de0_12_ff, NULL, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5de8_12_ff, NULL, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df0_12_ff, NULL, 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5df8_12_ff, NULL, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5df9_12_ff, NULL, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5ec0_12_ff, NULL, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ec8_12_ff, NULL, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5ed0_12_ff, NULL, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ed8_12_ff, NULL, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee0_12_ff, NULL, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5ee8_12_ff, NULL, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef0_12_ff, NULL, 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ef8_12_ff, NULL, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ef9_12_ff, NULL, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_5fc0_12_ff, NULL, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fc8_12_ff, NULL, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ op_5fd0_12_ff, NULL, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fd8_12_ff, NULL, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe0_12_ff, NULL, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ op_5fe8_12_ff, NULL, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff0_12_ff, NULL, 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ op_5ff8_12_ff, NULL, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ op_5ff9_12_ff, NULL, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ op_6000_12_ff, NULL, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6001_12_ff, NULL, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_60ff_12_ff, NULL, 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6100_12_ff, NULL, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ op_6101_12_ff, NULL, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ op_61ff_12_ff, NULL, 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ op_6200_12_ff, NULL, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6201_12_ff, NULL, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_62ff_12_ff, NULL, 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6300_12_ff, NULL, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6301_12_ff, NULL, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_63ff_12_ff, NULL, 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6400_12_ff, NULL, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6401_12_ff, NULL, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_64ff_12_ff, NULL, 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6500_12_ff, NULL, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6501_12_ff, NULL, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_65ff_12_ff, NULL, 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6600_12_ff, NULL, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6601_12_ff, NULL, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_66ff_12_ff, NULL, 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6700_12_ff, NULL, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6701_12_ff, NULL, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_67ff_12_ff, NULL, 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6800_12_ff, NULL, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6801_12_ff, NULL, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_68ff_12_ff, NULL, 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6900_12_ff, NULL, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6901_12_ff, NULL, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_69ff_12_ff, NULL, 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6a00_12_ff, NULL, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6a01_12_ff, NULL, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6aff_12_ff, NULL, 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6b00_12_ff, NULL, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6b01_12_ff, NULL, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6bff_12_ff, NULL, 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6c00_12_ff, NULL, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6c01_12_ff, NULL, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6cff_12_ff, NULL, 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6d00_12_ff, NULL, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6d01_12_ff, NULL, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6dff_12_ff, NULL, 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6e00_12_ff, NULL, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6e01_12_ff, NULL, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6eff_12_ff, NULL, 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_6f00_12_ff, NULL, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ op_6f01_12_ff, NULL, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ op_6fff_12_ff, NULL, 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ op_7000_12_ff, NULL, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ op_8000_12_ff, NULL, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ op_8010_12_ff, NULL, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ op_8018_12_ff, NULL, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ op_8020_12_ff, NULL, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ op_8028_12_ff, NULL, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ op_8030_12_ff, NULL, 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ op_8038_12_ff, NULL, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ op_8039_12_ff, NULL, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ op_803a_12_ff, NULL, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ op_803b_12_ff, NULL, 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ op_803c_12_ff, NULL, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8040_12_ff, NULL, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ op_8050_12_ff, NULL, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ op_8058_12_ff, NULL, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ op_8060_12_ff, NULL, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ op_8068_12_ff, NULL, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ op_8070_12_ff, NULL, 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ op_8078_12_ff, NULL, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ op_8079_12_ff, NULL, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ op_807a_12_ff, NULL, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ op_807b_12_ff, NULL, 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ op_807c_12_ff, NULL, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ op_8080_12_ff, NULL, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ op_8090_12_ff, NULL, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ op_8098_12_ff, NULL, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a0_12_ff, NULL, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_80a8_12_ff, NULL, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b0_12_ff, NULL, 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_80b8_12_ff, NULL, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_80b9_12_ff, NULL, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_80ba_12_ff, NULL, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ op_80bb_12_ff, NULL, 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ op_80bc_12_ff, NULL, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ op_80c0_12_ff, NULL, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d0_12_ff, NULL, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80d8_12_ff, NULL, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e0_12_ff, NULL, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ op_80e8_12_ff, NULL, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f0_12_ff, NULL, 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80f8_12_ff, NULL, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80f9_12_ff, NULL, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ op_80fa_12_ff, NULL, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_80fb_12_ff, NULL, 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ op_80fc_12_ff, NULL, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ op_8100_12_ff, NULL, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8108_12_ff, NULL, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ op_8110_12_ff, NULL, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ op_8118_12_ff, NULL, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ op_8120_12_ff, NULL, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ op_8128_12_ff, NULL, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ op_8130_12_ff, NULL, 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ op_8138_12_ff, NULL, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ op_8139_12_ff, NULL, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ op_8150_12_ff, NULL, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ op_8158_12_ff, NULL, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ op_8160_12_ff, NULL, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ op_8168_12_ff, NULL, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ op_8170_12_ff, NULL, 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ op_8178_12_ff, NULL, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ op_8179_12_ff, NULL, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ op_8190_12_ff, NULL, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ op_8198_12_ff, NULL, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a0_12_ff, NULL, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ op_81a8_12_ff, NULL, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b0_12_ff, NULL, 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ op_81b8_12_ff, NULL, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ op_81b9_12_ff, NULL, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ op_81c0_12_ff, NULL, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d0_12_ff, NULL, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81d8_12_ff, NULL, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e0_12_ff, NULL, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ op_81e8_12_ff, NULL, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f0_12_ff, NULL, 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81f8_12_ff, NULL, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81f9_12_ff, NULL, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ op_81fa_12_ff, NULL, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_81fb_12_ff, NULL, 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ op_81fc_12_ff, NULL, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ op_9000_12_ff, NULL, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9010_12_ff, NULL, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9018_12_ff, NULL, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9020_12_ff, NULL, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9028_12_ff, NULL, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9030_12_ff, NULL, 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9038_12_ff, NULL, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9039_12_ff, NULL, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ op_903a_12_ff, NULL, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_903b_12_ff, NULL, 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_903c_12_ff, NULL, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9040_12_ff, NULL, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9048_12_ff, NULL, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9050_12_ff, NULL, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9058_12_ff, NULL, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9060_12_ff, NULL, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9068_12_ff, NULL, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9070_12_ff, NULL, 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9078_12_ff, NULL, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9079_12_ff, NULL, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ op_907a_12_ff, NULL, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ op_907b_12_ff, NULL, 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ op_907c_12_ff, NULL, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9080_12_ff, NULL, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9088_12_ff, NULL, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9090_12_ff, NULL, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9098_12_ff, NULL, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a0_12_ff, NULL, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_90a8_12_ff, NULL, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b0_12_ff, NULL, 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90b8_12_ff, NULL, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90b9_12_ff, NULL, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90ba_12_ff, NULL, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ op_90bb_12_ff, NULL, 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ op_90bc_12_ff, NULL, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ op_90c0_12_ff, NULL, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90c8_12_ff, NULL, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d0_12_ff, NULL, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90d8_12_ff, NULL, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e0_12_ff, NULL, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_90e8_12_ff, NULL, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f0_12_ff, NULL, 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90f8_12_ff, NULL, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90f9_12_ff, NULL, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_90fa_12_ff, NULL, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_90fb_12_ff, NULL, 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_90fc_12_ff, NULL, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_9100_12_ff, NULL, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9108_12_ff, NULL, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9110_12_ff, NULL, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9118_12_ff, NULL, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9120_12_ff, NULL, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9128_12_ff, NULL, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9130_12_ff, NULL, 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9138_12_ff, NULL, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9139_12_ff, NULL, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9140_12_ff, NULL, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9148_12_ff, NULL, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9150_12_ff, NULL, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9158_12_ff, NULL, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9160_12_ff, NULL, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9168_12_ff, NULL, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9170_12_ff, NULL, 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ op_9178_12_ff, NULL, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ op_9179_12_ff, NULL, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ op_9180_12_ff, NULL, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9188_12_ff, NULL, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ op_9190_12_ff, NULL, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ op_9198_12_ff, NULL, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a0_12_ff, NULL, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ op_91a8_12_ff, NULL, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b0_12_ff, NULL, 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ op_91b8_12_ff, NULL, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ op_91b9_12_ff, NULL, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ op_91c0_12_ff, NULL, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91c8_12_ff, NULL, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d0_12_ff, NULL, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91d8_12_ff, NULL, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e0_12_ff, NULL, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ op_91e8_12_ff, NULL, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f0_12_ff, NULL, 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91f8_12_ff, NULL, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91f9_12_ff, NULL, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_91fa_12_ff, NULL, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ op_91fb_12_ff, NULL, 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ op_91fc_12_ff, NULL, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ op_b000_12_ff, NULL, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b010_12_ff, NULL, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b018_12_ff, NULL, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b020_12_ff, NULL, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b028_12_ff, NULL, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b030_12_ff, NULL, 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b038_12_ff, NULL, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b039_12_ff, NULL, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b03a_12_ff, NULL, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b03b_12_ff, NULL, 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b03c_12_ff, NULL, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b040_12_ff, NULL, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b048_12_ff, NULL, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b050_12_ff, NULL, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b058_12_ff, NULL, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b060_12_ff, NULL, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b068_12_ff, NULL, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b070_12_ff, NULL, 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b078_12_ff, NULL, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b079_12_ff, NULL, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b07a_12_ff, NULL, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b07b_12_ff, NULL, 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b07c_12_ff, NULL, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b080_12_ff, NULL, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b088_12_ff, NULL, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b090_12_ff, NULL, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b098_12_ff, NULL, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a0_12_ff, NULL, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ op_b0a8_12_ff, NULL, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b0_12_ff, NULL, 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0b8_12_ff, NULL, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0b9_12_ff, NULL, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0ba_12_ff, NULL, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ op_b0bb_12_ff, NULL, 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ op_b0bc_12_ff, NULL, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ op_b0c0_12_ff, NULL, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0c8_12_ff, NULL, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d0_12_ff, NULL, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0d8_12_ff, NULL, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e0_12_ff, NULL, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b0e8_12_ff, NULL, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f0_12_ff, NULL, 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0f8_12_ff, NULL, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0f9_12_ff, NULL, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fa_12_ff, NULL, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b0fb_12_ff, NULL, 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b0fc_12_ff, NULL, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b100_12_ff, NULL, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b108_12_ff, NULL, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b110_12_ff, NULL, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b118_12_ff, NULL, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b120_12_ff, NULL, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b128_12_ff, NULL, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b130_12_ff, NULL, 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b138_12_ff, NULL, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b139_12_ff, NULL, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b140_12_ff, NULL, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b148_12_ff, NULL, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b150_12_ff, NULL, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b158_12_ff, NULL, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b160_12_ff, NULL, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b168_12_ff, NULL, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b170_12_ff, NULL, 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b178_12_ff, NULL, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b179_12_ff, NULL, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b180_12_ff, NULL, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b188_12_ff, NULL, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ op_b190_12_ff, NULL, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b198_12_ff, NULL, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a0_12_ff, NULL, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ op_b1a8_12_ff, NULL, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b0_12_ff, NULL, 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ op_b1b8_12_ff, NULL, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ op_b1b9_12_ff, NULL, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ op_b1c0_12_ff, NULL, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1c8_12_ff, NULL, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d0_12_ff, NULL, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1d8_12_ff, NULL, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e0_12_ff, NULL, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ op_b1e8_12_ff, NULL, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f0_12_ff, NULL, 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1f8_12_ff, NULL, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1f9_12_ff, NULL, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fa_12_ff, NULL, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ op_b1fb_12_ff, NULL, 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ op_b1fc_12_ff, NULL, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ op_c000_12_ff, NULL, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ op_c010_12_ff, NULL, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ op_c018_12_ff, NULL, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ op_c020_12_ff, NULL, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ op_c028_12_ff, NULL, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ op_c030_12_ff, NULL, 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ op_c038_12_ff, NULL, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ op_c039_12_ff, NULL, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ op_c03a_12_ff, NULL, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c03b_12_ff, NULL, 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c03c_12_ff, NULL, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c040_12_ff, NULL, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ op_c050_12_ff, NULL, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ op_c058_12_ff, NULL, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ op_c060_12_ff, NULL, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ op_c068_12_ff, NULL, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ op_c070_12_ff, NULL, 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ op_c078_12_ff, NULL, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ op_c079_12_ff, NULL, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ op_c07a_12_ff, NULL, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ op_c07b_12_ff, NULL, 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ op_c07c_12_ff, NULL, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ op_c080_12_ff, NULL, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ op_c090_12_ff, NULL, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ op_c098_12_ff, NULL, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a0_12_ff, NULL, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c0a8_12_ff, NULL, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b0_12_ff, NULL, 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0b8_12_ff, NULL, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0b9_12_ff, NULL, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0ba_12_ff, NULL, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ op_c0bb_12_ff, NULL, 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ op_c0bc_12_ff, NULL, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ op_c0c0_12_ff, NULL, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d0_12_ff, NULL, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0d8_12_ff, NULL, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e0_12_ff, NULL, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ op_c0e8_12_ff, NULL, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f0_12_ff, NULL, 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0f8_12_ff, NULL, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0f9_12_ff, NULL, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ op_c0fa_12_ff, NULL, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c0fb_12_ff, NULL, 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ op_c0fc_12_ff, NULL, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ op_c100_12_ff, NULL, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c108_12_ff, NULL, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ op_c110_12_ff, NULL, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ op_c118_12_ff, NULL, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ op_c120_12_ff, NULL, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ op_c128_12_ff, NULL, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ op_c130_12_ff, NULL, 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ op_c138_12_ff, NULL, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ op_c139_12_ff, NULL, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ op_c140_12_ff, NULL, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c148_12_ff, NULL, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c150_12_ff, NULL, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ op_c158_12_ff, NULL, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ op_c160_12_ff, NULL, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ op_c168_12_ff, NULL, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ op_c170_12_ff, NULL, 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ op_c178_12_ff, NULL, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ op_c179_12_ff, NULL, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ op_c188_12_ff, NULL, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ op_c190_12_ff, NULL, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ op_c198_12_ff, NULL, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a0_12_ff, NULL, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ op_c1a8_12_ff, NULL, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b0_12_ff, NULL, 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ op_c1b8_12_ff, NULL, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ op_c1b9_12_ff, NULL, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ op_c1c0_12_ff, NULL, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d0_12_ff, NULL, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1d8_12_ff, NULL, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e0_12_ff, NULL, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ op_c1e8_12_ff, NULL, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f0_12_ff, NULL, 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1f8_12_ff, NULL, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1f9_12_ff, NULL, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ op_c1fa_12_ff, NULL, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ op_c1fb_12_ff, NULL, 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ op_c1fc_12_ff, NULL, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ op_d000_12_ff, NULL, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d010_12_ff, NULL, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d018_12_ff, NULL, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d020_12_ff, NULL, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d028_12_ff, NULL, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d030_12_ff, NULL, 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d038_12_ff, NULL, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d039_12_ff, NULL, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d03a_12_ff, NULL, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d03b_12_ff, NULL, 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d03c_12_ff, NULL, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d040_12_ff, NULL, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d048_12_ff, NULL, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d050_12_ff, NULL, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d058_12_ff, NULL, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d060_12_ff, NULL, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d068_12_ff, NULL, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d070_12_ff, NULL, 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d078_12_ff, NULL, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d079_12_ff, NULL, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d07a_12_ff, NULL, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d07b_12_ff, NULL, 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d07c_12_ff, NULL, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d080_12_ff, NULL, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d088_12_ff, NULL, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d090_12_ff, NULL, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d098_12_ff, NULL, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a0_12_ff, NULL, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d0a8_12_ff, NULL, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b0_12_ff, NULL, 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0b8_12_ff, NULL, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0b9_12_ff, NULL, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0ba_12_ff, NULL, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d0bb_12_ff, NULL, 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d0bc_12_ff, NULL, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d0c0_12_ff, NULL, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0c8_12_ff, NULL, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d0_12_ff, NULL, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0d8_12_ff, NULL, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e0_12_ff, NULL, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d0e8_12_ff, NULL, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f0_12_ff, NULL, 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0f8_12_ff, NULL, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0f9_12_ff, NULL, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fa_12_ff, NULL, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d0fb_12_ff, NULL, 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d0fc_12_ff, NULL, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d100_12_ff, NULL, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d108_12_ff, NULL, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d110_12_ff, NULL, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d118_12_ff, NULL, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d120_12_ff, NULL, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d128_12_ff, NULL, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d130_12_ff, NULL, 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d138_12_ff, NULL, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d139_12_ff, NULL, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d140_12_ff, NULL, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d148_12_ff, NULL, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d150_12_ff, NULL, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d158_12_ff, NULL, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d160_12_ff, NULL, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d168_12_ff, NULL, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d170_12_ff, NULL, 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d178_12_ff, NULL, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d179_12_ff, NULL, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d180_12_ff, NULL, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d188_12_ff, NULL, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ op_d190_12_ff, NULL, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d198_12_ff, NULL, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a0_12_ff, NULL, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ op_d1a8_12_ff, NULL, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b0_12_ff, NULL, 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ op_d1b8_12_ff, NULL, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ op_d1b9_12_ff, NULL, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ op_d1c0_12_ff, NULL, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1c8_12_ff, NULL, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d0_12_ff, NULL, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1d8_12_ff, NULL, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e0_12_ff, NULL, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ op_d1e8_12_ff, NULL, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f0_12_ff, NULL, 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1f8_12_ff, NULL, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1f9_12_ff, NULL, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fa_12_ff, NULL, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ op_d1fb_12_ff, NULL, 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ op_d1fc_12_ff, NULL, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ op_e000_12_ff, NULL, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e008_12_ff, NULL, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e010_12_ff, NULL, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e018_12_ff, NULL, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e020_12_ff, NULL, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e028_12_ff, NULL, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e030_12_ff, NULL, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e038_12_ff, NULL, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e040_12_ff, NULL, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e048_12_ff, NULL, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e050_12_ff, NULL, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e058_12_ff, NULL, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e060_12_ff, NULL, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e068_12_ff, NULL, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e070_12_ff, NULL, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e078_12_ff, NULL, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e080_12_ff, NULL, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e088_12_ff, NULL, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e090_12_ff, NULL, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e098_12_ff, NULL, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0a0_12_ff, NULL, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ op_e0a8_12_ff, NULL, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ op_e0b0_12_ff, NULL, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ op_e0b8_12_ff, NULL, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ op_e0d0_12_ff, NULL, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0d8_12_ff, NULL, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e0_12_ff, NULL, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ op_e0e8_12_ff, NULL, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f0_12_ff, NULL, 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ op_e0f8_12_ff, NULL, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ op_e0f9_12_ff, NULL, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ op_e100_12_ff, NULL, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e108_12_ff, NULL, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e110_12_ff, NULL, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e118_12_ff, NULL, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e120_12_ff, NULL, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e128_12_ff, NULL, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e130_12_ff, NULL, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e138_12_ff, NULL, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e140_12_ff, NULL, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e148_12_ff, NULL, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e150_12_ff, NULL, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e158_12_ff, NULL, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e160_12_ff, NULL, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e168_12_ff, NULL, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e170_12_ff, NULL, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e178_12_ff, NULL, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e180_12_ff, NULL, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e188_12_ff, NULL, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e190_12_ff, NULL, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e198_12_ff, NULL, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1a0_12_ff, NULL, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ op_e1a8_12_ff, NULL, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ op_e1b0_12_ff, NULL, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ op_e1b8_12_ff, NULL, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ op_e1d0_12_ff, NULL, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1d8_12_ff, NULL, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e0_12_ff, NULL, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ op_e1e8_12_ff, NULL, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f0_12_ff, NULL, 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ op_e1f8_12_ff, NULL, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ op_e1f9_12_ff, NULL, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ op_e2d0_12_ff, NULL, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2d8_12_ff, NULL, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e0_12_ff, NULL, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ op_e2e8_12_ff, NULL, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f0_12_ff, NULL, 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ op_e2f8_12_ff, NULL, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ op_e2f9_12_ff, NULL, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ op_e3d0_12_ff, NULL, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3d8_12_ff, NULL, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e0_12_ff, NULL, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ op_e3e8_12_ff, NULL, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f0_12_ff, NULL, 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ op_e3f8_12_ff, NULL, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ op_e3f9_12_ff, NULL, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ op_e4d0_12_ff, NULL, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4d8_12_ff, NULL, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e0_12_ff, NULL, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4e8_12_ff, NULL, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f0_12_ff, NULL, 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ op_e4f8_12_ff, NULL, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ op_e4f9_12_ff, NULL, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ op_e5d0_12_ff, NULL, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5d8_12_ff, NULL, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e0_12_ff, NULL, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5e8_12_ff, NULL, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f0_12_ff, NULL, 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ op_e5f8_12_ff, NULL, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ op_e5f9_12_ff, NULL, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ op_e6d0_12_ff, NULL, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6d8_12_ff, NULL, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e0_12_ff, NULL, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ op_e6e8_12_ff, NULL, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f0_12_ff, NULL, 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ op_e6f8_12_ff, NULL, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ op_e6f9_12_ff, NULL, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ op_e7d0_12_ff, NULL, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7d8_12_ff, NULL, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e0_12_ff, NULL, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ op_e7e8_12_ff, NULL, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f0_12_ff, NULL, 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ op_e7f8_12_ff, NULL, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ op_e7f9_12_ff, NULL, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#ifdef CPUEMU_13
const struct cputbl op_smalltbl_13[] = {
{ NULL, op_0000_13_ff, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0010_13_ff, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0018_13_ff, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0020_13_ff, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0028_13_ff, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0030_13_ff, 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ NULL, op_0038_13_ff, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0039_13_ff, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_003c_13_ff, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ NULL, op_0040_13_ff, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0050_13_ff, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0058_13_ff, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0060_13_ff, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0068_13_ff, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0070_13_ff, 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ NULL, op_0078_13_ff, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0079_13_ff, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_007c_13_ff, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ NULL, op_0080_13_ff, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0090_13_ff, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0098_13_ff, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00a0_13_ff, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00a8_13_ff, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00b0_13_ff, 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ NULL, op_00b8_13_ff, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00b9_13_ff, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0100_13_ff, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0108_13_ff, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ NULL, op_0110_13_ff, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0118_13_ff, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0120_13_ff, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0128_13_ff, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0130_13_ff, 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_0138_13_ff, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0139_13_ff, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_013a_13_ff, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_013b_13_ff, 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_013c_13_ff, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0140_13_ff, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0148_13_ff, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ NULL, op_0150_13_ff, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0158_13_ff, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0160_13_ff, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0168_13_ff, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0170_13_ff, 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ NULL, op_0178_13_ff, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0179_13_ff, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0180_13_ff, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0188_13_ff, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ NULL, op_0190_13_ff, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0198_13_ff, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01a0_13_ff, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01a8_13_ff, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01b0_13_ff, 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ NULL, op_01b8_13_ff, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01b9_13_ff, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01c0_13_ff, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01c8_13_ff, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ NULL, op_01d0_13_ff, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01d8_13_ff, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01e0_13_ff, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01e8_13_ff, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01f0_13_ff, 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ NULL, op_01f8_13_ff, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01f9_13_ff, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_0200_13_ff, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0210_13_ff, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0218_13_ff, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0220_13_ff, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0228_13_ff, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0230_13_ff, 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ NULL, op_0238_13_ff, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0239_13_ff, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_023c_13_ff, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ NULL, op_0240_13_ff, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0250_13_ff, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0258_13_ff, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0260_13_ff, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0268_13_ff, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0270_13_ff, 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ NULL, op_0278_13_ff, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0279_13_ff, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_027c_13_ff, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ NULL, op_0280_13_ff, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0290_13_ff, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0298_13_ff, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02a0_13_ff, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02a8_13_ff, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02b0_13_ff, 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ NULL, op_02b8_13_ff, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02b9_13_ff, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0400_13_ff, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0410_13_ff, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0418_13_ff, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0420_13_ff, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0428_13_ff, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0430_13_ff, 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_0438_13_ff, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0439_13_ff, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0440_13_ff, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0450_13_ff, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0458_13_ff, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0460_13_ff, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0468_13_ff, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0470_13_ff, 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_0478_13_ff, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0479_13_ff, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0480_13_ff, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0490_13_ff, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0498_13_ff, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04a0_13_ff, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04a8_13_ff, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04b0_13_ff, 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_04b8_13_ff, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04b9_13_ff, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0600_13_ff, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0610_13_ff, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0618_13_ff, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0620_13_ff, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0628_13_ff, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0630_13_ff, 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_0638_13_ff, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0639_13_ff, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0640_13_ff, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0650_13_ff, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0658_13_ff, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0660_13_ff, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0668_13_ff, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0670_13_ff, 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_0678_13_ff, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0679_13_ff, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0680_13_ff, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0690_13_ff, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0698_13_ff, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06a0_13_ff, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06a8_13_ff, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06b0_13_ff, 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_06b8_13_ff, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06b9_13_ff, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0800_13_ff, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0810_13_ff, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0818_13_ff, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0820_13_ff, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0828_13_ff, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0830_13_ff, 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_0838_13_ff, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0839_13_ff, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_083a_13_ff, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_083b_13_ff, 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_0840_13_ff, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0850_13_ff, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0858_13_ff, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0860_13_ff, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0868_13_ff, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0870_13_ff, 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ NULL, op_0878_13_ff, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0879_13_ff, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0880_13_ff, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0890_13_ff, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0898_13_ff, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08a0_13_ff, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08a8_13_ff, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08b0_13_ff, 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ NULL, op_08b8_13_ff, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08b9_13_ff, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08c0_13_ff, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08d0_13_ff, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08d8_13_ff, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08e0_13_ff, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08e8_13_ff, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08f0_13_ff, 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ NULL, op_08f8_13_ff, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08f9_13_ff, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_0a00_13_ff, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a10_13_ff, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a18_13_ff, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a20_13_ff, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a28_13_ff, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a30_13_ff, 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_0a38_13_ff, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a39_13_ff, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a3c_13_ff, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ NULL, op_0a40_13_ff, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a50_13_ff, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a58_13_ff, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a60_13_ff, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a68_13_ff, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a70_13_ff, 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_0a78_13_ff, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a79_13_ff, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a7c_13_ff, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ NULL, op_0a80_13_ff, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a90_13_ff, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a98_13_ff, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0aa0_13_ff, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0aa8_13_ff, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0ab0_13_ff, 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_0ab8_13_ff, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0ab9_13_ff, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0c00_13_ff, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c10_13_ff, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c18_13_ff, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c20_13_ff, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c28_13_ff, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c30_13_ff, 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_0c38_13_ff, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c39_13_ff, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c40_13_ff, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c50_13_ff, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c58_13_ff, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c60_13_ff, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c68_13_ff, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c70_13_ff, 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_0c78_13_ff, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c79_13_ff, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c80_13_ff, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c90_13_ff, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c98_13_ff, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0ca0_13_ff, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0ca8_13_ff, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0cb0_13_ff, 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_0cb8_13_ff, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0cb9_13_ff, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e10_13_ff, 0x0e10, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e18_13_ff, 0x0e18, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e20_13_ff, 0x0e20, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e28_13_ff, 0x0e28, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e30_13_ff, 0x0e30, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e38_13_ff, 0x0e38, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e39_13_ff, 0x0e39, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e50_13_ff, 0x0e50, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e58_13_ff, 0x0e58, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e60_13_ff, 0x0e60, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e68_13_ff, 0x0e68, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e70_13_ff, 0x0e70, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e78_13_ff, 0x0e78, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e79_13_ff, 0x0e79, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e90_13_ff, 0x0e90, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0e98_13_ff, 0x0e98, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0ea0_13_ff, 0x0ea0, 4, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0ea8_13_ff, 0x0ea8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0eb0_13_ff, 0x0eb0, 6, { 4, 4 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0eb8_13_ff, 0x0eb8, 6, { 0, 0 }, 0 }, /* MOVES */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_0eb9_13_ff, 0x0eb9, 8, { 0, 0 }, 0 }, /* MOVES */
#endif
{ NULL, op_1000_13_ff, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1010_13_ff, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1018_13_ff, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1020_13_ff, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1028_13_ff, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1030_13_ff, 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1038_13_ff, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1039_13_ff, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_103a_13_ff, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_103b_13_ff, 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_103c_13_ff, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1080_13_ff, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1090_13_ff, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1098_13_ff, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10a0_13_ff, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10a8_13_ff, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10b0_13_ff, 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10b8_13_ff, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10b9_13_ff, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10ba_13_ff, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10bb_13_ff, 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10bc_13_ff, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10c0_13_ff, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10d0_13_ff, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10d8_13_ff, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10e0_13_ff, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10e8_13_ff, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10f0_13_ff, 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10f8_13_ff, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10f9_13_ff, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10fa_13_ff, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10fb_13_ff, 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10fc_13_ff, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1100_13_ff, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1110_13_ff, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1118_13_ff, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1120_13_ff, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1128_13_ff, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1130_13_ff, 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1138_13_ff, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1139_13_ff, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_113a_13_ff, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_113b_13_ff, 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_113c_13_ff, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1140_13_ff, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1150_13_ff, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1158_13_ff, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1160_13_ff, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1168_13_ff, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1170_13_ff, 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_1178_13_ff, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1179_13_ff, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_117a_13_ff, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_117b_13_ff, 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_117c_13_ff, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1180_13_ff, 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1190_13_ff, 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1198_13_ff, 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11a0_13_ff, 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11a8_13_ff, 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11b0_13_ff, 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_11b8_13_ff, 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11b9_13_ff, 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11ba_13_ff, 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11bb_13_ff, 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_11bc_13_ff, 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11c0_13_ff, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11d0_13_ff, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11d8_13_ff, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11e0_13_ff, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11e8_13_ff, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11f0_13_ff, 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_11f8_13_ff, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11f9_13_ff, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11fa_13_ff, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11fb_13_ff, 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_11fc_13_ff, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13c0_13_ff, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13d0_13_ff, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13d8_13_ff, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13e0_13_ff, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13e8_13_ff, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13f0_13_ff, 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_13f8_13_ff, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13f9_13_ff, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13fa_13_ff, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13fb_13_ff, 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_13fc_13_ff, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2000_13_ff, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2008_13_ff, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2010_13_ff, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2018_13_ff, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2020_13_ff, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2028_13_ff, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2030_13_ff, 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2038_13_ff, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2039_13_ff, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_203a_13_ff, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_203b_13_ff, 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_203c_13_ff, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2040_13_ff, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2048_13_ff, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2050_13_ff, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2058_13_ff, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2060_13_ff, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2068_13_ff, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2070_13_ff, 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_2078_13_ff, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2079_13_ff, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_207a_13_ff, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_207b_13_ff, 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_207c_13_ff, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2080_13_ff, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2088_13_ff, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2090_13_ff, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2098_13_ff, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20a0_13_ff, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20a8_13_ff, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20b0_13_ff, 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20b8_13_ff, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20b9_13_ff, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20ba_13_ff, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20bb_13_ff, 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20bc_13_ff, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20c0_13_ff, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20c8_13_ff, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20d0_13_ff, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20d8_13_ff, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20e0_13_ff, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20e8_13_ff, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20f0_13_ff, 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20f8_13_ff, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20f9_13_ff, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20fa_13_ff, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20fb_13_ff, 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20fc_13_ff, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2100_13_ff, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2108_13_ff, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2110_13_ff, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2118_13_ff, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2120_13_ff, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2128_13_ff, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2130_13_ff, 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2138_13_ff, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2139_13_ff, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_213a_13_ff, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_213b_13_ff, 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_213c_13_ff, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2140_13_ff, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2148_13_ff, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2150_13_ff, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2158_13_ff, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2160_13_ff, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2168_13_ff, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2170_13_ff, 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_2178_13_ff, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2179_13_ff, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_217a_13_ff, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_217b_13_ff, 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_217c_13_ff, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2180_13_ff, 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2188_13_ff, 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2190_13_ff, 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2198_13_ff, 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21a0_13_ff, 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21a8_13_ff, 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21b0_13_ff, 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_21b8_13_ff, 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21b9_13_ff, 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21ba_13_ff, 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21bb_13_ff, 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_21bc_13_ff, 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21c0_13_ff, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21c8_13_ff, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21d0_13_ff, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21d8_13_ff, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21e0_13_ff, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21e8_13_ff, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21f0_13_ff, 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_21f8_13_ff, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21f9_13_ff, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21fa_13_ff, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21fb_13_ff, 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_21fc_13_ff, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23c0_13_ff, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23c8_13_ff, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23d0_13_ff, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23d8_13_ff, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23e0_13_ff, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23e8_13_ff, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23f0_13_ff, 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_23f8_13_ff, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23f9_13_ff, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23fa_13_ff, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23fb_13_ff, 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_23fc_13_ff, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3000_13_ff, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3008_13_ff, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3010_13_ff, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3018_13_ff, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3020_13_ff, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3028_13_ff, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3030_13_ff, 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3038_13_ff, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3039_13_ff, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_303a_13_ff, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_303b_13_ff, 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_303c_13_ff, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3040_13_ff, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3048_13_ff, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3050_13_ff, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3058_13_ff, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3060_13_ff, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3068_13_ff, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3070_13_ff, 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_3078_13_ff, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3079_13_ff, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_307a_13_ff, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_307b_13_ff, 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_307c_13_ff, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3080_13_ff, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3088_13_ff, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3090_13_ff, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3098_13_ff, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30a0_13_ff, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30a8_13_ff, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30b0_13_ff, 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30b8_13_ff, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30b9_13_ff, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30ba_13_ff, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30bb_13_ff, 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30bc_13_ff, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30c0_13_ff, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30c8_13_ff, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30d0_13_ff, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30d8_13_ff, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30e0_13_ff, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30e8_13_ff, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30f0_13_ff, 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30f8_13_ff, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30f9_13_ff, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30fa_13_ff, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30fb_13_ff, 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30fc_13_ff, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3100_13_ff, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3108_13_ff, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3110_13_ff, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3118_13_ff, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3120_13_ff, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3128_13_ff, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3130_13_ff, 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3138_13_ff, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3139_13_ff, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_313a_13_ff, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_313b_13_ff, 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_313c_13_ff, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3140_13_ff, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3148_13_ff, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3150_13_ff, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3158_13_ff, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3160_13_ff, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3168_13_ff, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3170_13_ff, 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_3178_13_ff, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3179_13_ff, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_317a_13_ff, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_317b_13_ff, 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_317c_13_ff, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3180_13_ff, 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3188_13_ff, 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3190_13_ff, 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3198_13_ff, 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31a0_13_ff, 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31a8_13_ff, 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31b0_13_ff, 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_31b8_13_ff, 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31b9_13_ff, 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31ba_13_ff, 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31bb_13_ff, 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_31bc_13_ff, 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31c0_13_ff, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31c8_13_ff, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31d0_13_ff, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31d8_13_ff, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31e0_13_ff, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31e8_13_ff, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31f0_13_ff, 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_31f8_13_ff, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31f9_13_ff, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31fa_13_ff, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31fb_13_ff, 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_31fc_13_ff, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33c0_13_ff, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33c8_13_ff, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33d0_13_ff, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33d8_13_ff, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33e0_13_ff, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33e8_13_ff, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33f0_13_ff, 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_33f8_13_ff, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33f9_13_ff, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33fa_13_ff, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33fb_13_ff, 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_33fc_13_ff, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_4000_13_ff, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4010_13_ff, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4018_13_ff, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4020_13_ff, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4028_13_ff, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4030_13_ff, 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ NULL, op_4038_13_ff, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4039_13_ff, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4040_13_ff, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4050_13_ff, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4058_13_ff, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4060_13_ff, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4068_13_ff, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4070_13_ff, 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ NULL, op_4078_13_ff, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4079_13_ff, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4080_13_ff, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4090_13_ff, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4098_13_ff, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40a0_13_ff, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40a8_13_ff, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40b0_13_ff, 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ NULL, op_40b8_13_ff, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40b9_13_ff, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40c0_13_ff, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40d0_13_ff, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40d8_13_ff, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40e0_13_ff, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40e8_13_ff, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40f0_13_ff, 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40f8_13_ff, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40f9_13_ff, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_4180_13_ff, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_4190_13_ff, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_4198_13_ff, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41a0_13_ff, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41a8_13_ff, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41b0_13_ff, 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ NULL, op_41b8_13_ff, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41b9_13_ff, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41ba_13_ff, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41bb_13_ff, 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ NULL, op_41bc_13_ff, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41d0_13_ff, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41e8_13_ff, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41f0_13_ff, 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ NULL, op_41f8_13_ff, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41f9_13_ff, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41fa_13_ff, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41fb_13_ff, 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ NULL, op_4200_13_ff, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4210_13_ff, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4218_13_ff, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4220_13_ff, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4228_13_ff, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4230_13_ff, 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ NULL, op_4238_13_ff, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4239_13_ff, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4240_13_ff, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4250_13_ff, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4258_13_ff, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4260_13_ff, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4268_13_ff, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4270_13_ff, 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ NULL, op_4278_13_ff, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4279_13_ff, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4280_13_ff, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4290_13_ff, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4298_13_ff, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42a0_13_ff, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42a8_13_ff, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42b0_13_ff, 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ NULL, op_42b8_13_ff, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42b9_13_ff, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42c0_13_ff, 0x42c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42d0_13_ff, 0x42d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42d8_13_ff, 0x42d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42e0_13_ff, 0x42e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42e8_13_ff, 0x42e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42f0_13_ff, 0x42f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42f8_13_ff, 0x42f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_42f9_13_ff, 0x42f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
#endif
{ NULL, op_4400_13_ff, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4410_13_ff, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4418_13_ff, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4420_13_ff, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4428_13_ff, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4430_13_ff, 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ NULL, op_4438_13_ff, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4439_13_ff, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4440_13_ff, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4450_13_ff, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4458_13_ff, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4460_13_ff, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4468_13_ff, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4470_13_ff, 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ NULL, op_4478_13_ff, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4479_13_ff, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4480_13_ff, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4490_13_ff, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4498_13_ff, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44a0_13_ff, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44a8_13_ff, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44b0_13_ff, 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ NULL, op_44b8_13_ff, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44b9_13_ff, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44c0_13_ff, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44d0_13_ff, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44d8_13_ff, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44e0_13_ff, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44e8_13_ff, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44f0_13_ff, 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_44f8_13_ff, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44f9_13_ff, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44fa_13_ff, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44fb_13_ff, 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_44fc_13_ff, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_4600_13_ff, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4610_13_ff, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4618_13_ff, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4620_13_ff, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4628_13_ff, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4630_13_ff, 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ NULL, op_4638_13_ff, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4639_13_ff, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4640_13_ff, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4650_13_ff, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4658_13_ff, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4660_13_ff, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4668_13_ff, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4670_13_ff, 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ NULL, op_4678_13_ff, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4679_13_ff, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4680_13_ff, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4690_13_ff, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4698_13_ff, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46a0_13_ff, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46a8_13_ff, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46b0_13_ff, 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ NULL, op_46b8_13_ff, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46b9_13_ff, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46c0_13_ff, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46d0_13_ff, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46d8_13_ff, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46e0_13_ff, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46e8_13_ff, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46f0_13_ff, 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_46f8_13_ff, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46f9_13_ff, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46fa_13_ff, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46fb_13_ff, 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_46fc_13_ff, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_4800_13_ff, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4810_13_ff, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4818_13_ff, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4820_13_ff, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4828_13_ff, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4830_13_ff, 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ NULL, op_4838_13_ff, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4839_13_ff, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4840_13_ff, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
#ifndef CPUEMU_68000_ONLY
{ NULL, op_4848_13_ff, 0x4848, 2, { 0, 0 }, 0 }, /* BKPT */
#endif
{ NULL, op_4850_13_ff, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_4868_13_ff, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_4870_13_ff, 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ NULL, op_4878_13_ff, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_4879_13_ff, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_487a_13_ff, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_487b_13_ff, 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ NULL, op_4880_13_ff, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ NULL, op_4890_13_ff, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48a0_13_ff, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48a8_13_ff, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48b0_13_ff, 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ NULL, op_48b8_13_ff, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48b9_13_ff, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48c0_13_ff, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ NULL, op_48d0_13_ff, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48e0_13_ff, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48e8_13_ff, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48f0_13_ff, 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ NULL, op_48f8_13_ff, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48f9_13_ff, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_4a00_13_ff, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a10_13_ff, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a18_13_ff, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a20_13_ff, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a28_13_ff, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a30_13_ff, 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ NULL, op_4a38_13_ff, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a39_13_ff, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a40_13_ff, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a50_13_ff, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a58_13_ff, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a60_13_ff, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a68_13_ff, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a70_13_ff, 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ NULL, op_4a78_13_ff, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a79_13_ff, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a80_13_ff, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a90_13_ff, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a98_13_ff, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4aa0_13_ff, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4aa8_13_ff, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4ab0_13_ff, 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ NULL, op_4ab8_13_ff, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4ab9_13_ff, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4ac0_13_ff, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ad0_13_ff, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ad8_13_ff, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ae0_13_ff, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ae8_13_ff, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4af0_13_ff, 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ NULL, op_4af8_13_ff, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4af9_13_ff, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4c90_13_ff, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4c98_13_ff, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4ca8_13_ff, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cb0_13_ff, 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cb8_13_ff, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cb9_13_ff, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cba_13_ff, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cbb_13_ff, 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cd0_13_ff, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cd8_13_ff, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4ce8_13_ff, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cf0_13_ff, 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cf8_13_ff, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cf9_13_ff, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cfa_13_ff, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cfb_13_ff, 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4e40_13_ff, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ NULL, op_4e50_13_ff, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ NULL, op_4e58_13_ff, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ NULL, op_4e60_13_ff, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ NULL, op_4e68_13_ff, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ NULL, op_4e70_13_ff, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ NULL, op_4e71_13_ff, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ NULL, op_4e72_13_ff, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ NULL, op_4e73_13_ff, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
#ifndef CPUEMU_68000_ONLY
{ NULL, op_4e74_13_ff, 0x4e74, 4, { 0, 0 }, 2 }, /* RTD */
#endif
{ NULL, op_4e75_13_ff, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ NULL, op_4e76_13_ff, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ NULL, op_4e77_13_ff, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
#ifndef CPUEMU_68000_ONLY
{ NULL, op_4e7a_13_ff, 0x4e7a, 4, { 0, 0 }, 0 }, /* MOVEC2 */
#endif
#ifndef CPUEMU_68000_ONLY
{ NULL, op_4e7b_13_ff, 0x4e7b, 4, { 0, 0 }, 0 }, /* MOVE2C */
#endif
{ NULL, op_4e90_13_ff, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ NULL, op_4ea8_13_ff, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ NULL, op_4eb0_13_ff, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ NULL, op_4eb8_13_ff, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ NULL, op_4eb9_13_ff, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ NULL, op_4eba_13_ff, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ NULL, op_4ebb_13_ff, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ NULL, op_4ed0_13_ff, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ NULL, op_4ee8_13_ff, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ NULL, op_4ef0_13_ff, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ NULL, op_4ef8_13_ff, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ NULL, op_4ef9_13_ff, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ NULL, op_4efa_13_ff, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ NULL, op_4efb_13_ff, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ NULL, op_5000_13_ff, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5010_13_ff, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5018_13_ff, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5020_13_ff, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5028_13_ff, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5030_13_ff, 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_5038_13_ff, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5039_13_ff, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5040_13_ff, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5048_13_ff, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_5050_13_ff, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5058_13_ff, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5060_13_ff, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5068_13_ff, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5070_13_ff, 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_5078_13_ff, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5079_13_ff, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5080_13_ff, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5088_13_ff, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_5090_13_ff, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5098_13_ff, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50a0_13_ff, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50a8_13_ff, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50b0_13_ff, 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_50b8_13_ff, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50b9_13_ff, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50c0_13_ff, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50c8_13_ff, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_50d0_13_ff, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50d8_13_ff, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50e0_13_ff, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50e8_13_ff, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50f0_13_ff, 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_50f8_13_ff, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50f9_13_ff, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5100_13_ff, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5110_13_ff, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5118_13_ff, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5120_13_ff, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5128_13_ff, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5130_13_ff, 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_5138_13_ff, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5139_13_ff, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5140_13_ff, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5148_13_ff, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_5150_13_ff, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5158_13_ff, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5160_13_ff, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5168_13_ff, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5170_13_ff, 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_5178_13_ff, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5179_13_ff, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5180_13_ff, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5188_13_ff, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_5190_13_ff, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5198_13_ff, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51a0_13_ff, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51a8_13_ff, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51b0_13_ff, 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_51b8_13_ff, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51b9_13_ff, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51c0_13_ff, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51c8_13_ff, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_51d0_13_ff, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51d8_13_ff, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51e0_13_ff, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51e8_13_ff, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51f0_13_ff, 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_51f8_13_ff, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51f9_13_ff, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52c0_13_ff, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52c8_13_ff, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_52d0_13_ff, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52d8_13_ff, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52e0_13_ff, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52e8_13_ff, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52f0_13_ff, 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_52f8_13_ff, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52f9_13_ff, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53c0_13_ff, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53c8_13_ff, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_53d0_13_ff, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53d8_13_ff, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53e0_13_ff, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53e8_13_ff, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53f0_13_ff, 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_53f8_13_ff, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53f9_13_ff, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54c0_13_ff, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54c8_13_ff, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_54d0_13_ff, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54d8_13_ff, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54e0_13_ff, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54e8_13_ff, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54f0_13_ff, 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_54f8_13_ff, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54f9_13_ff, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55c0_13_ff, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55c8_13_ff, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_55d0_13_ff, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55d8_13_ff, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55e0_13_ff, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55e8_13_ff, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55f0_13_ff, 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_55f8_13_ff, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55f9_13_ff, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56c0_13_ff, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56c8_13_ff, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_56d0_13_ff, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56d8_13_ff, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56e0_13_ff, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56e8_13_ff, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56f0_13_ff, 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_56f8_13_ff, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56f9_13_ff, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57c0_13_ff, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57c8_13_ff, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_57d0_13_ff, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57d8_13_ff, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57e0_13_ff, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57e8_13_ff, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57f0_13_ff, 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_57f8_13_ff, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57f9_13_ff, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58c0_13_ff, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58c8_13_ff, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_58d0_13_ff, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58d8_13_ff, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58e0_13_ff, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58e8_13_ff, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58f0_13_ff, 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_58f8_13_ff, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58f9_13_ff, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59c0_13_ff, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59c8_13_ff, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_59d0_13_ff, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59d8_13_ff, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59e0_13_ff, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59e8_13_ff, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59f0_13_ff, 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_59f8_13_ff, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59f9_13_ff, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ac0_13_ff, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ac8_13_ff, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5ad0_13_ff, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ad8_13_ff, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ae0_13_ff, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ae8_13_ff, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5af0_13_ff, 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5af8_13_ff, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5af9_13_ff, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bc0_13_ff, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bc8_13_ff, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5bd0_13_ff, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bd8_13_ff, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5be0_13_ff, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5be8_13_ff, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bf0_13_ff, 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5bf8_13_ff, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bf9_13_ff, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cc0_13_ff, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cc8_13_ff, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5cd0_13_ff, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cd8_13_ff, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ce0_13_ff, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ce8_13_ff, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cf0_13_ff, 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5cf8_13_ff, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cf9_13_ff, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5dc0_13_ff, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5dc8_13_ff, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5dd0_13_ff, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5dd8_13_ff, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5de0_13_ff, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5de8_13_ff, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5df0_13_ff, 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5df8_13_ff, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5df9_13_ff, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ec0_13_ff, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ec8_13_ff, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5ed0_13_ff, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ed8_13_ff, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ee0_13_ff, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ee8_13_ff, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ef0_13_ff, 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5ef8_13_ff, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ef9_13_ff, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fc0_13_ff, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fc8_13_ff, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5fd0_13_ff, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fd8_13_ff, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fe0_13_ff, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fe8_13_ff, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ff0_13_ff, 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5ff8_13_ff, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ff9_13_ff, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_6000_13_ff, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6001_13_ff, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_60ff_13_ff, 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6100_13_ff, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ NULL, op_6101_13_ff, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ NULL, op_61ff_13_ff, 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ NULL, op_6200_13_ff, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6201_13_ff, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_62ff_13_ff, 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6300_13_ff, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6301_13_ff, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_63ff_13_ff, 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6400_13_ff, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6401_13_ff, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_64ff_13_ff, 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6500_13_ff, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6501_13_ff, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_65ff_13_ff, 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6600_13_ff, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6601_13_ff, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_66ff_13_ff, 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6700_13_ff, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6701_13_ff, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_67ff_13_ff, 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6800_13_ff, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6801_13_ff, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_68ff_13_ff, 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6900_13_ff, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6901_13_ff, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_69ff_13_ff, 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6a00_13_ff, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6a01_13_ff, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6aff_13_ff, 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6b00_13_ff, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6b01_13_ff, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6bff_13_ff, 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6c00_13_ff, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6c01_13_ff, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6cff_13_ff, 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6d00_13_ff, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6d01_13_ff, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6dff_13_ff, 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6e00_13_ff, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6e01_13_ff, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6eff_13_ff, 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6f00_13_ff, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6f01_13_ff, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6fff_13_ff, 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_7000_13_ff, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_8000_13_ff, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8010_13_ff, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8018_13_ff, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8020_13_ff, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8028_13_ff, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8030_13_ff, 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8038_13_ff, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8039_13_ff, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_803a_13_ff, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_803b_13_ff, 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_803c_13_ff, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8040_13_ff, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8050_13_ff, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8058_13_ff, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8060_13_ff, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8068_13_ff, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8070_13_ff, 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8078_13_ff, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8079_13_ff, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_807a_13_ff, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_807b_13_ff, 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_807c_13_ff, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8080_13_ff, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8090_13_ff, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8098_13_ff, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80a0_13_ff, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80a8_13_ff, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80b0_13_ff, 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_80b8_13_ff, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80b9_13_ff, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80ba_13_ff, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80bb_13_ff, 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_80bc_13_ff, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80c0_13_ff, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80d0_13_ff, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80d8_13_ff, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80e0_13_ff, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80e8_13_ff, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80f0_13_ff, 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ NULL, op_80f8_13_ff, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80f9_13_ff, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80fa_13_ff, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80fb_13_ff, 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ NULL, op_80fc_13_ff, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_8100_13_ff, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ NULL, op_8108_13_ff, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ NULL, op_8110_13_ff, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8118_13_ff, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8120_13_ff, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8128_13_ff, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8130_13_ff, 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8138_13_ff, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8139_13_ff, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8150_13_ff, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8158_13_ff, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8160_13_ff, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8168_13_ff, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8170_13_ff, 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8178_13_ff, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8179_13_ff, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8190_13_ff, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8198_13_ff, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81a0_13_ff, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81a8_13_ff, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81b0_13_ff, 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_81b8_13_ff, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81b9_13_ff, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81c0_13_ff, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81d0_13_ff, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81d8_13_ff, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81e0_13_ff, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81e8_13_ff, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81f0_13_ff, 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ NULL, op_81f8_13_ff, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81f9_13_ff, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81fa_13_ff, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81fb_13_ff, 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ NULL, op_81fc_13_ff, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_9000_13_ff, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9010_13_ff, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9018_13_ff, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9020_13_ff, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9028_13_ff, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9030_13_ff, 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9038_13_ff, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9039_13_ff, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_903a_13_ff, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_903b_13_ff, 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_903c_13_ff, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9040_13_ff, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9048_13_ff, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9050_13_ff, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9058_13_ff, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9060_13_ff, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9068_13_ff, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9070_13_ff, 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9078_13_ff, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9079_13_ff, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_907a_13_ff, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_907b_13_ff, 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_907c_13_ff, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9080_13_ff, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9088_13_ff, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9090_13_ff, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9098_13_ff, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90a0_13_ff, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90a8_13_ff, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90b0_13_ff, 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_90b8_13_ff, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90b9_13_ff, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90ba_13_ff, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90bb_13_ff, 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_90bc_13_ff, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90c0_13_ff, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90c8_13_ff, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90d0_13_ff, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90d8_13_ff, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90e0_13_ff, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90e8_13_ff, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90f0_13_ff, 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_90f8_13_ff, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90f9_13_ff, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90fa_13_ff, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90fb_13_ff, 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_90fc_13_ff, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_9100_13_ff, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9108_13_ff, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9110_13_ff, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9118_13_ff, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9120_13_ff, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9128_13_ff, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9130_13_ff, 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9138_13_ff, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9139_13_ff, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9140_13_ff, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9148_13_ff, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9150_13_ff, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9158_13_ff, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9160_13_ff, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9168_13_ff, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9170_13_ff, 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9178_13_ff, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9179_13_ff, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9180_13_ff, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9188_13_ff, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9190_13_ff, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9198_13_ff, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91a0_13_ff, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91a8_13_ff, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91b0_13_ff, 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_91b8_13_ff, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91b9_13_ff, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91c0_13_ff, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91c8_13_ff, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91d0_13_ff, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91d8_13_ff, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91e0_13_ff, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91e8_13_ff, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91f0_13_ff, 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_91f8_13_ff, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91f9_13_ff, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91fa_13_ff, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91fb_13_ff, 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_91fc_13_ff, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_b000_13_ff, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b010_13_ff, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b018_13_ff, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b020_13_ff, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b028_13_ff, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b030_13_ff, 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b038_13_ff, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b039_13_ff, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b03a_13_ff, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b03b_13_ff, 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b03c_13_ff, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b040_13_ff, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b048_13_ff, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b050_13_ff, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b058_13_ff, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b060_13_ff, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b068_13_ff, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b070_13_ff, 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b078_13_ff, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b079_13_ff, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b07a_13_ff, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b07b_13_ff, 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b07c_13_ff, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b080_13_ff, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b088_13_ff, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b090_13_ff, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b098_13_ff, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0a0_13_ff, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0a8_13_ff, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0b0_13_ff, 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b0b8_13_ff, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0b9_13_ff, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0ba_13_ff, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0bb_13_ff, 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b0bc_13_ff, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0c0_13_ff, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0c8_13_ff, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0d0_13_ff, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0d8_13_ff, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0e0_13_ff, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0e8_13_ff, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0f0_13_ff, 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b0f8_13_ff, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0f9_13_ff, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0fa_13_ff, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0fb_13_ff, 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b0fc_13_ff, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b100_13_ff, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b108_13_ff, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ NULL, op_b110_13_ff, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b118_13_ff, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b120_13_ff, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b128_13_ff, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b130_13_ff, 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_b138_13_ff, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b139_13_ff, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b140_13_ff, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b148_13_ff, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ NULL, op_b150_13_ff, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b158_13_ff, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b160_13_ff, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b168_13_ff, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b170_13_ff, 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_b178_13_ff, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b179_13_ff, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b180_13_ff, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b188_13_ff, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ NULL, op_b190_13_ff, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b198_13_ff, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1a0_13_ff, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1a8_13_ff, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1b0_13_ff, 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_b1b8_13_ff, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1b9_13_ff, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1c0_13_ff, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1c8_13_ff, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1d0_13_ff, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1d8_13_ff, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1e0_13_ff, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1e8_13_ff, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1f0_13_ff, 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b1f8_13_ff, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1f9_13_ff, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1fa_13_ff, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1fb_13_ff, 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b1fc_13_ff, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_c000_13_ff, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c010_13_ff, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c018_13_ff, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c020_13_ff, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c028_13_ff, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c030_13_ff, 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c038_13_ff, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c039_13_ff, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c03a_13_ff, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c03b_13_ff, 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c03c_13_ff, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c040_13_ff, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c050_13_ff, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c058_13_ff, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c060_13_ff, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c068_13_ff, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c070_13_ff, 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c078_13_ff, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c079_13_ff, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c07a_13_ff, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c07b_13_ff, 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c07c_13_ff, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c080_13_ff, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c090_13_ff, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c098_13_ff, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0a0_13_ff, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0a8_13_ff, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0b0_13_ff, 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c0b8_13_ff, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0b9_13_ff, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0ba_13_ff, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0bb_13_ff, 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c0bc_13_ff, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0c0_13_ff, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0d0_13_ff, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0d8_13_ff, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0e0_13_ff, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0e8_13_ff, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0f0_13_ff, 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ NULL, op_c0f8_13_ff, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0f9_13_ff, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0fa_13_ff, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0fb_13_ff, 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ NULL, op_c0fc_13_ff, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c100_13_ff, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ NULL, op_c108_13_ff, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ NULL, op_c110_13_ff, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c118_13_ff, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c120_13_ff, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c128_13_ff, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c130_13_ff, 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c138_13_ff, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c139_13_ff, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c140_13_ff, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ NULL, op_c148_13_ff, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ NULL, op_c150_13_ff, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c158_13_ff, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c160_13_ff, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c168_13_ff, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c170_13_ff, 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c178_13_ff, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c179_13_ff, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c188_13_ff, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ NULL, op_c190_13_ff, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c198_13_ff, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1a0_13_ff, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1a8_13_ff, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1b0_13_ff, 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c1b8_13_ff, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1b9_13_ff, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1c0_13_ff, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1d0_13_ff, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1d8_13_ff, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1e0_13_ff, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1e8_13_ff, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1f0_13_ff, 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ NULL, op_c1f8_13_ff, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1f9_13_ff, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1fa_13_ff, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1fb_13_ff, 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ NULL, op_c1fc_13_ff, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_d000_13_ff, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d010_13_ff, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d018_13_ff, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d020_13_ff, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d028_13_ff, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d030_13_ff, 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d038_13_ff, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d039_13_ff, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d03a_13_ff, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d03b_13_ff, 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d03c_13_ff, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d040_13_ff, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d048_13_ff, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d050_13_ff, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d058_13_ff, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d060_13_ff, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d068_13_ff, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d070_13_ff, 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d078_13_ff, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d079_13_ff, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d07a_13_ff, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d07b_13_ff, 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d07c_13_ff, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d080_13_ff, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d088_13_ff, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d090_13_ff, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d098_13_ff, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0a0_13_ff, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0a8_13_ff, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0b0_13_ff, 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d0b8_13_ff, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0b9_13_ff, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0ba_13_ff, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0bb_13_ff, 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d0bc_13_ff, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0c0_13_ff, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0c8_13_ff, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0d0_13_ff, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0d8_13_ff, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0e0_13_ff, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0e8_13_ff, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0f0_13_ff, 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d0f8_13_ff, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0f9_13_ff, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0fa_13_ff, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0fb_13_ff, 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d0fc_13_ff, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d100_13_ff, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d108_13_ff, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d110_13_ff, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d118_13_ff, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d120_13_ff, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d128_13_ff, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d130_13_ff, 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d138_13_ff, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d139_13_ff, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d140_13_ff, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d148_13_ff, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d150_13_ff, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d158_13_ff, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d160_13_ff, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d168_13_ff, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d170_13_ff, 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d178_13_ff, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d179_13_ff, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d180_13_ff, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d188_13_ff, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d190_13_ff, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d198_13_ff, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1a0_13_ff, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1a8_13_ff, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1b0_13_ff, 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d1b8_13_ff, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1b9_13_ff, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1c0_13_ff, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1c8_13_ff, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1d0_13_ff, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1d8_13_ff, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1e0_13_ff, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1e8_13_ff, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1f0_13_ff, 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d1f8_13_ff, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1f9_13_ff, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1fa_13_ff, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1fb_13_ff, 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d1fc_13_ff, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_e000_13_ff, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ NULL, op_e008_13_ff, 0xe008, 2, { 0, 0 }, 0 }, /* LSR */
{ NULL, op_e010_13_ff, 0xe010, 2, { 0, 0 }, 0 }, /* ROXR */
{ NULL, op_e018_13_ff, 0xe018, 2, { 0, 0 }, 0 }, /* ROR */
{ NULL, op_e020_13_ff, 0xe020, 2, { 0, 0 }, 0 }, /* ASR */
{ NULL, op_e028_13_ff, 0xe028, 2, { 0, 0 }, 0 }, /* LSR */
{ NULL, op_e030_13_ff, 0xe030, 2, { 0, 0 }, 0 }, /* ROXR */
{ NULL, op_e038_13_ff, 0xe038, 2, { 0, 0 }, 0 }, /* ROR */
{ NULL, op_e040_13_ff, 0xe040, 2, { 0, 0 }, 0 }, /* ASR */
{ NULL, op_e048_13_ff, 0xe048, 2, { 0, 0 }, 0 }, /* LSR */
{ NULL, op_e050_13_ff, 0xe050, 2, { 0, 0 }, 0 }, /* ROXR */
{ NULL, op_e058_13_ff, 0xe058, 2, { 0, 0 }, 0 }, /* ROR */
{ NULL, op_e060_13_ff, 0xe060, 2, { 0, 0 }, 0 }, /* ASR */
{ NULL, op_e068_13_ff, 0xe068, 2, { 0, 0 }, 0 }, /* LSR */
{ NULL, op_e070_13_ff, 0xe070, 2, { 0, 0 }, 0 }, /* ROXR */
{ NULL, op_e078_13_ff, 0xe078, 2, { 0, 0 }, 0 }, /* ROR */
{ NULL, op_e080_13_ff, 0xe080, 2, { 0, 0 }, 0 }, /* ASR */
{ NULL, op_e088_13_ff, 0xe088, 2, { 0, 0 }, 0 }, /* LSR */
{ NULL, op_e090_13_ff, 0xe090, 2, { 0, 0 }, 0 }, /* ROXR */
{ NULL, op_e098_13_ff, 0xe098, 2, { 0, 0 }, 0 }, /* ROR */
{ NULL, op_e0a0_13_ff, 0xe0a0, 2, { 0, 0 }, 0 }, /* ASR */
{ NULL, op_e0a8_13_ff, 0xe0a8, 2, { 0, 0 }, 0 }, /* LSR */
{ NULL, op_e0b0_13_ff, 0xe0b0, 2, { 0, 0 }, 0 }, /* ROXR */
{ NULL, op_e0b8_13_ff, 0xe0b8, 2, { 0, 0 }, 0 }, /* ROR */
{ NULL, op_e0d0_13_ff, 0xe0d0, 2, { 0, 0 }, 0 }, /* ASRW */
{ NULL, op_e0d8_13_ff, 0xe0d8, 2, { 0, 0 }, 0 }, /* ASRW */
{ NULL, op_e0e0_13_ff, 0xe0e0, 2, { 0, 0 }, 0 }, /* ASRW */
{ NULL, op_e0e8_13_ff, 0xe0e8, 4, { 0, 0 }, 0 }, /* ASRW */
{ NULL, op_e0f0_13_ff, 0xe0f0, 4, { 4, 0 }, 0 }, /* ASRW */
{ NULL, op_e0f8_13_ff, 0xe0f8, 4, { 0, 0 }, 0 }, /* ASRW */
{ NULL, op_e0f9_13_ff, 0xe0f9, 6, { 0, 0 }, 0 }, /* ASRW */
{ NULL, op_e100_13_ff, 0xe100, 2, { 0, 0 }, 0 }, /* ASL */
{ NULL, op_e108_13_ff, 0xe108, 2, { 0, 0 }, 0 }, /* LSL */
{ NULL, op_e110_13_ff, 0xe110, 2, { 0, 0 }, 0 }, /* ROXL */
{ NULL, op_e118_13_ff, 0xe118, 2, { 0, 0 }, 0 }, /* ROL */
{ NULL, op_e120_13_ff, 0xe120, 2, { 0, 0 }, 0 }, /* ASL */
{ NULL, op_e128_13_ff, 0xe128, 2, { 0, 0 }, 0 }, /* LSL */
{ NULL, op_e130_13_ff, 0xe130, 2, { 0, 0 }, 0 }, /* ROXL */
{ NULL, op_e138_13_ff, 0xe138, 2, { 0, 0 }, 0 }, /* ROL */
{ NULL, op_e140_13_ff, 0xe140, 2, { 0, 0 }, 0 }, /* ASL */
{ NULL, op_e148_13_ff, 0xe148, 2, { 0, 0 }, 0 }, /* LSL */
{ NULL, op_e150_13_ff, 0xe150, 2, { 0, 0 }, 0 }, /* ROXL */
{ NULL, op_e158_13_ff, 0xe158, 2, { 0, 0 }, 0 }, /* ROL */
{ NULL, op_e160_13_ff, 0xe160, 2, { 0, 0 }, 0 }, /* ASL */
{ NULL, op_e168_13_ff, 0xe168, 2, { 0, 0 }, 0 }, /* LSL */
{ NULL, op_e170_13_ff, 0xe170, 2, { 0, 0 }, 0 }, /* ROXL */
{ NULL, op_e178_13_ff, 0xe178, 2, { 0, 0 }, 0 }, /* ROL */
{ NULL, op_e180_13_ff, 0xe180, 2, { 0, 0 }, 0 }, /* ASL */
{ NULL, op_e188_13_ff, 0xe188, 2, { 0, 0 }, 0 }, /* LSL */
{ NULL, op_e190_13_ff, 0xe190, 2, { 0, 0 }, 0 }, /* ROXL */
{ NULL, op_e198_13_ff, 0xe198, 2, { 0, 0 }, 0 }, /* ROL */
{ NULL, op_e1a0_13_ff, 0xe1a0, 2, { 0, 0 }, 0 }, /* ASL */
{ NULL, op_e1a8_13_ff, 0xe1a8, 2, { 0, 0 }, 0 }, /* LSL */
{ NULL, op_e1b0_13_ff, 0xe1b0, 2, { 0, 0 }, 0 }, /* ROXL */
{ NULL, op_e1b8_13_ff, 0xe1b8, 2, { 0, 0 }, 0 }, /* ROL */
{ NULL, op_e1d0_13_ff, 0xe1d0, 2, { 0, 0 }, 0 }, /* ASLW */
{ NULL, op_e1d8_13_ff, 0xe1d8, 2, { 0, 0 }, 0 }, /* ASLW */
{ NULL, op_e1e0_13_ff, 0xe1e0, 2, { 0, 0 }, 0 }, /* ASLW */
{ NULL, op_e1e8_13_ff, 0xe1e8, 4, { 0, 0 }, 0 }, /* ASLW */
{ NULL, op_e1f0_13_ff, 0xe1f0, 4, { 4, 0 }, 0 }, /* ASLW */
{ NULL, op_e1f8_13_ff, 0xe1f8, 4, { 0, 0 }, 0 }, /* ASLW */
{ NULL, op_e1f9_13_ff, 0xe1f9, 6, { 0, 0 }, 0 }, /* ASLW */
{ NULL, op_e2d0_13_ff, 0xe2d0, 2, { 0, 0 }, 0 }, /* LSRW */
{ NULL, op_e2d8_13_ff, 0xe2d8, 2, { 0, 0 }, 0 }, /* LSRW */
{ NULL, op_e2e0_13_ff, 0xe2e0, 2, { 0, 0 }, 0 }, /* LSRW */
{ NULL, op_e2e8_13_ff, 0xe2e8, 4, { 0, 0 }, 0 }, /* LSRW */
{ NULL, op_e2f0_13_ff, 0xe2f0, 4, { 4, 0 }, 0 }, /* LSRW */
{ NULL, op_e2f8_13_ff, 0xe2f8, 4, { 0, 0 }, 0 }, /* LSRW */
{ NULL, op_e2f9_13_ff, 0xe2f9, 6, { 0, 0 }, 0 }, /* LSRW */
{ NULL, op_e3d0_13_ff, 0xe3d0, 2, { 0, 0 }, 0 }, /* LSLW */
{ NULL, op_e3d8_13_ff, 0xe3d8, 2, { 0, 0 }, 0 }, /* LSLW */
{ NULL, op_e3e0_13_ff, 0xe3e0, 2, { 0, 0 }, 0 }, /* LSLW */
{ NULL, op_e3e8_13_ff, 0xe3e8, 4, { 0, 0 }, 0 }, /* LSLW */
{ NULL, op_e3f0_13_ff, 0xe3f0, 4, { 4, 0 }, 0 }, /* LSLW */
{ NULL, op_e3f8_13_ff, 0xe3f8, 4, { 0, 0 }, 0 }, /* LSLW */
{ NULL, op_e3f9_13_ff, 0xe3f9, 6, { 0, 0 }, 0 }, /* LSLW */
{ NULL, op_e4d0_13_ff, 0xe4d0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ NULL, op_e4d8_13_ff, 0xe4d8, 2, { 0, 0 }, 0 }, /* ROXRW */
{ NULL, op_e4e0_13_ff, 0xe4e0, 2, { 0, 0 }, 0 }, /* ROXRW */
{ NULL, op_e4e8_13_ff, 0xe4e8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ NULL, op_e4f0_13_ff, 0xe4f0, 4, { 4, 0 }, 0 }, /* ROXRW */
{ NULL, op_e4f8_13_ff, 0xe4f8, 4, { 0, 0 }, 0 }, /* ROXRW */
{ NULL, op_e4f9_13_ff, 0xe4f9, 6, { 0, 0 }, 0 }, /* ROXRW */
{ NULL, op_e5d0_13_ff, 0xe5d0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ NULL, op_e5d8_13_ff, 0xe5d8, 2, { 0, 0 }, 0 }, /* ROXLW */
{ NULL, op_e5e0_13_ff, 0xe5e0, 2, { 0, 0 }, 0 }, /* ROXLW */
{ NULL, op_e5e8_13_ff, 0xe5e8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ NULL, op_e5f0_13_ff, 0xe5f0, 4, { 4, 0 }, 0 }, /* ROXLW */
{ NULL, op_e5f8_13_ff, 0xe5f8, 4, { 0, 0 }, 0 }, /* ROXLW */
{ NULL, op_e5f9_13_ff, 0xe5f9, 6, { 0, 0 }, 0 }, /* ROXLW */
{ NULL, op_e6d0_13_ff, 0xe6d0, 2, { 0, 0 }, 0 }, /* RORW */
{ NULL, op_e6d8_13_ff, 0xe6d8, 2, { 0, 0 }, 0 }, /* RORW */
{ NULL, op_e6e0_13_ff, 0xe6e0, 2, { 0, 0 }, 0 }, /* RORW */
{ NULL, op_e6e8_13_ff, 0xe6e8, 4, { 0, 0 }, 0 }, /* RORW */
{ NULL, op_e6f0_13_ff, 0xe6f0, 4, { 4, 0 }, 0 }, /* RORW */
{ NULL, op_e6f8_13_ff, 0xe6f8, 4, { 0, 0 }, 0 }, /* RORW */
{ NULL, op_e6f9_13_ff, 0xe6f9, 6, { 0, 0 }, 0 }, /* RORW */
{ NULL, op_e7d0_13_ff, 0xe7d0, 2, { 0, 0 }, 0 }, /* ROLW */
{ NULL, op_e7d8_13_ff, 0xe7d8, 2, { 0, 0 }, 0 }, /* ROLW */
{ NULL, op_e7e0_13_ff, 0xe7e0, 2, { 0, 0 }, 0 }, /* ROLW */
{ NULL, op_e7e8_13_ff, 0xe7e8, 4, { 0, 0 }, 0 }, /* ROLW */
{ NULL, op_e7f0_13_ff, 0xe7f0, 4, { 4, 0 }, 0 }, /* ROLW */
{ NULL, op_e7f8_13_ff, 0xe7f8, 4, { 0, 0 }, 0 }, /* ROLW */
{ NULL, op_e7f9_13_ff, 0xe7f9, 6, { 0, 0 }, 0 }, /* ROLW */
{ NULL, NULL, 0, 0, { 0, 0 }, 0 } };
#endif /* CPUEMU_13 */
const struct cputbl op_smalltbl_14[] = {
{ NULL, op_0000_14_ff, 0x0000, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0010_14_ff, 0x0010, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0018_14_ff, 0x0018, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0020_14_ff, 0x0020, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0028_14_ff, 0x0028, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0030_14_ff, 0x0030, 6, { 4, 0 }, 0 }, /* OR */
{ NULL, op_0038_14_ff, 0x0038, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0039_14_ff, 0x0039, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_003c_14_ff, 0x003c, 4, { 0, 0 }, 0 }, /* ORSR */
{ NULL, op_0040_14_ff, 0x0040, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0050_14_ff, 0x0050, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0058_14_ff, 0x0058, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0060_14_ff, 0x0060, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0068_14_ff, 0x0068, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0070_14_ff, 0x0070, 6, { 4, 0 }, 0 }, /* OR */
{ NULL, op_0078_14_ff, 0x0078, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0079_14_ff, 0x0079, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_007c_14_ff, 0x007c, 4, { 0, 0 }, 0 }, /* ORSR */
{ NULL, op_0080_14_ff, 0x0080, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0090_14_ff, 0x0090, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0098_14_ff, 0x0098, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00a0_14_ff, 0x00a0, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00a8_14_ff, 0x00a8, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00b0_14_ff, 0x00b0, 8, { 4, 0 }, 0 }, /* OR */
{ NULL, op_00b8_14_ff, 0x00b8, 8, { 0, 0 }, 0 }, /* OR */
{ NULL, op_00b9_14_ff, 0x00b9, 10, { 0, 0 }, 0 }, /* OR */
{ NULL, op_0100_14_ff, 0x0100, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0108_14_ff, 0x0108, 4, { 0, 0 }, 0 }, /* MVPMR */
{ NULL, op_0110_14_ff, 0x0110, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0118_14_ff, 0x0118, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0120_14_ff, 0x0120, 2, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0128_14_ff, 0x0128, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0130_14_ff, 0x0130, 4, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_0138_14_ff, 0x0138, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0139_14_ff, 0x0139, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_013a_14_ff, 0x013a, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_013b_14_ff, 0x013b, 4, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_013c_14_ff, 0x013c, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0140_14_ff, 0x0140, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0148_14_ff, 0x0148, 4, { 0, 0 }, 0 }, /* MVPMR */
{ NULL, op_0150_14_ff, 0x0150, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0158_14_ff, 0x0158, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0160_14_ff, 0x0160, 2, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0168_14_ff, 0x0168, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0170_14_ff, 0x0170, 4, { 4, 0 }, 0 }, /* BCHG */
{ NULL, op_0178_14_ff, 0x0178, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0179_14_ff, 0x0179, 6, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0180_14_ff, 0x0180, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0188_14_ff, 0x0188, 4, { 0, 0 }, 0 }, /* MVPRM */
{ NULL, op_0190_14_ff, 0x0190, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0198_14_ff, 0x0198, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01a0_14_ff, 0x01a0, 2, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01a8_14_ff, 0x01a8, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01b0_14_ff, 0x01b0, 4, { 4, 0 }, 0 }, /* BCLR */
{ NULL, op_01b8_14_ff, 0x01b8, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01b9_14_ff, 0x01b9, 6, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_01c0_14_ff, 0x01c0, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01c8_14_ff, 0x01c8, 4, { 0, 0 }, 0 }, /* MVPRM */
{ NULL, op_01d0_14_ff, 0x01d0, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01d8_14_ff, 0x01d8, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01e0_14_ff, 0x01e0, 2, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01e8_14_ff, 0x01e8, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01f0_14_ff, 0x01f0, 4, { 4, 0 }, 0 }, /* BSET */
{ NULL, op_01f8_14_ff, 0x01f8, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_01f9_14_ff, 0x01f9, 6, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_0200_14_ff, 0x0200, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0210_14_ff, 0x0210, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0218_14_ff, 0x0218, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0220_14_ff, 0x0220, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0228_14_ff, 0x0228, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0230_14_ff, 0x0230, 6, { 4, 0 }, 0 }, /* AND */
{ NULL, op_0238_14_ff, 0x0238, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0239_14_ff, 0x0239, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_023c_14_ff, 0x023c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ NULL, op_0240_14_ff, 0x0240, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0250_14_ff, 0x0250, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0258_14_ff, 0x0258, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0260_14_ff, 0x0260, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0268_14_ff, 0x0268, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0270_14_ff, 0x0270, 6, { 4, 0 }, 0 }, /* AND */
{ NULL, op_0278_14_ff, 0x0278, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0279_14_ff, 0x0279, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_027c_14_ff, 0x027c, 4, { 0, 0 }, 0 }, /* ANDSR */
{ NULL, op_0280_14_ff, 0x0280, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0290_14_ff, 0x0290, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0298_14_ff, 0x0298, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02a0_14_ff, 0x02a0, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02a8_14_ff, 0x02a8, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02b0_14_ff, 0x02b0, 8, { 4, 0 }, 0 }, /* AND */
{ NULL, op_02b8_14_ff, 0x02b8, 8, { 0, 0 }, 0 }, /* AND */
{ NULL, op_02b9_14_ff, 0x02b9, 10, { 0, 0 }, 0 }, /* AND */
{ NULL, op_0400_14_ff, 0x0400, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0410_14_ff, 0x0410, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0418_14_ff, 0x0418, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0420_14_ff, 0x0420, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0428_14_ff, 0x0428, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0430_14_ff, 0x0430, 6, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_0438_14_ff, 0x0438, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0439_14_ff, 0x0439, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0440_14_ff, 0x0440, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0450_14_ff, 0x0450, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0458_14_ff, 0x0458, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0460_14_ff, 0x0460, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0468_14_ff, 0x0468, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0470_14_ff, 0x0470, 6, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_0478_14_ff, 0x0478, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0479_14_ff, 0x0479, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0480_14_ff, 0x0480, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0490_14_ff, 0x0490, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0498_14_ff, 0x0498, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04a0_14_ff, 0x04a0, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04a8_14_ff, 0x04a8, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04b0_14_ff, 0x04b0, 8, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_04b8_14_ff, 0x04b8, 8, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_04b9_14_ff, 0x04b9, 10, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_0600_14_ff, 0x0600, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0610_14_ff, 0x0610, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0618_14_ff, 0x0618, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0620_14_ff, 0x0620, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0628_14_ff, 0x0628, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0630_14_ff, 0x0630, 6, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_0638_14_ff, 0x0638, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0639_14_ff, 0x0639, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0640_14_ff, 0x0640, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0650_14_ff, 0x0650, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0658_14_ff, 0x0658, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0660_14_ff, 0x0660, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0668_14_ff, 0x0668, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0670_14_ff, 0x0670, 6, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_0678_14_ff, 0x0678, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0679_14_ff, 0x0679, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0680_14_ff, 0x0680, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0690_14_ff, 0x0690, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0698_14_ff, 0x0698, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06a0_14_ff, 0x06a0, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06a8_14_ff, 0x06a8, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06b0_14_ff, 0x06b0, 8, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_06b8_14_ff, 0x06b8, 8, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_06b9_14_ff, 0x06b9, 10, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_0800_14_ff, 0x0800, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0810_14_ff, 0x0810, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0818_14_ff, 0x0818, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0820_14_ff, 0x0820, 4, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0828_14_ff, 0x0828, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0830_14_ff, 0x0830, 6, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_0838_14_ff, 0x0838, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_0839_14_ff, 0x0839, 8, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_083a_14_ff, 0x083a, 6, { 0, 0 }, 0 }, /* BTST */
{ NULL, op_083b_14_ff, 0x083b, 6, { 4, 0 }, 0 }, /* BTST */
{ NULL, op_0840_14_ff, 0x0840, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0850_14_ff, 0x0850, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0858_14_ff, 0x0858, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0860_14_ff, 0x0860, 4, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0868_14_ff, 0x0868, 6, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0870_14_ff, 0x0870, 6, { 4, 0 }, 0 }, /* BCHG */
{ NULL, op_0878_14_ff, 0x0878, 6, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0879_14_ff, 0x0879, 8, { 0, 0 }, 0 }, /* BCHG */
{ NULL, op_0880_14_ff, 0x0880, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0890_14_ff, 0x0890, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_0898_14_ff, 0x0898, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08a0_14_ff, 0x08a0, 4, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08a8_14_ff, 0x08a8, 6, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08b0_14_ff, 0x08b0, 6, { 4, 0 }, 0 }, /* BCLR */
{ NULL, op_08b8_14_ff, 0x08b8, 6, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08b9_14_ff, 0x08b9, 8, { 0, 0 }, 0 }, /* BCLR */
{ NULL, op_08c0_14_ff, 0x08c0, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08d0_14_ff, 0x08d0, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08d8_14_ff, 0x08d8, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08e0_14_ff, 0x08e0, 4, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08e8_14_ff, 0x08e8, 6, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08f0_14_ff, 0x08f0, 6, { 4, 0 }, 0 }, /* BSET */
{ NULL, op_08f8_14_ff, 0x08f8, 6, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_08f9_14_ff, 0x08f9, 8, { 0, 0 }, 0 }, /* BSET */
{ NULL, op_0a00_14_ff, 0x0a00, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a10_14_ff, 0x0a10, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a18_14_ff, 0x0a18, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a20_14_ff, 0x0a20, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a28_14_ff, 0x0a28, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a30_14_ff, 0x0a30, 6, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_0a38_14_ff, 0x0a38, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a39_14_ff, 0x0a39, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a3c_14_ff, 0x0a3c, 4, { 0, 0 }, 0 }, /* EORSR */
{ NULL, op_0a40_14_ff, 0x0a40, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a50_14_ff, 0x0a50, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a58_14_ff, 0x0a58, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a60_14_ff, 0x0a60, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a68_14_ff, 0x0a68, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a70_14_ff, 0x0a70, 6, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_0a78_14_ff, 0x0a78, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a79_14_ff, 0x0a79, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a7c_14_ff, 0x0a7c, 4, { 0, 0 }, 0 }, /* EORSR */
{ NULL, op_0a80_14_ff, 0x0a80, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a90_14_ff, 0x0a90, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0a98_14_ff, 0x0a98, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0aa0_14_ff, 0x0aa0, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0aa8_14_ff, 0x0aa8, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0ab0_14_ff, 0x0ab0, 8, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_0ab8_14_ff, 0x0ab8, 8, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0ab9_14_ff, 0x0ab9, 10, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_0c00_14_ff, 0x0c00, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c10_14_ff, 0x0c10, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c18_14_ff, 0x0c18, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c20_14_ff, 0x0c20, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c28_14_ff, 0x0c28, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c30_14_ff, 0x0c30, 6, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_0c38_14_ff, 0x0c38, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c39_14_ff, 0x0c39, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c40_14_ff, 0x0c40, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c50_14_ff, 0x0c50, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c58_14_ff, 0x0c58, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c60_14_ff, 0x0c60, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c68_14_ff, 0x0c68, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c70_14_ff, 0x0c70, 6, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_0c78_14_ff, 0x0c78, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c79_14_ff, 0x0c79, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c80_14_ff, 0x0c80, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c90_14_ff, 0x0c90, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0c98_14_ff, 0x0c98, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0ca0_14_ff, 0x0ca0, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0ca8_14_ff, 0x0ca8, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0cb0_14_ff, 0x0cb0, 8, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_0cb8_14_ff, 0x0cb8, 8, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_0cb9_14_ff, 0x0cb9, 10, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_1000_14_ff, 0x1000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1010_14_ff, 0x1010, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1018_14_ff, 0x1018, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1020_14_ff, 0x1020, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1028_14_ff, 0x1028, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1030_14_ff, 0x1030, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1038_14_ff, 0x1038, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1039_14_ff, 0x1039, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_103a_14_ff, 0x103a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_103b_14_ff, 0x103b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_103c_14_ff, 0x103c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1080_14_ff, 0x1080, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1090_14_ff, 0x1090, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1098_14_ff, 0x1098, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10a0_14_ff, 0x10a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10a8_14_ff, 0x10a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10b0_14_ff, 0x10b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10b8_14_ff, 0x10b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10b9_14_ff, 0x10b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10ba_14_ff, 0x10ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10bb_14_ff, 0x10bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10bc_14_ff, 0x10bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10c0_14_ff, 0x10c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10d0_14_ff, 0x10d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10d8_14_ff, 0x10d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10e0_14_ff, 0x10e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10e8_14_ff, 0x10e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10f0_14_ff, 0x10f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10f8_14_ff, 0x10f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10f9_14_ff, 0x10f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10fa_14_ff, 0x10fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_10fb_14_ff, 0x10fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_10fc_14_ff, 0x10fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1100_14_ff, 0x1100, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1110_14_ff, 0x1110, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1118_14_ff, 0x1118, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1120_14_ff, 0x1120, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1128_14_ff, 0x1128, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1130_14_ff, 0x1130, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1138_14_ff, 0x1138, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1139_14_ff, 0x1139, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_113a_14_ff, 0x113a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_113b_14_ff, 0x113b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_113c_14_ff, 0x113c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1140_14_ff, 0x1140, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1150_14_ff, 0x1150, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1158_14_ff, 0x1158, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1160_14_ff, 0x1160, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1168_14_ff, 0x1168, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1170_14_ff, 0x1170, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_1178_14_ff, 0x1178, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1179_14_ff, 0x1179, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_117a_14_ff, 0x117a, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_117b_14_ff, 0x117b, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_117c_14_ff, 0x117c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_1180_14_ff, 0x1180, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1190_14_ff, 0x1190, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_1198_14_ff, 0x1198, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11a0_14_ff, 0x11a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11a8_14_ff, 0x11a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11b0_14_ff, 0x11b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_11b8_14_ff, 0x11b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11b9_14_ff, 0x11b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11ba_14_ff, 0x11ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11bb_14_ff, 0x11bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_11bc_14_ff, 0x11bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_11c0_14_ff, 0x11c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11d0_14_ff, 0x11d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11d8_14_ff, 0x11d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11e0_14_ff, 0x11e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11e8_14_ff, 0x11e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11f0_14_ff, 0x11f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_11f8_14_ff, 0x11f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11f9_14_ff, 0x11f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11fa_14_ff, 0x11fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_11fb_14_ff, 0x11fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_11fc_14_ff, 0x11fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13c0_14_ff, 0x13c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13d0_14_ff, 0x13d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13d8_14_ff, 0x13d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13e0_14_ff, 0x13e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13e8_14_ff, 0x13e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13f0_14_ff, 0x13f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_13f8_14_ff, 0x13f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13f9_14_ff, 0x13f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13fa_14_ff, 0x13fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_13fb_14_ff, 0x13fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_13fc_14_ff, 0x13fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2000_14_ff, 0x2000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2008_14_ff, 0x2008, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2010_14_ff, 0x2010, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2018_14_ff, 0x2018, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2020_14_ff, 0x2020, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2028_14_ff, 0x2028, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2030_14_ff, 0x2030, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2038_14_ff, 0x2038, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2039_14_ff, 0x2039, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_203a_14_ff, 0x203a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_203b_14_ff, 0x203b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_203c_14_ff, 0x203c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2040_14_ff, 0x2040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2048_14_ff, 0x2048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2050_14_ff, 0x2050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2058_14_ff, 0x2058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2060_14_ff, 0x2060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2068_14_ff, 0x2068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2070_14_ff, 0x2070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_2078_14_ff, 0x2078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2079_14_ff, 0x2079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_207a_14_ff, 0x207a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_207b_14_ff, 0x207b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_207c_14_ff, 0x207c, 6, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_2080_14_ff, 0x2080, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2088_14_ff, 0x2088, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2090_14_ff, 0x2090, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2098_14_ff, 0x2098, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20a0_14_ff, 0x20a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20a8_14_ff, 0x20a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20b0_14_ff, 0x20b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20b8_14_ff, 0x20b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20b9_14_ff, 0x20b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20ba_14_ff, 0x20ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20bb_14_ff, 0x20bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20bc_14_ff, 0x20bc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20c0_14_ff, 0x20c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20c8_14_ff, 0x20c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20d0_14_ff, 0x20d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20d8_14_ff, 0x20d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20e0_14_ff, 0x20e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20e8_14_ff, 0x20e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20f0_14_ff, 0x20f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20f8_14_ff, 0x20f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20f9_14_ff, 0x20f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20fa_14_ff, 0x20fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_20fb_14_ff, 0x20fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_20fc_14_ff, 0x20fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2100_14_ff, 0x2100, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2108_14_ff, 0x2108, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2110_14_ff, 0x2110, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2118_14_ff, 0x2118, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2120_14_ff, 0x2120, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2128_14_ff, 0x2128, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2130_14_ff, 0x2130, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2138_14_ff, 0x2138, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2139_14_ff, 0x2139, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_213a_14_ff, 0x213a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_213b_14_ff, 0x213b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_213c_14_ff, 0x213c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2140_14_ff, 0x2140, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2148_14_ff, 0x2148, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2150_14_ff, 0x2150, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2158_14_ff, 0x2158, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2160_14_ff, 0x2160, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2168_14_ff, 0x2168, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2170_14_ff, 0x2170, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_2178_14_ff, 0x2178, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2179_14_ff, 0x2179, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_217a_14_ff, 0x217a, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_217b_14_ff, 0x217b, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_217c_14_ff, 0x217c, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_2180_14_ff, 0x2180, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2188_14_ff, 0x2188, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2190_14_ff, 0x2190, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_2198_14_ff, 0x2198, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21a0_14_ff, 0x21a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21a8_14_ff, 0x21a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21b0_14_ff, 0x21b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_21b8_14_ff, 0x21b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21b9_14_ff, 0x21b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21ba_14_ff, 0x21ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21bb_14_ff, 0x21bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_21bc_14_ff, 0x21bc, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_21c0_14_ff, 0x21c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21c8_14_ff, 0x21c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21d0_14_ff, 0x21d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21d8_14_ff, 0x21d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21e0_14_ff, 0x21e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21e8_14_ff, 0x21e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21f0_14_ff, 0x21f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_21f8_14_ff, 0x21f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21f9_14_ff, 0x21f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21fa_14_ff, 0x21fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_21fb_14_ff, 0x21fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_21fc_14_ff, 0x21fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23c0_14_ff, 0x23c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23c8_14_ff, 0x23c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23d0_14_ff, 0x23d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23d8_14_ff, 0x23d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23e0_14_ff, 0x23e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23e8_14_ff, 0x23e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23f0_14_ff, 0x23f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_23f8_14_ff, 0x23f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23f9_14_ff, 0x23f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23fa_14_ff, 0x23fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_23fb_14_ff, 0x23fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_23fc_14_ff, 0x23fc, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3000_14_ff, 0x3000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3008_14_ff, 0x3008, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3010_14_ff, 0x3010, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3018_14_ff, 0x3018, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3020_14_ff, 0x3020, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3028_14_ff, 0x3028, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3030_14_ff, 0x3030, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3038_14_ff, 0x3038, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3039_14_ff, 0x3039, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_303a_14_ff, 0x303a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_303b_14_ff, 0x303b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_303c_14_ff, 0x303c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3040_14_ff, 0x3040, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3048_14_ff, 0x3048, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3050_14_ff, 0x3050, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3058_14_ff, 0x3058, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3060_14_ff, 0x3060, 2, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3068_14_ff, 0x3068, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3070_14_ff, 0x3070, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_3078_14_ff, 0x3078, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3079_14_ff, 0x3079, 6, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_307a_14_ff, 0x307a, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_307b_14_ff, 0x307b, 4, { 4, 0 }, 0 }, /* MOVEA */
{ NULL, op_307c_14_ff, 0x307c, 4, { 0, 0 }, 0 }, /* MOVEA */
{ NULL, op_3080_14_ff, 0x3080, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3088_14_ff, 0x3088, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3090_14_ff, 0x3090, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3098_14_ff, 0x3098, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30a0_14_ff, 0x30a0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30a8_14_ff, 0x30a8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30b0_14_ff, 0x30b0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30b8_14_ff, 0x30b8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30b9_14_ff, 0x30b9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30ba_14_ff, 0x30ba, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30bb_14_ff, 0x30bb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30bc_14_ff, 0x30bc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30c0_14_ff, 0x30c0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30c8_14_ff, 0x30c8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30d0_14_ff, 0x30d0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30d8_14_ff, 0x30d8, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30e0_14_ff, 0x30e0, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30e8_14_ff, 0x30e8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30f0_14_ff, 0x30f0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30f8_14_ff, 0x30f8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30f9_14_ff, 0x30f9, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30fa_14_ff, 0x30fa, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_30fb_14_ff, 0x30fb, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_30fc_14_ff, 0x30fc, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3100_14_ff, 0x3100, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3108_14_ff, 0x3108, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3110_14_ff, 0x3110, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3118_14_ff, 0x3118, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3120_14_ff, 0x3120, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3128_14_ff, 0x3128, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3130_14_ff, 0x3130, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3138_14_ff, 0x3138, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3139_14_ff, 0x3139, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_313a_14_ff, 0x313a, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_313b_14_ff, 0x313b, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_313c_14_ff, 0x313c, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3140_14_ff, 0x3140, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3148_14_ff, 0x3148, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3150_14_ff, 0x3150, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3158_14_ff, 0x3158, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3160_14_ff, 0x3160, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3168_14_ff, 0x3168, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3170_14_ff, 0x3170, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_3178_14_ff, 0x3178, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3179_14_ff, 0x3179, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_317a_14_ff, 0x317a, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_317b_14_ff, 0x317b, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_317c_14_ff, 0x317c, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_3180_14_ff, 0x3180, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3188_14_ff, 0x3188, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3190_14_ff, 0x3190, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_3198_14_ff, 0x3198, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31a0_14_ff, 0x31a0, 4, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31a8_14_ff, 0x31a8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31b0_14_ff, 0x31b0, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_31b8_14_ff, 0x31b8, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31b9_14_ff, 0x31b9, 8, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31ba_14_ff, 0x31ba, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31bb_14_ff, 0x31bb, 6, { 6, 4 }, 0 }, /* MOVE */
{ NULL, op_31bc_14_ff, 0x31bc, 6, { 4, 0 }, 0 }, /* MOVE */
{ NULL, op_31c0_14_ff, 0x31c0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31c8_14_ff, 0x31c8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31d0_14_ff, 0x31d0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31d8_14_ff, 0x31d8, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31e0_14_ff, 0x31e0, 4, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31e8_14_ff, 0x31e8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31f0_14_ff, 0x31f0, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_31f8_14_ff, 0x31f8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31f9_14_ff, 0x31f9, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31fa_14_ff, 0x31fa, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_31fb_14_ff, 0x31fb, 6, { 6, 0 }, 0 }, /* MOVE */
{ NULL, op_31fc_14_ff, 0x31fc, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33c0_14_ff, 0x33c0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33c8_14_ff, 0x33c8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33d0_14_ff, 0x33d0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33d8_14_ff, 0x33d8, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33e0_14_ff, 0x33e0, 6, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33e8_14_ff, 0x33e8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33f0_14_ff, 0x33f0, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_33f8_14_ff, 0x33f8, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33f9_14_ff, 0x33f9, 10, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33fa_14_ff, 0x33fa, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_33fb_14_ff, 0x33fb, 8, { 8, 0 }, 0 }, /* MOVE */
{ NULL, op_33fc_14_ff, 0x33fc, 8, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_4000_14_ff, 0x4000, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4010_14_ff, 0x4010, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4018_14_ff, 0x4018, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4020_14_ff, 0x4020, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4028_14_ff, 0x4028, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4030_14_ff, 0x4030, 4, { 4, 0 }, 0 }, /* NEGX */
{ NULL, op_4038_14_ff, 0x4038, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4039_14_ff, 0x4039, 6, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4040_14_ff, 0x4040, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4050_14_ff, 0x4050, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4058_14_ff, 0x4058, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4060_14_ff, 0x4060, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4068_14_ff, 0x4068, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4070_14_ff, 0x4070, 4, { 4, 0 }, 0 }, /* NEGX */
{ NULL, op_4078_14_ff, 0x4078, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4079_14_ff, 0x4079, 6, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4080_14_ff, 0x4080, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4090_14_ff, 0x4090, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_4098_14_ff, 0x4098, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40a0_14_ff, 0x40a0, 2, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40a8_14_ff, 0x40a8, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40b0_14_ff, 0x40b0, 4, { 4, 0 }, 0 }, /* NEGX */
{ NULL, op_40b8_14_ff, 0x40b8, 4, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40b9_14_ff, 0x40b9, 6, { 0, 0 }, 0 }, /* NEGX */
{ NULL, op_40c0_14_ff, 0x40c0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40d0_14_ff, 0x40d0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40d8_14_ff, 0x40d8, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40e0_14_ff, 0x40e0, 2, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40e8_14_ff, 0x40e8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40f0_14_ff, 0x40f0, 4, { 4, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40f8_14_ff, 0x40f8, 4, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_40f9_14_ff, 0x40f9, 6, { 0, 0 }, 0 }, /* MVSR2 */
{ NULL, op_4180_14_ff, 0x4180, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_4190_14_ff, 0x4190, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_4198_14_ff, 0x4198, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41a0_14_ff, 0x41a0, 2, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41a8_14_ff, 0x41a8, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41b0_14_ff, 0x41b0, 4, { 4, 0 }, 0 }, /* CHK */
{ NULL, op_41b8_14_ff, 0x41b8, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41b9_14_ff, 0x41b9, 6, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41ba_14_ff, 0x41ba, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41bb_14_ff, 0x41bb, 4, { 4, 0 }, 0 }, /* CHK */
{ NULL, op_41bc_14_ff, 0x41bc, 4, { 0, 0 }, 0 }, /* CHK */
{ NULL, op_41d0_14_ff, 0x41d0, 2, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41e8_14_ff, 0x41e8, 4, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41f0_14_ff, 0x41f0, 4, { 4, 0 }, 0 }, /* LEA */
{ NULL, op_41f8_14_ff, 0x41f8, 4, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41f9_14_ff, 0x41f9, 6, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41fa_14_ff, 0x41fa, 4, { 0, 0 }, 0 }, /* LEA */
{ NULL, op_41fb_14_ff, 0x41fb, 4, { 4, 0 }, 0 }, /* LEA */
{ NULL, op_4200_14_ff, 0x4200, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4210_14_ff, 0x4210, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4218_14_ff, 0x4218, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4220_14_ff, 0x4220, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4228_14_ff, 0x4228, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4230_14_ff, 0x4230, 4, { 4, 0 }, 0 }, /* CLR */
{ NULL, op_4238_14_ff, 0x4238, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4239_14_ff, 0x4239, 6, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4240_14_ff, 0x4240, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4250_14_ff, 0x4250, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4258_14_ff, 0x4258, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4260_14_ff, 0x4260, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4268_14_ff, 0x4268, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4270_14_ff, 0x4270, 4, { 4, 0 }, 0 }, /* CLR */
{ NULL, op_4278_14_ff, 0x4278, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4279_14_ff, 0x4279, 6, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4280_14_ff, 0x4280, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4290_14_ff, 0x4290, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4298_14_ff, 0x4298, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42a0_14_ff, 0x42a0, 2, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42a8_14_ff, 0x42a8, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42b0_14_ff, 0x42b0, 4, { 4, 0 }, 0 }, /* CLR */
{ NULL, op_42b8_14_ff, 0x42b8, 4, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_42b9_14_ff, 0x42b9, 6, { 0, 0 }, 0 }, /* CLR */
{ NULL, op_4400_14_ff, 0x4400, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4410_14_ff, 0x4410, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4418_14_ff, 0x4418, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4420_14_ff, 0x4420, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4428_14_ff, 0x4428, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4430_14_ff, 0x4430, 4, { 4, 0 }, 0 }, /* NEG */
{ NULL, op_4438_14_ff, 0x4438, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4439_14_ff, 0x4439, 6, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4440_14_ff, 0x4440, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4450_14_ff, 0x4450, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4458_14_ff, 0x4458, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4460_14_ff, 0x4460, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4468_14_ff, 0x4468, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4470_14_ff, 0x4470, 4, { 4, 0 }, 0 }, /* NEG */
{ NULL, op_4478_14_ff, 0x4478, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4479_14_ff, 0x4479, 6, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4480_14_ff, 0x4480, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4490_14_ff, 0x4490, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_4498_14_ff, 0x4498, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44a0_14_ff, 0x44a0, 2, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44a8_14_ff, 0x44a8, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44b0_14_ff, 0x44b0, 4, { 4, 0 }, 0 }, /* NEG */
{ NULL, op_44b8_14_ff, 0x44b8, 4, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44b9_14_ff, 0x44b9, 6, { 0, 0 }, 0 }, /* NEG */
{ NULL, op_44c0_14_ff, 0x44c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44d0_14_ff, 0x44d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44d8_14_ff, 0x44d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44e0_14_ff, 0x44e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44e8_14_ff, 0x44e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44f0_14_ff, 0x44f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_44f8_14_ff, 0x44f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44f9_14_ff, 0x44f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44fa_14_ff, 0x44fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_44fb_14_ff, 0x44fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_44fc_14_ff, 0x44fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_4600_14_ff, 0x4600, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4610_14_ff, 0x4610, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4618_14_ff, 0x4618, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4620_14_ff, 0x4620, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4628_14_ff, 0x4628, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4630_14_ff, 0x4630, 4, { 4, 0 }, 0 }, /* NOT */
{ NULL, op_4638_14_ff, 0x4638, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4639_14_ff, 0x4639, 6, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4640_14_ff, 0x4640, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4650_14_ff, 0x4650, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4658_14_ff, 0x4658, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4660_14_ff, 0x4660, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4668_14_ff, 0x4668, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4670_14_ff, 0x4670, 4, { 4, 0 }, 0 }, /* NOT */
{ NULL, op_4678_14_ff, 0x4678, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4679_14_ff, 0x4679, 6, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4680_14_ff, 0x4680, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4690_14_ff, 0x4690, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_4698_14_ff, 0x4698, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46a0_14_ff, 0x46a0, 2, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46a8_14_ff, 0x46a8, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46b0_14_ff, 0x46b0, 4, { 4, 0 }, 0 }, /* NOT */
{ NULL, op_46b8_14_ff, 0x46b8, 4, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46b9_14_ff, 0x46b9, 6, { 0, 0 }, 0 }, /* NOT */
{ NULL, op_46c0_14_ff, 0x46c0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46d0_14_ff, 0x46d0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46d8_14_ff, 0x46d8, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46e0_14_ff, 0x46e0, 2, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46e8_14_ff, 0x46e8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46f0_14_ff, 0x46f0, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_46f8_14_ff, 0x46f8, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46f9_14_ff, 0x46f9, 6, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46fa_14_ff, 0x46fa, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_46fb_14_ff, 0x46fb, 4, { 4, 0 }, 0 }, /* MV2SR */
{ NULL, op_46fc_14_ff, 0x46fc, 4, { 0, 0 }, 0 }, /* MV2SR */
{ NULL, op_4800_14_ff, 0x4800, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4810_14_ff, 0x4810, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4818_14_ff, 0x4818, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4820_14_ff, 0x4820, 2, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4828_14_ff, 0x4828, 4, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4830_14_ff, 0x4830, 4, { 4, 0 }, 0 }, /* NBCD */
{ NULL, op_4838_14_ff, 0x4838, 4, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4839_14_ff, 0x4839, 6, { 0, 0 }, 0 }, /* NBCD */
{ NULL, op_4840_14_ff, 0x4840, 2, { 0, 0 }, 0 }, /* SWAP */
{ NULL, op_4850_14_ff, 0x4850, 2, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_4868_14_ff, 0x4868, 4, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_4870_14_ff, 0x4870, 4, { 4, 0 }, 0 }, /* PEA */
{ NULL, op_4878_14_ff, 0x4878, 4, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_4879_14_ff, 0x4879, 6, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_487a_14_ff, 0x487a, 4, { 0, 0 }, 0 }, /* PEA */
{ NULL, op_487b_14_ff, 0x487b, 4, { 4, 0 }, 0 }, /* PEA */
{ NULL, op_4880_14_ff, 0x4880, 2, { 0, 0 }, 0 }, /* EXT */
{ NULL, op_4890_14_ff, 0x4890, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48a0_14_ff, 0x48a0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48a8_14_ff, 0x48a8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48b0_14_ff, 0x48b0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ NULL, op_48b8_14_ff, 0x48b8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48b9_14_ff, 0x48b9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48c0_14_ff, 0x48c0, 2, { 0, 0 }, 0 }, /* EXT */
{ NULL, op_48d0_14_ff, 0x48d0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48e0_14_ff, 0x48e0, 4, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48e8_14_ff, 0x48e8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48f0_14_ff, 0x48f0, 6, { 4, 0 }, 0 }, /* MVMLE */
{ NULL, op_48f8_14_ff, 0x48f8, 6, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_48f9_14_ff, 0x48f9, 8, { 0, 0 }, 0 }, /* MVMLE */
{ NULL, op_4a00_14_ff, 0x4a00, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a10_14_ff, 0x4a10, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a18_14_ff, 0x4a18, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a20_14_ff, 0x4a20, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a28_14_ff, 0x4a28, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a30_14_ff, 0x4a30, 4, { 4, 0 }, 0 }, /* TST */
{ NULL, op_4a38_14_ff, 0x4a38, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a39_14_ff, 0x4a39, 6, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a40_14_ff, 0x4a40, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a50_14_ff, 0x4a50, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a58_14_ff, 0x4a58, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a60_14_ff, 0x4a60, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a68_14_ff, 0x4a68, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a70_14_ff, 0x4a70, 4, { 4, 0 }, 0 }, /* TST */
{ NULL, op_4a78_14_ff, 0x4a78, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a79_14_ff, 0x4a79, 6, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a80_14_ff, 0x4a80, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a90_14_ff, 0x4a90, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4a98_14_ff, 0x4a98, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4aa0_14_ff, 0x4aa0, 2, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4aa8_14_ff, 0x4aa8, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4ab0_14_ff, 0x4ab0, 4, { 4, 0 }, 0 }, /* TST */
{ NULL, op_4ab8_14_ff, 0x4ab8, 4, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4ab9_14_ff, 0x4ab9, 6, { 0, 0 }, 0 }, /* TST */
{ NULL, op_4ac0_14_ff, 0x4ac0, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ad0_14_ff, 0x4ad0, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ad8_14_ff, 0x4ad8, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ae0_14_ff, 0x4ae0, 2, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4ae8_14_ff, 0x4ae8, 4, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4af0_14_ff, 0x4af0, 4, { 4, 0 }, 0 }, /* TAS */
{ NULL, op_4af8_14_ff, 0x4af8, 4, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4af9_14_ff, 0x4af9, 6, { 0, 0 }, 0 }, /* TAS */
{ NULL, op_4c90_14_ff, 0x4c90, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4c98_14_ff, 0x4c98, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4ca8_14_ff, 0x4ca8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cb0_14_ff, 0x4cb0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cb8_14_ff, 0x4cb8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cb9_14_ff, 0x4cb9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cba_14_ff, 0x4cba, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cbb_14_ff, 0x4cbb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cd0_14_ff, 0x4cd0, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cd8_14_ff, 0x4cd8, 4, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4ce8_14_ff, 0x4ce8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cf0_14_ff, 0x4cf0, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cf8_14_ff, 0x4cf8, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cf9_14_ff, 0x4cf9, 8, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cfa_14_ff, 0x4cfa, 6, { 0, 0 }, 0 }, /* MVMEL */
{ NULL, op_4cfb_14_ff, 0x4cfb, 6, { 4, 0 }, 0 }, /* MVMEL */
{ NULL, op_4e40_13_ff, 0x4e40, 2, { 0, 0 }, 0 }, /* TRAP */
{ NULL, op_4e50_14_ff, 0x4e50, 4, { 0, 0 }, 0 }, /* LINK */
{ NULL, op_4e58_14_ff, 0x4e58, 2, { 0, 0 }, 0 }, /* UNLK */
{ NULL, op_4e60_14_ff, 0x4e60, 2, { 0, 0 }, 0 }, /* MVR2USP */
{ NULL, op_4e68_14_ff, 0x4e68, 2, { 0, 0 }, 0 }, /* MVUSP2R */
{ NULL, op_4e70_14_ff, 0x4e70, 2, { 0, 0 }, 0 }, /* RESET */
{ NULL, op_4e71_14_ff, 0x4e71, 2, { 0, 0 }, 0 }, /* NOP */
{ NULL, op_4e72_14_ff, 0x4e72, 0, { 0, 0 }, 0 }, /* STOP */
{ NULL, op_4e73_14_ff, 0x4e73, 2, { 0, 0 }, 1 }, /* RTE */
{ NULL, op_4e75_14_ff, 0x4e75, 2, { 0, 0 }, 1 }, /* RTS */
{ NULL, op_4e76_14_ff, 0x4e76, 2, { 0, 0 }, 0 }, /* TRAPV */
{ NULL, op_4e77_14_ff, 0x4e77, 2, { 0, 0 }, 1 }, /* RTR */
{ NULL, op_4e90_14_ff, 0x4e90, 2, { 0, 0 }, 1 }, /* JSR */
{ NULL, op_4ea8_14_ff, 0x4ea8, 4, { 0, 0 }, 2 }, /* JSR */
{ NULL, op_4eb0_14_ff, 0x4eb0, 2, { 2, 0 }, 1 }, /* JSR */
{ NULL, op_4eb8_14_ff, 0x4eb8, 4, { 0, 0 }, 2 }, /* JSR */
{ NULL, op_4eb9_14_ff, 0x4eb9, 6, { 0, 0 }, 3 }, /* JSR */
{ NULL, op_4eba_14_ff, 0x4eba, 4, { 0, 0 }, 2 }, /* JSR */
{ NULL, op_4ebb_14_ff, 0x4ebb, 2, { 2, 0 }, 1 }, /* JSR */
{ NULL, op_4ed0_14_ff, 0x4ed0, 2, { 0, 0 }, 1 }, /* JMP */
{ NULL, op_4ee8_14_ff, 0x4ee8, 4, { 0, 0 }, 2 }, /* JMP */
{ NULL, op_4ef0_14_ff, 0x4ef0, 2, { 2, 0 }, 1 }, /* JMP */
{ NULL, op_4ef8_14_ff, 0x4ef8, 4, { 0, 0 }, 2 }, /* JMP */
{ NULL, op_4ef9_14_ff, 0x4ef9, 6, { 0, 0 }, 3 }, /* JMP */
{ NULL, op_4efa_14_ff, 0x4efa, 4, { 0, 0 }, 2 }, /* JMP */
{ NULL, op_4efb_14_ff, 0x4efb, 2, { 2, 0 }, 1 }, /* JMP */
{ NULL, op_5000_14_ff, 0x5000, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5010_14_ff, 0x5010, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5018_14_ff, 0x5018, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5020_14_ff, 0x5020, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5028_14_ff, 0x5028, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5030_14_ff, 0x5030, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_5038_14_ff, 0x5038, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5039_14_ff, 0x5039, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5040_14_ff, 0x5040, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5048_14_ff, 0x5048, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_5050_14_ff, 0x5050, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5058_14_ff, 0x5058, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5060_14_ff, 0x5060, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5068_14_ff, 0x5068, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5070_14_ff, 0x5070, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_5078_14_ff, 0x5078, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5079_14_ff, 0x5079, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5080_14_ff, 0x5080, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5088_14_ff, 0x5088, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_5090_14_ff, 0x5090, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_5098_14_ff, 0x5098, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50a0_14_ff, 0x50a0, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50a8_14_ff, 0x50a8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50b0_14_ff, 0x50b0, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_50b8_14_ff, 0x50b8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50b9_14_ff, 0x50b9, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_50c0_14_ff, 0x50c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50c8_14_ff, 0x50c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_50d0_14_ff, 0x50d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50d8_14_ff, 0x50d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50e0_14_ff, 0x50e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50e8_14_ff, 0x50e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50f0_14_ff, 0x50f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_50f8_14_ff, 0x50f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_50f9_14_ff, 0x50f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5100_14_ff, 0x5100, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5110_14_ff, 0x5110, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5118_14_ff, 0x5118, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5120_14_ff, 0x5120, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5128_14_ff, 0x5128, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5130_14_ff, 0x5130, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_5138_14_ff, 0x5138, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5139_14_ff, 0x5139, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5140_14_ff, 0x5140, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5148_14_ff, 0x5148, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_5150_14_ff, 0x5150, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5158_14_ff, 0x5158, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5160_14_ff, 0x5160, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5168_14_ff, 0x5168, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5170_14_ff, 0x5170, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_5178_14_ff, 0x5178, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5179_14_ff, 0x5179, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5180_14_ff, 0x5180, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5188_14_ff, 0x5188, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_5190_14_ff, 0x5190, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_5198_14_ff, 0x5198, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51a0_14_ff, 0x51a0, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51a8_14_ff, 0x51a8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51b0_14_ff, 0x51b0, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_51b8_14_ff, 0x51b8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51b9_14_ff, 0x51b9, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_51c0_14_ff, 0x51c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51c8_14_ff, 0x51c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_51d0_14_ff, 0x51d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51d8_14_ff, 0x51d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51e0_14_ff, 0x51e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51e8_14_ff, 0x51e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51f0_14_ff, 0x51f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_51f8_14_ff, 0x51f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_51f9_14_ff, 0x51f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52c0_14_ff, 0x52c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52c8_14_ff, 0x52c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_52d0_14_ff, 0x52d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52d8_14_ff, 0x52d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52e0_14_ff, 0x52e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52e8_14_ff, 0x52e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52f0_14_ff, 0x52f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_52f8_14_ff, 0x52f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_52f9_14_ff, 0x52f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53c0_14_ff, 0x53c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53c8_14_ff, 0x53c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_53d0_14_ff, 0x53d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53d8_14_ff, 0x53d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53e0_14_ff, 0x53e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53e8_14_ff, 0x53e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53f0_14_ff, 0x53f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_53f8_14_ff, 0x53f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_53f9_14_ff, 0x53f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54c0_14_ff, 0x54c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54c8_14_ff, 0x54c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_54d0_14_ff, 0x54d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54d8_14_ff, 0x54d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54e0_14_ff, 0x54e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54e8_14_ff, 0x54e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54f0_14_ff, 0x54f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_54f8_14_ff, 0x54f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_54f9_14_ff, 0x54f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55c0_14_ff, 0x55c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55c8_14_ff, 0x55c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_55d0_14_ff, 0x55d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55d8_14_ff, 0x55d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55e0_14_ff, 0x55e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55e8_14_ff, 0x55e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55f0_14_ff, 0x55f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_55f8_14_ff, 0x55f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_55f9_14_ff, 0x55f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56c0_14_ff, 0x56c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56c8_14_ff, 0x56c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_56d0_14_ff, 0x56d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56d8_14_ff, 0x56d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56e0_14_ff, 0x56e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56e8_14_ff, 0x56e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56f0_14_ff, 0x56f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_56f8_14_ff, 0x56f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_56f9_14_ff, 0x56f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57c0_14_ff, 0x57c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57c8_14_ff, 0x57c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_57d0_14_ff, 0x57d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57d8_14_ff, 0x57d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57e0_14_ff, 0x57e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57e8_14_ff, 0x57e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57f0_14_ff, 0x57f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_57f8_14_ff, 0x57f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_57f9_14_ff, 0x57f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58c0_14_ff, 0x58c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58c8_14_ff, 0x58c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_58d0_14_ff, 0x58d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58d8_14_ff, 0x58d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58e0_14_ff, 0x58e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58e8_14_ff, 0x58e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58f0_14_ff, 0x58f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_58f8_14_ff, 0x58f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_58f9_14_ff, 0x58f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59c0_14_ff, 0x59c0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59c8_14_ff, 0x59c8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_59d0_14_ff, 0x59d0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59d8_14_ff, 0x59d8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59e0_14_ff, 0x59e0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59e8_14_ff, 0x59e8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59f0_14_ff, 0x59f0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_59f8_14_ff, 0x59f8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_59f9_14_ff, 0x59f9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ac0_14_ff, 0x5ac0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ac8_14_ff, 0x5ac8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5ad0_14_ff, 0x5ad0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ad8_14_ff, 0x5ad8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ae0_14_ff, 0x5ae0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ae8_14_ff, 0x5ae8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5af0_14_ff, 0x5af0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5af8_14_ff, 0x5af8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5af9_14_ff, 0x5af9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bc0_14_ff, 0x5bc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bc8_14_ff, 0x5bc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5bd0_14_ff, 0x5bd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bd8_14_ff, 0x5bd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5be0_14_ff, 0x5be0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5be8_14_ff, 0x5be8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bf0_14_ff, 0x5bf0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5bf8_14_ff, 0x5bf8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5bf9_14_ff, 0x5bf9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cc0_14_ff, 0x5cc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cc8_14_ff, 0x5cc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5cd0_14_ff, 0x5cd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cd8_14_ff, 0x5cd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ce0_14_ff, 0x5ce0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ce8_14_ff, 0x5ce8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cf0_14_ff, 0x5cf0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5cf8_14_ff, 0x5cf8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5cf9_14_ff, 0x5cf9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5dc0_14_ff, 0x5dc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5dc8_14_ff, 0x5dc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5dd0_14_ff, 0x5dd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5dd8_14_ff, 0x5dd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5de0_14_ff, 0x5de0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5de8_14_ff, 0x5de8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5df0_14_ff, 0x5df0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5df8_14_ff, 0x5df8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5df9_14_ff, 0x5df9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ec0_14_ff, 0x5ec0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ec8_14_ff, 0x5ec8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5ed0_14_ff, 0x5ed0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ed8_14_ff, 0x5ed8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ee0_14_ff, 0x5ee0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ee8_14_ff, 0x5ee8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ef0_14_ff, 0x5ef0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5ef8_14_ff, 0x5ef8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ef9_14_ff, 0x5ef9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fc0_14_ff, 0x5fc0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fc8_14_ff, 0x5fc8, 4, { 0, 0 }, -2 }, /* DBcc */
{ NULL, op_5fd0_14_ff, 0x5fd0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fd8_14_ff, 0x5fd8, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fe0_14_ff, 0x5fe0, 2, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5fe8_14_ff, 0x5fe8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ff0_14_ff, 0x5ff0, 4, { 4, 0 }, 0 }, /* Scc */
{ NULL, op_5ff8_14_ff, 0x5ff8, 4, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_5ff9_14_ff, 0x5ff9, 6, { 0, 0 }, 0 }, /* Scc */
{ NULL, op_6000_14_ff, 0x6000, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6001_14_ff, 0x6001, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_60ff_14_ff, 0x60ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6100_14_ff, 0x6100, 4, { 0, 0 }, 2 }, /* BSR */
{ NULL, op_6101_14_ff, 0x6101, 2, { 0, 0 }, 1 }, /* BSR */
{ NULL, op_61ff_14_ff, 0x61ff, 2, { 0, 0 }, 1 }, /* BSR */
{ NULL, op_6200_14_ff, 0x6200, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6201_14_ff, 0x6201, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_62ff_14_ff, 0x62ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6300_14_ff, 0x6300, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6301_14_ff, 0x6301, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_63ff_14_ff, 0x63ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6400_14_ff, 0x6400, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6401_14_ff, 0x6401, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_64ff_14_ff, 0x64ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6500_14_ff, 0x6500, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6501_14_ff, 0x6501, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_65ff_14_ff, 0x65ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6600_14_ff, 0x6600, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6601_14_ff, 0x6601, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_66ff_14_ff, 0x66ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6700_14_ff, 0x6700, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6701_14_ff, 0x6701, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_67ff_14_ff, 0x67ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6800_14_ff, 0x6800, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6801_14_ff, 0x6801, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_68ff_14_ff, 0x68ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6900_14_ff, 0x6900, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6901_14_ff, 0x6901, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_69ff_14_ff, 0x69ff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6a00_14_ff, 0x6a00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6a01_14_ff, 0x6a01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6aff_14_ff, 0x6aff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6b00_14_ff, 0x6b00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6b01_14_ff, 0x6b01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6bff_14_ff, 0x6bff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6c00_14_ff, 0x6c00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6c01_14_ff, 0x6c01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6cff_14_ff, 0x6cff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6d00_14_ff, 0x6d00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6d01_14_ff, 0x6d01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6dff_14_ff, 0x6dff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6e00_14_ff, 0x6e00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6e01_14_ff, 0x6e01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6eff_14_ff, 0x6eff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_6f00_14_ff, 0x6f00, 4, { 0, 0 }, -2 }, /* Bcc */
{ NULL, op_6f01_14_ff, 0x6f01, 2, { 0, 0 }, -1 }, /* Bcc */
{ NULL, op_6fff_14_ff, 0x6fff, 2, { 0, 0 }, 0 }, /* Bcc */
{ NULL, op_7000_14_ff, 0x7000, 2, { 0, 0 }, 0 }, /* MOVE */
{ NULL, op_8000_14_ff, 0x8000, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8010_14_ff, 0x8010, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8018_14_ff, 0x8018, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8020_14_ff, 0x8020, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8028_14_ff, 0x8028, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8030_14_ff, 0x8030, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8038_14_ff, 0x8038, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8039_14_ff, 0x8039, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_803a_14_ff, 0x803a, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_803b_14_ff, 0x803b, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_803c_14_ff, 0x803c, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8040_14_ff, 0x8040, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8050_14_ff, 0x8050, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8058_14_ff, 0x8058, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8060_14_ff, 0x8060, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8068_14_ff, 0x8068, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8070_14_ff, 0x8070, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8078_14_ff, 0x8078, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8079_14_ff, 0x8079, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_807a_14_ff, 0x807a, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_807b_14_ff, 0x807b, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_807c_14_ff, 0x807c, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8080_14_ff, 0x8080, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8090_14_ff, 0x8090, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8098_14_ff, 0x8098, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80a0_14_ff, 0x80a0, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80a8_14_ff, 0x80a8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80b0_14_ff, 0x80b0, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_80b8_14_ff, 0x80b8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80b9_14_ff, 0x80b9, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80ba_14_ff, 0x80ba, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80bb_14_ff, 0x80bb, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_80bc_14_ff, 0x80bc, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_80c0_14_ff, 0x80c0, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80d0_14_ff, 0x80d0, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80d8_14_ff, 0x80d8, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80e0_14_ff, 0x80e0, 2, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80e8_14_ff, 0x80e8, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80f0_14_ff, 0x80f0, 4, { 4, 0 }, 0 }, /* DIVU */
{ NULL, op_80f8_14_ff, 0x80f8, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80f9_14_ff, 0x80f9, 6, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80fa_14_ff, 0x80fa, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_80fb_14_ff, 0x80fb, 4, { 4, 0 }, 0 }, /* DIVU */
{ NULL, op_80fc_14_ff, 0x80fc, 4, { 0, 0 }, 0 }, /* DIVU */
{ NULL, op_8100_14_ff, 0x8100, 2, { 0, 0 }, 0 }, /* SBCD */
{ NULL, op_8108_14_ff, 0x8108, 2, { 0, 0 }, 0 }, /* SBCD */
{ NULL, op_8110_14_ff, 0x8110, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8118_14_ff, 0x8118, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8120_14_ff, 0x8120, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8128_14_ff, 0x8128, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8130_14_ff, 0x8130, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8138_14_ff, 0x8138, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8139_14_ff, 0x8139, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8150_14_ff, 0x8150, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8158_14_ff, 0x8158, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8160_14_ff, 0x8160, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8168_14_ff, 0x8168, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8170_14_ff, 0x8170, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_8178_14_ff, 0x8178, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8179_14_ff, 0x8179, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8190_14_ff, 0x8190, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_8198_14_ff, 0x8198, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81a0_14_ff, 0x81a0, 2, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81a8_14_ff, 0x81a8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81b0_14_ff, 0x81b0, 4, { 4, 0 }, 0 }, /* OR */
{ NULL, op_81b8_14_ff, 0x81b8, 4, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81b9_14_ff, 0x81b9, 6, { 0, 0 }, 0 }, /* OR */
{ NULL, op_81c0_14_ff, 0x81c0, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81d0_14_ff, 0x81d0, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81d8_14_ff, 0x81d8, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81e0_14_ff, 0x81e0, 2, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81e8_14_ff, 0x81e8, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81f0_14_ff, 0x81f0, 4, { 4, 0 }, 0 }, /* DIVS */
{ NULL, op_81f8_14_ff, 0x81f8, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81f9_14_ff, 0x81f9, 6, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81fa_14_ff, 0x81fa, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_81fb_14_ff, 0x81fb, 4, { 4, 0 }, 0 }, /* DIVS */
{ NULL, op_81fc_14_ff, 0x81fc, 4, { 0, 0 }, 0 }, /* DIVS */
{ NULL, op_9000_14_ff, 0x9000, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9010_14_ff, 0x9010, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9018_14_ff, 0x9018, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9020_14_ff, 0x9020, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9028_14_ff, 0x9028, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9030_14_ff, 0x9030, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9038_14_ff, 0x9038, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9039_14_ff, 0x9039, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_903a_14_ff, 0x903a, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_903b_14_ff, 0x903b, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_903c_14_ff, 0x903c, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9040_14_ff, 0x9040, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9048_14_ff, 0x9048, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9050_14_ff, 0x9050, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9058_14_ff, 0x9058, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9060_14_ff, 0x9060, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9068_14_ff, 0x9068, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9070_14_ff, 0x9070, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9078_14_ff, 0x9078, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9079_14_ff, 0x9079, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_907a_14_ff, 0x907a, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_907b_14_ff, 0x907b, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_907c_14_ff, 0x907c, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9080_14_ff, 0x9080, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9088_14_ff, 0x9088, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9090_14_ff, 0x9090, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9098_14_ff, 0x9098, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90a0_14_ff, 0x90a0, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90a8_14_ff, 0x90a8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90b0_14_ff, 0x90b0, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_90b8_14_ff, 0x90b8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90b9_14_ff, 0x90b9, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90ba_14_ff, 0x90ba, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90bb_14_ff, 0x90bb, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_90bc_14_ff, 0x90bc, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_90c0_14_ff, 0x90c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90c8_14_ff, 0x90c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90d0_14_ff, 0x90d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90d8_14_ff, 0x90d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90e0_14_ff, 0x90e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90e8_14_ff, 0x90e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90f0_14_ff, 0x90f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_90f8_14_ff, 0x90f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90f9_14_ff, 0x90f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90fa_14_ff, 0x90fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_90fb_14_ff, 0x90fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_90fc_14_ff, 0x90fc, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_9100_14_ff, 0x9100, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9108_14_ff, 0x9108, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9110_14_ff, 0x9110, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9118_14_ff, 0x9118, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9120_14_ff, 0x9120, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9128_14_ff, 0x9128, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9130_14_ff, 0x9130, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9138_14_ff, 0x9138, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9139_14_ff, 0x9139, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9140_14_ff, 0x9140, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9148_14_ff, 0x9148, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9150_14_ff, 0x9150, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9158_14_ff, 0x9158, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9160_14_ff, 0x9160, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9168_14_ff, 0x9168, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9170_14_ff, 0x9170, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_9178_14_ff, 0x9178, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9179_14_ff, 0x9179, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9180_14_ff, 0x9180, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9188_14_ff, 0x9188, 2, { 0, 0 }, 0 }, /* SUBX */
{ NULL, op_9190_14_ff, 0x9190, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_9198_14_ff, 0x9198, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91a0_14_ff, 0x91a0, 2, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91a8_14_ff, 0x91a8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91b0_14_ff, 0x91b0, 4, { 4, 0 }, 0 }, /* SUB */
{ NULL, op_91b8_14_ff, 0x91b8, 4, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91b9_14_ff, 0x91b9, 6, { 0, 0 }, 0 }, /* SUB */
{ NULL, op_91c0_14_ff, 0x91c0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91c8_14_ff, 0x91c8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91d0_14_ff, 0x91d0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91d8_14_ff, 0x91d8, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91e0_14_ff, 0x91e0, 2, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91e8_14_ff, 0x91e8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91f0_14_ff, 0x91f0, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_91f8_14_ff, 0x91f8, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91f9_14_ff, 0x91f9, 6, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91fa_14_ff, 0x91fa, 4, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_91fb_14_ff, 0x91fb, 4, { 4, 0 }, 0 }, /* SUBA */
{ NULL, op_91fc_14_ff, 0x91fc, 6, { 0, 0 }, 0 }, /* SUBA */
{ NULL, op_b000_14_ff, 0xb000, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b010_14_ff, 0xb010, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b018_14_ff, 0xb018, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b020_14_ff, 0xb020, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b028_14_ff, 0xb028, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b030_14_ff, 0xb030, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b038_14_ff, 0xb038, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b039_14_ff, 0xb039, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b03a_14_ff, 0xb03a, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b03b_14_ff, 0xb03b, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b03c_14_ff, 0xb03c, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b040_14_ff, 0xb040, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b048_14_ff, 0xb048, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b050_14_ff, 0xb050, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b058_14_ff, 0xb058, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b060_14_ff, 0xb060, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b068_14_ff, 0xb068, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b070_14_ff, 0xb070, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b078_14_ff, 0xb078, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b079_14_ff, 0xb079, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b07a_14_ff, 0xb07a, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b07b_14_ff, 0xb07b, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b07c_14_ff, 0xb07c, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b080_14_ff, 0xb080, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b088_14_ff, 0xb088, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b090_14_ff, 0xb090, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b098_14_ff, 0xb098, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0a0_14_ff, 0xb0a0, 2, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0a8_14_ff, 0xb0a8, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0b0_14_ff, 0xb0b0, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b0b8_14_ff, 0xb0b8, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0b9_14_ff, 0xb0b9, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0ba_14_ff, 0xb0ba, 4, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0bb_14_ff, 0xb0bb, 4, { 4, 0 }, 0 }, /* CMP */
{ NULL, op_b0bc_14_ff, 0xb0bc, 6, { 0, 0 }, 0 }, /* CMP */
{ NULL, op_b0c0_14_ff, 0xb0c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0c8_14_ff, 0xb0c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0d0_14_ff, 0xb0d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0d8_14_ff, 0xb0d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0e0_14_ff, 0xb0e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0e8_14_ff, 0xb0e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0f0_14_ff, 0xb0f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b0f8_14_ff, 0xb0f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0f9_14_ff, 0xb0f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0fa_14_ff, 0xb0fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b0fb_14_ff, 0xb0fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b0fc_14_ff, 0xb0fc, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b100_14_ff, 0xb100, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b108_14_ff, 0xb108, 2, { 0, 0 }, 0 }, /* CMPM */
{ NULL, op_b110_14_ff, 0xb110, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b118_14_ff, 0xb118, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b120_14_ff, 0xb120, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b128_14_ff, 0xb128, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b130_14_ff, 0xb130, 4, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_b138_14_ff, 0xb138, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b139_14_ff, 0xb139, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b140_14_ff, 0xb140, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b148_14_ff, 0xb148, 2, { 0, 0 }, 0 }, /* CMPM */
{ NULL, op_b150_14_ff, 0xb150, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b158_14_ff, 0xb158, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b160_14_ff, 0xb160, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b168_14_ff, 0xb168, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b170_14_ff, 0xb170, 4, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_b178_14_ff, 0xb178, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b179_14_ff, 0xb179, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b180_14_ff, 0xb180, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b188_14_ff, 0xb188, 2, { 0, 0 }, 0 }, /* CMPM */
{ NULL, op_b190_14_ff, 0xb190, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b198_14_ff, 0xb198, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1a0_14_ff, 0xb1a0, 2, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1a8_14_ff, 0xb1a8, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1b0_14_ff, 0xb1b0, 4, { 4, 0 }, 0 }, /* EOR */
{ NULL, op_b1b8_14_ff, 0xb1b8, 4, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1b9_14_ff, 0xb1b9, 6, { 0, 0 }, 0 }, /* EOR */
{ NULL, op_b1c0_14_ff, 0xb1c0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1c8_14_ff, 0xb1c8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1d0_14_ff, 0xb1d0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1d8_14_ff, 0xb1d8, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1e0_14_ff, 0xb1e0, 2, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1e8_14_ff, 0xb1e8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1f0_14_ff, 0xb1f0, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b1f8_14_ff, 0xb1f8, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1f9_14_ff, 0xb1f9, 6, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1fa_14_ff, 0xb1fa, 4, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_b1fb_14_ff, 0xb1fb, 4, { 4, 0 }, 0 }, /* CMPA */
{ NULL, op_b1fc_14_ff, 0xb1fc, 6, { 0, 0 }, 0 }, /* CMPA */
{ NULL, op_c000_14_ff, 0xc000, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c010_14_ff, 0xc010, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c018_14_ff, 0xc018, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c020_14_ff, 0xc020, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c028_14_ff, 0xc028, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c030_14_ff, 0xc030, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c038_14_ff, 0xc038, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c039_14_ff, 0xc039, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c03a_14_ff, 0xc03a, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c03b_14_ff, 0xc03b, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c03c_14_ff, 0xc03c, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c040_14_ff, 0xc040, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c050_14_ff, 0xc050, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c058_14_ff, 0xc058, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c060_14_ff, 0xc060, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c068_14_ff, 0xc068, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c070_14_ff, 0xc070, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c078_14_ff, 0xc078, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c079_14_ff, 0xc079, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c07a_14_ff, 0xc07a, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c07b_14_ff, 0xc07b, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c07c_14_ff, 0xc07c, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c080_14_ff, 0xc080, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c090_14_ff, 0xc090, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c098_14_ff, 0xc098, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0a0_14_ff, 0xc0a0, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0a8_14_ff, 0xc0a8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0b0_14_ff, 0xc0b0, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c0b8_14_ff, 0xc0b8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0b9_14_ff, 0xc0b9, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0ba_14_ff, 0xc0ba, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0bb_14_ff, 0xc0bb, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c0bc_14_ff, 0xc0bc, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c0c0_14_ff, 0xc0c0, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0d0_14_ff, 0xc0d0, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0d8_14_ff, 0xc0d8, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0e0_14_ff, 0xc0e0, 2, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0e8_14_ff, 0xc0e8, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0f0_14_ff, 0xc0f0, 4, { 4, 0 }, 0 }, /* MULU */
{ NULL, op_c0f8_14_ff, 0xc0f8, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0f9_14_ff, 0xc0f9, 6, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0fa_14_ff, 0xc0fa, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c0fb_14_ff, 0xc0fb, 4, { 4, 0 }, 0 }, /* MULU */
{ NULL, op_c0fc_14_ff, 0xc0fc, 4, { 0, 0 }, 0 }, /* MULU */
{ NULL, op_c100_14_ff, 0xc100, 2, { 0, 0 }, 0 }, /* ABCD */
{ NULL, op_c108_14_ff, 0xc108, 2, { 0, 0 }, 0 }, /* ABCD */
{ NULL, op_c110_14_ff, 0xc110, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c118_14_ff, 0xc118, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c120_14_ff, 0xc120, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c128_14_ff, 0xc128, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c130_14_ff, 0xc130, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c138_14_ff, 0xc138, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c139_14_ff, 0xc139, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c140_14_ff, 0xc140, 2, { 0, 0 }, 0 }, /* EXG */
{ NULL, op_c148_14_ff, 0xc148, 2, { 0, 0 }, 0 }, /* EXG */
{ NULL, op_c150_14_ff, 0xc150, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c158_14_ff, 0xc158, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c160_14_ff, 0xc160, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c168_14_ff, 0xc168, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c170_14_ff, 0xc170, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c178_14_ff, 0xc178, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c179_14_ff, 0xc179, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c188_14_ff, 0xc188, 2, { 0, 0 }, 0 }, /* EXG */
{ NULL, op_c190_14_ff, 0xc190, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c198_14_ff, 0xc198, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1a0_14_ff, 0xc1a0, 2, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1a8_14_ff, 0xc1a8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1b0_14_ff, 0xc1b0, 4, { 4, 0 }, 0 }, /* AND */
{ NULL, op_c1b8_14_ff, 0xc1b8, 4, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1b9_14_ff, 0xc1b9, 6, { 0, 0 }, 0 }, /* AND */
{ NULL, op_c1c0_14_ff, 0xc1c0, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1d0_14_ff, 0xc1d0, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1d8_14_ff, 0xc1d8, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1e0_14_ff, 0xc1e0, 2, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1e8_14_ff, 0xc1e8, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1f0_14_ff, 0xc1f0, 4, { 4, 0 }, 0 }, /* MULS */
{ NULL, op_c1f8_14_ff, 0xc1f8, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1f9_14_ff, 0xc1f9, 6, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1fa_14_ff, 0xc1fa, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_c1fb_14_ff, 0xc1fb, 4, { 4, 0 }, 0 }, /* MULS */
{ NULL, op_c1fc_14_ff, 0xc1fc, 4, { 0, 0 }, 0 }, /* MULS */
{ NULL, op_d000_14_ff, 0xd000, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d010_14_ff, 0xd010, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d018_14_ff, 0xd018, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d020_14_ff, 0xd020, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d028_14_ff, 0xd028, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d030_14_ff, 0xd030, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d038_14_ff, 0xd038, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d039_14_ff, 0xd039, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d03a_14_ff, 0xd03a, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d03b_14_ff, 0xd03b, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d03c_14_ff, 0xd03c, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d040_14_ff, 0xd040, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d048_14_ff, 0xd048, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d050_14_ff, 0xd050, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d058_14_ff, 0xd058, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d060_14_ff, 0xd060, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d068_14_ff, 0xd068, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d070_14_ff, 0xd070, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d078_14_ff, 0xd078, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d079_14_ff, 0xd079, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d07a_14_ff, 0xd07a, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d07b_14_ff, 0xd07b, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d07c_14_ff, 0xd07c, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d080_14_ff, 0xd080, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d088_14_ff, 0xd088, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d090_14_ff, 0xd090, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d098_14_ff, 0xd098, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0a0_14_ff, 0xd0a0, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0a8_14_ff, 0xd0a8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0b0_14_ff, 0xd0b0, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d0b8_14_ff, 0xd0b8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0b9_14_ff, 0xd0b9, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0ba_14_ff, 0xd0ba, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0bb_14_ff, 0xd0bb, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d0bc_14_ff, 0xd0bc, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d0c0_14_ff, 0xd0c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0c8_14_ff, 0xd0c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0d0_14_ff, 0xd0d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0d8_14_ff, 0xd0d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0e0_14_ff, 0xd0e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0e8_14_ff, 0xd0e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0f0_14_ff, 0xd0f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d0f8_14_ff, 0xd0f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0f9_14_ff, 0xd0f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0fa_14_ff, 0xd0fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d0fb_14_ff, 0xd0fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d0fc_14_ff, 0xd0fc, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d100_14_ff, 0xd100, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d108_14_ff, 0xd108, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d110_14_ff, 0xd110, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d118_14_ff, 0xd118, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d120_14_ff, 0xd120, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d128_14_ff, 0xd128, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d130_14_ff, 0xd130, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d138_14_ff, 0xd138, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d139_14_ff, 0xd139, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d140_14_ff, 0xd140, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d148_14_ff, 0xd148, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d150_14_ff, 0xd150, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d158_14_ff, 0xd158, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d160_14_ff, 0xd160, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d168_14_ff, 0xd168, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d170_14_ff, 0xd170, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d178_14_ff, 0xd178, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d179_14_ff, 0xd179, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d180_14_ff, 0xd180, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d188_14_ff, 0xd188, 2, { 0, 0 }, 0 }, /* ADDX */
{ NULL, op_d190_14_ff, 0xd190, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d198_14_ff, 0xd198, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1a0_14_ff, 0xd1a0, 2, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1a8_14_ff, 0xd1a8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1b0_14_ff, 0xd1b0, 4, { 4, 0 }, 0 }, /* ADD */
{ NULL, op_d1b8_14_ff, 0xd1b8, 4, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1b9_14_ff, 0xd1b9, 6, { 0, 0 }, 0 }, /* ADD */
{ NULL, op_d1c0_14_ff, 0xd1c0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1c8_14_ff, 0xd1c8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1d0_14_ff, 0xd1d0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1d8_14_ff, 0xd1d8, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1e0_14_ff, 0xd1e0, 2, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1e8_14_ff, 0xd1e8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1f0_14_ff, 0xd1f0, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d1f8_14_ff, 0xd1f8, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1f9_14_ff, 0xd1f9, 6, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1fa_14_ff, 0xd1fa, 4, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_d1fb_14_ff, 0xd1fb, 4, { 4, 0 }, 0 }, /* ADDA */
{ NULL, op_d1fc_14_ff, 0xd1fc, 6, { 0, 0 }, 0 }, /* ADDA */
{ NULL, op_e000_14_ff, 0xe000, 2, { 0, 0 }, 0 }, /* ASR */
{ 