/* gpx-graph.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-graph.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gpx.h"
#include <pango/pango.h>
#include <cairo-gobject.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pangocairo.h>

#define GPX_LOG_DOMAIN "GPX_GRAPH"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GPX_GRAPH_0_PROPERTY,
	GPX_GRAPH_SMOOTH_FACTOR_PROPERTY,
	GPX_GRAPH_SHOW_POINTS_PROPERTY,
	GPX_GRAPH_MODE_PROPERTY,
	GPX_GRAPH_NUM_PROPERTIES
};
static GParamSpec* gpx_graph_properties[GPX_GRAPH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
enum  {
	GPX_GRAPH_POINT_CLICKED_SIGNAL,
	GPX_GRAPH_SELECTION_CHANGED_SIGNAL,
	GPX_GRAPH_NUM_SIGNALS
};
static guint gpx_graph_signals[GPX_GRAPH_NUM_SIGNALS] = {0};

struct _GpxGraphPrivate {
	GpxPoint* start;
	GpxPoint* stop;
	GpxPoint* selected;
	gboolean _do_miles;
	GpxGraphGraphMode _mode;
	gint _smooth_factor;
	gboolean _show_points;
	PangoFontDescription* fd;
	cairo_surface_t* surf;
	gint LEFT_OFFSET;
	gint RIGHT_OFFSET;
	gint BOTTOM_OFFSET;
	time_t highlight;
	GpxPoint* draw_current;
};

static gint GpxGraph_private_offset;
static gpointer gpx_graph_parent_class = NULL;
static gchar** gpx_graph_GraphModeName;
static gint gpx_graph_GraphModeName_length1;
static gchar** gpx_graph_GraphModeName = NULL;
static gint gpx_graph_GraphModeName_length1 = 0;
static gint _gpx_graph_GraphModeName_size_ = 0;
static gchar** gpx_graph_GraphModeMiles;
static gint gpx_graph_GraphModeMiles_length1;
static gchar** gpx_graph_GraphModeMiles = NULL;
static gint gpx_graph_GraphModeMiles_length1 = 0;
static gint _gpx_graph_GraphModeMiles_size_ = 0;

static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void gpx_graph_size_allocate_cb (GpxGraph* self,
                                 GtkAllocation* alloc);
static void _gpx_graph_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                           GtkAllocation* allocation,
                                                           gpointer self);
static gboolean gpx_graph_button_press_event_cb (GpxGraph* self,
                                          GdkEventButton* event);
static gboolean _gpx_graph_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
static gboolean gpx_graph_motion_notify_event_cb (GpxGraph* self,
                                           GdkEventMotion* event);
static gboolean _gpx_graph_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                           GdkEventMotion* event,
                                                                           gpointer self);
static gboolean gpx_graph_button_release_event_cb (GpxGraph* self,
                                            GdkEventButton* event);
static gboolean _gpx_graph_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self);
static gboolean gpx_graph_a_expose_event (GpxGraph* self,
                                   cairo_t* ctx);
static gboolean _gpx_graph_a_expose_event_gtk_widget_draw (GtkWidget* _sender,
                                                    cairo_t* cr,
                                                    gpointer self);
static GpxPoint* gpx_graph_get_point_from_position (GpxGraph* self,
                                             gdouble x,
                                             gdouble y);
static void ______lambda4_ (GpxGraph* self);
static void _______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self);
static void ______lambda5_ (GpxGraph* self);
static void _______lambda5__gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self);
static void gpx_graph_update_surface (GpxGraph* self,
                               GtkWidget* win);
static void gpx_graph_draw_grid (GpxGraph* self,
                          cairo_t* ctx,
                          PangoLayout* layout,
                          gdouble graph_width,
                          gdouble graph_height,
                          gdouble min_value,
                          gdouble max_value,
                          gdouble elapsed_time);
static gdouble gpx_graph_calculate_graph_point_value (GpxGraph* self,
                                               GList* ii);
static gdouble gpx_graph_calculate_graph_point_smooth_value (GpxGraph* self,
                                                      GList* iter);
static void g_cclosure_user_marshal_VOID__GPX_POINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_GPX_POINT_GPX_POINT (GClosure * closure,
                                                               GValue * return_value,
                                                               guint n_param_values,
                                                               const GValue * param_values,
                                                               gpointer invocation_hint,
                                                               gpointer marshal_data);
static void gpx_graph_finalize (GObject * obj);
static GType gpx_graph_get_type_once (void);
static void _vala_gpx_graph_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_gpx_graph_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gpx_graph_get_instance_private (GpxGraph* self)
{
	return G_STRUCT_MEMBER_P (self, GpxGraph_private_offset);
}

static GType
gpx_graph_graph_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GPX_GRAPH_GRAPH_MODE_SPEED, "GPX_GRAPH_GRAPH_MODE_SPEED", "speed"}, {GPX_GRAPH_GRAPH_MODE_ELEVATION, "GPX_GRAPH_GRAPH_MODE_ELEVATION", "elevation"}, {GPX_GRAPH_GRAPH_MODE_DISTANCE, "GPX_GRAPH_GRAPH_MODE_DISTANCE", "distance"}, {GPX_GRAPH_GRAPH_MODE_TOTAL_DISTANCE, "GPX_GRAPH_GRAPH_MODE_TOTAL_DISTANCE", "total-distance"}, {GPX_GRAPH_GRAPH_MODE_ACCELERATION_H, "GPX_GRAPH_GRAPH_MODE_ACCELERATION_H", "acceleration-h"}, {GPX_GRAPH_GRAPH_MODE_SPEED_V, "GPX_GRAPH_GRAPH_MODE_SPEED_V", "speed-v"}, {GPX_GRAPH_GRAPH_MODE_HEARTRATE, "GPX_GRAPH_GRAPH_MODE_HEARTRATE", "heartrate"}, {GPX_GRAPH_GRAPH_MODE_CADENCE, "GPX_GRAPH_GRAPH_MODE_CADENCE", "cadence"}, {GPX_GRAPH_GRAPH_MODE_NUM_GRAPH_MODES, "GPX_GRAPH_GRAPH_MODE_NUM_GRAPH_MODES", "num-graph-modes"}, {0, NULL, NULL}};
	GType gpx_graph_graph_mode_type_id;
	gpx_graph_graph_mode_type_id = g_enum_register_static ("GpxGraphGraphMode", values);
	return gpx_graph_graph_mode_type_id;
}

GType
gpx_graph_graph_mode_get_type (void)
{
	static volatile gsize gpx_graph_graph_mode_type_id__once = 0;
	if (g_once_init_enter (&gpx_graph_graph_mode_type_id__once)) {
		GType gpx_graph_graph_mode_type_id;
		gpx_graph_graph_mode_type_id = gpx_graph_graph_mode_get_type_once ();
		g_once_init_leave (&gpx_graph_graph_mode_type_id__once, gpx_graph_graph_mode_type_id);
	}
	return gpx_graph_graph_mode_type_id__once;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 73 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 207 "gpx-graph.c"
}

void
gpx_graph_hide_info (GpxGraph* self)
{
#line 85 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->draw_current = NULL;
#line 86 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 217 "gpx-graph.c"
}

void
gpx_graph_show_info (GpxGraph* self,
                     GpxPoint* cur_point)
{
#line 90 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->draw_current = cur_point;
#line 91 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 228 "gpx-graph.c"
}

/** 
 * @param p A Gpx.Point we want to highlight.
 * pass null to unhighlight.
 */
void
gpx_graph_highlight_point (GpxGraph* self,
                           GpxPoint* p)
{
	time_t _tmp0_ = 0;
	time_t pt = 0;
#line 100 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (p == NULL) {
#line 100 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp0_ = (time_t) 0;
#line 245 "gpx-graph.c"
	} else {
#line 100 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp0_ = gpx_point_get_time (p);
#line 249 "gpx-graph.c"
	}
#line 100 "../gpx-viewer/libgpx/gpx-graph.vala"
	pt = _tmp0_;
#line 101 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_set_highlight (self, pt);
#line 255 "gpx-graph.c"
}

void
gpx_graph_set_highlight (GpxGraph* self,
                         time_t highlight)
{
#line 104 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->highlight = highlight;
#line 106 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 266 "gpx-graph.c"
}

static void
_gpx_graph_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                      GtkAllocation* allocation,
                                                      gpointer self)
{
#line 153 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_size_allocate_cb ((GpxGraph*) self, allocation);
#line 276 "gpx-graph.c"
}

static gboolean
_gpx_graph_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = gpx_graph_button_press_event_cb ((GpxGraph*) self, event);
#line 154 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 288 "gpx-graph.c"
}

static gboolean
_gpx_graph_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                  GdkEventMotion* event,
                                                                  gpointer self)
{
	gboolean result;
	result = gpx_graph_motion_notify_event_cb ((GpxGraph*) self, event);
#line 155 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 300 "gpx-graph.c"
}

static gboolean
_gpx_graph_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                    GdkEventButton* event,
                                                                    gpointer self)
{
	gboolean result;
	result = gpx_graph_button_release_event_cb ((GpxGraph*) self, event);
#line 156 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 312 "gpx-graph.c"
}

static gboolean
_gpx_graph_a_expose_event_gtk_widget_draw (GtkWidget* _sender,
                                           cairo_t* cr,
                                           gpointer self)
{
	gboolean result;
	result = gpx_graph_a_expose_event ((GpxGraph*) self, cr);
#line 158 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 324 "gpx-graph.c"
}

GpxGraph*
gpx_graph_construct (GType object_type)
{
	GpxGraph * self = NULL;
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
#line 144 "../gpx-viewer/libgpx/gpx-graph.vala"
	self = (GpxGraph*) g_object_new (object_type, NULL);
#line 147 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = pango_font_description_new ();
#line 147 "../gpx-viewer/libgpx/gpx-graph.vala"
	__vala_PangoFontDescription_free0 (self->priv->fd);
#line 147 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->fd = _tmp0_;
#line 148 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = self->priv->fd;
#line 148 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_font_description_set_family (_tmp1_, "sans mono");
#line 150 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
#line 151 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_event_box_set_visible_window ((GtkEventBox*) self, TRUE);
#line 153 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _gpx_graph_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 154 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _gpx_graph_button_press_event_cb_gtk_widget_button_press_event, self, 0);
#line 155 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _gpx_graph_motion_notify_event_cb_gtk_widget_motion_notify_event, self, 0);
#line 156 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _gpx_graph_button_release_event_cb_gtk_widget_button_release_event, self, 0);
#line 158 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _gpx_graph_a_expose_event_gtk_widget_draw, self, 0);
#line 144 "../gpx-viewer/libgpx/gpx-graph.vala"
	return self;
#line 361 "gpx-graph.c"
}

GpxGraph*
gpx_graph_new (void)
{
#line 144 "../gpx-viewer/libgpx/gpx-graph.vala"
	return gpx_graph_construct (GPX_TYPE_GRAPH);
#line 369 "gpx-graph.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 164 "../gpx-viewer/libgpx/gpx-graph.vala"
	return self ? g_object_ref (self) : NULL;
#line 377 "gpx-graph.c"
}

void
gpx_graph_set_track (GpxGraph* self,
                     GpxTrack* track)
{
	GpxTrack* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GpxTrack* _tmp2_;
#line 163 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->highlight = (time_t) 0;
#line 164 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = _g_object_ref0 (track);
#line 164 "../gpx-viewer/libgpx/gpx-graph.vala"
	_g_object_unref0 (self->track);
#line 164 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->track = _tmp0_;
#line 166 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_surface_destroy0 (self->priv->surf);
#line 166 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->surf = NULL;
#line 168 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 169 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_point_unref0 (self->priv->start);
#line 169 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->start = NULL;
#line 170 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_point_unref0 (self->priv->stop);
#line 170 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->stop = NULL;
#line 172 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp2_ = self->track;
#line 172 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp2_ != NULL) {
#line 413 "gpx-graph.c"
		GpxTrack* _tmp3_;
		GList* _tmp4_;
#line 172 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = self->track;
#line 172 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = _tmp3_->points;
#line 172 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 422 "gpx-graph.c"
	} else {
#line 172 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp1_ = FALSE;
#line 426 "gpx-graph.c"
	}
#line 172 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp1_) {
#line 430 "gpx-graph.c"
		GpxTrack* _tmp5_;
		GpxTrack* _tmp6_;
		GList* _tmp7_;
		GList* _tmp8_;
		gconstpointer _tmp9_;
		GpxTrack* _tmp10_;
		GList* _tmp11_;
		GList* _tmp12_;
		gconstpointer _tmp13_;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = self->track;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp6_ = self->track;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp7_ = _tmp6_->points;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp8_ = g_list_first (_tmp7_);
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp9_ = _tmp8_->data;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp10_ = self->track;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp11_ = _tmp10_->points;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp12_ = g_list_last (_tmp11_);
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp13_ = _tmp12_->data;
#line 173 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp5_, (GpxPoint*) _tmp9_, (GpxPoint*) _tmp13_);
#line 460 "gpx-graph.c"
	} else {
		GpxTrack* _tmp14_;
#line 175 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp14_ = self->track;
#line 175 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp14_, NULL, NULL);
#line 467 "gpx-graph.c"
	}
}

/**
 * Private functions
 */
static gpointer
_gpx_point_ref0 (gpointer self)
{
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
	return self ? gpx_point_ref (self) : NULL;
#line 479 "gpx-graph.c"
}

static GpxPoint*
gpx_graph_get_point_from_position (GpxGraph* self,
                                   gdouble x,
                                   gdouble y)
{
	GtkAllocation alloc = {0};
	GpxTrack* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp7_;
	gboolean _tmp13_ = FALSE;
	GpxPoint* result;
#line 188 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->track;
#line 188 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ == NULL) {
#line 188 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = NULL;
#line 188 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 501 "gpx-graph.c"
	}
#line 189 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
#line 189 "../gpx-viewer/libgpx/gpx-graph.vala"
	alloc = _tmp1_;
#line 190 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (x <= ((gdouble) self->priv->LEFT_OFFSET)) {
#line 509 "gpx-graph.c"
		GpxTrack* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		GpxPoint* _tmp6_;
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp2_ = self->track;
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = _tmp2_->points;
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = g_list_first (_tmp3_);
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = _tmp4_->data;
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp6_ = _gpx_point_ref0 ((GpxPoint*) _tmp5_);
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = _tmp6_;
#line 192 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 529 "gpx-graph.c"
	}
#line 194 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_ = alloc;
#line 194 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (x >= ((gdouble) (_tmp7_.width - self->priv->RIGHT_OFFSET))) {
#line 535 "gpx-graph.c"
		GpxTrack* _tmp8_;
		GList* _tmp9_;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		GpxPoint* _tmp12_;
#line 196 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp8_ = self->track;
#line 196 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp9_ = _tmp8_->points;
#line 196 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp10_ = g_list_last (_tmp9_);
#line 196 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp11_ = _tmp10_->data;
#line 196 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp12_ = _gpx_point_ref0 ((GpxPoint*) _tmp11_);
#line 196 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = _tmp12_;
#line 196 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 555 "gpx-graph.c"
	}
#line 198 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (x > ((gdouble) self->priv->LEFT_OFFSET)) {
#line 559 "gpx-graph.c"
		GtkAllocation _tmp14_;
#line 198 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp14_ = alloc;
#line 198 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp13_ = x < ((gdouble) (_tmp14_.width - self->priv->RIGHT_OFFSET));
#line 565 "gpx-graph.c"
	} else {
#line 198 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp13_ = FALSE;
#line 569 "gpx-graph.c"
	}
#line 198 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp13_) {
#line 573 "gpx-graph.c"
		gdouble elapsed_time = 0.0;
		GpxTrack* _tmp15_;
		time_t time = 0;
		GtkAllocation _tmp16_;
		GList* iter = NULL;
		GpxTrack* _tmp17_;
		GList* _tmp18_;
		GList* _tmp19_;
		GList* _tmp20_;
		gconstpointer _tmp21_;
#line 200 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp15_ = self->track;
#line 200 "../gpx-viewer/libgpx/gpx-graph.vala"
		elapsed_time = (gdouble) gpx_track_get_total_time (_tmp15_);
#line 201 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp16_ = alloc;
#line 201 "../gpx-viewer/libgpx/gpx-graph.vala"
		time = (time_t) (((x - self->priv->LEFT_OFFSET) / ((_tmp16_.width - self->priv->RIGHT_OFFSET) - self->priv->LEFT_OFFSET)) * elapsed_time);
#line 202 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp17_ = self->track;
#line 202 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp18_ = _tmp17_->points;
#line 202 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp19_ = g_list_first (_tmp18_);
#line 202 "../gpx-viewer/libgpx/gpx-graph.vala"
		iter = _tmp19_;
#line 204 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp20_ = iter;
#line 204 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp21_ = _tmp20_->data;
#line 204 "../gpx-viewer/libgpx/gpx-graph.vala"
		time += gpx_point_get_time ((GpxPoint*) _tmp21_);
#line 205 "../gpx-viewer/libgpx/gpx-graph.vala"
		while (TRUE) {
#line 608 "gpx-graph.c"
			GList* _tmp22_;
			GList* _tmp23_;
			time_t next_time = 0;
			GList* _tmp24_;
			GList* _tmp25_;
			gconstpointer _tmp26_;
			time_t cur_time = 0;
			GList* _tmp27_;
			gconstpointer _tmp28_;
			time_t mid_next_time = 0;
			time_t mid_prev_time = 0;
			GList* _tmp29_;
			GList* _tmp30_;
			gboolean _tmp34_ = FALSE;
			GList* _tmp38_;
			GList* _tmp39_;
#line 205 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp22_ = iter;
#line 205 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp23_ = _tmp22_->next;
#line 205 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (!(_tmp23_ != NULL)) {
#line 205 "../gpx-viewer/libgpx/gpx-graph.vala"
				break;
#line 633 "gpx-graph.c"
			}
#line 207 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp24_ = iter;
#line 207 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp25_ = _tmp24_->next;
#line 207 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp26_ = _tmp25_->data;
#line 207 "../gpx-viewer/libgpx/gpx-graph.vala"
			next_time = gpx_point_get_time ((GpxPoint*) _tmp26_);
#line 208 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp27_ = iter;
#line 208 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp28_ = _tmp27_->data;
#line 208 "../gpx-viewer/libgpx/gpx-graph.vala"
			cur_time = gpx_point_get_time ((GpxPoint*) _tmp28_);
#line 209 "../gpx-viewer/libgpx/gpx-graph.vala"
			mid_next_time = (cur_time + next_time) / 2;
#line 210 "../gpx-viewer/libgpx/gpx-graph.vala"
			mid_prev_time = cur_time;
#line 212 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp29_ = iter;
#line 212 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp30_ = _tmp29_->prev;
#line 212 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp30_ != NULL) {
#line 659 "gpx-graph.c"
				time_t prev_time = 0;
				GList* _tmp31_;
				GList* _tmp32_;
				gconstpointer _tmp33_;
#line 213 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp31_ = iter;
#line 213 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp32_ = _tmp31_->prev;
#line 213 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp33_ = _tmp32_->data;
#line 213 "../gpx-viewer/libgpx/gpx-graph.vala"
				prev_time = gpx_point_get_time ((GpxPoint*) _tmp33_);
#line 214 "../gpx-viewer/libgpx/gpx-graph.vala"
				mid_prev_time = (prev_time + cur_time) / 2;
#line 674 "gpx-graph.c"
			}
#line 216 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (time >= mid_prev_time) {
#line 216 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp34_ = time <= mid_next_time;
#line 680 "gpx-graph.c"
			} else {
#line 216 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp34_ = FALSE;
#line 684 "gpx-graph.c"
			}
#line 216 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp34_) {
#line 688 "gpx-graph.c"
				GList* _tmp35_;
				gconstpointer _tmp36_;
				GpxPoint* _tmp37_;
#line 218 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp35_ = iter;
#line 218 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp36_ = _tmp35_->data;
#line 218 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp37_ = _gpx_point_ref0 ((GpxPoint*) _tmp36_);
#line 218 "../gpx-viewer/libgpx/gpx-graph.vala"
				result = _tmp37_;
#line 218 "../gpx-viewer/libgpx/gpx-graph.vala"
				return result;
#line 702 "gpx-graph.c"
			}
#line 220 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp38_ = iter;
#line 220 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp39_ = _tmp38_->next;
#line 220 "../gpx-viewer/libgpx/gpx-graph.vala"
			iter = _tmp39_;
#line 710 "gpx-graph.c"
		}
	}
#line 223 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = NULL;
#line 223 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 717 "gpx-graph.c"
}

gboolean
gpx_graph_select_next_point (GpxGraph* self)
{
	GpxPoint* _tmp0_;
	gint pos = 0;
	GpxTrack* _tmp6_;
	GList* _tmp7_;
	GpxPoint* _tmp8_;
	GpxTrack* _tmp9_;
	GList* _tmp10_;
	gboolean result;
#line 226 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->priv->selected;
#line 226 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ == NULL) {
#line 735 "gpx-graph.c"
		GpxTrack* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GpxPoint* _tmp5_;
#line 227 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp1_ = self->track;
#line 227 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp2_ = _tmp1_->points;
#line 227 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = g_list_first (_tmp2_);
#line 227 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = _tmp3_->data;
#line 227 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = _gpx_point_ref0 ((GpxPoint*) _tmp4_);
#line 227 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->selected);
#line 227 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->selected = _tmp5_;
#line 755 "gpx-graph.c"
	}
#line 229 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp6_ = self->track;
#line 229 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_ = _tmp6_->points;
#line 229 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp8_ = self->priv->selected;
#line 229 "../gpx-viewer/libgpx/gpx-graph.vala"
	pos = g_list_index (_tmp7_, _tmp8_);
#line 230 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp9_ = self->track;
#line 230 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp10_ = _tmp9_->points;
#line 230 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (((guint) pos) < (g_list_length (_tmp10_) - 1)) {
#line 771 "gpx-graph.c"
		GpxTrack* _tmp11_;
		GList* _tmp12_;
		gconstpointer _tmp13_;
		GpxPoint* _tmp14_;
		GpxPoint* _tmp15_;
#line 231 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp11_ = self->track;
#line 231 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp12_ = _tmp11_->points;
#line 231 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp13_ = g_list_nth_data (_tmp12_, (guint) (pos + 1));
#line 231 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp14_ = _gpx_point_ref0 ((GpxPoint*) _tmp13_);
#line 231 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->selected);
#line 231 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->selected = _tmp14_;
#line 232 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp15_ = self->priv->selected;
#line 232 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_POINT_CLICKED_SIGNAL], 0, _tmp15_);
#line 793 "gpx-graph.c"
	}
#line 234 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = TRUE;
#line 234 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 799 "gpx-graph.c"
}

gboolean
gpx_graph_select_prev_point (GpxGraph* self)
{
	GpxPoint* _tmp0_;
	gint pos = 0;
	GpxTrack* _tmp6_;
	GList* _tmp7_;
	GpxPoint* _tmp8_;
	gboolean result;
#line 237 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->priv->selected;
#line 237 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ == NULL) {
#line 815 "gpx-graph.c"
		GpxTrack* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GpxPoint* _tmp5_;
#line 238 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp1_ = self->track;
#line 238 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp2_ = _tmp1_->points;
#line 238 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = g_list_last (_tmp2_);
#line 238 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = _tmp3_->data;
#line 238 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = _gpx_point_ref0 ((GpxPoint*) _tmp4_);
#line 238 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->selected);
#line 238 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->selected = _tmp5_;
#line 835 "gpx-graph.c"
	}
#line 240 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp6_ = self->track;
#line 240 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_ = _tmp6_->points;
#line 240 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp8_ = self->priv->selected;
#line 240 "../gpx-viewer/libgpx/gpx-graph.vala"
	pos = g_list_index (_tmp7_, _tmp8_);
#line 241 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (pos > 0) {
#line 847 "gpx-graph.c"
		GpxTrack* _tmp9_;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		GpxPoint* _tmp12_;
		GpxPoint* _tmp13_;
#line 242 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp9_ = self->track;
#line 242 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp10_ = _tmp9_->points;
#line 242 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp11_ = g_list_nth_data (_tmp10_, (guint) (pos - 1));
#line 242 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp12_ = _gpx_point_ref0 ((GpxPoint*) _tmp11_);
#line 242 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->selected);
#line 242 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->selected = _tmp12_;
#line 243 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp13_ = self->priv->selected;
#line 243 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_POINT_CLICKED_SIGNAL], 0, _tmp13_);
#line 869 "gpx-graph.c"
	}
#line 245 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = TRUE;
#line 245 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 875 "gpx-graph.c"
}

void
gpx_graph_remove_selected (GpxGraph* self)
{
	gboolean _tmp0_ = FALSE;
	GpxPoint* _tmp1_;
#line 248 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = self->priv->start;
#line 248 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp1_ != NULL) {
#line 887 "gpx-graph.c"
		GpxPoint* _tmp2_;
#line 248 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp2_ = self->priv->stop;
#line 248 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 893 "gpx-graph.c"
	} else {
#line 248 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp0_ = FALSE;
#line 897 "gpx-graph.c"
	}
#line 248 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_) {
#line 901 "gpx-graph.c"
		gint start_pos = 0;
		GpxTrack* _tmp3_;
		GList* _tmp4_;
		GpxPoint* _tmp5_;
		gint end_pos = 0;
		GpxTrack* _tmp6_;
		GList* _tmp7_;
		GpxPoint* _tmp8_;
		GpxTrack* _tmp17_;
		GList* _tmp18_;
		gconstpointer _tmp19_;
		GpxPoint* _tmp20_;
#line 249 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = self->track;
#line 249 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = _tmp3_->points;
#line 249 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = self->priv->start;
#line 249 "../gpx-viewer/libgpx/gpx-graph.vala"
		start_pos = g_list_index (_tmp4_, _tmp5_);
#line 250 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp6_ = self->track;
#line 250 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp7_ = _tmp6_->points;
#line 250 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp8_ = self->priv->stop;
#line 250 "../gpx-viewer/libgpx/gpx-graph.vala"
		end_pos = g_list_index (_tmp7_, _tmp8_);
#line 251 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (end_pos < start_pos) {
#line 932 "gpx-graph.c"
			gint tmp_pos = 0;
#line 252 "../gpx-viewer/libgpx/gpx-graph.vala"
			tmp_pos = end_pos;
#line 253 "../gpx-viewer/libgpx/gpx-graph.vala"
			end_pos = start_pos;
#line 254 "../gpx-viewer/libgpx/gpx-graph.vala"
			start_pos = tmp_pos;
#line 940 "gpx-graph.c"
		}
		{
			gint i = 0;
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
			i = start_pos;
#line 946 "gpx-graph.c"
			{
				gboolean _tmp9_ = FALSE;
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp9_ = TRUE;
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
				while (TRUE) {
#line 953 "gpx-graph.c"
					GpxPoint* p = NULL;
					GpxTrack* _tmp11_;
					GList* _tmp12_;
					gconstpointer _tmp13_;
					GpxPoint* _tmp14_;
					GpxTrack* _tmp15_;
					GpxPoint* _tmp16_;
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (!_tmp9_) {
#line 963 "gpx-graph.c"
						gint _tmp10_;
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp10_ = i;
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
						i = _tmp10_ + 1;
#line 969 "gpx-graph.c"
					}
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp9_ = FALSE;
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (!(i < end_pos)) {
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
						break;
#line 977 "gpx-graph.c"
					}
#line 257 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp11_ = self->track;
#line 257 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp12_ = _tmp11_->points;
#line 257 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp13_ = g_list_nth_data (_tmp12_, (guint) start_pos);
#line 257 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp14_ = _gpx_point_ref0 ((GpxPoint*) _tmp13_);
#line 257 "../gpx-viewer/libgpx/gpx-graph.vala"
					p = _tmp14_;
#line 258 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp15_ = self->track;
#line 258 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp16_ = p;
#line 258 "../gpx-viewer/libgpx/gpx-graph.vala"
					gpx_track_remove_point (_tmp15_, _tmp16_, FALSE);
#line 256 "../gpx-viewer/libgpx/gpx-graph.vala"
					_gpx_point_unref0 (p);
#line 997 "gpx-graph.c"
				}
			}
		}
#line 260 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp17_ = self->track;
#line 260 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp18_ = _tmp17_->points;
#line 260 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp19_ = g_list_nth_data (_tmp18_, (guint) start_pos);
#line 260 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp20_ = _gpx_point_ref0 ((GpxPoint*) _tmp19_);
#line 260 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->selected);
#line 260 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->selected = _tmp20_;
#line 261 "../gpx-viewer/libgpx/gpx-graph.vala"
		gpx_graph_remove_selected_point (self);
#line 1015 "gpx-graph.c"
	} else {
		GpxPoint* _tmp21_;
#line 262 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp21_ = self->priv->selected;
#line 262 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp21_ != NULL) {
#line 263 "../gpx-viewer/libgpx/gpx-graph.vala"
			gpx_graph_remove_selected_point (self);
#line 1024 "gpx-graph.c"
		}
	}
}

void
gpx_graph_remove_selected_point (GpxGraph* self)
{
	GpxPoint* _tmp0_;
#line 267 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->priv->selected;
#line 267 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ != NULL) {
#line 1037 "gpx-graph.c"
		gint pos = 0;
		GpxTrack* _tmp1_;
		GList* _tmp2_;
		GpxPoint* _tmp3_;
		guint last = 0U;
		GpxTrack* _tmp4_;
		GList* _tmp5_;
		GpxTrack* _tmp7_;
		GpxPoint* _tmp8_;
		GpxTrack* _tmp9_;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		GpxPoint* _tmp12_;
		GpxPoint* _tmp13_;
		GpxPoint* _tmp14_ = NULL;
		GpxPoint* _tmp15_;
		GpxPoint* _tmp21_ = NULL;
		GpxPoint* _tmp22_;
		GpxTrack* _tmp28_;
#line 268 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp1_ = self->track;
#line 268 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp2_ = _tmp1_->points;
#line 268 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = self->priv->selected;
#line 268 "../gpx-viewer/libgpx/gpx-graph.vala"
		pos = g_list_index (_tmp2_, _tmp3_);
#line 269 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = self->track;
#line 269 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = _tmp4_->points;
#line 269 "../gpx-viewer/libgpx/gpx-graph.vala"
		last = g_list_length (_tmp5_) - 1;
#line 270 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (((guint) pos) == last) {
#line 1073 "gpx-graph.c"
			gint _tmp6_;
#line 271 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp6_ = pos;
#line 271 "../gpx-viewer/libgpx/gpx-graph.vala"
			pos = _tmp6_ - 1;
#line 1079 "gpx-graph.c"
		}
#line 273 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp7_ = self->track;
#line 273 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp8_ = self->priv->selected;
#line 273 "../gpx-viewer/libgpx/gpx-graph.vala"
		gpx_track_remove_point (_tmp7_, _tmp8_, TRUE);
#line 274 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp9_ = self->track;
#line 274 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp10_ = _tmp9_->points;
#line 274 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp11_ = g_list_nth_data (_tmp10_, (guint) pos);
#line 274 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp12_ = _gpx_point_ref0 ((GpxPoint*) _tmp11_);
#line 274 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->selected);
#line 274 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->selected = _tmp12_;
#line 275 "../gpx-viewer/libgpx/gpx-graph.vala"
		_cairo_surface_destroy0 (self->priv->surf);
#line 275 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->surf = NULL;
#line 276 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp13_ = self->priv->selected;
#line 276 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_POINT_CLICKED_SIGNAL], 0, _tmp13_);
#line 279 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp15_ = self->priv->start;
#line 279 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp15_ != NULL) {
#line 1111 "gpx-graph.c"
			GpxPoint* _tmp16_;
#line 280 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp16_ = self->priv->start;
#line 280 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp14_ = _tmp16_;
#line 1117 "gpx-graph.c"
		} else {
			GpxTrack* _tmp17_;
			GList* _tmp18_;
			GList* _tmp19_;
			gconstpointer _tmp20_;
#line 281 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp17_ = self->track;
#line 281 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp18_ = _tmp17_->points;
#line 281 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp19_ = g_list_first (_tmp18_);
#line 281 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp20_ = _tmp19_->data;
#line 281 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp14_ = (GpxPoint*) _tmp20_;
#line 1133 "gpx-graph.c"
		}
#line 282 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp22_ = self->priv->stop;
#line 282 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp22_ != NULL) {
#line 1139 "gpx-graph.c"
			GpxPoint* _tmp23_;
#line 283 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp23_ = self->priv->stop;
#line 283 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp21_ = _tmp23_;
#line 1145 "gpx-graph.c"
		} else {
			GpxTrack* _tmp24_;
			GList* _tmp25_;
			GList* _tmp26_;
			gconstpointer _tmp27_;
#line 284 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp24_ = self->track;
#line 284 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp25_ = _tmp24_->points;
#line 284 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp26_ = g_list_last (_tmp25_);
#line 284 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp27_ = _tmp26_->data;
#line 284 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp21_ = (GpxPoint*) _tmp27_;
#line 1161 "gpx-graph.c"
		}
#line 278 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp28_ = self->track;
#line 278 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp28_, _tmp14_, _tmp21_);
#line 285 "../gpx-viewer/libgpx/gpx-graph.vala"
		gtk_widget_queue_draw ((GtkWidget*) self);
#line 1169 "gpx-graph.c"
	}
}

void
gpx_graph_remove_non_selected_range (GpxGraph* self)
{
	gboolean _tmp0_ = FALSE;
	GpxPoint* _tmp1_;
#line 289 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = self->priv->start;
#line 289 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp1_ != NULL) {
#line 1182 "gpx-graph.c"
		GpxPoint* _tmp2_;
#line 289 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp2_ = self->priv->stop;
#line 289 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 1188 "gpx-graph.c"
	} else {
#line 289 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp0_ = FALSE;
#line 1192 "gpx-graph.c"
	}
#line 289 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_) {
#line 1196 "gpx-graph.c"
		gint start_pos = 0;
		GpxTrack* _tmp3_;
		GList* _tmp4_;
		GpxPoint* _tmp5_;
		gint end_pos = 0;
		GpxTrack* _tmp6_;
		GList* _tmp7_;
		GpxPoint* _tmp8_;
		guint last_pos = 0U;
		GpxTrack* _tmp9_;
		GList* _tmp10_;
		GpxTrack* _tmp27_;
		GList* _tmp28_;
		gconstpointer _tmp29_;
		GpxPoint* _tmp30_;
#line 290 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = self->track;
#line 290 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = _tmp3_->points;
#line 290 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = self->priv->start;
#line 290 "../gpx-viewer/libgpx/gpx-graph.vala"
		start_pos = g_list_index (_tmp4_, _tmp5_);
#line 291 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp6_ = self->track;
#line 291 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp7_ = _tmp6_->points;
#line 291 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp8_ = self->priv->stop;
#line 291 "../gpx-viewer/libgpx/gpx-graph.vala"
		end_pos = g_list_index (_tmp7_, _tmp8_);
#line 292 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp9_ = self->track;
#line 292 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp10_ = _tmp9_->points;
#line 292 "../gpx-viewer/libgpx/gpx-graph.vala"
		last_pos = g_list_length (_tmp10_) - 1;
#line 293 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (start_pos == end_pos) {
#line 294 "../gpx-viewer/libgpx/gpx-graph.vala"
			return;
#line 1238 "gpx-graph.c"
		}
#line 296 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (end_pos < start_pos) {
#line 1242 "gpx-graph.c"
			gint tmp_pos = 0;
#line 297 "../gpx-viewer/libgpx/gpx-graph.vala"
			tmp_pos = end_pos;
#line 298 "../gpx-viewer/libgpx/gpx-graph.vala"
			end_pos = start_pos;
#line 299 "../gpx-viewer/libgpx/gpx-graph.vala"
			start_pos = tmp_pos;
#line 1250 "gpx-graph.c"
		}
		{
			gint i = 0;
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
			i = 0;
#line 1256 "gpx-graph.c"
			{
				gboolean _tmp11_ = FALSE;
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp11_ = TRUE;
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
				while (TRUE) {
#line 1263 "gpx-graph.c"
					GpxPoint* p = NULL;
					GpxTrack* _tmp13_;
					GList* _tmp14_;
					gconstpointer _tmp15_;
					GpxPoint* _tmp16_;
					GpxTrack* _tmp17_;
					GpxPoint* _tmp18_;
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (!_tmp11_) {
#line 1273 "gpx-graph.c"
						gint _tmp12_;
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp12_ = i;
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
						i = _tmp12_ + 1;
#line 1279 "gpx-graph.c"
					}
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp11_ = FALSE;
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (!(i < start_pos)) {
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
						break;
#line 1287 "gpx-graph.c"
					}
#line 303 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp13_ = self->track;
#line 303 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp14_ = _tmp13_->points;
#line 303 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp15_ = g_list_nth_data (_tmp14_, (guint) 0);
#line 303 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp16_ = _gpx_point_ref0 ((GpxPoint*) _tmp15_);
#line 303 "../gpx-viewer/libgpx/gpx-graph.vala"
					p = _tmp16_;
#line 304 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp17_ = self->track;
#line 304 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp18_ = p;
#line 304 "../gpx-viewer/libgpx/gpx-graph.vala"
					gpx_track_remove_point (_tmp17_, _tmp18_, FALSE);
#line 302 "../gpx-viewer/libgpx/gpx-graph.vala"
					_gpx_point_unref0 (p);
#line 1307 "gpx-graph.c"
				}
			}
		}
#line 306 "../gpx-viewer/libgpx/gpx-graph.vala"
		end_pos -= start_pos - 1;
#line 307 "../gpx-viewer/libgpx/gpx-graph.vala"
		last_pos += (guint) (start_pos - 1);
#line 308 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_print ("removing trail %d to %u\n", end_pos, last_pos);
#line 1317 "gpx-graph.c"
		{
			gint i = 0;
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
			i = end_pos;
#line 1322 "gpx-graph.c"
			{
				gboolean _tmp19_ = FALSE;
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp19_ = TRUE;
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
				while (TRUE) {
#line 1329 "gpx-graph.c"
					GpxPoint* p = NULL;
					GpxTrack* _tmp21_;
					GList* _tmp22_;
					gconstpointer _tmp23_;
					GpxPoint* _tmp24_;
					GpxTrack* _tmp25_;
					GpxPoint* _tmp26_;
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (!_tmp19_) {
#line 1339 "gpx-graph.c"
						gint _tmp20_;
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp20_ = i;
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
						i = _tmp20_ + 1;
#line 1345 "gpx-graph.c"
					}
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp19_ = FALSE;
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (!(((guint) i) <= last_pos)) {
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
						break;
#line 1353 "gpx-graph.c"
					}
#line 310 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp21_ = self->track;
#line 310 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp22_ = _tmp21_->points;
#line 310 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp23_ = g_list_nth_data (_tmp22_, (guint) end_pos);
#line 310 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp24_ = _gpx_point_ref0 ((GpxPoint*) _tmp23_);
#line 310 "../gpx-viewer/libgpx/gpx-graph.vala"
					p = _tmp24_;
#line 311 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp25_ = self->track;
#line 311 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp26_ = p;
#line 311 "../gpx-viewer/libgpx/gpx-graph.vala"
					gpx_track_remove_point (_tmp25_, _tmp26_, FALSE);
#line 309 "../gpx-viewer/libgpx/gpx-graph.vala"
					_gpx_point_unref0 (p);
#line 1373 "gpx-graph.c"
				}
			}
		}
#line 313 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->start);
#line 313 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->start = NULL;
#line 314 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->stop);
#line 314 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->stop = NULL;
#line 315 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp27_ = self->track;
#line 315 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp28_ = _tmp27_->points;
#line 315 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp29_ = g_list_nth_data (_tmp28_, (guint) 0);
#line 315 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp30_ = _gpx_point_ref0 ((GpxPoint*) _tmp29_);
#line 315 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->selected);
#line 315 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->selected = _tmp30_;
#line 316 "../gpx-viewer/libgpx/gpx-graph.vala"
		gpx_graph_remove_selected_point (self);
#line 1399 "gpx-graph.c"
	}
}

static void
______lambda4_ (GpxGraph* self)
{
#line 338 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_remove_selected (self);
#line 1408 "gpx-graph.c"
}

static void
_______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                        gpointer self)
{
#line 337 "../gpx-viewer/libgpx/gpx-graph.vala"
	______lambda4_ ((GpxGraph*) self);
#line 1417 "gpx-graph.c"
}

static void
______lambda5_ (GpxGraph* self)
{
#line 347 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_remove_non_selected_range (self);
#line 1425 "gpx-graph.c"
}

static void
_______lambda5__gtk_menu_item_activate (GtkMenuItem* _sender,
                                        gpointer self)
{
#line 346 "../gpx-viewer/libgpx/gpx-graph.vala"
	______lambda5_ ((GpxGraph*) self);
#line 1434 "gpx-graph.c"
}

static gboolean
gpx_graph_button_press_event_cb (GpxGraph* self,
                                 GdkEventButton* event)
{
	GpxTrack* _tmp0_;
	GpxPoint* point = NULL;
	GpxPoint* _tmp1_;
	GpxPoint* _tmp2_;
	gboolean result;
#line 321 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->track;
#line 321 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ == NULL) {
#line 321 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = TRUE;
#line 321 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 1454 "gpx-graph.c"
	}
#line 322 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = gpx_graph_get_point_from_position (self, event->x, event->y);
#line 322 "../gpx-viewer/libgpx/gpx-graph.vala"
	point = _tmp1_;
#line 323 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp2_ = point;
#line 323 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp2_ != NULL) {
#line 324 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1466 "gpx-graph.c"
			GpxPoint* _tmp3_;
			GpxPoint* _tmp4_;
			GpxPoint* _tmp5_;
#line 325 "../gpx-viewer/libgpx/gpx-graph.vala"
			_gpx_point_unref0 (self->priv->start);
#line 325 "../gpx-viewer/libgpx/gpx-graph.vala"
			self->priv->start = NULL;
#line 326 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp3_ = point;
#line 326 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp4_ = _gpx_point_ref0 (_tmp3_);
#line 326 "../gpx-viewer/libgpx/gpx-graph.vala"
			_gpx_point_unref0 (self->priv->selected);
#line 326 "../gpx-viewer/libgpx/gpx-graph.vala"
			self->priv->selected = _tmp4_;
#line 327 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp5_ = point;
#line 327 "../gpx-viewer/libgpx/gpx-graph.vala"
			g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_POINT_CLICKED_SIGNAL], 0, _tmp5_);
#line 1486 "gpx-graph.c"
		} else {
#line 328 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (event->button == ((guint) GDK_BUTTON_SECONDARY)) {
#line 1490 "gpx-graph.c"
				gboolean _tmp6_ = FALSE;
				GpxPoint* _tmp7_;
				gboolean range_selected = FALSE;
				gboolean point_selected = FALSE;
				GpxPoint* _tmp9_;
				GtkMenu* menu = NULL;
				GtkMenu* _tmp10_;
				GtkAccelGroup* accel_group = NULL;
				GtkAccelGroup* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp29_ = FALSE;
#line 329 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp7_ = self->priv->start;
#line 329 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (_tmp7_ != NULL) {
#line 1506 "gpx-graph.c"
					GpxPoint* _tmp8_;
#line 329 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp8_ = self->priv->stop;
#line 329 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp6_ = _tmp8_ != NULL;
#line 1512 "gpx-graph.c"
				} else {
#line 329 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp6_ = FALSE;
#line 1516 "gpx-graph.c"
				}
#line 329 "../gpx-viewer/libgpx/gpx-graph.vala"
				range_selected = _tmp6_;
#line 330 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp9_ = self->priv->selected;
#line 330 "../gpx-viewer/libgpx/gpx-graph.vala"
				point_selected = _tmp9_ != NULL;
#line 331 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp10_ = (GtkMenu*) gtk_menu_new ();
#line 331 "../gpx-viewer/libgpx/gpx-graph.vala"
				g_object_ref_sink (_tmp10_);
#line 331 "../gpx-viewer/libgpx/gpx-graph.vala"
				menu = _tmp10_;
#line 332 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp11_ = gtk_accel_group_new ();
#line 332 "../gpx-viewer/libgpx/gpx-graph.vala"
				accel_group = _tmp11_;
#line 334 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (range_selected) {
#line 334 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp12_ = TRUE;
#line 1538 "gpx-graph.c"
				} else {
#line 334 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp12_ = point_selected;
#line 1542 "gpx-graph.c"
				}
#line 334 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (_tmp12_) {
#line 1546 "gpx-graph.c"
					GtkMenu* _tmp13_;
					const gchar* _tmp14_ = NULL;
					GtkMenuItem* menu_item = NULL;
					GtkMenuItem* _tmp15_;
					GtkMenuItem* _tmp16_;
					GtkMenuItem* _tmp17_;
					GtkAccelGroup* _tmp18_;
					GtkMenuItem* _tmp19_;
					GtkAccelGroup* _tmp20_;
					GtkMenu* _tmp21_;
					GtkMenuItem* _tmp22_;
#line 335 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp13_ = menu;
#line 335 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_menu_attach_to_widget (_tmp13_, (GtkWidget*) self, NULL);
#line 336 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (range_selected) {
#line 336 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp14_ = "Remove range";
#line 1566 "gpx-graph.c"
					} else {
#line 336 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp14_ = "Remove point";
#line 1570 "gpx-graph.c"
					}
#line 336 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp15_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp14_);
#line 336 "../gpx-viewer/libgpx/gpx-graph.vala"
					g_object_ref_sink (_tmp15_);
#line 336 "../gpx-viewer/libgpx/gpx-graph.vala"
					menu_item = _tmp15_;
#line 337 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp16_ = menu_item;
#line 337 "../gpx-viewer/libgpx/gpx-graph.vala"
					g_signal_connect_object (_tmp16_, "activate", (GCallback) _______lambda4__gtk_menu_item_activate, self, 0);
#line 340 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp17_ = menu_item;
#line 340 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp18_ = accel_group;
#line 340 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_widget_add_accelerator ((GtkWidget*) _tmp17_, "activate", _tmp18_, GDK_KEY_Delete, 0, GTK_ACCEL_VISIBLE);
#line 341 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp19_ = menu_item;
#line 341 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp20_ = accel_group;
#line 341 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_widget_add_accelerator ((GtkWidget*) _tmp19_, "activate", _tmp20_, GDK_KEY_BackSpace, 0, GTK_ACCEL_VISIBLE);
#line 342 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp21_ = menu;
#line 342 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp22_ = menu_item;
#line 342 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
#line 334 "../gpx-viewer/libgpx/gpx-graph.vala"
					_g_object_unref0 (menu_item);
#line 1602 "gpx-graph.c"
				}
#line 344 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (range_selected) {
#line 1606 "gpx-graph.c"
					GtkMenuItem* menu_item = NULL;
					GtkMenuItem* _tmp23_;
					GtkMenuItem* _tmp24_;
					GtkMenuItem* _tmp25_;
					GtkAccelGroup* _tmp26_;
					GtkMenu* _tmp27_;
					GtkMenuItem* _tmp28_;
#line 345 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp23_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Remove non selected range");
#line 345 "../gpx-viewer/libgpx/gpx-graph.vala"
					g_object_ref_sink (_tmp23_);
#line 345 "../gpx-viewer/libgpx/gpx-graph.vala"
					menu_item = _tmp23_;
#line 346 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp24_ = menu_item;
#line 346 "../gpx-viewer/libgpx/gpx-graph.vala"
					g_signal_connect_object (_tmp24_, "activate", (GCallback) _______lambda5__gtk_menu_item_activate, self, 0);
#line 349 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp25_ = menu_item;
#line 349 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp26_ = accel_group;
#line 349 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_widget_add_accelerator ((GtkWidget*) _tmp25_, "activate", _tmp26_, GDK_KEY_Delete, GDK_SHIFT_MASK, GTK_ACCEL_VISIBLE);
#line 350 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp27_ = menu;
#line 350 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp28_ = menu_item;
#line 350 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
#line 344 "../gpx-viewer/libgpx/gpx-graph.vala"
					_g_object_unref0 (menu_item);
#line 1638 "gpx-graph.c"
				}
#line 352 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (range_selected) {
#line 352 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp29_ = TRUE;
#line 1644 "gpx-graph.c"
				} else {
#line 352 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp29_ = point_selected;
#line 1648 "gpx-graph.c"
				}
#line 352 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (_tmp29_) {
#line 1652 "gpx-graph.c"
					GtkMenu* _tmp30_;
					GtkMenu* _tmp31_;
#line 353 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp30_ = menu;
#line 353 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_widget_show_all ((GtkWidget*) _tmp30_);
#line 354 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp31_ = menu;
#line 354 "../gpx-viewer/libgpx/gpx-graph.vala"
					gtk_menu_popup (_tmp31_, NULL, NULL, NULL, NULL, event->button, event->time);
#line 1663 "gpx-graph.c"
				}
#line 328 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_object_unref0 (accel_group);
#line 328 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_object_unref0 (menu);
#line 1669 "gpx-graph.c"
			}
		}
	}
#line 358 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = TRUE;
#line 358 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 1677 "gpx-graph.c"
}

static gboolean
gpx_graph_motion_notify_event_cb (GpxGraph* self,
                                  GdkEventMotion* event)
{
	GpxTrack* _tmp0_;
	GpxPoint* point = NULL;
	GpxPoint* _tmp1_;
	GpxPoint* _tmp2_;
	gboolean result;
#line 363 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->track;
#line 363 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ == NULL) {
#line 363 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = TRUE;
#line 363 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 1697 "gpx-graph.c"
	}
#line 365 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = gpx_graph_get_point_from_position (self, event->x, event->y);
#line 365 "../gpx-viewer/libgpx/gpx-graph.vala"
	point = _tmp1_;
#line 366 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp2_ = point;
#line 366 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp2_ != NULL) {
#line 1707 "gpx-graph.c"
		GpxPoint* _tmp3_;
		GpxPoint* _tmp6_;
		GpxPoint* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GpxPoint* _tmp9_;
		GpxTrack* _tmp21_;
		GpxTrack* _tmp22_;
		GList* _tmp23_;
		GList* _tmp24_;
		gconstpointer _tmp25_;
		GpxTrack* _tmp26_;
		GList* _tmp27_;
		GList* _tmp28_;
		gconstpointer _tmp29_;
#line 368 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = self->priv->start;
#line 368 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp3_ == NULL) {
#line 1726 "gpx-graph.c"
			GpxPoint* _tmp4_;
			GpxPoint* _tmp5_;
#line 369 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp4_ = point;
#line 369 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp5_ = _gpx_point_ref0 (_tmp4_);
#line 369 "../gpx-viewer/libgpx/gpx-graph.vala"
			_gpx_point_unref0 (self->priv->start);
#line 369 "../gpx-viewer/libgpx/gpx-graph.vala"
			self->priv->start = _tmp5_;
#line 1737 "gpx-graph.c"
		}
#line 370 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp6_ = point;
#line 370 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp7_ = _gpx_point_ref0 (_tmp6_);
#line 370 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (self->priv->stop);
#line 370 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->stop = _tmp7_;
#line 372 "../gpx-viewer/libgpx/gpx-graph.vala"
		gtk_widget_queue_draw ((GtkWidget*) self);
#line 373 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp9_ = self->priv->start;
#line 373 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp9_ != NULL) {
#line 1753 "gpx-graph.c"
			GpxPoint* _tmp10_;
#line 373 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp10_ = self->priv->stop;
#line 373 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp8_ = _tmp10_ != NULL;
#line 1759 "gpx-graph.c"
		} else {
#line 373 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp8_ = FALSE;
#line 1763 "gpx-graph.c"
		}
#line 373 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp8_) {
#line 1767 "gpx-graph.c"
			GpxPoint* _tmp11_;
			GpxPoint* _tmp12_;
#line 375 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp11_ = self->priv->start;
#line 375 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp12_ = self->priv->stop;
#line 375 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (gpx_point_get_time (_tmp11_) != gpx_point_get_time (_tmp12_)) {
#line 1776 "gpx-graph.c"
				GpxPoint* _tmp13_;
				GpxPoint* _tmp14_;
#line 377 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp13_ = self->priv->start;
#line 377 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp14_ = self->priv->stop;
#line 377 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (gpx_point_get_time (_tmp13_) < gpx_point_get_time (_tmp14_)) {
#line 1785 "gpx-graph.c"
					GpxTrack* _tmp15_;
					GpxPoint* _tmp16_;
					GpxPoint* _tmp17_;
#line 378 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp15_ = self->track;
#line 378 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp16_ = self->priv->start;
#line 378 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp17_ = self->priv->stop;
#line 378 "../gpx-viewer/libgpx/gpx-graph.vala"
					g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp15_, _tmp16_, _tmp17_);
#line 1797 "gpx-graph.c"
				} else {
					GpxTrack* _tmp18_;
					GpxPoint* _tmp19_;
					GpxPoint* _tmp20_;
#line 380 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp18_ = self->track;
#line 380 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp19_ = self->priv->stop;
#line 380 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp20_ = self->priv->start;
#line 380 "../gpx-viewer/libgpx/gpx-graph.vala"
					g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp18_, _tmp19_, _tmp20_);
#line 1810 "gpx-graph.c"
				}
#line 382 "../gpx-viewer/libgpx/gpx-graph.vala"
				result = TRUE;
#line 382 "../gpx-viewer/libgpx/gpx-graph.vala"
				return result;
#line 1816 "gpx-graph.c"
			}
		}
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp21_ = self->track;
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp22_ = self->track;
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp23_ = _tmp22_->points;
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp24_ = g_list_first (_tmp23_);
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp25_ = _tmp24_->data;
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp26_ = self->track;
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp27_ = _tmp26_->points;
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp28_ = g_list_last (_tmp27_);
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp29_ = _tmp28_->data;
#line 385 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp21_, (GpxPoint*) _tmp25_, (GpxPoint*) _tmp29_);
#line 1839 "gpx-graph.c"
	}
#line 387 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = TRUE;
#line 387 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 1845 "gpx-graph.c"
}

static gboolean
gpx_graph_button_release_event_cb (GpxGraph* self,
                                   GdkEventButton* event)
{
	GpxTrack* _tmp0_;
	GpxPoint* point = NULL;
	GpxPoint* _tmp1_;
	GpxPoint* _tmp2_;
	gboolean result;
#line 391 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->track;
#line 391 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ == NULL) {
#line 391 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = TRUE;
#line 391 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 1865 "gpx-graph.c"
	}
#line 392 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = gpx_graph_get_point_from_position (self, event->x, event->y);
#line 392 "../gpx-viewer/libgpx/gpx-graph.vala"
	point = _tmp1_;
#line 393 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp2_ = point;
#line 393 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp2_ != NULL) {
#line 395 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1877 "gpx-graph.c"
			GpxPoint* _tmp3_;
			GpxPoint* _tmp4_;
#line 396 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp3_ = point;
#line 396 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp4_ = _gpx_point_ref0 (_tmp3_);
#line 396 "../gpx-viewer/libgpx/gpx-graph.vala"
			_gpx_point_unref0 (self->priv->stop);
#line 396 "../gpx-viewer/libgpx/gpx-graph.vala"
			self->priv->stop = _tmp4_;
#line 1888 "gpx-graph.c"
		} else {
#line 397 "../gpx-viewer/libgpx/gpx-graph.vala"
			_gpx_point_unref0 (self->priv->stop);
#line 397 "../gpx-viewer/libgpx/gpx-graph.vala"
			self->priv->stop = NULL;
#line 1894 "gpx-graph.c"
		}
#line 398 "../gpx-viewer/libgpx/gpx-graph.vala"
		gtk_widget_queue_draw ((GtkWidget*) self);
#line 399 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1900 "gpx-graph.c"
			gboolean _tmp5_ = FALSE;
			GpxPoint* _tmp6_;
			GpxTrack* _tmp18_;
			GpxTrack* _tmp19_;
			GList* _tmp20_;
			GList* _tmp21_;
			gconstpointer _tmp22_;
			GpxTrack* _tmp23_;
			GList* _tmp24_;
			GList* _tmp25_;
			gconstpointer _tmp26_;
#line 401 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp6_ = self->priv->start;
#line 401 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp6_ != NULL) {
#line 1916 "gpx-graph.c"
				GpxPoint* _tmp7_;
#line 401 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp7_ = self->priv->stop;
#line 401 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp5_ = _tmp7_ != NULL;
#line 1922 "gpx-graph.c"
			} else {
#line 401 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp5_ = FALSE;
#line 1926 "gpx-graph.c"
			}
#line 401 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp5_) {
#line 1930 "gpx-graph.c"
				GpxPoint* _tmp8_;
				GpxPoint* _tmp9_;
#line 403 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp8_ = self->priv->start;
#line 403 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp9_ = self->priv->stop;
#line 403 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (gpx_point_get_time (_tmp8_) != gpx_point_get_time (_tmp9_)) {
#line 1939 "gpx-graph.c"
					GpxPoint* _tmp10_;
					GpxPoint* _tmp11_;
#line 405 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp10_ = self->priv->start;
#line 405 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp11_ = self->priv->stop;
#line 405 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (gpx_point_get_time (_tmp10_) < gpx_point_get_time (_tmp11_)) {
#line 1948 "gpx-graph.c"
						GpxTrack* _tmp12_;
						GpxPoint* _tmp13_;
						GpxPoint* _tmp14_;
#line 406 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp12_ = self->track;
#line 406 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp13_ = self->priv->start;
#line 406 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp14_ = self->priv->stop;
#line 406 "../gpx-viewer/libgpx/gpx-graph.vala"
						g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp12_, _tmp13_, _tmp14_);
#line 1960 "gpx-graph.c"
					} else {
						GpxTrack* _tmp15_;
						GpxPoint* _tmp16_;
						GpxPoint* _tmp17_;
#line 408 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp15_ = self->track;
#line 408 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp16_ = self->priv->stop;
#line 408 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp17_ = self->priv->start;
#line 408 "../gpx-viewer/libgpx/gpx-graph.vala"
						g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp15_, _tmp16_, _tmp17_);
#line 1973 "gpx-graph.c"
					}
#line 410 "../gpx-viewer/libgpx/gpx-graph.vala"
					result = TRUE;
#line 410 "../gpx-viewer/libgpx/gpx-graph.vala"
					return result;
#line 1979 "gpx-graph.c"
				}
			}
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp18_ = self->track;
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp19_ = self->track;
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp20_ = _tmp19_->points;
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp21_ = g_list_first (_tmp20_);
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp22_ = _tmp21_->data;
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp23_ = self->track;
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp24_ = _tmp23_->points;
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp25_ = g_list_last (_tmp24_);
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp26_ = _tmp25_->data;
#line 413 "../gpx-viewer/libgpx/gpx-graph.vala"
			g_signal_emit (self, gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL], 0, _tmp18_, (GpxPoint*) _tmp22_, (GpxPoint*) _tmp26_);
#line 2002 "gpx-graph.c"
		}
	}
#line 416 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = TRUE;
#line 416 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 2009 "gpx-graph.c"
}

static void
gpx_graph_size_allocate_cb (GpxGraph* self,
                            GtkAllocation* alloc)
{
#line 421 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_surface_destroy0 (self->priv->surf);
#line 421 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->surf = NULL;
#line 2020 "gpx-graph.c"
}

static gboolean
gpx_graph_a_expose_event (GpxGraph* self,
                          cairo_t* ctx)
{
	cairo_surface_t* _tmp0_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp1_ = {0};
	cairo_surface_t* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GpxPoint* _tmp4_;
	gboolean result;
#line 428 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->priv->surf;
#line 428 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp0_ == NULL) {
#line 429 "../gpx-viewer/libgpx/gpx-graph.vala"
		gpx_graph_update_surface (self, (GtkWidget*) self);
#line 2040 "gpx-graph.c"
	}
#line 433 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
#line 433 "../gpx-viewer/libgpx/gpx-graph.vala"
	alloc = _tmp1_;
#line 435 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp2_ = self->priv->surf;
#line 435 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_source_surface (ctx, _tmp2_, (gdouble) 0, (gdouble) 0);
#line 436 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_paint (ctx);
#line 438 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_translate (ctx, (gdouble) self->priv->LEFT_OFFSET, (gdouble) 20);
#line 440 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp4_ = self->priv->start;
#line 440 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp4_ != NULL) {
#line 2058 "gpx-graph.c"
		GpxPoint* _tmp5_;
#line 440 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp5_ = self->priv->stop;
#line 440 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = _tmp5_ != NULL;
#line 2064 "gpx-graph.c"
	} else {
#line 440 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = FALSE;
#line 2068 "gpx-graph.c"
	}
#line 440 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp3_) {
#line 2072 "gpx-graph.c"
		GpxPoint* _tmp6_;
		GpxPoint* _tmp7_;
#line 442 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp6_ = self->priv->start;
#line 442 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp7_ = self->priv->stop;
#line 442 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (gpx_point_get_time (_tmp6_) != gpx_point_get_time (_tmp7_)) {
#line 2081 "gpx-graph.c"
			GpxPoint* f = NULL;
			GpxTrack* _tmp8_;
			GList* _tmp9_;
			GList* _tmp10_;
			gconstpointer _tmp11_;
			GpxPoint* _tmp12_;
			gdouble elapsed_time = 0.0;
			GpxTrack* _tmp13_;
			gdouble graph_width = 0.0;
			GtkAllocation _tmp14_;
			gdouble graph_height = 0.0;
			GtkAllocation _tmp15_;
			GpxPoint* _tmp16_;
			GpxPoint* _tmp17_;
			GpxPoint* _tmp18_;
			GpxPoint* _tmp19_;
#line 444 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp8_ = self->track;
#line 444 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp9_ = _tmp8_->points;
#line 444 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp10_ = g_list_first (_tmp9_);
#line 444 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp11_ = _tmp10_->data;
#line 444 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp12_ = _gpx_point_ref0 ((GpxPoint*) _tmp11_);
#line 444 "../gpx-viewer/libgpx/gpx-graph.vala"
			f = _tmp12_;
#line 445 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp13_ = self->track;
#line 445 "../gpx-viewer/libgpx/gpx-graph.vala"
			elapsed_time = (gdouble) gpx_track_get_total_time (_tmp13_);
#line 446 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp14_ = alloc;
#line 446 "../gpx-viewer/libgpx/gpx-graph.vala"
			graph_width = (gdouble) ((_tmp14_.width - self->priv->LEFT_OFFSET) - self->priv->RIGHT_OFFSET);
#line 447 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp15_ = alloc;
#line 447 "../gpx-viewer/libgpx/gpx-graph.vala"
			graph_height = (gdouble) ((_tmp15_.height - 20) - self->priv->BOTTOM_OFFSET);
#line 449 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_set_source_rgba (ctx, 0.3, 0.2, 0.3, 0.8);
#line 450 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp16_ = self->priv->start;
#line 450 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp17_ = f;
#line 450 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp18_ = self->priv->stop;
#line 450 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp19_ = self->priv->start;
#line 450 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_rectangle (ctx, ((gpx_point_get_time (_tmp16_) - gpx_point_get_time (_tmp17_)) / elapsed_time) * graph_width, (gdouble) 0, ((gpx_point_get_time (_tmp18_) - gpx_point_get_time (_tmp19_)) / elapsed_time) * graph_width, graph_height);
#line 452 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_stroke_preserve (ctx);
#line 453 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_fill (ctx);
#line 442 "../gpx-viewer/libgpx/gpx-graph.vala"
			_gpx_point_unref0 (f);
#line 2140 "gpx-graph.c"
		}
	}
#line 457 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (self->priv->highlight > ((time_t) 0)) {
#line 2145 "gpx-graph.c"
		GpxPoint* f = NULL;
		GpxTrack* _tmp20_;
		GList* _tmp21_;
		GList* _tmp22_;
		gconstpointer _tmp23_;
		GpxPoint* _tmp24_;
		gdouble elapsed_time = 0.0;
		GpxTrack* _tmp25_;
		gdouble graph_width = 0.0;
		GtkAllocation _tmp26_;
		gdouble graph_height = 0.0;
		GtkAllocation _tmp27_;
		gdouble hl = 0.0;
		GpxPoint* _tmp28_;
		GpxPoint* _tmp29_;
#line 459 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp20_ = self->track;
#line 459 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp21_ = _tmp20_->points;
#line 459 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp22_ = g_list_first (_tmp21_);
#line 459 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp23_ = _tmp22_->data;
#line 459 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp24_ = _gpx_point_ref0 ((GpxPoint*) _tmp23_);
#line 459 "../gpx-viewer/libgpx/gpx-graph.vala"
		f = _tmp24_;
#line 460 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp25_ = self->track;
#line 460 "../gpx-viewer/libgpx/gpx-graph.vala"
		elapsed_time = (gdouble) gpx_track_get_total_time (_tmp25_);
#line 461 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp26_ = alloc;
#line 461 "../gpx-viewer/libgpx/gpx-graph.vala"
		graph_width = (gdouble) ((_tmp26_.width - self->priv->LEFT_OFFSET) - self->priv->RIGHT_OFFSET);
#line 462 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp27_ = alloc;
#line 462 "../gpx-viewer/libgpx/gpx-graph.vala"
		graph_height = (gdouble) ((_tmp27_.height - 20) - self->priv->BOTTOM_OFFSET);
#line 464 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp28_ = f;
#line 464 "../gpx-viewer/libgpx/gpx-graph.vala"
		hl = ((self->priv->highlight - gpx_point_get_time (_tmp28_)) / elapsed_time) * graph_width;
#line 466 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_set_source_rgba (ctx, 0.8, 0.2, 0.3, 0.8);
#line 467 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_move_to (ctx, hl, (gdouble) 0);
#line 468 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_line_to (ctx, hl, graph_height);
#line 470 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_stroke_preserve (ctx);
#line 471 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_fill (ctx);
#line 475 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp29_ = self->priv->draw_current;
#line 475 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp29_ != NULL) {
#line 2203 "gpx-graph.c"
			PangoLayout* layout = NULL;
			PangoLayout* _tmp30_;
			gint w = 0;
			gint h = 0;
			gchar* text = NULL;
			gchar* _tmp31_;
			gdouble x_pos = 0.0;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GpxPoint* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			GpxPoint* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			GpxPoint* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			GpxPoint* _tmp60_;
			GpxHeartRateMonitorPoint _tmp61_;
			const gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			GpxPoint* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			GpxPoint* _tmp92_;
			GDateTime* _tmp93_;
			GDateTime* _tmp94_;
			GDateTime* _tmp95_;
			GDateTime* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			PangoFontDescription* _tmp104_;
			PangoLayout* _tmp105_;
			PangoFontDescription* _tmp106_;
			PangoLayout* _tmp107_;
			const gchar* _tmp108_;
			PangoLayout* _tmp109_;
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
			PangoLayout* _tmp112_;
#line 477 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp30_ = pango_cairo_create_layout (ctx);
#line 477 "../gpx-viewer/libgpx/gpx-graph.vala"
			layout = _tmp30_;
#line 479 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp31_ = g_strdup ("");
#line 479 "../gpx-viewer/libgpx/gpx-graph.vala"
			text = _tmp31_;
#line 480 "../gpx-viewer/libgpx/gpx-graph.vala"
			x_pos = 0.0;
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp32_ = g_strconcat (_ ("Speed"), ":\t", NULL);
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp33_ = _tmp32_;
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp34_ = self->priv->draw_current;
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp35_ = gpx_viewer_misc_convert (_tmp34_->speed, SPEED);
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp36_ = _tmp35_;
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp37_ = g_strconcat (_tmp33_, _tmp36_, NULL);
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (text);
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			text = _tmp37_;
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp36_);
#line 482 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp33_);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp38_ = text;
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp39_ = g_strconcat ("\n", _ ("Elevation"), NULL);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp40_ = _tmp39_;
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp41_ = g_strconcat (_tmp40_, ":\t", NULL);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp42_ = _tmp41_;
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp43_ = self->priv->draw_current;
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp44_ = gpx_viewer_misc_convert (_tmp43_->elevation, ELEVATION);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp45_ = _tmp44_;
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp46_ = g_strconcat (_tmp42_, _tmp45_, NULL);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp47_ = _tmp46_;
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp48_ = g_strconcat (_tmp38_, _tmp47_, NULL);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (text);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			text = _tmp48_;
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp47_);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp45_);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp42_);
#line 483 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp40_);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp49_ = text;
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp50_ = g_strconcat ("\n", _ ("Distance"), NULL);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp51_ = _tmp50_;
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp52_ = g_strconcat (_tmp51_, ":\t", NULL);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp53_ = _tmp52_;
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp54_ = self->priv->draw_current;
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp55_ = gpx_viewer_misc_convert (_tmp54_->distance, DISTANCE);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp56_ = _tmp55_;
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp57_ = g_strconcat (_tmp53_, _tmp56_, NULL);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp58_ = _tmp57_;
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp59_ = g_strconcat (_tmp49_, _tmp58_, NULL);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (text);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			text = _tmp59_;
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp58_);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp56_);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp53_);
#line 484 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp51_);
#line 485 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp60_ = f;
#line 485 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp61_ = _tmp60_->tpe;
#line 485 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp61_.heartrate > 0) {
#line 2382 "gpx-graph.c"
				const gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				GpxPoint* _tmp67_;
				GpxHeartRateMonitorPoint _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp62_ = text;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp63_ = g_strconcat ("\n", _ ("Heart-rate"), NULL);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp64_ = _tmp63_;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp65_ = g_strconcat (_tmp64_, ": ", NULL);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp66_ = _tmp65_;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp67_ = self->priv->draw_current;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp68_ = _tmp67_->tpe;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp69_ = g_strdup_printf ("%d", _tmp68_.heartrate);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp70_ = _tmp69_;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp71_ = g_strconcat (_tmp66_, _tmp70_, NULL);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp72_ = _tmp71_;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp73_ = g_strconcat (_tmp72_, _ ("(bpm)"), NULL);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp74_ = _tmp73_;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp75_ = g_strconcat (_tmp62_, _tmp74_, NULL);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_free0 (text);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				text = _tmp75_;
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_free0 (_tmp74_);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_free0 (_tmp72_);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_free0 (_tmp70_);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_free0 (_tmp66_);
#line 486 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_free0 (_tmp64_);
#line 2439 "gpx-graph.c"
			}
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp76_ = text;
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp77_ = g_strconcat ("\n", _ ("Cadence"), NULL);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp78_ = _tmp77_;
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp79_ = g_strconcat (_tmp78_, ":\t", NULL);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp80_ = _tmp79_;
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp81_ = self->priv->draw_current;
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp82_ = g_strdup_printf ("%u rpm", (guint) _tmp81_->cadence);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp83_ = _tmp82_;
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp84_ = g_strconcat (_tmp80_, _tmp83_, NULL);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp85_ = _tmp84_;
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp86_ = g_strconcat (_tmp76_, _tmp85_, NULL);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (text);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			text = _tmp86_;
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp85_);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp83_);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp80_);
#line 488 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp78_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp87_ = text;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp88_ = g_strconcat ("\n", _ ("Time"), NULL);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp89_ = _tmp88_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp90_ = g_strconcat (_tmp89_, ":\t", NULL);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp91_ = _tmp90_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp92_ = self->priv->draw_current;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp93_ = gpx_point_get_datetime (_tmp92_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp94_ = _tmp93_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp95_ = g_date_time_to_local (_tmp94_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp96_ = _tmp95_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp97_ = g_date_time_format (_tmp96_, "%c");
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp98_ = _tmp97_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp99_ = g_strdup_printf ("%s", _tmp98_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp100_ = _tmp99_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp101_ = g_strconcat (_tmp91_, _tmp100_, NULL);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp102_ = _tmp101_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp103_ = g_strconcat (_tmp87_, _tmp102_, NULL);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (text);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			text = _tmp103_;
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp102_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp100_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp98_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_date_time_unref0 (_tmp96_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_date_time_unref0 (_tmp94_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp91_);
#line 489 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (_tmp89_);
#line 491 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp104_ = self->priv->fd;
#line 491 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_font_description_set_absolute_size (_tmp104_, (gdouble) (12 * 1024));
#line 492 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp105_ = layout;
#line 492 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp106_ = self->priv->fd;
#line 492 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_layout_set_font_description (_tmp105_, _tmp106_);
#line 493 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp107_ = layout;
#line 493 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp108_ = text;
#line 493 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_layout_set_text (_tmp107_, _tmp108_, -1);
#line 494 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp109_ = layout;
#line 494 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_layout_get_pixel_size (_tmp109_, &_tmp110_, &_tmp111_);
#line 494 "../gpx-viewer/libgpx/gpx-graph.vala"
			w = _tmp110_;
#line 494 "../gpx-viewer/libgpx/gpx-graph.vala"
			h = _tmp111_;
#line 497 "../gpx-viewer/libgpx/gpx-graph.vala"
			x_pos = hl - ((w + 8) / 2.0);
#line 498 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (x_pos < ((gdouble) (-self->priv->LEFT_OFFSET))) {
#line 498 "../gpx-viewer/libgpx/gpx-graph.vala"
				x_pos = 0.0;
#line 2557 "gpx-graph.c"
			} else {
#line 499 "../gpx-viewer/libgpx/gpx-graph.vala"
				if ((hl + ((w + 8) / 2.0)) >= graph_width) {
#line 499 "../gpx-viewer/libgpx/gpx-graph.vala"
					x_pos = ((gdouble) graph_width) - ((gdouble) (w + 8.0));
#line 2563 "gpx-graph.c"
				}
			}
#line 501 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_rectangle (ctx, x_pos, MAX ((gdouble) ((-h) - 2), (gdouble) -18), (gdouble) (w + 8), (gdouble) (h + 4));
#line 502 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 1.0);
#line 503 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_stroke_preserve (ctx);
#line 504 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_set_source_rgba (ctx, 0.7, 0.7, 0.7, 0.9);
#line 505 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_fill (ctx);
#line 507 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_move_to (ctx, x_pos + 4, MAX ((gdouble) (-h), (gdouble) -16));
#line 510 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp112_ = layout;
#line 510 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_cairo_layout_path (ctx, _tmp112_);
#line 514 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 1.0);
#line 515 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_fill (ctx);
#line 475 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (text);
#line 475 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_object_unref0 (layout);
#line 2590 "gpx-graph.c"
		}
#line 457 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (f);
#line 2594 "gpx-graph.c"
	}
#line 518 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = FALSE;
#line 518 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 2600 "gpx-graph.c"
}

/**
 * Draw the graph to the required surface.
 */
static void
gpx_graph_draw_grid (GpxGraph* self,
                     cairo_t* ctx,
                     PangoLayout* layout,
                     gdouble graph_width,
                     gdouble graph_height,
                     gdouble min_value,
                     gdouble max_value,
                     gdouble elapsed_time)
{
	gdouble j = 0.0;
	gdouble step_size = 0.0;
	gdouble range = 0.0;
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	gint wt = 0;
	gint ht = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	PangoFontDescription* _tmp11_;
	PangoFontDescription* _tmp12_;
	guint interval = 0U;
	gint current = 0;
#line 528 "../gpx-viewer/libgpx/gpx-graph.vala"
	j = 0.0;
#line 529 "../gpx-viewer/libgpx/gpx-graph.vala"
	step_size = graph_height / 8.0;
#line 530 "../gpx-viewer/libgpx/gpx-graph.vala"
	range = max_value - min_value;
#line 532 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:532: Draw grid lines");
#line 534 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 1.0);
#line 536 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = self->priv->fd;
#line 536 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_font_description_set_absolute_size (_tmp0_, (gdouble) (12 * 1024));
#line 537 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = self->priv->fd;
#line 537 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_layout_set_font_description (layout, _tmp1_);
#line 538 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_layout_set_text (layout, "0.0", -1);
#line 540 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_layout_get_pixel_size (layout, &_tmp2_, &_tmp3_);
#line 540 "../gpx-viewer/libgpx/gpx-graph.vala"
	wt = _tmp2_;
#line 540 "../gpx-viewer/libgpx/gpx-graph.vala"
	ht = _tmp3_;
#line 541 "../gpx-viewer/libgpx/gpx-graph.vala"
	step_size = graph_height / (ceil ((graph_height / (ht + 10)) / 5) * 5);
#line 2657 "gpx-graph.c"
	{
		gboolean _tmp4_ = FALSE;
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
		j = (gdouble) 0;
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp4_ = TRUE;
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
		while (TRUE) {
#line 2666 "gpx-graph.c"
			gdouble speed = 0.0;
			gchar* text = NULL;
			gchar* _tmp5_;
			gint w = 0;
			gint h = 0;
			const gchar* _tmp6_;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (!_tmp4_) {
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
				j += step_size;
#line 2681 "gpx-graph.c"
			}
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp4_ = FALSE;
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (!(j <= (graph_height + 1))) {
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
				break;
#line 2689 "gpx-graph.c"
			}
#line 544 "../gpx-viewer/libgpx/gpx-graph.vala"
			speed = min_value + (range * ((graph_height - j) / graph_height));
#line 545 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp5_ = g_strdup_printf ("%.1f", speed);
#line 545 "../gpx-viewer/libgpx/gpx-graph.vala"
			text = _tmp5_;
#line 547 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 1.0);
#line 548 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp6_ = text;
#line 548 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_layout_set_text (layout, _tmp6_, -1);
#line 549 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_layout_get_pixel_size (layout, &_tmp7_, &_tmp8_);
#line 549 "../gpx-viewer/libgpx/gpx-graph.vala"
			w = _tmp7_;
#line 549 "../gpx-viewer/libgpx/gpx-graph.vala"
			h = _tmp8_;
#line 550 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_move_to (ctx, (gdouble) ((-w) - 5), j - (h / 2.0));
#line 551 "../gpx-viewer/libgpx/gpx-graph.vala"
			pango_cairo_layout_path (ctx, layout);
#line 552 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_fill (ctx);
#line 554 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp9_ = text;
#line 554 "../gpx-viewer/libgpx/gpx-graph.vala"
			g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:554: Set speed tick: %s", _tmp9_);
#line 557 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_move_to (ctx, (gdouble) -4, j);
#line 558 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_line_to (ctx, (gdouble) 0, j);
#line 559 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_stroke (ctx);
#line 561 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (j <= 0.00001) {
#line 561 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp10_ = TRUE;
#line 2729 "gpx-graph.c"
			} else {
#line 561 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp10_ = j >= (graph_height - 0.00001);
#line 2733 "gpx-graph.c"
			}
#line 561 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp10_) {
#line 561 "../gpx-viewer/libgpx/gpx-graph.vala"
				_g_free0 (text);
#line 561 "../gpx-viewer/libgpx/gpx-graph.vala"
				continue;
#line 2741 "gpx-graph.c"
			}
#line 562 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_set_source_rgba (ctx, 0.4, 0.4, 0.4, 0.6);
#line 563 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_set_line_width (ctx, (gdouble) 1);
#line 564 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_move_to (ctx, 0.0, j);
#line 565 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_line_to (ctx, graph_width, j);
#line 566 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_stroke (ctx);
#line 543 "../gpx-viewer/libgpx/gpx-graph.vala"
			_g_free0 (text);
#line 2755 "gpx-graph.c"
		}
	}
#line 570 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_line_width (ctx, 2.5);
#line 571 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, (gdouble) 1);
#line 572 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_move_to (ctx, 0.0, 0.0);
#line 573 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_line_to (ctx, 0.0, graph_height);
#line 574 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_stroke (ctx);
#line 576 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_line_to (ctx, 0.0, graph_height + ((graph_height / range) * min_value));
#line 577 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_line_to (ctx, graph_width, graph_height + ((graph_height / range) * min_value));
#line 578 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_stroke (ctx);
#line 582 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp11_ = self->priv->fd;
#line 582 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_font_description_set_absolute_size (_tmp11_, (gdouble) (12 * 1024));
#line 583 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp12_ = self->priv->fd;
#line 583 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_layout_set_font_description (layout, _tmp12_);
#line 584 "../gpx-viewer/libgpx/gpx-graph.vala"
	interval = ((guint) elapsed_time) / ((guint) (graph_width / (5 * 12.0)));
#line 585 "../gpx-viewer/libgpx/gpx-graph.vala"
	current = 0;
#line 2786 "gpx-graph.c"
	{
		guint i = 0U;
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
		i = (guint) 0;
#line 2791 "gpx-graph.c"
		{
			gboolean _tmp13_ = FALSE;
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp13_ = TRUE;
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
			while (TRUE) {
#line 2798 "gpx-graph.c"
				gboolean _tmp14_ = FALSE;
				gint _tmp20_;
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (!_tmp13_) {
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
					i += interval;
#line 2805 "gpx-graph.c"
				}
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp13_ = FALSE;
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (((gdouble) i) < elapsed_time) {
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp14_ = interval > ((guint) 0);
#line 2813 "gpx-graph.c"
				} else {
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp14_ = FALSE;
#line 2817 "gpx-graph.c"
				}
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (!_tmp14_) {
#line 586 "../gpx-viewer/libgpx/gpx-graph.vala"
					break;
#line 2823 "gpx-graph.c"
				}
#line 588 "../gpx-viewer/libgpx/gpx-graph.vala"
				if ((graph_width * (1 - (i / elapsed_time))) > (2.5 * 12)) {
#line 2827 "gpx-graph.c"
					gint w = 0;
					gint h = 0;
					gchar* text = NULL;
					gchar* _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					const gchar* _tmp19_;
#line 590 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp15_ = g_strdup_printf ("%02i:%02i", ((gint) i) / 3600, (((gint) i) % 3600) / 60);
#line 590 "../gpx-viewer/libgpx/gpx-graph.vala"
					text = _tmp15_;
#line 591 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp16_ = text;
#line 591 "../gpx-viewer/libgpx/gpx-graph.vala"
					pango_layout_set_text (layout, _tmp16_, -1);
#line 592 "../gpx-viewer/libgpx/gpx-graph.vala"
					pango_layout_get_pixel_size (layout, &_tmp17_, &_tmp18_);
#line 592 "../gpx-viewer/libgpx/gpx-graph.vala"
					w = _tmp17_;
#line 592 "../gpx-viewer/libgpx/gpx-graph.vala"
					h = _tmp18_;
#line 593 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_move_to (ctx, (graph_width * ((gdouble) (i / elapsed_time))) - (w / 2.0), graph_height + 10);
#line 594 "../gpx-viewer/libgpx/gpx-graph.vala"
					pango_cairo_layout_path (ctx, layout);
#line 597 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_set_line_width (ctx, 1.0);
#line 598 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 1.0);
#line 599 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_fill (ctx);
#line 601 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp19_ = text;
#line 601 "../gpx-viewer/libgpx/gpx-graph.vala"
					g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:601: Set time tick: %s", _tmp19_);
#line 604 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_set_source_rgba (ctx, 0.4, 0.4, 0.4, 0.6);
#line 605 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_set_line_width (ctx, (gdouble) 1);
#line 606 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_move_to (ctx, graph_width * ((gdouble) (i / elapsed_time)), graph_height);
#line 607 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_line_to (ctx, graph_width * ((gdouble) (i / elapsed_time)), graph_height * 0);
#line 608 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_stroke (ctx);
#line 610 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_set_line_width (ctx, 1.5);
#line 611 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 1.0);
#line 612 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_move_to (ctx, graph_width * ((gdouble) (i / elapsed_time)), graph_height + ((graph_height / range) * min_value));
#line 613 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_line_to (ctx, graph_width * ((gdouble) (i / elapsed_time)), (graph_height + ((graph_height / range) * min_value)) + 5);
#line 614 "../gpx-viewer/libgpx/gpx-graph.vala"
					cairo_stroke (ctx);
#line 588 "../gpx-viewer/libgpx/gpx-graph.vala"
					_g_free0 (text);
#line 2886 "gpx-graph.c"
				}
#line 617 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp20_ = current;
#line 617 "../gpx-viewer/libgpx/gpx-graph.vala"
				current = _tmp20_ + 1;
#line 2892 "gpx-graph.c"
			}
		}
	}
}

static gdouble
gpx_graph_calculate_graph_point_value (GpxGraph* self,
                                       GList* ii)
{
	gdouble value = 0.0;
	gdouble result;
#line 624 "../gpx-viewer/libgpx/gpx-graph.vala"
	value = (gdouble) 0;
#line 626 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_SPEED) {
#line 2908 "gpx-graph.c"
		gconstpointer _tmp0_;
#line 627 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp0_ = ii->data;
#line 627 "../gpx-viewer/libgpx/gpx-graph.vala"
		value = ((GpxPoint*) _tmp0_)->speed;
#line 2914 "gpx-graph.c"
	} else {
#line 628 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_ELEVATION) {
#line 2918 "gpx-graph.c"
			gconstpointer _tmp1_;
#line 629 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp1_ = ii->data;
#line 629 "../gpx-viewer/libgpx/gpx-graph.vala"
			value = ((GpxPoint*) _tmp1_)->elevation;
#line 2924 "gpx-graph.c"
		} else {
#line 630 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_TOTAL_DISTANCE) {
#line 2928 "gpx-graph.c"
				gconstpointer _tmp2_;
#line 631 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp2_ = ii->data;
#line 631 "../gpx-viewer/libgpx/gpx-graph.vala"
				value = ((GpxPoint*) _tmp2_)->distance;
#line 2934 "gpx-graph.c"
			} else {
#line 632 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_DISTANCE) {
#line 2938 "gpx-graph.c"
					gconstpointer _tmp3_;
					GList* _tmp4_;
					gconstpointer _tmp5_;
#line 633 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp3_ = ii->data;
#line 633 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp4_ = g_list_first (ii);
#line 633 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp5_ = _tmp4_->data;
#line 633 "../gpx-viewer/libgpx/gpx-graph.vala"
					value = gpx_track_calculate_distance ((GpxPoint*) _tmp3_, (GpxPoint*) _tmp5_);
#line 2950 "gpx-graph.c"
				} else {
					gboolean _tmp6_ = FALSE;
#line 634 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_ACCELERATION_H) {
#line 2955 "gpx-graph.c"
						GList* _tmp7_;
#line 634 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp7_ = ii->prev;
#line 634 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp6_ = _tmp7_ != NULL;
#line 2961 "gpx-graph.c"
					} else {
#line 634 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp6_ = FALSE;
#line 2965 "gpx-graph.c"
					}
#line 634 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (_tmp6_) {
#line 2969 "gpx-graph.c"
						gconstpointer _tmp8_;
						GList* _tmp9_;
						gconstpointer _tmp10_;
						gconstpointer _tmp11_;
						GList* _tmp12_;
						gconstpointer _tmp13_;
						gconstpointer _tmp14_;
						GList* _tmp15_;
						gconstpointer _tmp16_;
#line 635 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp8_ = ii->data;
#line 635 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp9_ = ii->prev;
#line 635 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp10_ = _tmp9_->data;
#line 635 "../gpx-viewer/libgpx/gpx-graph.vala"
						if (gpx_point_get_time ((GpxPoint*) _tmp8_) == gpx_point_get_time ((GpxPoint*) _tmp10_)) {
#line 635 "../gpx-viewer/libgpx/gpx-graph.vala"
							result = (gdouble) 0;
#line 635 "../gpx-viewer/libgpx/gpx-graph.vala"
							return result;
#line 2991 "gpx-graph.c"
						}
#line 636 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp11_ = ii->data;
#line 636 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp12_ = ii->prev;
#line 636 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp13_ = _tmp12_->data;
#line 636 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp14_ = ii->data;
#line 636 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp15_ = ii->prev;
#line 636 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp16_ = _tmp15_->data;
#line 636 "../gpx-viewer/libgpx/gpx-graph.vala"
						value = (((GpxPoint*) _tmp11_)->speed - ((GpxPoint*) _tmp13_)->speed) / (3.6 * (gpx_point_get_time ((GpxPoint*) _tmp14_) - gpx_point_get_time ((GpxPoint*) _tmp16_)));
#line 3007 "gpx-graph.c"
					} else {
						gboolean _tmp17_ = FALSE;
#line 637 "../gpx-viewer/libgpx/gpx-graph.vala"
						if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_SPEED_V) {
#line 3012 "gpx-graph.c"
							GList* _tmp18_;
#line 637 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp18_ = ii->prev;
#line 637 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp17_ = _tmp18_ != NULL;
#line 3018 "gpx-graph.c"
						} else {
#line 637 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp17_ = FALSE;
#line 3022 "gpx-graph.c"
						}
#line 637 "../gpx-viewer/libgpx/gpx-graph.vala"
						if (_tmp17_) {
#line 3026 "gpx-graph.c"
							gconstpointer _tmp19_;
							GList* _tmp20_;
							gconstpointer _tmp21_;
							gconstpointer _tmp22_;
							GList* _tmp23_;
							gconstpointer _tmp24_;
							gconstpointer _tmp25_;
							GList* _tmp26_;
							gconstpointer _tmp27_;
#line 638 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp19_ = ii->data;
#line 638 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp20_ = ii->prev;
#line 638 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp21_ = _tmp20_->data;
#line 638 "../gpx-viewer/libgpx/gpx-graph.vala"
							if (gpx_point_get_time ((GpxPoint*) _tmp19_) == gpx_point_get_time ((GpxPoint*) _tmp21_)) {
#line 638 "../gpx-viewer/libgpx/gpx-graph.vala"
								result = (gdouble) 0;
#line 638 "../gpx-viewer/libgpx/gpx-graph.vala"
								return result;
#line 3048 "gpx-graph.c"
							}
#line 639 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp22_ = ii->data;
#line 639 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp23_ = ii->prev;
#line 639 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp24_ = _tmp23_->data;
#line 639 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp25_ = ii->data;
#line 639 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp26_ = ii->prev;
#line 639 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp27_ = _tmp26_->data;
#line 639 "../gpx-viewer/libgpx/gpx-graph.vala"
							value = (((GpxPoint*) _tmp22_)->elevation - ((GpxPoint*) _tmp24_)->elevation) / (3.6 * (gpx_point_get_time ((GpxPoint*) _tmp25_) - gpx_point_get_time ((GpxPoint*) _tmp27_)));
#line 3064 "gpx-graph.c"
						} else {
#line 640 "../gpx-viewer/libgpx/gpx-graph.vala"
							if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_HEARTRATE) {
#line 3068 "gpx-graph.c"
								gconstpointer _tmp28_;
								GpxHeartRateMonitorPoint _tmp29_;
#line 641 "../gpx-viewer/libgpx/gpx-graph.vala"
								_tmp28_ = ii->data;
#line 641 "../gpx-viewer/libgpx/gpx-graph.vala"
								_tmp29_ = ((GpxPoint*) _tmp28_)->tpe;
#line 641 "../gpx-viewer/libgpx/gpx-graph.vala"
								value = (gdouble) _tmp29_.heartrate;
#line 3077 "gpx-graph.c"
							} else {
#line 642 "../gpx-viewer/libgpx/gpx-graph.vala"
								if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_CADENCE) {
#line 3081 "gpx-graph.c"
									gconstpointer _tmp30_;
#line 643 "../gpx-viewer/libgpx/gpx-graph.vala"
									_tmp30_ = ii->data;
#line 643 "../gpx-viewer/libgpx/gpx-graph.vala"
									value = (gdouble) ((GpxPoint*) _tmp30_)->cadence;
#line 3087 "gpx-graph.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 645 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = value;
#line 645 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 3100 "gpx-graph.c"
}

static gdouble
gpx_graph_calculate_graph_point_smooth_value (GpxGraph* self,
                                              GList* iter)
{
	gdouble result;
#line 649 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (self->priv->_smooth_factor == 1) {
#line 651 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = gpx_graph_calculate_graph_point_value (self, iter);
#line 651 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 3114 "gpx-graph.c"
	} else {
		gdouble speed = 0.0;
		GList* ii = NULL;
		gint _tmp0_ = 0;
		gboolean _tmp1_ = FALSE;
		GList* _tmp2_;
		gconstpointer _tmp3_;
		gint sf = 0;
		gint i = 0;
		gint items = 0;
		GList* _tmp13_;
#line 655 "../gpx-viewer/libgpx/gpx-graph.vala"
		speed = (gdouble) 0;
#line 656 "../gpx-viewer/libgpx/gpx-graph.vala"
		ii = iter;
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp2_ = ii;
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp3_ = _tmp2_->data;
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (((GpxPoint*) _tmp3_)->stopped) {
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp1_ = self->priv->_mode == GPX_GRAPH_GRAPH_MODE_SPEED;
#line 3138 "gpx-graph.c"
		} else {
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp1_ = FALSE;
#line 3142 "gpx-graph.c"
		}
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (_tmp1_) {
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp0_ = 1;
#line 3148 "gpx-graph.c"
		} else {
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp0_ = self->priv->_smooth_factor;
#line 3152 "gpx-graph.c"
		}
#line 657 "../gpx-viewer/libgpx/gpx-graph.vala"
		sf = _tmp0_;
#line 658 "../gpx-viewer/libgpx/gpx-graph.vala"
		items = 0;
#line 3158 "gpx-graph.c"
		{
			gboolean _tmp4_ = FALSE;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
			i = 0;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp4_ = TRUE;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
			while (TRUE) {
#line 3167 "gpx-graph.c"
				gboolean _tmp6_ = FALSE;
				GList* _tmp9_;
				gint _tmp10_;
				GList* _tmp11_;
				GList* _tmp12_;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (!_tmp4_) {
#line 3175 "gpx-graph.c"
					gint _tmp5_;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp5_ = i;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
					i = _tmp5_ + 1;
#line 3181 "gpx-graph.c"
				}
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp4_ = FALSE;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (i < sf) {
#line 3187 "gpx-graph.c"
					GList* _tmp7_;
					GList* _tmp8_;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp7_ = ii;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp8_ = _tmp7_->prev;
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp6_ = _tmp8_ != NULL;
#line 3196 "gpx-graph.c"
				} else {
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp6_ = FALSE;
#line 3200 "gpx-graph.c"
				}
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (!_tmp6_) {
#line 659 "../gpx-viewer/libgpx/gpx-graph.vala"
					break;
#line 3206 "gpx-graph.c"
				}
#line 661 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp9_ = ii;
#line 661 "../gpx-viewer/libgpx/gpx-graph.vala"
				speed += gpx_graph_calculate_graph_point_value (self, _tmp9_);
#line 662 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp10_ = items;
#line 662 "../gpx-viewer/libgpx/gpx-graph.vala"
				items = _tmp10_ + 1;
#line 663 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp11_ = ii;
#line 663 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp12_ = _tmp11_->prev;
#line 663 "../gpx-viewer/libgpx/gpx-graph.vala"
				ii = _tmp12_;
#line 3222 "gpx-graph.c"
			}
		}
#line 665 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp13_ = iter->next;
#line 665 "../gpx-viewer/libgpx/gpx-graph.vala"
		ii = _tmp13_;
#line 3229 "gpx-graph.c"
		{
			gboolean _tmp14_ = FALSE;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
			i = 1;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp14_ = TRUE;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
			while (TRUE) {
#line 3238 "gpx-graph.c"
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				GList* _tmp21_;
				gint _tmp22_;
				GList* _tmp23_;
				GList* _tmp24_;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (!_tmp14_) {
#line 3247 "gpx-graph.c"
					gint _tmp15_;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp15_ = i;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					i = _tmp15_ + 1;
#line 3253 "gpx-graph.c"
				}
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp14_ = FALSE;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (i < sf) {
#line 3259 "gpx-graph.c"
					GList* _tmp18_;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp18_ = ii;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp17_ = _tmp18_ != NULL;
#line 3265 "gpx-graph.c"
				} else {
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp17_ = FALSE;
#line 3269 "gpx-graph.c"
				}
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (_tmp17_) {
#line 3273 "gpx-graph.c"
					GList* _tmp19_;
					GList* _tmp20_;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp19_ = ii;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp20_ = _tmp19_->next;
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp16_ = _tmp20_ != NULL;
#line 3282 "gpx-graph.c"
				} else {
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp16_ = FALSE;
#line 3286 "gpx-graph.c"
				}
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (!_tmp16_) {
#line 666 "../gpx-viewer/libgpx/gpx-graph.vala"
					break;
#line 3292 "gpx-graph.c"
				}
#line 668 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp21_ = ii;
#line 668 "../gpx-viewer/libgpx/gpx-graph.vala"
				speed += gpx_graph_calculate_graph_point_value (self, _tmp21_);
#line 669 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp22_ = items;
#line 669 "../gpx-viewer/libgpx/gpx-graph.vala"
				items = _tmp22_ + 1;
#line 670 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp23_ = ii;
#line 670 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp24_ = _tmp23_->next;
#line 670 "../gpx-viewer/libgpx/gpx-graph.vala"
				ii = _tmp24_;
#line 3308 "gpx-graph.c"
			}
		}
#line 672 "../gpx-viewer/libgpx/gpx-graph.vala"
		speed = speed / items;
#line 673 "../gpx-viewer/libgpx/gpx-graph.vala"
		result = speed;
#line 673 "../gpx-viewer/libgpx/gpx-graph.vala"
		return result;
#line 3317 "gpx-graph.c"
	}
}

static void
gpx_graph_update_surface (GpxGraph* self,
                          GtkWidget* win)
{
	cairo_t* ctx = NULL;
	GdkWindow* _tmp0_;
	cairo_t* _tmp1_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp2_ = {0};
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	GtkAllocation _tmp5_;
	GtkAllocation _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GpxTrack* _tmp13_;
	gdouble max_value = 0.0;
	gdouble min_value = 0.0;
	gdouble range = 0.0;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gdouble elapsed_time = 0.0;
	GpxTrack* _tmp73_;
	cairo_t* _tmp74_;
	GpxPoint* f = NULL;
	GpxTrack* _tmp75_;
	GList* _tmp76_;
	gconstpointer _tmp77_;
	GpxPoint* _tmp78_;
	gdouble graph_width = 0.0;
	GtkAllocation _tmp79_;
	gdouble graph_height = 0.0;
	GtkAllocation _tmp80_;
	PangoLayout* layout = NULL;
	cairo_t* _tmp81_;
	PangoLayout* _tmp82_;
	cairo_t* _tmp83_;
	PangoLayout* _tmp84_;
	cairo_t* _tmp85_;
	cairo_t* _tmp86_;
	GList* iter = NULL;
	GpxTrack* _tmp87_;
	GList* _tmp88_;
	GList* _tmp89_;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp120_ = FALSE;
	cairo_t* _tmp123_;
	cairo_t* _tmp124_;
	cairo_t* _tmp125_;
	cairo_t* _tmp126_;
	gboolean _tmp127_;
	gboolean _tmp128_;
	gint w = 0;
	gint h = 0;
	cairo_t* _tmp170_;
	PangoFontDescription* _tmp171_;
	PangoLayout* _tmp172_;
	PangoFontDescription* _tmp173_;
	gchar* mtext = NULL;
	gchar* _tmp174_;
	PangoLayout* _tmp189_;
	gint _tmp190_ = 0;
	gint _tmp191_ = 0;
	cairo_t* _tmp192_;
	cairo_t* _tmp193_;
	PangoLayout* _tmp194_;
	cairo_t* _tmp195_;
#line 678 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = gtk_widget_get_window (win);
#line 678 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = gdk_cairo_create (_tmp0_);
#line 678 "../gpx-viewer/libgpx/gpx-graph.vala"
	ctx = _tmp1_;
#line 679 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:679: Updating surface");
#line 684 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_get_allocation (win, &_tmp2_);
#line 684 "../gpx-viewer/libgpx/gpx-graph.vala"
	alloc = _tmp2_;
#line 686 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp3_ = ctx;
#line 686 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp4_ = cairo_get_target (_tmp3_);
#line 686 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp5_ = alloc;
#line 686 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp6_ = alloc;
#line 686 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_ = cairo_surface_create_similar (_tmp4_, CAIRO_CONTENT_COLOR_ALPHA, _tmp5_.width, _tmp6_.height);
#line 686 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_surface_destroy0 (self->priv->surf);
#line 686 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->surf = _tmp7_;
#line 689 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp8_ = self->priv->surf;
#line 689 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp9_ = cairo_create (_tmp8_);
#line 689 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_destroy0 (ctx);
#line 689 "../gpx-viewer/libgpx/gpx-graph.vala"
	ctx = _tmp9_;
#line 692 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp10_ = ctx;
#line 692 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_source_rgba (_tmp10_, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 693 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp11_ = ctx;
#line 693 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_paint (_tmp11_);
#line 695 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp13_ = self->track;
#line 695 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp13_ == NULL) {
#line 695 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp12_ = TRUE;
#line 3440 "gpx-graph.c"
	} else {
		GpxTrack* _tmp14_;
		GList* _tmp15_;
#line 695 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp14_ = self->track;
#line 695 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp15_ = _tmp14_->points;
#line 695 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp12_ = _tmp15_ == NULL;
#line 3450 "gpx-graph.c"
	}
#line 695 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp12_) {
#line 696 "../gpx-viewer/libgpx/gpx-graph.vala"
		_cairo_destroy0 (ctx);
#line 696 "../gpx-viewer/libgpx/gpx-graph.vala"
		return;
#line 3458 "gpx-graph.c"
	}
#line 698 "../gpx-viewer/libgpx/gpx-graph.vala"
	max_value = (gdouble) 0;
#line 699 "../gpx-viewer/libgpx/gpx-graph.vala"
	min_value = (gdouble) 0;
#line 700 "../gpx-viewer/libgpx/gpx-graph.vala"
	range = (gdouble) 0;
#line 701 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_SPEED) {
#line 701 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp17_ = TRUE;
#line 3470 "gpx-graph.c"
	} else {
#line 701 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp17_ = self->priv->_mode == GPX_GRAPH_GRAPH_MODE_DISTANCE;
#line 3474 "gpx-graph.c"
	}
#line 701 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp17_) {
#line 701 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp16_ = TRUE;
#line 3480 "gpx-graph.c"
	} else {
#line 701 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp16_ = self->priv->_mode == GPX_GRAPH_GRAPH_MODE_TOTAL_DISTANCE;
#line 3484 "gpx-graph.c"
	}
#line 701 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp16_) {
#line 3488 "gpx-graph.c"
		GList* iter = NULL;
		GpxTrack* _tmp18_;
		GList* _tmp19_;
		GList* _tmp20_;
#line 703 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp18_ = self->track;
#line 703 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp19_ = _tmp18_->points;
#line 703 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp20_ = g_list_first (_tmp19_);
#line 703 "../gpx-viewer/libgpx/gpx-graph.vala"
		iter = _tmp20_;
#line 704 "../gpx-viewer/libgpx/gpx-graph.vala"
		while (TRUE) {
#line 3503 "gpx-graph.c"
			GList* _tmp21_;
			GList* _tmp22_;
			GList* ii = NULL;
			GList* _tmp23_;
			GList* _tmp24_;
			gdouble speed = 0.0;
			GList* _tmp25_;
			gdouble _tmp26_ = 0.0;
			GList* _tmp27_;
			GList* _tmp28_;
#line 704 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp21_ = iter;
#line 704 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp22_ = _tmp21_->next;
#line 704 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (!(_tmp22_ != NULL)) {
#line 704 "../gpx-viewer/libgpx/gpx-graph.vala"
				break;
#line 3522 "gpx-graph.c"
			}
#line 706 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp23_ = iter;
#line 706 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp24_ = _tmp23_->next;
#line 706 "../gpx-viewer/libgpx/gpx-graph.vala"
			ii = _tmp24_;
#line 707 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp25_ = ii;
#line 707 "../gpx-viewer/libgpx/gpx-graph.vala"
			speed = gpx_graph_calculate_graph_point_smooth_value (self, _tmp25_) - min_value;
#line 708 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (speed > max_value) {
#line 708 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp26_ = speed;
#line 3538 "gpx-graph.c"
			} else {
#line 708 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp26_ = max_value;
#line 3542 "gpx-graph.c"
			}
#line 708 "../gpx-viewer/libgpx/gpx-graph.vala"
			max_value = _tmp26_;
#line 709 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp27_ = iter;
#line 709 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp28_ = _tmp27_->next;
#line 709 "../gpx-viewer/libgpx/gpx-graph.vala"
			iter = _tmp28_;
#line 3552 "gpx-graph.c"
		}
	} else {
#line 711 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_ELEVATION) {
#line 3557 "gpx-graph.c"
			GpxTrack* _tmp29_;
			GpxTrack* _tmp30_;
#line 712 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp29_ = self->track;
#line 712 "../gpx-viewer/libgpx/gpx-graph.vala"
			max_value = _tmp29_->max_elevation;
#line 713 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp30_ = self->track;
#line 713 "../gpx-viewer/libgpx/gpx-graph.vala"
			min_value = _tmp30_->min_elevation;
#line 3568 "gpx-graph.c"
		} else {
			gboolean _tmp31_ = FALSE;
#line 714 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_SPEED_V) {
#line 714 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp31_ = TRUE;
#line 3575 "gpx-graph.c"
			} else {
#line 714 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp31_ = self->priv->_mode == GPX_GRAPH_GRAPH_MODE_ACCELERATION_H;
#line 3579 "gpx-graph.c"
			}
#line 714 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp31_) {
#line 3583 "gpx-graph.c"
				GList* iter = NULL;
				GpxTrack* _tmp32_;
				GList* _tmp33_;
				GList* _tmp34_;
#line 715 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp32_ = self->track;
#line 715 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp33_ = _tmp32_->points;
#line 715 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp34_ = g_list_first (_tmp33_);
#line 715 "../gpx-viewer/libgpx/gpx-graph.vala"
				iter = _tmp34_;
#line 716 "../gpx-viewer/libgpx/gpx-graph.vala"
				while (TRUE) {
#line 3598 "gpx-graph.c"
					GList* _tmp35_;
					GList* _tmp36_;
					GList* ii = NULL;
					GList* _tmp37_;
					GList* _tmp38_;
					gdouble speed = 0.0;
					GList* _tmp39_;
					gdouble _tmp40_ = 0.0;
					gdouble _tmp41_ = 0.0;
					GList* _tmp42_;
					GList* _tmp43_;
#line 716 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp35_ = iter;
#line 716 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp36_ = _tmp35_->next;
#line 716 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (!(_tmp36_ != NULL)) {
#line 716 "../gpx-viewer/libgpx/gpx-graph.vala"
						break;
#line 3618 "gpx-graph.c"
					}
#line 718 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp37_ = iter;
#line 718 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp38_ = _tmp37_->next;
#line 718 "../gpx-viewer/libgpx/gpx-graph.vala"
					ii = _tmp38_;
#line 719 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp39_ = ii;
#line 719 "../gpx-viewer/libgpx/gpx-graph.vala"
					speed = gpx_graph_calculate_graph_point_smooth_value (self, _tmp39_) - min_value;
#line 720 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (speed > max_value) {
#line 720 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp40_ = speed;
#line 3634 "gpx-graph.c"
					} else {
#line 720 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp40_ = max_value;
#line 3638 "gpx-graph.c"
					}
#line 720 "../gpx-viewer/libgpx/gpx-graph.vala"
					max_value = _tmp40_;
#line 721 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (speed < min_value) {
#line 721 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp41_ = speed;
#line 3646 "gpx-graph.c"
					} else {
#line 721 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp41_ = min_value;
#line 3650 "gpx-graph.c"
					}
#line 721 "../gpx-viewer/libgpx/gpx-graph.vala"
					min_value = _tmp41_;
#line 722 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp42_ = iter;
#line 722 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp43_ = _tmp42_->next;
#line 722 "../gpx-viewer/libgpx/gpx-graph.vala"
					iter = _tmp43_;
#line 3660 "gpx-graph.c"
				}
			} else {
				GpxGraphGraphMode _tmp44_;
				GpxGraphGraphMode _tmp45_;
#line 724 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp44_ = gpx_graph_get_mode (self);
#line 724 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp45_ = _tmp44_;
#line 724 "../gpx-viewer/libgpx/gpx-graph.vala"
				if (_tmp45_ == GPX_GRAPH_GRAPH_MODE_HEARTRATE) {
#line 3671 "gpx-graph.c"
					GList* iter = NULL;
					GpxTrack* _tmp46_;
					GList* _tmp47_;
					GList* _tmp48_;
#line 725 "../gpx-viewer/libgpx/gpx-graph.vala"
					min_value = 0.0;
#line 726 "../gpx-viewer/libgpx/gpx-graph.vala"
					max_value = 0.0;
#line 727 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp46_ = self->track;
#line 727 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp47_ = _tmp46_->points;
#line 727 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp48_ = g_list_first (_tmp47_);
#line 727 "../gpx-viewer/libgpx/gpx-graph.vala"
					iter = _tmp48_;
#line 728 "../gpx-viewer/libgpx/gpx-graph.vala"
					while (TRUE) {
#line 3690 "gpx-graph.c"
						GList* _tmp49_;
						GList* _tmp50_;
						GList* ii = NULL;
						GList* _tmp51_;
						GList* _tmp52_;
						gdouble speed = 0.0;
						GList* _tmp53_;
						gdouble _tmp54_ = 0.0;
						GList* _tmp55_;
						GList* _tmp56_;
#line 728 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp49_ = iter;
#line 728 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp50_ = _tmp49_->next;
#line 728 "../gpx-viewer/libgpx/gpx-graph.vala"
						if (!(_tmp50_ != NULL)) {
#line 728 "../gpx-viewer/libgpx/gpx-graph.vala"
							break;
#line 3709 "gpx-graph.c"
						}
#line 730 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp51_ = iter;
#line 730 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp52_ = _tmp51_->next;
#line 730 "../gpx-viewer/libgpx/gpx-graph.vala"
						ii = _tmp52_;
#line 731 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp53_ = ii;
#line 731 "../gpx-viewer/libgpx/gpx-graph.vala"
						speed = gpx_graph_calculate_graph_point_smooth_value (self, _tmp53_);
#line 732 "../gpx-viewer/libgpx/gpx-graph.vala"
						if (speed > max_value) {
#line 732 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp54_ = speed;
#line 3725 "gpx-graph.c"
						} else {
#line 732 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp54_ = max_value;
#line 3729 "gpx-graph.c"
						}
#line 732 "../gpx-viewer/libgpx/gpx-graph.vala"
						max_value = _tmp54_;
#line 733 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp55_ = iter;
#line 733 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp56_ = _tmp55_->next;
#line 733 "../gpx-viewer/libgpx/gpx-graph.vala"
						iter = _tmp56_;
#line 3739 "gpx-graph.c"
					}
				} else {
					GpxGraphGraphMode _tmp57_;
					GpxGraphGraphMode _tmp58_;
#line 735 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp57_ = gpx_graph_get_mode (self);
#line 735 "../gpx-viewer/libgpx/gpx-graph.vala"
					_tmp58_ = _tmp57_;
#line 735 "../gpx-viewer/libgpx/gpx-graph.vala"
					if (_tmp58_ == GPX_GRAPH_GRAPH_MODE_CADENCE) {
#line 3750 "gpx-graph.c"
						GList* iter = NULL;
						GpxTrack* _tmp59_;
						GList* _tmp60_;
						GList* _tmp61_;
#line 736 "../gpx-viewer/libgpx/gpx-graph.vala"
						max_value = 0.0;
#line 737 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp59_ = self->track;
#line 737 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp60_ = _tmp59_->points;
#line 737 "../gpx-viewer/libgpx/gpx-graph.vala"
						_tmp61_ = g_list_first (_tmp60_);
#line 737 "../gpx-viewer/libgpx/gpx-graph.vala"
						iter = _tmp61_;
#line 738 "../gpx-viewer/libgpx/gpx-graph.vala"
						while (TRUE) {
#line 3767 "gpx-graph.c"
							GList* _tmp62_;
							GList* _tmp63_;
							GList* ii = NULL;
							GList* _tmp64_;
							GList* _tmp65_;
							gdouble _tmp66_ = 0.0;
							GList* _tmp67_;
							gconstpointer _tmp68_;
							GList* _tmp71_;
							GList* _tmp72_;
#line 738 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp62_ = iter;
#line 738 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp63_ = _tmp62_->next;
#line 738 "../gpx-viewer/libgpx/gpx-graph.vala"
							if (!(_tmp63_ != NULL)) {
#line 738 "../gpx-viewer/libgpx/gpx-graph.vala"
								break;
#line 3786 "gpx-graph.c"
							}
#line 740 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp64_ = iter;
#line 740 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp65_ = _tmp64_->next;
#line 740 "../gpx-viewer/libgpx/gpx-graph.vala"
							ii = _tmp65_;
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp67_ = ii;
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp68_ = _tmp67_->data;
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
							if (((gdouble) ((GpxPoint*) _tmp68_)->cadence) > max_value) {
#line 3800 "gpx-graph.c"
								GList* _tmp69_;
								gconstpointer _tmp70_;
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
								_tmp69_ = ii;
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
								_tmp70_ = _tmp69_->data;
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
								_tmp66_ = (gdouble) ((GpxPoint*) _tmp70_)->cadence;
#line 3809 "gpx-graph.c"
							} else {
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
								_tmp66_ = max_value;
#line 3813 "gpx-graph.c"
							}
#line 741 "../gpx-viewer/libgpx/gpx-graph.vala"
							max_value = _tmp66_;
#line 742 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp71_ = iter;
#line 742 "../gpx-viewer/libgpx/gpx-graph.vala"
							_tmp72_ = _tmp71_->next;
#line 742 "../gpx-viewer/libgpx/gpx-graph.vala"
							iter = _tmp72_;
#line 3823 "gpx-graph.c"
						}
					}
				}
			}
		}
	}
#line 746 "../gpx-viewer/libgpx/gpx-graph.vala"
	max_value = ceil (max_value);
#line 748 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (max_value == min_value) {
#line 748 "../gpx-viewer/libgpx/gpx-graph.vala"
		_cairo_destroy0 (ctx);
#line 748 "../gpx-viewer/libgpx/gpx-graph.vala"
		return;
#line 3838 "gpx-graph.c"
	}
#line 750 "../gpx-viewer/libgpx/gpx-graph.vala"
	range = max_value - min_value;
#line 752 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp73_ = self->track;
#line 752 "../gpx-viewer/libgpx/gpx-graph.vala"
	elapsed_time = (gdouble) gpx_track_get_total_time (_tmp73_);
#line 754 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:754: Draw Axis");
#line 757 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp74_ = ctx;
#line 757 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_translate (_tmp74_, (gdouble) self->priv->LEFT_OFFSET, (gdouble) 20);
#line 758 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp75_ = self->track;
#line 758 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp76_ = _tmp75_->points;
#line 758 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp77_ = _tmp76_->data;
#line 758 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp78_ = _gpx_point_ref0 ((GpxPoint*) _tmp77_);
#line 758 "../gpx-viewer/libgpx/gpx-graph.vala"
	f = _tmp78_;
#line 760 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp79_ = alloc;
#line 760 "../gpx-viewer/libgpx/gpx-graph.vala"
	graph_width = (gdouble) ((_tmp79_.width - self->priv->LEFT_OFFSET) - self->priv->RIGHT_OFFSET);
#line 761 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp80_ = alloc;
#line 761 "../gpx-viewer/libgpx/gpx-graph.vala"
	graph_height = (gdouble) ((_tmp80_.height - 20) - self->priv->BOTTOM_OFFSET);
#line 762 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (graph_height < ((gdouble) 50)) {
#line 762 "../gpx-viewer/libgpx/gpx-graph.vala"
		_gpx_point_unref0 (f);
#line 762 "../gpx-viewer/libgpx/gpx-graph.vala"
		_cairo_destroy0 (ctx);
#line 762 "../gpx-viewer/libgpx/gpx-graph.vala"
		return;
#line 3878 "gpx-graph.c"
	}
#line 763 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp81_ = ctx;
#line 763 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp82_ = pango_cairo_create_layout (_tmp81_);
#line 763 "../gpx-viewer/libgpx/gpx-graph.vala"
	layout = _tmp82_;
#line 767 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp83_ = ctx;
#line 767 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp84_ = layout;
#line 767 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_draw_grid (self, _tmp83_, _tmp84_, graph_width, graph_height, min_value, max_value, elapsed_time);
#line 771 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp85_ = ctx;
#line 771 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_source_rgba (_tmp85_, 0.1, 0.2, 0.3, (gdouble) 1);
#line 772 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp86_ = ctx;
#line 772 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_line_width (_tmp86_, (gdouble) 1);
#line 773 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp87_ = self->track;
#line 773 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp88_ = _tmp87_->points;
#line 773 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp89_ = g_list_first (_tmp88_);
#line 773 "../gpx-viewer/libgpx/gpx-graph.vala"
	iter = _tmp89_;
#line 776 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (min_value < ((gdouble) 0)) {
#line 776 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp90_ = max_value > ((gdouble) 0);
#line 3912 "gpx-graph.c"
	} else {
#line 776 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp90_ = FALSE;
#line 3916 "gpx-graph.c"
	}
#line 776 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp90_) {
#line 3920 "gpx-graph.c"
		cairo_t* _tmp91_;
#line 777 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp91_ = ctx;
#line 777 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_move_to (_tmp91_, 0.0, graph_height * (max_value / range));
#line 3926 "gpx-graph.c"
	} else {
		cairo_t* _tmp92_;
#line 779 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp92_ = ctx;
#line 779 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_move_to (_tmp92_, 0.0, graph_height);
#line 3933 "gpx-graph.c"
	}
#line 783 "../gpx-viewer/libgpx/gpx-graph.vala"
	while (TRUE) {
#line 3937 "gpx-graph.c"
		GList* _tmp93_;
		GList* _tmp94_;
		gdouble time_offset = 0.0;
		GList* _tmp95_;
		gconstpointer _tmp96_;
		GpxPoint* _tmp97_;
		gdouble speed = 0.0;
		GList* _tmp98_;
		GList* _tmp118_;
		GList* _tmp119_;
#line 783 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp93_ = iter;
#line 783 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp94_ = _tmp93_->next;
#line 783 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (!(_tmp94_ != NULL)) {
#line 783 "../gpx-viewer/libgpx/gpx-graph.vala"
			break;
#line 3956 "gpx-graph.c"
		}
#line 785 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp95_ = iter;
#line 785 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp96_ = _tmp95_->data;
#line 785 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp97_ = f;
#line 785 "../gpx-viewer/libgpx/gpx-graph.vala"
		time_offset = (gdouble) (gpx_point_get_time ((GpxPoint*) _tmp96_) - gpx_point_get_time (_tmp97_));
#line 786 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp98_ = iter;
#line 786 "../gpx-viewer/libgpx/gpx-graph.vala"
		speed = gpx_graph_calculate_graph_point_smooth_value (self, _tmp98_) - min_value;
#line 787 "../gpx-viewer/libgpx/gpx-graph.vala"
		if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_SPEED) {
#line 3972 "gpx-graph.c"
			gboolean _tmp99_ = FALSE;
			GList* _tmp100_;
			GList* _tmp101_;
			GList* _tmp106_;
			gconstpointer _tmp107_;
			gboolean _tmp110_ = FALSE;
			GList* _tmp111_;
			GList* _tmp112_;
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp100_ = iter;
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp101_ = _tmp100_->prev;
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp101_ != NULL) {
#line 3987 "gpx-graph.c"
				GList* _tmp102_;
				GList* _tmp103_;
				gconstpointer _tmp104_;
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp102_ = iter;
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp103_ = _tmp102_->prev;
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp104_ = _tmp103_->data;
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp99_ = ((GpxPoint*) _tmp104_)->stopped;
#line 3999 "gpx-graph.c"
			} else {
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp99_ = FALSE;
#line 4003 "gpx-graph.c"
			}
#line 790 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp99_) {
#line 4007 "gpx-graph.c"
				cairo_t* _tmp105_;
#line 791 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp105_ = ctx;
#line 791 "../gpx-viewer/libgpx/gpx-graph.vala"
				cairo_line_to (_tmp105_, graph_width * ((gdouble) (time_offset / ((gdouble) elapsed_time))), graph_height);
#line 4013 "gpx-graph.c"
			}
#line 795 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp106_ = iter;
#line 795 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp107_ = _tmp106_->data;
#line 795 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (((GpxPoint*) _tmp107_)->stopped) {
#line 4021 "gpx-graph.c"
				cairo_t* _tmp108_;
#line 797 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp108_ = ctx;
#line 797 "../gpx-viewer/libgpx/gpx-graph.vala"
				cairo_line_to (_tmp108_, graph_width * ((gdouble) (time_offset / ((gdouble) elapsed_time))), graph_height);
#line 4027 "gpx-graph.c"
			} else {
				cairo_t* _tmp109_;
#line 800 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp109_ = ctx;
#line 800 "../gpx-viewer/libgpx/gpx-graph.vala"
				cairo_line_to (_tmp109_, graph_width * ((gdouble) (time_offset / ((gdouble) elapsed_time))), graph_height * ((gdouble) (1.0 - (speed / range))));
#line 4034 "gpx-graph.c"
			}
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp111_ = iter;
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp112_ = _tmp111_->next;
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp112_ != NULL) {
#line 4042 "gpx-graph.c"
				GList* _tmp113_;
				GList* _tmp114_;
				gconstpointer _tmp115_;
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp113_ = iter;
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp114_ = _tmp113_->next;
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp115_ = _tmp114_->data;
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp110_ = ((GpxPoint*) _tmp115_)->stopped;
#line 4054 "gpx-graph.c"
			} else {
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp110_ = FALSE;
#line 4058 "gpx-graph.c"
			}
#line 805 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (_tmp110_) {
#line 4062 "gpx-graph.c"
				cairo_t* _tmp116_;
#line 806 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp116_ = ctx;
#line 806 "../gpx-viewer/libgpx/gpx-graph.vala"
				cairo_line_to (_tmp116_, graph_width * ((gdouble) (time_offset / ((gdouble) elapsed_time))), graph_height * ((gdouble) 1.0));
#line 4068 "gpx-graph.c"
			}
		} else {
			cairo_t* _tmp117_;
#line 810 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp117_ = ctx;
#line 810 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_line_to (_tmp117_, graph_width * ((gdouble) (time_offset / ((gdouble) elapsed_time))), graph_height * ((gdouble) (1.0 - (speed / range))));
#line 4076 "gpx-graph.c"
		}
#line 814 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp118_ = iter;
#line 814 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp119_ = _tmp118_->next;
#line 814 "../gpx-viewer/libgpx/gpx-graph.vala"
		iter = _tmp119_;
#line 4084 "gpx-graph.c"
	}
#line 817 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (min_value < ((gdouble) 0)) {
#line 817 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp120_ = max_value > ((gdouble) 0);
#line 4090 "gpx-graph.c"
	} else {
#line 817 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp120_ = FALSE;
#line 4094 "gpx-graph.c"
	}
#line 817 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp120_) {
#line 4098 "gpx-graph.c"
		cairo_t* _tmp121_;
#line 818 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp121_ = ctx;
#line 818 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_line_to (_tmp121_, graph_width, graph_height * (max_value / range));
#line 4104 "gpx-graph.c"
	} else {
		cairo_t* _tmp122_;
#line 820 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp122_ = ctx;
#line 820 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_line_to (_tmp122_, graph_width, graph_height * 1);
#line 4111 "gpx-graph.c"
	}
#line 823 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp123_ = ctx;
#line 823 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_close_path (_tmp123_);
#line 824 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp124_ = ctx;
#line 824 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_stroke_preserve (_tmp124_);
#line 826 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp125_ = ctx;
#line 826 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_source_rgba (_tmp125_, 0.6, 0.8, 0.9, 0.8);
#line 827 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp126_ = ctx;
#line 827 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_fill (_tmp126_);
#line 829 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp127_ = gpx_graph_get_show_points (self);
#line 829 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp128_ = _tmp127_;
#line 829 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (_tmp128_) {
#line 4135 "gpx-graph.c"
		cairo_t* _tmp129_;
		GpxTrack* _tmp130_;
		GList* _tmp131_;
		GList* _tmp132_;
#line 830 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:830: Draw data points");
#line 832 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp129_ = ctx;
#line 832 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_set_source_rgba (_tmp129_, 0.0, 0.0, 0.0, 1.0);
#line 833 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp130_ = self->track;
#line 833 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp131_ = _tmp130_->points;
#line 833 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp132_ = g_list_first (_tmp131_);
#line 833 "../gpx-viewer/libgpx/gpx-graph.vala"
		iter = _tmp132_;
#line 834 "../gpx-viewer/libgpx/gpx-graph.vala"
		while (TRUE) {
#line 4156 "gpx-graph.c"
			GList* _tmp133_;
			GList* _tmp134_;
			GList* ii = NULL;
			GList* _tmp135_;
			GList* _tmp136_;
			gdouble time_offset = 0.0;
			GList* _tmp137_;
			gconstpointer _tmp138_;
			GpxPoint* _tmp139_;
			gdouble speed = 0.0;
			GList* _tmp140_;
			GList* _tmp141_;
			gconstpointer _tmp142_;
			cairo_t* _tmp145_;
			cairo_t* _tmp146_;
			GList* _tmp147_;
			GList* _tmp148_;
#line 834 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp133_ = iter;
#line 834 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp134_ = _tmp133_->next;
#line 834 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (!(_tmp134_ != NULL)) {
#line 834 "../gpx-viewer/libgpx/gpx-graph.vala"
				break;
#line 4182 "gpx-graph.c"
			}
#line 836 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp135_ = iter;
#line 836 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp136_ = _tmp135_->next;
#line 836 "../gpx-viewer/libgpx/gpx-graph.vala"
			ii = _tmp136_;
#line 837 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp137_ = ii;
#line 837 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp138_ = _tmp137_->data;
#line 837 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp139_ = f;
#line 837 "../gpx-viewer/libgpx/gpx-graph.vala"
			time_offset = (gdouble) (gpx_point_get_time ((GpxPoint*) _tmp138_) - gpx_point_get_time (_tmp139_));
#line 838 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp140_ = ii;
#line 838 "../gpx-viewer/libgpx/gpx-graph.vala"
			speed = gpx_graph_calculate_graph_point_smooth_value (self, _tmp140_) - min_value;
#line 841 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp141_ = ii;
#line 841 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp142_ = _tmp141_->data;
#line 841 "../gpx-viewer/libgpx/gpx-graph.vala"
			if (((GpxPoint*) _tmp142_)->stopped) {
#line 4208 "gpx-graph.c"
				cairo_t* _tmp143_;
#line 842 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp143_ = ctx;
#line 842 "../gpx-viewer/libgpx/gpx-graph.vala"
				cairo_set_source_rgba (_tmp143_, 1.0, 0.0, 0.0, 1.0);
#line 4214 "gpx-graph.c"
			} else {
				cairo_t* _tmp144_;
#line 844 "../gpx-viewer/libgpx/gpx-graph.vala"
				_tmp144_ = ctx;
#line 844 "../gpx-viewer/libgpx/gpx-graph.vala"
				cairo_set_source_rgba (_tmp144_, 0.0, 0.0, 0.0, 1.0);
#line 4221 "gpx-graph.c"
			}
#line 846 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp145_ = ctx;
#line 846 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_rectangle (_tmp145_, (graph_width * ((gdouble) (time_offset / ((gdouble) elapsed_time)))) - 1, (graph_height * ((gdouble) (1.0 - (speed / range)))) - 1, (gdouble) 2, (gdouble) 2);
#line 848 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp146_ = ctx;
#line 848 "../gpx-viewer/libgpx/gpx-graph.vala"
			cairo_stroke (_tmp146_);
#line 850 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp147_ = iter;
#line 850 "../gpx-viewer/libgpx/gpx-graph.vala"
			_tmp148_ = _tmp147_->next;
#line 850 "../gpx-viewer/libgpx/gpx-graph.vala"
			iter = _tmp148_;
#line 4237 "gpx-graph.c"
		}
	}
#line 854 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:854: Draw graph");
#line 856 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (self->priv->_mode == GPX_GRAPH_GRAPH_MODE_SPEED) {
#line 4244 "gpx-graph.c"
		gdouble avg = 0.0;
		GpxTrack* _tmp149_;
		cairo_t* _tmp150_;
		cairo_t* _tmp151_;
		cairo_t* _tmp152_;
		cairo_t* _tmp153_;
		cairo_t* _tmp154_;
		time_t moving_time = 0;
		GpxTrack* _tmp155_;
		GpxTrack* _tmp156_;
		GList* _tmp157_;
		GList* _tmp158_;
		gconstpointer _tmp159_;
		GpxTrack* _tmp160_;
		GList* _tmp161_;
		GList* _tmp162_;
		gconstpointer _tmp163_;
		time_t _tmp164_ = 0;
		gdouble _tmp165_;
		cairo_t* _tmp166_;
		cairo_t* _tmp167_;
		cairo_t* _tmp168_;
		cairo_t* _tmp169_;
#line 859 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp149_ = self->track;
#line 859 "../gpx-viewer/libgpx/gpx-graph.vala"
		avg = gpx_track_get_track_average (_tmp149_);
#line 860 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp150_ = ctx;
#line 860 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_move_to (_tmp150_, 0.0, graph_height * (1 - (avg / max_value)));
#line 861 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp151_ = ctx;
#line 861 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_line_to (_tmp151_, graph_width, graph_height * (1 - (avg / max_value)));
#line 863 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp152_ = ctx;
#line 863 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_set_line_width (_tmp152_, 2.5);
#line 864 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp153_ = ctx;
#line 864 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_set_source_rgba (_tmp153_, 1.00, 0.33, 0.00, 1.0);
#line 865 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp154_ = ctx;
#line 865 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_stroke (_tmp154_);
#line 866 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:866: Draw average speed line @ %.02f km/h", avg);
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp155_ = self->track;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp156_ = self->track;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp157_ = _tmp156_->points;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp158_ = g_list_first (_tmp157_);
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp159_ = _tmp158_->data;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp160_ = self->track;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp161_ = _tmp160_->points;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp162_ = g_list_last (_tmp161_);
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp163_ = _tmp162_->data;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp165_ = gpx_track_calculate_moving_average (_tmp155_, (GpxPoint*) _tmp159_, (GpxPoint*) _tmp163_, &_tmp164_);
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		moving_time = _tmp164_;
#line 870 "../gpx-viewer/libgpx/gpx-graph.vala"
		avg = _tmp165_;
#line 871 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp166_ = ctx;
#line 871 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_set_source_rgba (_tmp166_, 0.7, 0.0, 0.0, 1.0);
#line 872 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp167_ = ctx;
#line 872 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_move_to (_tmp167_, 0.0, graph_height * (1 - (avg / max_value)));
#line 873 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp168_ = ctx;
#line 873 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_line_to (_tmp168_, graph_width, graph_height * (1 - (avg / max_value)));
#line 874 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp169_ = ctx;
#line 874 "../gpx-viewer/libgpx/gpx-graph.vala"
		cairo_stroke (_tmp169_);
#line 876 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:876: Draw moving average speed line @ %.02f km/h", avg);
#line 4336 "gpx-graph.c"
	}
#line 881 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp170_ = ctx;
#line 881 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_set_source_rgba (_tmp170_, 0.0, 0.0, 0.0, 1.0);
#line 882 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp171_ = self->priv->fd;
#line 882 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_font_description_set_absolute_size (_tmp171_, (gdouble) (12 * 1024));
#line 883 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp172_ = layout;
#line 883 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp173_ = self->priv->fd;
#line 883 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_layout_set_font_description (_tmp172_, _tmp173_);
#line 884 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp174_ = g_strdup ("");
#line 884 "../gpx-viewer/libgpx/gpx-graph.vala"
	mtext = _tmp174_;
#line 885 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (self->priv->_do_miles) {
#line 4358 "gpx-graph.c"
		gchar** _tmp175_;
		gint _tmp175__length1;
		const gchar* _tmp176_;
		gchar* _tmp177_;
#line 886 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp175_ = gpx_graph_GraphModeMiles;
#line 886 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp175__length1 = gpx_graph_GraphModeMiles_length1;
#line 886 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp176_ = _tmp175_[self->priv->_mode];
#line 886 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp177_ = g_strdup (_ (_tmp176_));
#line 886 "../gpx-viewer/libgpx/gpx-graph.vala"
		_g_free0 (mtext);
#line 886 "../gpx-viewer/libgpx/gpx-graph.vala"
		mtext = _tmp177_;
#line 4375 "gpx-graph.c"
	} else {
		gchar** _tmp178_;
		gint _tmp178__length1;
		const gchar* _tmp179_;
		gchar* _tmp180_;
#line 888 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp178_ = gpx_graph_GraphModeName;
#line 888 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp178__length1 = gpx_graph_GraphModeName_length1;
#line 888 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp179_ = _tmp178_[self->priv->_mode];
#line 888 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp180_ = g_strdup (_ (_tmp179_));
#line 888 "../gpx-viewer/libgpx/gpx-graph.vala"
		_g_free0 (mtext);
#line 888 "../gpx-viewer/libgpx/gpx-graph.vala"
		mtext = _tmp180_;
#line 4393 "gpx-graph.c"
	}
#line 890 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (self->priv->_smooth_factor != 1) {
#line 4397 "gpx-graph.c"
		gchar* markup = NULL;
		const gchar* _tmp181_;
		gchar* _tmp182_;
		PangoLayout* _tmp183_;
		const gchar* _tmp184_;
		const gchar* _tmp185_;
#line 892 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp181_ = mtext;
#line 892 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp182_ = g_strdup_printf (_ ("%s <i>(smooth window: %i)</i>"), _tmp181_, self->priv->_smooth_factor);
#line 892 "../gpx-viewer/libgpx/gpx-graph.vala"
		markup = _tmp182_;
#line 893 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp183_ = layout;
#line 893 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp184_ = markup;
#line 893 "../gpx-viewer/libgpx/gpx-graph.vala"
		pango_layout_set_markup (_tmp183_, _tmp184_, -1);
#line 894 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp185_ = markup;
#line 894 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:894: Set graph title: %s", _tmp185_);
#line 890 "../gpx-viewer/libgpx/gpx-graph.vala"
		_g_free0 (markup);
#line 4422 "gpx-graph.c"
	} else {
		PangoLayout* _tmp186_;
		const gchar* _tmp187_;
		const gchar* _tmp188_;
#line 899 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp186_ = layout;
#line 899 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp187_ = mtext;
#line 899 "../gpx-viewer/libgpx/gpx-graph.vala"
		pango_layout_set_text (_tmp186_, _tmp187_, -1);
#line 900 "../gpx-viewer/libgpx/gpx-graph.vala"
		_tmp188_ = mtext;
#line 900 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_log (GPX_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:900: Set graph title: %s", _tmp188_);
#line 4437 "gpx-graph.c"
	}
#line 903 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp189_ = layout;
#line 903 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_layout_get_pixel_size (_tmp189_, &_tmp190_, &_tmp191_);
#line 903 "../gpx-viewer/libgpx/gpx-graph.vala"
	w = _tmp190_;
#line 903 "../gpx-viewer/libgpx/gpx-graph.vala"
	h = _tmp191_;
#line 904 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp192_ = ctx;
#line 904 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_move_to (_tmp192_, (graph_width / 2) - (w / 2), (gdouble) -20);
#line 905 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp193_ = ctx;
#line 905 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp194_ = layout;
#line 905 "../gpx-viewer/libgpx/gpx-graph.vala"
	pango_cairo_layout_path (_tmp193_, _tmp194_);
#line 906 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp195_ = ctx;
#line 906 "../gpx-viewer/libgpx/gpx-graph.vala"
	cairo_fill (_tmp195_);
#line 676 "../gpx-viewer/libgpx/gpx-graph.vala"
	_g_free0 (mtext);
#line 676 "../gpx-viewer/libgpx/gpx-graph.vala"
	_g_object_unref0 (layout);
#line 676 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_point_unref0 (f);
#line 676 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_destroy0 (ctx);
#line 4469 "gpx-graph.c"
}

gint
gpx_graph_get_smooth_factor (GpxGraph* self)
{
	gint result;
#line 110 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = self->priv->_smooth_factor;
#line 110 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 4480 "gpx-graph.c"
}

void
gpx_graph_set_smooth_factor (GpxGraph* self,
                             gint value)
{
#line 112 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->_smooth_factor = value;
#line 114 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_surface_destroy0 (self->priv->surf);
#line 114 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->surf = NULL;
#line 116 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 111 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_graph_properties[GPX_GRAPH_SMOOTH_FACTOR_PROPERTY]);
#line 4497 "gpx-graph.c"
}

gboolean
gpx_graph_get_show_points (GpxGraph* self)
{
	gboolean result;
#line 121 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = self->priv->_show_points;
#line 121 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 4508 "gpx-graph.c"
}

void
gpx_graph_set_show_points (GpxGraph* self,
                           gboolean value)
{
#line 123 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->_show_points = value;
#line 125 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_surface_destroy0 (self->priv->surf);
#line 125 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->surf = NULL;
#line 127 "../gpx-viewer/libgpx/gpx-graph.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 122 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_graph_properties[GPX_GRAPH_SHOW_POINTS_PROPERTY]);
#line 4525 "gpx-graph.c"
}

GpxGraphGraphMode
gpx_graph_get_mode (GpxGraph* self)
{
	GpxGraphGraphMode result;
#line 132 "../gpx-viewer/libgpx/gpx-graph.vala"
	result = self->priv->_mode;
#line 132 "../gpx-viewer/libgpx/gpx-graph.vala"
	return result;
#line 4536 "gpx-graph.c"
}

void
gpx_graph_set_mode (GpxGraph* self,
                    GpxGraphGraphMode value)
{
#line 134 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (value != self->priv->_mode) {
#line 136 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->_mode = value;
#line 137 "../gpx-viewer/libgpx/gpx-graph.vala"
		_cairo_surface_destroy0 (self->priv->surf);
#line 137 "../gpx-viewer/libgpx/gpx-graph.vala"
		self->priv->surf = NULL;
#line 139 "../gpx-viewer/libgpx/gpx-graph.vala"
		gtk_widget_queue_draw ((GtkWidget*) self);
#line 4553 "gpx-graph.c"
	}
#line 133 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_graph_properties[GPX_GRAPH_MODE_PROPERTY]);
#line 4557 "gpx-graph.c"
}

static void
g_cclosure_user_marshal_VOID__GPX_POINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__GPX_POINT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__GPX_POINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_return_if_fail (n_param_values == 2);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data1 = closure->data;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data2 = param_values->data[0].v_pointer;
#line 4582 "gpx-graph.c"
	} else {
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data2 = closure->data;
#line 4588 "gpx-graph.c"
	}
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	callback = (GMarshalFunc_VOID__GPX_POINT) (marshal_data ? marshal_data : cc->callback);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	callback (data1, gpx_value_get_point (param_values + 1), data2);
#line 4594 "gpx-graph.c"
}

static void
g_cclosure_user_marshal_VOID__OBJECT_GPX_POINT_GPX_POINT (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_GPX_POINT_GPX_POINT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_GPX_POINT_GPX_POINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_return_if_fail (n_param_values == 4);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data1 = closure->data;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data2 = param_values->data[0].v_pointer;
#line 4619 "gpx-graph.c"
	} else {
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		data2 = closure->data;
#line 4625 "gpx-graph.c"
	}
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	callback = (GMarshalFunc_VOID__OBJECT_GPX_POINT_GPX_POINT) (marshal_data ? marshal_data : cc->callback);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	callback (data1, g_value_get_object (param_values + 1), gpx_value_get_point (param_values + 2), gpx_value_get_point (param_values + 3), data2);
#line 4631 "gpx-graph.c"
}

static void
gpx_graph_class_init (GpxGraphClass * klass,
                      gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_parent_class = g_type_class_peek_parent (klass);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_type_class_adjust_private_offset (klass, &GpxGraph_private_offset);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gpx_graph_get_property;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gpx_graph_set_property;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_graph_finalize;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_GRAPH_SMOOTH_FACTOR_PROPERTY, gpx_graph_properties[GPX_GRAPH_SMOOTH_FACTOR_PROPERTY] = g_param_spec_int ("smooth-factor", "smooth-factor", "smooth-factor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_GRAPH_SHOW_POINTS_PROPERTY, gpx_graph_properties[GPX_GRAPH_SHOW_POINTS_PROPERTY] = g_param_spec_boolean ("show-points", "show-points", "show-points", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_GRAPH_MODE_PROPERTY, gpx_graph_properties[GPX_GRAPH_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", GPX_GRAPH_TYPE_GRAPH_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_signals[GPX_GRAPH_POINT_CLICKED_SIGNAL] = g_signal_new ("point-clicked", GPX_TYPE_GRAPH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__GPX_POINT, G_TYPE_NONE, 1, GPX_TYPE_POINT);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_signals[GPX_GRAPH_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", GPX_TYPE_GRAPH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_GPX_POINT_GPX_POINT, G_TYPE_NONE, 3, GPX_TYPE_TRACK, GPX_TYPE_POINT, GPX_TYPE_POINT);
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp0_ = g_strdup (N_ ("Speed (km/h) vs Time (HH:MM)"));
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp1_ = g_strdup (N_ ("Elevation (m) vs Time (HH:MM)"));
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp2_ = g_strdup (N_ ("Absolute Distance (km) vs Time (HH:MM)"));
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp3_ = g_strdup (N_ ("Horizontal acceleration (m/s²) vs Time (HH:MM)"));
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp4_ = g_strdup (N_ ("Vertical speed (m/s) vs Time (HH:MM)"));
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp5_ = g_strdup (N_ ("Heart-rate (bpm) vs Time (HH:MM)"));
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp6_ = g_strdup (N_ ("Cadence (rpm) vs Time (HH:MM)"));
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_ = g_new0 (gchar*, 7 + 1);
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_[0] = _tmp0_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_[1] = _tmp1_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_[2] = _tmp2_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_[3] = _tmp3_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_[4] = _tmp4_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_[5] = _tmp5_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp7_[6] = _tmp6_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_GraphModeName = _tmp7_;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_GraphModeName_length1 = 7;
#line 45 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_graph_GraphModeName_size_ = gpx_graph_GraphModeName_length1;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp8_ = g_strdup (N_ ("Speed (Miles/h) vs Time (HH:MM)"));
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp9_ = g_strdup (N_ ("Elevation (feet) vs Time (HH:MM)"));
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp10_ = g_strdup (N_ ("Distance (Miles) vs Time (HH:MM)"));
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp11_ = g_strdup (N_ ("Horizontal acceleration (Miles/s²) vs Time (HH:MM)"));
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp12_ = g_strdup (N_ ("Vertical speed (feet/s) vs Time (HH:MM)"));
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp13_ = g_strdup (N_ ("Heart-rate (bpm) vs Time (HH:MM)"));
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp14_ = g_strdup (N_ ("Cadence (rpm) vs Time (HH:MM)"));
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_ = g_new0 (gchar*, 7 + 1);
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_[0] = _tmp8_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_[1] = _tmp9_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_[2] = _tmp10_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_[3] = _tmp11_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_[4] = _tmp12_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_[5] = _tmp13_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_tmp15_[6] = _tmp14_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_GraphModeMiles = _tmp15_;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	gpx_graph_GraphModeMiles_length1 = 7;
#line 54 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_graph_GraphModeMiles_size_ = gpx_graph_GraphModeMiles_length1;
#line 4746 "gpx-graph.c"
}

static void
gpx_graph_instance_init (GpxGraph * self,
                         gpointer klass)
{
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv = gpx_graph_get_instance_private (self);
#line 28 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->track = NULL;
#line 29 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->start = NULL;
#line 30 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->stop = NULL;
#line 31 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->selected = NULL;
#line 64 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->_do_miles = FALSE;
#line 67 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->_mode = GPX_GRAPH_GRAPH_MODE_ELEVATION;
#line 69 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->_smooth_factor = 1;
#line 71 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->_show_points = TRUE;
#line 73 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->fd = NULL;
#line 74 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->surf = NULL;
#line 75 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->LEFT_OFFSET = 60;
#line 76 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->RIGHT_OFFSET = 10;
#line 77 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->BOTTOM_OFFSET = 30;
#line 78 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->highlight = (time_t) 0;
#line 80 "../gpx-viewer/libgpx/gpx-graph.vala"
	self->priv->draw_current = NULL;
#line 4785 "gpx-graph.c"
}

static void
gpx_graph_finalize (GObject * obj)
{
	GpxGraph * self;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_GRAPH, GpxGraph);
#line 910 "../gpx-viewer/libgpx/gpx-graph.vala"
	g_debug ("gpx-graph.vala:910: Destroying graph");
#line 28 "../gpx-viewer/libgpx/gpx-graph.vala"
	_g_object_unref0 (self->track);
#line 29 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_point_unref0 (self->priv->start);
#line 30 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_point_unref0 (self->priv->stop);
#line 31 "../gpx-viewer/libgpx/gpx-graph.vala"
	_gpx_point_unref0 (self->priv->selected);
#line 73 "../gpx-viewer/libgpx/gpx-graph.vala"
	__vala_PangoFontDescription_free0 (self->priv->fd);
#line 74 "../gpx-viewer/libgpx/gpx-graph.vala"
	_cairo_surface_destroy0 (self->priv->surf);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	G_OBJECT_CLASS (gpx_graph_parent_class)->finalize (obj);
#line 4810 "gpx-graph.c"
}

static GType
gpx_graph_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxGraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxGraph), 0, (GInstanceInitFunc) gpx_graph_instance_init, NULL };
	GType gpx_graph_type_id;
	gpx_graph_type_id = g_type_register_static (gtk_event_box_get_type (), "GpxGraph", &g_define_type_info, 0);
	GpxGraph_private_offset = g_type_add_instance_private (gpx_graph_type_id, sizeof (GpxGraphPrivate));
	return gpx_graph_type_id;
}

GType
gpx_graph_get_type (void)
{
	static volatile gsize gpx_graph_type_id__once = 0;
	if (g_once_init_enter (&gpx_graph_type_id__once)) {
		GType gpx_graph_type_id;
		gpx_graph_type_id = gpx_graph_get_type_once ();
		g_once_init_leave (&gpx_graph_type_id__once, gpx_graph_type_id);
	}
	return gpx_graph_type_id__once;
}

static void
_vala_gpx_graph_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GpxGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_GRAPH, GpxGraph);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	switch (property_id) {
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		case GPX_GRAPH_SMOOTH_FACTOR_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_value_set_int (value, gpx_graph_get_smooth_factor (self));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		case GPX_GRAPH_SHOW_POINTS_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_value_set_boolean (value, gpx_graph_get_show_points (self));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		case GPX_GRAPH_MODE_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		g_value_set_enum (value, gpx_graph_get_mode (self));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 4863 "gpx-graph.c"
		default:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 4869 "gpx-graph.c"
	}
}

static void
_vala_gpx_graph_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GpxGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_GRAPH, GpxGraph);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
	switch (property_id) {
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		case GPX_GRAPH_SMOOTH_FACTOR_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		gpx_graph_set_smooth_factor (self, g_value_get_int (value));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		case GPX_GRAPH_SHOW_POINTS_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		gpx_graph_set_show_points (self, g_value_get_boolean (value));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		case GPX_GRAPH_MODE_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		gpx_graph_set_mode (self, g_value_get_enum (value));
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 4901 "gpx-graph.c"
		default:
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../gpx-viewer/libgpx/gpx-graph.vala"
		break;
#line 4907 "gpx-graph.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

