/* pieWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from pieWindow.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_PIE_WINDOW (gnome_pie_pie_window_get_type ())
#define GNOME_PIE_PIE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindow))
#define GNOME_PIE_PIE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindowClass))
#define GNOME_PIE_IS_PIE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PIE_WINDOW))
#define GNOME_PIE_IS_PIE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PIE_WINDOW))
#define GNOME_PIE_PIE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindowClass))

typedef struct _GnomePiePieWindow GnomePiePieWindow;
typedef struct _GnomePiePieWindowClass GnomePiePieWindowClass;
typedef struct _GnomePiePieWindowPrivate GnomePiePieWindowPrivate;

#define GNOME_PIE_TYPE_IMAGE (gnome_pie_image_get_type ())
#define GNOME_PIE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImage))
#define GNOME_PIE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))
#define GNOME_PIE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))

typedef struct _GnomePieImage GnomePieImage;
typedef struct _GnomePieImageClass GnomePieImageClass;

#define GNOME_PIE_TYPE_PIE_RENDERER (gnome_pie_pie_renderer_get_type ())
#define GNOME_PIE_PIE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PIE_RENDERER, GnomePiePieRenderer))
#define GNOME_PIE_PIE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PIE_RENDERER, GnomePiePieRendererClass))
#define GNOME_PIE_IS_PIE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PIE_RENDERER))
#define GNOME_PIE_IS_PIE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PIE_RENDERER))
#define GNOME_PIE_PIE_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PIE_RENDERER, GnomePiePieRendererClass))

typedef struct _GnomePiePieRenderer GnomePiePieRenderer;
typedef struct _GnomePiePieRendererClass GnomePiePieRendererClass;
enum  {
	GNOME_PIE_PIE_WINDOW_0_PROPERTY,
	GNOME_PIE_PIE_WINDOW_BACKGROUND_PROPERTY,
	GNOME_PIE_PIE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_pie_window_properties[GNOME_PIE_PIE_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block18Data Block18Data;

#define GNOME_PIE_TYPE_BINDING_MANAGER (gnome_pie_binding_manager_get_type ())
#define GNOME_PIE_BINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_BINDING_MANAGER, GnomePieBindingManager))
#define GNOME_PIE_BINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_BINDING_MANAGER, GnomePieBindingManagerClass))
#define GNOME_PIE_IS_BINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_BINDING_MANAGER))
#define GNOME_PIE_IS_BINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_BINDING_MANAGER))
#define GNOME_PIE_BINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_BINDING_MANAGER, GnomePieBindingManagerClass))

typedef struct _GnomePieBindingManager GnomePieBindingManager;
typedef struct _GnomePieBindingManagerClass GnomePieBindingManagerClass;

#define GNOME_PIE_TYPE_PIE (gnome_pie_pie_get_type ())
#define GNOME_PIE_PIE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PIE, GnomePiePie))
#define GNOME_PIE_PIE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PIE, GnomePiePieClass))
#define GNOME_PIE_IS_PIE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PIE))
#define GNOME_PIE_IS_PIE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PIE))
#define GNOME_PIE_PIE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PIE, GnomePiePieClass))

typedef struct _GnomePiePie GnomePiePie;
typedef struct _GnomePiePieClass GnomePiePieClass;
typedef struct _Block19Data Block19Data;

#define GNOME_PIE_TYPE_CONFIG (gnome_pie_config_get_type ())
#define GNOME_PIE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_CONFIG, GnomePieConfig))
#define GNOME_PIE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_CONFIG, GnomePieConfigClass))
#define GNOME_PIE_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_CONFIG))
#define GNOME_PIE_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_CONFIG))
#define GNOME_PIE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_CONFIG, GnomePieConfigClass))

typedef struct _GnomePieConfig GnomePieConfig;
typedef struct _GnomePieConfigClass GnomePieConfigClass;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;

#define GNOME_PIE_TYPE_THEME (gnome_pie_theme_get_type ())
#define GNOME_PIE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_THEME, GnomePieTheme))
#define GNOME_PIE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_THEME, GnomePieThemeClass))
#define GNOME_PIE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_THEME))
#define GNOME_PIE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_THEME))
#define GNOME_PIE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_THEME, GnomePieThemeClass))

typedef struct _GnomePieTheme GnomePieTheme;
typedef struct _GnomePieThemeClass GnomePieThemeClass;
typedef struct _Block22Data Block22Data;
enum  {
	GNOME_PIE_PIE_WINDOW_ON_CLOSING_SIGNAL,
	GNOME_PIE_PIE_WINDOW_ON_CLOSED_SIGNAL,
	GNOME_PIE_PIE_WINDOW_NUM_SIGNALS
};
static guint gnome_pie_pie_window_signals[GNOME_PIE_PIE_WINDOW_NUM_SIGNALS] = {0};

struct _GnomePiePieWindow {
	GtkWindow parent_instance;
	GnomePiePieWindowPrivate * priv;
};

struct _GnomePiePieWindowClass {
	GtkWindowClass parent_class;
};

struct _GnomePiePieWindowPrivate {
	GnomePieImage* _background;
	gint back_x;
	gint back_y;
	gint back_sz_x;
	gint back_sz_y;
	gint panel_sz;
	gint mouse_move;
	GnomePiePieRenderer* renderer;
	gboolean closing;
	gboolean closed;
	GTimer* timer;
	gboolean has_compositing;
	gchar* search_string;
	gboolean wayland;
};

struct _Block18Data {
	int _ref_count_;
	GnomePiePieWindow* self;
	guint last_key;
	guint32 last_time_stamp;
	gulong connection_id;
};

struct _Block19Data {
	int _ref_count_;
	GnomePiePieWindow* self;
	gboolean warp_pointer;
};

struct _Block20Data {
	int _ref_count_;
	GnomePiePieWindow* self;
	guint32 time_stamp;
};

struct _Block21Data {
	int _ref_count_;
	Block20Data * _data20_;
	gboolean should_close;
};

struct _Block22Data {
	int _ref_count_;
	GnomePiePieWindow* self;
	guint32 time_stamp;
};

static gint GnomePiePieWindow_private_offset;
static gpointer gnome_pie_pie_window_parent_class = NULL;
VALA_EXTERN GnomePieBindingManager* gnome_pie_pie_manager_bindings;

VALA_EXTERN GType gnome_pie_pie_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePieWindow, g_object_unref)
VALA_EXTERN GType gnome_pie_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieImage, g_object_unref)
VALA_EXTERN GType gnome_pie_pie_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePieRenderer, g_object_unref)
VALA_EXTERN GnomePiePieWindow* gnome_pie_pie_window_new (void);
VALA_EXTERN GnomePiePieWindow* gnome_pie_pie_window_construct (GType object_type);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
VALA_EXTERN GnomePiePieRenderer* gnome_pie_pie_renderer_new (void);
VALA_EXTERN GnomePiePieRenderer* gnome_pie_pie_renderer_construct (GType object_type);
static gboolean __lambda6_ (GnomePiePieWindow* self,
                     GdkEventButton* e);
VALA_EXTERN gboolean gnome_pie_pie_manager_get_is_turbo (const gchar* id);
VALA_EXTERN const gchar* gnome_pie_pie_renderer_get_id (GnomePiePieRenderer* self);
static void gnome_pie_pie_window_activate_slice (GnomePiePieWindow* self,
                                          guint32 time_stamp);
static gboolean ___lambda6__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda10_ (GnomePiePieWindow* self,
                      GdkEventButton* e);
static void gnome_pie_pie_window_cancel (GnomePiePieWindow* self);
static gboolean ___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda12_ (Block18Data* _data18_,
                      GdkEventKey* e);
static void gnome_pie_pie_window_handle_key_press (GnomePiePieWindow* self,
                                            guint key,
                                            guint32 time_stamp,
                                            guint32 last_time_stamp,
                                            const gchar* text);
static gboolean ___lambda12__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static gboolean __lambda14_ (Block18Data* _data18_,
                      GdkEventKey* e);
static void gnome_pie_pie_window_handle_key_release (GnomePiePieWindow* self,
                                              guint key);
static gboolean ___lambda14__gtk_widget_key_release_event (GtkWidget* _sender,
                                                    GdkEventKey* event,
                                                    gpointer self);
VALA_EXTERN GType gnome_pie_binding_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieBindingManager, g_object_unref)
static void __lambda15_ (GnomePiePieWindow* self,
                  guint32 time_stamp);
static void ___lambda15__gnome_pie_binding_manager_on_release (GnomePieBindingManager* _sender,
                                                        guint32 time_stamp,
                                                        gpointer self);
static void __lambda16_ (Block18Data* _data18_);
static void ___lambda16__gnome_pie_pie_window_on_closing (GnomePiePieWindow* _sender,
                                                   gpointer self);
static gboolean __lambda17_ (GnomePiePieWindow* self,
                      GtkWidget* w,
                      GdkEventFocus* e);
static gboolean ___lambda17__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean __lambda18_ (GnomePiePieWindow* self,
                      GdkEventMotion* e);
VALA_EXTERN void gnome_pie_pie_renderer_on_mouse_move (GnomePiePieRenderer* self);
static gboolean ___lambda18__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                      GdkEventMotion* event,
                                                      gpointer self);
static void __lambda19_ (GnomePiePieWindow* self);
VALA_EXTERN void gnome_pie_focus_grabber_grab (GdkWindow* window);
static void ___lambda19__gtk_widget_show (GtkWidget* _sender,
                                   gpointer self);
static gboolean __lambda20_ (GnomePiePieWindow* self,
                      GdkEventScroll* e);
VALA_EXTERN void gnome_pie_pie_renderer_select_prevpage (GnomePiePieRenderer* self);
VALA_EXTERN void gnome_pie_pie_renderer_select_nextpage (GnomePiePieRenderer* self);
static gboolean ___lambda20__gtk_widget_scroll_event (GtkWidget* _sender,
                                               GdkEventScroll* event,
                                               gpointer self);
static gboolean gnome_pie_pie_window_draw_window (GnomePiePieWindow* self,
                                           cairo_t* ctx);
static gboolean _gnome_pie_pie_window_draw_window_gtk_widget_draw (GtkWidget* _sender,
                                                            cairo_t* cr,
                                                            gpointer self);
VALA_EXTERN GType gnome_pie_pie_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePie, g_object_unref)
VALA_EXTERN void gnome_pie_pie_window_load_pie (GnomePiePieWindow* self,
                                    GnomePiePie* pie);
VALA_EXTERN void gnome_pie_pie_renderer_load_pie (GnomePiePieRenderer* self,
                                      GnomePiePie* pie);
static void gnome_pie_pie_window_set_window_position (GnomePiePieWindow* self,
                                               GnomePiePie* pie);
VALA_EXTERN gint gnome_pie_pie_renderer_get_size_w (GnomePiePieRenderer* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_size_h (GnomePiePieRenderer* self);
VALA_EXTERN void gnome_pie_pie_window_open (GnomePiePieWindow* self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
VALA_EXTERN GnomePieImage* gnome_pie_image_new_capture_screen (gint posx,
                                                   gint posy,
                                                   gint width,
                                                   gint height,
                                                   gboolean hide_pies);
VALA_EXTERN GnomePieImage* gnome_pie_image_construct_capture_screen (GType object_type,
                                                         gint posx,
                                                         gint posy,
                                                         gint width,
                                                         gint height,
                                                         gboolean hide_pies);
static void gnome_pie_pie_window_set_background (GnomePiePieWindow* self,
                                          GnomePieImage* value);
VALA_EXTERN gboolean gnome_pie_pie_manager_get_is_warp (const gchar* id);
VALA_EXTERN GType gnome_pie_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieConfig, g_object_unref)
VALA_EXTERN GnomePieConfig* gnome_pie_config_get_global (void);
VALA_EXTERN gdouble gnome_pie_config_get_refresh_rate (GnomePieConfig* self);
static gboolean __lambda21_ (Block19Data* _data19_);
VALA_EXTERN void gnome_pie_pie_window_get_center_pos (GnomePiePieWindow* self,
                                          gint* out_x,
                                          gint* out_y);
static void gnome_pie_pie_window_set_mouse_position (GnomePiePieWindow* self,
                                              gint mx,
                                              gint my);
static gboolean ___lambda21__gsource_func (gpointer self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_center_x (GnomePiePieRenderer* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_center_y (GnomePiePieRenderer* self);
static void gnome_pie_pie_window_get_mouse_position (GnomePiePieWindow* self,
                                              gint* mx,
                                              gint* my);
VALA_EXTERN GnomePieImage* gnome_pie_pie_window_get_background (GnomePiePieWindow* self);
VALA_EXTERN cairo_surface_t* gnome_pie_image_get_surface (GnomePieImage* self);
VALA_EXTERN void gnome_pie_pie_renderer_draw (GnomePiePieRenderer* self,
                                  gdouble frame_time,
                                  cairo_t* ctx,
                                  gint mouse_x,
                                  gint mouse_y);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
VALA_EXTERN GdkModifierType gnome_pie_key_get_modifiers (void);
static gboolean ___lambda7_ (Block21Data* _data21_);
VALA_EXTERN void gnome_pie_pie_renderer_activate (GnomePiePieRenderer* self,
                                      guint32 time_stamp,
                                      gboolean fade_out);
static gboolean ____lambda7__gsource_func (gpointer self);
VALA_EXTERN void gnome_pie_focus_grabber_ungrab (void);
VALA_EXTERN GType gnome_pie_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieTheme, g_object_unref)
VALA_EXTERN GnomePieTheme* gnome_pie_config_get_theme (GnomePieConfig* self);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_out_time (GnomePieTheme* self);
static gboolean ____lambda9_ (GnomePiePieWindow* self);
static gboolean _____lambda9__gsource_func (gpointer self);
VALA_EXTERN void gnome_pie_pie_renderer_cancel (GnomePiePieRenderer* self);
static gboolean ___lambda11_ (GnomePiePieWindow* self);
static gboolean ____lambda11__gsource_func (gpointer self);
VALA_EXTERN gboolean gnome_pie_pie_manager_get_is_centered (const gchar* id);
VALA_EXTERN const gchar* gnome_pie_pie_get_id (GnomePiePie* self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
VALA_EXTERN void gnome_pie_pie_renderer_select_up (GnomePiePieRenderer* self);
VALA_EXTERN void gnome_pie_pie_renderer_select_down (GnomePiePieRenderer* self);
VALA_EXTERN void gnome_pie_pie_renderer_select_left (GnomePiePieRenderer* self);
VALA_EXTERN void gnome_pie_pie_renderer_select_right (GnomePiePieRenderer* self);
VALA_EXTERN gboolean gnome_pie_config_get_search_by_string (GnomePieConfig* self);
VALA_EXTERN void gnome_pie_pie_renderer_set_show_hotkeys (GnomePiePieRenderer* self,
                                              gboolean value);
VALA_EXTERN void gnome_pie_pie_renderer_select_by_string (GnomePiePieRenderer* self,
                                              const gchar* search);
VALA_EXTERN gint gnome_pie_pie_renderer_slice_count (GnomePiePieRenderer* self);
VALA_EXTERN void gnome_pie_pie_renderer_set_key_board_control (GnomePiePieRenderer* self,
                                                   gboolean value);
VALA_EXTERN void gnome_pie_pie_renderer_select_by_index (GnomePiePieRenderer* self,
                                             gint index);
VALA_EXTERN gint gnome_pie_pie_renderer_get_active_slice (GnomePiePieRenderer* self);
VALA_EXTERN gdouble gnome_pie_theme_get_transition_time (GnomePieTheme* self);
static gboolean __________________lambda13_ (Block22Data* _data22_);
static gboolean ___________________lambda13__gsource_func (gpointer self);
static void gnome_pie_pie_window_finalize (GObject * obj);
static GType gnome_pie_pie_window_get_type_once (void);
static void _vala_gnome_pie_pie_window_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gnome_pie_pie_window_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gnome_pie_pie_window_get_instance_private (GnomePiePieWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePiePieWindow_private_offset);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		GnomePiePieWindow* self;
		self = _data18_->self;
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static gboolean
__lambda6_ (GnomePiePieWindow* self,
            GdkEventButton* e)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) 1)) {
		_tmp0_ = TRUE;
	} else {
		GnomePiePieRenderer* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->renderer;
		_tmp2_ = gnome_pie_pie_renderer_get_id (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = gnome_pie_pie_manager_get_is_turbo (_tmp3_);
	}
	if (_tmp0_) {
		gnome_pie_pie_window_activate_slice (self, e->time);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda6__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda6_ ((GnomePiePieWindow*) self, event);
	return result;
}

static gboolean
__lambda10_ (GnomePiePieWindow* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) 3)) {
		gnome_pie_pie_window_cancel (self);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda10_ ((GnomePiePieWindow*) self, event);
	return result;
}

static gboolean
__lambda12_ (Block18Data* _data18_,
             GdkEventKey* e)
{
	GnomePiePieWindow* self;
	gboolean result;
	self = _data18_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->keyval != _data18_->last_key) {
		const gchar* _tmp0_;
		_tmp0_ = e->string;
		gnome_pie_pie_window_handle_key_press (self, e->keyval, e->time, _data18_->last_time_stamp, _tmp0_);
		_data18_->last_key = e->keyval;
		_data18_->last_time_stamp = e->time;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda12__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda12_ (self, event);
	return result;
}

static gboolean
__lambda14_ (Block18Data* _data18_,
             GdkEventKey* e)
{
	GnomePiePieWindow* self;
	GnomePiePieRenderer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	self = _data18_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_data18_->last_key = (guint) 0;
	_tmp0_ = self->priv->renderer;
	_tmp1_ = gnome_pie_pie_renderer_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	if (gnome_pie_pie_manager_get_is_turbo (_tmp2_)) {
		gnome_pie_pie_window_activate_slice (self, e->time);
	} else {
		gnome_pie_pie_window_handle_key_release (self, e->keyval);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda14__gtk_widget_key_release_event (GtkWidget* _sender,
                                           GdkEventKey* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda14_ (self, event);
	return result;
}

static void
__lambda15_ (GnomePiePieWindow* self,
             guint32 time_stamp)
{
	GnomePiePieRenderer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->renderer;
	_tmp1_ = gnome_pie_pie_renderer_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	if (gnome_pie_pie_manager_get_is_turbo (_tmp2_)) {
		gnome_pie_pie_window_activate_slice (self, time_stamp);
	}
}

static void
___lambda15__gnome_pie_binding_manager_on_release (GnomePieBindingManager* _sender,
                                                   guint32 time_stamp,
                                                   gpointer self)
{
	__lambda15_ ((GnomePiePieWindow*) self, time_stamp);
}

static void
__lambda16_ (Block18Data* _data18_)
{
	GnomePiePieWindow* self;
	GnomePieBindingManager* _tmp0_;
	self = _data18_->self;
	_tmp0_ = gnome_pie_pie_manager_bindings;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data18_->connection_id);
}

static void
___lambda16__gnome_pie_pie_window_on_closing (GnomePiePieWindow* _sender,
                                              gpointer self)
{
	__lambda16_ (self);
}

static gboolean
__lambda17_ (GnomePiePieWindow* self,
             GtkWidget* w,
             GdkEventFocus* e)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gnome_pie_pie_window_cancel (self);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda17__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda17_ ((GnomePiePieWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda18_ (GnomePiePieWindow* self,
             GdkEventMotion* e)
{
	GnomePiePieRenderer* _tmp0_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->renderer;
	gnome_pie_pie_renderer_on_mouse_move (_tmp0_);
	result = TRUE;
	return result;
}

static gboolean
___lambda18__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                             GdkEventMotion* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda18_ ((GnomePiePieWindow*) self, event);
	return result;
}

static void
__lambda19_ (GnomePiePieWindow* self)
{
	GdkWindow* _tmp0_;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gnome_pie_focus_grabber_grab (_tmp0_);
}

static void
___lambda19__gtk_widget_show (GtkWidget* _sender,
                              gpointer self)
{
	__lambda19_ ((GnomePiePieWindow*) self);
}

static gboolean
__lambda20_ (GnomePiePieWindow* self,
             GdkEventScroll* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->direction == GDK_SCROLL_UP) {
		GnomePiePieRenderer* _tmp0_;
		_tmp0_ = self->priv->renderer;
		gnome_pie_pie_renderer_select_prevpage (_tmp0_);
	} else {
		if (e->direction == GDK_SCROLL_DOWN) {
			GnomePiePieRenderer* _tmp1_;
			_tmp1_ = self->priv->renderer;
			gnome_pie_pie_renderer_select_nextpage (_tmp1_);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda20__gtk_widget_scroll_event (GtkWidget* _sender,
                                      GdkEventScroll* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda20_ ((GnomePiePieWindow*) self, event);
	return result;
}

static gboolean
_gnome_pie_pie_window_draw_window_gtk_widget_draw (GtkWidget* _sender,
                                                   cairo_t* cr,
                                                   gpointer self)
{
	gboolean result;
	result = gnome_pie_pie_window_draw_window ((GnomePiePieWindow*) self, cr);
	return result;
}

GnomePiePieWindow*
gnome_pie_pie_window_construct (GType object_type)
{
	GnomePiePieWindow * self = NULL;
	Block18Data* _data18_;
	GnomePiePieRenderer* _tmp0_;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GnomePieBindingManager* _tmp6_;
	gulong _tmp7_;
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	self = (GnomePiePieWindow*) g_object_new (object_type, NULL);
	_data18_->self = g_object_ref (self);
	_tmp0_ = gnome_pie_pie_renderer_new ();
	_g_object_unref0 (self->priv->renderer);
	self->priv->renderer = _tmp0_;
	gtk_window_set_title ((GtkWindow*) self, "Gnome-Pie");
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_icon_name ((GtkWindow*) self, "gnome-pie");
	gtk_window_set_accept_focus ((GtkWindow*) self, TRUE);
	gtk_window_set_focus_on_map ((GtkWindow*) self, TRUE);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	if (gdk_screen_is_composited (_tmp2_)) {
		GdkScreen* _tmp3_;
		GdkScreen* _tmp4_;
		GdkVisual* _tmp5_;
		_tmp3_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = gdk_screen_get_rgba_visual (_tmp4_);
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
		self->priv->has_compositing = TRUE;
	}
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) ___lambda6__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda10__gtk_widget_button_press_event, self, 0);
	_data18_->last_key = (guint) 0;
	_data18_->last_time_stamp = (guint32) 0;
	g_signal_connect_data ((GtkWidget*) self, "key-press-event", (GCallback) ___lambda12__gtk_widget_key_press_event, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) self, "key-release-event", (GCallback) ___lambda14__gtk_widget_key_release_event, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp6_ = gnome_pie_pie_manager_bindings;
	_tmp7_ = g_signal_connect_object (_tmp6_, "on-release", (GCallback) ___lambda15__gnome_pie_binding_manager_on_release, self, 0);
	_data18_->connection_id = _tmp7_;
	g_signal_connect_data (self, "on-closing", (GCallback) ___lambda16__gnome_pie_pie_window_on_closing, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda17__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) ___lambda18__gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) ___lambda19__gtk_widget_show, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self, "scroll-event", (GCallback) ___lambda20__gtk_widget_scroll_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _gnome_pie_pie_window_draw_window_gtk_widget_draw, self, 0);
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return self;
}

GnomePiePieWindow*
gnome_pie_pie_window_new (void)
{
	return gnome_pie_pie_window_construct (GNOME_PIE_TYPE_PIE_WINDOW);
}

void
gnome_pie_pie_window_load_pie (GnomePiePieWindow* self,
                               GnomePiePie* pie)
{
	GnomePiePieRenderer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pie != NULL);
	_tmp0_ = self->priv->renderer;
	gnome_pie_pie_renderer_load_pie (_tmp0_, pie);
	if (self->priv->wayland) {
		GdkRectangle monitor = {0};
		GdkDisplay* _tmp1_;
		GdkMonitor* _tmp2_;
		GdkRectangle _tmp3_ = {0};
		gint monitor_x = 0;
		GdkRectangle _tmp4_;
		gint monitor_y = 0;
		GdkRectangle _tmp5_;
		_tmp1_ = gdk_display_get_default ();
		_tmp2_ = gdk_display_get_monitor_at_point (_tmp1_, self->priv->back_x, self->priv->back_y);
		gdk_monitor_get_geometry (_tmp2_, &_tmp3_);
		monitor = _tmp3_;
		_tmp4_ = monitor;
		monitor_x = _tmp4_.width;
		_tmp5_ = monitor;
		monitor_y = _tmp5_.height;
		gtk_widget_set_size_request ((GtkWidget*) self, monitor_x, monitor_y);
	} else {
		GnomePiePieRenderer* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GnomePiePieRenderer* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gnome_pie_pie_window_set_window_position (self, pie);
		_tmp6_ = self->priv->renderer;
		_tmp7_ = gnome_pie_pie_renderer_get_size_w (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->renderer;
		_tmp10_ = gnome_pie_pie_renderer_get_size_h (_tmp9_);
		_tmp11_ = _tmp10_;
		gtk_widget_set_size_request ((GtkWidget*) self, _tmp8_, _tmp11_);
	}
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		GnomePiePieWindow* self;
		self = _data19_->self;
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gboolean
__lambda21_ (Block19Data* _data19_)
{
	GnomePiePieWindow* self;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = _data19_->self;
	if (self->priv->closed) {
		result = FALSE;
		return result;
	}
	if (_data19_->warp_pointer) {
		gint x = 0;
		gint y = 0;
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		_data19_->warp_pointer = FALSE;
		gnome_pie_pie_window_get_center_pos (self, &_tmp0_, &_tmp1_);
		x = _tmp0_;
		y = _tmp1_;
		gnome_pie_pie_window_set_mouse_position (self, x, y);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static gboolean
___lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda21_ (self);
	return result;
}

void
gnome_pie_pie_window_open (GnomePiePieWindow* self)
{
	Block19Data* _data19_;
	GTimer* _tmp13_;
	GTimer* _tmp14_;
	GnomePiePieRenderer* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GnomePieConfig* _tmp18_;
	GnomePieConfig* _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	g_return_if_fail (self != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	gtk_widget_realize ((GtkWidget*) self);
	if (!self->priv->has_compositing) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_;
		gint _tmp5_;
		GdkRectangle monitor = {0};
		GdkDisplay* _tmp6_;
		GdkMonitor* _tmp7_;
		GdkRectangle _tmp8_ = {0};
		gint monitor_x = 0;
		GdkRectangle _tmp9_;
		gint monitor_y = 0;
		GdkRectangle _tmp10_;
		gint dx = 0;
		gint dy = 0;
		GnomePieImage* _tmp11_;
		GnomePieImage* _tmp12_;
		gtk_window_get_position ((GtkWindow*) self, &_tmp0_, &_tmp1_);
		self->priv->back_x = _tmp0_;
		self->priv->back_y = _tmp1_;
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		self->priv->back_sz_x = _tmp2_;
		self->priv->back_sz_y = _tmp3_;
		_tmp4_ = self->priv->back_sz_x;
		self->priv->back_sz_x = _tmp4_ + 1;
		_tmp5_ = self->priv->back_sz_y;
		self->priv->back_sz_y = _tmp5_ + 1;
		_tmp6_ = gdk_display_get_default ();
		_tmp7_ = gdk_display_get_monitor_at_point (_tmp6_, self->priv->back_x, self->priv->back_y);
		gdk_monitor_get_geometry (_tmp7_, &_tmp8_);
		monitor = _tmp8_;
		_tmp9_ = monitor;
		monitor_x = _tmp9_.width;
		_tmp10_ = monitor;
		monitor_y = _tmp10_.height;
		dx = self->priv->panel_sz - self->priv->back_x;
		if (dx > 0) {
			self->priv->back_sz_x = self->priv->back_sz_x + dx;
		}
		dx = self->priv->panel_sz - (((monitor_x - self->priv->back_x) - self->priv->back_sz_x) + 1);
		if (dx > 0) {
			self->priv->back_sz_x = self->priv->back_sz_x + dx;
			self->priv->back_x = self->priv->back_x - dx;
		}
		dy = self->priv->panel_sz - self->priv->back_y;
		if (dy > 0) {
			self->priv->back_sz_y = self->priv->back_sz_y + dy;
		}
		dy = self->priv->panel_sz - (((monitor_y - self->priv->back_y) - self->priv->back_sz_y) + 1);
		if (dy > 0) {
			self->priv->back_sz_y = self->priv->back_sz_y + dy;
			self->priv->back_y = self->priv->back_y - dy;
		}
		self->priv->back_x = self->priv->back_x - self->priv->mouse_move;
		self->priv->back_sz_x = self->priv->back_sz_x + (self->priv->mouse_move * 2);
		self->priv->back_y = self->priv->back_y - self->priv->mouse_move;
		self->priv->back_sz_y = self->priv->back_sz_y + (self->priv->mouse_move * 2);
		if (self->priv->back_x < 0) {
			self->priv->back_sz_x = self->priv->back_sz_x + self->priv->back_x;
			self->priv->back_x = 0;
		}
		if (self->priv->back_y < 0) {
			self->priv->back_sz_y = self->priv->back_sz_y + self->priv->back_y;
			self->priv->back_y = 0;
		}
		if ((self->priv->back_x + self->priv->back_sz_x) > monitor_x) {
			self->priv->back_sz_x = monitor_x - self->priv->back_x;
		}
		if ((self->priv->back_y + self->priv->back_sz_y) > monitor_y) {
			self->priv->back_sz_y = monitor_y - self->priv->back_y;
		}
		_tmp11_ = gnome_pie_image_new_capture_screen (self->priv->back_x, self->priv->back_y, self->priv->back_sz_x, self->priv->back_sz_y, TRUE);
		_tmp12_ = _tmp11_;
		gnome_pie_pie_window_set_background (self, _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	gtk_widget_show ((GtkWidget*) self);
	_tmp13_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp13_;
	_tmp14_ = self->priv->timer;
	g_timer_start (_tmp14_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp15_ = self->priv->renderer;
	_tmp16_ = gnome_pie_pie_renderer_get_id (_tmp15_);
	_tmp17_ = _tmp16_;
	_data19_->warp_pointer = gnome_pie_pie_manager_get_is_warp (_tmp17_);
	_tmp18_ = gnome_pie_config_get_global ();
	_tmp19_ = _tmp18_;
	_tmp20_ = gnome_pie_config_get_refresh_rate (_tmp19_);
	_tmp21_ = _tmp20_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (1000.0 / _tmp21_), ___lambda21__gsource_func, block19_data_ref (_data19_), block19_data_unref);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

void
gnome_pie_pie_window_get_center_pos (GnomePiePieWindow* self,
                                     gint* out_x,
                                     gint* out_y)
{
	gint _vala_out_x = 0;
	gint _vala_out_y = 0;
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GnomePiePieRenderer* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GnomePiePieRenderer* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	x = 0;
	y = 0;
	gtk_window_get_position ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	_tmp2_ = self->priv->renderer;
	_tmp3_ = gnome_pie_pie_renderer_get_center_x (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_out_x = x + _tmp4_;
	_tmp5_ = self->priv->renderer;
	_tmp6_ = gnome_pie_pie_renderer_get_center_y (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_out_y = y + _tmp7_;
	if (out_x) {
		*out_x = _vala_out_x;
	}
	if (out_y) {
		*out_y = _vala_out_y;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gnome_pie_pie_window_get_mouse_position (GnomePiePieWindow* self,
                                         gint* mx,
                                         gint* my)
{
	gint _vala_mx = 0;
	gint _vala_my = 0;
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	GdkDevice* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	seat = _tmp2_;
	_tmp3_ = gdk_seat_get_pointer (seat);
	gdk_device_get_position (_tmp3_, NULL, &_tmp4_, &_tmp5_);
	_vala_mx = _tmp4_;
	_vala_my = _tmp5_;
	_g_object_unref0 (seat);
	if (mx) {
		*mx = _vala_mx;
	}
	if (my) {
		*my = _vala_my;
	}
}

static void
gnome_pie_pie_window_set_mouse_position (GnomePiePieWindow* self,
                                         gint mx,
                                         gint my)
{
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	GdkDevice* _tmp3_;
	GdkScreen* _tmp4_;
	GdkScreen* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	seat = _tmp2_;
	_tmp3_ = gdk_seat_get_pointer (seat);
	_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	gdk_device_warp (_tmp3_, _tmp5_, mx, my);
	_g_object_unref0 (seat);
}

static gboolean
gnome_pie_pie_window_draw_window (GnomePiePieWindow* self,
                                  cairo_t* ctx)
{
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint mouse_x = 0;
	gint mouse_y = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gdouble frame_time = 0.0;
	GTimer* _tmp7_;
	GTimer* _tmp8_;
	gint center_x = 0;
	GnomePiePieRenderer* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint center_y = 0;
	GnomePiePieRenderer* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GnomePiePieRenderer* _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	gtk_window_get_position ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	if (self->priv->has_compositing) {
		cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
		cairo_paint (ctx);
		cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	} else {
		gint dx = 0;
		gint dy = 0;
		GnomePieImage* _tmp2_;
		cairo_surface_t* _tmp3_;
		cairo_surface_t* _tmp4_;
		dx = self->priv->back_x - x;
		dy = self->priv->back_y - y;
		cairo_save (ctx);
		cairo_translate (ctx, (gdouble) dx, (gdouble) dy);
		cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
		_tmp2_ = self->priv->_background;
		_tmp3_ = gnome_pie_image_get_surface (_tmp2_);
		_tmp4_ = _tmp3_;
		cairo_set_source_surface (ctx, _tmp4_, (gdouble) -1, (gdouble) -1);
		cairo_paint (ctx);
		cairo_restore (ctx);
	}
	gnome_pie_pie_window_get_mouse_position (self, &_tmp5_, &_tmp6_);
	mouse_x = _tmp5_;
	mouse_y = _tmp6_;
	_tmp7_ = self->priv->timer;
	frame_time = g_timer_elapsed (_tmp7_, NULL);
	_tmp8_ = self->priv->timer;
	g_timer_reset (_tmp8_);
	_tmp9_ = self->priv->renderer;
	_tmp10_ = gnome_pie_pie_renderer_get_center_x (_tmp9_);
	_tmp11_ = _tmp10_;
	center_x = _tmp11_;
	_tmp12_ = self->priv->renderer;
	_tmp13_ = gnome_pie_pie_renderer_get_center_y (_tmp12_);
	_tmp14_ = _tmp13_;
	center_y = _tmp14_;
	if (self->priv->wayland) {
		GdkRectangle monitor = {0};
		GdkDisplay* _tmp15_;
		GdkMonitor* _tmp16_;
		GdkRectangle _tmp17_ = {0};
		GdkRectangle _tmp18_;
		GdkRectangle _tmp19_;
		_tmp15_ = gdk_display_get_default ();
		_tmp16_ = gdk_display_get_monitor_at_point (_tmp15_, mouse_x, mouse_y);
		gdk_monitor_get_geometry (_tmp16_, &_tmp17_);
		monitor = _tmp17_;
		_tmp18_ = monitor;
		center_x = _tmp18_.width / 2;
		_tmp19_ = monitor;
		center_y = _tmp19_.height / 2;
	}
	x += center_x;
	y += center_y;
	cairo_translate (ctx, (gdouble) center_x, (gdouble) center_y);
	_tmp20_ = self->priv->renderer;
	gnome_pie_pie_renderer_draw (_tmp20_, frame_time, ctx, mouse_x - x, mouse_y - y);
	result = TRUE;
	return result;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		GnomePiePieWindow* self;
		self = _data20_->self;
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		GnomePiePieWindow* self;
		self = _data21_->_data20_->self;
		block20_data_unref (_data21_->_data20_);
		_data21_->_data20_ = NULL;
		g_slice_free (Block21Data, _data21_);
	}
}

static gboolean
___lambda7_ (Block21Data* _data21_)
{
	Block20Data* _data20_;
	GnomePiePieWindow* self;
	GnomePiePieRenderer* _tmp0_;
	gboolean result;
	_data20_ = _data21_->_data20_;
	self = _data20_->self;
	_tmp0_ = self->priv->renderer;
	gnome_pie_pie_renderer_activate (_tmp0_, _data20_->time_stamp, _data21_->should_close);
	result = FALSE;
	return result;
}

static gboolean
____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda7_ (self);
	return result;
}

static gboolean
____lambda9_ (GnomePiePieWindow* self)
{
	gboolean result;
	self->priv->closed = TRUE;
	g_signal_emit (self, gnome_pie_pie_window_signals[GNOME_PIE_PIE_WINDOW_ON_CLOSED_SIGNAL], 0);
	gtk_widget_destroy ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
_____lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda9_ ((GnomePiePieWindow*) self);
	return result;
}

static void
gnome_pie_pie_window_activate_slice (GnomePiePieWindow* self,
                                     guint32 time_stamp)
{
	Block20Data* _data20_;
	g_return_if_fail (self != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_data20_->time_stamp = time_stamp;
	if (!self->priv->closing) {
		Block21Data* _data21_;
		gboolean _tmp0_ = FALSE;
		_data21_ = g_slice_new0 (Block21Data);
		_data21_->_ref_count_ = 1;
		_data21_->_data20_ = block20_data_ref (_data20_);
		_data21_->should_close = TRUE;
		if ((gnome_pie_key_get_modifiers () & (GDK_CONTROL_MASK | GDK_SHIFT_MASK)) > 0) {
			GnomePiePieRenderer* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = self->priv->renderer;
			_tmp2_ = gnome_pie_pie_renderer_get_id (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp0_ = !gnome_pie_pie_manager_get_is_turbo (_tmp3_);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			_data21_->should_close = FALSE;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, ____lambda7__gsource_func, block21_data_ref (_data21_), block21_data_unref);
		if (_data21_->should_close) {
			GnomePieConfig* _tmp4_;
			GnomePieConfig* _tmp5_;
			GnomePieTheme* _tmp6_;
			GnomePieTheme* _tmp7_;
			gdouble _tmp8_;
			gdouble _tmp9_;
			self->priv->closing = TRUE;
			g_signal_emit (self, gnome_pie_pie_window_signals[GNOME_PIE_PIE_WINDOW_ON_CLOSING_SIGNAL], 0);
			gnome_pie_focus_grabber_ungrab ();
			_tmp4_ = gnome_pie_config_get_global ();
			_tmp5_ = _tmp4_;
			_tmp6_ = gnome_pie_config_get_theme (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gnome_pie_theme_get_fade_out_time (_tmp7_);
			_tmp9_ = _tmp8_;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp9_ * 1000), _____lambda9__gsource_func, g_object_ref (self), g_object_unref);
		}
		block21_data_unref (_data21_);
		_data21_ = NULL;
	}
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static gboolean
___lambda11_ (GnomePiePieWindow* self)
{
	gboolean result;
	self->priv->closed = TRUE;
	g_signal_emit (self, gnome_pie_pie_window_signals[GNOME_PIE_PIE_WINDOW_ON_CLOSED_SIGNAL], 0);
	gtk_widget_destroy ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
____lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda11_ ((GnomePiePieWindow*) self);
	return result;
}

static void
gnome_pie_pie_window_cancel (GnomePiePieWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->closing) {
		GnomePiePieRenderer* _tmp0_;
		GnomePieConfig* _tmp1_;
		GnomePieConfig* _tmp2_;
		GnomePieTheme* _tmp3_;
		GnomePieTheme* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		self->priv->closing = TRUE;
		g_signal_emit (self, gnome_pie_pie_window_signals[GNOME_PIE_PIE_WINDOW_ON_CLOSING_SIGNAL], 0);
		gnome_pie_focus_grabber_ungrab ();
		_tmp0_ = self->priv->renderer;
		gnome_pie_pie_renderer_cancel (_tmp0_);
		_tmp1_ = gnome_pie_config_get_global ();
		_tmp2_ = _tmp1_;
		_tmp3_ = gnome_pie_config_get_theme (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gnome_pie_theme_get_fade_out_time (_tmp4_);
		_tmp6_ = _tmp5_;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp6_ * 1000), ____lambda11__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
gnome_pie_pie_window_set_window_position (GnomePiePieWindow* self,
                                          GnomePiePie* pie)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pie != NULL);
	_tmp0_ = gnome_pie_pie_get_id (pie);
	_tmp1_ = _tmp0_;
	if (gnome_pie_pie_manager_get_is_centered (_tmp1_)) {
		gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
	} else {
		gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_MOUSE);
	}
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		GnomePiePieWindow* self;
		self = _data22_->self;
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static gboolean
__________________lambda13_ (Block22Data* _data22_)
{
	GnomePiePieWindow* self;
	gboolean result;
	self = _data22_->self;
	gnome_pie_pie_window_activate_slice (self, _data22_->time_stamp);
	result = FALSE;
	return result;
}

static gboolean
___________________lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __________________lambda13_ (self);
	return result;
}

static void
gnome_pie_pie_window_handle_key_press (GnomePiePieWindow* self,
                                       guint key,
                                       guint32 time_stamp,
                                       guint32 last_time_stamp,
                                       const gchar* text)
{
	Block22Data* _data22_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_data22_->time_stamp = time_stamp;
	if ((last_time_stamp + 1000) < _data22_->time_stamp) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		_g_free0 (self->priv->search_string);
		self->priv->search_string = _tmp0_;
	}
	_tmp1_ = gdk_keyval_name (key);
	if (g_strcmp0 (_tmp1_, "Escape") == 0) {
		gnome_pie_pie_window_cancel (self);
	} else {
		const gchar* _tmp2_;
		_tmp2_ = gdk_keyval_name (key);
		if (g_strcmp0 (_tmp2_, "Return") == 0) {
			gnome_pie_pie_window_activate_slice (self, _data22_->time_stamp);
		} else {
			const gchar* _tmp3_;
			_tmp3_ = gdk_keyval_name (key);
			if (g_strcmp0 (_tmp3_, "KP_Enter") == 0) {
				gnome_pie_pie_window_activate_slice (self, _data22_->time_stamp);
			} else {
				GnomePiePieRenderer* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp4_ = self->priv->renderer;
				_tmp5_ = gnome_pie_pie_renderer_get_id (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!gnome_pie_pie_manager_get_is_turbo (_tmp6_)) {
					const gchar* _tmp7_;
					_tmp7_ = gdk_keyval_name (key);
					if (g_strcmp0 (_tmp7_, "Up") == 0) {
						GnomePiePieRenderer* _tmp8_;
						_tmp8_ = self->priv->renderer;
						gnome_pie_pie_renderer_select_up (_tmp8_);
					} else {
						const gchar* _tmp9_;
						_tmp9_ = gdk_keyval_name (key);
						if (g_strcmp0 (_tmp9_, "Down") == 0) {
							GnomePiePieRenderer* _tmp10_;
							_tmp10_ = self->priv->renderer;
							gnome_pie_pie_renderer_select_down (_tmp10_);
						} else {
							const gchar* _tmp11_;
							_tmp11_ = gdk_keyval_name (key);
							if (g_strcmp0 (_tmp11_, "Left") == 0) {
								GnomePiePieRenderer* _tmp12_;
								_tmp12_ = self->priv->renderer;
								gnome_pie_pie_renderer_select_left (_tmp12_);
							} else {
								const gchar* _tmp13_;
								_tmp13_ = gdk_keyval_name (key);
								if (g_strcmp0 (_tmp13_, "Right") == 0) {
									GnomePiePieRenderer* _tmp14_;
									_tmp14_ = self->priv->renderer;
									gnome_pie_pie_renderer_select_right (_tmp14_);
								} else {
									const gchar* _tmp15_;
									_tmp15_ = gdk_keyval_name (key);
									if (g_strcmp0 (_tmp15_, "Page_Down") == 0) {
										GnomePiePieRenderer* _tmp16_;
										_tmp16_ = self->priv->renderer;
										gnome_pie_pie_renderer_select_nextpage (_tmp16_);
									} else {
										const gchar* _tmp17_;
										_tmp17_ = gdk_keyval_name (key);
										if (g_strcmp0 (_tmp17_, "Page_Up") == 0) {
											GnomePiePieRenderer* _tmp18_;
											_tmp18_ = self->priv->renderer;
											gnome_pie_pie_renderer_select_prevpage (_tmp18_);
										} else {
											const gchar* _tmp19_;
											_tmp19_ = gdk_keyval_name (key);
											if (g_strcmp0 (_tmp19_, "Tab") == 0) {
												GnomePiePieRenderer* _tmp20_;
												_tmp20_ = self->priv->renderer;
												gnome_pie_pie_renderer_select_nextpage (_tmp20_);
											} else {
												const gchar* _tmp21_;
												_tmp21_ = gdk_keyval_name (key);
												if (g_strcmp0 (_tmp21_, "ISO_Left_Tab") == 0) {
													GnomePiePieRenderer* _tmp22_;
													_tmp22_ = self->priv->renderer;
													gnome_pie_pie_renderer_select_prevpage (_tmp22_);
												} else {
													gboolean _tmp23_ = FALSE;
													const gchar* _tmp24_;
													_tmp24_ = gdk_keyval_name (key);
													if (g_strcmp0 (_tmp24_, "Alt_L") == 0) {
														GnomePieConfig* _tmp25_;
														GnomePieConfig* _tmp26_;
														gboolean _tmp27_;
														gboolean _tmp28_;
														_tmp25_ = gnome_pie_config_get_global ();
														_tmp26_ = _tmp25_;
														_tmp27_ = gnome_pie_config_get_search_by_string (_tmp26_);
														_tmp28_ = _tmp27_;
														_tmp23_ = !_tmp28_;
													} else {
														_tmp23_ = FALSE;
													}
													if (_tmp23_) {
														GnomePiePieRenderer* _tmp29_;
														_tmp29_ = self->priv->renderer;
														gnome_pie_pie_renderer_set_show_hotkeys (_tmp29_, TRUE);
													} else {
														GnomePieConfig* _tmp30_;
														GnomePieConfig* _tmp31_;
														gboolean _tmp32_;
														gboolean _tmp33_;
														_tmp30_ = gnome_pie_config_get_global ();
														_tmp31_ = _tmp30_;
														_tmp32_ = gnome_pie_config_get_search_by_string (_tmp31_);
														_tmp33_ = _tmp32_;
														if (_tmp33_) {
															const gchar* _tmp34_;
															gchar* _tmp35_;
															GnomePiePieRenderer* _tmp36_;
															const gchar* _tmp37_;
															gchar* _tmp38_;
															gchar* _tmp39_;
															_tmp34_ = self->priv->search_string;
															_tmp35_ = g_strconcat (_tmp34_, text, NULL);
															_g_free0 (self->priv->search_string);
															self->priv->search_string = _tmp35_;
															_tmp36_ = self->priv->renderer;
															_tmp37_ = self->priv->search_string;
															_tmp38_ = g_utf8_strdown (_tmp37_, (gssize) -1);
															_tmp39_ = _tmp38_;
															gnome_pie_pie_renderer_select_by_string (_tmp36_, _tmp39_);
															_g_free0 (_tmp39_);
														} else {
															gint index = 0;
															gboolean _tmp40_ = FALSE;
															gboolean _tmp43_ = FALSE;
															index = -1;
															if (key >= ((guint) 48)) {
																_tmp40_ = key <= ((guint) 57);
															} else {
																_tmp40_ = FALSE;
															}
															if (_tmp40_) {
																index = (((gint) key) - 39) % 10;
															} else {
																gboolean _tmp41_ = FALSE;
																if (key >= ((guint) 97)) {
																	_tmp41_ = key <= ((guint) 122);
																} else {
																	_tmp41_ = FALSE;
																}
																if (_tmp41_) {
																	index = ((gint) key) - 87;
																} else {
																	gboolean _tmp42_ = FALSE;
																	if (key >= ((guint) 65)) {
																		_tmp42_ = key <= ((guint) 90);
																	} else {
																		_tmp42_ = FALSE;
																	}
																	if (_tmp42_) {
																		index = ((gint) key) - 55;
																	}
																}
															}
															if (index >= 0) {
																GnomePiePieRenderer* _tmp44_;
																_tmp44_ = self->priv->renderer;
																_tmp43_ = index < gnome_pie_pie_renderer_slice_count (_tmp44_);
															} else {
																_tmp43_ = FALSE;
															}
															if (_tmp43_) {
																GnomePiePieRenderer* _tmp45_;
																GnomePiePieRenderer* _tmp46_;
																GnomePiePieRenderer* _tmp47_;
																gint _tmp48_;
																gint _tmp49_;
																_tmp45_ = self->priv->renderer;
																gnome_pie_pie_renderer_set_key_board_control (_tmp45_, TRUE);
																_tmp46_ = self->priv->renderer;
																gnome_pie_pie_renderer_select_by_index (_tmp46_, index);
																_tmp47_ = self->priv->renderer;
																_tmp48_ = gnome_pie_pie_renderer_get_active_slice (_tmp47_);
																_tmp49_ = _tmp48_;
																if (_tmp49_ == index) {
																	GnomePieConfig* _tmp50_;
																	GnomePieConfig* _tmp51_;
																	GnomePieTheme* _tmp52_;
																	GnomePieTheme* _tmp53_;
																	gdouble _tmp54_;
																	gdouble _tmp55_;
																	_tmp50_ = gnome_pie_config_get_global ();
																	_tmp51_ = _tmp50_;
																	_tmp52_ = gnome_pie_config_get_theme (_tmp51_);
																	_tmp53_ = _tmp52_;
																	_tmp54_ = gnome_pie_theme_get_transition_time (_tmp53_);
																	_tmp55_ = _tmp54_;
																	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp55_ * 1000.0), ___________________lambda13__gsource_func, block22_data_ref (_data22_), block22_data_unref);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static void
gnome_pie_pie_window_handle_key_release (GnomePiePieWindow* self,
                                         guint key)
{
	GnomePiePieRenderer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->renderer;
	_tmp1_ = gnome_pie_pie_renderer_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!gnome_pie_pie_manager_get_is_turbo (_tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = gdk_keyval_name (key);
		if (g_strcmp0 (_tmp3_, "Alt_L") == 0) {
			GnomePiePieRenderer* _tmp4_;
			_tmp4_ = self->priv->renderer;
			gnome_pie_pie_renderer_set_show_hotkeys (_tmp4_, FALSE);
		}
	}
}

GnomePieImage*
gnome_pie_pie_window_get_background (GnomePiePieWindow* self)
{
	GnomePieImage* result;
	GnomePieImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_pie_window_set_background (GnomePiePieWindow* self,
                                     GnomePieImage* value)
{
	GnomePieImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_pie_window_get_background (self);
	if (old_value != value) {
		GnomePieImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_background);
		self->priv->_background = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_pie_window_properties[GNOME_PIE_PIE_WINDOW_BACKGROUND_PROPERTY]);
	}
}

static void
gnome_pie_pie_window_class_init (GnomePiePieWindowClass * klass,
                                 gpointer klass_data)
{
	gnome_pie_pie_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePiePieWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_pie_pie_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_pie_pie_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_pie_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_PIE_WINDOW_BACKGROUND_PROPERTY, gnome_pie_pie_window_properties[GNOME_PIE_PIE_WINDOW_BACKGROUND_PROPERTY] = g_param_spec_object ("background", "background", "background", GNOME_PIE_TYPE_IMAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gnome_pie_pie_window_signals[GNOME_PIE_PIE_WINDOW_ON_CLOSING_SIGNAL] = g_signal_new ("on-closing", GNOME_PIE_TYPE_PIE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gnome_pie_pie_window_signals[GNOME_PIE_PIE_WINDOW_ON_CLOSED_SIGNAL] = g_signal_new ("on-closed", GNOME_PIE_TYPE_PIE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gnome_pie_pie_window_instance_init (GnomePiePieWindow * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	self->priv = gnome_pie_pie_window_get_instance_private (self);
	self->priv->_background = NULL;
	self->priv->panel_sz = 64;
	self->priv->mouse_move = 30;
	self->priv->closing = FALSE;
	self->priv->closed = FALSE;
	self->priv->has_compositing = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->search_string = _tmp0_;
	_tmp1_ = g_getenv ("XDG_SESSION_TYPE");
	self->priv->wayland = g_strcmp0 (_tmp1_, "wayland") == 0;
}

static void
gnome_pie_pie_window_finalize (GObject * obj)
{
	GnomePiePieWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindow);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->renderer);
	_g_timer_destroy0 (self->priv->timer);
	_g_free0 (self->priv->search_string);
	G_OBJECT_CLASS (gnome_pie_pie_window_parent_class)->finalize (obj);
}

static GType
gnome_pie_pie_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePiePieWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_pie_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePiePieWindow), 0, (GInstanceInitFunc) gnome_pie_pie_window_instance_init, NULL };
	GType gnome_pie_pie_window_type_id;
	gnome_pie_pie_window_type_id = g_type_register_static (gtk_window_get_type (), "GnomePiePieWindow", &g_define_type_info, 0);
	GnomePiePieWindow_private_offset = g_type_add_instance_private (gnome_pie_pie_window_type_id, sizeof (GnomePiePieWindowPrivate));
	return gnome_pie_pie_window_type_id;
}

GType
gnome_pie_pie_window_get_type (void)
{
	static volatile gsize gnome_pie_pie_window_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_pie_window_type_id__once)) {
		GType gnome_pie_pie_window_type_id;
		gnome_pie_pie_window_type_id = gnome_pie_pie_window_get_type_once ();
		g_once_init_leave (&gnome_pie_pie_window_type_id__once, gnome_pie_pie_window_type_id);
	}
	return gnome_pie_pie_window_type_id__once;
}

static void
_vala_gnome_pie_pie_window_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GnomePiePieWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindow);
	switch (property_id) {
		case GNOME_PIE_PIE_WINDOW_BACKGROUND_PROPERTY:
		g_value_set_object (value, gnome_pie_pie_window_get_background (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_pie_pie_window_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GnomePiePieWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindow);
	switch (property_id) {
		case GNOME_PIE_PIE_WINDOW_BACKGROUND_PROPERTY:
		gnome_pie_pie_window_set_background (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

