/* world-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from world-item.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgweather/gweather.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define RISESET_CORRECTION_NONE 0.0
#define RISESET_CORRECTION_CIVIL 6.0
#define RISESET_CORRECTION_NAUTICAL 12.0
#define RISESET_CORRECTION_ASTRONOMICAL 18.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CLOCKS_WORLD_SUN_STATE_NONE,
	CLOCKS_WORLD_SUN_STATE_NIGHT,
	CLOCKS_WORLD_SUN_STATE_ASTRO,
	CLOCKS_WORLD_SUN_STATE_NAUT,
	CLOCKS_WORLD_SUN_STATE_CIVIL,
	CLOCKS_WORLD_SUN_STATE_DAY
} ClocksWorldSunState;

#define CLOCKS_WORLD_TYPE_SUN_STATE (clocks_world_sun_state_get_type ())

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;
typedef struct _ClocksWorldItemPrivate ClocksWorldItemPrivate;
enum  {
	CLOCKS_WORLD_ITEM_0_PROPERTY,
	CLOCKS_WORLD_ITEM_LOCATION_PROPERTY,
	CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY,
	CLOCKS_WORLD_ITEM_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_TIME_LABEL_SECONDS_PROPERTY,
	CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_LOCAL_OFFSET_PROPERTY,
	CLOCKS_WORLD_ITEM_SUN_STATE_PROPERTY,
	CLOCKS_WORLD_ITEM_NUM_PROPERTIES
};
static GParamSpec* clocks_world_item_properties[CLOCKS_WORLD_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
enum  {
	CLOCKS_WORLD_ITEM_TICK_SIGNAL,
	CLOCKS_WORLD_ITEM_NUM_SIGNALS
};
static guint clocks_world_item_signals[CLOCKS_WORLD_ITEM_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksWorldItem {
	GObject parent_instance;
	ClocksWorldItemPrivate * priv;
};

struct _ClocksWorldItemClass {
	GObjectClass parent_class;
	void (*tick) (ClocksWorldItem* self);
};

struct _ClocksWorldItemPrivate {
	GWeatherLocation* _location;
	gboolean _automatic;
	gchar* _name;
	GTimeZone* time_zone;
	GDateTime* local_time;
	GDateTime* date_time;
	GWeatherInfo* weather_info;
	GDateTime* sun_rise;
	GDateTime* sun_set;
	GDateTime* civil_rise;
	GDateTime* civil_set;
	GDateTime* naut_rise;
	GDateTime* naut_set;
	GDateTime* astro_rise;
	GDateTime* astro_set;
	gint last_calc_day;
};

static gint ClocksWorldItem_private_offset;
static gpointer clocks_world_item_parent_class = NULL;
static ClocksContentItemIface * clocks_world_item_clocks_content_item_parent_iface = NULL;

VALA_EXTERN GType clocks_world_sun_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* clocks_world_sun_state_as_css (ClocksWorldSunState self);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN GType clocks_world_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldItem, g_object_unref)
static gboolean clocks_world_item_is_current (ClocksWorldItem* self,
                                       GDateTime* sunrise,
                                       GDateTime* sunset);
VALA_EXTERN ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location);
VALA_EXTERN ClocksWorldItem* clocks_world_item_construct (GType object_type,
                                              GWeatherLocation* location);
static void clocks_world_item_calculate_riseset_at_correction (ClocksWorldItem* self,
                                                        gdouble latitude,
                                                        gdouble longitude,
                                                        gint year,
                                                        gint month,
                                                        gint day,
                                                        gdouble correction,
                                                        GDateTime** sunrise,
                                                        GDateTime** sunset);
gboolean calculate_sunrise_sunset (gdouble lat,
                                   gdouble lon,
                                   gint year,
                                   gint month,
                                   gint day,
                                   gdouble correction,
                                   gint* rise_hour,
                                   gint* rise_min,
                                   gint* set_hour,
                                   gint* set_min);
static void clocks_world_item_calculate_riseset (ClocksWorldItem* self);
VALA_EXTERN GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self);
static void clocks_world_item_real_serialize (ClocksContentItem* base,
                                       GVariantBuilder* builder);
VALA_EXTERN gboolean clocks_world_item_get_automatic (ClocksWorldItem* self);
VALA_EXTERN ClocksContentItem* clocks_world_item_deserialize (GVariant* location_variant);
VALA_EXTERN void clocks_world_item_set_location (ClocksWorldItem* self,
                                     GWeatherLocation* value);
VALA_EXTERN void clocks_world_item_set_automatic (ClocksWorldItem* self,
                                      gboolean value);
VALA_EXTERN gchar* clocks_world_item_get_country_name (ClocksWorldItem* self);
VALA_EXTERN gchar* clocks_world_item_get_state_name (ClocksWorldItem* self);
VALA_EXTERN gchar* clocks_world_item_get_city_name (ClocksWorldItem* self);
VALA_EXTERN gchar* clocks_world_item_get_sunrise_label (ClocksWorldItem* self);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
VALA_EXTERN gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self,
                                            GDateTime* date_time,
                                            gboolean seconds);
VALA_EXTERN gchar* clocks_world_item_get_sunset_label (ClocksWorldItem* self);
VALA_EXTERN gchar* clocks_world_item_get_time_label (ClocksWorldItem* self);
VALA_EXTERN gchar* clocks_world_item_get_time_label_seconds (ClocksWorldItem* self);
VALA_EXTERN const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self);
VALA_EXTERN GTimeSpan clocks_world_item_get_local_offset (ClocksWorldItem* self);
VALA_EXTERN ClocksWorldSunState clocks_world_item_get_sun_state (ClocksWorldItem* self);
static void clocks_world_item_real_tick (ClocksWorldItem* self);
VALA_EXTERN GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
VALA_EXTERN void clocks_content_item_serialize (ClocksContentItem* self,
                                    GVariantBuilder* builder);
VALA_EXTERN const gchar* clocks_content_item_get_name (ClocksContentItem* self);
VALA_EXTERN void clocks_content_item_set_name (ClocksContentItem* self,
                                   const gchar* value);
static void clocks_world_item_finalize (GObject * obj);
static GType clocks_world_item_get_type_once (void);
static void _vala_clocks_world_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_clocks_world_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

const gchar* CLOCKS_WORLD_STATE_CLASSES[6] = {"none", "night", "astro", "naut", "civil", "day"};

gchar*
clocks_world_sun_state_as_css (ClocksWorldSunState self)
{
	gchar* result;
	switch (self) {
		default:
		case CLOCKS_WORLD_SUN_STATE_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("none");
			result = _tmp0_;
			return result;
		}
		case CLOCKS_WORLD_SUN_STATE_NIGHT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("night");
			result = _tmp1_;
			return result;
		}
		case CLOCKS_WORLD_SUN_STATE_ASTRO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("astro");
			result = _tmp2_;
			return result;
		}
		case CLOCKS_WORLD_SUN_STATE_NAUT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("naut");
			result = _tmp3_;
			return result;
		}
		case CLOCKS_WORLD_SUN_STATE_CIVIL:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("civil");
			result = _tmp4_;
			return result;
		}
		case CLOCKS_WORLD_SUN_STATE_DAY:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("day");
			result = _tmp5_;
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
clocks_world_sun_state_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_WORLD_SUN_STATE_NONE, "CLOCKS_WORLD_SUN_STATE_NONE", "none"}, {CLOCKS_WORLD_SUN_STATE_NIGHT, "CLOCKS_WORLD_SUN_STATE_NIGHT", "night"}, {CLOCKS_WORLD_SUN_STATE_ASTRO, "CLOCKS_WORLD_SUN_STATE_ASTRO", "astro"}, {CLOCKS_WORLD_SUN_STATE_NAUT, "CLOCKS_WORLD_SUN_STATE_NAUT", "naut"}, {CLOCKS_WORLD_SUN_STATE_CIVIL, "CLOCKS_WORLD_SUN_STATE_CIVIL", "civil"}, {CLOCKS_WORLD_SUN_STATE_DAY, "CLOCKS_WORLD_SUN_STATE_DAY", "day"}, {0, NULL, NULL}};
	GType clocks_world_sun_state_type_id;
	clocks_world_sun_state_type_id = g_enum_register_static ("ClocksWorldSunState", values);
	return clocks_world_sun_state_type_id;
}

GType
clocks_world_sun_state_get_type (void)
{
	static gsize clocks_world_sun_state_type_id__once = 0;
	if (g_once_init_enter (&clocks_world_sun_state_type_id__once)) {
		GType clocks_world_sun_state_type_id;
		clocks_world_sun_state_type_id = clocks_world_sun_state_get_type_once ();
		g_once_init_leave (&clocks_world_sun_state_type_id__once, clocks_world_sun_state_type_id);
	}
	return clocks_world_sun_state_type_id__once;
}

static inline gpointer
clocks_world_item_get_instance_private (ClocksWorldItem* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksWorldItem_private_offset);
}

static gboolean
clocks_world_item_is_current (ClocksWorldItem* self,
                              GDateTime* sunrise,
                              GDateTime* sunset)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GDateTime* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (sunrise == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sunset == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->date_time;
	if (g_date_time_compare (_tmp2_, (GDateTime*) sunrise) > 0) {
		GDateTime* _tmp3_;
		_tmp3_ = self->priv->date_time;
		_tmp1_ = g_date_time_compare (_tmp3_, (GDateTime*) sunset) < 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

static gpointer
_g_time_zone_ref0 (gpointer self)
{
	return self ? g_time_zone_ref (self) : NULL;
}

ClocksWorldItem*
clocks_world_item_construct (GType object_type,
                             GWeatherLocation* location)
{
	ClocksWorldItem * self = NULL;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	g_return_val_if_fail (location != NULL, NULL);
	self = (ClocksWorldItem*) g_object_new (object_type, "location", location, NULL);
	_tmp0_ = gweather_location_get_timezone (location);
	_tmp1_ = _g_time_zone_ref0 (_tmp0_);
	_g_time_zone_unref0 (self->priv->time_zone);
	self->priv->time_zone = _tmp1_;
	g_signal_emit (self, clocks_world_item_signals[CLOCKS_WORLD_ITEM_TICK_SIGNAL], 0);
	return self;
}

ClocksWorldItem*
clocks_world_item_new (GWeatherLocation* location)
{
	return clocks_world_item_construct (CLOCKS_WORLD_TYPE_ITEM, location);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
clocks_world_item_calculate_riseset_at_correction (ClocksWorldItem* self,
                                                   gdouble latitude,
                                                   gdouble longitude,
                                                   gint year,
                                                   gint month,
                                                   gint day,
                                                   gdouble correction,
                                                   GDateTime** sunrise,
                                                   GDateTime** sunset)
{
	GDateTime* _vala_sunrise = NULL;
	GDateTime* _vala_sunset = NULL;
	GTimeZone* _tmp0_;
	gint rise_hour = 0;
	gint rise_min = 0;
	gint set_hour = 0;
	gint set_min = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	GDateTime* utc_sunrise = NULL;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* utc_sunset = NULL;
	GDateTime* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GDateTime* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->time_zone;
	_vala_return_if_fail (_tmp0_ != NULL, "time_zone != null");
	_tmp5_ = calculate_sunrise_sunset (latitude, longitude, year, month, day, correction, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	rise_hour = _tmp1_;
	rise_min = _tmp2_;
	set_hour = _tmp3_;
	set_min = _tmp4_;
	if (!_tmp5_) {
		_g_date_time_unref0 (_vala_sunrise);
		_vala_sunrise = NULL;
		_g_date_time_unref0 (_vala_sunset);
		_vala_sunset = NULL;
		g_debug ("world-item.vala:280: Location (%f,%f) has incalculable sunset/sunrise", latitude, longitude);
		if (sunrise) {
			*sunrise = _vala_sunrise;
		} else {
			_g_date_time_unref0 (_vala_sunrise);
		}
		if (sunset) {
			*sunset = _vala_sunset;
		} else {
			_g_date_time_unref0 (_vala_sunset);
		}
		return;
	}
	_tmp6_ = g_date_time_new_utc (year, month, day, rise_hour, rise_min, (gdouble) 0);
	utc_sunrise = (GDateTime*) _tmp6_;
	_tmp7_ = utc_sunrise;
	if (_tmp7_ != NULL) {
		GDateTime* _tmp8_;
		GTimeZone* _tmp9_;
		GDateTime* _tmp10_;
		_tmp8_ = utc_sunrise;
		_tmp9_ = self->priv->time_zone;
		_tmp10_ = g_date_time_to_timezone ((GDateTime*) _tmp8_, (GTimeZone*) _tmp9_);
		_g_date_time_unref0 (_vala_sunrise);
		_vala_sunrise = _tmp10_;
	} else {
		_g_date_time_unref0 (_vala_sunrise);
		_vala_sunrise = NULL;
		g_warning ("world-item.vala:291: Sunrise for (%f,%f) resulted in %04i-%02i-%02i %0" \
"2i:%02i", latitude, longitude, year, month, day, rise_hour, rise_min);
	}
	_tmp11_ = g_date_time_new_utc (year, month, day, set_hour, set_min, (gdouble) 0);
	utc_sunset = (GDateTime*) _tmp11_;
	_tmp13_ = utc_sunset;
	if (_tmp13_ != NULL) {
		GDateTime* _tmp14_;
		_tmp14_ = _vala_sunrise;
		_tmp12_ = _tmp14_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GDateTime* local_sunset = NULL;
		GDateTime* _tmp15_;
		GTimeZone* _tmp16_;
		GDateTime* _tmp17_;
		GDateTime* _tmp18_;
		GDateTime* _tmp19_;
		_tmp15_ = utc_sunset;
		_tmp16_ = self->priv->time_zone;
		_tmp17_ = g_date_time_to_timezone ((GDateTime*) _tmp15_, (GTimeZone*) _tmp16_);
		local_sunset = _tmp17_;
		_tmp18_ = local_sunset;
		_tmp19_ = _vala_sunrise;
		if (g_date_time_compare (_tmp18_, (GDateTime*) _tmp19_) < 0) {
			GDateTime* _tmp20_;
			GDateTime* _tmp21_;
			_tmp20_ = local_sunset;
			_tmp21_ = g_date_time_add_days (_tmp20_, 1);
			_g_date_time_unref0 (_vala_sunset);
			_vala_sunset = _tmp21_;
		} else {
			GDateTime* _tmp22_;
			GDateTime* _tmp23_;
			_tmp22_ = local_sunset;
			_tmp23_ = _g_date_time_ref0 (_tmp22_);
			_g_date_time_unref0 (_vala_sunset);
			_vala_sunset = _tmp23_;
		}
		_g_date_time_unref0 (local_sunset);
	} else {
		_g_date_time_unref0 (_vala_sunset);
		_vala_sunset = NULL;
		g_warning ("world-item.vala:311: Sunset for (%f,%f) resulted in %04i-%02i-%02i %02" \
"i:%02i", latitude, longitude, year, month, day, rise_hour, rise_min);
	}
	_g_date_time_unref0 (utc_sunset);
	_g_date_time_unref0 (utc_sunrise);
	if (sunrise) {
		*sunrise = _vala_sunrise;
	} else {
		_g_date_time_unref0 (_vala_sunrise);
	}
	if (sunset) {
		*sunset = _vala_sunset;
	} else {
		_g_date_time_unref0 (_vala_sunset);
	}
}

static void
clocks_world_item_calculate_riseset (ClocksWorldItem* self)
{
	gdouble latitude = 0.0;
	gdouble longitude = 0.0;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	GDateTime* _tmp0_;
	GWeatherLocation* _tmp1_;
	GWeatherLocation* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gboolean _tmp5_ = FALSE;
	GDateTime* utc = NULL;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GDateTime* _tmp12_ = NULL;
	GDateTime* _tmp13_ = NULL;
	GDateTime* _tmp14_ = NULL;
	GDateTime* _tmp15_ = NULL;
	GDateTime* _tmp16_ = NULL;
	GDateTime* _tmp17_ = NULL;
	GDateTime* _tmp18_ = NULL;
	GDateTime* _tmp19_ = NULL;
	GDateTime* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->date_time;
	if (g_date_time_get_day_of_year (_tmp0_) == self->priv->last_calc_day) {
		return;
	}
	_tmp1_ = self->priv->_location;
	if (!gweather_location_has_coords (_tmp1_)) {
		return;
	}
	_tmp2_ = self->priv->_location;
	gweather_location_get_coords (_tmp2_, &_tmp3_, &_tmp4_);
	latitude = _tmp3_;
	longitude = _tmp4_;
	if (!isfinite (latitude)) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = !isfinite (longitude);
	}
	if (_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->date_time;
	_tmp7_ = g_date_time_to_utc (_tmp6_);
	utc = _tmp7_;
	_tmp8_ = utc;
	g_date_time_get_ymd (_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	year = _tmp9_;
	month = _tmp10_;
	day = _tmp11_;
	clocks_world_item_calculate_riseset_at_correction (self, latitude, longitude, year, month, day, RISESET_CORRECTION_NONE, &_tmp12_, &_tmp13_);
	_g_date_time_unref0 (self->priv->sun_rise);
	self->priv->sun_rise = _tmp12_;
	_g_date_time_unref0 (self->priv->sun_set);
	self->priv->sun_set = _tmp13_;
	clocks_world_item_calculate_riseset_at_correction (self, latitude, longitude, year, month, day, RISESET_CORRECTION_CIVIL, &_tmp14_, &_tmp15_);
	_g_date_time_unref0 (self->priv->civil_rise);
	self->priv->civil_rise = _tmp14_;
	_g_date_time_unref0 (self->priv->civil_set);
	self->priv->civil_set = _tmp15_;
	clocks_world_item_calculate_riseset_at_correction (self, latitude, longitude, year, month, day, RISESET_CORRECTION_NAUTICAL, &_tmp16_, &_tmp17_);
	_g_date_time_unref0 (self->priv->naut_rise);
	self->priv->naut_rise = _tmp16_;
	_g_date_time_unref0 (self->priv->naut_set);
	self->priv->naut_set = _tmp17_;
	clocks_world_item_calculate_riseset_at_correction (self, latitude, longitude, year, month, day, RISESET_CORRECTION_ASTRONOMICAL, &_tmp18_, &_tmp19_);
	_g_date_time_unref0 (self->priv->astro_rise);
	self->priv->astro_rise = _tmp18_;
	_g_date_time_unref0 (self->priv->astro_set);
	self->priv->astro_set = _tmp19_;
	_tmp20_ = self->priv->date_time;
	self->priv->last_calc_day = g_date_time_get_day_of_year (_tmp20_);
	_g_date_time_unref0 (utc);
}

static void
clocks_world_item_real_serialize (ClocksContentItem* base,
                                  GVariantBuilder* builder)
{
	ClocksWorldItem * self;
	gboolean _tmp0_;
	self = (ClocksWorldItem*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = self->priv->_automatic;
	if (!_tmp0_) {
		GVariantType* _tmp1_;
		GVariantType* _tmp2_;
		GWeatherLocation* _tmp3_;
		GVariant* _tmp4_;
		_tmp1_ = g_variant_type_new ("a{sv}");
		_tmp2_ = _tmp1_;
		g_variant_builder_open (builder, _tmp2_);
		_g_variant_type_free0 (_tmp2_);
		_tmp3_ = self->priv->_location;
		_tmp4_ = gweather_location_serialize (_tmp3_);
		g_variant_builder_add (builder, "{sv}", "location", _tmp4_, NULL);
		g_variant_builder_close (builder);
	}
}

ClocksContentItem*
clocks_world_item_deserialize (GVariant* location_variant)
{
	GWeatherLocation* location = NULL;
	gchar* key = NULL;
	GVariant* val = NULL;
	GWeatherLocation* world = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp2_;
	GWeatherLocation* _tmp11_;
	ClocksContentItem* result;
	g_return_val_if_fail (location_variant != NULL, NULL);
	location = NULL;
	_tmp0_ = gweather_location_get_world ();
	world = _tmp0_;
	_tmp1_ = world;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (world);
		_g_variant_unref0 (val);
		_g_free0 (key);
		_g_object_unref0 (location);
		return result;
	}
	_tmp2_ = g_variant_iter_new (location_variant);
	iter = _tmp2_;
	while (TRUE) {
		GVariantIter* _tmp3_;
		gchar* _tmp4_ = NULL;
		GVariant* _tmp5_ = NULL;
		gboolean _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = iter;
		_tmp6_ = g_variant_iter_next (_tmp3_, "{sv}", &_tmp4_, &_tmp5_, NULL);
		_g_free0 (key);
		key = _tmp4_;
		_g_variant_unref0 (val);
		val = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = key;
		if (g_strcmp0 (_tmp7_, "location") == 0) {
			GWeatherLocation* _tmp8_;
			GVariant* _tmp9_;
			GWeatherLocation* _tmp10_;
			_tmp8_ = world;
			_tmp9_ = val;
			_tmp10_ = gweather_location_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gweather_location_get_type (), GWeatherLocation), _tmp9_);
			_g_object_unref0 (location);
			location = _tmp10_;
		}
	}
	_tmp11_ = location;
	if (_tmp11_ == NULL) {
		result = NULL;
		_g_variant_iter_free0 (iter);
		_g_object_unref0 (world);
		_g_variant_unref0 (val);
		_g_free0 (key);
		_g_object_unref0 (location);
		return result;
	} else {
		GWeatherLocation* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = location;
		_tmp13_ = gweather_location_get_timezone_str (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gweather_location_get_type (), GWeatherLocation));
		if (_tmp13_ == NULL) {
			GWeatherLocation* _tmp14_;
			const gchar* _tmp15_;
			_tmp14_ = location;
			_tmp15_ = gweather_location_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gweather_location_get_type (), GWeatherLocation));
			g_warning ("world-item.vala:441: Invalid location “%s” – timezone unknown. Ignorin" \
"g.", _tmp15_);
			result = NULL;
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (world);
			_g_variant_unref0 (val);
			_g_free0 (key);
			_g_object_unref0 (location);
			return result;
		} else {
			GWeatherLocation* _tmp16_;
			ClocksWorldItem* _tmp17_;
			_tmp16_ = location;
			_tmp17_ = clocks_world_item_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gweather_location_get_type (), GWeatherLocation));
			result = (ClocksContentItem*) _tmp17_;
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (world);
			_g_variant_unref0 (val);
			_g_free0 (key);
			_g_object_unref0 (location);
			return result;
		}
	}
}

GWeatherLocation*
clocks_world_item_get_location (ClocksWorldItem* self)
{
	GWeatherLocation* result;
	GWeatherLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
clocks_world_item_set_location (ClocksWorldItem* self,
                                GWeatherLocation* value)
{
	GWeatherLocation* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_world_item_get_location (self);
	if (old_value != value) {
		GWeatherLocation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_LOCATION_PROPERTY]);
	}
}

gboolean
clocks_world_item_get_automatic (ClocksWorldItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic;
	return result;
}

void
clocks_world_item_set_automatic (ClocksWorldItem* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_world_item_get_automatic (self);
	if (old_value != value) {
		self->priv->_automatic = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY]);
	}
}

static const gchar*
clocks_world_item_real_get_name (ClocksContentItem* base)
{
	const gchar* result;
	ClocksWorldItem* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp27_;
	self = (ClocksWorldItem*) base;
	_tmp0_ = clocks_world_item_get_country_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = clocks_world_item_get_state_name (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_ != NULL;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp8_ = clocks_world_item_get_city_name (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = clocks_world_item_get_state_name (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = (gchar*) _tmp12_;
			_tmp14_ = clocks_world_item_get_country_name (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = (gchar*) _tmp15_;
			_tmp17_ = g_strdup_printf ("%s, %s, %s", _tmp10_, _tmp13_, _tmp16_);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp17_;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp10_);
		} else {
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp18_ = clocks_world_item_get_city_name (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = clocks_world_item_get_country_name (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = (gchar*) _tmp22_;
			_tmp24_ = g_strdup_printf ("%s, %s", _tmp20_, _tmp23_);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp24_;
			_g_free0 (_tmp23_);
			_g_free0 (_tmp20_);
		}
	} else {
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = clocks_world_item_get_city_name (self);
		_tmp26_ = _tmp25_;
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp26_;
	}
	_tmp27_ = self->priv->_name;
	result = _tmp27_;
	return result;
}

static void
clocks_world_item_real_set_name (ClocksContentItem* base,
                                 const gchar* value)
{
	ClocksWorldItem* self;
	self = (ClocksWorldItem*) base;
	g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_NAME_PROPERTY]);
}

gchar*
clocks_world_item_get_city_name (ClocksWorldItem* self)
{
	gchar* result;
	gchar* city_name = NULL;
	GWeatherLocation* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_city_name (_tmp0_);
	city_name = _tmp1_;
	_tmp2_ = city_name;
	if (_tmp2_ == NULL) {
		GWeatherLocation* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->_location;
		_tmp4_ = gweather_location_get_name (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (city_name);
		city_name = _tmp5_;
	}
	_tmp6_ = city_name;
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	result = _tmp7_;
	_g_free0 (city_name);
	return result;
}

gchar*
clocks_world_item_get_state_name (ClocksWorldItem* self)
{
	gchar* result;
	GWeatherLocation* parent = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	GWeatherLocation* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_parent (_tmp0_);
	parent = _tmp1_;
	_tmp2_ = parent;
	if (_tmp2_ != NULL) {
		GWeatherLocation* _tmp3_;
		_tmp3_ = parent;
		if (gweather_location_get_level (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gweather_location_get_type (), GWeatherLocation)) == GWEATHER_LOCATION_ADM1) {
			GWeatherLocation* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = parent;
			_tmp5_ = gweather_location_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gweather_location_get_type (), GWeatherLocation));
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			_g_object_unref0 (parent);
			return result;
		}
	}
	result = NULL;
	_g_object_unref0 (parent);
	return result;
}

gchar*
clocks_world_item_get_country_name (ClocksWorldItem* self)
{
	gchar* result;
	GWeatherLocation* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_country_name (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
clocks_world_item_get_sunrise_label (ClocksWorldItem* self)
{
	gchar* result;
	GWeatherInfo* _tmp0_;
	gulong sunrise = 0UL;
	GWeatherInfo* _tmp2_;
	gulong _tmp3_ = 0UL;
	gboolean _tmp4_;
	GTimeZone* _tmp6_;
	GDateTime* sunrise_time = NULL;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GTimeZone* _tmp10_;
	GDateTime* _tmp11_;
	ClocksUtilsWallClock* _tmp12_;
	ClocksUtilsWallClock* _tmp13_;
	GDateTime* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("-");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->weather_info;
	_tmp4_ = gweather_info_get_value_sunrise (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gweather_info_get_type (), GWeatherInfo), &_tmp3_);
	sunrise = _tmp3_;
	if (!_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("-");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->priv->time_zone;
	if (_tmp6_ == NULL) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("-");
		result = _tmp7_;
		return result;
	}
	_tmp8_ = g_date_time_new_from_unix_local ((gint64) sunrise);
	sunrise_time = _tmp8_;
	_tmp9_ = sunrise_time;
	_tmp10_ = self->priv->time_zone;
	_tmp11_ = g_date_time_to_timezone (_tmp9_, (GTimeZone*) _tmp10_);
	_g_date_time_unref0 (sunrise_time);
	sunrise_time = _tmp11_;
	_tmp12_ = clocks_utils_wall_clock_get_default ();
	_tmp13_ = _tmp12_;
	_tmp14_ = sunrise_time;
	_tmp15_ = clocks_utils_wall_clock_format_time (_tmp13_, _tmp14_, FALSE);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp13_);
	result = _tmp16_;
	_g_date_time_unref0 (sunrise_time);
	return result;
}

gchar*
clocks_world_item_get_sunset_label (ClocksWorldItem* self)
{
	gchar* result;
	GWeatherInfo* _tmp0_;
	gulong sunset = 0UL;
	GWeatherInfo* _tmp2_;
	gulong _tmp3_ = 0UL;
	gboolean _tmp4_;
	GTimeZone* _tmp6_;
	GDateTime* sunset_time = NULL;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GTimeZone* _tmp10_;
	GDateTime* _tmp11_;
	ClocksUtilsWallClock* _tmp12_;
	ClocksUtilsWallClock* _tmp13_;
	GDateTime* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("-");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->weather_info;
	_tmp4_ = gweather_info_get_value_sunset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gweather_info_get_type (), GWeatherInfo), &_tmp3_);
	sunset = _tmp3_;
	if (!_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("-");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->priv->time_zone;
	if (_tmp6_ == NULL) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("-");
		result = _tmp7_;
		return result;
	}
	_tmp8_ = g_date_time_new_from_unix_local ((gint64) sunset);
	sunset_time = _tmp8_;
	_tmp9_ = sunset_time;
	_tmp10_ = self->priv->time_zone;
	_tmp11_ = g_date_time_to_timezone (_tmp9_, (GTimeZone*) _tmp10_);
	_g_date_time_unref0 (sunset_time);
	sunset_time = _tmp11_;
	_tmp12_ = clocks_utils_wall_clock_get_default ();
	_tmp13_ = _tmp12_;
	_tmp14_ = sunset_time;
	_tmp15_ = clocks_utils_wall_clock_format_time (_tmp13_, _tmp14_, FALSE);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp13_);
	result = _tmp16_;
	_g_date_time_unref0 (sunset_time);
	return result;
}

gchar*
clocks_world_item_get_time_label (ClocksWorldItem* self)
{
	gchar* result;
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->date_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_, FALSE);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gchar*
clocks_world_item_get_time_label_seconds (ClocksWorldItem* self)
{
	gchar* result;
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->date_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_, TRUE);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

const gchar*
clocks_world_item_get_day_label (ClocksWorldItem* self)
{
	const gchar* result;
	gint d = 0;
	GDateTime* _tmp0_;
	gint t = 0;
	GDateTime* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->date_time;
	d = g_date_time_get_day_of_year (_tmp0_);
	_tmp1_ = self->priv->local_time;
	t = g_date_time_get_day_of_year (_tmp1_);
	if (d < t) {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		if (d == 1) {
			_tmp3_ = t != 2;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = _ ("Tomorrow");
		} else {
			_tmp2_ = _ ("Yesterday");
		}
		result = _tmp2_;
		return result;
	} else {
		if (d > t) {
			const gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			if (t == 1) {
				_tmp5_ = d != 2;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = _ ("Yesterday");
			} else {
				_tmp4_ = _ ("Tomorrow");
			}
			result = _tmp4_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}

GTimeSpan
clocks_world_item_get_local_offset (ClocksWorldItem* self)
{
	GTimeSpan result;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->local_time;
	_tmp1_ = self->priv->date_time;
	result = g_date_time_get_utc_offset (_tmp0_) - g_date_time_get_utc_offset (_tmp1_);
	return result;
}

ClocksWorldSunState
clocks_world_item_get_sun_state (ClocksWorldItem* self)
{
	ClocksWorldSunState result;
	gboolean _tmp0_ = FALSE;
	GDateTime* _tmp1_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->sun_rise;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GDateTime* _tmp2_;
		_tmp2_ = self->priv->sun_set;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		result = CLOCKS_WORLD_SUN_STATE_NONE;
		return result;
	}
	_tmp3_ = self->priv->sun_rise;
	_tmp4_ = self->priv->sun_set;
	if (clocks_world_item_is_current (self, _tmp3_, _tmp4_)) {
		result = CLOCKS_WORLD_SUN_STATE_DAY;
		return result;
	}
	_tmp5_ = self->priv->civil_rise;
	_tmp6_ = self->priv->civil_set;
	if (clocks_world_item_is_current (self, _tmp5_, _tmp6_)) {
		result = CLOCKS_WORLD_SUN_STATE_CIVIL;
		return result;
	}
	_tmp7_ = self->priv->naut_rise;
	_tmp8_ = self->priv->naut_set;
	if (clocks_world_item_is_current (self, _tmp7_, _tmp8_)) {
		result = CLOCKS_WORLD_SUN_STATE_NAUT;
		return result;
	}
	_tmp9_ = self->priv->astro_rise;
	_tmp10_ = self->priv->astro_set;
	if (clocks_world_item_is_current (self, _tmp9_, _tmp10_)) {
		result = CLOCKS_WORLD_SUN_STATE_ASTRO;
		return result;
	}
	result = CLOCKS_WORLD_SUN_STATE_NIGHT;
	return result;
}

static void
clocks_world_item_real_tick (ClocksWorldItem* self)
{
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GTimeZone* _tmp5_;
	GDateTime* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	GWeatherLocation* _tmp9_;
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = wallclock;
	_tmp2_ = clocks_utils_wall_clock_get_date_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	_g_date_time_unref0 (self->priv->local_time);
	self->priv->local_time = _tmp4_;
	_tmp5_ = self->priv->time_zone;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (wallclock);
		return;
	}
	_tmp6_ = self->priv->local_time;
	_tmp7_ = self->priv->time_zone;
	_tmp8_ = g_date_time_to_timezone (_tmp6_, (GTimeZone*) _tmp7_);
	_g_date_time_unref0 (self->priv->date_time);
	self->priv->date_time = _tmp8_;
	clocks_world_item_calculate_riseset (self);
	_tmp9_ = self->priv->_location;
	if (gweather_location_has_coords (_tmp9_)) {
		GWeatherLocation* _tmp10_;
		GObject* _tmp11_;
		GObject* _tmp12_;
		_tmp10_ = self->priv->_location;
		_tmp11_ = g_object_new (gweather_info_get_type (), "location", _tmp10_, "enabled-providers", GWEATHER_PROVIDER_NONE, NULL);
		_tmp12_ = G_IS_INITIALLY_UNOWNED (_tmp11_) ? g_object_ref_sink (_tmp11_) : _tmp11_;
		_g_object_unref0 (self->priv->weather_info);
		self->priv->weather_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gweather_info_get_type (), GWeatherInfo);
	}
	g_object_notify ((GObject*) self, "sunrise-label");
	g_object_notify ((GObject*) self, "sunset-label");
	g_object_notify ((GObject*) self, "time-label");
	g_object_notify ((GObject*) self, "time-label-seconds");
	g_object_notify ((GObject*) self, "day-label");
	g_object_notify ((GObject*) self, "local-offset");
	g_object_notify ((GObject*) self, "sun-state");
	_g_object_unref0 (wallclock);
}

static void
clocks_world_item_class_init (ClocksWorldItemClass * klass,
                              gpointer klass_data)
{
	clocks_world_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksWorldItem_private_offset);
	((ClocksWorldItemClass *) klass)->tick = clocks_world_item_real_tick;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_LOCATION_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", gweather_location_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY] = g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY] = g_param_spec_string ("city-name", "city-name", "city-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY] = g_param_spec_string ("state-name", "state-name", "state-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY] = g_param_spec_string ("country-name", "country-name", "country-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY] = g_param_spec_string ("sunrise-label", "sunrise-label", "sunrise-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY] = g_param_spec_string ("sunset-label", "sunset-label", "sunset-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY] = g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_TIME_LABEL_SECONDS_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_TIME_LABEL_SECONDS_PROPERTY] = g_param_spec_string ("time-label-seconds", "time-label-seconds", "time-label-seconds", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY] = g_param_spec_string ("day-label", "day-label", "day-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_LOCAL_OFFSET_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_LOCAL_OFFSET_PROPERTY] = g_param_spec_int64 ("local-offset", "local-offset", "local-offset", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUN_STATE_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SUN_STATE_PROPERTY] = g_param_spec_enum ("sun-state", "sun-state", "sun-state", CLOCKS_WORLD_TYPE_SUN_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	clocks_world_item_signals[CLOCKS_WORLD_ITEM_TICK_SIGNAL] = g_signal_new ("tick", CLOCKS_WORLD_TYPE_ITEM, G_SIGNAL_RUN_FIRST, G_STRUCT_OFFSET (ClocksWorldItemClass, tick), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
clocks_world_item_clocks_content_item_interface_init (ClocksContentItemIface * iface,
                                                      gpointer iface_data)
{
	clocks_world_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize = (void (*) (ClocksContentItem*, GVariantBuilder*)) clocks_world_item_real_serialize;
	iface->get_name = clocks_world_item_real_get_name;
	iface->set_name = clocks_world_item_real_set_name;
}

static void
clocks_world_item_instance_init (ClocksWorldItem * self,
                                 gpointer klass)
{
	self->priv = clocks_world_item_get_instance_private (self);
	self->priv->_automatic = FALSE;
	self->priv->last_calc_day = -1;
}

static void
clocks_world_item_finalize (GObject * obj)
{
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	_g_object_unref0 (self->priv->_location);
	_g_free0 (self->priv->_name);
	_g_time_zone_unref0 (self->priv->time_zone);
	_g_date_time_unref0 (self->priv->local_time);
	_g_date_time_unref0 (self->priv->date_time);
	_g_object_unref0 (self->priv->weather_info);
	_g_date_time_unref0 (self->priv->sun_rise);
	_g_date_time_unref0 (self->priv->sun_set);
	_g_date_time_unref0 (self->priv->civil_rise);
	_g_date_time_unref0 (self->priv->civil_set);
	_g_date_time_unref0 (self->priv->naut_rise);
	_g_date_time_unref0 (self->priv->naut_set);
	_g_date_time_unref0 (self->priv->astro_rise);
	_g_date_time_unref0 (self->priv->astro_set);
	G_OBJECT_CLASS (clocks_world_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_world_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldItem), 0, (GInstanceInitFunc) clocks_world_item_instance_init, NULL };
	static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_world_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_world_item_type_id;
	clocks_world_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksWorldItem", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_world_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
	ClocksWorldItem_private_offset = g_type_add_instance_private (clocks_world_item_type_id, sizeof (ClocksWorldItemPrivate));
	return clocks_world_item_type_id;
}

GType
clocks_world_item_get_type (void)
{
	static gsize clocks_world_item_type_id__once = 0;
	if (g_once_init_enter (&clocks_world_item_type_id__once)) {
		GType clocks_world_item_type_id;
		clocks_world_item_type_id = clocks_world_item_get_type_once ();
		g_once_init_leave (&clocks_world_item_type_id__once, clocks_world_item_type_id);
	}
	return clocks_world_item_type_id__once;
}

static void
_vala_clocks_world_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION_PROPERTY:
		g_value_set_object (value, clocks_world_item_get_location (self));
		break;
		case CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY:
		g_value_set_boolean (value, clocks_world_item_get_automatic (self));
		break;
		case CLOCKS_WORLD_ITEM_NAME_PROPERTY:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_city_name (self));
		break;
		case CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_state_name (self));
		break;
		case CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_country_name (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_sunrise_label (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_sunset_label (self));
		break;
		case CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_time_label (self));
		break;
		case CLOCKS_WORLD_ITEM_TIME_LABEL_SECONDS_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_time_label_seconds (self));
		break;
		case CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY:
		g_value_set_string (value, clocks_world_item_get_day_label (self));
		break;
		case CLOCKS_WORLD_ITEM_LOCAL_OFFSET_PROPERTY:
		g_value_set_int64 (value, clocks_world_item_get_local_offset (self));
		break;
		case CLOCKS_WORLD_ITEM_SUN_STATE_PROPERTY:
		g_value_set_enum (value, clocks_world_item_get_sun_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_world_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION_PROPERTY:
		clocks_world_item_set_location (self, g_value_get_object (value));
		break;
		case CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY:
		clocks_world_item_set_automatic (self, g_value_get_boolean (value));
		break;
		case CLOCKS_WORLD_ITEM_NAME_PROPERTY:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

